/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "interface.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_VOID__STRING_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value G_GNUC_UNUSED,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef void (*_GDbusCodegenMarshalVoid_StringUintUintFunc)
       (void *data1,
        const gchar *arg_device,
        guint arg_control,
        guint arg_value,
        void *data2);
  _GDbusCodegenMarshalVoid_StringUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;

  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalVoid_StringUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  callback (data1,
            g_marshal_value_peek_string (param_values + 1),
            g_marshal_value_peek_uint (param_values + 2),
            g_marshal_value_peek_uint (param_values + 3),
            data2);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_device,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_device,
        guint arg_control,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_UINT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringUintUintFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_device,
        guint arg_control,
        guint arg_value,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringUintUintFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 5);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringUintUintFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_uint (param_values + 3),
              g_marshal_value_peek_uint (param_values + 4),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface ddccontrol.DDCControl
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:DDCControl
 * @title: DDCControl
 * @short_description: Generated C code for the ddccontrol.DDCControl D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-ddccontrol-DDCControl.top_of_page">ddccontrol.DDCControl</link> D-Bus interface in C.
 */

enum
{
  _DDCCONTROL_CONTROL_CHANGED,
};

static unsigned _DDCCONTROL_SIGNALS[1] = { 0 };

/* ---- Introspection data for ddccontrol.DDCControl ---- */

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_monitors_OUT_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_monitors_OUT_ARG_supported =
{
  {
    -1,
    (gchar *) "supported",
    (gchar *) "a(y)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_monitors_OUT_ARG_names =
{
  {
    -1,
    (gchar *) "names",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_monitors_OUT_ARG_digital =
{
  {
    -1,
    (gchar *) "digital",
    (gchar *) "a(y)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_method_info_get_monitors_OUT_ARG_pointers[] =
{
  &_ddccontrol_method_info_get_monitors_OUT_ARG_devices.parent_struct,
  &_ddccontrol_method_info_get_monitors_OUT_ARG_supported.parent_struct,
  &_ddccontrol_method_info_get_monitors_OUT_ARG_names.parent_struct,
  &_ddccontrol_method_info_get_monitors_OUT_ARG_digital.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ddccontrol_method_info_get_monitors =
{
  {
    -1,
    (gchar *) "GetMonitors",
    NULL,
    (GDBusArgInfo **) &_ddccontrol_method_info_get_monitors_OUT_ARG_pointers,
    NULL
  },
  "handle-get-monitors",
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_rescan_monitors_OUT_ARG_devices =
{
  {
    -1,
    (gchar *) "devices",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_rescan_monitors_OUT_ARG_supported =
{
  {
    -1,
    (gchar *) "supported",
    (gchar *) "a(y)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_rescan_monitors_OUT_ARG_names =
{
  {
    -1,
    (gchar *) "names",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_rescan_monitors_OUT_ARG_digital =
{
  {
    -1,
    (gchar *) "digital",
    (gchar *) "a(y)",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_method_info_rescan_monitors_OUT_ARG_pointers[] =
{
  &_ddccontrol_method_info_rescan_monitors_OUT_ARG_devices.parent_struct,
  &_ddccontrol_method_info_rescan_monitors_OUT_ARG_supported.parent_struct,
  &_ddccontrol_method_info_rescan_monitors_OUT_ARG_names.parent_struct,
  &_ddccontrol_method_info_rescan_monitors_OUT_ARG_digital.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ddccontrol_method_info_rescan_monitors =
{
  {
    -1,
    (gchar *) "RescanMonitors",
    NULL,
    (GDBusArgInfo **) &_ddccontrol_method_info_rescan_monitors_OUT_ARG_pointers,
    NULL
  },
  "handle-rescan-monitors",
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_open_monitor_IN_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_method_info_open_monitor_IN_ARG_pointers[] =
{
  &_ddccontrol_method_info_open_monitor_IN_ARG_device.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_open_monitor_OUT_ARG_pnpid =
{
  {
    -1,
    (gchar *) "pnpid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_open_monitor_OUT_ARG_caps =
{
  {
    -1,
    (gchar *) "caps",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_method_info_open_monitor_OUT_ARG_pointers[] =
{
  &_ddccontrol_method_info_open_monitor_OUT_ARG_pnpid.parent_struct,
  &_ddccontrol_method_info_open_monitor_OUT_ARG_caps.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ddccontrol_method_info_open_monitor =
{
  {
    -1,
    (gchar *) "OpenMonitor",
    (GDBusArgInfo **) &_ddccontrol_method_info_open_monitor_IN_ARG_pointers,
    (GDBusArgInfo **) &_ddccontrol_method_info_open_monitor_OUT_ARG_pointers,
    NULL
  },
  "handle-open-monitor",
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_control_IN_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_control_IN_ARG_control =
{
  {
    -1,
    (gchar *) "control",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_method_info_get_control_IN_ARG_pointers[] =
{
  &_ddccontrol_method_info_get_control_IN_ARG_device.parent_struct,
  &_ddccontrol_method_info_get_control_IN_ARG_control.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_control_OUT_ARG_result =
{
  {
    -1,
    (gchar *) "result",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_control_OUT_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_get_control_OUT_ARG_maximum =
{
  {
    -1,
    (gchar *) "maximum",
    (gchar *) "q",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_method_info_get_control_OUT_ARG_pointers[] =
{
  &_ddccontrol_method_info_get_control_OUT_ARG_result.parent_struct,
  &_ddccontrol_method_info_get_control_OUT_ARG_value.parent_struct,
  &_ddccontrol_method_info_get_control_OUT_ARG_maximum.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ddccontrol_method_info_get_control =
{
  {
    -1,
    (gchar *) "GetControl",
    (GDBusArgInfo **) &_ddccontrol_method_info_get_control_IN_ARG_pointers,
    (GDBusArgInfo **) &_ddccontrol_method_info_get_control_OUT_ARG_pointers,
    NULL
  },
  "handle-get-control",
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_set_control_IN_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_set_control_IN_ARG_control =
{
  {
    -1,
    (gchar *) "control",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_method_info_set_control_IN_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_method_info_set_control_IN_ARG_pointers[] =
{
  &_ddccontrol_method_info_set_control_IN_ARG_device.parent_struct,
  &_ddccontrol_method_info_set_control_IN_ARG_control.parent_struct,
  &_ddccontrol_method_info_set_control_IN_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _ddccontrol_method_info_set_control =
{
  {
    -1,
    (gchar *) "SetControl",
    (GDBusArgInfo **) &_ddccontrol_method_info_set_control_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-control",
  FALSE
};

static const GDBusMethodInfo * const _ddccontrol_method_info_pointers[] =
{
  &_ddccontrol_method_info_get_monitors.parent_struct,
  &_ddccontrol_method_info_rescan_monitors.parent_struct,
  &_ddccontrol_method_info_open_monitor.parent_struct,
  &_ddccontrol_method_info_get_control.parent_struct,
  &_ddccontrol_method_info_set_control.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _ddccontrol_signal_info_control_changed_ARG_device =
{
  {
    -1,
    (gchar *) "device",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_signal_info_control_changed_ARG_control =
{
  {
    -1,
    (gchar *) "control",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _ddccontrol_signal_info_control_changed_ARG_value =
{
  {
    -1,
    (gchar *) "value",
    (gchar *) "u",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _ddccontrol_signal_info_control_changed_ARG_pointers[] =
{
  &_ddccontrol_signal_info_control_changed_ARG_device.parent_struct,
  &_ddccontrol_signal_info_control_changed_ARG_control.parent_struct,
  &_ddccontrol_signal_info_control_changed_ARG_value.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _ddccontrol_signal_info_control_changed =
{
  {
    -1,
    (gchar *) "ControlChanged",
    (GDBusArgInfo **) &_ddccontrol_signal_info_control_changed_ARG_pointers,
    NULL
  },
  "control-changed"
};

static const GDBusSignalInfo * const _ddccontrol_signal_info_pointers[] =
{
  &_ddccontrol_signal_info_control_changed.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _ddccontrol_interface_info =
{
  {
    -1,
    (gchar *) "ddccontrol.DDCControl",
    (GDBusMethodInfo **) &_ddccontrol_method_info_pointers,
    (GDBusSignalInfo **) &_ddccontrol_signal_info_pointers,
    NULL,
    NULL
  },
  "ddccontrol",
};


/**
 * ddccontrol_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-ddccontrol-DDCControl.top_of_page">ddccontrol.DDCControl</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
ddccontrol_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_ddccontrol_interface_info.parent_struct;
}

/**
 * ddccontrol_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #DDCControl interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
ddccontrol_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}


inline static void
ddccontrol_signal_marshal_control_changed (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_VOID__STRING_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ddccontrol_method_marshal_get_monitors (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ddccontrol_method_marshal_rescan_monitors (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ddccontrol_method_marshal_open_monitor (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ddccontrol_method_marshal_get_control (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
ddccontrol_method_marshal_set_control (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_UINT_UINT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * DDCControl:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-ddccontrol-DDCControl.top_of_page">ddccontrol.DDCControl</link>.
 */

/**
 * DDCControlIface:
 * @parent_iface: The parent interface.
 * @handle_get_control: Handler for the #DDCControl::handle-get-control signal.
 * @handle_get_monitors: Handler for the #DDCControl::handle-get-monitors signal.
 * @handle_open_monitor: Handler for the #DDCControl::handle-open-monitor signal.
 * @handle_rescan_monitors: Handler for the #DDCControl::handle-rescan-monitors signal.
 * @handle_set_control: Handler for the #DDCControl::handle-set-control signal.
 * @control_changed: Handler for the #DDCControl::control-changed signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-ddccontrol-DDCControl.top_of_page">ddccontrol.DDCControl</link>.
 */

typedef DDCControlIface DDCControlInterface;
G_DEFINE_INTERFACE (DDCControl, ddccontrol, G_TYPE_OBJECT)

static void
ddccontrol_default_init (DDCControlIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * DDCControl::handle-get-monitors:
   * @object: A #DDCControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-ddccontrol-DDCControl.GetMonitors">GetMonitors()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ddccontrol_complete_get_monitors() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-monitors",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DDCControlIface, handle_get_monitors),
    g_signal_accumulator_true_handled,
    NULL,
      ddccontrol_method_marshal_get_monitors,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * DDCControl::handle-rescan-monitors:
   * @object: A #DDCControl.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-ddccontrol-DDCControl.RescanMonitors">RescanMonitors()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ddccontrol_complete_rescan_monitors() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-rescan-monitors",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DDCControlIface, handle_rescan_monitors),
    g_signal_accumulator_true_handled,
    NULL,
      ddccontrol_method_marshal_rescan_monitors,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * DDCControl::handle-open-monitor:
   * @object: A #DDCControl.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_device: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-ddccontrol-DDCControl.OpenMonitor">OpenMonitor()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ddccontrol_complete_open_monitor() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-open-monitor",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DDCControlIface, handle_open_monitor),
    g_signal_accumulator_true_handled,
    NULL,
      ddccontrol_method_marshal_open_monitor,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * DDCControl::handle-get-control:
   * @object: A #DDCControl.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_device: Argument passed by remote caller.
   * @arg_control: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-ddccontrol-DDCControl.GetControl">GetControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ddccontrol_complete_get_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-get-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DDCControlIface, handle_get_control),
    g_signal_accumulator_true_handled,
    NULL,
      ddccontrol_method_marshal_get_control,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT);

  /**
   * DDCControl::handle-set-control:
   * @object: A #DDCControl.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_device: Argument passed by remote caller.
   * @arg_control: Argument passed by remote caller.
   * @arg_value: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-ddccontrol-DDCControl.SetControl">SetControl()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call ddccontrol_complete_set_control() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-control",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (DDCControlIface, handle_set_control),
    g_signal_accumulator_true_handled,
    NULL,
      ddccontrol_method_marshal_set_control,
    G_TYPE_BOOLEAN,
    4,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT);

  /* GObject signals for received D-Bus signals: */
  /**
   * DDCControl::control-changed:
   * @object: A #DDCControl.
   * @arg_device: Argument.
   * @arg_control: Argument.
   * @arg_value: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-ddccontrol-DDCControl.ControlChanged">"ControlChanged"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  _DDCCONTROL_SIGNALS[_DDCCONTROL_CONTROL_CHANGED] =
    g_signal_new ("control-changed",
      G_TYPE_FROM_INTERFACE (iface),
      G_SIGNAL_RUN_LAST,
      G_STRUCT_OFFSET (DDCControlIface, control_changed),
      NULL,
      NULL,
      ddccontrol_signal_marshal_control_changed,
      G_TYPE_NONE,
      3, G_TYPE_STRING, G_TYPE_UINT, G_TYPE_UINT);

}

/**
 * ddccontrol_emit_control_changed:
 * @object: A #DDCControl.
 * @arg_device: Argument to pass with the signal.
 * @arg_control: Argument to pass with the signal.
 * @arg_value: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-ddccontrol-DDCControl.ControlChanged">"ControlChanged"</link> D-Bus signal.
 */
void
ddccontrol_emit_control_changed (
    DDCControl *object,
    const gchar *arg_device,
    guint arg_control,
    guint arg_value)
{
  g_signal_emit (object, _DDCCONTROL_SIGNALS[_DDCCONTROL_CONTROL_CHANGED], 0, arg_device, arg_control, arg_value);
}

/**
 * ddccontrol_call_get_monitors:
 * @proxy: A #DDCControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.GetMonitors">GetMonitors()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ddccontrol_call_get_monitors_finish() to get the result of the operation.
 *
 * See ddccontrol_call_get_monitors_sync() for the synchronous, blocking version of this method.
 */
void
ddccontrol_call_get_monitors (
    DDCControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetMonitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ddccontrol_call_get_monitors_finish:
 * @proxy: A #DDCControlProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_supported: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_names: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_digital: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ddccontrol_call_get_monitors().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ddccontrol_call_get_monitors().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_get_monitors_finish (
    DDCControl *proxy,
    gchar ***out_devices,
    GVariant **out_supported,
    gchar ***out_names,
    GVariant **out_digital,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as@a(y)^as@a(y))",
                 out_devices,
                 out_supported,
                 out_names,
                 out_digital);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_get_monitors_sync:
 * @proxy: A #DDCControlProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_supported: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_names: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_digital: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.GetMonitors">GetMonitors()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ddccontrol_call_get_monitors() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_get_monitors_sync (
    DDCControl *proxy,
    gchar ***out_devices,
    GVariant **out_supported,
    gchar ***out_names,
    GVariant **out_digital,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetMonitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as@a(y)^as@a(y))",
                 out_devices,
                 out_supported,
                 out_names,
                 out_digital);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_rescan_monitors:
 * @proxy: A #DDCControlProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.RescanMonitors">RescanMonitors()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ddccontrol_call_rescan_monitors_finish() to get the result of the operation.
 *
 * See ddccontrol_call_rescan_monitors_sync() for the synchronous, blocking version of this method.
 */
void
ddccontrol_call_rescan_monitors (
    DDCControl *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "RescanMonitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ddccontrol_call_rescan_monitors_finish:
 * @proxy: A #DDCControlProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_supported: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_names: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_digital: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ddccontrol_call_rescan_monitors().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ddccontrol_call_rescan_monitors().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_rescan_monitors_finish (
    DDCControl *proxy,
    gchar ***out_devices,
    GVariant **out_supported,
    gchar ***out_names,
    GVariant **out_digital,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as@a(y)^as@a(y))",
                 out_devices,
                 out_supported,
                 out_names,
                 out_digital);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_rescan_monitors_sync:
 * @proxy: A #DDCControlProxy.
 * @out_devices: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_supported: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_names: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @out_digital: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.RescanMonitors">RescanMonitors()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ddccontrol_call_rescan_monitors() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_rescan_monitors_sync (
    DDCControl *proxy,
    gchar ***out_devices,
    GVariant **out_supported,
    gchar ***out_names,
    GVariant **out_digital,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "RescanMonitors",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(^as@a(y)^as@a(y))",
                 out_devices,
                 out_supported,
                 out_names,
                 out_digital);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_open_monitor:
 * @proxy: A #DDCControlProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.OpenMonitor">OpenMonitor()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ddccontrol_call_open_monitor_finish() to get the result of the operation.
 *
 * See ddccontrol_call_open_monitor_sync() for the synchronous, blocking version of this method.
 */
void
ddccontrol_call_open_monitor (
    DDCControl *proxy,
    const gchar *arg_device,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "OpenMonitor",
    g_variant_new ("(s)",
                   arg_device),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ddccontrol_call_open_monitor_finish:
 * @proxy: A #DDCControlProxy.
 * @out_pnpid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_caps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ddccontrol_call_open_monitor().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ddccontrol_call_open_monitor().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_open_monitor_finish (
    DDCControl *proxy,
    gchar **out_pnpid,
    gchar **out_caps,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_pnpid,
                 out_caps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_open_monitor_sync:
 * @proxy: A #DDCControlProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @out_pnpid: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_caps: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.OpenMonitor">OpenMonitor()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ddccontrol_call_open_monitor() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_open_monitor_sync (
    DDCControl *proxy,
    const gchar *arg_device,
    gchar **out_pnpid,
    gchar **out_caps,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "OpenMonitor",
    g_variant_new ("(s)",
                   arg_device),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(ss)",
                 out_pnpid,
                 out_caps);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_get_control:
 * @proxy: A #DDCControlProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_control: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.GetControl">GetControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ddccontrol_call_get_control_finish() to get the result of the operation.
 *
 * See ddccontrol_call_get_control_sync() for the synchronous, blocking version of this method.
 */
void
ddccontrol_call_get_control (
    DDCControl *proxy,
    const gchar *arg_device,
    guint arg_control,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "GetControl",
    g_variant_new ("(su)",
                   arg_device,
                   arg_control),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ddccontrol_call_get_control_finish:
 * @proxy: A #DDCControlProxy.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_maximum: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ddccontrol_call_get_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ddccontrol_call_get_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_get_control_finish (
    DDCControl *proxy,
    gint *out_result,
    guint16 *out_value,
    guint16 *out_maximum,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iqq)",
                 out_result,
                 out_value,
                 out_maximum);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_get_control_sync:
 * @proxy: A #DDCControlProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_control: Argument to pass with the method invocation.
 * @out_result: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_value: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_maximum: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.GetControl">GetControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ddccontrol_call_get_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_get_control_sync (
    DDCControl *proxy,
    const gchar *arg_device,
    guint arg_control,
    gint *out_result,
    guint16 *out_value,
    guint16 *out_maximum,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "GetControl",
    g_variant_new ("(su)",
                   arg_device,
                   arg_control),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(iqq)",
                 out_result,
                 out_value,
                 out_maximum);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_set_control:
 * @proxy: A #DDCControlProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_control: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.SetControl">SetControl()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ddccontrol_call_set_control_finish() to get the result of the operation.
 *
 * See ddccontrol_call_set_control_sync() for the synchronous, blocking version of this method.
 */
void
ddccontrol_call_set_control (
    DDCControl *proxy,
    const gchar *arg_device,
    guint arg_control,
    guint arg_value,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetControl",
    g_variant_new ("(suu)",
                   arg_device,
                   arg_control,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * ddccontrol_call_set_control_finish:
 * @proxy: A #DDCControlProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ddccontrol_call_set_control().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with ddccontrol_call_set_control().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_set_control_finish (
    DDCControl *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_call_set_control_sync:
 * @proxy: A #DDCControlProxy.
 * @arg_device: Argument to pass with the method invocation.
 * @arg_control: Argument to pass with the method invocation.
 * @arg_value: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-ddccontrol-DDCControl.SetControl">SetControl()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See ddccontrol_call_set_control() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
ddccontrol_call_set_control_sync (
    DDCControl *proxy,
    const gchar *arg_device,
    guint arg_control,
    guint arg_value,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetControl",
    g_variant_new ("(suu)",
                   arg_device,
                   arg_control,
                   arg_value),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * ddccontrol_complete_get_monitors:
 * @object: A #DDCControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @devices: Parameter to return.
 * @supported: Parameter to return.
 * @names: Parameter to return.
 * @digital: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-ddccontrol-DDCControl.GetMonitors">GetMonitors()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ddccontrol_complete_get_monitors (
    DDCControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *devices,
    GVariant *supported,
    const gchar *const *names,
    GVariant *digital)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as@a(y)^as@a(y))",
                   devices,
                   supported,
                   names,
                   digital));
}

/**
 * ddccontrol_complete_rescan_monitors:
 * @object: A #DDCControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @devices: Parameter to return.
 * @supported: Parameter to return.
 * @names: Parameter to return.
 * @digital: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-ddccontrol-DDCControl.RescanMonitors">RescanMonitors()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ddccontrol_complete_rescan_monitors (
    DDCControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *const *devices,
    GVariant *supported,
    const gchar *const *names,
    GVariant *digital)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(^as@a(y)^as@a(y))",
                   devices,
                   supported,
                   names,
                   digital));
}

/**
 * ddccontrol_complete_open_monitor:
 * @object: A #DDCControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @pnpid: Parameter to return.
 * @caps: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-ddccontrol-DDCControl.OpenMonitor">OpenMonitor()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ddccontrol_complete_open_monitor (
    DDCControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    const gchar *pnpid,
    const gchar *caps)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(ss)",
                   pnpid,
                   caps));
}

/**
 * ddccontrol_complete_get_control:
 * @object: A #DDCControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @result: Parameter to return.
 * @value: Parameter to return.
 * @maximum: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-ddccontrol-DDCControl.GetControl">GetControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ddccontrol_complete_get_control (
    DDCControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint result,
    guint16 value,
    guint16 maximum)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(iqq)",
                   result,
                   value,
                   maximum));
}

/**
 * ddccontrol_complete_set_control:
 * @object: A #DDCControl.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-ddccontrol-DDCControl.SetControl">SetControl()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
ddccontrol_complete_set_control (
    DDCControl *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * DDCControlProxy:
 *
 * The #DDCControlProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * DDCControlProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #DDCControlProxy.
 */

struct _DDCControlProxyPrivate
{
  GData *qdata;
};

static void ddccontrol_proxy_iface_init (DDCControlIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (DDCControlProxy, ddccontrol_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (DDCControlProxy)
                         G_IMPLEMENT_INTERFACE (TYPE_DDCCONTROL, ddccontrol_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (DDCControlProxy, ddccontrol_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (TYPE_DDCCONTROL, ddccontrol_proxy_iface_init))

#endif
static void
ddccontrol_proxy_finalize (GObject *object)
{
  DDCControlProxy *proxy = DDCCONTROL_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (ddccontrol_proxy_parent_class)->finalize (object);
}

static void
ddccontrol_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ddccontrol_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
ddccontrol_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_ddccontrol_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], TYPE_DDCCONTROL);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_DDCCONTROL);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
ddccontrol_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  DDCControlProxy *proxy = DDCCONTROL_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ddccontrol_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ddccontrol_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
ddccontrol_proxy_init (DDCControlProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = ddccontrol_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, TYPE_DDCCONTROL_PROXY, DDCControlProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), ddccontrol_interface_info ());
}

static void
ddccontrol_proxy_class_init (DDCControlProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = ddccontrol_proxy_finalize;
  gobject_class->get_property = ddccontrol_proxy_get_property;
  gobject_class->set_property = ddccontrol_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = ddccontrol_proxy_g_signal;
  proxy_class->g_properties_changed = ddccontrol_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (DDCControlProxyPrivate));
#endif
}

static void
ddccontrol_proxy_iface_init (DDCControlIface *iface G_GNUC_UNUSED)
{
}

/**
 * ddccontrol_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-ddccontrol-DDCControl.top_of_page">ddccontrol.DDCControl</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ddccontrol_proxy_new_finish() to get the result of the operation.
 *
 * See ddccontrol_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
ddccontrol_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_DDCCONTROL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "ddccontrol.DDCControl", NULL);
}

/**
 * ddccontrol_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ddccontrol_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ddccontrol_proxy_new().
 *
 * Returns: (transfer full) (type DDCControlProxy): The constructed proxy object or %NULL if @error is set.
 */
DDCControl *
ddccontrol_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return DDCCONTROL (ret);
  else
    return NULL;
}

/**
 * ddccontrol_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-ddccontrol-DDCControl.top_of_page">ddccontrol.DDCControl</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ddccontrol_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type DDCControlProxy): The constructed proxy object or %NULL if @error is set.
 */
DDCControl *
ddccontrol_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_DDCCONTROL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "ddccontrol.DDCControl", NULL);
  if (ret != NULL)
    return DDCCONTROL (ret);
  else
    return NULL;
}


/**
 * ddccontrol_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like ddccontrol_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call ddccontrol_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See ddccontrol_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
ddccontrol_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (TYPE_DDCCONTROL_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "ddccontrol.DDCControl", NULL);
}

/**
 * ddccontrol_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to ddccontrol_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with ddccontrol_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type DDCControlProxy): The constructed proxy object or %NULL if @error is set.
 */
DDCControl *
ddccontrol_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return DDCCONTROL (ret);
  else
    return NULL;
}

/**
 * ddccontrol_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like ddccontrol_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See ddccontrol_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type DDCControlProxy): The constructed proxy object or %NULL if @error is set.
 */
DDCControl *
ddccontrol_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (TYPE_DDCCONTROL_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "ddccontrol.DDCControl", NULL);
  if (ret != NULL)
    return DDCCONTROL (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * DDCControlSkeleton:
 *
 * The #DDCControlSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * DDCControlSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #DDCControlSkeleton.
 */

struct _DDCControlSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_ddccontrol_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  DDCControlSkeleton *skeleton = DDCCONTROL_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], TYPE_DDCCONTROL);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, TYPE_DDCCONTROL);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_ddccontrol_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  DDCControlSkeleton *skeleton = DDCCONTROL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ddccontrol_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_ddccontrol_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  DDCControlSkeleton *skeleton = DDCCONTROL_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_ddccontrol_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _ddccontrol_skeleton_vtable =
{
  _ddccontrol_skeleton_handle_method_call,
  _ddccontrol_skeleton_handle_get_property,
  _ddccontrol_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
ddccontrol_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return ddccontrol_interface_info ();
}

static GDBusInterfaceVTable *
ddccontrol_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_ddccontrol_skeleton_vtable;
}

static GVariant *
ddccontrol_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  DDCControlSkeleton *skeleton = DDCCONTROL_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_ddccontrol_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _ddccontrol_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _ddccontrol_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _ddccontrol_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "ddccontrol.DDCControl", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
ddccontrol_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_ddccontrol_on_signal_control_changed (
    DDCControl *object,
    const gchar *arg_device,
    guint arg_control,
    guint arg_value)
{
  DDCControlSkeleton *skeleton = DDCCONTROL_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(suu)",
                   arg_device,
                   arg_control,
                   arg_value));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "ddccontrol.DDCControl", "ControlChanged",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void ddccontrol_skeleton_iface_init (DDCControlIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (DDCControlSkeleton, ddccontrol_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (DDCControlSkeleton)
                         G_IMPLEMENT_INTERFACE (TYPE_DDCCONTROL, ddccontrol_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (DDCControlSkeleton, ddccontrol_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (TYPE_DDCCONTROL, ddccontrol_skeleton_iface_init))

#endif
static void
ddccontrol_skeleton_finalize (GObject *object)
{
  DDCControlSkeleton *skeleton = DDCCONTROL_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (ddccontrol_skeleton_parent_class)->finalize (object);
}

static void
ddccontrol_skeleton_init (DDCControlSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = ddccontrol_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, TYPE_DDCCONTROL_SKELETON, DDCControlSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
ddccontrol_skeleton_class_init (DDCControlSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = ddccontrol_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = ddccontrol_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = ddccontrol_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = ddccontrol_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = ddccontrol_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (DDCControlSkeletonPrivate));
#endif
}

static void
ddccontrol_skeleton_iface_init (DDCControlIface *iface)
{
  iface->control_changed = _ddccontrol_on_signal_control_changed;
}

/**
 * ddccontrol_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-ddccontrol-DDCControl.top_of_page">ddccontrol.DDCControl</link>.
 *
 * Returns: (transfer full) (type DDCControlSkeleton): The skeleton object.
 */
DDCControl *
ddccontrol_skeleton_new (void)
{
  return DDCCONTROL (g_object_new (TYPE_DDCCONTROL_SKELETON, NULL));
}

