#ifndef GLOBAL_ENUMS_H
#define GLOBAL_ENUMS_H

#include "qobject.h"
#include "qstring.h"

typedef enum {
    DH_MISERABLE = 0,
    DH_VERY_UNHAPPY,
    DH_UNHAPPY,
    DH_FINE,
    DH_CONTENT,
    DH_HAPPY,
    DH_ECSTATIC,
    DH_TOTAL_LEVELS
} DWARF_HAPPINESS;

typedef enum {
    MT_NONE= -1,
    MT_FEY=0,
    MT_SECRET=1,
    MT_POSSESSED=2,
    MT_MACABRE=3,
    MT_FELL=4,
    MT_MELANCHOLY=5,
    MT_INSANE=6,
    MT_BERSERK=7,
    MT_BABY=8,
    MT_TRAUMA=9,
    MT_MARTIAL=10, //appended temporary moods, martial = 0
    MT_ENRAGED=11,
    MT_TANTRUM=12,
    MT_DEPRESSED=13,
    MT_OBLIVIOUS=14
} MOOD_TYPE;

typedef enum {
    AT_NONE = -1,
    AT_STRENGTH = 0,
    AT_AGILITY=1,
    AT_TOUGHNESS=2,
    AT_ENDURANCE=3,
    AT_RECUPERATION=4,
    AT_DISEASE_RESISTANCE=5,
    AT_ANALYTICAL_ABILITY=6,
    AT_FOCUS=7,
    AT_WILLPOWER=8,
    AT_CREATIVITY=9,
    AT_INTUITION=10,
    AT_PATIENCE=11,
    AT_MEMORY=12,
    AT_LINGUISTIC_ABILITY=13,
    AT_SPATIAL_SENSE=14,
    AT_MUSICALITY=15,
    AT_KINESTHETIC_SENSE=16,
    AT_EMPATHY=17,
    AT_SOCIAL_AWARENESS=18
} ATTRIBUTES_TYPE;

typedef enum {
    NONE=-1,
    BAR,
    SMALLGEM,
    BLOCKS,
    ROUGH,
    BOULDER,
    WOOD,
    DOOR,
    FLOODGATE,
    BED,
    CHAIR,
    CHAIN,
    FLASK,
    GOBLET,
    INSTRUMENT,
    TOY,
    WINDOW,
    CAGE,
    BARREL,
    BUCKET,
    ANIMALTRAP,
    TABLE,
    COFFIN,
    STATUE,
    CORPSE,
    WEAPON,
    ARMOR,
    SHOES,
    SHIELD,
    HELM,
    GLOVES,
    BOX,
    BAG,
    BIN,
    ARMORSTAND,
    WEAPONRACK,
    CABINET,
    FIGURINE,
    AMULET,
    SCEPTER,
    AMMO,
    CROWN,
    RING,
    EARRING,
    BRACELET,
    GEM,
    ANVIL,
    CORPSEPIECE,
    REMAINS,
    MEAT,
    FISH,
    FISH_RAW,
    VERMIN,
    IS_PET,
    SEEDS,
    PLANT,
    SKIN_TANNED,
    LEAVES_FRUIT,
    THREAD,
    CLOTH,
    TOTEM,
    PANTS,
    BACKPACK,
    QUIVER,
    CATAPULTPARTS,
    BALLISTAPARTS,
    SIEGEAMMO,
    BALLISTAARROWHEAD,
    TRAPPARTS,
    TRAPCOMP,
    DRINK,
    POWDER_MISC,
    CHEESE,
    FOOD,
    LIQUID_MISC,
    COIN,
    GLOB,
    ROCK,
    PIPE_SECTION,
    HATCH_COVER,
    GRATE,
    QUERN,
    MILLSTONE,
    SPLINT,
    CRUTCH,
    TRACTION_BENCH,
    ORTHOPEDIC_CAST,
    TOOL,
    SLAB,
    EGG,
    BOOK,
    SHEET,
    NUM_OF_ITEM_TYPES,
    //custom flags
    SUPPLIES=999,
    ARTIFACTS=1000,
    MELEE_EQUIPMENT=1001,
    RANGED_EQUIPMENT=1002,
    VIAL=1006,
    WATERSKIN=1007
} ITEM_TYPE;

typedef enum {
    ANY_STATE = -1,
    SOLID = 0,
    LIQUID,
    GAS,
    POWDER,
    PASTE,
    PRESSED,
} MATERIAL_STATES;

typedef enum {
    LIKES_NONE=-1,
    LIKE_MATERIAL=0,
    LIKE_CREATURE=1,
    LIKE_FOOD=2,
    HATE_CREATURE=3,
    LIKE_ITEM=4,
    LIKE_PLANT=5,
    LIKE_TREE=6,
    LIKE_COLOR=7,
    LIKE_SHAPE=8,
    LIKE_POETRY=9,
    LIKE_MUSIC=10,
    LIKE_DANCE=11,
    LIKE_OUTDOORS=99
} PREF_TYPES;

//df-structures material_flags
typedef enum {
    MAT_NONE=-1,
    BONE=0,
    IS_MEAT=1,
    EDIBLE_VERMIN=2,
    EDIBLE_RAW=3,
    EDIBLE_COOKED=4,
    ALCOHOL=5,
    ITEMS_METAL=6,
    ITEMS_BARRED=7,
    ITEMS_SCALED=8,
    ITEMS_LEATHER=9,
    ITEMS_SOFT=10,
    ITEMS_HARD=11,
    IMPLIES_ANIMAL_KILL=12,
    ALCOHOL_PLANT=13,
    ALCOHOL_CREATURE=14,
    CHEESE_PLANT=15,
    CHEESE_CREATURE=16,
    POWDER_MISC_PLANT=17,
    POWDER_MISC_CREATURE=18,
    STOCKPILE_GLOB=19,
    LIQUID_MISC_PLANT=20,
    LIQUID_MISC_CREATURE=21,
    LIQUID_MISC_OTHER=22,
    IS_WOOD=23,
    THREAD_PLANT=24,
    TOOTH=25,
    HORN=26,
    PEARL=27,
    SHELL=28,
    LEATHER=29,
    SILK=30,
    SOAP=31,
    ROTS=32,
    IS_DYE=33,
    IS_POWDER_MISC=34,
    IS_LIQUID_MISC=35,
    STRUCTURAL_PLANT_MAT=36,
    SEED_MAT=37,
    LEAF_MAT=38,
    IS_CHEESE=39,
    ENTERS_BLOOD=40,
    BLOOD_MAP_DESCRIPTOR=41,
    ICHOR_MAP_DESCRIPTOR=42,
    GOO_MAP_DESCRIPTOR=43,
    SLIME_MAP_DESCRIPTOR=44,
    PUS_MAP_DESCRIPTOR=45,
    GENERATES_MIASMA=46,
    IS_METAL=47,
    IS_GEM=48,
    IS_GLASS=49,
    CRYSTAL_GLASSABLE=50,
    ITEMS_WEAPON=51,
    ITEMS_WEAPON_RANGED=52,
    ITEMS_ANVIL=53,
    ITEMS_AMMO=54,
    ITEMS_DIGGER=55,
    ITEMS_ARMOR=56,
    ITEMS_DELICATE=57,
    ITEMS_SIEGE_ENGINE=58,
    ITEMS_QUERN=59,
    IS_STONE=60,
    UNDIGGABLE=61,
    YARN=62,
    STOCKPILE_GLOB_PASTE=63,
    STOCKPILE_GLOB_PRESSED=64,
    DISPLAY_UNGLAZED=65,
    DO_NOT_CLEAN_GLOB=66,
    NO_STONE_STOCKPILE=67,
    STOCKPILE_THREAD_METAL=68,
    NUM_OF_MATERIAL_FLAGS=69
} MATERIAL_FLAGS;

typedef enum{
    WAGON=1,
    VERMIN_FISH=9,
    CAN_LEARN=71,
    HATEABLE=72,
    CAN_SPEAK=89,
    NIGHT_CREATURE=99
} CREATURE_FLAGS;

typedef enum{
    AMPHIBIOUS=0,
    NO_EAT=13,
    NO_DRINK=14,
    NO_SLEEP=15,
    DOMESTIC=16,
    FLIER=19,
    WEB_IMMUNE=25,
    FISHABLE=26,
    IMMOBILE_LAND=27,
    MILKABLE=29,
    NO_FISH=37,
    NO_DIZZINESS=39,
    NO_FEVERS=40,
    NOT_BUTCHERABLE=46,
    TRAINABLE_HUNTING=53,
    PET=54,
    PET_EXOTIC=55,
    NO_EXERT=63,
    NO_PAIN=64,
    EXTRAVISION=65,
    NO_BREATHE=66,
    NO_STUN=67,
    NO_NAUSEA=68,
    PARALYZE_IMMUNE=79,
    GETS_WOUND_INFECTIONS=83,
    TRAINABLE_WAR=88,
    BABY=97,
    CHILD=98,
    CRAZED=161, //werebeasts
    BLOODSUCKER=162, //vampires
    HAS_EXTRACTS=200, //custom past this
    SHEARABLE=201,
    BUTCHERABLE=202, //indicates non-butcherable for convenience
    TRAINABLE=203 //indicates pet, pet exotic, war/hunt trainable
} CASTE_FLAGS;

typedef enum {
    P_SPRING = 0,
    P_SUMMER = 1,
    P_AUTUMN = 2,
    P_WINTER = 3,
    P_SEED = 5,
    P_DRINK = 7,
    P_EXTRACT_BARREL = 8,
    P_EXTRACT_VIAL = 9,
    P_EXTRACT_STILL_VIAL = 10,
    P_THREAD = 12,
    P_MILL = 13,
    P_SAPLING = 77,
    P_TREE =78,
    P_CROP = 200, //custom, indicates it has some season to plant
    P_HAS_EXTRACTS = 201 //indicates thread or extracts all used by processing
} PLANT_FLAGS;

namespace eCurse{
typedef enum {
    NONE = -1,
    VAMPIRE = 0,
    WEREBEAST = 1,
    OTHER = 2
} CURSE_TYPE;

typedef enum {
    OPPOSED_TO_LIFE = 2,
    NOT_LIVING = 4,
    NO_EAT = 65536,
    NO_DRINK = 131072,
    BLOODSUCKER = 268435456
} CURSE_FLAGS1;

typedef enum {
    NO_AGING = 1
} CURSE_FLAGS2;
}

namespace eHealth
{
typedef enum  {
    HI_UNK = -1,
    HI_DIAGNOSIS = 0, //diagnosis and recovery
    HI_BLEEDING = 1,
    HI_BLOOD_LOSS = 2,
    HI_PARALYSIS = 3,
    HI_NUMBNESS = 4,
    HI_FEVER = 5,
    //HI_DIZZY = 6,
    HI_PAIN = 7,
    HI_MOVEMENT = 8,
    HI_TIREDNESS = 9,
    HI_BREATHING = 10,
    HI_THIRST = 11,
    HI_HUNGER = 12,
    HI_SLEEPLESS = 13,
    HI_NAUSEOUS = 14,
    HI_VISION = 15,
    HI_GUTTED = 16,
    HI_STAND = 17,
    HI_GRASP = 18,
    HI_FLY = 19,
    HI_NERVE = 20,
    HI_ARTERY = 21,
    HI_FRACTURE = 22,
    HI_TENDON = 23,
    HI_LIGAMENT = 24,
    HI_SETTING = 25,
    HI_DAMAGE = 26,
    HI_TISSUE = 27,
    HI_SWELLING = 28,
    HI_INFECTION = 29,
    HI_LACERATION = 30,
    HI_SEVERED = 31, //old wounds = missing, fresh = severed
    HI_ROT = 32,
    //    HI_RECOVERY = 33, //combined with diagnosis
    HI_IMMOBILIZATION = 34,
    HI_DRESSING = 35,
    HI_CLEANING = 36,
    HI_SURGERY = 37,
    HI_SUTURES = 38,
    HI_TRACTION = 39,
    HI_CRUTCH = 40,
    HI_OTHER = 41,
    HI_GELDED = 42
} H_INFO;

typedef enum {
    TT_BONE,
    TT_FAT,
    TT_SKIN,
    TT_MUSCLE,
    TT_OTHER
} TISSUE_TYPE;

}

typedef enum {
    CUSTOM_ICON,
    CUSTOM_PROF,
    CUSTOM_SUPER
} CUSTOMIZATION_TYPE;

typedef enum {
    SCR_DEFAULT,
    SCR_PREF, //one or more prefs chosen from the dock
    SCR_PREF_EXP, //explicitly chosen from the filter text search
    SCR_ALL
} FILTER_SCRIPT_TYPE;

typedef enum {
    EM_NONE = -1,
    EM_ACCEPTANCE,
    EM_ADORATION,
    EM_AFFECTION,
    EM_AGITATION,
    EM_AGGRAVATION,
    EM_AGONY,
    EM_ALARM,
    EM_ALIENATION,
    EM_AMAZEMENT,
    EM_AMBIVALENCE,
    EM_AMUSEMENT,
    EM_ANGER,
    EM_EXISTENTIAL_CRISIS,
    EM_ANGUISH,
    EM_ANNOYANCE,
    EM_UNKNOWN_15,
    EM_ANXIETY,
    EM_APATHY,
    EM_UNKNOWN_18,
    EM_AROUSAL,
    EM_ASTONISHMENT,
    EM_UNKNOWN_21,
    EM_AVERSION,
    EM_AWE,
    EM_BITTERNESS,
    EM_BLISS,
    EM_BOREDOM,
    EM_CARING,
    EM_UNKNOWN_28,
    EM_CONFUSION,
    EM_CONTEMPT,
    EM_CONTENTMENT,
    EM_UNKNOWN_32,
    EM_UNKNOWN_33,
    EM_DEFEATED,
    EM_DEJECTION,
    EM_DELIGHT,
    EM_UNKNOWN_37,
    EM_UNKNOWN_38,
    EM_DESPAIR,
    EM_DISAPPOINTMENT,
    EM_DISGUST,
    EM_DISILLUSIONED,
    EM_DISLIKE,
    EM_DISMAY,
    EM_DISPLEASURE,
    EM_DISTRESS,
    EM_DOUBT,
    EM_UNKNOWN_48,
    EM_EAGERNESS,
    EM_UNKNOWN_50,
    EM_ELATION,
    EM_EMBARRASSMENT,
    EM_EMPATHY,
    EM_EMPTINESS,
    EM_ENJOYMENT,
    EM_UNKNOWN_56,
    EM_ENTHUSIASTIC,
    EM_UNKNOWN_58,
    EM_EUPHORIC,
    EM_EXASPERATION,
    EM_EXCITED,
    EM_EXHILARATION,
    EM_EXPECTANT,
    EM_FEAR,
    EM_FEROCITY,
    EM_FONDNESS,
    EM_FREE,
    EM_FRIGHT,
    EM_FRUSTRATION,
    EM_UNKNOWN_70,
    EM_UNKNOWN_71,
    EM_UNKNOWN_72,
    EM_GLEE,
    EM_GLOOM,
    EM_GLUMNESS,
    EM_GRATITUDE,
    EM_UNKNOWN_77,
    EM_GRIEF,
    EM_GRIMSATISFACTION,
    EM_GROUCHINESS,
    EM_GRUMPINESS,
    EM_GUILT,
    EM_HAPPINESS,
    EM_HATRED,
    EM_UNKNOWN_85,
    EM_HOPE,
    EM_HOPELESSNESS,
    EM_HORROR,
    EM_UNKNOWN_89,
    EM_HUMILIATION,
    EM_UNKNOWN_91,
    EM_UNKNOWN_92,
    EM_UNKNOWN_93,
    EM_UNKNOWN_94,
    EM_INSULT,
    EM_INTEREST,
    EM_IRRITATION,
    EM_ISOLATION,
    EM_UNKNOWN_99,
    EM_JOLLINESS,
    EM_JOVIALTY,
    EM_JOY,
    EM_JUBILATION,
    EM_UNKNOWN_104,
    EM_LOATHING,
    EM_LONELINESS,
    EM_UNKNOWN_107,
    EM_LOVE,
    EM_UNKNOWN_109,
    EM_LUST,
    EM_UNKNOWN_111,
    EM_MISERY,
    EM_MORTIFICATION,
    EM_UNKNOWN_114,
    EM_NERVOUSNESS,
    EM_NOSTALGIA,
    EM_OPTIMISM,
    EM_OUTRAGE,
    EM_PANIC,
    EM_PATIENCE,
    EM_PASSION,
    EM_PESSIMISTIC,
    EM_UNKNOWN_123,
    EM_PLEASURE,
    EM_PRIDE,
    EM_RAGE,
    EM_RAPTURE,
    EM_REJECTION,
    EM_RELIEF,
    EM_REGRET,
    EM_REMORSE,
    EM_REPENTANCE,
    EM_RESENTMENT,
    EM_UNKNOWN_134,
    EM_RIGHTEOUSINDIGNATION,
    EM_SADNESS,
    EM_SATISFACTION,
    EM_UNKNOWN_138,
    EM_SELFPITY,
    EM_UNKNOWN_140,
    EM_SERVILE,
    EM_SHAKEN,
    EM_SHAME,
    EM_SHOCK,
    EM_UNKNOWN_145,
    EM_UNKNOWN_146,
    EM_UNKNOWN_147,
    EM_UNKNOWN_148,
    EM_SUSPICION,
    EM_SYMPATHY,
    EM_TENDERNESS,
    EM_UNKNOWN_152,
    EM_TERROR,
    EM_THRILL,
    EM_UNKNOWN_155,
    EM_TRIUMPH,
    EM_UNEASINESS,
    EM_UNHAPPINESS,
    EM_VENGEFULNESS,
    EM_UNKNOWN_160,
    EM_WONDER,
    EM_WORRY,
    EM_WRATH,
    EM_ZEAL,
    EM_UNKNOWN_165,
    EM_UNKNOWN_166,
    EM_UNKNOWN_167,
    EM_RESTLESS,
    EM_ADMIRATION
} EMOTION_TYPE;

typedef enum{
    BT_NONE = -1,
    BT_CHAIR,
    BT_BED,
    BT_TABLE,
    BT_COFFIN,
    BT_FARMPLOT,
    BT_FURNACE,
    BT_TRADEDEPOT,
    BT_SHOP,
    BT_DOOR,
    BT_FLOODGATE,
    BT_BOX,
    BT_WEAPONRACK,
    BT_ARMORSTAND,
    BT_WORKSHOP,
    BT_CABINET,
    BT_STATUE,
    BT_WINDOWGLASS,
    BT_WINDOWGEM,
    BT_WELL,
    BT_BRIDGE,
    BT_ROADDIRT,
    BT_ROADPAVED,
    BT_SIEGEENGINE,
    BT_TRAP,
    BT_ANIMALTRAP,
    BT_SUPPORT,
    BT_ARCHERYTARGET,
    BT_CHAIN,
    BT_CAGE,
    BT_STOCKPILE,
    BT_CIVZONE,
    BT_WEAPON,
    BT_WAGON,
    BT_SCREWPUMP,
    BT_CONSTRUCTION,
    BT_HATCH,
    BT_GRATEWALL,
    BT_GRATEFLOOR,
    BT_BARSVERTICAL,
    BT_BARSFLOOR,
    BT_GEARASSEMBLY,
    BT_AXLEHORIZONTAL,
    BT_AXLEVERTICAL,
    BT_WATERWHEEL,
    BT_WINDMILL,
    BT_TRACTIONBENCH,
    BT_SLAB,
    BT_NEST,
    BT_NESTBOX,
    BT_HIVE,
    BT_ROLLERS
} BUILDING_TYPE;

typedef enum {
    FLAG_UNKNOWN = -1,
    FLAG_DEAD = 1,
    FLAG_IN_MOOD = 2,
    FLAG_HAD_MOOD = 3,
    FLAG_MIGRANT = 7,
    FLAG_INCOMING = 10,
    FLAG_CAGED = 25,
    FLAG_TAME = 26,
    FLAG_KILLED = 39,
    FLAG_BUTCHER = 49,
    FLAG_GHOST = 76,
    FLAG_GELD = 93
} UNIT_FLAGS;

typedef enum {
    GCOL_ACTIVE = 0,
    GCOL_PENDING = 1,
    GCOL_DISABLED = 2
} GLOBAL_COLOR_TYPES;

#endif // GLOBAL_ENUMS_H
