/*
Dwarf Therapist
Copyright (c) 2009 Trey Stout (chmod)

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
#ifndef ITEMWEAPONSUBTYPE_H
#define ITEMWEAPONSUBTYPE_H

#include <QObject>
#include "itemsubtype.h"

class ItemWeaponSubtype : public ItemSubtype {
    Q_OBJECT
public:
    ItemWeaponSubtype(DFInstance *df, VIRTADDR address, QObject *parent = 0);
    ~ItemWeaponSubtype();

    QString group_name() const {return m_group_name;}

    int single_grasp() const {return m_single_grasp_size;}
    int multi_grasp() const {return  m_multi_grasp_size;}
    int melee_skill() const {return m_melee_skill_id;}
    int ranged_skill() const {return m_ranged_skill_id;}

private:
    QString m_group_name;
    int m_single_grasp_size;
    int m_multi_grasp_size;
    QString m_ammo;
    int m_melee_skill_id;
    int m_ranged_skill_id;
};

#endif // ITEMWEAPONSUBTYPE_H
