/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.classfile;

import java.util.List;
import java.util.Map;
import org.jd.core.v1.model.classfile.Field;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.Attribute;

public class ClassFile {
    protected int majorVersion;
    protected int minorVersion;
    protected int accessFlags;
    protected String internalTypeName;
    protected String superTypeName;
    protected String[] interfaceTypeNames;
    protected Field[] fields;
    protected Method[] methods;
    protected Map<String, Attribute> attributes;
    protected ClassFile outerClassFile;
    protected List<ClassFile> innerClassFiles;

    public ClassFile(int majorVersion, int minorVersion, int accessFlags, String internalTypeName, String superTypeName, String[] interfaceTypeNames, Field[] fields, Method[] methods, Map<String, Attribute> attributes) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.accessFlags = accessFlags;
        this.internalTypeName = internalTypeName;
        this.superTypeName = superTypeName;
        this.interfaceTypeNames = interfaceTypeNames;
        this.fields = fields;
        this.methods = methods;
        this.attributes = attributes;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public boolean isEnum() {
        return (this.accessFlags & 0x4000) != 0;
    }

    public boolean isAnnotation() {
        return (this.accessFlags & 0x2000) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isModule() {
        return (this.accessFlags & 0x8000) != 0;
    }

    public boolean isStatic() {
        return (this.accessFlags & 8) != 0;
    }

    public String getInternalTypeName() {
        return this.internalTypeName;
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public String[] getInterfaceTypeNames() {
        return this.interfaceTypeNames;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public <T extends Attribute> T getAttribute(String name) {
        return (T)(this.attributes == null ? null : this.attributes.get(name));
    }

    public ClassFile getOuterClassFile() {
        return this.outerClassFile;
    }

    public void setOuterClassFile(ClassFile outerClassFile) {
        this.outerClassFile = outerClassFile;
    }

    public List<ClassFile> getInnerClassFiles() {
        return this.innerClassFiles;
    }

    public void setInnerClassFiles(List<ClassFile> innerClassFiles) {
        this.innerClassFiles = innerClassFiles;
    }

    public String toString() {
        return "ClassFile{" + this.internalTypeName + "}";
    }
}

