/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javafragment;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.jd.core.v1.model.fragment.FlexibleFragment;
import org.jd.core.v1.model.javafragment.JavaFragment;
import org.jd.core.v1.model.javafragment.JavaFragmentVisitor;
import org.jd.core.v1.util.DefaultList;

public class ImportsFragment
extends FlexibleFragment
implements JavaFragment {
    protected static final ImportCountComparator COUNT_COMPARATOR = new ImportCountComparator();
    protected final HashMap<String, Import> importMap = new HashMap();

    public ImportsFragment(int weight) {
        super(0, -1, -1, weight, "Imports");
    }

    public void addImport(String internalName, String qualifiedName) {
        Import imp = this.importMap.get(internalName);
        if (imp == null) {
            this.importMap.put(internalName, new Import(internalName, qualifiedName));
        } else {
            imp.incCounter();
        }
    }

    public boolean incCounter(String internalName) {
        Import imp = this.importMap.get(internalName);
        if (imp == null) {
            return false;
        }
        imp.incCounter();
        return true;
    }

    public boolean isEmpty() {
        return this.importMap.isEmpty();
    }

    public void initLineCounts() {
        this.initialLineCount = this.lineCount = this.importMap.size();
        this.maximalLineCount = this.lineCount;
    }

    public boolean contains(String internalName) {
        return this.importMap.containsKey(internalName);
    }

    @Override
    public int getLineCount() {
        assert (this.lineCount != -1) : "Call initLineCounts() before";
        return this.lineCount;
    }

    public Collection<Import> getImports() {
        int size;
        int lineCount = this.getLineCount();
        if (lineCount < (size = this.importMap.size())) {
            DefaultList<Import> imports = new DefaultList<Import>(this.importMap.values());
            imports.sort(COUNT_COMPARATOR);
            List subList = imports.subList(lineCount, size);
            for (Import imp0rt : subList) {
                this.importMap.remove(imp0rt.getInternalName());
            }
            subList.clear();
            return imports;
        }
        return this.importMap.values();
    }

    @Override
    public void accept(JavaFragmentVisitor visitor) {
        visitor.visit(this);
    }

    public static class Import {
        protected String internalName;
        protected String qualifiedName;
        protected int counter;

        public Import(String internalName, String qualifiedName) {
            this.internalName = internalName;
            this.qualifiedName = qualifiedName;
            this.counter = 1;
        }

        public String getInternalName() {
            return this.internalName;
        }

        public String getQualifiedName() {
            return this.qualifiedName;
        }

        public int getCounter() {
            return this.counter;
        }

        public void incCounter() {
            ++this.counter;
        }
    }

    protected static class ImportCountComparator
    implements Comparator<Import> {
        protected ImportCountComparator() {
        }

        @Override
        public int compare(Import tr1, Import tr2) {
            return tr2.getCounter() - tr1.getCounter();
        }
    }
}

