/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;

public class IntegerConstantExpression
extends AbstractLineNumberTypeExpression {
    protected int value;

    public IntegerConstantExpression(Type type, int value) {
        super(type);
        this.value = value;
        assert (type.isPrimitiveType());
    }

    public IntegerConstantExpression(int lineNumber, Type type, int value) {
        super(lineNumber, type);
        this.value = value;
        assert (type.isPrimitiveType());
    }

    @Override
    public int getIntegerValue() {
        return this.value;
    }

    @Override
    public void setType(Type type) {
        assert (this.checkType(type)) : "IntegerConstantExpression.setType(type) : incompatible types";
        super.setType(type);
    }

    protected boolean checkType(Type type) {
        if (type.isPrimitiveType()) {
            PrimitiveType valueType = PrimitiveTypeUtil.getPrimitiveTypeFromValue(this.value);
            return (((PrimitiveType)type).getFlags() & valueType.getFlags()) != 0;
        }
        return false;
    }

    @Override
    public boolean isIntegerConstantExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "IntegerConstantExpression{type=" + this.type + ", value=" + this.value + "}";
    }
}

