/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberExpression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;

public class StringConstantExpression
extends AbstractLineNumberExpression {
    public static final StringConstantExpression EMPTY_STRING = new StringConstantExpression("");
    protected String string;

    public StringConstantExpression(String string) {
        this.string = string;
    }

    public StringConstantExpression(int lineNumber, String string) {
        super(lineNumber);
        this.string = string;
    }

    @Override
    public String getStringValue() {
        return this.string;
    }

    @Override
    public Type getType() {
        return ObjectType.TYPE_STRING;
    }

    @Override
    public boolean isStringConstantExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "StringConstantExpression{\"" + this.string + "\"}";
    }
}

