/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.expression;

import org.jd.core.v1.model.javasyntax.expression.AbstractLineNumberTypeExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.type.Type;

public class TernaryOperatorExpression
extends AbstractLineNumberTypeExpression {
    protected Expression condition;
    protected Expression trueExpression;
    protected Expression falseExpression;

    public TernaryOperatorExpression(Type type, Expression condition, Expression trueExpression, Expression falseExpression) {
        super(type);
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    public TernaryOperatorExpression(int lineNumber, Type type, Expression condition, Expression trueExpression, Expression falseExpression) {
        super(lineNumber, type);
        this.condition = condition;
        this.trueExpression = trueExpression;
        this.falseExpression = falseExpression;
    }

    @Override
    public Expression getCondition() {
        return this.condition;
    }

    public void setCondition(Expression condition) {
        this.condition = condition;
    }

    @Override
    public Expression getTrueExpression() {
        return this.trueExpression;
    }

    public void setTrueExpression(Expression trueExpression) {
        this.trueExpression = trueExpression;
    }

    @Override
    public Expression getFalseExpression() {
        return this.falseExpression;
    }

    public void setFalseExpression(Expression falseExpression) {
        this.falseExpression = falseExpression;
    }

    @Override
    public int getPriority() {
        return 15;
    }

    @Override
    public boolean isTernaryOperatorExpression() {
        return true;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return "TernaryOperatorExpression{" + this.condition + " ? " + this.trueExpression + " : " + this.falseExpression + "}";
    }
}

