/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;

public class InnerObjectType
extends ObjectType {
    protected ObjectType outerType;

    public InnerObjectType(String internalName, String qualifiedName, String name, ObjectType outerType) {
        super(internalName, qualifiedName, name);
        this.outerType = outerType;
        assert (name == null || !Character.isDigit(name.charAt(0)) || qualifiedName == null);
    }

    public InnerObjectType(String internalName, String qualifiedName, String name, int dimension, ObjectType outerType) {
        super(internalName, qualifiedName, name, dimension);
        this.outerType = outerType;
        assert (name == null || !Character.isDigit(name.charAt(0)) || qualifiedName == null);
    }

    public InnerObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments, ObjectType outerType) {
        super(internalName, qualifiedName, name, typeArguments);
        this.outerType = outerType;
        assert (name == null || !Character.isDigit(name.charAt(0)) || qualifiedName == null);
    }

    public InnerObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments, int dimension, ObjectType outerType) {
        super(internalName, qualifiedName, name, typeArguments, dimension);
        this.outerType = outerType;
        assert (name == null || !Character.isDigit(name.charAt(0)) || qualifiedName == null);
    }

    public InnerObjectType(InnerObjectType iot) {
        super(iot);
        this.outerType = iot.outerType;
    }

    @Override
    public ObjectType getOuterType() {
        return this.outerType;
    }

    @Override
    public Type createType(int dimension) {
        assert (dimension >= 0);
        return new InnerObjectType(this.internalName, this.qualifiedName, this.name, this.typeArguments, dimension, this.outerType);
    }

    @Override
    public ObjectType createType(BaseTypeArgument typeArguments) {
        return new InnerObjectType(this.internalName, this.qualifiedName, this.name, typeArguments, this.dimension, this.outerType);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof InnerObjectType)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InnerObjectType that = (InnerObjectType)o;
        return this.outerType.equals(that.outerType);
    }

    @Override
    public int hashCode() {
        int result = 111476860 + super.hashCode();
        result = 31 * result + this.outerType.hashCode();
        return result;
    }

    @Override
    public boolean isInnerObjectType() {
        return true;
    }

    @Override
    public boolean isInnerObjectTypeArgument() {
        return true;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(TypeArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        if (this.typeArguments == null) {
            return "InnerObjectType{" + this.outerType.toString() + "." + this.descriptor + "}";
        }
        return "InnerObjectType{" + this.outerType.toString() + "." + this.descriptor + "<" + this.typeArguments + ">}";
    }
}

