/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.model.javasyntax.type;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.TypeVisitor;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;

public class ObjectType
implements Type {
    public static final ObjectType TYPE_BOOLEAN = new ObjectType("java/lang/Boolean", "java.lang.Boolean", "Boolean");
    public static final ObjectType TYPE_BYTE = new ObjectType("java/lang/Byte", "java.lang.Byte", "Byte");
    public static final ObjectType TYPE_CHARACTER = new ObjectType("java/lang/Character", "java.lang.Character", "Character");
    public static final ObjectType TYPE_CLASS = new ObjectType("java/lang/Class", "java.lang.Class", "Class");
    public static final ObjectType TYPE_CLASS_WILDCARD = TYPE_CLASS.createType(WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
    public static final ObjectType TYPE_DOUBLE = new ObjectType("java/lang/Double", "java.lang.Double", "Double");
    public static final ObjectType TYPE_EXCEPTION = new ObjectType("java/lang/Exception", "java.lang.Exception", "Exception");
    public static final ObjectType TYPE_FLOAT = new ObjectType("java/lang/Float", "java.lang.Float", "Float");
    public static final ObjectType TYPE_INTEGER = new ObjectType("java/lang/Integer", "java.lang.Integer", "Integer");
    public static final ObjectType TYPE_ITERABLE = new ObjectType("java/lang/Iterable", "java.lang.Iterable", "Iterable");
    public static final ObjectType TYPE_LONG = new ObjectType("java/lang/Long", "java.lang.Long", "Long");
    public static final ObjectType TYPE_MATH = new ObjectType("java/lang/Math", "java.lang.Math", "Math");
    public static final ObjectType TYPE_OBJECT = new ObjectType("java/lang/Object", "java.lang.Object", "Object");
    public static final ObjectType TYPE_RUNTIME_EXCEPTION = new ObjectType("java/lang/RuntimeException", "java.lang.RuntimeException", "RuntimeException");
    public static final ObjectType TYPE_SHORT = new ObjectType("java/lang/Short", "java.lang.Short", "Short");
    public static final ObjectType TYPE_STRING = new ObjectType("java/lang/String", "java.lang.String", "String");
    public static final ObjectType TYPE_STRING_BUFFER = new ObjectType("java/lang/StringBuffer", "java.lang.StringBuffer", "StringBuffer");
    public static final ObjectType TYPE_STRING_BUILDER = new ObjectType("java/lang/StringBuilder", "java.lang.StringBuilder", "StringBuilder");
    public static final ObjectType TYPE_SYSTEM = new ObjectType("java/lang/System", "java.lang.System", "System");
    public static final ObjectType TYPE_THREAD = new ObjectType("java/lang/Thread", "java.lang.Thread", "Thread");
    public static final ObjectType TYPE_THROWABLE = new ObjectType("java/lang/Throwable", "java.lang.Throwable", "Throwable");
    public static final ObjectType TYPE_PRIMITIVE_BOOLEAN = new ObjectType("Z");
    public static final ObjectType TYPE_PRIMITIVE_BYTE = new ObjectType("B");
    public static final ObjectType TYPE_PRIMITIVE_CHAR = new ObjectType("C");
    public static final ObjectType TYPE_PRIMITIVE_DOUBLE = new ObjectType("D");
    public static final ObjectType TYPE_PRIMITIVE_FLOAT = new ObjectType("F");
    public static final ObjectType TYPE_PRIMITIVE_INT = new ObjectType("I");
    public static final ObjectType TYPE_PRIMITIVE_LONG = new ObjectType("J");
    public static final ObjectType TYPE_PRIMITIVE_SHORT = new ObjectType("S");
    public static final ObjectType TYPE_PRIMITIVE_VOID = new ObjectType("V");
    public static final ObjectType TYPE_UNDEFINED_OBJECT = new ObjectType("java/lang/Object", "java.lang.Object", "Object"){

        @Override
        public String toString() {
            return "UndefinedObjectType";
        }
    };
    protected String internalName;
    protected String qualifiedName;
    protected String name;
    protected BaseTypeArgument typeArguments;
    protected int dimension;
    protected String descriptor;

    public ObjectType(String internalName, String qualifiedName, String name) {
        this(internalName, qualifiedName, name, null, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name, int dimension) {
        this(internalName, qualifiedName, name, null, dimension);
    }

    public ObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments) {
        this(internalName, qualifiedName, name, typeArguments, 0);
    }

    public ObjectType(String internalName, String qualifiedName, String name, BaseTypeArgument typeArguments, int dimension) {
        this.internalName = internalName;
        this.qualifiedName = qualifiedName;
        this.name = name;
        this.typeArguments = typeArguments;
        this.dimension = dimension;
        this.descriptor = ObjectType.createDescriptor("L" + internalName + ';', dimension);
        assert (internalName != null && !internalName.endsWith(";"));
    }

    public ObjectType(String primitiveDescriptor) {
        this(primitiveDescriptor, 0);
    }

    public ObjectType(String primitiveDescriptor, int dimension) {
        this.internalName = primitiveDescriptor;
        this.qualifiedName = this.name = PrimitiveType.getPrimitiveType(primitiveDescriptor.charAt(0)).getName();
        this.dimension = dimension;
        this.descriptor = ObjectType.createDescriptor(primitiveDescriptor, dimension);
    }

    protected static String createDescriptor(String descriptor, int dimension) {
        switch (dimension) {
            case 0: {
                return descriptor;
            }
            case 1: {
                return "[" + descriptor;
            }
            case 2: {
                return "[[" + descriptor;
            }
        }
        return new String(new char[dimension]).replaceAll("\u0000", "[") + descriptor;
    }

    public ObjectType(ObjectType ot) {
        this.internalName = ot.getInternalName();
        this.qualifiedName = ot.getQualifiedName();
        this.name = ot.getName();
        this.typeArguments = ot.getTypeArguments();
        this.dimension = ot.getDimension();
        this.descriptor = ot.getDescriptor();
    }

    @Override
    public String getInternalName() {
        return this.internalName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BaseTypeArgument getTypeArguments() {
        return this.typeArguments;
    }

    @Override
    public String getDescriptor() {
        return this.descriptor;
    }

    @Override
    public int getDimension() {
        return this.dimension;
    }

    @Override
    public Type createType(int dimension) {
        assert (dimension >= 0) : "ObjectType.createType(dim) : create type with negative dimension";
        if (this.dimension == dimension) {
            return this;
        }
        if (this.descriptor.charAt(this.descriptor.length() - 1) != ';') {
            if (dimension == 0) {
                return PrimitiveType.getPrimitiveType(this.descriptor.charAt(this.dimension));
            }
            return new ObjectType(this.internalName, dimension);
        }
        return new ObjectType(this.internalName, this.qualifiedName, this.name, this.typeArguments, dimension);
    }

    public ObjectType createType(BaseTypeArgument typeArguments) {
        if (this.typeArguments == typeArguments) {
            return this;
        }
        return new ObjectType(this.internalName, this.qualifiedName, this.name, typeArguments, this.dimension);
    }

    public boolean rawEquals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        return this.internalName.equals(that.internalName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectType that = (ObjectType)o;
        if (this.dimension != that.dimension) {
            return false;
        }
        if (!this.internalName.equals(that.internalName)) {
            return false;
        }
        if ("java/lang/Class".equals(this.internalName)) {
            boolean wildcard2;
            boolean wildcard1 = this.typeArguments == null || this.typeArguments.getClass() == WildcardTypeArgument.class;
            boolean bl = wildcard2 = that.typeArguments == null || that.typeArguments.getClass() == WildcardTypeArgument.class;
            if (wildcard1 && wildcard2) {
                return true;
            }
        }
        return this.typeArguments != null ? this.typeArguments.equals(that.typeArguments) : that.typeArguments == null;
    }

    public int hashCode() {
        int result = 735485092 + this.internalName.hashCode();
        result = 31 * result + (this.typeArguments != null ? this.typeArguments.hashCode() : 0);
        result = 31 * result + this.dimension;
        return result;
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(TypeArgumentVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public boolean isTypeArgumentAssignableFrom(Map<String, BaseType> typeBounds, BaseTypeArgument typeArgument) {
        GenericType gt;
        BaseType bt;
        Class<?> typeArgumentClass = typeArgument.getClass();
        if (typeArgumentClass == ObjectType.class || typeArgumentClass == InnerObjectType.class) {
            ObjectType ot = (ObjectType)typeArgument;
            if (this.dimension != ot.getDimension() || !this.internalName.equals(ot.getInternalName())) {
                return false;
            }
            if (ot.getTypeArguments() == null) {
                return this.typeArguments == null;
            }
            if (this.typeArguments == null) {
                return false;
            }
            return this.typeArguments.isTypeArgumentAssignableFrom(typeBounds, ot.getTypeArguments());
        }
        if (typeArgumentClass == GenericType.class && (bt = typeBounds.get((gt = (GenericType)typeArgument).getName())) != null) {
            for (Type type : bt) {
                ObjectType ot;
                Class<?> typeClass;
                if (this.dimension != type.getDimension() || (typeClass = type.getClass()) != ObjectType.class && typeClass != InnerObjectType.class || !this.internalName.equals((ot = (ObjectType)type).getInternalName())) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTypeArgumentAssignableFrom(Map<String, BaseType> typeBounds, ObjectType objectType) {
        if (this.dimension != objectType.getDimension() || !this.internalName.equals(objectType.getInternalName())) {
            return false;
        }
        if (objectType.getTypeArguments() == null) {
            return this.typeArguments == null;
        }
        if (this.typeArguments == null) {
            return false;
        }
        return this.typeArguments.isTypeArgumentAssignableFrom(typeBounds, objectType.getTypeArguments());
    }

    @Override
    public boolean isObjectType() {
        return true;
    }

    @Override
    public boolean isObjectTypeArgument() {
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ObjectType{");
        sb.append(this.internalName);
        if (this.typeArguments != null) {
            sb.append('<').append(this.typeArguments).append('>');
        }
        if (this.dimension > 0) {
            sb.append(", dimension=").append(this.dimension);
        }
        return sb.append('}').toString();
    }
}

