/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import java.util.HashSet;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.Frame;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableReference;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableVisitor;
import org.jd.core.v1.util.DefaultList;

public abstract class AbstractLocalVariable {
    protected Frame frame;
    protected AbstractLocalVariable next;
    protected boolean declared;
    protected int index;
    protected int fromOffset;
    protected int toOffset;
    protected String name;
    protected DefaultList<LocalVariableReference> references = new DefaultList();
    protected HashSet<AbstractLocalVariable> variablesOnRight = null;
    protected HashSet<AbstractLocalVariable> variablesOnLeft = null;

    public AbstractLocalVariable(int index, int offset, String name) {
        this(index, offset, name, offset == 0);
    }

    public AbstractLocalVariable(int index, int offset, String name, boolean declared) {
        this.declared = declared;
        this.index = index;
        this.fromOffset = offset;
        this.toOffset = offset;
        this.name = name;
    }

    public Frame getFrame() {
        return this.frame;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    public AbstractLocalVariable getNext() {
        return this.next;
    }

    public void setNext(AbstractLocalVariable next) {
        this.next = next;
    }

    public boolean isDeclared() {
        return this.declared;
    }

    public void setDeclared(boolean declared) {
        this.declared = declared;
    }

    public int getIndex() {
        return this.index;
    }

    public int getFromOffset() {
        return this.fromOffset;
    }

    public void setFromOffset(int fromOffset) {
        assert (fromOffset <= this.toOffset);
        this.fromOffset = fromOffset;
    }

    public int getToOffset() {
        return this.toOffset;
    }

    public void setToOffset(int offset) {
        if (this.fromOffset > offset) {
            this.fromOffset = offset;
        }
        if (this.toOffset < offset) {
            this.toOffset = offset;
        }
    }

    public void setToOffset(int offset, boolean force) {
        this.toOffset = offset;
    }

    public abstract Type getType();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract int getDimension();

    public abstract void accept(LocalVariableVisitor var1);

    public DefaultList<LocalVariableReference> getReferences() {
        return this.references;
    }

    public void addReference(LocalVariableReference reference) {
        this.references.add(reference);
    }

    public abstract boolean isAssignableFrom(Map<String, BaseType> var1, Type var2);

    public abstract void typeOnRight(Map<String, BaseType> var1, Type var2);

    public abstract void typeOnLeft(Map<String, BaseType> var1, Type var2);

    public abstract boolean isAssignableFrom(Map<String, BaseType> var1, AbstractLocalVariable var2);

    public abstract void variableOnRight(Map<String, BaseType> var1, AbstractLocalVariable var2);

    public abstract void variableOnLeft(Map<String, BaseType> var1, AbstractLocalVariable var2);

    protected void fireChangeEvent(Map<String, BaseType> typeBounds) {
        if (this.variablesOnLeft != null) {
            for (AbstractLocalVariable v : this.variablesOnLeft) {
                v.variableOnRight(typeBounds, this);
            }
        }
        if (this.variablesOnRight != null) {
            for (AbstractLocalVariable v : this.variablesOnRight) {
                v.variableOnLeft(typeBounds, this);
            }
        }
    }

    protected void addVariableOnLeft(AbstractLocalVariable variable) {
        if (this.variablesOnLeft == null) {
            this.variablesOnLeft = new HashSet();
            this.variablesOnLeft.add(variable);
            variable.addVariableOnRight(this);
        } else if (!this.variablesOnLeft.contains(variable)) {
            this.variablesOnLeft.add(variable);
            variable.addVariableOnRight(this);
        }
    }

    protected void addVariableOnRight(AbstractLocalVariable variable) {
        if (this.variablesOnRight == null) {
            this.variablesOnRight = new HashSet();
            this.variablesOnRight.add(variable);
            variable.addVariableOnLeft(this);
        } else if (!this.variablesOnRight.contains(variable)) {
            this.variablesOnRight.add(variable);
            variable.addVariableOnLeft(this);
        }
    }

    public boolean isPrimitiveLocalVariable() {
        return false;
    }
}

