/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class ObjectLocalVariable
extends AbstractLocalVariable {
    protected TypeMaker typeMaker;
    protected Type type;

    public ObjectLocalVariable(TypeMaker typeMaker, int index, int offset, Type type, String name) {
        super(index, offset, name);
        this.typeMaker = typeMaker;
        this.type = type;
    }

    public ObjectLocalVariable(TypeMaker typeMaker, int index, int offset, Type type, String name, boolean declared) {
        this(typeMaker, index, offset, type, name);
        this.declared = declared;
    }

    public ObjectLocalVariable(TypeMaker typeMaker, int index, int offset, ObjectLocalVariable objectLocalVariable) {
        super(index, offset, null);
        this.typeMaker = typeMaker;
        this.type = objectLocalVariable.type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setType(Map<String, BaseType> typeBounds, Type type) {
        if (!this.type.equals(type)) {
            this.type = type;
            this.fireChangeEvent(typeBounds);
        }
    }

    @Override
    public int getDimension() {
        return this.type.getDimension();
    }

    @Override
    public void accept(LocalVariableVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectLocalVariable{");
        if (this.type.getName() == null) {
            sb.append(this.type.getInternalName());
        } else {
            sb.append(this.type.getName());
        }
        if (this.type.getDimension() > 0) {
            sb.append(new String(new char[this.type.getDimension()]).replaceAll("\u0000", "[]"));
        }
        sb.append(' ').append(this.name).append(", index=").append(this.index);
        if (this.next != null) {
            sb.append(", next=").append(this.next);
        }
        return sb.append("}").toString();
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, Type type) {
        if (this.type.isObjectType()) {
            if (this.type.equals(ObjectType.TYPE_OBJECT) && (type.getDimension() > 0 || !type.isPrimitiveType())) {
                return true;
            }
            if (type.isObjectType()) {
                return this.typeMaker.isAssignable(typeBounds, (ObjectType)this.type, (ObjectType)type);
            }
        }
        return false;
    }

    @Override
    public void typeOnRight(Map<String, BaseType> typeBounds, Type type) {
        if (type != ObjectType.TYPE_UNDEFINED_OBJECT) {
            if (this.type == ObjectType.TYPE_UNDEFINED_OBJECT) {
                this.type = type;
                this.fireChangeEvent(typeBounds);
            } else if (this.type.getDimension() == 0 && type.getDimension() == 0) {
                assert (!this.type.isPrimitiveType() && !type.isPrimitiveType()) : "ObjectLocalVariable.typeOnRight(type) : unexpected type";
                if (this.type.isObjectType()) {
                    ObjectType thisObjectType = (ObjectType)this.type;
                    if (type.isObjectType()) {
                        ObjectType otherObjectType = (ObjectType)type;
                        if (thisObjectType.getInternalName().equals(otherObjectType.getInternalName())) {
                            if (thisObjectType.getTypeArguments() == null && otherObjectType.getTypeArguments() != null) {
                                this.type = otherObjectType;
                                this.fireChangeEvent(typeBounds);
                            }
                        } else if (this.typeMaker.isAssignable(typeBounds, thisObjectType, otherObjectType) && thisObjectType.getTypeArguments() == null && otherObjectType.getTypeArguments() != null) {
                            this.type = thisObjectType.createType(otherObjectType.getTypeArguments());
                            this.fireChangeEvent(typeBounds);
                        }
                    }
                } else if (this.type.isGenericType() && type.isGenericType()) {
                    this.type = type;
                    this.fireChangeEvent(typeBounds);
                }
            }
        }
    }

    @Override
    public void typeOnLeft(Map<String, BaseType> typeBounds, Type type) {
        if (type != ObjectType.TYPE_UNDEFINED_OBJECT && !type.equals(ObjectType.TYPE_OBJECT)) {
            if (this.type == ObjectType.TYPE_UNDEFINED_OBJECT) {
                this.type = type;
                this.fireChangeEvent(typeBounds);
            } else if (this.type.getDimension() == 0 && type.getDimension() == 0 && this.type.isObjectType() && type.isObjectType()) {
                ObjectType thisObjectType = (ObjectType)this.type;
                ObjectType otherObjectType = (ObjectType)type;
                if (thisObjectType.getInternalName().equals(otherObjectType.getInternalName())) {
                    if (thisObjectType.getTypeArguments() == null && otherObjectType.getTypeArguments() != null) {
                        this.type = otherObjectType;
                        this.fireChangeEvent(typeBounds);
                    }
                } else if (this.typeMaker.isAssignable(typeBounds, otherObjectType, thisObjectType) && thisObjectType.getTypeArguments() == null && otherObjectType.getTypeArguments() != null) {
                    this.type = thisObjectType.createType(otherObjectType.getTypeArguments());
                    this.fireChangeEvent(typeBounds);
                }
            }
        }
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        return this.isAssignableFrom(typeBounds, variable.getType());
    }

    @Override
    public void variableOnRight(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        this.addVariableOnRight(variable);
        this.typeOnRight(typeBounds, variable.getType());
    }

    @Override
    public void variableOnLeft(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        this.addVariableOnLeft(variable);
        this.typeOnLeft(typeBounds, variable.getType());
    }
}

