/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.LocalVariableVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.PrimitiveTypeUtil;

public class PrimitiveLocalVariable
extends AbstractLocalVariable {
    protected int flags;

    public PrimitiveLocalVariable(int index, int offset, PrimitiveType type, String name) {
        super(index, offset, name);
        this.flags = type.getFlags();
    }

    public PrimitiveLocalVariable(int index, int offset, PrimitiveLocalVariable primitiveLocalVariable) {
        super(index, offset, null);
        int valueFlags = primitiveLocalVariable.flags;
        this.flags = (valueFlags & 0x40) != 0 ? valueFlags : ((valueFlags & 0x20) != 0 ? valueFlags | 0x40 : ((valueFlags & 2) != 0 ? valueFlags | 0x40 | 0x20 : ((valueFlags & 0x10) != 0 ? valueFlags | 0x40 | 0x20 : valueFlags)));
    }

    @Override
    public Type getType() {
        switch (this.flags) {
            case 1: {
                return PrimitiveType.TYPE_BOOLEAN;
            }
            case 2: {
                return PrimitiveType.TYPE_CHAR;
            }
            case 4: {
                return PrimitiveType.TYPE_FLOAT;
            }
            case 8: {
                return PrimitiveType.TYPE_DOUBLE;
            }
            case 16: {
                return PrimitiveType.TYPE_BYTE;
            }
            case 32: {
                return PrimitiveType.TYPE_SHORT;
            }
            case 64: {
                return PrimitiveType.TYPE_INT;
            }
            case 128: {
                return PrimitiveType.TYPE_LONG;
            }
            case 256: {
                return PrimitiveType.TYPE_VOID;
            }
        }
        if (this.flags == 66) {
            return PrimitiveType.MAYBE_CHAR_TYPE;
        }
        if (this.flags == 98) {
            return PrimitiveType.MAYBE_SHORT_TYPE;
        }
        if (this.flags == 114) {
            return PrimitiveType.MAYBE_BYTE_TYPE;
        }
        if (this.flags == 115) {
            return PrimitiveType.MAYBE_BOOLEAN_TYPE;
        }
        if (this.flags == 112) {
            return PrimitiveType.MAYBE_NEGATIVE_BYTE_TYPE;
        }
        if (this.flags == 96) {
            return PrimitiveType.MAYBE_NEGATIVE_SHORT_TYPE;
        }
        if (this.flags == 113) {
            return PrimitiveType.MAYBE_NEGATIVE_BOOLEAN_TYPE;
        }
        return PrimitiveType.TYPE_INT;
    }

    @Override
    public int getDimension() {
        return 0;
    }

    public void setType(PrimitiveType type) {
        this.flags = type.getFlags();
    }

    @Override
    public void accept(LocalVariableVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PrimitiveLocalVariable{");
        if ((this.flags & 1) != 0) {
            sb.append("boolean ");
        }
        if ((this.flags & 2) != 0) {
            sb.append("char ");
        }
        if ((this.flags & 4) != 0) {
            sb.append("float ");
        }
        if ((this.flags & 8) != 0) {
            sb.append("double ");
        }
        if ((this.flags & 0x10) != 0) {
            sb.append("byte ");
        }
        if ((this.flags & 0x20) != 0) {
            sb.append("short ");
        }
        if ((this.flags & 0x40) != 0) {
            sb.append("int ");
        }
        if ((this.flags & 0x80) != 0) {
            sb.append("long ");
        }
        if ((this.flags & 0x100) != 0) {
            sb.append("void ");
        }
        sb.append(this.name).append(", index=").append(this.index);
        if (this.next != null) {
            sb.append(", next=").append(this.next);
        }
        return sb.append("}").toString();
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, Type type) {
        if (type.getDimension() == 0 && type.isPrimitiveType()) {
            return (this.flags & ((PrimitiveType)type).getRightFlags()) != 0;
        }
        return false;
    }

    @Override
    public void typeOnRight(Map<String, BaseType> typeBounds, Type type) {
        if (type.isPrimitiveType()) {
            assert (type.getDimension() == 0);
            int f = ((PrimitiveType)type).getRightFlags();
            if ((this.flags & f) != 0) {
                int old = this.flags;
                this.flags &= f;
                if (old != this.flags) {
                    this.fireChangeEvent(typeBounds);
                }
            }
        }
    }

    @Override
    public void typeOnLeft(Map<String, BaseType> typeBounds, Type type) {
        if (type.isPrimitiveType()) {
            assert (type.getDimension() == 0);
            int f = ((PrimitiveType)type).getLeftFlags();
            if ((this.flags & f) != 0) {
                int old = this.flags;
                this.flags &= f;
                if (old != this.flags) {
                    this.fireChangeEvent(typeBounds);
                }
            }
        }
    }

    @Override
    public boolean isAssignableFrom(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        if (variable.isPrimitiveLocalVariable()) {
            int variableFlags = ((PrimitiveLocalVariable)variable).flags;
            PrimitiveType type = PrimitiveTypeUtil.getPrimitiveTypeFromFlags(variableFlags);
            if (type != null) {
                variableFlags = type.getRightFlags();
            }
            return (this.flags & variableFlags) != 0;
        }
        return false;
    }

    @Override
    public void variableOnRight(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        assert (variable.getDimension() == 0);
        this.addVariableOnRight(variable);
        int old = this.flags;
        int variableFlags = ((PrimitiveLocalVariable)variable).flags;
        PrimitiveType type = PrimitiveTypeUtil.getPrimitiveTypeFromFlags(variableFlags);
        if (type != null) {
            variableFlags = type.getRightFlags();
        }
        this.flags &= variableFlags;
        assert (this.flags != 0) : "PrimitiveLocalVariable.variableOnRight(var) : flags = 0 after type reduction";
        if (old != this.flags) {
            this.fireChangeEvent(typeBounds);
        }
    }

    @Override
    public void variableOnLeft(Map<String, BaseType> typeBounds, AbstractLocalVariable variable) {
        assert (variable.getDimension() == 0);
        this.addVariableOnLeft(variable);
        int old = this.flags;
        int variableFlags = ((PrimitiveLocalVariable)variable).flags;
        PrimitiveType type = PrimitiveTypeUtil.getPrimitiveTypeFromFlags(variableFlags);
        if (type != null) {
            variableFlags = type.getLeftFlags();
        }
        this.flags &= variableFlags;
        assert (this.flags != 0) : "PrimitiveLocalVariable.variableOnLeft(var) : flags = 0 after type reduction";
        if (old != this.flags) {
            this.fireChangeEvent(typeBounds);
        }
    }

    @Override
    public boolean isPrimitiveLocalVariable() {
        return true;
    }
}

