/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import org.jd.core.v1.model.classfile.ConstantPool;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.constant.ConstantMemberRef;
import org.jd.core.v1.model.classfile.constant.ConstantNameAndType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.cfg.BasicBlock;

public class ByteCodeUtil {
    public static int searchNextOpcode(BasicBlock basicBlock, int maxOffset) {
        byte[] code = ((AttributeCode)basicBlock.getControlFlowGraph().getMethod().getAttribute("Code")).getCode();
        int offset = basicBlock.getFromOffset();
        int toOffset = basicBlock.getToOffset();
        if (toOffset > maxOffset) {
            toOffset = maxOffset;
        }
        while (offset < toOffset) {
            int opcode = code[offset] & 0xFF;
            switch (opcode) {
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: 
                case 188: {
                    ++offset;
                    break;
                }
                case 17: 
                case 19: 
                case 20: 
                case 132: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 198: 
                case 199: {
                    int deltaOffset = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 2 - 1;
                    break;
                }
                case 200: {
                    int deltaOffset = (code[++offset] & 0xFF) << 24 | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 4 - 1;
                    break;
                }
                case 168: {
                    offset += 2;
                    break;
                }
                case 197: {
                    offset += 3;
                    break;
                }
                case 185: 
                case 186: {
                    offset += 4;
                    break;
                }
                case 201: {
                    offset += 4;
                    break;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    break;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    break;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    if (opcode == 132) {
                        offset += 4;
                        break;
                    }
                    offset += 2;
                }
            }
            ++offset;
        }
        if (offset <= maxOffset) {
            return code[offset] & 0xFF;
        }
        return 0;
    }

    public static int getLastOpcode(BasicBlock basicBlock) {
        int toOffset;
        byte[] code = ((AttributeCode)basicBlock.getControlFlowGraph().getMethod().getAttribute("Code")).getCode();
        int offset = basicBlock.getFromOffset();
        if (offset >= (toOffset = basicBlock.getToOffset())) {
            return 0;
        }
        int lastOffset = offset;
        while (offset < toOffset) {
            int opcode = code[offset] & 0xFF;
            lastOffset = offset++;
            switch (opcode) {
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: 
                case 188: {
                    break;
                }
                case 17: 
                case 19: 
                case 20: 
                case 132: 
                case 178: 
                case 179: 
                case 180: 
                case 181: 
                case 182: 
                case 183: 
                case 184: 
                case 187: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 167: 
                case 198: 
                case 199: {
                    int deltaOffset = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 2 - 1;
                    break;
                }
                case 200: {
                    int deltaOffset = (code[++offset] & 0xFF) << 24 | (code[++offset] & 0xFF) << 16 | (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    if (deltaOffset <= 0) break;
                    offset += deltaOffset - 4 - 1;
                    break;
                }
                case 168: {
                    offset += 2;
                    break;
                }
                case 197: {
                    offset += 3;
                    break;
                }
                case 185: 
                case 186: {
                    offset += 4;
                    break;
                }
                case 201: {
                    offset += 4;
                    break;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    break;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    break;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    if (opcode == 132) {
                        offset += 4;
                        break;
                    }
                    offset += 2;
                }
            }
            ++offset;
        }
        return code[lastOffset] & 0xFF;
    }

    public static int evalStackDepth(BasicBlock bb) {
        Method method = bb.getControlFlowGraph().getMethod();
        ConstantPool constants = method.getConstants();
        AttributeCode attributeCode = (AttributeCode)method.getAttribute("Code");
        byte[] code = attributeCode.getCode();
        return ByteCodeUtil.evalStackDepth(constants, code, bb);
    }

    public static int evalStackDepth(ConstantPool constants, byte[] code, BasicBlock bb) {
        int depth = 0;
        int toOffset = bb.getToOffset();
        block28: for (int offset = bb.getFromOffset(); offset < toOffset; ++offset) {
            int opcode = code[offset] & 0xFF;
            switch (opcode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 89: 
                case 90: 
                case 91: {
                    ++depth;
                    continue block28;
                }
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    ++offset;
                    ++depth;
                    continue block28;
                }
                case 17: 
                case 19: 
                case 20: 
                case 168: 
                case 178: 
                case 187: {
                    offset += 2;
                    ++depth;
                    continue block28;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 87: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 194: 
                case 195: {
                    --depth;
                    continue block28;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 179: 
                case 198: 
                case 199: {
                    offset += 2;
                    --depth;
                    continue block28;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    ++offset;
                    --depth;
                    continue block28;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    depth -= 3;
                    continue block28;
                }
                case 92: 
                case 93: 
                case 94: {
                    depth += 2;
                    continue block28;
                }
                case 132: 
                case 167: 
                case 180: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    continue block28;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 181: {
                    offset += 2;
                    depth -= 2;
                    continue block28;
                }
                case 88: {
                    depth -= 2;
                    continue block28;
                }
                case 169: 
                case 188: {
                    ++offset;
                    continue block28;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    --depth;
                    continue block28;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    --depth;
                    continue block28;
                }
                case 182: 
                case 183: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= 1 + ByteCodeUtil.countMethodParameters(descriptor);
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 184: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= ByteCodeUtil.countMethodParameters(descriptor);
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 185: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= 1 + ByteCodeUtil.countMethodParameters(descriptor);
                    offset += 2;
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 186: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    depth -= ByteCodeUtil.countMethodParameters(descriptor);
                    offset += 2;
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block28;
                    ++depth;
                    continue block28;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    if (opcode == 132) {
                        offset += 4;
                        continue block28;
                    }
                    offset += 2;
                    switch (opcode) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            ++depth;
                            continue block28;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            --depth;
                            continue block28;
                        }
                    }
                    continue block28;
                }
                case 197: {
                    depth += 1 - (code[offset += 3] & 0xFF);
                    continue block28;
                }
                case 201: {
                    offset += 4;
                    ++depth;
                }
                case 200: {
                    offset += 4;
                }
            }
        }
        return depth;
    }

    public static int getMinDepth(BasicBlock bb) {
        Method method = bb.getControlFlowGraph().getMethod();
        ConstantPool constants = method.getConstants();
        AttributeCode attributeCode = (AttributeCode)method.getAttribute("Code");
        byte[] code = attributeCode.getCode();
        return ByteCodeUtil.getMinDepth(constants, code, bb);
    }

    private static int getMinDepth(ConstantPool constants, byte[] code, BasicBlock bb) {
        int depth = 0;
        int minDepth = 0;
        int toOffset = bb.getToOffset();
        block36: for (int offset = bb.getFromOffset(); offset < toOffset; ++offset) {
            int opcode = code[offset] & 0xFF;
            switch (opcode) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    ++depth;
                    continue block36;
                }
                case 89: {
                    if (minDepth > --depth) {
                        minDepth = depth;
                    }
                    depth += 2;
                    continue block36;
                }
                case 90: {
                    if (minDepth > (depth -= 2)) {
                        minDepth = depth;
                    }
                    depth += 3;
                    continue block36;
                }
                case 91: {
                    if (minDepth > (depth -= 3)) {
                        minDepth = depth;
                    }
                    depth += 4;
                    continue block36;
                }
                case 16: 
                case 18: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    ++offset;
                    ++depth;
                    continue block36;
                }
                case 17: 
                case 19: 
                case 20: 
                case 168: 
                case 178: 
                case 187: {
                    offset += 2;
                    ++depth;
                    continue block36;
                }
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: 
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    if (minDepth > (depth -= 2)) {
                        minDepth = depth;
                    }
                    ++depth;
                    continue block36;
                }
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 72: 
                case 73: 
                case 74: 
                case 75: 
                case 76: 
                case 77: 
                case 78: 
                case 87: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 194: 
                case 195: {
                    if (minDepth <= --depth) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 179: 
                case 198: 
                case 199: {
                    offset += 2;
                    if (minDepth <= --depth) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: {
                    ++offset;
                    if (minDepth <= --depth) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    if (minDepth <= (depth -= 3)) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 92: {
                    if (minDepth > (depth -= 2)) {
                        minDepth = depth;
                    }
                    depth += 4;
                    continue block36;
                }
                case 93: {
                    if (minDepth > (depth -= 3)) {
                        minDepth = depth;
                    }
                    depth += 5;
                    continue block36;
                }
                case 94: {
                    if (minDepth > (depth -= 4)) {
                        minDepth = depth;
                    }
                    depth += 6;
                    continue block36;
                }
                case 132: 
                case 167: {
                    offset += 2;
                    continue block36;
                }
                case 180: 
                case 189: 
                case 192: 
                case 193: {
                    offset += 2;
                    if (minDepth > --depth) {
                        minDepth = depth;
                    }
                    ++depth;
                    continue block36;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 181: {
                    offset += 2;
                    if (minDepth <= (depth -= 2)) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 88: {
                    if (minDepth <= (depth -= 2)) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 169: {
                    ++offset;
                    continue block36;
                }
                case 188: {
                    ++offset;
                    if (minDepth > --depth) {
                        minDepth = depth;
                    }
                    ++depth;
                    continue block36;
                }
                case 170: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int low = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    int high = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 4 * (high - low + 1) - 1;
                    if (minDepth <= --depth) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 171: {
                    offset = offset + 4 & 0xFFFC;
                    offset += 4;
                    int count = (code[offset++] & 0xFF) << 24 | (code[offset++] & 0xFF) << 16 | (code[offset++] & 0xFF) << 8 | code[offset++] & 0xFF;
                    offset += 8 * count - 1;
                    if (minDepth <= --depth) continue block36;
                    minDepth = depth;
                    continue block36;
                }
                case 182: 
                case 183: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    if (minDepth > (depth -= 1 + ByteCodeUtil.countMethodParameters(descriptor))) {
                        minDepth = depth;
                    }
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block36;
                    ++depth;
                    continue block36;
                }
                case 184: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    if (minDepth > (depth -= ByteCodeUtil.countMethodParameters(descriptor))) {
                        minDepth = depth;
                    }
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block36;
                    ++depth;
                    continue block36;
                }
                case 185: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    if (minDepth > (depth -= 1 + ByteCodeUtil.countMethodParameters(descriptor))) {
                        minDepth = depth;
                    }
                    offset += 2;
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block36;
                    ++depth;
                    continue block36;
                }
                case 186: {
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant((code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF);
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    if (minDepth > (depth -= ByteCodeUtil.countMethodParameters(descriptor))) {
                        minDepth = depth;
                    }
                    offset += 2;
                    if (descriptor.charAt(descriptor.length() - 1) == 'V') continue block36;
                    ++depth;
                    continue block36;
                }
                case 196: {
                    opcode = code[++offset] & 0xFF;
                    if (opcode == 132) {
                        offset += 4;
                        continue block36;
                    }
                    offset += 2;
                    switch (opcode) {
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            ++depth;
                            break;
                        }
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: 
                        case 58: {
                            if (minDepth <= --depth) break;
                            minDepth = depth;
                            break;
                        }
                    }
                    continue block36;
                }
                case 197: {
                    if (minDepth > (depth -= code[offset += 3] & 0xFF)) {
                        minDepth = depth;
                    }
                    ++depth;
                    continue block36;
                }
                case 201: {
                    offset += 4;
                    ++depth;
                }
                case 200: {
                    offset += 4;
                }
            }
        }
        return minDepth;
    }

    private static int countMethodParameters(String descriptor) {
        int count = 0;
        int i = 2;
        char c = descriptor.charAt(1);
        assert (descriptor.length() > 2 && descriptor.charAt(0) == '(');
        while (c != ')') {
            while (c == '[') {
                c = descriptor.charAt(i++);
            }
            if (c == 'L') {
                while ((c = descriptor.charAt(i++)) != ';') {
                }
            }
            c = descriptor.charAt(i++);
            ++count;
        }
        return count;
    }
}

