/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jd.core.v1.model.javasyntax.expression.AbstractNopExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.ArrayExpression;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.BooleanExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.CommentExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.ExpressionVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expressions;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.InstanceOfExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaFormalParametersExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LengthExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewArray;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NoExpression;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.ParenthesesExpression;
import org.jd.core.v1.model.javasyntax.expression.PostOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.PreOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.StringConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorOrMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.AbstractTypeParametersToTypeArgumentsBinder;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BaseTypeToTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BindTypeParametersToNonWildcardTypeArgumentsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BindTypesToTypesVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.GetTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBindingsWithTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.PopulateBindingsWithTypeParameterVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchInTypeArgumentVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.TypeArgumentToTypeVisitor;

public class Java5TypeParametersToTypeArgumentsBinder
extends AbstractTypeParametersToTypeArgumentsBinder
implements ExpressionVisitor {
    protected static final RemoveNonWildcardTypeArgumentsVisitor REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR = new RemoveNonWildcardTypeArgumentsVisitor();
    protected PopulateBindingsWithTypeParameterVisitor populateBindingsWithTypeParameterVisitor = new PopulateBindingsWithTypeParameterVisitor();
    protected BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
    protected SearchInTypeArgumentVisitor searchInTypeArgumentVisitor = new SearchInTypeArgumentVisitor();
    protected TypeArgumentToTypeVisitor typeArgumentToTypeVisitor = new TypeArgumentToTypeVisitor();
    protected BaseTypeToTypeArgumentVisitor baseTypeToTypeArgumentVisitor = new BaseTypeToTypeArgumentVisitor();
    protected GetTypeArgumentVisitor getTypeArgumentVisitor = new GetTypeArgumentVisitor();
    protected BindTypeParametersToNonWildcardTypeArgumentsVisitor bindTypeParametersToNonWildcardTypeArgumentsVisitor = new BindTypeParametersToNonWildcardTypeArgumentsVisitor();
    protected TypeMaker typeMaker;
    protected String internalTypeName;
    protected boolean staticMethod;
    protected PopulateBindingsWithTypeArgumentVisitor populateBindingsWithTypeArgumentVisitor;
    protected Map<String, TypeArgument> contextualBindings;
    protected Map<String, BaseType> contextualTypeBounds;
    protected Type type;

    public Java5TypeParametersToTypeArgumentsBinder(TypeMaker typeMaker, String internalTypeName, ClassFileConstructorOrMethodDeclaration comd) {
        this.typeMaker = typeMaker;
        this.internalTypeName = internalTypeName;
        this.staticMethod = (comd.getFlags() & 8) != 0;
        this.populateBindingsWithTypeArgumentVisitor = new PopulateBindingsWithTypeArgumentVisitor(typeMaker);
        this.contextualBindings = comd.getBindings();
        this.contextualTypeBounds = comd.getTypeBounds();
    }

    @Override
    public ClassFileConstructorInvocationExpression newConstructorInvocationExpression(int lineNumber, ObjectType objectType, String descriptor, TypeMaker.MethodTypes methodTypes, BaseExpression parameters) {
        HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
        BaseType parameterTypes = Java5TypeParametersToTypeArgumentsBinder.clone(methodTypes.parameterTypes);
        BaseTypeParameter methodTypeParameters = methodTypes.typeParameters;
        this.populateBindings(bindings, null, null, null, methodTypeParameters, ObjectType.TYPE_OBJECT, null, null, null);
        parameterTypes = this.bind(bindings, parameterTypes);
        this.bindParameters(parameterTypes, parameters);
        return new ClassFileConstructorInvocationExpression(lineNumber, objectType, descriptor, parameterTypes, parameters);
    }

    @Override
    public ClassFileSuperConstructorInvocationExpression newSuperConstructorInvocationExpression(int lineNumber, ObjectType objectType, String descriptor, TypeMaker.MethodTypes methodTypes, BaseExpression parameters) {
        TypeMaker.TypeTypes superTypeTypes;
        BaseType parameterTypes = Java5TypeParametersToTypeArgumentsBinder.clone(methodTypes.parameterTypes);
        Map<String, TypeArgument> bindings = this.contextualBindings;
        TypeMaker.TypeTypes typeTypes = this.typeMaker.makeTypeTypes(this.internalTypeName);
        if (typeTypes != null && typeTypes.superType != null && typeTypes.superType.getTypeArguments() != null && (superTypeTypes = this.typeMaker.makeTypeTypes(objectType.getInternalName())) != null) {
            bindings = new HashMap<String, TypeArgument>();
            BaseTypeParameter typeParameters = superTypeTypes.typeParameters;
            BaseTypeArgument typeArguments = typeTypes.superType.getTypeArguments();
            BaseTypeParameter methodTypeParameters = methodTypes.typeParameters;
            this.populateBindings(bindings, null, typeParameters, typeArguments, methodTypeParameters, ObjectType.TYPE_OBJECT, null, null, null);
        }
        parameterTypes = this.bind(bindings, parameterTypes);
        this.bindParameters(parameterTypes, parameters);
        return new ClassFileSuperConstructorInvocationExpression(lineNumber, objectType, descriptor, parameterTypes, parameters);
    }

    @Override
    public ClassFileMethodInvocationExpression newMethodInvocationExpression(int lineNumber, Expression expression, ObjectType objectType, String name, String descriptor, TypeMaker.MethodTypes methodTypes, BaseExpression parameters) {
        return new ClassFileMethodInvocationExpression(lineNumber, methodTypes.typeParameters, methodTypes.returnedType, expression, objectType.getInternalName(), name, descriptor, Java5TypeParametersToTypeArgumentsBinder.clone(methodTypes.parameterTypes), parameters);
    }

    @Override
    public FieldReferenceExpression newFieldReferenceExpression(int lineNumber, Type type, Expression expression, ObjectType objectType, String name, String descriptor) {
        Type expressionType = expression.getType();
        if (expressionType.isObjectType()) {
            ObjectType ot;
            ObjectType expressionObjectType = (ObjectType)expressionType;
            if ((this.staticMethod || !expressionObjectType.getInternalName().equals(this.internalTypeName)) && type.isObjectType() && (ot = (ObjectType)type).getTypeArguments() != null) {
                TypeMaker.TypeTypes typeTypes = this.typeMaker.makeTypeTypes(expressionObjectType.getInternalName());
                if (typeTypes == null) {
                    type = (Type)this.bind(this.contextualBindings, type);
                } else {
                    HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
                    BaseTypeParameter typeParameters = typeTypes.typeParameters;
                    BaseTypeArgument typeArguments = expressionObjectType.getTypeArguments();
                    boolean partialBinding = this.populateBindings(bindings, expression, typeParameters, typeArguments, null, ObjectType.TYPE_OBJECT, null, null, null);
                    if (!partialBinding) {
                        type = (Type)this.bind(bindings, type);
                    }
                }
            }
        }
        return new FieldReferenceExpression(lineNumber, type, expression, objectType.getInternalName(), name, descriptor);
    }

    @Override
    public void bindParameterTypesWithArgumentTypes(Type type, Expression expression) {
        this.type = type;
        expression.accept(this);
        expression.accept(REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR);
    }

    protected Type checkTypeArguments(Type type, AbstractLocalVariable localVariable) {
        ObjectType localVariableObjectType;
        TypeMaker.TypeTypes typeTypes;
        Type localVariableType;
        ObjectType objectType;
        if (type.isObjectType() && (objectType = (ObjectType)type).getTypeArguments() != null && (localVariableType = localVariable.getType()).isObjectType() && (typeTypes = this.typeMaker.makeTypeTypes((localVariableObjectType = (ObjectType)localVariableType).getInternalName())) != null && typeTypes.typeParameters == null) {
            type = ((ObjectType)type).createType(null);
        }
        return type;
    }

    protected void bindParameters(BaseType parameterTypes, BaseExpression parameters) {
        if (parameterTypes != null) {
            if (parameterTypes.isList() && parameters.isList()) {
                Iterator parameterTypesIterator = parameterTypes.iterator();
                for (Expression parameter : parameters) {
                    this.type = (Type)parameterTypesIterator.next();
                    parameter.accept(this);
                    parameter.accept(REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR);
                }
            } else {
                Expression parameter = (Expression)parameters.getFirst();
                this.type = (Type)parameterTypes.getFirst();
                parameter.accept(this);
                parameter.accept(REMOVE_NON_WILDCARD_TYPE_ARGUMENTS_VISITOR);
            }
        }
    }

    protected boolean populateBindings(Map<String, TypeArgument> bindings, Expression expression, BaseTypeParameter typeParameters, BaseTypeArgument typeArguments, BaseTypeParameter methodTypeParameters, Type returnType, Type returnExpressionType, BaseType parameterTypes, BaseExpression parameters) {
        boolean bindingsContainsNull;
        block17: {
            boolean statik;
            HashMap<String, BaseType> typeBounds = new HashMap<String, BaseType>();
            boolean bl = statik = expression != null && expression.isObjectTypeReferenceExpression();
            if (!statik) {
                bindings.putAll(this.contextualBindings);
                if (typeParameters != null) {
                    this.populateBindingsWithTypeParameterVisitor.init(bindings, typeBounds);
                    typeParameters.accept(this.populateBindingsWithTypeParameterVisitor);
                    if (typeArguments != null) {
                        if (typeParameters.isList() && typeArguments.isTypeArgumentList()) {
                            Iterator iteratorTypeParameter = typeParameters.iterator();
                            Iterator iteratorTypeArgument = typeArguments.getTypeArgumentList().iterator();
                            while (iteratorTypeParameter.hasNext()) {
                                bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iteratorTypeArgument.next());
                            }
                        } else {
                            bindings.put(((TypeParameter)typeParameters.getFirst()).getIdentifier(), typeArguments.getTypeArgumentFirst());
                        }
                    }
                }
            }
            if (methodTypeParameters != null) {
                this.populateBindingsWithTypeParameterVisitor.init(bindings, typeBounds);
                methodTypeParameters.accept(this.populateBindingsWithTypeParameterVisitor);
            }
            if (!ObjectType.TYPE_OBJECT.equals(returnType) && returnExpressionType != null) {
                this.populateBindingsWithTypeArgumentVisitor.init(this.contextualTypeBounds, bindings, typeBounds, returnType);
                returnExpressionType.accept(this.populateBindingsWithTypeArgumentVisitor);
            }
            if (parameterTypes != null) {
                if (parameterTypes.isList() && parameters.isList()) {
                    Iterator parameterTypesIterator = parameterTypes.iterator();
                    Iterator parametersIterator = parameters.iterator();
                    while (parametersIterator.hasNext()) {
                        this.populateBindingsWithTypeArgument(bindings, typeBounds, (Type)parameterTypesIterator.next(), (Expression)parametersIterator.next());
                    }
                } else {
                    this.populateBindingsWithTypeArgument(bindings, typeBounds, (Type)parameterTypes.getFirst(), (Expression)parameters.getFirst());
                }
            }
            if (!(bindingsContainsNull = bindings.containsValue(null))) break block17;
            if (this.eraseTypeArguments(expression, typeParameters, typeArguments)) {
                for (Map.Entry<String, TypeArgument> entry : bindings.entrySet()) {
                    entry.setValue(null);
                }
            } else {
                for (Map.Entry<String, TypeArgument> entry : bindings.entrySet()) {
                    if (entry.getValue() != null) continue;
                    BaseType baseType = (BaseType)typeBounds.get(entry.getKey());
                    if (baseType == null) {
                        entry.setValue(WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT);
                        continue;
                    }
                    this.bindTypesToTypesVisitor.setBindings(bindings);
                    this.bindTypesToTypesVisitor.init();
                    baseType.accept(this.bindTypesToTypesVisitor);
                    baseType = this.bindTypesToTypesVisitor.getType();
                    this.baseTypeToTypeArgumentVisitor.init();
                    baseType.accept(this.baseTypeToTypeArgumentVisitor);
                    entry.setValue(this.baseTypeToTypeArgumentVisitor.getTypeArgument());
                }
            }
        }
        return bindingsContainsNull;
    }

    protected boolean eraseTypeArguments(Expression expression, BaseTypeParameter typeParameters, BaseTypeArgument typeArguments) {
        if (typeParameters != null && typeArguments == null && expression != null) {
            if (expression.isCastExpression()) {
                expression = expression.getExpression();
            }
            if (expression.isFieldReferenceExpression() || expression.isMethodInvocationExpression() || expression.isLocalVariableReferenceExpression()) {
                return true;
            }
        }
        return false;
    }

    protected void populateBindingsWithTypeArgument(Map<String, TypeArgument> bindings, Map<String, BaseType> typeBounds, Type type, Expression expression) {
        Type t = this.getExpressionType(expression);
        if (t != null && t != ObjectType.TYPE_UNDEFINED_OBJECT) {
            this.populateBindingsWithTypeArgumentVisitor.init(this.contextualTypeBounds, bindings, typeBounds, t);
            type.accept(this.populateBindingsWithTypeArgumentVisitor);
        }
    }

    protected BaseType bind(Map<String, TypeArgument> bindings, BaseType parameterTypes) {
        if (parameterTypes != null && !bindings.isEmpty()) {
            this.bindTypesToTypesVisitor.setBindings(bindings);
            this.bindTypesToTypesVisitor.init();
            parameterTypes.accept(this.bindTypesToTypesVisitor);
            parameterTypes = this.bindTypesToTypesVisitor.getType();
        }
        return parameterTypes;
    }

    protected Type getExpressionType(Expression expression) {
        if (expression.isMethodInvocationExpression()) {
            return this.getExpressionType((ClassFileMethodInvocationExpression)expression);
        }
        if (expression.isNewExpression()) {
            return this.getExpressionType((ClassFileNewExpression)expression);
        }
        return expression.getType();
    }

    protected Type getExpressionType(ClassFileMethodInvocationExpression mie) {
        TypeMaker.TypeTypes typeTypes;
        Type t = mie.getType();
        this.searchInTypeArgumentVisitor.init();
        t.accept(this.searchInTypeArgumentVisitor);
        if (!this.searchInTypeArgumentVisitor.containsGeneric()) {
            return t;
        }
        if (mie.getTypeParameters() != null) {
            return null;
        }
        if ((this.staticMethod || !mie.getInternalTypeName().equals(this.internalTypeName)) && (typeTypes = this.typeMaker.makeTypeTypes(mie.getInternalTypeName())) != null && typeTypes.typeParameters != null) {
            return null;
        }
        return t;
    }

    protected Type getExpressionType(ClassFileNewExpression ne) {
        TypeMaker.TypeTypes typeTypes;
        ObjectType ot = ne.getObjectType();
        if ((this.staticMethod || !ot.getInternalName().equals(this.internalTypeName)) && (typeTypes = this.typeMaker.makeTypeTypes(ot.getInternalName())) != null && typeTypes.typeParameters != null) {
            return null;
        }
        return ot;
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        ClassFileMethodInvocationExpression mie = (ClassFileMethodInvocationExpression)expression;
        if (!mie.isBound()) {
            TypeMaker.TypeTypes typeTypes;
            BaseType parameterTypes = mie.getParameterTypes();
            BaseExpression parameters = mie.getParameters();
            Expression exp = mie.getExpression();
            Type expressionType = exp.getType();
            if ((this.staticMethod || mie.getTypeParameters() != null || !mie.getInternalTypeName().equals(this.internalTypeName)) && (typeTypes = this.typeMaker.makeTypeTypes(mie.getInternalTypeName())) != null) {
                ObjectType mieTypeObjectType;
                ObjectType objectType;
                Type t;
                BaseTypeArgument typeArguments;
                BaseTypeParameter typeParameters = typeTypes.typeParameters;
                BaseTypeParameter methodTypeParameters = mie.getTypeParameters();
                if (exp.isSuperExpression()) {
                    typeTypes = this.typeMaker.makeTypeTypes(this.internalTypeName);
                    typeArguments = typeTypes == null || typeTypes.superType == null ? null : typeTypes.superType.getTypeArguments();
                } else if (exp.isMethodInvocationExpression()) {
                    t = this.getExpressionType((ClassFileMethodInvocationExpression)exp);
                    typeArguments = t != null && t.isObjectType() ? ((ObjectType)t).getTypeArguments() : null;
                } else if (expressionType.isGenericType()) {
                    BaseType typeBound = this.contextualTypeBounds.get(expressionType.getName());
                    if (typeBound != null) {
                        this.getTypeArgumentVisitor.init();
                        typeBound.accept(this.getTypeArgumentVisitor);
                        typeArguments = this.getTypeArgumentVisitor.getTypeArguments();
                    } else {
                        typeArguments = null;
                    }
                } else {
                    typeArguments = ((ObjectType)expressionType).getTypeArguments();
                }
                t = mie.getType();
                if (this.type.isObjectType() && t.isObjectType() && (t = this.typeMaker.searchSuperParameterizedType(objectType = (ObjectType)this.type, mieTypeObjectType = (ObjectType)t)) == null) {
                    t = mie.getType();
                }
                HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
                boolean partialBinding = this.populateBindings(bindings, exp, typeParameters, typeArguments, methodTypeParameters, this.type, t, parameterTypes, parameters);
                parameterTypes = this.bind(bindings, parameterTypes);
                mie.setParameterTypes(parameterTypes);
                mie.setType((Type)this.bind(bindings, mie.getType()));
                if (methodTypeParameters != null && !partialBinding) {
                    this.bindTypeParametersToNonWildcardTypeArgumentsVisitor.init(bindings);
                    methodTypeParameters.accept(this.bindTypeParametersToNonWildcardTypeArgumentsVisitor);
                    mie.setNonWildcardTypeArguments(this.bindTypeParametersToNonWildcardTypeArgumentsVisitor.getTypeArgument());
                }
                if (expressionType.isObjectType()) {
                    ObjectType expressionObjectType = (ObjectType)expressionType;
                    if (bindings.isEmpty() || partialBinding) {
                        expressionType = expressionObjectType.createType(null);
                    } else if (exp.isObjectTypeReferenceExpression() || typeParameters == null) {
                        expressionType = expressionObjectType.createType(null);
                    } else if (typeParameters.isList()) {
                        TypeArguments tas = new TypeArguments(typeParameters.size());
                        for (TypeParameter typeParameter : typeParameters) {
                            tas.add((TypeArgument)bindings.get(typeParameter.getIdentifier()));
                        }
                        expressionType = expressionObjectType.createType(tas);
                    } else {
                        expressionType = expressionObjectType.createType((BaseTypeArgument)bindings.get(((TypeParameter)typeParameters.getFirst()).getIdentifier()));
                    }
                } else if (expressionType.isGenericType()) {
                    if (bindings.isEmpty() || partialBinding) {
                        expressionType = ObjectType.TYPE_OBJECT;
                    } else {
                        TypeArgument typeArgument = (TypeArgument)bindings.get(expressionType.getName());
                        if (typeArgument == null) {
                            expressionType = ObjectType.TYPE_OBJECT;
                        } else {
                            this.typeArgumentToTypeVisitor.init();
                            typeArgument.accept(this.typeArgumentToTypeVisitor);
                            expressionType = this.typeArgumentToTypeVisitor.getType();
                        }
                    }
                }
            }
            this.type = expressionType;
            exp.accept(this);
            this.bindParameters(parameterTypes, parameters);
            mie.setBound(true);
        }
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
        AbstractLocalVariable localVariable = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        if (localVariable.getFromOffset() > 0) {
            localVariable.typeOnLeft(this.contextualTypeBounds, this.checkTypeArguments(this.type, localVariable));
        }
    }

    @Override
    public void visit(NewExpression expression) {
        ClassFileNewExpression ne = (ClassFileNewExpression)expression;
        if (!ne.isBound()) {
            TypeMaker.TypeTypes typeTypes;
            BaseType parameterTypes = ne.getParameterTypes();
            BaseExpression parameters = ne.getParameters();
            ObjectType neObjectType = ne.getObjectType();
            if ((this.staticMethod || !neObjectType.getInternalName().equals(this.internalTypeName)) && (typeTypes = this.typeMaker.makeTypeTypes(neObjectType.getInternalName())) != null) {
                ObjectType objectType;
                BaseTypeParameter typeParameters = typeTypes.typeParameters;
                BaseTypeArgument typeArguments = neObjectType.getTypeArguments();
                if (typeParameters != null && typeArguments == null) {
                    if (typeParameters.isList()) {
                        TypeArguments tas = new TypeArguments(typeParameters.size());
                        for (TypeParameter typeParameter : typeParameters) {
                            tas.add(new GenericType(typeParameter.getIdentifier()));
                        }
                        neObjectType = neObjectType.createType(tas);
                    } else {
                        neObjectType = neObjectType.createType(new GenericType(((TypeParameter)typeParameters.getFirst()).getIdentifier()));
                    }
                }
                ObjectType t = neObjectType;
                if (this.type.isObjectType() && (t = this.typeMaker.searchSuperParameterizedType(objectType = (ObjectType)this.type, neObjectType)) == null) {
                    t = neObjectType;
                }
                HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
                boolean partialBinding = this.populateBindings(bindings, null, typeParameters, typeArguments, null, this.type, t, parameterTypes, parameters);
                parameterTypes = this.bind(bindings, parameterTypes);
                ne.setParameterTypes(parameterTypes);
                for (Map.Entry entry : bindings.entrySet()) {
                    this.typeArgumentToTypeVisitor.init();
                    ((TypeArgument)entry.getValue()).accept(this.typeArgumentToTypeVisitor);
                    entry.setValue(this.typeArgumentToTypeVisitor.getType());
                }
                if (!partialBinding) {
                    ne.setType((ObjectType)this.bind(bindings, neObjectType));
                }
            }
            this.bindParameters(parameterTypes, parameters);
            ne.setBound(true);
        }
    }

    @Override
    public void visit(CastExpression expression) {
        ObjectType objectType;
        assert (ObjectType.TYPE_OBJECT.equals(this.type) || this.type.getDimension() == expression.getType().getDimension()) : "TypeParametersToTypeArgumentsBinder.visit(CastExpression ce) : invalid array type";
        if (this.type.isObjectType() && (objectType = (ObjectType)this.type).getTypeArguments() != null && !objectType.getTypeArguments().equals(WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT)) {
            assert (expression.getType().isObjectType()) : "TypeParametersToTypeArgumentsBinder.visit(CastExpression ce) : invalid object type";
            ObjectType expressionObjectType = (ObjectType)expression.getType();
            if (objectType.getInternalName().equals(expressionObjectType.getInternalName())) {
                Type expressionExpressionType = expression.getExpression().getType();
                if (expressionExpressionType.isObjectType()) {
                    ObjectType expressionExpressionObjectType = (ObjectType)expressionExpressionType;
                    if (expressionExpressionObjectType.getTypeArguments() == null) {
                        expression.setType(objectType);
                    } else if (objectType.getTypeArguments().isTypeArgumentAssignableFrom(this.contextualTypeBounds, expressionExpressionObjectType.getTypeArguments())) {
                        expression.setType(objectType);
                    }
                } else if (expressionExpressionType.isGenericType()) {
                    expression.setType(objectType);
                }
            }
        }
        this.type = expression.getType();
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        Type t = this.type;
        expression.setType(t);
        expression.getTrueExpression().accept(this);
        this.type = t;
        expression.getFalseExpression().accept(this);
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        if (expression.getType() == ObjectType.TYPE_STRING && "+".equals(expression.getOperator())) {
            this.type = ObjectType.TYPE_OBJECT;
        }
        Type t = this.type;
        expression.getLeftExpression().accept(this);
        this.type = t;
        expression.getRightExpression().accept(this);
    }

    @Override
    public void visit(ArrayExpression expression) {
    }

    @Override
    public void visit(BooleanExpression expression) {
    }

    @Override
    public void visit(CommentExpression expression) {
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
    }

    @Override
    public void visit(Expressions expression) {
    }

    @Override
    public void visit(FieldReferenceExpression expression) {
    }

    @Override
    public void visit(FloatConstantExpression expression) {
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
    }

    @Override
    public void visit(InstanceOfExpression expression) {
    }

    @Override
    public void visit(LambdaFormalParametersExpression expression) {
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
    }

    @Override
    public void visit(LengthExpression expression) {
    }

    @Override
    public void visit(LongConstantExpression expression) {
    }

    @Override
    public void visit(MethodReferenceExpression expression) {
    }

    @Override
    public void visit(NewArray expression) {
    }

    @Override
    public void visit(NewInitializedArray expression) {
    }

    @Override
    public void visit(NoExpression expression) {
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
    }

    @Override
    public void visit(ParenthesesExpression expression) {
    }

    @Override
    public void visit(PostOperatorExpression expression) {
    }

    @Override
    public void visit(PreOperatorExpression expression) {
    }

    @Override
    public void visit(StringConstantExpression expression) {
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
    }

    @Override
    public void visit(SuperExpression expression) {
    }

    @Override
    public void visit(ThisExpression expression) {
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
    }

    protected static class RemoveNonWildcardTypeArgumentsVisitor
    extends AbstractNopExpressionVisitor {
        protected RemoveNonWildcardTypeArgumentsVisitor() {
        }

        @Override
        public void visit(MethodInvocationExpression expression) {
            expression.setNonWildcardTypeArguments(null);
        }
    }
}

