/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.Iterator;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.SynchronizedStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;

public class SynchronizedStatementMaker {
    public static Statement make(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements) {
        Expression monitor = ((Statement)statements.removeLast()).getMonitor();
        AbstractLocalVariable localVariable = null;
        if (monitor.isLocalVariableReferenceExpression()) {
            Expression expression;
            if (!statements.isEmpty() && (expression = ((Statement)statements.removeLast()).getExpression()).isBinaryOperatorExpression() && expression.getLeftExpression().isLocalVariableReferenceExpression()) {
                ClassFileLocalVariableReferenceExpression m = (ClassFileLocalVariableReferenceExpression)monitor;
                ClassFileLocalVariableReferenceExpression l = (ClassFileLocalVariableReferenceExpression)expression.getLeftExpression();
                assert (l.getLocalVariable() == m.getLocalVariable());
                monitor = expression.getRightExpression();
                localVariable = l.getLocalVariable();
            }
        } else if (monitor.isBinaryOperatorExpression() && monitor.getLeftExpression().isLocalVariableReferenceExpression()) {
            ClassFileLocalVariableReferenceExpression l = (ClassFileLocalVariableReferenceExpression)monitor.getLeftExpression();
            monitor = monitor.getRightExpression();
            localVariable = l.getLocalVariable();
        }
        new RemoveMonitorExitVisitor(localVariable).visit(tryStatements);
        localVariableMaker.removeLocalVariable(localVariable);
        return new SynchronizedStatement(monitor, tryStatements);
    }

    protected static class RemoveMonitorExitVisitor
    extends AbstractJavaSyntaxVisitor {
        protected AbstractLocalVariable localVariable;

        public RemoveMonitorExitVisitor(AbstractLocalVariable localVariable) {
            this.localVariable = localVariable;
        }

        @Override
        public void visit(Statements list) {
            if (!list.isEmpty()) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Statement statement = (Statement)iterator.next();
                    if (statement.isMonitorExitStatement()) {
                        ClassFileLocalVariableReferenceExpression cflvre;
                        if (!statement.getMonitor().isLocalVariableReferenceExpression() || (cflvre = (ClassFileLocalVariableReferenceExpression)statement.getMonitor()).getLocalVariable() != this.localVariable) continue;
                        iterator.remove();
                        continue;
                    }
                    statement.accept(this);
                }
            }
        }
    }
}

