/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.util.List;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.model.javasyntax.statement.TryStatement;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileLocalVariableReferenceExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.statement.ClassFileTryStatement;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.localvariable.AbstractLocalVariable;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.LocalVariableMaker;
import org.jd.core.v1.util.DefaultList;

public class TryWithResourcesStatementMaker {
    public static Statement make(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, DefaultList<TryStatement.CatchClause> catchClauses, Statements finallyStatements) {
        int size = statements.size();
        if (size < 2 || finallyStatements == null || finallyStatements.size() != 1 || !TryWithResourcesStatementMaker.checkThrowable(catchClauses)) {
            return null;
        }
        Statement statement = (Statement)statements.get(size - 2);
        if (!statement.isExpressionStatement()) {
            return null;
        }
        Expression expression = statement.getExpression();
        if (!expression.isBinaryOperatorExpression()) {
            return null;
        }
        Expression boe = expression;
        if (!(expression = boe.getLeftExpression()).isLocalVariableReferenceExpression()) {
            return null;
        }
        AbstractLocalVariable lv1 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        statement = (Statement)statements.get(size - 1);
        if (!statement.isExpressionStatement()) {
            return null;
        }
        expression = statement.getExpression();
        if (!expression.isBinaryOperatorExpression()) {
            return null;
        }
        if (!(expression = expression.getLeftExpression()).isLocalVariableReferenceExpression()) {
            return null;
        }
        AbstractLocalVariable lv2 = ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable();
        statement = (Statement)finallyStatements.getFirst();
        if (statement.isIfStatement() && lv1 == TryWithResourcesStatementMaker.getLocalVariable(statement.getCondition())) {
            if ((statement = (Statement)statement.getStatements().getFirst()).isIfElseStatement()) {
                return TryWithResourcesStatementMaker.parsePatternAddSuppressed(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2, statement);
            }
            if (statement.isExpressionStatement()) {
                return TryWithResourcesStatementMaker.parsePatternCloseResource(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2, statement);
            }
        }
        if (statement.isExpressionStatement()) {
            return TryWithResourcesStatementMaker.parsePatternCloseResource(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2, statement);
        }
        return null;
    }

    protected static Statement parsePatternAddSuppressed(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, Statements finallyStatements, Expression boe, AbstractLocalVariable lv1, AbstractLocalVariable lv2, Statement statement) {
        if (!statement.isIfElseStatement()) {
            return null;
        }
        Statement ies = statement;
        if (!(statement = (Statement)ies.getStatements().getFirst()).isTryStatement()) {
            return null;
        }
        Statement ts = statement;
        statement = (Statement)ies.getElseStatements().getFirst();
        if (!statement.isExpressionStatement()) {
            return null;
        }
        Expression expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        MethodInvocationExpression mie = (MethodInvocationExpression)expression;
        if (ts.getFinallyStatements() != null || lv2 != TryWithResourcesStatementMaker.getLocalVariable(ies.getCondition()) || !TryWithResourcesStatementMaker.checkThrowable(ts.getCatchClauses()) || !TryWithResourcesStatementMaker.checkCloseInvocation(mie, lv1)) {
            return null;
        }
        statement = (Statement)ts.getTryStatements().getFirst();
        if (!statement.isExpressionStatement()) {
            return null;
        }
        expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        mie = (MethodInvocationExpression)expression;
        if (!TryWithResourcesStatementMaker.checkCloseInvocation(mie, lv1)) {
            return null;
        }
        statement = (Statement)ts.getCatchClauses().getFirst().getStatements().getFirst();
        if (!statement.isExpressionStatement()) {
            return null;
        }
        expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        mie = (MethodInvocationExpression)expression;
        if (!mie.getName().equals("addSuppressed") || !mie.getDescriptor().equals("(Ljava/lang/Throwable;)V")) {
            return null;
        }
        expression = mie.getExpression();
        if (!expression.isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() != lv2) {
            return null;
        }
        return TryWithResourcesStatementMaker.newTryStatement(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2);
    }

    protected static boolean checkThrowable(List<? extends TryStatement.CatchClause> catchClauses) {
        return catchClauses.size() == 1 && catchClauses.get(0).getType().equals(ObjectType.TYPE_THROWABLE);
    }

    protected static AbstractLocalVariable getLocalVariable(Expression condition) {
        if (!condition.isBinaryOperatorExpression()) {
            return null;
        }
        if (!(condition.getOperator().equals("!=") && condition.getRightExpression().isNullExpression() && condition.getLeftExpression().isLocalVariableReferenceExpression())) {
            return null;
        }
        return ((ClassFileLocalVariableReferenceExpression)condition.getLeftExpression()).getLocalVariable();
    }

    protected static boolean checkCloseInvocation(MethodInvocationExpression mie, AbstractLocalVariable lv) {
        Expression expression;
        if (mie.getName().equals("close") && mie.getDescriptor().equals("()V") && (expression = mie.getExpression()).isLocalVariableReferenceExpression()) {
            return ((ClassFileLocalVariableReferenceExpression)expression).getLocalVariable() == lv;
        }
        return false;
    }

    protected static Statement parsePatternCloseResource(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, Statements finallyStatements, Expression boe, AbstractLocalVariable lv1, AbstractLocalVariable lv2, Statement statement) {
        Expression expression = statement.getExpression();
        if (!expression.isMethodInvocationExpression()) {
            return null;
        }
        MethodInvocationExpression mie = (MethodInvocationExpression)expression;
        if (!mie.getName().equals("$closeResource") || !mie.getDescriptor().equals("(Ljava/lang/Throwable;Ljava/lang/AutoCloseable;)V")) {
            return null;
        }
        DefaultList parameters = mie.getParameters().getList();
        Expression parameter0 = (Expression)parameters.getFirst();
        if (!parameter0.isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)parameter0).getLocalVariable() != lv2) {
            return null;
        }
        Expression parameter1 = (Expression)parameters.get(1);
        if (!parameter1.isLocalVariableReferenceExpression()) {
            return null;
        }
        if (((ClassFileLocalVariableReferenceExpression)parameter1).getLocalVariable() != lv1) {
            return null;
        }
        return TryWithResourcesStatementMaker.newTryStatement(localVariableMaker, statements, tryStatements, finallyStatements, boe, lv1, lv2);
    }

    protected static ClassFileTryStatement newTryStatement(LocalVariableMaker localVariableMaker, Statements statements, Statements tryStatements, Statements finallyStatements, Expression boe, AbstractLocalVariable lv1, AbstractLocalVariable lv2) {
        statements.removeLast();
        statements.removeLast();
        lv1.setDeclared(true);
        localVariableMaker.removeLocalVariable(lv2);
        DefaultList<TryStatement.Resource> resources = new DefaultList<TryStatement.Resource>();
        resources.add(new TryStatement.Resource((ObjectType)lv1.getType(), lv1.getName(), boe.getRightExpression()));
        return new ClassFileTryStatement(resources, tryStatements, null, finallyStatements, false, false);
    }
}

