/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.loader.LoaderException;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.classfile.Field;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeExceptions;
import org.jd.core.v1.model.classfile.attribute.AttributeSignature;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.TypeParameters;
import org.jd.core.v1.model.javasyntax.type.UnmodifiableTypes;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureFormatException;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BindTypesToTypesVisitor;
import org.jd.core.v1.service.deserializer.classfile.ClassFileFormatException;
import org.jd.core.v1.service.deserializer.classfile.ClassFileReader;

public class TypeMaker {
    private static final HashMap<String, ObjectType> INTERNALNAME_TO_OBJECTPRIMITIVETYPE = new HashMap();
    private HashMap<String, Type> signatureToType = new HashMap(1024);
    private HashMap<String, Type> internalTypeNameFieldNameToType = new HashMap(1024);
    private HashMap<String, ObjectType> descriptorToObjectType = new HashMap(1024);
    private HashMap<String, ObjectType> internalTypeNameToObjectType = new HashMap(1024);
    private HashMap<String, TypeTypes> internalTypeNameToTypeTypes = new HashMap(1024);
    private HashMap<String, Set<BaseType>> internalTypeNameMethodNameParameterCountToDeclaredParameterTypes = new HashMap(1024);
    private HashMap<String, Set<BaseType>> internalTypeNameMethodNameParameterCountToParameterTypes = new HashMap(1024);
    private HashMap<String, MethodTypes> internalTypeNameMethodNameDescriptorToMethodTypes = new HashMap(1024);
    private HashMap<String, MethodTypes> signatureToMethodTypes = new HashMap(1024);
    private HashMap<Long, Boolean> assignableRawTypes = new HashMap(1024);
    private HashMap<Long, ObjectType> superParameterizedObjectTypes = new HashMap(1024);
    private HashMap<String, String[]> hierarchy = new HashMap(1024);
    private ClassPathLoader classPathLoader = new ClassPathLoader();
    private Loader loader;

    public TypeMaker(Loader loader) {
        this.loader = loader;
        this.signatureToType.put("B", PrimitiveType.TYPE_BYTE);
        this.signatureToType.put("C", PrimitiveType.TYPE_CHAR);
        this.signatureToType.put("D", PrimitiveType.TYPE_DOUBLE);
        this.signatureToType.put("F", PrimitiveType.TYPE_FLOAT);
        this.signatureToType.put("I", PrimitiveType.TYPE_INT);
        this.signatureToType.put("J", PrimitiveType.TYPE_LONG);
        this.signatureToType.put("S", PrimitiveType.TYPE_SHORT);
        this.signatureToType.put("V", PrimitiveType.TYPE_VOID);
        this.signatureToType.put("Z", PrimitiveType.TYPE_BOOLEAN);
        this.signatureToType.put("Ljava/lang/Class;", ObjectType.TYPE_CLASS);
        this.signatureToType.put("Ljava/lang/Exception;", ObjectType.TYPE_EXCEPTION);
        this.signatureToType.put("Ljava/lang/Object;", ObjectType.TYPE_OBJECT);
        this.signatureToType.put("Ljava/lang/Throwable;", ObjectType.TYPE_THROWABLE);
        this.signatureToType.put("Ljava/lang/String;", ObjectType.TYPE_STRING);
        this.signatureToType.put("Ljava/lang/System;", ObjectType.TYPE_SYSTEM);
        this.descriptorToObjectType.put("Ljava/lang/Class;", ObjectType.TYPE_CLASS);
        this.descriptorToObjectType.put("Ljava/lang/Exception;", ObjectType.TYPE_EXCEPTION);
        this.descriptorToObjectType.put("Ljava/lang/Object;", ObjectType.TYPE_OBJECT);
        this.descriptorToObjectType.put("Ljava/lang/Throwable;", ObjectType.TYPE_THROWABLE);
        this.descriptorToObjectType.put("Ljava/lang/String;", ObjectType.TYPE_STRING);
        this.descriptorToObjectType.put("Ljava/lang/System;", ObjectType.TYPE_SYSTEM);
        this.internalTypeNameToObjectType.put("java/lang/Class", ObjectType.TYPE_CLASS);
        this.internalTypeNameToObjectType.put("java/lang/Exception", ObjectType.TYPE_EXCEPTION);
        this.internalTypeNameToObjectType.put("java/lang/Object", ObjectType.TYPE_OBJECT);
        this.internalTypeNameToObjectType.put("java/lang/Throwable", ObjectType.TYPE_THROWABLE);
        this.internalTypeNameToObjectType.put("java/lang/String", ObjectType.TYPE_STRING);
        this.internalTypeNameToObjectType.put("java/lang/System", ObjectType.TYPE_SYSTEM);
    }

    public TypeTypes parseClassFileSignature(ClassFile classFile) {
        TypeTypes typeTypes = new TypeTypes();
        String internalTypeName = classFile.getInternalTypeName();
        typeTypes.thisType = this.makeFromInternalTypeName(internalTypeName);
        AttributeSignature attributeSignature = (AttributeSignature)classFile.getAttribute("Signature");
        if (attributeSignature == null) {
            String superTypeName = classFile.getSuperTypeName();
            String[] interfaceTypeNames = classFile.getInterfaceTypeNames();
            if (!"java/lang/Object".equals(superTypeName)) {
                typeTypes.superType = this.makeFromInternalTypeName(superTypeName);
            }
            if (interfaceTypeNames != null) {
                int length = interfaceTypeNames.length;
                if (length == 1) {
                    typeTypes.interfaces = this.makeFromInternalTypeName(interfaceTypeNames[0]);
                } else {
                    UnmodifiableTypes list = new UnmodifiableTypes(length);
                    for (String interfaceTypeName : interfaceTypeNames) {
                        list.add(this.makeFromInternalTypeName(interfaceTypeName));
                    }
                    typeTypes.interfaces = list;
                }
            }
        } else {
            SignatureReader signatureReader = new SignatureReader(attributeSignature.getSignature());
            typeTypes.typeParameters = this.parseTypeParameters(signatureReader);
            typeTypes.superType = this.parseClassTypeSignature(signatureReader, 0);
            ObjectType firstInterface = this.parseClassTypeSignature(signatureReader, 0);
            if (firstInterface != null) {
                ObjectType nextInterface = this.parseClassTypeSignature(signatureReader, 0);
                if (nextInterface == null) {
                    typeTypes.interfaces = firstInterface;
                } else {
                    UnmodifiableTypes list = new UnmodifiableTypes(classFile.getInterfaceTypeNames().length);
                    list.add(firstInterface);
                    do {
                        list.add(nextInterface);
                    } while ((nextInterface = this.parseClassTypeSignature(signatureReader, 0)) != null);
                    typeTypes.interfaces = list;
                }
            }
        }
        this.internalTypeNameToTypeTypes.put(internalTypeName, typeTypes);
        return typeTypes;
    }

    public MethodTypes parseMethodSignature(ClassFile classFile, Method method) {
        String key = classFile.getInternalTypeName() + ':' + method.getName() + method.getDescriptor();
        return this.parseMethodSignature(method, key);
    }

    private MethodTypes parseMethodSignature(Method method, String key) {
        AttributeSignature attributeSignature = (AttributeSignature)method.getAttribute("Signature");
        String[] exceptionTypeNames = TypeMaker.getExceptionTypeNames(method);
        MethodTypes methodTypes = attributeSignature == null ? this.parseMethodSignature(method.getDescriptor(), exceptionTypeNames) : this.parseMethodSignature(method.getDescriptor(), attributeSignature.getSignature(), exceptionTypeNames);
        this.internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
        return methodTypes;
    }

    private static String[] getExceptionTypeNames(Method method) {
        AttributeExceptions attributeExceptions;
        if (method != null && (attributeExceptions = (AttributeExceptions)method.getAttribute("Exceptions")) != null) {
            return attributeExceptions.getExceptionTypeNames();
        }
        return null;
    }

    public Type parseFieldSignature(ClassFile classFile, Field field) {
        String key = classFile.getInternalTypeName() + ':' + field.getName();
        AttributeSignature attributeSignature = (AttributeSignature)field.getAttribute("Signature");
        String signature = attributeSignature == null ? field.getDescriptor() : attributeSignature.getSignature();
        Type type = this.makeFromSignature(signature);
        this.internalTypeNameFieldNameToType.put(key, type);
        return type;
    }

    public Type makeFromSignature(String signature) {
        Type type = this.signatureToType.get(signature);
        if (type == null) {
            SignatureReader reader = new SignatureReader(signature);
            type = this.parseReferenceTypeSignature(reader);
            this.signatureToType.put(signature, type);
        }
        return type;
    }

    public static int countDimension(String descriptor) {
        int count = 0;
        int len = descriptor.length();
        for (int i = 0; i < len && descriptor.charAt(i) == '['; ++i) {
            ++count;
        }
        return count;
    }

    private MethodTypes parseMethodSignature(String descriptor, String signature, String[] exceptionTypeNames) {
        if (signature == null) {
            return this.parseMethodSignature(descriptor, exceptionTypeNames);
        }
        MethodTypes mtDescriptor = this.parseMethodSignature(descriptor, exceptionTypeNames);
        MethodTypes mtSignature = this.parseMethodSignature(signature, exceptionTypeNames);
        if (mtDescriptor.parameterTypes == null) {
            return mtSignature;
        }
        if (mtSignature.parameterTypes == null) {
            MethodTypes mt = new MethodTypes();
            mt.typeParameters = mtSignature.typeParameters;
            mt.parameterTypes = mtDescriptor.parameterTypes;
            mt.returnedType = mtSignature.returnedType;
            mt.exceptionTypes = mtSignature.exceptionTypes;
            return mt;
        }
        if (mtDescriptor.parameterTypes.size() == mtSignature.parameterTypes.size()) {
            return mtSignature;
        }
        UnmodifiableTypes parameterTypes = new UnmodifiableTypes((Collection<Type>)mtDescriptor.parameterTypes.getList().subList(0, mtDescriptor.parameterTypes.size() - mtSignature.parameterTypes.size()));
        parameterTypes.addAll(mtSignature.parameterTypes.getList());
        MethodTypes mt = new MethodTypes();
        mt.typeParameters = mtSignature.typeParameters;
        mt.parameterTypes = parameterTypes;
        mt.returnedType = mtSignature.returnedType;
        mt.exceptionTypes = mtSignature.exceptionTypes;
        return mt;
    }

    private MethodTypes parseMethodSignature(String signature, String[] exceptionTypeNames) {
        MethodTypes methodTypes;
        boolean containsThrowsSignature;
        String cacheKey = signature;
        boolean bl = containsThrowsSignature = signature.indexOf(94) != -1;
        if (!containsThrowsSignature && exceptionTypeNames != null) {
            StringBuilder sb = new StringBuilder(signature);
            for (String exceptionTypeName : exceptionTypeNames) {
                sb.append("^L").append(exceptionTypeName).append(';');
            }
            cacheKey = sb.toString();
        }
        if ((methodTypes = this.signatureToMethodTypes.get(cacheKey)) == null) {
            SignatureReader reader = new SignatureReader(signature);
            methodTypes = new MethodTypes();
            methodTypes.typeParameters = this.parseTypeParameters(reader);
            if (reader.read() != '(') {
                throw new SignatureFormatException(signature);
            }
            Type firstParameterType = this.parseReferenceTypeSignature(reader);
            if (firstParameterType == null) {
                methodTypes.parameterTypes = null;
            } else {
                Type nextParameterType = this.parseReferenceTypeSignature(reader);
                UnmodifiableTypes types = new UnmodifiableTypes();
                types.add(firstParameterType);
                while (nextParameterType != null) {
                    types.add(nextParameterType);
                    nextParameterType = this.parseReferenceTypeSignature(reader);
                }
                methodTypes.parameterTypes = types;
            }
            if (reader.read() != ')') {
                throw new SignatureFormatException(signature);
            }
            methodTypes.returnedType = this.parseReferenceTypeSignature(reader);
            Type firstException = this.parseExceptionSignature(reader);
            if (firstException == null) {
                if (exceptionTypeNames != null) {
                    if (exceptionTypeNames.length == 1) {
                        methodTypes.exceptionTypes = this.makeFromInternalTypeName(exceptionTypeNames[0]);
                    } else {
                        UnmodifiableTypes list = new UnmodifiableTypes(exceptionTypeNames.length);
                        for (String exceptionTypeName : exceptionTypeNames) {
                            list.add(this.makeFromInternalTypeName(exceptionTypeName));
                        }
                        methodTypes.exceptionTypes = list;
                    }
                }
            } else {
                Type nextException = this.parseExceptionSignature(reader);
                if (nextException == null) {
                    methodTypes.exceptionTypes = firstException;
                } else {
                    UnmodifiableTypes list = new UnmodifiableTypes();
                    list.add(firstException);
                    do {
                        list.add(nextException);
                    } while ((nextException = this.parseExceptionSignature(reader)) != null);
                    methodTypes.exceptionTypes = list;
                }
            }
            this.signatureToMethodTypes.put(cacheKey, methodTypes);
        }
        return methodTypes;
    }

    private BaseTypeParameter parseTypeParameters(SignatureReader reader) {
        if (reader.nextEqualsTo('<')) {
            BaseTypeParameter typeParameters;
            ++reader.index;
            TypeParameter firstTypeParameter = this.parseTypeParameter(reader);
            if (firstTypeParameter == null) {
                throw new SignatureFormatException(reader.signature);
            }
            TypeParameter nextTypeParameter = this.parseTypeParameter(reader);
            if (nextTypeParameter == null) {
                typeParameters = firstTypeParameter;
            } else {
                TypeParameters list = new TypeParameters();
                list.add(firstTypeParameter);
                do {
                    list.add(nextTypeParameter);
                } while ((nextTypeParameter = this.parseTypeParameter(reader)) != null);
                typeParameters = list;
            }
            if (reader.read() != '>') {
                throw new SignatureFormatException(reader.signature);
            }
            return typeParameters;
        }
        return null;
    }

    private TypeParameter parseTypeParameter(SignatureReader reader) {
        int fistIndex = reader.index;
        if (reader.search(':')) {
            String identifier = reader.substring(fistIndex);
            Type firstBound = null;
            ArrayList types = null;
            while (reader.nextEqualsTo(':')) {
                ++reader.index;
                Type bound = this.parseReferenceTypeSignature(reader);
                if (bound == null || bound.getDescriptor().equals("Ljava/lang/Object;")) continue;
                if (firstBound == null) {
                    firstBound = bound;
                    continue;
                }
                if (types == null) {
                    types = new UnmodifiableTypes();
                    types.add(firstBound);
                    types.add(bound);
                    continue;
                }
                types.add(bound);
            }
            if (firstBound == null) {
                return new TypeParameter(identifier);
            }
            if (types == null) {
                return new TypeParameterWithTypeBounds(identifier, firstBound);
            }
            return new TypeParameterWithTypeBounds(identifier, (BaseType)((Object)types));
        }
        return null;
    }

    private Type parseExceptionSignature(SignatureReader reader) {
        if (reader.nextEqualsTo('^')) {
            ++reader.index;
            return this.parseReferenceTypeSignature(reader);
        }
        return null;
    }

    private ObjectType parseClassTypeSignature(SignatureReader reader, int dimension) {
        if (reader.nextEqualsTo('L')) {
            ++reader.index;
            int index = reader.index++;
            char endMarker = reader.searchEndMarker();
            if (endMarker == '\u0000') {
                throw new SignatureFormatException(reader.signature);
            }
            String internalTypeName = reader.substring(index);
            ObjectType ot = this.makeFromInternalTypeName(internalTypeName);
            if (endMarker == '<') {
                ot = ot.createType(this.parseTypeArguments(reader));
                if (reader.read() != '>') {
                    throw new SignatureFormatException(reader.signature);
                }
            }
            while (reader.nextEqualsTo('.')) {
                String qualifiedName;
                index = ++reader.index;
                endMarker = reader.searchEndMarker();
                if (endMarker == '\u0000') {
                    throw new SignatureFormatException(reader.signature);
                }
                String name = reader.substring(index);
                internalTypeName = internalTypeName + '$' + name;
                if (Character.isDigit(name.charAt(0))) {
                    name = TypeMaker.extractLocalClassName(name);
                    qualifiedName = null;
                } else {
                    qualifiedName = ot.getQualifiedName() + '.' + name;
                }
                if (endMarker == '<') {
                    ++reader.index;
                    BaseTypeArgument typeArguments = this.parseTypeArguments(reader);
                    if (reader.read() != '>') {
                        throw new SignatureFormatException(reader.signature);
                    }
                    ot = new InnerObjectType(internalTypeName, qualifiedName, name, typeArguments, ot);
                    continue;
                }
                ot = new InnerObjectType(internalTypeName, qualifiedName, name, ot);
            }
            ++reader.index;
            return dimension == 0 ? ot : (ObjectType)ot.createType(dimension);
        }
        return null;
    }

    private BaseTypeArgument parseTypeArguments(SignatureReader reader) {
        TypeArgument firstTypeArgument = this.parseTypeArgument(reader);
        if (firstTypeArgument == null) {
            throw new SignatureFormatException(reader.signature);
        }
        TypeArgument nextTypeArgument = this.parseTypeArgument(reader);
        if (nextTypeArgument == null) {
            return firstTypeArgument;
        }
        TypeArguments typeArguments = new TypeArguments();
        typeArguments.add(firstTypeArgument);
        do {
            typeArguments.add(nextTypeArgument);
        } while ((nextTypeArgument = this.parseTypeArgument(reader)) != null);
        return typeArguments;
    }

    private Type parseReferenceTypeSignature(SignatureReader reader) {
        if (reader.available()) {
            int dimension = 0;
            char c = reader.read();
            while (c == '[') {
                ++dimension;
                c = reader.read();
            }
            switch (c) {
                case 'B': {
                    return dimension == 0 ? PrimitiveType.TYPE_BYTE : PrimitiveType.TYPE_BYTE.createType(dimension);
                }
                case 'C': {
                    return dimension == 0 ? PrimitiveType.TYPE_CHAR : PrimitiveType.TYPE_CHAR.createType(dimension);
                }
                case 'D': {
                    return dimension == 0 ? PrimitiveType.TYPE_DOUBLE : PrimitiveType.TYPE_DOUBLE.createType(dimension);
                }
                case 'F': {
                    return dimension == 0 ? PrimitiveType.TYPE_FLOAT : PrimitiveType.TYPE_FLOAT.createType(dimension);
                }
                case 'I': {
                    return dimension == 0 ? PrimitiveType.TYPE_INT : PrimitiveType.TYPE_INT.createType(dimension);
                }
                case 'J': {
                    return dimension == 0 ? PrimitiveType.TYPE_LONG : PrimitiveType.TYPE_LONG.createType(dimension);
                }
                case 'L': {
                    --reader.index;
                    return this.parseClassTypeSignature(reader, dimension);
                }
                case 'S': {
                    return dimension == 0 ? PrimitiveType.TYPE_SHORT : PrimitiveType.TYPE_SHORT.createType(dimension);
                }
                case 'T': {
                    int index = reader.index++;
                    if (!reader.search(';')) {
                        return null;
                    }
                    String identifier = reader.substring(index);
                    return new GenericType(identifier, dimension);
                }
                case 'V': {
                    assert (dimension == 0);
                    return PrimitiveType.TYPE_VOID;
                }
                case 'Z': {
                    return dimension == 0 ? PrimitiveType.TYPE_BOOLEAN : PrimitiveType.TYPE_BOOLEAN.createType(dimension);
                }
            }
            --reader.index;
            return null;
        }
        return null;
    }

    private TypeArgument parseTypeArgument(SignatureReader reader) {
        switch (reader.read()) {
            case '+': {
                return new WildcardExtendsTypeArgument(this.parseReferenceTypeSignature(reader));
            }
            case '-': {
                return new WildcardSuperTypeArgument(this.parseReferenceTypeSignature(reader));
            }
            case '*': {
                return WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT;
            }
        }
        --reader.index;
        return this.parseReferenceTypeSignature(reader);
    }

    private static boolean isAReferenceTypeSignature(SignatureReader reader) {
        if (reader.available()) {
            char c = reader.read();
            while (c == '[') {
                c = reader.read();
            }
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': {
                    return true;
                }
                case 'L': {
                    --reader.index;
                    return TypeMaker.isAClassTypeSignature(reader);
                }
                case 'S': {
                    return true;
                }
                case 'T': {
                    reader.searchEndMarker();
                    return true;
                }
                case 'V': 
                case 'Z': {
                    return true;
                }
            }
            --reader.index;
            return false;
        }
        return false;
    }

    private static boolean isAClassTypeSignature(SignatureReader reader) {
        if (reader.nextEqualsTo('L')) {
            ++reader.index;
            char endMarker = reader.searchEndMarker();
            if (endMarker == '\u0000') {
                throw new SignatureFormatException(reader.signature);
            }
            if (endMarker == '<') {
                ++reader.index;
                TypeMaker.isATypeArguments(reader);
                if (reader.read() != '>') {
                    throw new SignatureFormatException(reader.signature);
                }
            }
            while (reader.nextEqualsTo('.')) {
                ++reader.index;
                endMarker = reader.searchEndMarker();
                if (endMarker == '\u0000') {
                    throw new SignatureFormatException(reader.signature);
                }
                if (endMarker != '<') continue;
                ++reader.index;
                TypeMaker.isATypeArguments(reader);
                if (reader.read() == '>') continue;
                throw new SignatureFormatException(reader.signature);
            }
            ++reader.index;
            return true;
        }
        return false;
    }

    private static boolean isATypeArguments(SignatureReader reader) {
        if (!TypeMaker.isATypeArgument(reader)) {
            throw new SignatureFormatException(reader.signature);
        }
        while (TypeMaker.isATypeArgument(reader)) {
        }
        return true;
    }

    private static boolean isATypeArgument(SignatureReader reader) {
        switch (reader.read()) {
            case '+': 
            case '-': {
                return TypeMaker.isAReferenceTypeSignature(reader);
            }
            case '*': {
                return true;
            }
        }
        --reader.index;
        return TypeMaker.isAReferenceTypeSignature(reader);
    }

    private static String extractLocalClassName(String name) {
        if (Character.isDigit(name.charAt(0))) {
            int i;
            int len = name.length();
            for (i = 0; i < len && Character.isDigit(name.charAt(i)); ++i) {
            }
            return i == len ? null : name.substring(i);
        }
        return name;
    }

    public ObjectType makeFromDescriptorOrInternalTypeName(String descriptorOrInternalTypeName) {
        return descriptorOrInternalTypeName.charAt(0) == '[' ? this.makeFromDescriptor(descriptorOrInternalTypeName) : this.makeFromInternalTypeName(descriptorOrInternalTypeName);
    }

    public ObjectType makeFromDescriptor(String descriptor) {
        ObjectType ot = this.descriptorToObjectType.get(descriptor);
        if (ot == null) {
            if (descriptor.charAt(0) == '[') {
                int dimension = 1;
                while (descriptor.charAt(dimension) == '[') {
                    ++dimension;
                }
                ot = (ObjectType)this.makeFromDescriptorWithoutBracket(descriptor.substring(dimension)).createType(dimension);
            } else {
                ot = this.makeFromDescriptorWithoutBracket(descriptor);
            }
            this.descriptorToObjectType.put(descriptor, ot);
        }
        return ot;
    }

    private ObjectType makeFromDescriptorWithoutBracket(String descriptor) {
        ObjectType ot = INTERNALNAME_TO_OBJECTPRIMITIVETYPE.get(descriptor);
        if (ot == null) {
            ot = this.makeFromInternalTypeName(descriptor.substring(1, descriptor.length() - 1));
        }
        return ot;
    }

    public ObjectType makeFromInternalTypeName(String internalTypeName) {
        assert (internalTypeName != null && !internalTypeName.endsWith(";")) : "ObjectTypeMaker.makeFromInternalTypeName(internalTypeName) : invalid internalTypeName";
        ObjectType ot = this.loadType(internalTypeName);
        if (ot == null) {
            ot = this.create(internalTypeName);
        }
        return ot;
    }

    private ObjectType create(String internalTypeName) {
        ObjectType ot;
        int lastDollar;
        int lastSlash = internalTypeName.lastIndexOf(47);
        if (lastSlash < (lastDollar = internalTypeName.lastIndexOf(36))) {
            String outerTypeName = internalTypeName.substring(0, lastDollar);
            ObjectType outerSot = this.create(outerTypeName);
            String innerName = internalTypeName.substring(outerTypeName.length() + 1);
            if (innerName.isEmpty()) {
                String qualifiedName = internalTypeName.replace('/', '.');
                String name = qualifiedName.substring(lastSlash + 1);
                ot = new ObjectType(internalTypeName, qualifiedName, name);
            } else if (Character.isDigit(innerName.charAt(0))) {
                ot = new InnerObjectType(internalTypeName, null, TypeMaker.extractLocalClassName(innerName), outerSot);
            } else {
                String qualifiedName = outerSot.getQualifiedName() + '.' + innerName;
                ot = new InnerObjectType(internalTypeName, qualifiedName, innerName, outerSot);
            }
        } else {
            String qualifiedName = internalTypeName.replace('/', '.');
            String name = qualifiedName.substring(lastSlash + 1);
            ot = new ObjectType(internalTypeName, qualifiedName, name);
        }
        this.internalTypeNameToObjectType.put(internalTypeName, ot);
        return ot;
    }

    public ObjectType searchSuperParameterizedType(ObjectType superObjectType, ObjectType objectType) {
        if (superObjectType == ObjectType.TYPE_UNDEFINED_OBJECT || superObjectType.equals(ObjectType.TYPE_OBJECT) || superObjectType.equals(objectType)) {
            return objectType;
        }
        if (superObjectType.getDimension() > 0 || objectType.getDimension() > 0) {
            return null;
        }
        String superInternalTypeName = superObjectType.getInternalName();
        long superHashCode = superInternalTypeName.hashCode() * 31;
        return this.searchSuperParameterizedType(superHashCode, superInternalTypeName, objectType);
    }

    public boolean isAssignable(Map<String, BaseType> typeBounds, ObjectType left, ObjectType right) {
        if (right == ObjectType.TYPE_UNDEFINED_OBJECT || left == ObjectType.TYPE_UNDEFINED_OBJECT || left.equals(ObjectType.TYPE_OBJECT) || left.equals(right)) {
            return true;
        }
        if (left.getDimension() > 0 || right.getDimension() > 0) {
            return false;
        }
        String leftInternalTypeName = left.getInternalName();
        long leftHashCode = leftInternalTypeName.hashCode() * 31;
        ObjectType ot = this.searchSuperParameterizedType(leftHashCode, leftInternalTypeName, right);
        if (ot != null && leftInternalTypeName.equals(ot.getInternalName())) {
            if (left.getTypeArguments() == null || ot.getTypeArguments() == null) {
                return true;
            }
            return left.getTypeArguments().isTypeArgumentAssignableFrom(typeBounds, ot.getTypeArguments());
        }
        return false;
    }

    private ObjectType searchSuperParameterizedType(long leftHashCode, String leftInternalTypeName, ObjectType right) {
        if (right.equals(ObjectType.TYPE_OBJECT)) {
            return null;
        }
        Long key = leftHashCode + (long)right.hashCode();
        if (this.superParameterizedObjectTypes.containsKey(key)) {
            return this.superParameterizedObjectTypes.get(key);
        }
        String rightInternalTypeName = right.getInternalName();
        if (leftInternalTypeName.equals(rightInternalTypeName)) {
            this.superParameterizedObjectTypes.put(key, right);
            return right;
        }
        TypeTypes rightTypeTypes = this.makeTypeTypes(rightInternalTypeName);
        if (rightTypeTypes != null) {
            Map<String, TypeArgument> bindings;
            BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
            if (rightTypeTypes.typeParameters == null || right.getTypeArguments() == null) {
                bindings = Collections.emptyMap();
            } else {
                bindings = new HashMap<String, TypeArgument>();
                if (rightTypeTypes.typeParameters.isList() && right.getTypeArguments().isTypeArgumentList()) {
                    Iterator iteratorTypeParameter = rightTypeTypes.typeParameters.iterator();
                    Iterator iteratorTypeArgument = right.getTypeArguments().getTypeArgumentList().iterator();
                    while (iteratorTypeParameter.hasNext()) {
                        bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iteratorTypeArgument.next());
                    }
                } else {
                    bindings.put(((TypeParameter)rightTypeTypes.typeParameters.getFirst()).getIdentifier(), right.getTypeArguments().getTypeArgumentFirst());
                }
            }
            bindTypesToTypesVisitor.setBindings(bindings);
            if (rightTypeTypes.superType != null) {
                bindTypesToTypesVisitor.init();
                rightTypeTypes.superType.accept(bindTypesToTypesVisitor);
                ObjectType ot = (ObjectType)bindTypesToTypesVisitor.getType();
                ot = this.searchSuperParameterizedType(leftHashCode, leftInternalTypeName, ot);
                if (ot != null) {
                    this.superParameterizedObjectTypes.put(key, ot);
                    return ot;
                }
            }
            if (rightTypeTypes.interfaces != null) {
                for (Type interfaze : rightTypeTypes.interfaces) {
                    bindTypesToTypesVisitor.init();
                    interfaze.accept(bindTypesToTypesVisitor);
                    ObjectType ot = (ObjectType)bindTypesToTypesVisitor.getType();
                    if ((ot = this.searchSuperParameterizedType(leftHashCode, leftInternalTypeName, ot)) == null) continue;
                    this.superParameterizedObjectTypes.put(key, ot);
                    return ot;
                }
            }
        }
        this.superParameterizedObjectTypes.put(key, null);
        return null;
    }

    public boolean isRawTypeAssignable(ObjectType left, ObjectType right) {
        String rightInternalName;
        if (left == ObjectType.TYPE_UNDEFINED_OBJECT || left.equals(ObjectType.TYPE_OBJECT) || left.equals(right)) {
            return true;
        }
        if (left.getDimension() > 0 || right.getDimension() > 0) {
            return false;
        }
        String leftInternalName = left.getInternalName();
        if (leftInternalName.equals(rightInternalName = right.getInternalName())) {
            return true;
        }
        return this.isRawTypeAssignable(leftInternalName.hashCode() * 31, leftInternalName, rightInternalName);
    }

    private boolean isRawTypeAssignable(long leftHashCode, String leftInternalName, String rightInternalName) {
        if (rightInternalName.equals("java/lang/Object")) {
            return false;
        }
        Long key = leftHashCode + (long)rightInternalName.hashCode();
        if (this.assignableRawTypes.containsKey(key)) {
            return this.assignableRawTypes.get(key);
        }
        String[] superClassAndInterfaceNames = this.hierarchy.get(rightInternalName);
        if (superClassAndInterfaceNames == null) {
            this.loadType(rightInternalName);
            superClassAndInterfaceNames = this.hierarchy.get(rightInternalName);
        }
        if (superClassAndInterfaceNames != null) {
            for (String name : superClassAndInterfaceNames) {
                if (!leftInternalName.equals(name)) continue;
                this.assignableRawTypes.put(key, Boolean.TRUE);
                return true;
            }
            for (String name : superClassAndInterfaceNames) {
                if (!this.isRawTypeAssignable(leftHashCode, leftInternalName, name)) continue;
                this.assignableRawTypes.put(key, Boolean.TRUE);
                return true;
            }
        }
        this.assignableRawTypes.put(key, Boolean.FALSE);
        return false;
    }

    public TypeTypes makeTypeTypes(String internalTypeName) {
        TypeTypes typeTypes;
        block6: {
            if (this.internalTypeNameToTypeTypes.containsKey(internalTypeName)) {
                return this.internalTypeNameToTypeTypes.get(internalTypeName);
            }
            typeTypes = null;
            try {
                if (this.loader.canLoad(internalTypeName)) {
                    typeTypes = this.makeTypeTypes(internalTypeName, this.loader.load(internalTypeName));
                    this.internalTypeNameToTypeTypes.put(internalTypeName, typeTypes);
                } else if (this.classPathLoader.canLoad(internalTypeName)) {
                    typeTypes = this.makeTypeTypes(internalTypeName, this.classPathLoader.load(internalTypeName));
                    this.internalTypeNameToTypeTypes.put(internalTypeName, typeTypes);
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block6;
                throw new AssertionError();
            }
        }
        return typeTypes;
    }

    private TypeTypes makeTypeTypes(String internalTypeName, byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        ClassFileReader reader = new ClassFileReader(data);
        Object[] constants = this.loadClassFile(internalTypeName, reader);
        TypeMaker.skipMembers(reader);
        TypeMaker.skipMembers(reader);
        String signature = null;
        int count = reader.readUnsignedShort();
        for (int j = 0; j < count; ++j) {
            int attributeNameIndex = reader.readUnsignedShort();
            int attributeLength = reader.readInt();
            if ("Signature".equals(constants[attributeNameIndex])) {
                signature = (String)constants[reader.readUnsignedShort()];
                break;
            }
            reader.skip(attributeLength);
        }
        String[] superClassAndInterfaceNames = this.hierarchy.get(internalTypeName);
        TypeTypes typeTypes = new TypeTypes();
        typeTypes.thisType = this.makeFromInternalTypeName(internalTypeName);
        if (signature == null) {
            String superTypeName = superClassAndInterfaceNames[0];
            typeTypes.superType = superTypeName == null ? null : this.makeFromInternalTypeName(superTypeName);
            switch (superClassAndInterfaceNames.length) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    typeTypes.interfaces = this.makeFromInternalTypeName(superClassAndInterfaceNames[1]);
                    break;
                }
                default: {
                    int length = superClassAndInterfaceNames.length;
                    UnmodifiableTypes list = new UnmodifiableTypes(length - 1);
                    for (int i = 1; i < length; ++i) {
                        list.add(this.makeFromInternalTypeName(superClassAndInterfaceNames[i]));
                    }
                    typeTypes.interfaces = list;
                    break;
                }
            }
        } else {
            SignatureReader signatureReader = new SignatureReader(signature);
            typeTypes.typeParameters = this.parseTypeParameters(signatureReader);
            typeTypes.superType = this.parseClassTypeSignature(signatureReader, 0);
            ObjectType firstInterface = this.parseClassTypeSignature(signatureReader, 0);
            if (firstInterface != null) {
                ObjectType nextInterface = this.parseClassTypeSignature(signatureReader, 0);
                if (nextInterface == null) {
                    typeTypes.interfaces = firstInterface;
                } else {
                    int length = superClassAndInterfaceNames.length;
                    UnmodifiableTypes list = new UnmodifiableTypes(length - 1);
                    list.add(firstInterface);
                    do {
                        list.add(nextInterface);
                    } while ((nextInterface = this.parseClassTypeSignature(signatureReader, 0)) != null);
                    typeTypes.interfaces = list;
                }
            }
        }
        return typeTypes;
    }

    public void setFieldType(String internalTypeName, String fieldName, Type type) {
        String key = internalTypeName + ':' + fieldName;
        this.internalTypeNameFieldNameToType.put(key, type);
    }

    public Type makeFieldType(String internalTypeName, String fieldName, String descriptor) {
        Type type = this.loadFieldType(internalTypeName, fieldName, descriptor);
        if (type == null) {
            String key = internalTypeName + ':' + fieldName;
            type = this.makeFromSignature(descriptor);
            this.internalTypeNameFieldNameToType.put(key, type);
        }
        return type;
    }

    private Type loadFieldType(String internalTypeName, String fieldName, String descriptor) {
        String key = internalTypeName + ':' + fieldName;
        Type type = this.internalTypeNameFieldNameToType.get(key);
        if (type == null && this.loadFieldsAndMethods(internalTypeName)) {
            TypeTypes typeTypes;
            type = this.internalTypeNameFieldNameToType.get(key);
            if (type == null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null) {
                if (typeTypes.superType != null) {
                    type = this.loadFieldType(typeTypes.superType, fieldName, descriptor);
                }
                if (type == null && typeTypes.interfaces != null) {
                    if (typeTypes.interfaces.isList()) {
                        Type interfaze;
                        Iterator iterator = typeTypes.interfaces.iterator();
                        while (iterator.hasNext() && (type = this.loadFieldType((ObjectType)(interfaze = (Type)iterator.next()), fieldName, descriptor)) == null) {
                        }
                    } else {
                        type = this.loadFieldType((ObjectType)typeTypes.interfaces.getFirst(), fieldName, descriptor);
                    }
                }
            }
            if (type != null) {
                this.internalTypeNameFieldNameToType.put(key, type);
            }
        }
        return type;
    }

    private Type loadFieldType(ObjectType objectType, String fieldName, String descriptor) {
        TypeTypes typeTypes;
        String internalTypeName = objectType.getInternalName();
        BaseTypeArgument typeArguments = objectType.getTypeArguments();
        Type type = this.loadFieldType(internalTypeName, fieldName, descriptor);
        if (type != null && typeArguments != null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null && typeTypes.typeParameters != null) {
            BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
            HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
            if (typeTypes.typeParameters.isList() && typeArguments.isTypeArgumentList()) {
                Iterator iteratorTypeParameter = typeTypes.typeParameters.iterator();
                Iterator iteratorTypeArgument = typeArguments.getTypeArgumentList().iterator();
                while (iteratorTypeParameter.hasNext()) {
                    bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iteratorTypeArgument.next());
                }
            } else {
                bindings.put(((TypeParameter)typeTypes.typeParameters.getFirst()).getIdentifier(), typeArguments.getTypeArgumentFirst());
            }
            bindTypesToTypesVisitor.setBindings(bindings);
            bindTypesToTypesVisitor.init();
            type.accept(bindTypesToTypesVisitor);
            type = (Type)bindTypesToTypesVisitor.getType();
        }
        return type;
    }

    public void setMethodReturnedType(String internalTypeName, String methodName, String descriptor, Type type) {
        this.makeMethodTypes((String)internalTypeName, (String)methodName, (String)descriptor).returnedType = type;
    }

    public MethodTypes makeMethodTypes(String descriptor) {
        return this.parseMethodSignature(descriptor, null);
    }

    public MethodTypes makeMethodTypes(String internalTypeName, String methodName, String descriptor) {
        MethodTypes methodTypes = this.loadMethodTypes(internalTypeName, methodName, descriptor);
        if (methodTypes == null) {
            String key = internalTypeName + ':' + methodName + descriptor;
            methodTypes = this.parseMethodSignature(descriptor, null);
            this.internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
        }
        return methodTypes;
    }

    private MethodTypes loadMethodTypes(String internalTypeName, String methodName, String descriptor) {
        String key = internalTypeName + ':' + methodName + descriptor;
        MethodTypes methodTypes = this.internalTypeNameMethodNameDescriptorToMethodTypes.get(key);
        if (methodTypes == null && this.loadFieldsAndMethods(internalTypeName)) {
            TypeTypes typeTypes;
            methodTypes = this.internalTypeNameMethodNameDescriptorToMethodTypes.get(key);
            if (methodTypes == null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null) {
                if (typeTypes.superType != null) {
                    methodTypes = this.loadMethodTypes(typeTypes.superType, methodName, descriptor);
                }
                if (methodTypes == null && typeTypes.interfaces != null) {
                    if (typeTypes.interfaces.isList()) {
                        Type interfaze;
                        Iterator iterator = typeTypes.interfaces.iterator();
                        while (iterator.hasNext() && (methodTypes = this.loadMethodTypes((ObjectType)(interfaze = (Type)iterator.next()), methodName, descriptor)) == null) {
                        }
                    } else {
                        methodTypes = this.loadMethodTypes((ObjectType)typeTypes.interfaces.getFirst(), methodName, descriptor);
                    }
                }
            }
            if (methodTypes != null) {
                this.internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
            }
        }
        return methodTypes;
    }

    private MethodTypes loadMethodTypes(ObjectType objectType, String methodName, String descriptor) {
        TypeTypes typeTypes;
        String internalTypeName = objectType.getInternalName();
        BaseTypeArgument typeArguments = objectType.getTypeArguments();
        MethodTypes methodTypes = this.loadMethodTypes(internalTypeName, methodName, descriptor);
        if (methodTypes != null && typeArguments != null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null && typeTypes.typeParameters != null) {
            BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
            HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
            MethodTypes newMethodTypes = new MethodTypes();
            if (typeTypes.typeParameters.isList() && typeArguments.isTypeArgumentList()) {
                Iterator iteratorTypeParameter = typeTypes.typeParameters.iterator();
                Iterator iteratorTypeArgument = typeArguments.getTypeArgumentList().iterator();
                while (iteratorTypeParameter.hasNext()) {
                    bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iteratorTypeArgument.next());
                }
            } else {
                bindings.put(((TypeParameter)typeTypes.typeParameters.getFirst()).getIdentifier(), typeArguments.getTypeArgumentFirst());
            }
            bindTypesToTypesVisitor.setBindings(bindings);
            if (methodTypes.parameterTypes == null) {
                newMethodTypes.parameterTypes = null;
            } else {
                bindTypesToTypesVisitor.init();
                methodTypes.parameterTypes.accept(bindTypesToTypesVisitor);
                BaseType baseType = bindTypesToTypesVisitor.getType();
                if (baseType.isList() && baseType.isTypes()) {
                    baseType = new UnmodifiableTypes((Collection<Type>)baseType.getList());
                }
                newMethodTypes.parameterTypes = baseType;
            }
            bindTypesToTypesVisitor.init();
            methodTypes.returnedType.accept(bindTypesToTypesVisitor);
            newMethodTypes.returnedType = (Type)bindTypesToTypesVisitor.getType();
            newMethodTypes.typeParameters = null;
            newMethodTypes.exceptionTypes = methodTypes.exceptionTypes;
            methodTypes = newMethodTypes;
        }
        return methodTypes;
    }

    private ObjectType loadType(String internalTypeName) {
        ObjectType ot;
        block6: {
            ot = this.internalTypeNameToObjectType.get(internalTypeName);
            if (ot == null) {
                try {
                    if (this.loader.canLoad(internalTypeName)) {
                        ot = this.loadType(internalTypeName, this.loader.load(internalTypeName));
                        this.internalTypeNameToObjectType.put(internalTypeName, ot);
                    } else if (this.classPathLoader.canLoad(internalTypeName)) {
                        ot = this.loadType(internalTypeName, this.classPathLoader.load(internalTypeName));
                        this.internalTypeNameToObjectType.put(internalTypeName, ot);
                    }
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block6;
                    throw new AssertionError();
                }
            }
        }
        return ot;
    }

    private ObjectType loadType(String internalTypeName, byte[] data) throws Exception {
        if (data == null) {
            return null;
        }
        ClassFileReader reader = new ClassFileReader(data);
        Object[] constants = this.loadClassFile(internalTypeName, reader);
        TypeMaker.skipMembers(reader);
        TypeMaker.skipMembers(reader);
        String outerTypeName = null;
        ObjectType outerObjectType = null;
        int count = reader.readUnsignedShort();
        block0: for (int i = 0; i < count; ++i) {
            int attributeNameIndex = reader.readUnsignedShort();
            int attributeLength = reader.readInt();
            if ("InnerClasses".equals(constants[attributeNameIndex])) {
                int innerClassesCount = reader.readUnsignedShort();
                for (int j = 0; j < innerClassesCount; ++j) {
                    int innerTypeIndex = reader.readUnsignedShort();
                    int outerTypeIndex = reader.readUnsignedShort();
                    reader.skip(4);
                    Integer cc = (Integer)constants[innerTypeIndex];
                    String innerTypeName = (String)constants[cc];
                    if (!innerTypeName.equals(internalTypeName)) continue;
                    if (outerTypeIndex == 0) {
                        int lastDollar = internalTypeName.lastIndexOf(36);
                        if (lastDollar == -1) break block0;
                        outerTypeName = internalTypeName.substring(0, lastDollar);
                        outerObjectType = this.loadType(outerTypeName);
                        break block0;
                    }
                    cc = (Integer)constants[outerTypeIndex];
                    outerTypeName = (String)constants[cc];
                    outerObjectType = this.loadType(outerTypeName);
                    break block0;
                }
                break;
            }
            reader.skip(attributeLength);
        }
        if (outerObjectType == null) {
            int lastSlash = internalTypeName.lastIndexOf(47);
            String qualifiedName = internalTypeName.replace('/', '.');
            String name = qualifiedName.substring(lastSlash + 1);
            return new ObjectType(internalTypeName, qualifiedName, name);
        }
        int index = internalTypeName.length() > outerTypeName.length() + 1 ? outerTypeName.length() : internalTypeName.lastIndexOf(36);
        String innerName = internalTypeName.substring(index + 1);
        if (Character.isDigit(innerName.charAt(0))) {
            return new InnerObjectType(internalTypeName, null, TypeMaker.extractLocalClassName(innerName), outerObjectType);
        }
        String qualifiedName = outerObjectType.getQualifiedName() + '.' + innerName;
        return new InnerObjectType(internalTypeName, qualifiedName, innerName, outerObjectType);
    }

    private boolean loadFieldsAndMethods(String internalTypeName) {
        block4: {
            try {
                if (this.loader.canLoad(internalTypeName)) {
                    this.loadFieldsAndMethods(internalTypeName, this.loader.load(internalTypeName));
                    return true;
                }
                if (this.classPathLoader.canLoad(internalTypeName)) {
                    this.loadFieldsAndMethods(internalTypeName, this.classPathLoader.load(internalTypeName));
                    return true;
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block4;
                throw new AssertionError();
            }
        }
        return false;
    }

    private void loadFieldsAndMethods(String internalTypeName, byte[] data) throws Exception {
        if (data != null) {
            String signature;
            int descriptorIndex;
            int nameIndex;
            int i;
            ClassFileReader reader = new ClassFileReader(data);
            Object[] constants = this.loadClassFile(internalTypeName, reader);
            int count = reader.readUnsignedShort();
            for (i = 0; i < count; ++i) {
                reader.skip(2);
                nameIndex = reader.readUnsignedShort();
                descriptorIndex = reader.readUnsignedShort();
                signature = null;
                int attributeCount = reader.readUnsignedShort();
                for (int j = 0; j < attributeCount; ++j) {
                    int attributeNameIndex = reader.readUnsignedShort();
                    int attributeLength = reader.readInt();
                    if ("Signature".equals(constants[attributeNameIndex])) {
                        signature = (String)constants[reader.readUnsignedShort()];
                        continue;
                    }
                    reader.skip(attributeLength);
                }
                String name = (String)constants[nameIndex];
                String descriptor = (String)constants[descriptorIndex];
                String key = internalTypeName + ':' + name;
                if (signature == null) {
                    this.internalTypeNameFieldNameToType.put(key, this.makeFromSignature(descriptor));
                    continue;
                }
                this.internalTypeNameFieldNameToType.put(key, this.makeFromSignature(signature));
            }
            count = reader.readUnsignedShort();
            for (i = 0; i < count; ++i) {
                reader.skip(2);
                nameIndex = reader.readUnsignedShort();
                descriptorIndex = reader.readUnsignedShort();
                signature = null;
                String[] exceptionTypeNames = null;
                int attributeCount = reader.readUnsignedShort();
                block11: for (int j = 0; j < attributeCount; ++j) {
                    String name;
                    int attributeNameIndex = reader.readUnsignedShort();
                    int attributeLength = reader.readInt();
                    switch (name = (String)constants[attributeNameIndex]) {
                        case "Signature": {
                            signature = (String)constants[reader.readUnsignedShort()];
                            continue block11;
                        }
                        case "Exceptions": {
                            int exceptionCount = reader.readUnsignedShort();
                            if (exceptionCount <= 0) continue block11;
                            exceptionTypeNames = new String[exceptionCount];
                            for (int k = 0; k < exceptionCount; ++k) {
                                int exceptionClassIndex = reader.readUnsignedShort();
                                Integer cc = (Integer)constants[exceptionClassIndex];
                                exceptionTypeNames[k] = (String)constants[cc];
                            }
                            continue block11;
                        }
                        default: {
                            reader.skip(attributeLength);
                        }
                    }
                }
                String name = (String)constants[nameIndex];
                String descriptor = (String)constants[descriptorIndex];
                String key = internalTypeName + ':' + name + descriptor;
                MethodTypes methodTypes = signature == null ? this.parseMethodSignature(descriptor, exceptionTypeNames) : this.parseMethodSignature(descriptor, signature, exceptionTypeNames);
                this.internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
                int parameterCount = methodTypes.parameterTypes == null ? 0 : methodTypes.parameterTypes.size();
                key = internalTypeName + ':' + name + ':' + parameterCount;
                Set<BaseType> set = this.internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.get(key);
                if (parameterCount > 0) {
                    if (set == null) {
                        set = new HashSet<BaseType>();
                        this.internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.put(key, set);
                    }
                    set.add(methodTypes.parameterTypes);
                    continue;
                }
                if (set != null) continue;
                this.internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.put(key, Collections.emptySet());
            }
        }
    }

    private Object[] loadClassFile(String internalTypeName, ClassFileReader reader) throws Exception {
        String superClassName;
        int magic = reader.readInt();
        if (magic != -889275714) {
            throw new ClassFileFormatException("Invalid CLASS file");
        }
        reader.skip(4);
        Object[] constants = this.loadConstants(reader);
        reader.skip(4);
        int superClassIndex = reader.readUnsignedShort();
        if (superClassIndex == 0) {
            superClassName = null;
        } else {
            Integer cc = (Integer)constants[superClassIndex];
            superClassName = (String)constants[cc];
        }
        int count = reader.readUnsignedShort();
        String[] superClassAndInterfaceNames = new String[count + 1];
        superClassAndInterfaceNames[0] = superClassName;
        for (int i = 1; i <= count; ++i) {
            int interfaceIndex = reader.readUnsignedShort();
            Integer cc = (Integer)constants[interfaceIndex];
            superClassAndInterfaceNames[i] = (String)constants[cc];
        }
        this.hierarchy.put(internalTypeName, superClassAndInterfaceNames);
        return constants;
    }

    private static void skipMembers(ClassFileReader reader) {
        int count = reader.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            reader.skip(6);
            TypeMaker.skipAttributes(reader);
        }
    }

    private Object[] loadConstants(ClassFileReader reader) throws Exception {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            return null;
        }
        Object[] constants = new Object[count];
        block8: for (int i = 1; i < count; ++i) {
            byte tag = reader.readByte();
            switch (tag) {
                case 1: {
                    constants[i] = reader.readUTF8();
                    continue block8;
                }
                case 7: {
                    constants[i] = reader.readUnsignedShort();
                    continue block8;
                }
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    reader.skip(2);
                    continue block8;
                }
                case 15: {
                    reader.skip(3);
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    reader.skip(4);
                    continue block8;
                }
                case 5: 
                case 6: {
                    reader.skip(8);
                    ++i;
                    continue block8;
                }
                default: {
                    throw new ClassFileFormatException("Invalid constant pool entry");
                }
            }
        }
        return constants;
    }

    private static void skipAttributes(ClassFileReader reader) {
        int count = reader.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            reader.skip(2);
            int attributeLength = reader.readInt();
            reader.skip(attributeLength);
        }
    }

    public int matchCount(String internalTypeName, String name, int parameterCount, boolean constructor) {
        String suffixKey = ":" + name + ':' + parameterCount;
        return this.getSetOfParameterTypes(internalTypeName, suffixKey, constructor).size();
    }

    public int matchCount(Map<String, BaseType> typeBounds, String internalTypeName, String name, BaseExpression parameters, boolean constructor) {
        int parameterCount = parameters.size();
        String suffixKey = ":" + name + ':' + parameterCount;
        Set<BaseType> setOfParameterTypes = this.getSetOfParameterTypes(internalTypeName, suffixKey, constructor);
        if (parameterCount == 0) {
            return setOfParameterTypes.size();
        }
        if (setOfParameterTypes.size() <= 1) {
            return setOfParameterTypes.size();
        }
        int counter = 0;
        for (BaseType parameterTypes : setOfParameterTypes) {
            if (!this.match(typeBounds, parameterTypes, parameters)) continue;
            ++counter;
        }
        return counter;
    }

    private Set<BaseType> getSetOfParameterTypes(String internalTypeName, String suffixKey, boolean constructor) {
        String key = internalTypeName + suffixKey;
        Set<BaseType> setOfParameterTypes = this.internalTypeNameMethodNameParameterCountToParameterTypes.get(key);
        if (setOfParameterTypes == null) {
            Set<BaseType> declaredParameterTypes;
            TypeTypes typeTypes;
            setOfParameterTypes = new HashSet<BaseType>();
            if (!constructor && (typeTypes = this.makeTypeTypes(internalTypeName)) != null && typeTypes.superType != null) {
                setOfParameterTypes.addAll(this.getSetOfParameterTypes(typeTypes.superType.getInternalName(), suffixKey, constructor));
            }
            if ((declaredParameterTypes = this.internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.get(key)) == null && this.loadFieldsAndMethods(internalTypeName)) {
                declaredParameterTypes = this.internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.get(key);
            }
            if (declaredParameterTypes != null) {
                setOfParameterTypes.addAll(declaredParameterTypes);
            }
            this.internalTypeNameMethodNameParameterCountToParameterTypes.put(key, setOfParameterTypes);
        }
        return setOfParameterTypes;
    }

    private boolean match(Map<String, BaseType> typeBounds, BaseType parameterTypes, BaseExpression parameters) {
        if (parameterTypes.size() != parameters.size()) {
            return false;
        }
        switch (parameterTypes.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.match(typeBounds, (Type)parameterTypes.getFirst(), ((Expression)parameters.getFirst()).getType());
            }
        }
        Iterator iteratorType = parameterTypes.getList().iterator();
        Iterator iteratorExpression = parameters.getList().iterator();
        while (iteratorType.hasNext()) {
            if (this.match(typeBounds, (Type)iteratorType.next(), ((Expression)iteratorExpression.next()).getType())) continue;
            return false;
        }
        return true;
    }

    private boolean match(Map<String, BaseType> typeBounds, Type leftType, Type rightType) {
        if (leftType.equals(rightType)) {
            return true;
        }
        if (leftType.isPrimitiveType() && rightType.isPrimitiveType()) {
            int flags = ((PrimitiveType)leftType).getFlags() | ((PrimitiveType)rightType).getFlags();
            return flags != 0;
        }
        if (leftType.isObjectType() && rightType.isObjectType()) {
            ObjectType ot1 = (ObjectType)leftType;
            ObjectType ot2 = (ObjectType)rightType;
            return this.isAssignable(typeBounds, ot1, ot2);
        }
        return false;
    }

    static {
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_BOOLEAN.getInternalName(), ObjectType.TYPE_PRIMITIVE_BOOLEAN);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_BYTE.getInternalName(), ObjectType.TYPE_PRIMITIVE_BYTE);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_CHAR.getInternalName(), ObjectType.TYPE_PRIMITIVE_CHAR);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_DOUBLE.getInternalName(), ObjectType.TYPE_PRIMITIVE_DOUBLE);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_FLOAT.getInternalName(), ObjectType.TYPE_PRIMITIVE_FLOAT);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_INT.getInternalName(), ObjectType.TYPE_PRIMITIVE_INT);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_LONG.getInternalName(), ObjectType.TYPE_PRIMITIVE_LONG);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_SHORT.getInternalName(), ObjectType.TYPE_PRIMITIVE_SHORT);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_VOID.getInternalName(), ObjectType.TYPE_PRIMITIVE_VOID);
    }

    private static class ClassPathLoader
    implements Loader {
        protected byte[] buffer = new byte[5120];

        private ClassPathLoader() {
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public byte[] load(String internalName) throws LoaderException {
            InputStream is = this.getClass().getResourceAsStream("/" + internalName + ".class");
            if (is == null) {
                return null;
            }
            try (InputStream in = is;){
                byte[] byArray;
                try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                    int read = in.read(this.buffer);
                    while (read > 0) {
                        out.write(this.buffer, 0, read);
                        read = in.read(this.buffer);
                    }
                    byArray = out.toByteArray();
                }
                return byArray;
            }
            catch (IOException e) {
                throw new LoaderException(e);
            }
        }

        @Override
        public boolean canLoad(String internalName) {
            return this.getClass().getResource("/" + internalName + ".class") != null;
        }
    }

    public static class TypeTypes {
        public ObjectType thisType;
        public BaseTypeParameter typeParameters;
        public ObjectType superType;
        public BaseType interfaces;
    }

    private static class SignatureReader {
        public String signature;
        public char[] array;
        public int length;
        public int index = 0;

        public SignatureReader(String signature) {
            this(signature, 0);
        }

        public SignatureReader(String signature, int index) {
            this.signature = signature;
            this.array = signature.toCharArray();
            this.length = this.array.length;
            this.index = index;
        }

        public char read() {
            return this.array[this.index++];
        }

        public boolean nextEqualsTo(char c) {
            return this.index < this.length && this.array[this.index] == c;
        }

        public boolean search(char c) {
            int length = this.array.length;
            for (int i = this.index; i < length; ++i) {
                if (this.array[i] != c) continue;
                this.index = i;
                return true;
            }
            return false;
        }

        public char searchEndMarker() {
            int length = this.array.length;
            while (this.index < length) {
                char c = this.array[this.index];
                if (c == ';' || c == '<' || c == '.') {
                    return c;
                }
                ++this.index;
            }
            return '\u0000';
        }

        public boolean available() {
            return this.index < this.length;
        }

        public String substring(int beginIndex) {
            return new String(this.array, beginIndex, this.index - beginIndex);
        }

        public String toString() {
            return "SignatureReader{index=" + this.index + ", nextChars=" + new String(this.array, this.index, this.length - this.index) + "}";
        }
    }

    public static class MethodTypes {
        public BaseTypeParameter typeParameters;
        public BaseType parameterTypes;
        public Type returnedType;
        public BaseType exceptionTypes;
    }
}

