/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.ArrayVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.BaseMemberDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.LocalVariableDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.VariableInitializer;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.BinaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.CastExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.ConstructorReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.DoubleConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.EnumConstantReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.FloatConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.IntegerConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LongConstantExpression;
import org.jd.core.v1.model.javasyntax.expression.MethodInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.NewInitializedArray;
import org.jd.core.v1.model.javasyntax.expression.NullExpression;
import org.jd.core.v1.model.javasyntax.expression.ObjectTypeReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperExpression;
import org.jd.core.v1.model.javasyntax.expression.TernaryOperatorExpression;
import org.jd.core.v1.model.javasyntax.expression.ThisExpression;
import org.jd.core.v1.model.javasyntax.expression.TypeReferenceDotClassExpression;
import org.jd.core.v1.model.javasyntax.reference.InnerObjectReference;
import org.jd.core.v1.model.javasyntax.reference.ObjectReference;
import org.jd.core.v1.model.javasyntax.statement.BaseStatement;
import org.jd.core.v1.model.javasyntax.statement.BreakStatement;
import org.jd.core.v1.model.javasyntax.statement.ByteCodeStatement;
import org.jd.core.v1.model.javasyntax.statement.ContinueStatement;
import org.jd.core.v1.model.javasyntax.statement.ReturnExpressionStatement;
import org.jd.core.v1.model.javasyntax.statement.ThrowStatement;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileStaticInitializerDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileMethodInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileNewExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.expression.ClassFileSuperConstructorInvocationExpression;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.util.DefaultList;

public class AddCastExpressionVisitor
extends AbstractJavaSyntaxVisitor {
    protected SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    protected TypeMaker typeMaker;
    protected Map<String, BaseType> typeBounds;
    protected Type returnedType;
    protected BaseType exceptionTypes;
    protected Type type;

    public AddCastExpressionVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        BaseMemberDeclaration memberDeclarations = declaration.getMemberDeclarations();
        if (memberDeclarations != null) {
            Map<String, BaseType> tb = this.typeBounds;
            this.typeBounds = ((ClassFileBodyDeclaration)declaration).getTypeBounds();
            memberDeclarations.accept(this);
            this.typeBounds = tb;
        }
    }

    @Override
    public void visit(FieldDeclaration declaration) {
        if ((declaration.getFlags() & 0x1000) == 0) {
            Type t = this.type;
            this.type = declaration.getType();
            declaration.getFieldDeclarators().accept(this);
            this.type = t;
        }
    }

    @Override
    public void visit(FieldDeclarator declarator) {
        VariableInitializer variableInitializer = declarator.getVariableInitializer();
        if (variableInitializer != null) {
            int extraDimension = declarator.getDimension();
            if (extraDimension == 0) {
                variableInitializer.accept(this);
            } else {
                Type t = this.type;
                this.type = this.type.createType(this.type.getDimension() + extraDimension);
                variableInitializer.accept(this);
                this.type = t;
            }
        }
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
        BaseStatement statements = declaration.getStatements();
        if (statements != null) {
            Map<String, BaseType> tb = this.typeBounds;
            this.typeBounds = ((ClassFileStaticInitializerDeclaration)declaration).getTypeBounds();
            statements.accept(this);
            this.typeBounds = tb;
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        BaseStatement statements;
        if ((declaration.getFlags() & 0x1040) == 0 && (statements = declaration.getStatements()) != null) {
            Map<String, BaseType> tb = this.typeBounds;
            BaseType et = this.exceptionTypes;
            this.typeBounds = ((ClassFileConstructorDeclaration)declaration).getTypeBounds();
            this.exceptionTypes = declaration.getExceptionTypes();
            statements.accept(this);
            this.typeBounds = tb;
            this.exceptionTypes = et;
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        BaseStatement statements;
        if ((declaration.getFlags() & 0x1040) == 0 && (statements = declaration.getStatements()) != null) {
            Map<String, BaseType> tb = this.typeBounds;
            Type rt = this.returnedType;
            BaseType et = this.exceptionTypes;
            this.typeBounds = ((ClassFileMethodDeclaration)declaration).getTypeBounds();
            this.returnedType = declaration.getReturnedType();
            this.exceptionTypes = declaration.getExceptionTypes();
            statements.accept(this);
            this.typeBounds = tb;
            this.returnedType = rt;
            this.exceptionTypes = et;
        }
    }

    @Override
    public void visit(LambdaIdentifiersExpression expression) {
        BaseStatement statements = expression.getStatements();
        if (statements != null) {
            Type rt = this.returnedType;
            this.returnedType = ObjectType.TYPE_OBJECT;
            statements.accept(this);
            this.returnedType = rt;
        }
    }

    @Override
    public void visit(ReturnExpressionStatement statement) {
        statement.setExpression(this.updateExpression(this.returnedType, statement.getExpression(), false, true));
    }

    @Override
    public void visit(ThrowStatement statement) {
        Type exceptionType;
        if (this.exceptionTypes != null && this.exceptionTypes.size() == 1 && (exceptionType = (Type)this.exceptionTypes.getFirst()).isGenericType() && !statement.getExpression().getType().equals(exceptionType)) {
            statement.setExpression(this.addCastExpression(exceptionType, statement.getExpression()));
        }
    }

    @Override
    public void visit(LocalVariableDeclaration declaration) {
        Type t = this.type;
        this.type = declaration.getType();
        declaration.getLocalVariableDeclarators().accept(this);
        this.type = t;
    }

    @Override
    public void visit(LocalVariableDeclarator declarator) {
        VariableInitializer variableInitializer = declarator.getVariableInitializer();
        if (variableInitializer != null) {
            int extraDimension = declarator.getDimension();
            if (extraDimension == 0) {
                variableInitializer.accept(this);
            } else {
                Type t = this.type;
                this.type = this.type.createType(this.type.getDimension() + extraDimension);
                variableInitializer.accept(this);
                this.type = t;
            }
        }
    }

    @Override
    public void visit(ArrayVariableInitializer declaration) {
        if (this.type.getDimension() == 0) {
            this.acceptListDeclaration(declaration);
        } else {
            Type t = this.type;
            this.type = this.type.createType(this.type.getDimension() - 1);
            this.acceptListDeclaration(declaration);
            this.type = t;
        }
    }

    @Override
    public void visit(ExpressionVariableInitializer declaration) {
        Expression expression = declaration.getExpression();
        if (expression.isNewInitializedArray()) {
            NewInitializedArray nia = (NewInitializedArray)expression;
            Type t = this.type;
            this.type = nia.getType();
            nia.getArrayInitializer().accept(this);
            this.type = t;
        } else {
            declaration.setExpression(this.updateExpression(this.type, expression, false, true));
        }
    }

    @Override
    public void visit(SuperConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean unique = this.typeMaker.matchCount(expression.getObjectType().getInternalName(), "<init>", parameters.size(), true) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(this.typeBounds, expression.getObjectType().getInternalName(), "<init>", parameters, true) > 1;
            expression.setParameters(this.updateParameters(((ClassFileSuperConstructorInvocationExpression)expression).getParameterTypes(), parameters, forceCast, unique));
        }
    }

    @Override
    public void visit(ConstructorInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean unique = this.typeMaker.matchCount(expression.getObjectType().getInternalName(), "<init>", parameters.size(), true) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(this.typeBounds, expression.getObjectType().getInternalName(), "<init>", parameters, true) > 1;
            expression.setParameters(this.updateParameters(((ClassFileConstructorInvocationExpression)expression).getParameterTypes(), parameters, forceCast, unique));
        }
    }

    @Override
    public void visit(MethodInvocationExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null && parameters.size() > 0) {
            boolean unique = this.typeMaker.matchCount(expression.getInternalTypeName(), expression.getName(), parameters.size(), false) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(this.typeBounds, expression.getInternalTypeName(), expression.getName(), parameters, false) > 1;
            expression.setParameters(this.updateParameters(((ClassFileMethodInvocationExpression)expression).getParameterTypes(), parameters, forceCast, unique));
        }
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(NewExpression expression) {
        BaseExpression parameters = expression.getParameters();
        if (parameters != null) {
            boolean unique = this.typeMaker.matchCount(expression.getObjectType().getInternalName(), "<init>", parameters.size(), true) <= 1;
            boolean forceCast = !unique && this.typeMaker.matchCount(this.typeBounds, expression.getObjectType().getInternalName(), "<init>", parameters, true) > 1;
            expression.setParameters(this.updateParameters(((ClassFileNewExpression)expression).getParameterTypes(), parameters, forceCast, unique));
        }
    }

    @Override
    public void visit(NewInitializedArray expression) {
        ArrayVariableInitializer arrayInitializer = expression.getArrayInitializer();
        if (arrayInitializer != null) {
            Type t = this.type;
            this.type = expression.getType();
            arrayInitializer.accept(this);
            this.type = t;
        }
    }

    @Override
    public void visit(FieldReferenceExpression expression) {
        ObjectType type;
        Expression exp = expression.getExpression();
        if (exp != null && !exp.isObjectTypeReferenceExpression() && (type = this.typeMaker.makeFromInternalTypeName(expression.getInternalTypeName())).getName() != null) {
            expression.setExpression(this.updateExpression(type, exp, false, true));
        }
    }

    @Override
    public void visit(BinaryOperatorExpression expression) {
        expression.getLeftExpression().accept(this);
        Expression rightExpression = expression.getRightExpression();
        if (expression.getOperator().equals("=")) {
            ClassFileMethodInvocationExpression mie;
            if (rightExpression.isMethodInvocationExpression() && (mie = (ClassFileMethodInvocationExpression)rightExpression).getTypeParameters() != null) {
                rightExpression.accept(this);
                return;
            }
            expression.setRightExpression(this.updateExpression(expression.getLeftExpression().getType(), rightExpression, false, true));
            return;
        }
        rightExpression.accept(this);
    }

    @Override
    public void visit(TernaryOperatorExpression expression) {
        Type expressionType = expression.getType();
        expression.getCondition().accept(this);
        expression.setTrueExpression(this.updateExpression(expressionType, expression.getTrueExpression(), false, true));
        expression.setFalseExpression(this.updateExpression(expressionType, expression.getFalseExpression(), false, true));
    }

    protected BaseExpression updateParameters(BaseType types, BaseExpression expressions, boolean forceCast, boolean unique) {
        if (expressions != null) {
            if (expressions.isList()) {
                DefaultList typeList = types.getList();
                DefaultList expressionList = expressions.getList();
                for (int i = expressionList.size() - 1; i >= 0; --i) {
                    expressionList.set(i, this.updateParameter((Type)typeList.get(i), (Expression)expressionList.get(i), forceCast, unique));
                }
            } else {
                expressions = this.updateParameter((Type)types.getFirst(), (Expression)expressions.getFirst(), forceCast, unique);
            }
        }
        return expressions;
    }

    private Expression updateParameter(Type type, Expression expression, boolean forceCast, boolean unique) {
        expression = this.updateExpression(type, expression, forceCast, unique);
        if (type == PrimitiveType.TYPE_BYTE) {
            if (expression.isIntegerConstantExpression()) {
                expression = new CastExpression(PrimitiveType.TYPE_BYTE, expression);
            } else if (expression.isTernaryOperatorExpression()) {
                Expression exp = expression.getTrueExpression();
                if (exp.isIntegerConstantExpression() || exp.isTernaryOperatorExpression()) {
                    expression = new CastExpression(PrimitiveType.TYPE_BYTE, expression);
                } else {
                    exp = expression.getFalseExpression();
                    if (exp.isIntegerConstantExpression() || exp.isTernaryOperatorExpression()) {
                        expression = new CastExpression(PrimitiveType.TYPE_BYTE, expression);
                    }
                }
            }
        }
        return expression;
    }

    private Expression updateExpression(Type type, Expression expression, boolean forceCast, boolean unique) {
        if (expression.isNullExpression()) {
            if (forceCast) {
                this.searchFirstLineNumberVisitor.init();
                expression.accept(this.searchFirstLineNumberVisitor);
                expression = new CastExpression(this.searchFirstLineNumberVisitor.getLineNumber(), type, expression);
            }
        } else {
            Type expressionType = expression.getType();
            if (!expressionType.equals(type)) {
                if (type.isObjectType()) {
                    if (expressionType.isObjectType()) {
                        ObjectType objectType = (ObjectType)type;
                        ObjectType expressionObjectType = (ObjectType)expressionType;
                        if (forceCast && !objectType.rawEquals(expressionObjectType)) {
                            if (expression.isNewExpression()) {
                                ClassFileNewExpression ne = (ClassFileNewExpression)expression;
                                ne.setObjectType(ne.getObjectType().createType(null));
                            }
                            expression = this.addCastExpression(objectType, expression);
                        } else if (!ObjectType.TYPE_OBJECT.equals(type) && !this.typeMaker.isAssignable(this.typeBounds, objectType, expressionObjectType)) {
                            BaseTypeArgument ta1 = objectType.getTypeArguments();
                            BaseTypeArgument ta2 = expressionObjectType.getTypeArguments();
                            Type t = type;
                            if (ta1 != null && ta2 != null && !ta1.isTypeArgumentAssignableFrom(this.typeBounds, ta2)) {
                                t = objectType.createType(null);
                            }
                            expression = this.addCastExpression(t, expression);
                        }
                    } else if (expressionType.isGenericType() && !ObjectType.TYPE_OBJECT.equals(type)) {
                        expression = this.addCastExpression(type, expression);
                    }
                } else if (type.isGenericType() && (expressionType.isObjectType() || expressionType.isGenericType())) {
                    expression = this.addCastExpression(type, expression);
                }
            }
            if (expression.isCastExpression()) {
                Type ceExpressionType = expression.getExpression().getType();
                if (type.isObjectType() && ceExpressionType.isObjectType()) {
                    ObjectType ot1 = (ObjectType)type;
                    ObjectType ot2 = (ObjectType)ceExpressionType;
                    if (ot1.equals(ot2)) {
                        expression = expression.getExpression();
                    } else if (unique && this.typeMaker.isAssignable(this.typeBounds, ot1, ot2)) {
                        expression = expression.getExpression();
                    }
                }
            }
            expression.accept(this);
        }
        return expression;
    }

    private Expression addCastExpression(Type type, Expression expression) {
        if (expression.isCastExpression()) {
            if (type.equals(expression.getExpression().getType())) {
                return expression.getExpression();
            }
            CastExpression ce = (CastExpression)expression;
            ce.setType(type);
            return ce;
        }
        this.searchFirstLineNumberVisitor.init();
        expression.accept(this.searchFirstLineNumberVisitor);
        return new CastExpression(this.searchFirstLineNumberVisitor.getLineNumber(), type, expression);
    }

    @Override
    public void visit(FloatConstantExpression expression) {
    }

    @Override
    public void visit(IntegerConstantExpression expression) {
    }

    @Override
    public void visit(ConstructorReferenceExpression expression) {
    }

    @Override
    public void visit(DoubleConstantExpression expression) {
    }

    @Override
    public void visit(EnumConstantReferenceExpression expression) {
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
    }

    @Override
    public void visit(LongConstantExpression expression) {
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ByteCodeStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(NullExpression expression) {
    }

    @Override
    public void visit(ObjectTypeReferenceExpression expression) {
    }

    @Override
    public void visit(SuperExpression expression) {
    }

    @Override
    public void visit(ThisExpression expression) {
    }

    @Override
    public void visit(TypeReferenceDotClassExpression expression) {
    }

    @Override
    public void visit(ObjectReference reference) {
    }

    @Override
    public void visit(InnerObjectReference reference) {
    }

    @Override
    public void visit(TypeArguments type) {
    }

    @Override
    public void visit(WildcardExtendsTypeArgument type) {
    }

    @Override
    public void visit(ObjectType type) {
    }

    @Override
    public void visit(InnerObjectType type) {
    }

    @Override
    public void visit(WildcardSuperTypeArgument type) {
    }

    @Override
    public void visit(Types list) {
    }

    @Override
    public void visit(TypeParameterWithTypeBounds type) {
    }
}

