/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ExpressionVariableInitializer;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.FieldReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.LocalVariableReferenceExpression;
import org.jd.core.v1.model.javasyntax.expression.NewExpression;
import org.jd.core.v1.model.javasyntax.expression.SuperConstructorInvocationExpression;
import org.jd.core.v1.model.javasyntax.statement.Statement;
import org.jd.core.v1.model.javasyntax.statement.Statements;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.SearchFirstLineNumberVisitor;
import org.jd.core.v1.util.DefaultList;

public class InitInstanceFieldVisitor
extends AbstractJavaSyntaxVisitor {
    protected SearchFirstLineNumberVisitor searchFirstLineNumberVisitor = new SearchFirstLineNumberVisitor();
    protected HashMap<String, FieldDeclarator> fieldDeclarators = new HashMap();
    protected DefaultList<Data> datas = new DefaultList();
    protected DefaultList<Expression> putFields = new DefaultList();
    protected int lineNumber = 0;
    protected boolean containsLocalVariableReference;

    @Override
    public void visit(AnnotationDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(EnumDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.fieldDeclarators.clear();
        this.datas.clear();
        this.putFields.clear();
        this.safeAcceptListDeclaration(bodyDeclaration.getFieldDeclarations());
        this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        this.updateFieldsAndConstructors();
    }

    @Override
    public void visit(FieldDeclaration declaration) {
        if ((declaration.getFlags() & 8) == 0) {
            declaration.getFieldDeclarators().accept(this);
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        Statements statements;
        ListIterator<Statement> iterator;
        SuperConstructorInvocationExpression superConstructorCall;
        ClassFileConstructorDeclaration cfcd = (ClassFileConstructorDeclaration)declaration;
        if (cfcd.getStatements() != null && cfcd.getStatements().isStatements() && (superConstructorCall = this.searchSuperConstructorCall(iterator = (statements = (Statements)cfcd.getStatements()).listIterator())) != null) {
            String internalTypeName = cfcd.getClassFile().getInternalTypeName();
            this.datas.add(new Data(cfcd, statements, iterator.nextIndex()));
            if (this.datas.size() == 1) {
                int firstLineNumber;
                if ((cfcd.getFlags() & 0x1000) != 0) {
                    firstLineNumber = 0;
                } else {
                    firstLineNumber = superConstructorCall.getLineNumber();
                    if (superConstructorCall.getDescriptor().equals("()V") && firstLineNumber != 0 && iterator.hasNext() && (this.lineNumber == 0 || this.lineNumber >= firstLineNumber)) {
                        this.searchFirstLineNumberVisitor.init();
                        iterator.next().accept(this.searchFirstLineNumberVisitor);
                        iterator.previous();
                        int ln = this.searchFirstLineNumberVisitor.getLineNumber();
                        if (ln != 0 && ln >= firstLineNumber) {
                            firstLineNumber = 0;
                        }
                    }
                }
                this.initPutFields(internalTypeName, firstLineNumber, iterator);
            } else {
                this.filterPutFields(internalTypeName, iterator);
            }
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        this.lineNumber = ((ClassFileMethodDeclaration)declaration).getFirstLineNumber();
    }

    @Override
    public void visit(NewExpression expression) {
        this.safeAccept(expression.getParameters());
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    @Override
    public void visit(FieldDeclarator declaration) {
        this.fieldDeclarators.put(declaration.getName(), declaration);
    }

    @Override
    public void visit(LocalVariableReferenceExpression expression) {
        this.containsLocalVariableReference = true;
    }

    protected SuperConstructorInvocationExpression searchSuperConstructorCall(ListIterator<Statement> iterator) {
        while (iterator.hasNext()) {
            Expression expression = iterator.next().getExpression();
            if (expression.isSuperConstructorInvocationExpression()) {
                return (SuperConstructorInvocationExpression)expression;
            }
            if (!expression.isConstructorInvocationExpression()) continue;
            break;
        }
        return null;
    }

    protected void initPutFields(String internalTypeName, int firstLineNumber, ListIterator<Statement> iterator) {
        String fieldName;
        FieldReferenceExpression fre;
        Statement statement;
        HashSet<String> fieldNames = new HashSet<String>();
        Expression expression = null;
        while (iterator.hasNext() && (statement = iterator.next()).isExpressionStatement() && (expression = statement.getExpression()).isBinaryOperatorExpression() && expression.getOperator().equals("=") && expression.getLeftExpression().isFieldReferenceExpression() && (fre = (FieldReferenceExpression)expression.getLeftExpression()).getInternalTypeName().equals(internalTypeName) && fre.getExpression().isThisExpression() && !fieldNames.contains(fieldName = fre.getName())) {
            this.containsLocalVariableReference = false;
            expression.getRightExpression().accept(this);
            if (this.containsLocalVariableReference) break;
            this.putFields.add(expression);
            fieldNames.add(fieldName);
            expression = null;
        }
        int lastLineNumber = expression == null ? (firstLineNumber == 0 ? 0 : firstLineNumber + 1) : expression.getLineNumber();
        if (firstLineNumber < lastLineNumber) {
            Iterator ite = this.putFields.iterator();
            while (ite.hasNext()) {
                int lineNumber = ((Expression)ite.next()).getLineNumber();
                if (firstLineNumber > lineNumber || lastLineNumber > lastLineNumber) continue;
                if (lastLineNumber == lastLineNumber) {
                    ++lastLineNumber;
                }
                ite.remove();
            }
        }
    }

    protected void filterPutFields(String internalTypeName, ListIterator<Statement> iterator) {
        FieldReferenceExpression fre;
        Expression expression;
        Iterator putFieldIterator = this.putFields.iterator();
        int index = 0;
        while (iterator.hasNext() && putFieldIterator.hasNext() && (expression = iterator.next().getExpression()).isBinaryOperatorExpression() && expression.getOperator().equals("=") && expression.getLeftExpression().isFieldReferenceExpression() && (fre = (FieldReferenceExpression)expression.getLeftExpression()).getInternalTypeName().equals(internalTypeName)) {
            Expression putField = (Expression)putFieldIterator.next();
            if (expression.getLineNumber() != putField.getLineNumber() || !fre.getName().equals(putField.getLeftExpression().getName())) break;
            ++index;
        }
        if (index < this.putFields.size()) {
            this.putFields.subList(index, this.putFields.size()).clear();
        }
    }

    protected void updateFieldsAndConstructors() {
        int count = this.putFields.size();
        if (count > 0) {
            for (Expression putField : this.putFields) {
                FieldDeclarator declaration = this.fieldDeclarators.get(putField.getLeftExpression().getName());
                if (declaration == null) continue;
                Expression expression = putField.getRightExpression();
                declaration.setVariableInitializer(new ExpressionVariableInitializer(expression));
                ((ClassFileFieldDeclaration)declaration.getFieldDeclaration()).setFirstLineNumber(expression.getLineNumber());
            }
            for (Data data : this.datas) {
                data.statements.subList(data.index, data.index + count).clear();
                if (data.statements.isEmpty()) {
                    data.declaration.setStatements(null);
                    data.declaration.setFirstLineNumber(0);
                    continue;
                }
                this.searchFirstLineNumberVisitor.init();
                this.searchFirstLineNumberVisitor.visit(data.statements);
                int firstLineNumber = this.searchFirstLineNumberVisitor.getLineNumber();
                data.declaration.setFirstLineNumber(firstLineNumber == -1 ? 0 : firstLineNumber);
            }
        }
    }

    protected static final class Data {
        public ClassFileConstructorDeclaration declaration;
        public Statements statements;
        public int index;

        public Data(ClassFileConstructorDeclaration declaration, Statements statements, int index) {
            this.declaration = declaration;
            this.statements = statements;
            this.index = index;
        }
    }
}

