/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import org.jd.core.v1.model.classfile.ConstantPool;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.constant.ConstantMemberRef;
import org.jd.core.v1.model.classfile.constant.ConstantNameAndType;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileMethodDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class UpdateBridgeMethodTypeVisitor
extends AbstractJavaSyntaxVisitor {
    protected TypeMaker typeMaker;

    public UpdateBridgeMethodTypeVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        this.safeAcceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
    }

    @Override
    public void visit(MethodDeclaration declaration) {
        TypeMaker.TypeTypes typeTypes;
        if (declaration.isStatic() && declaration.getReturnedType().isObjectType() && declaration.getName().startsWith("access$") && (typeTypes = this.typeMaker.makeTypeTypes(declaration.getReturnedType().getInternalName())) != null && typeTypes.typeParameters != null) {
            ClassFileMethodDeclaration cfmd = (ClassFileMethodDeclaration)declaration;
            Method method = cfmd.getMethod();
            byte[] code = ((AttributeCode)method.getAttribute("Code")).getCode();
            int offset = 0;
            int opcode = code[offset] & 0xFF;
            while (21 <= opcode && opcode <= 45 || 89 <= opcode && opcode <= 95) {
                opcode = code[++offset] & 0xFF;
            }
            switch (opcode) {
                case 178: 
                case 179: 
                case 180: 
                case 181: {
                    int index = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    ConstantPool constants = method.getConstants();
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
                    String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    Type type = this.typeMaker.makeFieldType(typeName, name, descriptor);
                    this.typeMaker.setMethodReturnedType(typeName, cfmd.getName(), cfmd.getDescriptor(), type);
                    break;
                }
                case 182: 
                case 183: 
                case 184: 
                case 185: {
                    int index = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
                    ConstantPool constants = method.getConstants();
                    ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
                    String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
                    ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
                    String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
                    String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
                    TypeMaker.MethodTypes methodTypes = this.typeMaker.makeMethodTypes(typeName, name, descriptor);
                    this.typeMaker.setMethodReturnedType(typeName, cfmd.getName(), cfmd.getDescriptor(), methodTypes.returnedType);
                }
            }
        }
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
    }

    @Override
    public void visit(EnumDeclaration declaration) {
    }
}

