/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import org.jd.core.v1.model.classfile.ConstantPool;
import org.jd.core.v1.model.classfile.Method;
import org.jd.core.v1.model.classfile.attribute.AttributeCode;
import org.jd.core.v1.model.classfile.constant.ConstantMemberRef;
import org.jd.core.v1.model.classfile.constant.ConstantNameAndType;
import org.jd.core.v1.model.javasyntax.AbstractJavaSyntaxVisitor;
import org.jd.core.v1.model.javasyntax.declaration.AnnotationDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.BodyDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ClassDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.ConstructorDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.EnumDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.FieldDeclarator;
import org.jd.core.v1.model.javasyntax.declaration.InterfaceDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.MethodDeclaration;
import org.jd.core.v1.model.javasyntax.declaration.StaticInitializerDeclaration;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileBodyDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileConstructorDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.model.javasyntax.declaration.ClassFileFieldDeclaration;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.TypeMaker;

public class UpdateOuterFieldTypeVisitor
extends AbstractJavaSyntaxVisitor {
    protected TypeMaker typeMaker;
    protected SearchFieldVisitor searchFieldVisitor = new SearchFieldVisitor();

    public UpdateOuterFieldTypeVisitor(TypeMaker typeMaker) {
        this.typeMaker = typeMaker;
    }

    @Override
    public void visit(BodyDeclaration declaration) {
        ClassFileBodyDeclaration bodyDeclaration = (ClassFileBodyDeclaration)declaration;
        if (!bodyDeclaration.getClassFile().isStatic()) {
            this.safeAcceptListDeclaration(bodyDeclaration.getMethodDeclarations());
        }
        this.safeAcceptListDeclaration(bodyDeclaration.getInnerTypeDeclarations());
    }

    @Override
    public void visit(ConstructorDeclaration declaration) {
        ClassFileConstructorDeclaration cfcd;
        if (!declaration.isStatic() && (cfcd = (ClassFileConstructorDeclaration)declaration).getClassFile().getOuterClassFile() != null && !declaration.isStatic()) {
            int offset;
            Method method = cfcd.getMethod();
            byte[] code = ((AttributeCode)method.getAttribute("Code")).getCode();
            int opcode = code[offset = 0] & 0xFF;
            if (opcode != 42) {
                return;
            }
            if ((opcode = code[++offset] & 0xFF) != 43) {
                return;
            }
            if ((opcode = code[++offset] & 0xFF) != 181) {
                return;
            }
            int index = (code[++offset] & 0xFF) << 8 | code[++offset] & 0xFF;
            ConstantPool constants = method.getConstants();
            ConstantMemberRef constantMemberRef = (ConstantMemberRef)constants.getConstant(index);
            String typeName = constants.getConstantTypeName(constantMemberRef.getClassIndex());
            ConstantNameAndType constantNameAndType = (ConstantNameAndType)constants.getConstant(constantMemberRef.getNameAndTypeIndex());
            String descriptor = constants.getConstantUtf8(constantNameAndType.getDescriptorIndex());
            TypeMaker.TypeTypes typeTypes = this.typeMaker.makeTypeTypes(descriptor.substring(1, descriptor.length() - 1));
            if (typeTypes != null && typeTypes.typeParameters != null) {
                String name = constants.getConstantUtf8(constantNameAndType.getNameIndex());
                this.searchFieldVisitor.init(name);
                for (ClassFileFieldDeclaration field : cfcd.getBodyDeclaration().getFieldDeclarations()) {
                    BaseTypeArgument typeArguments;
                    field.getFieldDeclarators().accept(this.searchFieldVisitor);
                    if (!this.searchFieldVisitor.found()) continue;
                    if (typeTypes.typeParameters.isList()) {
                        TypeArguments tas = new TypeArguments(typeTypes.typeParameters.size());
                        for (TypeParameter typeParameter : typeTypes.typeParameters) {
                            tas.add(new GenericType(typeParameter.getIdentifier()));
                        }
                        typeArguments = tas;
                    } else {
                        typeArguments = new GenericType(((TypeParameter)typeTypes.typeParameters.getFirst()).getIdentifier());
                    }
                    this.typeMaker.setFieldType(typeName, name, typeTypes.thisType.createType(typeArguments));
                    break;
                }
            }
        }
    }

    @Override
    public void visit(MethodDeclaration declaration) {
    }

    @Override
    public void visit(StaticInitializerDeclaration declaration) {
    }

    @Override
    public void visit(ClassDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(InterfaceDeclaration declaration) {
        this.safeAccept(declaration.getBodyDeclaration());
    }

    @Override
    public void visit(AnnotationDeclaration declaration) {
    }

    @Override
    public void visit(EnumDeclaration declaration) {
    }

    protected static class SearchFieldVisitor
    extends AbstractJavaSyntaxVisitor {
        protected String name;
        protected boolean found;

        protected SearchFieldVisitor() {
        }

        public void init(String name) {
            this.name = name;
            this.found = false;
        }

        public boolean found() {
            return this.found;
        }

        @Override
        public void visit(FieldDeclarator declaration) {
            this.found |= declaration.getName().equals(this.name);
        }
    }
}

