/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class DefaultList<E>
extends ArrayList<E> {
    protected static final EmptyList EMPTY_LIST = new EmptyList();

    public DefaultList() {
    }

    public DefaultList(int capacity) {
        super(capacity);
    }

    public DefaultList(Collection<E> collection) {
        super(collection);
    }

    public DefaultList(E element, E ... elements) {
        this.ensureCapacity(elements.length + 1);
        this.add(element);
        for (E e : elements) {
            this.add(e);
        }
    }

    public DefaultList(E[] elements) {
        if (elements != null && elements.length > 0) {
            this.ensureCapacity(elements.length);
            for (E e : elements) {
                this.add(e);
            }
        }
    }

    @Override
    public E getFirst() {
        return this.get(0);
    }

    @Override
    public E getLast() {
        return this.get(this.size() - 1);
    }

    @Override
    public E removeFirst() {
        return this.remove(0);
    }

    @Override
    public E removeLast() {
        return this.remove(this.size() - 1);
    }

    public boolean isList() {
        return true;
    }

    public DefaultList<E> getList() {
        return this;
    }

    public static <T> DefaultList<T> emptyList() {
        return EMPTY_LIST;
    }

    protected static class EmptyList<E>
    extends DefaultList<E>
    implements Iterator<E> {
        public EmptyList() {
            super(0);
        }

        @Override
        public E set(int index, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

