/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.model.container;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jd.gui.api.model.Container;

public class DelegatingFilterContainer
implements Container {
    protected static final URI DEFAULT_ROOT_URI = URI.create("file:.");
    protected Container container;
    protected DelegatedEntry root;
    protected Set<URI> validEntries = new HashSet<URI>();
    protected Map<URI, DelegatedEntry> uriToDelegatedEntry = new HashMap<URI, DelegatedEntry>();
    protected Map<URI, DelegatedContainer> uriToDelegatedContainer = new HashMap<URI, DelegatedContainer>();

    public DelegatingFilterContainer(Container container, Collection<Container.Entry> entries) {
        this.container = container;
        this.root = this.getDelegatedEntry(container.getRoot());
        Iterator<Container.Entry> iterator = entries.iterator();
        while (iterator.hasNext()) {
            for (Container.Entry entry = iterator.next(); entry != null && !this.validEntries.contains(entry.getUri()); entry = entry.getParent()) {
                this.validEntries.add(entry.getUri());
            }
        }
    }

    @Override
    public String getType() {
        return this.container.getType();
    }

    @Override
    public Container.Entry getRoot() {
        return this.root;
    }

    public Container.Entry getEntry(URI uri) {
        return this.uriToDelegatedEntry.get(uri);
    }

    public Set<URI> getUris() {
        return this.validEntries;
    }

    protected DelegatedEntry getDelegatedEntry(Container.Entry entry) {
        URI uri = entry.getUri();
        DelegatedEntry delegatedEntry = this.uriToDelegatedEntry.get(uri);
        if (delegatedEntry == null) {
            delegatedEntry = new DelegatedEntry(entry);
            this.uriToDelegatedEntry.put(uri, delegatedEntry);
        }
        return delegatedEntry;
    }

    protected DelegatedContainer getDelegatedContainer(Container container) {
        Container.Entry root = container.getRoot();
        URI uri = root == null ? DEFAULT_ROOT_URI : root.getUri();
        DelegatedContainer delegatedContainer = this.uriToDelegatedContainer.get(uri);
        if (delegatedContainer == null) {
            delegatedContainer = new DelegatedContainer(container);
            this.uriToDelegatedContainer.put(uri, delegatedContainer);
        }
        return delegatedContainer;
    }

    protected class DelegatedEntry
    implements Container.Entry,
    Comparable<DelegatedEntry> {
        protected Container.Entry entry;
        protected Collection<Container.Entry> children;

        public DelegatedEntry(Container.Entry entry) {
            this.entry = entry;
        }

        @Override
        public Container getContainer() {
            return DelegatingFilterContainer.this.getDelegatedContainer(this.entry.getContainer());
        }

        @Override
        public Container.Entry getParent() {
            return DelegatingFilterContainer.this.getDelegatedEntry(this.entry.getParent());
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }

        @Override
        public String getPath() {
            return this.entry.getPath();
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public long length() {
            return this.entry.length();
        }

        @Override
        public InputStream getInputStream() {
            return this.entry.getInputStream();
        }

        @Override
        public Collection<Container.Entry> getChildren() {
            if (this.children == null) {
                this.children = new ArrayList<Container.Entry>();
                for (Container.Entry child : this.entry.getChildren()) {
                    if (!DelegatingFilterContainer.this.validEntries.contains(child.getUri())) continue;
                    this.children.add(DelegatingFilterContainer.this.getDelegatedEntry(child));
                }
            }
            return this.children;
        }

        @Override
        public int compareTo(DelegatedEntry other) {
            if (this.entry.isDirectory()) {
                if (!other.isDirectory()) {
                    return -1;
                }
            } else if (other.isDirectory()) {
                return 1;
            }
            return this.entry.getPath().compareTo(other.getPath());
        }
    }

    protected class DelegatedContainer
    implements Container {
        protected Container container;

        public DelegatedContainer(Container container) {
            this.container = container;
        }

        @Override
        public String getType() {
            return this.container.getType();
        }

        @Override
        public Container.Entry getRoot() {
            return DelegatingFilterContainer.this.getDelegatedEntry(this.container.getRoot());
        }
    }
}

