/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.fileloader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.jd.gui.api.API;
import org.jd.gui.service.fileloader.AbstractTypeFileLoaderProvider;
import org.jd.gui.util.exception.ExceptionUtil;
import org.objectweb.asm.ClassReader;

public class ClassFileLoaderProvider
extends AbstractTypeFileLoaderProvider {
    protected static final String[] EXTENSIONS = new String[]{"class"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getDescription() {
        return "Class files (*.class)";
    }

    @Override
    public boolean accept(API api, File file) {
        return file.exists() && file.isFile() && file.canRead() && file.getName().toLowerCase().endsWith(".class");
    }

    @Override
    public boolean load(API api, File file) {
        boolean bl;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        try {
            ClassReader classReader = new ClassReader(bis);
            String pathInFile = classReader.getClassName().replace("/", File.separator) + ".class";
            bl = this.load(api, file, pathInFile);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                assert (ExceptionUtil.printStackTrace(e));
                return false;
            }
        }
        bis.close();
        return bl;
    }
}

