/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.indexer;

import java.io.InputStream;
import java.util.HashSet;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.service.indexer.AbstractIndexerProvider;
import org.jd.gui.util.exception.ExceptionUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ModuleVisitor;

public class JavaModuleInfoFileIndexerProvider
extends AbstractIndexerProvider {
    protected HashSet<String> javaModuleDeclarationSet = new HashSet();
    protected HashSet<String> javaModuleReferenceSet = new HashSet();
    protected HashSet<String> typeReferenceSet = new HashSet();
    protected ClassIndexer classIndexer = new ClassIndexer();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("jmod:file:classes/module-info.class");
    }

    @Override
    public void index(API api, Container.Entry entry, Indexes indexes) {
        block8: {
            this.javaModuleDeclarationSet.clear();
            this.javaModuleReferenceSet.clear();
            this.typeReferenceSet.clear();
            try (InputStream inputStream = entry.getInputStream();){
                ClassReader classReader = new ClassReader(inputStream);
                classReader.accept(this.classIndexer, 7);
                JavaModuleInfoFileIndexerProvider.addToIndexes(indexes, "javaModuleDeclarations", this.javaModuleDeclarationSet, entry);
                JavaModuleInfoFileIndexerProvider.addToIndexes(indexes, "javaModuleReferences", this.javaModuleReferenceSet, entry);
                JavaModuleInfoFileIndexerProvider.addToIndexes(indexes, "typeReferences", this.typeReferenceSet, entry);
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block8;
                throw new AssertionError();
            }
        }
    }

    protected class ClassIndexer
    extends ClassVisitor {
        protected ModuleIndexer moduleIndexer;

        public ClassIndexer() {
            super(458752);
            this.moduleIndexer = new ModuleIndexer();
        }

        @Override
        public ModuleVisitor visitModule(String moduleName, int moduleFlags, String moduleVersion) {
            JavaModuleInfoFileIndexerProvider.this.javaModuleDeclarationSet.add(moduleName);
            return this.moduleIndexer;
        }
    }

    protected class ModuleIndexer
    extends ModuleVisitor {
        public ModuleIndexer() {
            super(458752);
        }

        @Override
        public void visitMainClass(String mainClass) {
            JavaModuleInfoFileIndexerProvider.this.typeReferenceSet.add(mainClass);
        }

        @Override
        public void visitRequire(String module, int access, String version) {
            JavaModuleInfoFileIndexerProvider.this.javaModuleReferenceSet.add(module);
        }

        @Override
        public void visitUse(String service) {
            JavaModuleInfoFileIndexerProvider.this.typeReferenceSet.add(service);
        }

        @Override
        public void visitExport(String packaze, int access, String ... modules) {
            if (modules != null) {
                for (String module : modules) {
                    JavaModuleInfoFileIndexerProvider.this.javaModuleReferenceSet.add(module);
                }
            }
        }

        @Override
        public void visitOpen(String packaze, int access, String ... modules) {
            if (modules != null) {
                for (String module : modules) {
                    JavaModuleInfoFileIndexerProvider.this.javaModuleReferenceSet.add(module);
                }
            }
        }

        @Override
        public void visitProvide(String service, String ... providers) {
            JavaModuleInfoFileIndexerProvider.this.typeReferenceSet.add(service);
            if (providers != null) {
                for (String provider : providers) {
                    JavaModuleInfoFileIndexerProvider.this.typeReferenceSet.add(provider);
                }
            }
        }
    }
}

