/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.mainpanel;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContentIndexable;
import org.jd.gui.api.feature.SourcesSavable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.spi.Indexer;
import org.jd.gui.spi.PanelFactory;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.spi.TreeNodeFactory;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.view.component.panel.TreeTabbedPanel;

public class ContainerPanelFactoryProvider
implements PanelFactory {
    protected static final String[] TYPES = new String[]{"default"};

    @Override
    public String[] getTypes() {
        return TYPES;
    }

    @Override
    public <T extends JComponent> T make(API api, Container container) {
        return (T)new ContainerPanel(api, container);
    }

    protected class ContainerPanel
    extends TreeTabbedPanel
    implements ContentIndexable,
    SourcesSavable {
        protected Container.Entry entry;

        public ContainerPanel(API api, Container container) {
            super(api, container.getRoot().getParent().getUri());
            this.entry = container.getRoot().getParent();
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            for (Container.Entry entry : container.getRoot().getChildren()) {
                TreeNodeFactory factory = api.getTreeNodeFactory(entry);
                if (factory == null) continue;
                root.add((MutableTreeNode)factory.make(api, entry));
            }
            this.tree.setModel(new DefaultTreeModel(root));
        }

        @Override
        public Indexes index(API api) {
            HashMap<String, Map<String, Collection>> map = new HashMap<String, Map<String, Collection>>();
            DelegatedMapMapWithDefault mapWithDefault = new DelegatedMapMapWithDefault((Map<String, Map<String, Collection>>)map);
            Indexes indexesWithDefault = name -> mapWithDefault.get(name);
            Indexer indexer = api.getIndexer(this.entry);
            if (indexer != null) {
                indexer.index(api, this.entry, indexesWithDefault);
            }
            return name -> (Map)map.get(name);
        }

        @Override
        public String getSourceFileName() {
            SourceSaver saver = this.api.getSourceSaver(this.entry);
            if (saver != null) {
                String path = saver.getSourcePath(this.entry);
                int index = path.lastIndexOf(47);
                return path.substring(index + 1);
            }
            return null;
        }

        @Override
        public int getFileCount() {
            SourceSaver saver = this.api.getSourceSaver(this.entry);
            return saver != null ? saver.getFileCount(this.api, this.entry) : 0;
        }

        @Override
        public void save(API api, SourcesSavable.Controller controller, SourcesSavable.Listener listener, Path path) {
            block10: {
                try {
                    Path parentPath = path.getParent();
                    if (parentPath != null && !Files.exists(parentPath, new LinkOption[0])) {
                        Files.createDirectories(parentPath, new FileAttribute[0]);
                    }
                    URI uri = path.toUri();
                    URI archiveUri = new URI("jar:" + uri.getScheme(), uri.getHost(), uri.getPath() + "!/", null);
                    try (FileSystem archiveFs = FileSystems.newFileSystem(archiveUri, Collections.singletonMap("create", "true"));){
                        Path archiveRootPath = archiveFs.getPath("/", new String[0]);
                        SourceSaver saver = api.getSourceSaver(this.entry);
                        if (saver != null) {
                            saver.saveContent(api, () -> controller.isCancelled(), p -> listener.pathSaved(p), archiveRootPath, archiveRootPath, this.entry);
                        }
                    }
                }
                catch (IOException | URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block10;
                    throw new AssertionError();
                }
            }
        }
    }

    protected static class DelegatedMapMapWithDefault
    extends DelegatedMap<String, Map<String, Collection>> {
        protected HashMap<String, Map<String, Collection>> wrappers = new HashMap();

        public DelegatedMapMapWithDefault(Map<String, Map<String, Collection>> map) {
            super(map);
        }

        @Override
        public Map<String, Collection> get(Object o) {
            DelegatedMapWithDefault value = this.wrappers.get(o);
            if (value == null) {
                String key = o.toString();
                HashMap<String, Collection> m = new HashMap<String, Collection>();
                this.map.put(key, m);
                value = new DelegatedMapWithDefault((Map<String, Collection>)m);
                this.wrappers.put(key, value);
            }
            return value;
        }
    }

    protected static class DelegatedMapWithDefault
    extends DelegatedMap<String, Collection> {
        public DelegatedMapWithDefault(Map<String, Collection> map) {
            super(map);
        }

        @Override
        public Collection get(Object o) {
            ArrayList value = (ArrayList)this.map.get(o);
            if (value == null) {
                String key = o.toString();
                value = new ArrayList();
                this.map.put(key, value);
            }
            return value;
        }
    }

    protected static class DelegatedMap<K, V>
    implements Map<K, V> {
        protected Map<K, V> map;

        public DelegatedMap(Map<K, V> map) {
            this.map = map;
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public boolean containsKey(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean containsValue(Object o) {
            return this.map.containsValue(o);
        }

        @Override
        public V get(Object o) {
            return this.map.get(o);
        }

        @Override
        public V put(K k, V v) {
            return this.map.put(k, v);
        }

        @Override
        public V remove(Object o) {
            return this.map.remove(o);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            this.map.putAll(map);
        }

        @Override
        public void clear() {
            this.map.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.map.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.map.values();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.map.entrySet();
        }

        @Override
        public boolean equals(Object o) {
            return this.map.equals(o);
        }

        @Override
        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

