/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourceloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.spi.SourceLoader;
import org.jd.gui.util.exception.ExceptionUtil;

public class MavenOrgSourceLoaderProvider
implements SourceLoader {
    protected static final String MAVENORG_SEARCH_URL_PREFIX = "https://search.maven.org/solrsearch/select?q=1:%22";
    protected static final String MAVENORG_SEARCH_URL_SUFFIX = "%22&rows=20&wt=xml";
    protected static final String MAVENORG_LOAD_URL_PREFIX = "https://search.maven.org/classic/remotecontent?filepath=";
    protected static final String MAVENORG_LOAD_URL_SUFFIX = "-sources.jar";
    protected HashSet<Container.Entry> failed = new HashSet();
    protected HashMap<Container.Entry, File> cache = new HashMap();

    @Override
    public String getSource(API api, Container.Entry entry) {
        if (MavenOrgSourceLoaderProvider.isActivated(api)) {
            String filters = api.getPreferences().get("MavenOrgSourceLoaderPreferencesProvider.filters");
            if (filters == null || filters.isEmpty()) {
                filters = "+org +com.google +com.springsource +com.sun -com +java +javax +sun +sunw +spring +springframework +springmodules +tomcat +maven +edu";
            }
            if (this.accepted(filters, entry.getPath())) {
                return this.searchSource(entry, this.cache.get(entry.getContainer().getRoot().getParent()));
            }
        }
        return null;
    }

    @Override
    public String loadSource(API api, Container.Entry entry) {
        if (MavenOrgSourceLoaderProvider.isActivated(api)) {
            String filters = api.getPreferences().get("MavenOrgSourceLoaderPreferencesProvider.filters");
            if (filters == null || filters.isEmpty()) {
                filters = "+org +com.google +com.springsource +com.sun -com +java +javax +sun +sunw +spring +springframework +springmodules +tomcat +maven +edu";
            }
            if (this.accepted(filters, entry.getPath())) {
                return this.searchSource(entry, this.downloadSourceJarFile(entry.getContainer().getRoot().getParent()));
            }
        }
        return null;
    }

    @Override
    public File loadSourceFile(API api, Container.Entry entry) {
        return MavenOrgSourceLoaderProvider.isActivated(api) ? this.downloadSourceJarFile(entry) : null;
    }

    private static boolean isActivated(API api) {
        return !"false".equals(api.getPreferences().get("MavenOrgSourceLoaderPreferencesProvider.activated"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String searchSource(Container.Entry entry, File sourceJarFile) {
        if (sourceJarFile == null) return null;
        byte[] buffer = new byte[2048];
        try (ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(sourceJarFile)));){
            ZipEntry ze = zis.getNextEntry();
            String name = entry.getPath();
            name = name.substring(0, name.length() - 6) + ".java";
            while (ze != null) {
                if (ze.getName().equals(name)) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int read = zis.read(buffer);
                    while (true) {
                        if (read <= 0) {
                            String string = new String(out.toByteArray(), "UTF-8");
                            return string;
                        }
                        out.write(buffer, 0, read);
                        read = zis.read(buffer);
                    }
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            return null;
        }
        catch (IOException e) {
            if ($assertionsDisabled) return null;
            if (ExceptionUtil.printStackTrace(e)) return null;
            throw new AssertionError();
        }
    }

    protected File downloadSourceJarFile(Container.Entry entry) {
        block50: {
            if (this.cache.containsKey(entry)) {
                return this.cache.get(entry);
            }
            if (!entry.isDirectory() && !this.failed.contains(entry)) {
                try {
                    MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
                    byte[] buffer = new byte[2048];
                    try (DigestInputStream is = new DigestInputStream(entry.getInputStream(), messageDigest);){
                        while (is.read(buffer) > -1) {
                        }
                    }
                    byte[] array = messageDigest.digest();
                    StringBuilder sb = new StringBuilder();
                    for (byte b : array) {
                        sb.append(MavenOrgSourceLoaderProvider.hexa((b & 0xFF) >> 4));
                        sb.append(MavenOrgSourceLoaderProvider.hexa(b & 0xF));
                    }
                    String sha1 = sb.toString();
                    URL searchUrl = new URL(MAVENORG_SEARCH_URL_PREFIX + sha1 + MAVENORG_SEARCH_URL_SUFFIX);
                    boolean sourceAvailable = false;
                    String id = null;
                    String numFound = null;
                    try (InputStream is = searchUrl.openStream();){
                        XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(is);
                        String name = "";
                        while (reader.hasNext()) {
                            block9 : switch (reader.next()) {
                                case 1: {
                                    if ("str".equals(reader.getLocalName())) {
                                        if ("id".equals(reader.getAttributeValue(null, "name"))) {
                                            name = "id";
                                            break;
                                        }
                                        name = "str";
                                        break;
                                    }
                                    if ("result".equals(reader.getLocalName())) {
                                        numFound = reader.getAttributeValue(null, "numFound");
                                        break;
                                    }
                                    name = "";
                                    break;
                                }
                                case 4: {
                                    switch (name) {
                                        case "id": {
                                            id = reader.getText().trim();
                                            break block9;
                                        }
                                        case "str": {
                                            sourceAvailable |= MAVENORG_LOAD_URL_SUFFIX.equals(reader.getText().trim());
                                        }
                                    }
                                }
                            }
                        }
                        reader.close();
                    }
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    if ("0".equals(numFound)) {
                        Properties pomProperties = MavenOrgSourceLoaderProvider.getPomProperties(entry);
                        if (pomProperties != null) {
                            groupId = pomProperties.getProperty("groupId");
                            artifactId = pomProperties.getProperty("artifactId");
                            version = pomProperties.getProperty("version");
                        }
                    } else if ("1".equals(numFound) && sourceAvailable) {
                        int index1 = id.indexOf(58);
                        int index2 = id.lastIndexOf(58);
                        groupId = id.substring(0, index1);
                        artifactId = id.substring(index1 + 1, index2);
                        version = id.substring(index2 + 1);
                    }
                    if (artifactId == null) break block50;
                    String filePath = groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version;
                    URL loadUrl = new URL(MAVENORG_LOAD_URL_PREFIX + filePath + MAVENORG_LOAD_URL_SUFFIX);
                    File tmpFile = File.createTempFile("jd-gui.tmp.", '.' + groupId + '_' + artifactId + '_' + version + MAVENORG_LOAD_URL_SUFFIX);
                    tmpFile.delete();
                    tmpFile.deleteOnExit();
                    try (BufferedInputStream is = new BufferedInputStream(loadUrl.openStream());
                         BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));){
                        int read = ((InputStream)is).read(buffer);
                        while (read > 0) {
                            ((OutputStream)os).write(buffer, 0, read);
                            read = ((InputStream)is).read(buffer);
                        }
                    }
                    this.cache.put(entry, tmpFile);
                    return tmpFile;
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block50;
                    throw new AssertionError();
                }
            }
        }
        this.failed.add(entry);
        return null;
    }

    private static Properties getPomProperties(Container.Entry parent) {
        for (Container.Entry child1 : parent.getChildren()) {
            if (!child1.isDirectory() || !child1.getPath().equals("META-INF")) continue;
            for (Container.Entry child2 : child1.getChildren()) {
                Container.Entry entry;
                Collection<Container.Entry> children;
                if (!child2.isDirectory() || !child2.getPath().equals("META-INF/maven") || !child2.isDirectory() || (children = child2.getChildren()).size() != 1 || !(entry = children.iterator().next()).isDirectory() || (children = entry.getChildren()).size() != 1) continue;
                entry = children.iterator().next();
                for (Container.Entry child3 : entry.getChildren()) {
                    Properties properties;
                    block12: {
                        if (child3.isDirectory() || !child3.getPath().endsWith("/pom.properties")) continue;
                        InputStream is = child3.getInputStream();
                        try {
                            Properties properties2 = new Properties();
                            properties2.load(is);
                            properties = properties2;
                            if (is == null) break block12;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (Exception e) {
                                assert (ExceptionUtil.printStackTrace(e));
                                continue;
                            }
                        }
                        is.close();
                    }
                    return properties;
                }
            }
        }
        return null;
    }

    private static char hexa(int i) {
        return (char)(i <= 9 ? 48 + i : 87 + i);
    }

    protected boolean accepted(String filters, String path) {
        StringTokenizer tokenizer = new StringTokenizer(filters);
        while (tokenizer.hasMoreTokens()) {
            String filter = tokenizer.nextToken();
            if (filter.length() <= 1) continue;
            String prefix = filter.substring(1).replace('.', '/');
            if (prefix.charAt(prefix.length() - 1) != '/') {
                prefix = prefix + '/';
            }
            if (!path.startsWith(prefix)) continue;
            return filter.charAt(0) == '+';
        }
        return false;
    }
}

