/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.jd.core.v1.ClassFileToJavaSourceDecompiler;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourcesaver.AbstractSourceSaverProvider;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.util.decompiler.ContainerLoader;
import org.jd.gui.util.decompiler.LineNumberStringBuilderPrinter;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.io.NewlineOutputStream;

public class ClassFileSourceSaverProvider
extends AbstractSourceSaverProvider {
    protected static final String ESCAPE_UNICODE_CHARACTERS = "ClassFileDecompilerPreferences.escapeUnicodeCharacters";
    protected static final String REALIGN_LINE_NUMBERS = "ClassFileDecompilerPreferences.realignLineNumbers";
    protected static final String WRITE_LINE_NUMBERS = "ClassFileSaverPreferences.writeLineNumbers";
    protected static final String WRITE_METADATA = "ClassFileSaverPreferences.writeMetadata";
    protected static final String JD_CORE_VERSION = "JdGuiPreferences.jdCoreVersion";
    protected static final ClassFileToJavaSourceDecompiler DECOMPILER = new ClassFileToJavaSourceDecompiler();
    protected ContainerLoader loader = new ContainerLoader();
    protected LineNumberStringBuilderPrinter printer = new LineNumberStringBuilderPrinter();

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.class");
    }

    @Override
    public String getSourcePath(Container.Entry entry) {
        String path = entry.getPath();
        int index = path.lastIndexOf(46);
        String prefix = index == -1 ? path : path.substring(0, index);
        return prefix + ".java";
    }

    @Override
    public int getFileCount(API api, Container.Entry entry) {
        if (entry.getPath().indexOf(36) == -1) {
            return 1;
        }
        return 0;
    }

    @Override
    public void save(API api, SourceSaver.Controller controller, SourceSaver.Listener listener, Path rootPath, Container.Entry entry) {
        String sourcePath = this.getSourcePath(entry);
        Path path = rootPath.resolve(sourcePath);
        this.saveContent(api, controller, listener, rootPath, path, entry);
    }

    @Override
    public void saveContent(API api, SourceSaver.Controller controller, SourceSaver.Listener listener, Path rootPath, Path path, Container.Entry entry) {
        block26: {
            try {
                if (path.toString().indexOf(36) == -1) {
                    listener.pathSaved(path);
                }
                Map<String, String> preferences = api.getPreferences();
                boolean realignmentLineNumbers = ClassFileSourceSaverProvider.getPreferenceValue(preferences, REALIGN_LINE_NUMBERS, true);
                boolean unicodeEscape = ClassFileSourceSaverProvider.getPreferenceValue(preferences, ESCAPE_UNICODE_CHARACTERS, false);
                boolean showLineNumbers = ClassFileSourceSaverProvider.getPreferenceValue(preferences, WRITE_LINE_NUMBERS, true);
                HashMap<String, Object> configuration = new HashMap<String, Object>();
                configuration.put("realignLineNumbers", realignmentLineNumbers);
                this.loader.setEntry(entry);
                this.printer.setRealignmentLineNumber(realignmentLineNumbers);
                this.printer.setUnicodeEscape(unicodeEscape);
                this.printer.setShowLineNumbers(showLineNumbers);
                String entryPath = entry.getPath();
                assert (entryPath.endsWith(".class"));
                String entryInternalName = entryPath.substring(0, entryPath.length() - 6);
                DECOMPILER.decompile(this.loader, this.printer, entryInternalName, configuration);
                StringBuilder stringBuffer = this.printer.getStringBuffer();
                if (ClassFileSourceSaverProvider.getPreferenceValue(preferences, WRITE_METADATA, true)) {
                    String location = new File(entry.getUri()).getPath().replaceAll("(^|[^\\\\])\\\\u", "\\\\\\\\u");
                    stringBuffer.append("\n\n/* Location:              ");
                    stringBuffer.append(location);
                    int majorVersion = this.printer.getMajorVersion();
                    if (majorVersion >= 45) {
                        stringBuffer.append("\n * Java compiler version: ");
                        if (majorVersion >= 49) {
                            stringBuffer.append(majorVersion - 44);
                        } else {
                            stringBuffer.append(majorVersion - 44);
                        }
                        stringBuffer.append(" (");
                        stringBuffer.append(majorVersion);
                        stringBuffer.append('.');
                        stringBuffer.append(this.printer.getMinorVersion());
                        stringBuffer.append(')');
                    }
                    stringBuffer.append("\n * JD-Core Version:       ");
                    stringBuffer.append(preferences.get(JD_CORE_VERSION));
                    stringBuffer.append("\n */");
                }
                try (PrintStream ps = new PrintStream((OutputStream)new NewlineOutputStream(Files.newOutputStream(path, new OpenOption[0])), true, "UTF-8");){
                    ps.print(stringBuffer.toString());
                }
                catch (IOException e) {
                    assert (ExceptionUtil.printStackTrace(e));
                }
            }
            finally {
                Throwable t;
                assert (ExceptionUtil.printStackTrace(t));
                try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
                    writer.write("// INTERNAL ERROR //");
                }
                catch (IOException ee) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(ee)) break block26;
                    throw new AssertionError();
                }
            }
        }
    }

    protected static boolean getPreferenceValue(Map<String, String> preferences, String key, boolean defaultValue) {
        String v = preferences.get(key);
        return v == null ? defaultValue : Boolean.valueOf(v);
    }
}

