/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.sourcesaver;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.sourcesaver.AbstractSourceSaverProvider;
import org.jd.gui.spi.SourceSaver;
import org.jd.gui.util.exception.ExceptionUtil;

public class FileSourceSaverProvider
extends AbstractSourceSaverProvider {
    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*");
    }

    @Override
    public String getSourcePath(Container.Entry entry) {
        return entry.getPath();
    }

    @Override
    public int getFileCount(API api, Container.Entry entry) {
        return 1;
    }

    @Override
    public void save(API api, SourceSaver.Controller controller, SourceSaver.Listener listener, Path rootPath, Container.Entry entry) {
        this.saveContent(api, controller, listener, rootPath, rootPath.resolve(entry.getPath()), entry);
    }

    @Override
    public void saveContent(API api, SourceSaver.Controller controller, SourceSaver.Listener listener, Path rootPath, Path path, Container.Entry entry) {
        block17: {
            listener.pathSaved(path);
            try (InputStream is = entry.getInputStream();){
                Files.copy(is, path, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                assert (ExceptionUtil.printStackTrace(e));
                try (BufferedWriter writer = Files.newBufferedWriter(path, Charset.defaultCharset(), new OpenOption[0]);){
                    writer.write("// INTERNAL ERROR //");
                }
                catch (IOException ee) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(ee)) break block17;
                    throw new AssertionError();
                }
            }
        }
    }
}

