/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.TextFileTreeNodeFactoryProvider;
import org.jd.gui.view.data.TreeNodeBean;

public class PropertiesFileTreeNodeFactoryProvider
extends TextFileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON = new ImageIcon(PropertiesFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/ascii_obj.png"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.properties", "*:file:*.cfg");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)ICON));
    }

    protected static class TreeNode
    extends TextFileTreeNodeFactoryProvider.TreeNode {
        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            return (T)new TextFileTreeNodeFactoryProvider.Page(this.entry){

                @Override
                public String getSyntaxStyle() {
                    return "text/properties";
                }
            };
        }
    }
}

