/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.Gutter;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.PageCreator;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.FileTreeNodeFactoryProvider;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.io.TextReader;
import org.jd.gui.view.component.TextPage;
import org.jd.gui.view.data.TreeNodeBean;

public class TextFileTreeNodeFactoryProvider
extends FileTreeNodeFactoryProvider {
    protected static final ImageIcon ICON;

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.txt", "*:file:*.md", "*:file:*.SF", "*:file:*.policy", "*:file:*.yaml", "*:file:*.yml", "*:file:*/COPYRIGHT", "*:file:*/LICENSE", "*:file:*.cnd", "*:file:*.drl", "*:file:*.dsl");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        return (T)new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)ICON));
    }

    static {
        block2: {
            ICON = new ImageIcon(TextFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/ascii_obj.png"));
            new Gutter(new RSyntaxTextArea());
            try {
                Theme.load(TextFileTreeNodeFactoryProvider.class.getClassLoader().getResourceAsStream("rsyntaxtextarea/themes/eclipse.xml"));
            }
            catch (IOException e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block2;
                throw new AssertionError();
            }
        }
    }

    protected static class TreeNode
    extends FileTreeNodeFactoryProvider.TreeNode
    implements PageCreator {
        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public <T extends JComponent> T createPage(API api) {
            return (T)new Page(this.entry);
        }
    }

    protected static class Page
    extends TextPage
    implements UriGettable {
        protected Container.Entry entry;

        public Page(Container.Entry entry) {
            this.entry = entry;
            this.setText(TextReader.getText(entry.getInputStream()));
        }

        @Override
        public URI getUri() {
            return this.entry.getUri();
        }

        @Override
        public String getFileName() {
            String path = this.entry.getPath();
            int index = path.lastIndexOf("/");
            return path.substring(index + 1);
        }
    }
}

