/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.decompiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.loader.LoaderException;

public class ClassPathLoader
implements Loader {
    protected byte[] buffer = new byte[4096];

    @Override
    public boolean canLoad(String internalName) {
        return this.getClass().getResource("/" + internalName + ".class") != null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] load(String internalName) throws LoaderException {
        InputStream is = this.getClass().getResourceAsStream("/" + internalName + ".class");
        if (is == null) {
            return null;
        }
        try (InputStream input = is;){
            byte[] byArray;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int len = input.read(this.buffer);
                while (len > 0) {
                    output.write(this.buffer, 0, len);
                    len = input.read(this.buffer);
                }
                byArray = output.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new LoaderException(e);
        }
    }
}

