/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.util.decompiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.api.loader.LoaderException;
import org.jd.gui.api.model.Container;

public class ContainerLoader
implements Loader {
    protected byte[] buffer = new byte[4096];
    protected Container.Entry entry;

    public ContainerLoader() {
        this.entry = null;
    }

    public ContainerLoader(Container.Entry entry) {
        this.entry = entry;
    }

    public void setEntry(Container.Entry e) {
        this.entry = e;
    }

    protected Container.Entry getEntry(String internalPath) {
        String path = internalPath + ".class";
        if (this.entry.getPath().equals(path)) {
            return this.entry;
        }
        for (Container.Entry e : this.entry.getParent().getChildren()) {
            if (!e.getPath().equals(path)) continue;
            return e;
        }
        return null;
    }

    @Override
    public boolean canLoad(String internalName) {
        return this.getEntry(internalName) != null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] load(String internalName) throws LoaderException {
        Container.Entry entry = this.getEntry(internalName);
        if (entry == null) {
            return null;
        }
        try (InputStream input = entry.getInputStream();){
            byte[] byArray;
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
                int len = input.read(this.buffer);
                while (len > 0) {
                    output.write(this.buffer, 0, len);
                    len = input.read(this.buffer);
                }
                byArray = output.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new LoaderException(e);
        }
    }
}

