/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContentCopyable;
import org.jd.gui.api.feature.ContentSavable;
import org.jd.gui.api.feature.ContentSearchable;
import org.jd.gui.api.feature.ContentSelectable;
import org.jd.gui.api.feature.FocusedTypeGettable;
import org.jd.gui.api.feature.LineNumberNavigable;
import org.jd.gui.api.feature.PageChangeListener;
import org.jd.gui.api.feature.PageClosable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.SourcesSavable;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.model.configuration.Configuration;
import org.jd.gui.model.history.History;
import org.jd.gui.service.platform.PlatformService;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.swing.SwingUtil;
import org.jd.gui.view.component.IconButton;
import org.jd.gui.view.component.panel.MainTabbedPanel;

public class MainView<T extends JComponent>
implements UriOpenable,
PreferencesChangeListener {
    protected History history;
    protected Consumer<File> openFilesCallback;
    protected JFrame mainFrame;
    protected JMenu recentFiles = new JMenu("Recent Files");
    protected Action closeAction;
    protected Action openTypeAction;
    protected Action backwardAction;
    protected Action forwardAction;
    protected MainTabbedPanel mainTabbedPanel;
    protected Box findPanel;
    protected JComboBox findComboBox;
    protected JCheckBox findCaseSensitive;
    protected Color findBackgroundColor;
    protected Color findErrorBackgroundColor;

    public MainView(Configuration configuration, API api, final History history, ActionListener openActionListener, ActionListener closeActionListener, ActionListener saveActionListener, ActionListener saveAllSourcesActionListener, ActionListener exitActionListener, ActionListener copyActionListener, ActionListener pasteActionListener, ActionListener selectAllActionListener, ActionListener findActionListener, ActionListener findPreviousActionListener, ActionListener findNextActionListener, ActionListener findCaseSensitiveActionListener, final Runnable findCriteriaChangedCallback, ActionListener openTypeActionListener, ActionListener openTypeHierarchyActionListener, ActionListener goToActionListener, ActionListener backwardActionListener, ActionListener forwardActionListener, ActionListener searchActionListener, ActionListener jdWebSiteActionListener, ActionListener jdGuiIssuesActionListener, ActionListener jdCoreIssuesActionListener, ActionListener preferencesActionListener, ActionListener aboutActionListener, final Runnable panelClosedCallback, final Consumer<T> currentPageChangedCallback, Consumer<File> openFilesCallback) {
        this.history = history;
        this.openFilesCallback = openFilesCallback;
        SwingUtil.invokeLater(() -> {
            this.mainFrame = new JFrame("Java Decompiler");
            this.mainFrame.setIconImages(Arrays.asList(SwingUtil.getImage("/org/jd/gui/images/jd_icon_32.png"), SwingUtil.getImage("/org/jd/gui/images/jd_icon_64.png"), SwingUtil.getImage("/org/jd/gui/images/jd_icon_128.png")));
            this.mainFrame.setMinimumSize(new Dimension(500, 160));
            this.mainFrame.setDefaultCloseOperation(3);
            final Action findNextAction = SwingUtil.newAction("Next", SwingUtil.newImageIcon("/org/jd/gui/images/next_nav.png"), true, findNextActionListener);
            this.findPanel = Box.createHorizontalBox();
            this.findPanel.setVisible(false);
            this.findPanel.add(new JLabel("Find: "));
            this.findComboBox = new JComboBox();
            this.findComboBox.setEditable(true);
            JComponent editorComponent = (JComponent)this.findComboBox.getEditor().getEditorComponent();
            editorComponent.addKeyListener(new KeyAdapter(){
                protected String lastStr = "";

                @Override
                public void keyReleased(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 27: {
                            MainView.this.findPanel.setVisible(false);
                            break;
                        }
                        case 10: {
                            String str = MainView.this.getFindText();
                            if (str.length() <= 1) break;
                            int index = ((DefaultComboBoxModel)MainView.this.findComboBox.getModel()).getIndexOf(str);
                            if (index != -1) {
                                MainView.this.findComboBox.removeItemAt(index);
                            }
                            MainView.this.findComboBox.insertItemAt(str, 0);
                            MainView.this.findComboBox.setSelectedIndex(0);
                            findNextAction.actionPerformed(null);
                            break;
                        }
                        default: {
                            String str = MainView.this.getFindText();
                            if (this.lastStr.equals(str)) break;
                            findCriteriaChangedCallback.run();
                            this.lastStr = str;
                        }
                    }
                }
            });
            editorComponent.setOpaque(true);
            this.findBackgroundColor = editorComponent.getBackground();
            this.findComboBox.setBackground(this.findBackgroundColor);
            this.findErrorBackgroundColor = Color.decode(configuration.getPreferences().get("JdGuiPreferences.errorBackgroundColor"));
            this.findPanel.add(this.findComboBox);
            this.findPanel.add(Box.createHorizontalStrut(5));
            JToolBar toolBar = new JToolBar();
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            IconButton findNextButton = new IconButton("Next", SwingUtil.newAction(SwingUtil.newImageIcon("/org/jd/gui/images/next_nav.png"), true, findNextActionListener));
            toolBar.add(findNextButton);
            toolBar.add(Box.createHorizontalStrut(5));
            IconButton findPreviousButton = new IconButton("Previous", SwingUtil.newAction(SwingUtil.newImageIcon("/org/jd/gui/images/prev_nav.png"), true, findPreviousActionListener));
            toolBar.add(findPreviousButton);
            this.findPanel.add(toolBar);
            this.findCaseSensitive = new JCheckBox();
            this.findCaseSensitive.setAction(SwingUtil.newAction("Case sensitive", true, findCaseSensitiveActionListener));
            this.findPanel.add(this.findCaseSensitive);
            this.findPanel.add(Box.createHorizontalGlue());
            IconButton findCloseButton = new IconButton(SwingUtil.newAction(null, null, true, e -> this.findPanel.setVisible(false)));
            findCloseButton.setContentAreaFilled(false);
            findCloseButton.setIcon(SwingUtil.newImageIcon("/org/jd/gui/images/close.gif"));
            findCloseButton.setRolloverIcon(SwingUtil.newImageIcon("/org/jd/gui/images/close_active.gif"));
            this.findPanel.add(findCloseButton);
            if (PlatformService.getInstance().isMac()) {
                this.findPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
                Border border = BorderFactory.createEmptyBorder();
                findNextButton.setBorder(border);
                findPreviousButton.setBorder(border);
                findCloseButton.setBorder(border);
            } else {
                this.findPanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 2));
            }
            boolean browser = Desktop.isDesktopSupported() ? Desktop.getDesktop().isSupported(Desktop.Action.BROWSE) : false;
            Action openAction = SwingUtil.newAction("Open File...", SwingUtil.newImageIcon("/org/jd/gui/images/open.png"), true, "Open a file", openActionListener);
            this.closeAction = SwingUtil.newAction("Close", false, closeActionListener);
            final Action saveAction = SwingUtil.newAction("Save", SwingUtil.newImageIcon("/org/jd/gui/images/save.png"), false, saveActionListener);
            final Action saveAllSourcesAction = SwingUtil.newAction("Save All Sources", SwingUtil.newImageIcon("/org/jd/gui/images/save_all.png"), false, saveAllSourcesActionListener);
            Action exitAction = SwingUtil.newAction("Exit", true, "Quit this program", exitActionListener);
            final Action copyAction = SwingUtil.newAction("Copy", SwingUtil.newImageIcon("/org/jd/gui/images/copy.png"), false, copyActionListener);
            Action pasteAction = SwingUtil.newAction("Paste Log", SwingUtil.newImageIcon("/org/jd/gui/images/paste.png"), true, pasteActionListener);
            final Action selectAllAction = SwingUtil.newAction("Select all", false, selectAllActionListener);
            final Action findAction = SwingUtil.newAction("Find...", false, findActionListener);
            this.openTypeAction = SwingUtil.newAction("Open Type...", SwingUtil.newImageIcon("/org/jd/gui/images/open_type.png"), false, openTypeActionListener);
            final Action openTypeHierarchyAction = SwingUtil.newAction("Open Type Hierarchy...", false, openTypeHierarchyActionListener);
            final Action goToAction = SwingUtil.newAction("Go to Line...", false, goToActionListener);
            this.backwardAction = SwingUtil.newAction("Back", SwingUtil.newImageIcon("/org/jd/gui/images/backward_nav.png"), false, backwardActionListener);
            this.forwardAction = SwingUtil.newAction("Forward", SwingUtil.newImageIcon("/org/jd/gui/images/forward_nav.png"), false, forwardActionListener);
            final Action searchAction = SwingUtil.newAction("Search...", SwingUtil.newImageIcon("/org/jd/gui/images/search_src.png"), false, searchActionListener);
            Action jdWebSiteAction = SwingUtil.newAction("JD Web site", browser, "Open JD Web site", jdWebSiteActionListener);
            Action jdGuiIssuesActionAction = SwingUtil.newAction("JD-GUI issues", browser, "Open JD-GUI issues page", jdGuiIssuesActionListener);
            Action jdCoreIssuesActionAction = SwingUtil.newAction("JD-Core issues", browser, "Open JD-Core issues page", jdCoreIssuesActionListener);
            Action preferencesAction = SwingUtil.newAction("Preferences...", SwingUtil.newImageIcon("/org/jd/gui/images/preferences.png"), true, "Open the preferences panel", preferencesActionListener);
            Action aboutAction = SwingUtil.newAction("About...", true, "About JD-GUI", aboutActionListener);
            int menuShortcutKeyMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            JMenuBar menuBar = new JMenuBar();
            JMenu menu = new JMenu("File");
            menuBar.add(menu);
            menu.add(openAction).setAccelerator(KeyStroke.getKeyStroke(79, menuShortcutKeyMask));
            menu.addSeparator();
            menu.add(this.closeAction).setAccelerator(KeyStroke.getKeyStroke(87, menuShortcutKeyMask));
            menu.addSeparator();
            menu.add(saveAction).setAccelerator(KeyStroke.getKeyStroke(83, menuShortcutKeyMask));
            menu.add(saveAllSourcesAction).setAccelerator(KeyStroke.getKeyStroke(83, menuShortcutKeyMask | 8));
            menu.addSeparator();
            menu.add(this.recentFiles);
            if (!PlatformService.getInstance().isMac()) {
                menu.addSeparator();
                menu.add(exitAction).setAccelerator(KeyStroke.getKeyStroke(88, 8));
            }
            menu = new JMenu("Edit");
            menuBar.add(menu);
            menu.add(copyAction).setAccelerator(KeyStroke.getKeyStroke(67, menuShortcutKeyMask));
            menu.add(pasteAction).setAccelerator(KeyStroke.getKeyStroke(86, menuShortcutKeyMask));
            menu.addSeparator();
            menu.add(selectAllAction).setAccelerator(KeyStroke.getKeyStroke(65, menuShortcutKeyMask));
            menu.addSeparator();
            menu.add(findAction).setAccelerator(KeyStroke.getKeyStroke(70, menuShortcutKeyMask));
            menu = new JMenu("Navigation");
            menuBar.add(menu);
            menu.add(this.openTypeAction).setAccelerator(KeyStroke.getKeyStroke(84, menuShortcutKeyMask));
            menu.add(openTypeHierarchyAction).setAccelerator(KeyStroke.getKeyStroke(72, menuShortcutKeyMask));
            menu.addSeparator();
            menu.add(goToAction).setAccelerator(KeyStroke.getKeyStroke(76, menuShortcutKeyMask));
            menu.addSeparator();
            menu.add(this.backwardAction).setAccelerator(KeyStroke.getKeyStroke(37, 8));
            menu.add(this.forwardAction).setAccelerator(KeyStroke.getKeyStroke(39, 8));
            menu = new JMenu("Search");
            menuBar.add(menu);
            menu.add(searchAction).setAccelerator(KeyStroke.getKeyStroke(83, menuShortcutKeyMask | 1));
            menu = new JMenu("Help");
            menuBar.add(menu);
            if (browser) {
                menu.add(jdWebSiteAction);
                menu.add(jdGuiIssuesActionAction);
                menu.add(jdCoreIssuesActionAction);
                menu.addSeparator();
            }
            menu.add(preferencesAction).setAccelerator(KeyStroke.getKeyStroke(80, menuShortcutKeyMask | 1));
            if (!PlatformService.getInstance().isMac()) {
                menu.addSeparator();
                menu.add(aboutAction).setAccelerator(KeyStroke.getKeyStroke(112, 0));
            }
            this.mainFrame.setJMenuBar(menuBar);
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            toolBar = new JToolBar();
            toolBar.setFloatable(false);
            toolBar.setRollover(true);
            toolBar.add(new IconButton(openAction));
            toolBar.addSeparator();
            toolBar.add(new IconButton(this.openTypeAction));
            toolBar.add(new IconButton(searchAction));
            toolBar.addSeparator();
            toolBar.add(new IconButton(this.backwardAction));
            toolBar.add(new IconButton(this.forwardAction));
            panel.add((Component)toolBar, "First");
            this.mainTabbedPanel = new MainTabbedPanel(api);
            this.mainTabbedPanel.getPageChangedListeners().add(new PageChangeListener(){
                protected JComponent currentPage = null;

                public <U extends JComponent> void pageChanged(U page) {
                    if (this.currentPage != page) {
                        this.currentPage = page;
                        currentPageChangedCallback.accept(page);
                        SwingUtil.invokeLater(() -> {
                            if (page == null) {
                                MainView.this.mainFrame.setTitle("Java Decompiler");
                                saveAction.setEnabled(false);
                                copyAction.setEnabled(false);
                                selectAllAction.setEnabled(false);
                                openTypeHierarchyAction.setEnabled(false);
                                goToAction.setEnabled(false);
                                MainView.this.findPanel.setVisible(false);
                            } else {
                                String path = ((UriGettable)((Object)page)).getUri().getPath();
                                int index = path.lastIndexOf(47);
                                String name = index == -1 ? path : path.substring(index + 1);
                                MainView.this.mainFrame.setTitle(name != null ? name + " - Java Decompiler" : "Java Decompiler");
                                history.add(((UriGettable)((Object)page)).getUri());
                                MainView.this.updateHistoryActions();
                                saveAction.setEnabled(page instanceof ContentSavable);
                                copyAction.setEnabled(page instanceof ContentCopyable);
                                selectAllAction.setEnabled(page instanceof ContentSelectable);
                                findAction.setEnabled(page instanceof ContentSearchable);
                                openTypeHierarchyAction.setEnabled(page instanceof FocusedTypeGettable);
                                goToAction.setEnabled(page instanceof LineNumberNavigable);
                                if (MainView.this.findPanel.isVisible()) {
                                    MainView.this.findPanel.setVisible(page instanceof ContentSearchable);
                                }
                            }
                        });
                    }
                }
            });
            this.mainTabbedPanel.getTabbedPane().addChangeListener(new ChangeListener(){
                protected int lastTabCount = 0;

                @Override
                public void stateChanged(ChangeEvent e) {
                    int tabCount = MainView.this.mainTabbedPanel.getTabbedPane().getTabCount();
                    boolean enabled = tabCount > 0;
                    MainView.this.closeAction.setEnabled(enabled);
                    MainView.this.openTypeAction.setEnabled(enabled);
                    searchAction.setEnabled(enabled);
                    saveAllSourcesAction.setEnabled(MainView.this.mainTabbedPanel.getTabbedPane().getSelectedComponent() instanceof SourcesSavable);
                    if (tabCount < this.lastTabCount) {
                        panelClosedCallback.run();
                    }
                    this.lastTabCount = tabCount;
                }
            });
            this.mainTabbedPanel.preferencesChanged(configuration.getPreferences());
            panel.add((Component)this.mainTabbedPanel, "Center");
            panel.add((Component)this.findPanel, "Last");
            this.mainFrame.add(panel);
        });
    }

    public void show(Point location, Dimension size, boolean maximize) {
        SwingUtil.invokeLater(() -> {
            this.mainFrame.setLocation(location);
            this.mainFrame.setSize(size);
            this.mainFrame.setExtendedState(maximize ? 6 : 0);
            this.mainFrame.setVisible(true);
        });
    }

    public JFrame getMainFrame() {
        return this.mainFrame;
    }

    public void showFindPanel() {
        SwingUtil.invokeLater(() -> {
            this.findPanel.setVisible(true);
            this.findComboBox.requestFocus();
            this.findComboBox.getEditor().selectAll();
        });
    }

    public void setFindBackgroundColor(boolean wasFound) {
        SwingUtil.invokeLater(() -> this.findComboBox.getEditor().getEditorComponent().setBackground(wasFound ? this.findBackgroundColor : this.findErrorBackgroundColor));
    }

    public <T extends JComponent> void addMainPanel(String title, Icon icon, String tip, T component) {
        SwingUtil.invokeLater(() -> this.mainTabbedPanel.addPage(title, icon, tip, component));
    }

    public <T extends JComponent> List<T> getMainPanels() {
        return this.mainTabbedPanel.getPages();
    }

    public <T extends JComponent> T getSelectedMainPanel() {
        return (T)((JComponent)this.mainTabbedPanel.getTabbedPane().getSelectedComponent());
    }

    public void closeCurrentTab() {
        SwingUtil.invokeLater(() -> {
            Component component = this.mainTabbedPanel.getTabbedPane().getSelectedComponent();
            if (component instanceof PageClosable) {
                if (!((PageClosable)((Object)component)).closePage()) {
                    this.mainTabbedPanel.removeComponent(component);
                }
            } else {
                this.mainTabbedPanel.removeComponent(component);
            }
        });
    }

    public void updateRecentFilesMenu(List<File> files) {
        SwingUtil.invokeLater(() -> {
            this.recentFiles.removeAll();
            for (File file : files) {
                JMenuItem menuItem = new JMenuItem(MainView.reduceRecentFilePath(file.getAbsolutePath()));
                menuItem.addActionListener(e -> this.openFilesCallback.accept(file));
                this.recentFiles.add(menuItem);
            }
        });
    }

    public String getFindText() {
        Document doc = ((JTextField)this.findComboBox.getEditor().getEditorComponent()).getDocument();
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            assert (ExceptionUtil.printStackTrace(e));
            return "";
        }
    }

    public boolean getFindCaseSensitive() {
        return this.findCaseSensitive.isSelected();
    }

    public void updateHistoryActions() {
        SwingUtil.invokeLater(() -> {
            this.backwardAction.setEnabled(this.history.canBackward());
            this.forwardAction.setEnabled(this.history.canForward());
        });
    }

    static String reduceRecentFilePath(String path) {
        int lastSeparatorPosition = path.lastIndexOf(File.separatorChar);
        if (lastSeparatorPosition == -1 || lastSeparatorPosition < 200) {
            return path;
        }
        int length = 98;
        String left = path.substring(0, length);
        String right = path.substring(path.length() - length);
        return left + "..." + right;
    }

    @Override
    public boolean openUri(URI uri) {
        boolean success = this.mainTabbedPanel.openUri(uri);
        if (success) {
            this.closeAction.setEnabled(true);
            this.openTypeAction.setEnabled(true);
        }
        return success;
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        this.mainTabbedPanel.preferencesChanged(preferences);
    }
}

