/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.jd.gui.api.API;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.api.model.TreeNodeData;
import org.jd.gui.api.model.Type;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.function.TriConsumer;
import org.jd.gui.util.swing.SwingUtil;
import org.jd.gui.view.component.Tree;
import org.jd.gui.view.renderer.TreeNodeRenderer;

public class OpenTypeHierarchyView {
    protected static final ImageIcon ROOT_CLASS_ICON = new ImageIcon(OpenTypeHierarchyView.class.getClassLoader().getResource("org/jd/gui/images/generate_class.png"));
    protected static final ImageIcon ROOT_INTERFACE_ICON = new ImageIcon(OpenTypeHierarchyView.class.getClassLoader().getResource("org/jd/gui/images/generate_int.png"));
    protected static final TreeNodeComparator TREE_NODE_COMPARATOR = new TreeNodeComparator();
    protected API api;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes;
    protected JDialog openTypeHierarchyDialog;
    protected Tree openTypeHierarchyTree;
    protected TriConsumer<Point, Collection<Container.Entry>, String> selectedTypeCallback;

    public OpenTypeHierarchyView(API api, JFrame mainFrame, TriConsumer<Point, Collection<Container.Entry>, String> selectedTypeCallback) {
        this.api = api;
        this.selectedTypeCallback = selectedTypeCallback;
        SwingUtil.invokeLater(() -> {
            this.openTypeHierarchyDialog = new JDialog(mainFrame, "Hierarchy Type", false);
            JPanel panel = new JPanel();
            panel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            panel.setLayout(new BorderLayout());
            this.openTypeHierarchyDialog.add(panel);
            this.openTypeHierarchyTree = new Tree();
            this.openTypeHierarchyTree.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
            this.openTypeHierarchyTree.setCellRenderer(new TreeNodeRenderer());
            this.openTypeHierarchyTree.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        OpenTypeHierarchyView.this.onTypeSelected();
                    }
                }
            });
            this.openTypeHierarchyTree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeExpanded(TreeExpansionEvent e) {
                    TreeNode node = (TreeNode)e.getPath().getLastPathComponent();
                    while (node.getChildCount() > 0) {
                        if (((DefaultMutableTreeNode)node.getChildAt(0)).getUserObject() == null) {
                            OpenTypeHierarchyView.this.populateTreeNode(node, null);
                        }
                        if (node.getChildCount() != 1) break;
                        node = (TreeNode)node.getChildAt(0);
                    }
                    DefaultTreeModel model = (DefaultTreeModel)OpenTypeHierarchyView.this.openTypeHierarchyTree.getModel();
                    model.reload((TreeNode)e.getPath().getLastPathComponent());
                    OpenTypeHierarchyView.this.openTypeHierarchyTree.setSelectionPath(new TreePath(node.getPath()));
                }

                @Override
                public void treeCollapsed(TreeExpansionEvent e) {
                }
            });
            this.openTypeHierarchyTree.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    TreeNode node;
                    if (e.getKeyCode() == 115 && (node = (TreeNode)OpenTypeHierarchyView.this.openTypeHierarchyTree.getLastSelectedPathComponent()) != null) {
                        OpenTypeHierarchyView.this.updateTree(node.entry, node.typeName);
                    }
                }
            });
            JScrollPane openTypeHierarchyScrollPane = new JScrollPane(this.openTypeHierarchyTree);
            openTypeHierarchyScrollPane.setHorizontalScrollBarPolicy(31);
            openTypeHierarchyScrollPane.setPreferredSize(new Dimension(400, 150));
            panel.add((Component)openTypeHierarchyScrollPane, "Center");
            Box vbox = Box.createVerticalBox();
            panel.add((Component)vbox, "South");
            vbox.add(Box.createVerticalStrut(25));
            Box hbox = Box.createHorizontalBox();
            vbox.add(hbox);
            hbox.add(Box.createHorizontalGlue());
            JButton openTypeHierarchyOpenButton = new JButton("Open");
            hbox.add(openTypeHierarchyOpenButton);
            openTypeHierarchyOpenButton.setEnabled(false);
            openTypeHierarchyOpenButton.addActionListener(e -> this.onTypeSelected());
            hbox.add(Box.createHorizontalStrut(5));
            JButton openTypeHierarchyCancelButton = new JButton("Cancel");
            hbox.add(openTypeHierarchyCancelButton);
            AbstractAction openTypeHierarchyCancelActionListener = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OpenTypeHierarchyView.this.openTypeHierarchyDialog.setVisible(false);
                }
            };
            openTypeHierarchyCancelButton.addActionListener(openTypeHierarchyCancelActionListener);
            this.openTypeHierarchyTree.addTreeSelectionListener(e -> {
                Object o = this.openTypeHierarchyTree.getLastSelectedPathComponent();
                if (o != null) {
                    o = ((TreeNode)o).entry;
                }
                openTypeHierarchyOpenButton.setEnabled(o != null);
            });
            JRootPane rootPane = this.openTypeHierarchyDialog.getRootPane();
            rootPane.setDefaultButton(openTypeHierarchyOpenButton);
            rootPane.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "OpenTypeHierarchyView.cancel");
            rootPane.getActionMap().put("OpenTypeHierarchyView.cancel", openTypeHierarchyCancelActionListener);
            this.openTypeHierarchyDialog.setMinimumSize(this.openTypeHierarchyDialog.getSize());
            this.openTypeHierarchyDialog.pack();
            this.openTypeHierarchyDialog.setLocationRelativeTo(mainFrame);
        });
    }

    public void show(Collection<Future<Indexes>> collectionOfFutureIndexes, Container.Entry entry, String typeName) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        SwingUtil.invokeLater(() -> {
            this.updateTree(entry, typeName);
            this.openTypeHierarchyDialog.setVisible(true);
            this.openTypeHierarchyTree.requestFocus();
        });
    }

    public boolean isVisible() {
        return this.openTypeHierarchyDialog.isVisible();
    }

    public void showWaitCursor() {
        SwingUtil.invokeLater(() -> this.openTypeHierarchyDialog.setCursor(Cursor.getPredefinedCursor(3)));
    }

    public void hideWaitCursor() {
        SwingUtil.invokeLater(() -> this.openTypeHierarchyDialog.setCursor(Cursor.getDefaultCursor()));
    }

    public void updateTree(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        TreeNode selectedTreeNode = (TreeNode)this.openTypeHierarchyTree.getLastSelectedPathComponent();
        if (selectedTreeNode != null) {
            this.updateTree(selectedTreeNode.entry, selectedTreeNode.typeName);
        }
    }

    protected void updateTree(Container.Entry entry, String typeName) {
        SwingUtil.invokeLater(() -> {
            DefaultTreeModel model = (DefaultTreeModel)this.openTypeHierarchyTree.getModel();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
            root.removeAllChildren();
            TreeNode selectedTreeNode = this.createTreeNode(entry, typeName);
            TreeNode parentTreeNode = this.createParentTreeNode(selectedTreeNode);
            root.add(parentTreeNode);
            model.reload();
            if (selectedTreeNode != null) {
                TreePath path = new TreePath(selectedTreeNode.getPath());
                this.openTypeHierarchyTree.expandPath(path);
                this.openTypeHierarchyTree.makeVisible(path);
                Rectangle bounds = this.openTypeHierarchyTree.getPathBounds(path);
                if (bounds != null) {
                    bounds.x = 0;
                    Rectangle lastRowBounds = this.openTypeHierarchyTree.getRowBounds(this.openTypeHierarchyTree.getRowCount() - 1);
                    if (lastRowBounds != null) {
                        bounds.y = Math.max(bounds.y - 30, 0);
                        bounds.height = Math.min(bounds.height + bounds.y + 60, lastRowBounds.height + lastRowBounds.y) - bounds.y;
                    }
                    this.openTypeHierarchyTree.scrollRectToVisible(bounds);
                    this.openTypeHierarchyTree.scrollPathToVisible(path);
                    this.openTypeHierarchyTree.fireVisibleDataPropertyChange();
                }
                this.openTypeHierarchyTree.setSelectionPath(path);
            }
        });
    }

    protected TreeNode createTreeNode(Container.Entry entry, String typeName) {
        Type type = this.api.getTypeFactory(entry).make(this.api, entry, typeName);
        typeName = type.getName();
        List<Container.Entry> entries = this.getEntries(typeName);
        TreeNode treeNode = new TreeNode(entry, typeName, entries, new TreeNodeBean(type));
        List<String> childTypeNames = this.getSubTypeNames(typeName);
        if (childTypeNames != null) {
            treeNode.add(new DefaultMutableTreeNode());
        }
        return treeNode;
    }

    protected TreeNode createParentTreeNode(TreeNode treeNode) {
        Type type = this.api.getTypeFactory(treeNode.entry).make(this.api, treeNode.entry, treeNode.typeName);
        String superTypeName = type.getSuperName();
        if (superTypeName != null) {
            List<Container.Entry> superEntries = this.getEntries(superTypeName);
            Container.Entry superEntry = null;
            if (superEntries != null && !superEntries.isEmpty()) {
                for (Container.Entry se : superEntries) {
                    if (se.getContainer() != treeNode.entry.getContainer()) continue;
                    superEntry = se;
                    break;
                }
                if (superEntry == null) {
                    superEntry = superEntries.get(0);
                }
            } else {
                superEntry = null;
            }
            if (superEntry != null) {
                TreeNode superTreeNode = this.createTreeNode(superEntry, superTypeName);
                this.populateTreeNode(superTreeNode, treeNode);
                return this.createParentTreeNode(superTreeNode);
            }
            int lastPackageSeparatorIndex = superTypeName.lastIndexOf(47);
            String package_ = superTypeName.substring(0, lastPackageSeparatorIndex).replace('/', '.');
            String name = superTypeName.substring(lastPackageSeparatorIndex + 1).replace('$', '.');
            String label = package_ != null ? name + " - " + package_ : name;
            ImageIcon icon = (type.getFlags() & 0x200) == 0 ? ROOT_CLASS_ICON : ROOT_INTERFACE_ICON;
            TreeNode rootTreeNode = new TreeNode(null, superTypeName, null, new TreeNodeBean(label, icon));
            if (package_.startsWith("java.")) {
                rootTreeNode.add(treeNode);
            } else {
                this.populateTreeNode(rootTreeNode, treeNode);
            }
            return rootTreeNode;
        }
        return treeNode;
    }

    protected void populateTreeNode(TreeNode superTreeNode, TreeNode activeTreeNode) {
        superTreeNode.removeAllChildren();
        Container.Entry notNullEntry = superTreeNode.entry;
        if (notNullEntry == null) {
            notNullEntry = activeTreeNode.entry;
        }
        Container preferredContainer = notNullEntry.getContainer();
        String activeTypName = null;
        if (activeTreeNode != null) {
            activeTypName = activeTreeNode.typeName;
        }
        List<String> subTypeNames = this.getSubTypeNames(superTreeNode.typeName);
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        for (String subTypeName : subTypeNames) {
            Type t;
            if (subTypeName.equals(activeTypName)) {
                treeNodes.add(activeTreeNode);
                continue;
            }
            List<Container.Entry> entries = this.getEntries(subTypeName);
            Container.Entry entry = null;
            for (Container.Entry e : entries) {
                if (e.getContainer() != preferredContainer) continue;
                entry = e;
            }
            if (entry == null) {
                entry = entries.get(0);
            }
            if (entry == null || (t = this.api.getTypeFactory(entry).make(this.api, entry, subTypeName)) == null) continue;
            treeNodes.add(this.createTreeNode(entry, t.getName()));
        }
        treeNodes.sort(TREE_NODE_COMPARATOR);
        for (TreeNode treeNode : treeNodes) {
            superTreeNode.add(treeNode);
        }
    }

    public void focus() {
        SwingUtil.invokeLater(() -> this.openTypeHierarchyTree.requestFocus());
    }

    protected void onTypeSelected() {
        TreeNode selectedTreeNode = (TreeNode)this.openTypeHierarchyTree.getLastSelectedPathComponent();
        if (selectedTreeNode != null) {
            TreePath path = new TreePath(selectedTreeNode.getPath());
            Rectangle bounds = this.openTypeHierarchyTree.getPathBounds(path);
            Point listLocation = this.openTypeHierarchyTree.getLocationOnScreen();
            Point leftBottom = new Point(listLocation.x + bounds.x, listLocation.y + bounds.y + bounds.height);
            this.selectedTypeCallback.accept(leftBottom, selectedTreeNode.entries, selectedTreeNode.typeName);
        }
    }

    protected List<String> getSubTypeNames(String typeName) {
        ArrayList<String> result;
        block4: {
            result = new ArrayList<String>();
            try {
                for (Future<Indexes> futureIndexes : this.collectionOfFutureIndexes) {
                    Collection collection;
                    Map<String, Collection> subTypeNames;
                    if (!futureIndexes.isDone() || (subTypeNames = futureIndexes.get().getIndex("subTypeNames")) == null || (collection = subTypeNames.get(typeName)) == null) continue;
                    for (String tn : collection) {
                        if (tn == null) continue;
                        result.add(tn);
                    }
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block4;
                throw new AssertionError();
            }
        }
        return result;
    }

    protected List<Container.Entry> getEntries(String typeName) {
        ArrayList<Container.Entry> result;
        block4: {
            result = new ArrayList<Container.Entry>();
            try {
                for (Future<Indexes> futureIndexes : this.collectionOfFutureIndexes) {
                    Collection collection;
                    Map<String, Collection> typeDeclarations;
                    if (!futureIndexes.isDone() || (typeDeclarations = futureIndexes.get().getIndex("typeDeclarations")) == null || (collection = typeDeclarations.get(typeName)) == null) continue;
                    for (Container.Entry e : collection) {
                        if (e == null) continue;
                        result.add(e);
                    }
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block4;
                throw new AssertionError();
            }
        }
        return result;
    }

    protected static class TreeNode
    extends DefaultMutableTreeNode {
        Container.Entry entry;
        String typeName;
        List<Container.Entry> entries;

        TreeNode(Container.Entry entry, String typeName, List<Container.Entry> entries, Object userObject) {
            super(userObject);
            this.entry = entry;
            this.typeName = typeName;
            this.entries = entries;
        }
    }

    protected static class TreeNodeBean
    implements TreeNodeData {
        String label;
        String tip;
        Icon icon;
        Icon openIcon;

        TreeNodeBean(Type type) {
            this.label = type.getDisplayPackageName() != null ? type.getDisplayTypeName() + " - " + type.getDisplayPackageName() : type.getDisplayTypeName();
            this.icon = type.getIcon();
        }

        TreeNodeBean(String label, Icon icon) {
            this.label = label;
            this.icon = icon;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getTip() {
            return this.tip;
        }

        @Override
        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Icon getOpenIcon() {
            return this.openIcon;
        }
    }

    protected static class TreeNodeComparator
    implements Comparator<TreeNode> {
        protected TreeNodeComparator() {
        }

        @Override
        public int compare(TreeNode tn1, TreeNode tn2) {
            return ((TreeNodeBean)tn1.getUserObject()).label.compareTo(((TreeNodeBean)tn2.getUserObject()).label);
        }
    }
}

