/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component;

import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fife.ui.rsyntaxtextarea.DocumentRange;
import org.fife.ui.rtextarea.Marker;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.FocusedTypeGettable;
import org.jd.gui.api.feature.IndexesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.feature.UriOpenable;
import org.jd.gui.api.model.Container;
import org.jd.gui.api.model.Indexes;
import org.jd.gui.api.model.Type;
import org.jd.gui.util.exception.ExceptionUtil;
import org.jd.gui.util.index.IndexesUtil;
import org.jd.gui.util.matcher.DescriptorMatcher;
import org.jd.gui.view.component.CustomLineNumbersPage;
import org.jd.gui.view.component.HyperlinkPage;

public abstract class TypePage
extends CustomLineNumbersPage
implements UriGettable,
UriOpenable,
IndexesChangeListener,
FocusedTypeGettable {
    protected API api;
    protected Container.Entry entry;
    protected Collection<Future<Indexes>> collectionOfFutureIndexes = Collections.emptyList();
    protected HashMap<String, DeclarationData> declarations = new HashMap();
    protected TreeMap<Integer, DeclarationData> typeDeclarations = new TreeMap();
    protected ArrayList<ReferenceData> references = new ArrayList();
    protected ArrayList<StringData> strings = new ArrayList();

    public TypePage(API api, Container.Entry entry) {
        this.api = api;
        this.entry = entry;
    }

    @Override
    protected boolean isHyperlinkEnabled(HyperlinkPage.HyperlinkData hyperlinkData) {
        return ((HyperlinkReferenceData)hyperlinkData).reference.enabled;
    }

    @Override
    protected void openHyperlink(int x, int y, HyperlinkPage.HyperlinkData hyperlinkData) {
        block11: {
            HyperlinkReferenceData hyperlinkReferenceData = (HyperlinkReferenceData)hyperlinkData;
            if (hyperlinkReferenceData.reference.enabled) {
                try {
                    Point location = this.textArea.getLocationOnScreen();
                    int offset = this.textArea.viewToModel(new Point(x - location.x, y - location.y));
                    URI uri = this.entry.getUri();
                    this.api.addURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), "position=" + offset, null));
                    ReferenceData reference = hyperlinkReferenceData.reference;
                    String typeName = reference.typeName;
                    List<Container.Entry> entries = IndexesUtil.findInternalTypeName(this.collectionOfFutureIndexes, typeName);
                    String fragment = typeName;
                    if (reference.name != null) {
                        fragment = fragment + '-' + reference.name;
                    }
                    if (reference.descriptor != null) {
                        fragment = fragment + '-' + reference.descriptor;
                    }
                    if (entries.contains(this.entry)) {
                        this.api.openURI(new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), fragment));
                    } else {
                        String rootUri = this.entry.getContainer().getRoot().getUri().toString();
                        ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
                        for (Container.Entry entry : entries) {
                            if (!entry.getUri().toString().startsWith(rootUri)) continue;
                            sameContainerEntries.add(entry);
                        }
                        if (sameContainerEntries.size() > 0) {
                            this.api.openURI(x, y, sameContainerEntries, null, fragment);
                        } else if (entries.size() > 0) {
                            this.api.openURI(x, y, entries, null, fragment);
                        }
                    }
                }
                catch (URISyntaxException e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block11;
                    throw new AssertionError();
                }
            }
        }
    }

    @Override
    public URI getUri() {
        return this.entry.getUri();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean openUri(URI uri) {
        ranges = new ArrayList<DocumentRange>();
        fragment = uri.getFragment();
        query = uri.getQuery();
        Marker.clearMarkAllHighlights(this.textArea);
        if (fragment != null) {
            TypePage.matchFragmentAndAddDocumentRange(fragment, this.declarations, ranges);
        }
        if (query != null) {
            parameters = this.parseQuery(query);
            if (parameters.containsKey("lineNumber")) {
                lineNumber = parameters.get("lineNumber");
                try {
                    this.goToLineNumber(Integer.parseInt(lineNumber));
                    return true;
                }
                catch (NumberFormatException e) {
                    if (!TypePage.$assertionsDisabled && !ExceptionUtil.printStackTrace(e)) {
                        throw new AssertionError();
                    }
                }
            } else if (parameters.containsKey("position")) {
                position = parameters.get("position");
                try {
                    pos = Integer.parseInt(position);
                    if (this.textArea.getDocument().getLength() <= pos) ** GOTO lbl31
                    ranges.add(new DocumentRange(pos, pos));
                }
                catch (NumberFormatException e) {
                    if (!TypePage.$assertionsDisabled && !ExceptionUtil.printStackTrace(e)) {
                        throw new AssertionError();
                    }
                }
            } else {
                TypePage.matchQueryAndAddDocumentRange(parameters, this.declarations, this.hyperlinks, this.strings, ranges);
            }
        }
lbl31:
        // 7 sources

        if (ranges != null && !ranges.isEmpty()) {
            this.textArea.setMarkAllHighlightColor(TypePage.SELECT_HIGHLIGHT_COLOR);
            Marker.markAll(this.textArea, ranges);
            ranges.sort(null);
            this.setCaretPositionAndCenter(ranges.get(0));
        }
        return true;
    }

    public static void matchFragmentAndAddDocumentRange(String fragment, HashMap<String, DeclarationData> declarations, List<DocumentRange> ranges) {
        if (fragment.indexOf(63) != -1 || fragment.indexOf(42) != -1) {
            int lastDash = fragment.lastIndexOf(45);
            if (lastDash == -1) {
                String slashAndTypeName = fragment.substring(1);
                String typeName = fragment.substring(2);
                for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                    if (!entry.getKey().endsWith(slashAndTypeName) && !entry.getKey().equals(typeName)) continue;
                    ranges.add(new DocumentRange(entry.getValue().startPosition, entry.getValue().endPosition));
                }
            } else {
                String prefix = fragment.substring(0, lastDash + 1);
                String suffix = fragment.substring(lastDash + 1);
                BiFunction<String, String, Boolean> matchDescriptors = suffix.charAt(0) == '(' ? DescriptorMatcher::matchMethodDescriptors : DescriptorMatcher::matchFieldDescriptors;
                if (fragment.charAt(0) == '*') {
                    String slashAndTypeNameAndName = prefix.substring(1);
                    String typeNameAndName = prefix.substring(2);
                    for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                        int index;
                        String key = entry.getKey();
                        if (key.indexOf(slashAndTypeNameAndName) == -1 && !key.startsWith(typeNameAndName) || !matchDescriptors.apply(suffix, key.substring(index = key.lastIndexOf(45) + 1)).booleanValue()) continue;
                        ranges.add(new DocumentRange(entry.getValue().startPosition, entry.getValue().endPosition));
                    }
                } else {
                    for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                        int index;
                        String key = entry.getKey();
                        if (!key.startsWith(prefix) || !matchDescriptors.apply(suffix, key.substring(index = key.lastIndexOf(45) + 1)).booleanValue()) continue;
                        ranges.add(new DocumentRange(entry.getValue().startPosition, entry.getValue().endPosition));
                    }
                }
            }
        } else {
            DeclarationData data = declarations.get(fragment);
            if (data != null) {
                ranges.add(new DocumentRange(data.startPosition, data.endPosition));
            } else if (fragment.endsWith("-<clinit>-()V")) {
                String typeName = fragment.substring(0, fragment.indexOf(45));
                data = declarations.get(typeName);
                ranges.add(new DocumentRange(data.startPosition, data.endPosition));
            }
        }
    }

    public static void matchQueryAndAddDocumentRange(Map<String, String> parameters, HashMap<String, DeclarationData> declarations, TreeMap<Integer, HyperlinkPage.HyperlinkData> hyperlinks, ArrayList<StringData> strings, List<DocumentRange> ranges) {
        String highlightFlags = parameters.get("highlightFlags");
        String highlightPattern = parameters.get("highlightPattern");
        if (highlightFlags != null && highlightPattern != null) {
            boolean c;
            String highlightScope = parameters.get("highlightScope");
            String regexp = TypePage.createRegExp(highlightPattern);
            Pattern pattern = Pattern.compile(regexp + ".*");
            if (highlightFlags.indexOf(115) != -1) {
                Pattern patternForString = Pattern.compile(regexp);
                for (StringData data : strings) {
                    if (!TypePage.matchScope(highlightScope, data.owner)) continue;
                    Matcher matcher = patternForString.matcher(data.text);
                    int offset = data.startPosition;
                    while (matcher.find()) {
                        ranges.add(new DocumentRange(offset + matcher.start(), offset + matcher.end()));
                    }
                }
            }
            boolean t = highlightFlags.indexOf(116) != -1;
            boolean f = highlightFlags.indexOf(102) != -1;
            boolean m = highlightFlags.indexOf(109) != -1;
            boolean bl = c = highlightFlags.indexOf(99) != -1;
            if (highlightFlags.indexOf(100) != -1) {
                for (Map.Entry<String, DeclarationData> entry : declarations.entrySet()) {
                    DeclarationData declaration = entry.getValue();
                    if (!TypePage.matchScope(highlightScope, declaration.typeName)) continue;
                    if (t && declaration.isAType() || c && declaration.isAConstructor()) {
                        TypePage.matchAndAddDocumentRange(pattern, TypePage.getMostInnerTypeName(declaration.typeName), declaration.startPosition, declaration.endPosition, ranges);
                    }
                    if ((!f || !declaration.isAField()) && (!m || !declaration.isAMethod())) continue;
                    TypePage.matchAndAddDocumentRange(pattern, declaration.name, declaration.startPosition, declaration.endPosition, ranges);
                }
            }
            if (highlightFlags.indexOf(114) != -1) {
                for (Map.Entry<Integer, HyperlinkPage.HyperlinkData> entry : hyperlinks.entrySet()) {
                    HyperlinkPage.HyperlinkData hyperlink = entry.getValue();
                    ReferenceData reference = ((HyperlinkReferenceData)hyperlink).reference;
                    if (!TypePage.matchScope(highlightScope, reference.owner)) continue;
                    if (t && reference.isAType() || c && reference.isAConstructor()) {
                        TypePage.matchAndAddDocumentRange(pattern, TypePage.getMostInnerTypeName(reference.typeName), hyperlink.startPosition, hyperlink.endPosition, ranges);
                    }
                    if ((!f || !reference.isAField()) && (!m || !reference.isAMethod())) continue;
                    TypePage.matchAndAddDocumentRange(pattern, reference.name, hyperlink.startPosition, hyperlink.endPosition, ranges);
                }
            }
        }
    }

    public static boolean matchScope(String scope, String type) {
        if (scope == null || scope.isEmpty()) {
            return true;
        }
        if (scope.charAt(0) == '*') {
            return type.endsWith(scope.substring(1)) || type.equals(scope.substring(2));
        }
        return type.equals(scope);
    }

    public static void matchAndAddDocumentRange(Pattern pattern, String text, int start, int end, List<DocumentRange> ranges) {
        if (pattern.matcher(text).matches()) {
            ranges.add(new DocumentRange(start, end));
        }
    }

    public static String getMostInnerTypeName(String typeName) {
        int lastPackageSeparatorIndex = typeName.lastIndexOf(47) + 1;
        int lastTypeNameSeparatorIndex = typeName.lastIndexOf(36) + 1;
        int lastIndex = Math.max(lastPackageSeparatorIndex, lastTypeNameSeparatorIndex);
        return typeName.substring(lastIndex);
    }

    @Override
    public String getFocusedTypeName() {
        DeclarationData data;
        Map.Entry<Integer, DeclarationData> entry = this.typeDeclarations.floorEntry(this.textArea.getCaretPosition());
        if (entry != null && (data = entry.getValue()) != null) {
            return data.typeName;
        }
        return null;
    }

    @Override
    public Container.Entry getEntry() {
        return this.entry;
    }

    @Override
    public void indexesChanged(Collection<Future<Indexes>> collectionOfFutureIndexes) {
        this.collectionOfFutureIndexes = collectionOfFutureIndexes;
        boolean refresh = false;
        for (ReferenceData reference : this.references) {
            boolean enabled;
            String typeName = reference.typeName;
            if (reference.name == null) {
                enabled = false;
                try {
                    for (Future<Indexes> futureIndexes : collectionOfFutureIndexes) {
                        Map<String, Collection> index;
                        if (!futureIndexes.isDone() || (index = futureIndexes.get().getIndex("typeDeclarations")) == null || index.get(typeName) == null) continue;
                        enabled = true;
                    }
                }
                catch (Exception e) {
                    assert (ExceptionUtil.printStackTrace(e));
                }
            } else {
                try {
                    typeName = this.searchTypeHavingMember(typeName, reference.name, reference.descriptor, this.entry);
                    if (typeName != null) {
                        reference.typeName = typeName;
                        enabled = true;
                    } else {
                        enabled = false;
                    }
                }
                catch (Error e) {
                    assert (ExceptionUtil.printStackTrace(e));
                    enabled = false;
                }
            }
            if (reference.enabled == enabled) continue;
            reference.enabled = enabled;
            refresh = true;
        }
        if (refresh) {
            this.textArea.repaint();
        }
    }

    protected String searchTypeHavingMember(String typeName, String name, String descriptor, Container.Entry entry) {
        ArrayList<Container.Entry> entries;
        block5: {
            entries = new ArrayList<Container.Entry>();
            try {
                for (Future<Indexes> futureIndexes : this.collectionOfFutureIndexes) {
                    Collection collection;
                    Map<String, Collection> index;
                    if (!futureIndexes.isDone() || (index = futureIndexes.get().getIndex("typeDeclarations")) == null || (collection = index.get(typeName)) == null) continue;
                    entries.addAll(collection);
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block5;
                throw new AssertionError();
            }
        }
        String rootUri = entry.getContainer().getRoot().getUri().toString();
        ArrayList<Container.Entry> sameContainerEntries = new ArrayList<Container.Entry>();
        for (Container.Entry e : entries) {
            if (!e.getUri().toString().startsWith(rootUri)) continue;
            sameContainerEntries.add(e);
        }
        if (sameContainerEntries.size() > 0) {
            return this.searchTypeHavingMember(typeName, name, descriptor, sameContainerEntries);
        }
        return this.searchTypeHavingMember(typeName, name, descriptor, entries);
    }

    protected String searchTypeHavingMember(String typeName, String name, String descriptor, List<Container.Entry> entries) {
        for (Container.Entry entry : entries) {
            String typeOwnerName;
            Type type = this.api.getTypeFactory(entry).make(this.api, entry, typeName);
            if (type == null) continue;
            if (descriptor.indexOf(40) == -1) {
                for (Type.Field field : type.getFields()) {
                    if (!field.getName().equals(name) || !DescriptorMatcher.matchFieldDescriptors(field.getDescriptor(), descriptor)) continue;
                    return typeName;
                }
            } else {
                for (Type.Method method : type.getMethods()) {
                    if (!method.getName().equals(name) || !DescriptorMatcher.matchMethodDescriptors(method.getDescriptor(), descriptor)) continue;
                    return typeName;
                }
            }
            if ((typeOwnerName = this.searchTypeHavingMember(type.getSuperName(), name, descriptor, entry)) == null) continue;
            return typeOwnerName;
        }
        return null;
    }

    public static class HyperlinkReferenceData
    extends HyperlinkPage.HyperlinkData {
        public ReferenceData reference;

        public HyperlinkReferenceData(int startPosition, int length, ReferenceData reference) {
            super(startPosition, startPosition + length);
            this.reference = reference;
        }
    }

    protected static class ReferenceData {
        public String typeName;
        public String name;
        public String descriptor;
        public String owner;
        public boolean enabled = false;

        public ReferenceData(String typeName, String name, String descriptor, String owner) {
            this.typeName = typeName;
            this.name = name;
            this.descriptor = descriptor;
            this.owner = owner;
        }

        boolean isAType() {
            return this.name == null;
        }

        boolean isAField() {
            return this.descriptor != null && this.descriptor.charAt(0) != '(';
        }

        boolean isAMethod() {
            return this.descriptor != null && this.descriptor.charAt(0) == '(';
        }

        boolean isAConstructor() {
            return "<init>".equals(this.name);
        }
    }

    public static class DeclarationData {
        int startPosition;
        int endPosition;
        String typeName;
        String name;
        String descriptor;

        public DeclarationData(int startPosition, int length, String typeName, String name, String descriptor) {
            this.startPosition = startPosition;
            this.endPosition = startPosition + length;
            this.typeName = typeName;
            this.name = name;
            this.descriptor = descriptor;
        }

        public boolean isAType() {
            return this.name == null;
        }

        public boolean isAField() {
            return this.descriptor != null && this.descriptor.charAt(0) != '(';
        }

        public boolean isAMethod() {
            return this.descriptor != null && this.descriptor.charAt(0) == '(';
        }

        public boolean isAConstructor() {
            return "<init>".equals(this.name);
        }
    }

    public static class StringData {
        int startPosition;
        int endPosition;
        String text;
        String owner;

        public StringData(int startPosition, int length, String text, String owner) {
            this.startPosition = startPosition;
            this.endPosition = startPosition + length;
            this.text = text;
            this.owner = owner;
        }
    }
}

