/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.view.component.panel;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.ContainerEntryGettable;
import org.jd.gui.api.feature.PreferencesChangeListener;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.service.platform.PlatformService;

public class TabbedPanel<T extends JComponent>
extends JPanel
implements PreferencesChangeListener {
    protected static final ImageIcon CLOSE_ICON = new ImageIcon(TabbedPanel.class.getClassLoader().getResource("org/jd/gui/images/close.gif"));
    protected static final ImageIcon CLOSE_ACTIVE_ICON = new ImageIcon(TabbedPanel.class.getClassLoader().getResource("org/jd/gui/images/close_active.gif"));
    protected static final String TAB_LAYOUT = "UITabsPreferencesProvider.singleLineTabs";
    protected API api;
    protected CardLayout cardLayout;
    protected JTabbedPane tabbedPane;
    protected Map<String, String> preferences;

    public TabbedPanel(API api) {
        this.api = api;
        this.create();
    }

    protected void create() {
        this.cardLayout = new CardLayout();
        this.setLayout(this.cardLayout);
        this.add("panel", new JPanel());
        this.tabbedPane = this.createTabPanel();
        this.add("tabs", this.tabbedPane);
    }

    protected JTabbedPane createTabPanel() {
        final JTabbedPane tabPanel = new JTabbedPane(){

            @Override
            public String getToolTipText(MouseEvent e) {
                int index = this.indexAtLocation(e.getX(), e.getY());
                if (index != -1) {
                    return ((JComponent)this.getTabComponentAt(index)).getToolTipText();
                }
                return super.getToolTipText(e);
            }
        };
        ToolTipManager.sharedInstance().registerComponent(tabPanel);
        tabPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.showPopupTabMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.showPopupTabMenu(e);
            }

            protected void showPopupTabMenu(MouseEvent e) {
                int index;
                if (e.isPopupTrigger() && (index = tabPanel.indexAtLocation(e.getX(), e.getY())) != -1) {
                    new PopupTabMenu(tabPanel.getComponentAt(index)).show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        return tabPanel;
    }

    protected static Color darker(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.85), 0), Math.max((int)((double)c.getGreen() * 0.85), 0), Math.max((int)((double)c.getBlue() * 0.85), 0), c.getAlpha());
    }

    public void addPage(String title, Icon icon, String tip, T page) {
        JLabel tabCloseButton = new JLabel(CLOSE_ICON);
        tabCloseButton.setToolTipText("Close this panel");
        tabCloseButton.addMouseListener(new MouseListener(){
            final /* synthetic */ JComponent val$page;
            {
                this.val$page = jComponent;
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                ((JLabel)e.getSource()).setIcon(CLOSE_ACTIVE_ICON);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ((JLabel)e.getSource()).setIcon(CLOSE_ICON);
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TabbedPanel.this.removeComponent(this.val$page);
            }
        });
        JPanel tab = new JPanel(new BorderLayout());
        tab.setBorder(BorderFactory.createEmptyBorder(2, 0, 3, 0));
        tab.setOpaque(false);
        tab.setToolTipText(tip);
        tab.add((Component)new JLabel(title, icon, 10), "Center");
        tab.add((Component)tabCloseButton, "East");
        ToolTipManager.sharedInstance().unregisterComponent(tab);
        int index = this.tabbedPane.getTabCount();
        this.tabbedPane.addTab(title, (Component)page);
        this.tabbedPane.setTabComponentAt(index, tab);
        this.setSelectedIndex(index);
        this.cardLayout.show(this, "tabs");
    }

    protected void setSelectedIndex(int index) {
        if (index != -1) {
            if (this.tabbedPane.getTabLayoutPolicy() == 1) {
                ChangeEvent event = new ChangeEvent(this.tabbedPane);
                for (ChangeListener listener : this.tabbedPane.getChangeListeners()) {
                    if (!listener.getClass().getPackage().getName().startsWith("javax.")) continue;
                    listener.stateChanged(event);
                }
            }
            this.tabbedPane.setSelectedIndex(index);
        }
    }

    protected T showPage(URI uri) {
        String u1 = uri.getPath();
        int i = this.tabbedPane.getTabCount();
        while (i-- > 0) {
            JComponent page = (JComponent)this.tabbedPane.getComponentAt(i);
            String u2 = ((UriGettable)((Object)page)).getUri().getPath();
            if (u2.isEmpty() || !u1.startsWith(u2)) continue;
            this.tabbedPane.setSelectedIndex(i);
            return (T)page;
        }
        return null;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public void removeComponent(Component component) {
        this.tabbedPane.remove(component);
        if (this.tabbedPane.getTabCount() == 0) {
            this.cardLayout.show(this, "panel");
        }
    }

    protected void removeOtherComponents(Component component) {
        int i = this.tabbedPane.getTabCount();
        while (i-- > 0) {
            Component c = this.tabbedPane.getComponentAt(i);
            if (c == component) continue;
            this.tabbedPane.remove(i);
        }
        if (this.tabbedPane.getTabCount() == 0) {
            this.cardLayout.show(this, "panel");
        }
    }

    protected void removeAllComponents() {
        this.tabbedPane.removeAll();
        if (this.tabbedPane.getTabCount() == 0) {
            this.cardLayout.show(this, "panel");
        }
    }

    @Override
    public void preferencesChanged(Map<String, String> preferences) {
        this.preferences = preferences;
        if ("true".equals(preferences.get(TAB_LAYOUT))) {
            this.tabbedPane.setTabLayoutPolicy(1);
        } else {
            this.tabbedPane.setTabLayoutPolicy(0);
        }
        this.setSelectedIndex(this.tabbedPane.getSelectedIndex());
    }

    protected class SubMenuItemActionListener
    implements ActionListener {
        protected int index;

        public SubMenuItemActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedPanel.this.tabbedPane.setSelectedIndex(this.index);
        }
    }

    protected class PopupTabMenu
    extends JPopupMenu {
        public PopupTabMenu(Component component) {
            Collection<Action> actions;
            JMenuItem menuItem = new JMenuItem("Close", null);
            menuItem.addActionListener(e -> TabbedPanel.this.removeComponent(component));
            this.add(menuItem);
            menuItem = new JMenuItem("Close Others", null);
            menuItem.addActionListener(e -> TabbedPanel.this.removeOtherComponents(component));
            this.add(menuItem);
            menuItem = new JMenuItem("Close All", null);
            menuItem.addActionListener(e -> TabbedPanel.this.removeAllComponents());
            this.add(menuItem);
            if (TabbedPanel.this.tabbedPane.getTabCount() > 1 && (PlatformService.getInstance().isMac() || "true".equals(TabbedPanel.this.preferences.get(TabbedPanel.TAB_LAYOUT)))) {
                this.addSeparator();
                JMenu menu = new JMenu("Select Tab");
                int count = TabbedPanel.this.tabbedPane.getTabCount();
                for (int i = 0; i < count; ++i) {
                    JPanel tab = (JPanel)TabbedPanel.this.tabbedPane.getTabComponentAt(i);
                    JLabel label = (JLabel)tab.getComponent(0);
                    JMenuItem subMenuItem = new JMenuItem(label.getText(), label.getIcon());
                    subMenuItem.addActionListener(new SubMenuItemActionListener(i));
                    if (component == TabbedPanel.this.tabbedPane.getComponentAt(i)) {
                        subMenuItem.setFont(subMenuItem.getFont().deriveFont(1));
                    }
                    menu.add(subMenuItem);
                }
                this.add(menu);
            }
            if (component instanceof ContainerEntryGettable && (actions = TabbedPanel.this.api.getContextualActions(((ContainerEntryGettable)((Object)component)).getEntry(), null)) != null) {
                this.addSeparator();
                for (Action action : actions) {
                    if (action != null) {
                        this.add(action);
                        continue;
                    }
                    this.addSeparator();
                }
            }
        }
    }
}

