// IWYU pragma: private, include "nvim/option_defs.h"

typedef enum {
  kOptInvalid = -1,
  kOptAleph = 0,
  kOptAllowrevins = 1,
  kOptAmbiwidth = 2,
  kOptArabic = 3,
  kOptArabicshape = 4,
  kOptAutochdir = 5,
  kOptAutoindent = 6,
  kOptAutoread = 7,
  kOptAutowrite = 8,
  kOptAutowriteall = 9,
  kOptBackground = 10,
  kOptBackspace = 11,
  kOptBackup = 12,
  kOptBackupcopy = 13,
  kOptBackupdir = 14,
  kOptBackupext = 15,
  kOptBackupskip = 16,
  kOptBelloff = 17,
  kOptBinary = 18,
  kOptBomb = 19,
  kOptBreakat = 20,
  kOptBreakindent = 21,
  kOptBreakindentopt = 22,
  kOptBrowsedir = 23,
  kOptBufhidden = 24,
  kOptBuflisted = 25,
  kOptBuftype = 26,
  kOptCasemap = 27,
  kOptCdhome = 28,
  kOptCdpath = 29,
  kOptCedit = 30,
  kOptChannel = 31,
  kOptCharconvert = 32,
  kOptCindent = 33,
  kOptCinkeys = 34,
  kOptCinoptions = 35,
  kOptCinscopedecls = 36,
  kOptCinwords = 37,
  kOptClipboard = 38,
  kOptCmdheight = 39,
  kOptCmdwinheight = 40,
  kOptColorcolumn = 41,
  kOptColumns = 42,
  kOptComments = 43,
  kOptCommentstring = 44,
  kOptCompatible = 45,
  kOptComplete = 46,
  kOptCompletefunc = 47,
  kOptCompletefuzzycollect = 48,
  kOptCompleteitemalign = 49,
  kOptCompleteopt = 50,
  kOptCompleteslash = 51,
  kOptConcealcursor = 52,
  kOptConceallevel = 53,
  kOptConfirm = 54,
  kOptCopyindent = 55,
  kOptCpoptions = 56,
  kOptCursorbind = 57,
  kOptCursorcolumn = 58,
  kOptCursorline = 59,
  kOptCursorlineopt = 60,
  kOptDebug = 61,
  kOptDefine = 62,
  kOptDelcombine = 63,
  kOptDictionary = 64,
  kOptDiff = 65,
  kOptDiffexpr = 66,
  kOptDiffopt = 67,
  kOptDigraph = 68,
  kOptDirectory = 69,
  kOptDisplay = 70,
  kOptEadirection = 71,
  kOptEdcompatible = 72,
  kOptEmoji = 73,
  kOptEncoding = 74,
  kOptEndoffile = 75,
  kOptEndofline = 76,
  kOptEqualalways = 77,
  kOptEqualprg = 78,
  kOptErrorbells = 79,
  kOptErrorfile = 80,
  kOptErrorformat = 81,
  kOptEventignore = 82,
  kOptEventignorewin = 83,
  kOptExpandtab = 84,
  kOptExrc = 85,
  kOptFileencoding = 86,
  kOptFileencodings = 87,
  kOptFileformat = 88,
  kOptFileformats = 89,
  kOptFileignorecase = 90,
  kOptFiletype = 91,
  kOptFillchars = 92,
  kOptFindfunc = 93,
  kOptFixendofline = 94,
  kOptFoldclose = 95,
  kOptFoldcolumn = 96,
  kOptFoldenable = 97,
  kOptFoldexpr = 98,
  kOptFoldignore = 99,
  kOptFoldlevel = 100,
  kOptFoldlevelstart = 101,
  kOptFoldmarker = 102,
  kOptFoldmethod = 103,
  kOptFoldminlines = 104,
  kOptFoldnestmax = 105,
  kOptFoldopen = 106,
  kOptFoldtext = 107,
  kOptFormatexpr = 108,
  kOptFormatlistpat = 109,
  kOptFormatoptions = 110,
  kOptFormatprg = 111,
  kOptFsync = 112,
  kOptGdefault = 113,
  kOptGrepformat = 114,
  kOptGrepprg = 115,
  kOptGuicursor = 116,
  kOptGuifont = 117,
  kOptGuifontwide = 118,
  kOptGuioptions = 119,
  kOptGuitablabel = 120,
  kOptGuitabtooltip = 121,
  kOptHelpfile = 122,
  kOptHelpheight = 123,
  kOptHelplang = 124,
  kOptHidden = 125,
  kOptHighlight = 126,
  kOptHistory = 127,
  kOptHkmap = 128,
  kOptHkmapp = 129,
  kOptHlsearch = 130,
  kOptIcon = 131,
  kOptIconstring = 132,
  kOptIgnorecase = 133,
  kOptImcmdline = 134,
  kOptImdisable = 135,
  kOptIminsert = 136,
  kOptImsearch = 137,
  kOptInccommand = 138,
  kOptInclude = 139,
  kOptIncludeexpr = 140,
  kOptIncsearch = 141,
  kOptIndentexpr = 142,
  kOptIndentkeys = 143,
  kOptInfercase = 144,
  kOptInsertmode = 145,
  kOptIsfname = 146,
  kOptIsident = 147,
  kOptIskeyword = 148,
  kOptIsprint = 149,
  kOptJoinspaces = 150,
  kOptJumpoptions = 151,
  kOptKeymap = 152,
  kOptKeymodel = 153,
  kOptKeywordprg = 154,
  kOptLangmap = 155,
  kOptLangmenu = 156,
  kOptLangnoremap = 157,
  kOptLangremap = 158,
  kOptLaststatus = 159,
  kOptLazyredraw = 160,
  kOptLinebreak = 161,
  kOptLines = 162,
  kOptLinespace = 163,
  kOptLisp = 164,
  kOptLispoptions = 165,
  kOptLispwords = 166,
  kOptList = 167,
  kOptListchars = 168,
  kOptLoadplugins = 169,
  kOptMagic = 170,
  kOptMakeef = 171,
  kOptMakeencoding = 172,
  kOptMakeprg = 173,
  kOptMatchpairs = 174,
  kOptMatchtime = 175,
  kOptMaxcombine = 176,
  kOptMaxfuncdepth = 177,
  kOptMaxmapdepth = 178,
  kOptMaxmempattern = 179,
  kOptMenuitems = 180,
  kOptMessagesopt = 181,
  kOptMkspellmem = 182,
  kOptModeline = 183,
  kOptModelineexpr = 184,
  kOptModelines = 185,
  kOptModifiable = 186,
  kOptModified = 187,
  kOptMore = 188,
  kOptMouse = 189,
  kOptMousefocus = 190,
  kOptMousehide = 191,
  kOptMousemodel = 192,
  kOptMousemoveevent = 193,
  kOptMousescroll = 194,
  kOptMouseshape = 195,
  kOptMousetime = 196,
  kOptNrformats = 197,
  kOptNumber = 198,
  kOptNumberwidth = 199,
  kOptOmnifunc = 200,
  kOptOpendevice = 201,
  kOptOperatorfunc = 202,
  kOptPackpath = 203,
  kOptParagraphs = 204,
  kOptPaste = 205,
  kOptPastetoggle = 206,
  kOptPatchexpr = 207,
  kOptPatchmode = 208,
  kOptPath = 209,
  kOptPreserveindent = 210,
  kOptPreviewheight = 211,
  kOptPreviewwindow = 212,
  kOptPrompt = 213,
  kOptPumblend = 214,
  kOptPumheight = 215,
  kOptPummaxwidth = 216,
  kOptPumwidth = 217,
  kOptPyxversion = 218,
  kOptQuickfixtextfunc = 219,
  kOptQuoteescape = 220,
  kOptReadonly = 221,
  kOptRedrawdebug = 222,
  kOptRedrawtime = 223,
  kOptRegexpengine = 224,
  kOptRelativenumber = 225,
  kOptRemap = 226,
  kOptReport = 227,
  kOptRevins = 228,
  kOptRightleft = 229,
  kOptRightleftcmd = 230,
  kOptRuler = 231,
  kOptRulerformat = 232,
  kOptRuntimepath = 233,
  kOptScroll = 234,
  kOptScrollback = 235,
  kOptScrollbind = 236,
  kOptScrolljump = 237,
  kOptScrolloff = 238,
  kOptScrollopt = 239,
  kOptSections = 240,
  kOptSecure = 241,
  kOptSelection = 242,
  kOptSelectmode = 243,
  kOptSessionoptions = 244,
  kOptShada = 245,
  kOptShadafile = 246,
  kOptShell = 247,
  kOptShellcmdflag = 248,
  kOptShellpipe = 249,
  kOptShellquote = 250,
  kOptShellredir = 251,
  kOptShellslash = 252,
  kOptShelltemp = 253,
  kOptShellxescape = 254,
  kOptShellxquote = 255,
  kOptShiftround = 256,
  kOptShiftwidth = 257,
  kOptShortmess = 258,
  kOptShowbreak = 259,
  kOptShowcmd = 260,
  kOptShowcmdloc = 261,
  kOptShowfulltag = 262,
  kOptShowmatch = 263,
  kOptShowmode = 264,
  kOptShowtabline = 265,
  kOptSidescroll = 266,
  kOptSidescrolloff = 267,
  kOptSigncolumn = 268,
  kOptSmartcase = 269,
  kOptSmartindent = 270,
  kOptSmarttab = 271,
  kOptSmoothscroll = 272,
  kOptSofttabstop = 273,
  kOptSpell = 274,
  kOptSpellcapcheck = 275,
  kOptSpellfile = 276,
  kOptSpelllang = 277,
  kOptSpelloptions = 278,
  kOptSpellsuggest = 279,
  kOptSplitbelow = 280,
  kOptSplitkeep = 281,
  kOptSplitright = 282,
  kOptStartofline = 283,
  kOptStatuscolumn = 284,
  kOptStatusline = 285,
  kOptSuffixes = 286,
  kOptSuffixesadd = 287,
  kOptSwapfile = 288,
  kOptSwitchbuf = 289,
  kOptSynmaxcol = 290,
  kOptSyntax = 291,
  kOptTabclose = 292,
  kOptTabline = 293,
  kOptTabpagemax = 294,
  kOptTabstop = 295,
  kOptTagbsearch = 296,
  kOptTagcase = 297,
  kOptTagfunc = 298,
  kOptTaglength = 299,
  kOptTagrelative = 300,
  kOptTags = 301,
  kOptTagstack = 302,
  kOptTermbidi = 303,
  kOptTermencoding = 304,
  kOptTermguicolors = 305,
  kOptTermpastefilter = 306,
  kOptTermsync = 307,
  kOptTerse = 308,
  kOptTextwidth = 309,
  kOptThesaurus = 310,
  kOptThesaurusfunc = 311,
  kOptTildeop = 312,
  kOptTimeout = 313,
  kOptTimeoutlen = 314,
  kOptTitle = 315,
  kOptTitlelen = 316,
  kOptTitleold = 317,
  kOptTitlestring = 318,
  kOptTtimeout = 319,
  kOptTtimeoutlen = 320,
  kOptTtyfast = 321,
  kOptUndodir = 322,
  kOptUndofile = 323,
  kOptUndolevels = 324,
  kOptUndoreload = 325,
  kOptUpdatecount = 326,
  kOptUpdatetime = 327,
  kOptVarsofttabstop = 328,
  kOptVartabstop = 329,
  kOptVerbose = 330,
  kOptVerbosefile = 331,
  kOptViewdir = 332,
  kOptViewoptions = 333,
  kOptVirtualedit = 334,
  kOptVisualbell = 335,
  kOptWarn = 336,
  kOptWhichwrap = 337,
  kOptWildchar = 338,
  kOptWildcharm = 339,
  kOptWildignore = 340,
  kOptWildignorecase = 341,
  kOptWildmenu = 342,
  kOptWildmode = 343,
  kOptWildoptions = 344,
  kOptWinaltkeys = 345,
  kOptWinbar = 346,
  kOptWinblend = 347,
  kOptWinborder = 348,
  kOptWindow = 349,
  kOptWinfixbuf = 350,
  kOptWinfixheight = 351,
  kOptWinfixwidth = 352,
  kOptWinheight = 353,
  kOptWinhighlight = 354,
  kOptWinminheight = 355,
  kOptWinminwidth = 356,
  kOptWinwidth = 357,
  kOptWrap = 358,
  kOptWrapmargin = 359,
  kOptWrapscan = 360,
  kOptWrite = 361,
  kOptWriteany = 362,
  kOptWritebackup = 363,
  kOptWritedelay = 364,
  // Option count
#define kOptCount 365
} OptIndex;

typedef enum {
  kGlobalOptInvalid = -1,
  kGlobalOptAleph = 0,
  kGlobalOptAllowrevins = 1,
  kGlobalOptAmbiwidth = 2,
  kGlobalOptArabicshape = 3,
  kGlobalOptAutochdir = 4,
  kGlobalOptAutoread = 5,
  kGlobalOptAutowrite = 6,
  kGlobalOptAutowriteall = 7,
  kGlobalOptBackground = 8,
  kGlobalOptBackspace = 9,
  kGlobalOptBackup = 10,
  kGlobalOptBackupcopy = 11,
  kGlobalOptBackupdir = 12,
  kGlobalOptBackupext = 13,
  kGlobalOptBackupskip = 14,
  kGlobalOptBelloff = 15,
  kGlobalOptBreakat = 16,
  kGlobalOptBrowsedir = 17,
  kGlobalOptCasemap = 18,
  kGlobalOptCdhome = 19,
  kGlobalOptCdpath = 20,
  kGlobalOptCedit = 21,
  kGlobalOptCharconvert = 22,
  kGlobalOptClipboard = 23,
  kGlobalOptCmdheight = 24,
  kGlobalOptCmdwinheight = 25,
  kGlobalOptColumns = 26,
  kGlobalOptCompatible = 27,
  kGlobalOptCompletefuzzycollect = 28,
  kGlobalOptCompleteitemalign = 29,
  kGlobalOptCompleteopt = 30,
  kGlobalOptConfirm = 31,
  kGlobalOptCpoptions = 32,
  kGlobalOptDebug = 33,
  kGlobalOptDefine = 34,
  kGlobalOptDelcombine = 35,
  kGlobalOptDictionary = 36,
  kGlobalOptDiffexpr = 37,
  kGlobalOptDiffopt = 38,
  kGlobalOptDigraph = 39,
  kGlobalOptDirectory = 40,
  kGlobalOptDisplay = 41,
  kGlobalOptEadirection = 42,
  kGlobalOptEdcompatible = 43,
  kGlobalOptEmoji = 44,
  kGlobalOptEncoding = 45,
  kGlobalOptEqualalways = 46,
  kGlobalOptEqualprg = 47,
  kGlobalOptErrorbells = 48,
  kGlobalOptErrorfile = 49,
  kGlobalOptErrorformat = 50,
  kGlobalOptEventignore = 51,
  kGlobalOptExrc = 52,
  kGlobalOptFileencodings = 53,
  kGlobalOptFileformats = 54,
  kGlobalOptFileignorecase = 55,
  kGlobalOptFillchars = 56,
  kGlobalOptFindfunc = 57,
  kGlobalOptFoldclose = 58,
  kGlobalOptFoldlevelstart = 59,
  kGlobalOptFoldopen = 60,
  kGlobalOptFormatprg = 61,
  kGlobalOptFsync = 62,
  kGlobalOptGdefault = 63,
  kGlobalOptGrepformat = 64,
  kGlobalOptGrepprg = 65,
  kGlobalOptGuicursor = 66,
  kGlobalOptGuifont = 67,
  kGlobalOptGuifontwide = 68,
  kGlobalOptGuioptions = 69,
  kGlobalOptGuitablabel = 70,
  kGlobalOptGuitabtooltip = 71,
  kGlobalOptHelpfile = 72,
  kGlobalOptHelpheight = 73,
  kGlobalOptHelplang = 74,
  kGlobalOptHidden = 75,
  kGlobalOptHighlight = 76,
  kGlobalOptHistory = 77,
  kGlobalOptHkmap = 78,
  kGlobalOptHkmapp = 79,
  kGlobalOptHlsearch = 80,
  kGlobalOptIcon = 81,
  kGlobalOptIconstring = 82,
  kGlobalOptIgnorecase = 83,
  kGlobalOptImcmdline = 84,
  kGlobalOptImdisable = 85,
  kGlobalOptInccommand = 86,
  kGlobalOptInclude = 87,
  kGlobalOptIncsearch = 88,
  kGlobalOptInsertmode = 89,
  kGlobalOptIsfname = 90,
  kGlobalOptIsident = 91,
  kGlobalOptIsprint = 92,
  kGlobalOptJoinspaces = 93,
  kGlobalOptJumpoptions = 94,
  kGlobalOptKeymodel = 95,
  kGlobalOptKeywordprg = 96,
  kGlobalOptLangmap = 97,
  kGlobalOptLangmenu = 98,
  kGlobalOptLangnoremap = 99,
  kGlobalOptLangremap = 100,
  kGlobalOptLaststatus = 101,
  kGlobalOptLazyredraw = 102,
  kGlobalOptLines = 103,
  kGlobalOptLinespace = 104,
  kGlobalOptLispwords = 105,
  kGlobalOptListchars = 106,
  kGlobalOptLoadplugins = 107,
  kGlobalOptMagic = 108,
  kGlobalOptMakeef = 109,
  kGlobalOptMakeencoding = 110,
  kGlobalOptMakeprg = 111,
  kGlobalOptMatchtime = 112,
  kGlobalOptMaxcombine = 113,
  kGlobalOptMaxfuncdepth = 114,
  kGlobalOptMaxmapdepth = 115,
  kGlobalOptMaxmempattern = 116,
  kGlobalOptMenuitems = 117,
  kGlobalOptMessagesopt = 118,
  kGlobalOptMkspellmem = 119,
  kGlobalOptModelineexpr = 120,
  kGlobalOptModelines = 121,
  kGlobalOptMore = 122,
  kGlobalOptMouse = 123,
  kGlobalOptMousefocus = 124,
  kGlobalOptMousehide = 125,
  kGlobalOptMousemodel = 126,
  kGlobalOptMousemoveevent = 127,
  kGlobalOptMousescroll = 128,
  kGlobalOptMouseshape = 129,
  kGlobalOptMousetime = 130,
  kGlobalOptOpendevice = 131,
  kGlobalOptOperatorfunc = 132,
  kGlobalOptPackpath = 133,
  kGlobalOptParagraphs = 134,
  kGlobalOptPaste = 135,
  kGlobalOptPastetoggle = 136,
  kGlobalOptPatchexpr = 137,
  kGlobalOptPatchmode = 138,
  kGlobalOptPath = 139,
  kGlobalOptPreviewheight = 140,
  kGlobalOptPrompt = 141,
  kGlobalOptPumblend = 142,
  kGlobalOptPumheight = 143,
  kGlobalOptPummaxwidth = 144,
  kGlobalOptPumwidth = 145,
  kGlobalOptPyxversion = 146,
  kGlobalOptQuickfixtextfunc = 147,
  kGlobalOptRedrawdebug = 148,
  kGlobalOptRedrawtime = 149,
  kGlobalOptRegexpengine = 150,
  kGlobalOptRemap = 151,
  kGlobalOptReport = 152,
  kGlobalOptRevins = 153,
  kGlobalOptRuler = 154,
  kGlobalOptRulerformat = 155,
  kGlobalOptRuntimepath = 156,
  kGlobalOptScrolljump = 157,
  kGlobalOptScrolloff = 158,
  kGlobalOptScrollopt = 159,
  kGlobalOptSections = 160,
  kGlobalOptSecure = 161,
  kGlobalOptSelection = 162,
  kGlobalOptSelectmode = 163,
  kGlobalOptSessionoptions = 164,
  kGlobalOptShada = 165,
  kGlobalOptShadafile = 166,
  kGlobalOptShell = 167,
  kGlobalOptShellcmdflag = 168,
  kGlobalOptShellpipe = 169,
  kGlobalOptShellquote = 170,
  kGlobalOptShellredir = 171,
  kGlobalOptShellslash = 172,
  kGlobalOptShelltemp = 173,
  kGlobalOptShellxescape = 174,
  kGlobalOptShellxquote = 175,
  kGlobalOptShiftround = 176,
  kGlobalOptShortmess = 177,
  kGlobalOptShowbreak = 178,
  kGlobalOptShowcmd = 179,
  kGlobalOptShowcmdloc = 180,
  kGlobalOptShowfulltag = 181,
  kGlobalOptShowmatch = 182,
  kGlobalOptShowmode = 183,
  kGlobalOptShowtabline = 184,
  kGlobalOptSidescroll = 185,
  kGlobalOptSidescrolloff = 186,
  kGlobalOptSmartcase = 187,
  kGlobalOptSmarttab = 188,
  kGlobalOptSpellsuggest = 189,
  kGlobalOptSplitbelow = 190,
  kGlobalOptSplitkeep = 191,
  kGlobalOptSplitright = 192,
  kGlobalOptStartofline = 193,
  kGlobalOptStatusline = 194,
  kGlobalOptSuffixes = 195,
  kGlobalOptSwitchbuf = 196,
  kGlobalOptTabclose = 197,
  kGlobalOptTabline = 198,
  kGlobalOptTabpagemax = 199,
  kGlobalOptTagbsearch = 200,
  kGlobalOptTagcase = 201,
  kGlobalOptTaglength = 202,
  kGlobalOptTagrelative = 203,
  kGlobalOptTags = 204,
  kGlobalOptTagstack = 205,
  kGlobalOptTermbidi = 206,
  kGlobalOptTermencoding = 207,
  kGlobalOptTermguicolors = 208,
  kGlobalOptTermpastefilter = 209,
  kGlobalOptTermsync = 210,
  kGlobalOptTerse = 211,
  kGlobalOptThesaurus = 212,
  kGlobalOptThesaurusfunc = 213,
  kGlobalOptTildeop = 214,
  kGlobalOptTimeout = 215,
  kGlobalOptTimeoutlen = 216,
  kGlobalOptTitle = 217,
  kGlobalOptTitlelen = 218,
  kGlobalOptTitleold = 219,
  kGlobalOptTitlestring = 220,
  kGlobalOptTtimeout = 221,
  kGlobalOptTtimeoutlen = 222,
  kGlobalOptTtyfast = 223,
  kGlobalOptUndodir = 224,
  kGlobalOptUndolevels = 225,
  kGlobalOptUndoreload = 226,
  kGlobalOptUpdatecount = 227,
  kGlobalOptUpdatetime = 228,
  kGlobalOptVerbose = 229,
  kGlobalOptVerbosefile = 230,
  kGlobalOptViewdir = 231,
  kGlobalOptViewoptions = 232,
  kGlobalOptVirtualedit = 233,
  kGlobalOptVisualbell = 234,
  kGlobalOptWarn = 235,
  kGlobalOptWhichwrap = 236,
  kGlobalOptWildchar = 237,
  kGlobalOptWildcharm = 238,
  kGlobalOptWildignore = 239,
  kGlobalOptWildignorecase = 240,
  kGlobalOptWildmenu = 241,
  kGlobalOptWildmode = 242,
  kGlobalOptWildoptions = 243,
  kGlobalOptWinaltkeys = 244,
  kGlobalOptWinbar = 245,
  kGlobalOptWinborder = 246,
  kGlobalOptWindow = 247,
  kGlobalOptWinheight = 248,
  kGlobalOptWinminheight = 249,
  kGlobalOptWinminwidth = 250,
  kGlobalOptWinwidth = 251,
  kGlobalOptWrapscan = 252,
  kGlobalOptWrite = 253,
  kGlobalOptWriteany = 254,
  kGlobalOptWritebackup = 255,
  kGlobalOptWritedelay = 256,
  // Global option count
#define kGlobalOptCount 257
} GlobalOptIndex;

typedef enum {
  kBufOptInvalid = -1,
  kBufOptAutoindent = 0,
  kBufOptAutoread = 1,
  kBufOptBackupcopy = 2,
  kBufOptBinary = 3,
  kBufOptBomb = 4,
  kBufOptBufhidden = 5,
  kBufOptBuflisted = 6,
  kBufOptBuftype = 7,
  kBufOptChannel = 8,
  kBufOptCindent = 9,
  kBufOptCinkeys = 10,
  kBufOptCinoptions = 11,
  kBufOptCinscopedecls = 12,
  kBufOptCinwords = 13,
  kBufOptComments = 14,
  kBufOptCommentstring = 15,
  kBufOptComplete = 16,
  kBufOptCompletefunc = 17,
  kBufOptCompleteopt = 18,
  kBufOptCompleteslash = 19,
  kBufOptCopyindent = 20,
  kBufOptDefine = 21,
  kBufOptDictionary = 22,
  kBufOptEndoffile = 23,
  kBufOptEndofline = 24,
  kBufOptEqualprg = 25,
  kBufOptErrorformat = 26,
  kBufOptExpandtab = 27,
  kBufOptFileencoding = 28,
  kBufOptFileformat = 29,
  kBufOptFiletype = 30,
  kBufOptFindfunc = 31,
  kBufOptFixendofline = 32,
  kBufOptFormatexpr = 33,
  kBufOptFormatlistpat = 34,
  kBufOptFormatoptions = 35,
  kBufOptFormatprg = 36,
  kBufOptGrepprg = 37,
  kBufOptIminsert = 38,
  kBufOptImsearch = 39,
  kBufOptInclude = 40,
  kBufOptIncludeexpr = 41,
  kBufOptIndentexpr = 42,
  kBufOptIndentkeys = 43,
  kBufOptInfercase = 44,
  kBufOptIskeyword = 45,
  kBufOptKeymap = 46,
  kBufOptKeywordprg = 47,
  kBufOptLisp = 48,
  kBufOptLispoptions = 49,
  kBufOptLispwords = 50,
  kBufOptMakeencoding = 51,
  kBufOptMakeprg = 52,
  kBufOptMatchpairs = 53,
  kBufOptModeline = 54,
  kBufOptModifiable = 55,
  kBufOptModified = 56,
  kBufOptNrformats = 57,
  kBufOptOmnifunc = 58,
  kBufOptPath = 59,
  kBufOptPreserveindent = 60,
  kBufOptQuoteescape = 61,
  kBufOptReadonly = 62,
  kBufOptScrollback = 63,
  kBufOptShiftwidth = 64,
  kBufOptSmartindent = 65,
  kBufOptSofttabstop = 66,
  kBufOptSpellcapcheck = 67,
  kBufOptSpellfile = 68,
  kBufOptSpelllang = 69,
  kBufOptSpelloptions = 70,
  kBufOptSuffixesadd = 71,
  kBufOptSwapfile = 72,
  kBufOptSynmaxcol = 73,
  kBufOptSyntax = 74,
  kBufOptTabstop = 75,
  kBufOptTagcase = 76,
  kBufOptTagfunc = 77,
  kBufOptTags = 78,
  kBufOptTextwidth = 79,
  kBufOptThesaurus = 80,
  kBufOptThesaurusfunc = 81,
  kBufOptUndofile = 82,
  kBufOptUndolevels = 83,
  kBufOptVarsofttabstop = 84,
  kBufOptVartabstop = 85,
  kBufOptWrapmargin = 86,
  // Buf option count
#define kBufOptCount 87
} BufOptIndex;

typedef enum {
  kWinOptInvalid = -1,
  kWinOptArabic = 0,
  kWinOptBreakindent = 1,
  kWinOptBreakindentopt = 2,
  kWinOptColorcolumn = 3,
  kWinOptConcealcursor = 4,
  kWinOptConceallevel = 5,
  kWinOptCursorbind = 6,
  kWinOptCursorcolumn = 7,
  kWinOptCursorline = 8,
  kWinOptCursorlineopt = 9,
  kWinOptDiff = 10,
  kWinOptEventignorewin = 11,
  kWinOptFillchars = 12,
  kWinOptFoldcolumn = 13,
  kWinOptFoldenable = 14,
  kWinOptFoldexpr = 15,
  kWinOptFoldignore = 16,
  kWinOptFoldlevel = 17,
  kWinOptFoldmarker = 18,
  kWinOptFoldmethod = 19,
  kWinOptFoldminlines = 20,
  kWinOptFoldnestmax = 21,
  kWinOptFoldtext = 22,
  kWinOptLinebreak = 23,
  kWinOptList = 24,
  kWinOptListchars = 25,
  kWinOptNumber = 26,
  kWinOptNumberwidth = 27,
  kWinOptPreviewwindow = 28,
  kWinOptRelativenumber = 29,
  kWinOptRightleft = 30,
  kWinOptRightleftcmd = 31,
  kWinOptScroll = 32,
  kWinOptScrollbind = 33,
  kWinOptScrolloff = 34,
  kWinOptShowbreak = 35,
  kWinOptSidescrolloff = 36,
  kWinOptSigncolumn = 37,
  kWinOptSmoothscroll = 38,
  kWinOptSpell = 39,
  kWinOptStatuscolumn = 40,
  kWinOptStatusline = 41,
  kWinOptVirtualedit = 42,
  kWinOptWinbar = 43,
  kWinOptWinblend = 44,
  kWinOptWinfixbuf = 45,
  kWinOptWinfixheight = 46,
  kWinOptWinfixwidth = 47,
  kWinOptWinhighlight = 48,
  kWinOptWrap = 49,
  // Win option count
#define kWinOptCount 50
} WinOptIndex;

EXTERN const OptIndex global_opt_idx[] INIT( = {
  [kGlobalOptAleph] = kOptAleph,
  [kGlobalOptAllowrevins] = kOptAllowrevins,
  [kGlobalOptAmbiwidth] = kOptAmbiwidth,
  [kGlobalOptArabicshape] = kOptArabicshape,
  [kGlobalOptAutochdir] = kOptAutochdir,
  [kGlobalOptAutoread] = kOptAutoread,
  [kGlobalOptAutowrite] = kOptAutowrite,
  [kGlobalOptAutowriteall] = kOptAutowriteall,
  [kGlobalOptBackground] = kOptBackground,
  [kGlobalOptBackspace] = kOptBackspace,
  [kGlobalOptBackup] = kOptBackup,
  [kGlobalOptBackupcopy] = kOptBackupcopy,
  [kGlobalOptBackupdir] = kOptBackupdir,
  [kGlobalOptBackupext] = kOptBackupext,
  [kGlobalOptBackupskip] = kOptBackupskip,
  [kGlobalOptBelloff] = kOptBelloff,
  [kGlobalOptBreakat] = kOptBreakat,
  [kGlobalOptBrowsedir] = kOptBrowsedir,
  [kGlobalOptCasemap] = kOptCasemap,
  [kGlobalOptCdhome] = kOptCdhome,
  [kGlobalOptCdpath] = kOptCdpath,
  [kGlobalOptCedit] = kOptCedit,
  [kGlobalOptCharconvert] = kOptCharconvert,
  [kGlobalOptClipboard] = kOptClipboard,
  [kGlobalOptCmdheight] = kOptCmdheight,
  [kGlobalOptCmdwinheight] = kOptCmdwinheight,
  [kGlobalOptColumns] = kOptColumns,
  [kGlobalOptCompatible] = kOptCompatible,
  [kGlobalOptCompletefuzzycollect] = kOptCompletefuzzycollect,
  [kGlobalOptCompleteitemalign] = kOptCompleteitemalign,
  [kGlobalOptCompleteopt] = kOptCompleteopt,
  [kGlobalOptConfirm] = kOptConfirm,
  [kGlobalOptCpoptions] = kOptCpoptions,
  [kGlobalOptDebug] = kOptDebug,
  [kGlobalOptDefine] = kOptDefine,
  [kGlobalOptDelcombine] = kOptDelcombine,
  [kGlobalOptDictionary] = kOptDictionary,
  [kGlobalOptDiffexpr] = kOptDiffexpr,
  [kGlobalOptDiffopt] = kOptDiffopt,
  [kGlobalOptDigraph] = kOptDigraph,
  [kGlobalOptDirectory] = kOptDirectory,
  [kGlobalOptDisplay] = kOptDisplay,
  [kGlobalOptEadirection] = kOptEadirection,
  [kGlobalOptEdcompatible] = kOptEdcompatible,
  [kGlobalOptEmoji] = kOptEmoji,
  [kGlobalOptEncoding] = kOptEncoding,
  [kGlobalOptEqualalways] = kOptEqualalways,
  [kGlobalOptEqualprg] = kOptEqualprg,
  [kGlobalOptErrorbells] = kOptErrorbells,
  [kGlobalOptErrorfile] = kOptErrorfile,
  [kGlobalOptErrorformat] = kOptErrorformat,
  [kGlobalOptEventignore] = kOptEventignore,
  [kGlobalOptExrc] = kOptExrc,
  [kGlobalOptFileencodings] = kOptFileencodings,
  [kGlobalOptFileformats] = kOptFileformats,
  [kGlobalOptFileignorecase] = kOptFileignorecase,
  [kGlobalOptFillchars] = kOptFillchars,
  [kGlobalOptFindfunc] = kOptFindfunc,
  [kGlobalOptFoldclose] = kOptFoldclose,
  [kGlobalOptFoldlevelstart] = kOptFoldlevelstart,
  [kGlobalOptFoldopen] = kOptFoldopen,
  [kGlobalOptFormatprg] = kOptFormatprg,
  [kGlobalOptFsync] = kOptFsync,
  [kGlobalOptGdefault] = kOptGdefault,
  [kGlobalOptGrepformat] = kOptGrepformat,
  [kGlobalOptGrepprg] = kOptGrepprg,
  [kGlobalOptGuicursor] = kOptGuicursor,
  [kGlobalOptGuifont] = kOptGuifont,
  [kGlobalOptGuifontwide] = kOptGuifontwide,
  [kGlobalOptGuioptions] = kOptGuioptions,
  [kGlobalOptGuitablabel] = kOptGuitablabel,
  [kGlobalOptGuitabtooltip] = kOptGuitabtooltip,
  [kGlobalOptHelpfile] = kOptHelpfile,
  [kGlobalOptHelpheight] = kOptHelpheight,
  [kGlobalOptHelplang] = kOptHelplang,
  [kGlobalOptHidden] = kOptHidden,
  [kGlobalOptHighlight] = kOptHighlight,
  [kGlobalOptHistory] = kOptHistory,
  [kGlobalOptHkmap] = kOptHkmap,
  [kGlobalOptHkmapp] = kOptHkmapp,
  [kGlobalOptHlsearch] = kOptHlsearch,
  [kGlobalOptIcon] = kOptIcon,
  [kGlobalOptIconstring] = kOptIconstring,
  [kGlobalOptIgnorecase] = kOptIgnorecase,
  [kGlobalOptImcmdline] = kOptImcmdline,
  [kGlobalOptImdisable] = kOptImdisable,
  [kGlobalOptInccommand] = kOptInccommand,
  [kGlobalOptInclude] = kOptInclude,
  [kGlobalOptIncsearch] = kOptIncsearch,
  [kGlobalOptInsertmode] = kOptInsertmode,
  [kGlobalOptIsfname] = kOptIsfname,
  [kGlobalOptIsident] = kOptIsident,
  [kGlobalOptIsprint] = kOptIsprint,
  [kGlobalOptJoinspaces] = kOptJoinspaces,
  [kGlobalOptJumpoptions] = kOptJumpoptions,
  [kGlobalOptKeymodel] = kOptKeymodel,
  [kGlobalOptKeywordprg] = kOptKeywordprg,
  [kGlobalOptLangmap] = kOptLangmap,
  [kGlobalOptLangmenu] = kOptLangmenu,
  [kGlobalOptLangnoremap] = kOptLangnoremap,
  [kGlobalOptLangremap] = kOptLangremap,
  [kGlobalOptLaststatus] = kOptLaststatus,
  [kGlobalOptLazyredraw] = kOptLazyredraw,
  [kGlobalOptLines] = kOptLines,
  [kGlobalOptLinespace] = kOptLinespace,
  [kGlobalOptLispwords] = kOptLispwords,
  [kGlobalOptListchars] = kOptListchars,
  [kGlobalOptLoadplugins] = kOptLoadplugins,
  [kGlobalOptMagic] = kOptMagic,
  [kGlobalOptMakeef] = kOptMakeef,
  [kGlobalOptMakeencoding] = kOptMakeencoding,
  [kGlobalOptMakeprg] = kOptMakeprg,
  [kGlobalOptMatchtime] = kOptMatchtime,
  [kGlobalOptMaxcombine] = kOptMaxcombine,
  [kGlobalOptMaxfuncdepth] = kOptMaxfuncdepth,
  [kGlobalOptMaxmapdepth] = kOptMaxmapdepth,
  [kGlobalOptMaxmempattern] = kOptMaxmempattern,
  [kGlobalOptMenuitems] = kOptMenuitems,
  [kGlobalOptMessagesopt] = kOptMessagesopt,
  [kGlobalOptMkspellmem] = kOptMkspellmem,
  [kGlobalOptModelineexpr] = kOptModelineexpr,
  [kGlobalOptModelines] = kOptModelines,
  [kGlobalOptMore] = kOptMore,
  [kGlobalOptMouse] = kOptMouse,
  [kGlobalOptMousefocus] = kOptMousefocus,
  [kGlobalOptMousehide] = kOptMousehide,
  [kGlobalOptMousemodel] = kOptMousemodel,
  [kGlobalOptMousemoveevent] = kOptMousemoveevent,
  [kGlobalOptMousescroll] = kOptMousescroll,
  [kGlobalOptMouseshape] = kOptMouseshape,
  [kGlobalOptMousetime] = kOptMousetime,
  [kGlobalOptOpendevice] = kOptOpendevice,
  [kGlobalOptOperatorfunc] = kOptOperatorfunc,
  [kGlobalOptPackpath] = kOptPackpath,
  [kGlobalOptParagraphs] = kOptParagraphs,
  [kGlobalOptPaste] = kOptPaste,
  [kGlobalOptPastetoggle] = kOptPastetoggle,
  [kGlobalOptPatchexpr] = kOptPatchexpr,
  [kGlobalOptPatchmode] = kOptPatchmode,
  [kGlobalOptPath] = kOptPath,
  [kGlobalOptPreviewheight] = kOptPreviewheight,
  [kGlobalOptPrompt] = kOptPrompt,
  [kGlobalOptPumblend] = kOptPumblend,
  [kGlobalOptPumheight] = kOptPumheight,
  [kGlobalOptPummaxwidth] = kOptPummaxwidth,
  [kGlobalOptPumwidth] = kOptPumwidth,
  [kGlobalOptPyxversion] = kOptPyxversion,
  [kGlobalOptQuickfixtextfunc] = kOptQuickfixtextfunc,
  [kGlobalOptRedrawdebug] = kOptRedrawdebug,
  [kGlobalOptRedrawtime] = kOptRedrawtime,
  [kGlobalOptRegexpengine] = kOptRegexpengine,
  [kGlobalOptRemap] = kOptRemap,
  [kGlobalOptReport] = kOptReport,
  [kGlobalOptRevins] = kOptRevins,
  [kGlobalOptRuler] = kOptRuler,
  [kGlobalOptRulerformat] = kOptRulerformat,
  [kGlobalOptRuntimepath] = kOptRuntimepath,
  [kGlobalOptScrolljump] = kOptScrolljump,
  [kGlobalOptScrolloff] = kOptScrolloff,
  [kGlobalOptScrollopt] = kOptScrollopt,
  [kGlobalOptSections] = kOptSections,
  [kGlobalOptSecure] = kOptSecure,
  [kGlobalOptSelection] = kOptSelection,
  [kGlobalOptSelectmode] = kOptSelectmode,
  [kGlobalOptSessionoptions] = kOptSessionoptions,
  [kGlobalOptShada] = kOptShada,
  [kGlobalOptShadafile] = kOptShadafile,
  [kGlobalOptShell] = kOptShell,
  [kGlobalOptShellcmdflag] = kOptShellcmdflag,
  [kGlobalOptShellpipe] = kOptShellpipe,
  [kGlobalOptShellquote] = kOptShellquote,
  [kGlobalOptShellredir] = kOptShellredir,
  [kGlobalOptShellslash] = kOptShellslash,
  [kGlobalOptShelltemp] = kOptShelltemp,
  [kGlobalOptShellxescape] = kOptShellxescape,
  [kGlobalOptShellxquote] = kOptShellxquote,
  [kGlobalOptShiftround] = kOptShiftround,
  [kGlobalOptShortmess] = kOptShortmess,
  [kGlobalOptShowbreak] = kOptShowbreak,
  [kGlobalOptShowcmd] = kOptShowcmd,
  [kGlobalOptShowcmdloc] = kOptShowcmdloc,
  [kGlobalOptShowfulltag] = kOptShowfulltag,
  [kGlobalOptShowmatch] = kOptShowmatch,
  [kGlobalOptShowmode] = kOptShowmode,
  [kGlobalOptShowtabline] = kOptShowtabline,
  [kGlobalOptSidescroll] = kOptSidescroll,
  [kGlobalOptSidescrolloff] = kOptSidescrolloff,
  [kGlobalOptSmartcase] = kOptSmartcase,
  [kGlobalOptSmarttab] = kOptSmarttab,
  [kGlobalOptSpellsuggest] = kOptSpellsuggest,
  [kGlobalOptSplitbelow] = kOptSplitbelow,
  [kGlobalOptSplitkeep] = kOptSplitkeep,
  [kGlobalOptSplitright] = kOptSplitright,
  [kGlobalOptStartofline] = kOptStartofline,
  [kGlobalOptStatusline] = kOptStatusline,
  [kGlobalOptSuffixes] = kOptSuffixes,
  [kGlobalOptSwitchbuf] = kOptSwitchbuf,
  [kGlobalOptTabclose] = kOptTabclose,
  [kGlobalOptTabline] = kOptTabline,
  [kGlobalOptTabpagemax] = kOptTabpagemax,
  [kGlobalOptTagbsearch] = kOptTagbsearch,
  [kGlobalOptTagcase] = kOptTagcase,
  [kGlobalOptTaglength] = kOptTaglength,
  [kGlobalOptTagrelative] = kOptTagrelative,
  [kGlobalOptTags] = kOptTags,
  [kGlobalOptTagstack] = kOptTagstack,
  [kGlobalOptTermbidi] = kOptTermbidi,
  [kGlobalOptTermencoding] = kOptTermencoding,
  [kGlobalOptTermguicolors] = kOptTermguicolors,
  [kGlobalOptTermpastefilter] = kOptTermpastefilter,
  [kGlobalOptTermsync] = kOptTermsync,
  [kGlobalOptTerse] = kOptTerse,
  [kGlobalOptThesaurus] = kOptThesaurus,
  [kGlobalOptThesaurusfunc] = kOptThesaurusfunc,
  [kGlobalOptTildeop] = kOptTildeop,
  [kGlobalOptTimeout] = kOptTimeout,
  [kGlobalOptTimeoutlen] = kOptTimeoutlen,
  [kGlobalOptTitle] = kOptTitle,
  [kGlobalOptTitlelen] = kOptTitlelen,
  [kGlobalOptTitleold] = kOptTitleold,
  [kGlobalOptTitlestring] = kOptTitlestring,
  [kGlobalOptTtimeout] = kOptTtimeout,
  [kGlobalOptTtimeoutlen] = kOptTtimeoutlen,
  [kGlobalOptTtyfast] = kOptTtyfast,
  [kGlobalOptUndodir] = kOptUndodir,
  [kGlobalOptUndolevels] = kOptUndolevels,
  [kGlobalOptUndoreload] = kOptUndoreload,
  [kGlobalOptUpdatecount] = kOptUpdatecount,
  [kGlobalOptUpdatetime] = kOptUpdatetime,
  [kGlobalOptVerbose] = kOptVerbose,
  [kGlobalOptVerbosefile] = kOptVerbosefile,
  [kGlobalOptViewdir] = kOptViewdir,
  [kGlobalOptViewoptions] = kOptViewoptions,
  [kGlobalOptVirtualedit] = kOptVirtualedit,
  [kGlobalOptVisualbell] = kOptVisualbell,
  [kGlobalOptWarn] = kOptWarn,
  [kGlobalOptWhichwrap] = kOptWhichwrap,
  [kGlobalOptWildchar] = kOptWildchar,
  [kGlobalOptWildcharm] = kOptWildcharm,
  [kGlobalOptWildignore] = kOptWildignore,
  [kGlobalOptWildignorecase] = kOptWildignorecase,
  [kGlobalOptWildmenu] = kOptWildmenu,
  [kGlobalOptWildmode] = kOptWildmode,
  [kGlobalOptWildoptions] = kOptWildoptions,
  [kGlobalOptWinaltkeys] = kOptWinaltkeys,
  [kGlobalOptWinbar] = kOptWinbar,
  [kGlobalOptWinborder] = kOptWinborder,
  [kGlobalOptWindow] = kOptWindow,
  [kGlobalOptWinheight] = kOptWinheight,
  [kGlobalOptWinminheight] = kOptWinminheight,
  [kGlobalOptWinminwidth] = kOptWinminwidth,
  [kGlobalOptWinwidth] = kOptWinwidth,
  [kGlobalOptWrapscan] = kOptWrapscan,
  [kGlobalOptWrite] = kOptWrite,
  [kGlobalOptWriteany] = kOptWriteany,
  [kGlobalOptWritebackup] = kOptWritebackup,
  [kGlobalOptWritedelay] = kOptWritedelay,
});

EXTERN const OptIndex buf_opt_idx[] INIT( = {
  [kBufOptAutoindent] = kOptAutoindent,
  [kBufOptAutoread] = kOptAutoread,
  [kBufOptBackupcopy] = kOptBackupcopy,
  [kBufOptBinary] = kOptBinary,
  [kBufOptBomb] = kOptBomb,
  [kBufOptBufhidden] = kOptBufhidden,
  [kBufOptBuflisted] = kOptBuflisted,
  [kBufOptBuftype] = kOptBuftype,
  [kBufOptChannel] = kOptChannel,
  [kBufOptCindent] = kOptCindent,
  [kBufOptCinkeys] = kOptCinkeys,
  [kBufOptCinoptions] = kOptCinoptions,
  [kBufOptCinscopedecls] = kOptCinscopedecls,
  [kBufOptCinwords] = kOptCinwords,
  [kBufOptComments] = kOptComments,
  [kBufOptCommentstring] = kOptCommentstring,
  [kBufOptComplete] = kOptComplete,
  [kBufOptCompletefunc] = kOptCompletefunc,
  [kBufOptCompleteopt] = kOptCompleteopt,
  [kBufOptCompleteslash] = kOptCompleteslash,
  [kBufOptCopyindent] = kOptCopyindent,
  [kBufOptDefine] = kOptDefine,
  [kBufOptDictionary] = kOptDictionary,
  [kBufOptEndoffile] = kOptEndoffile,
  [kBufOptEndofline] = kOptEndofline,
  [kBufOptEqualprg] = kOptEqualprg,
  [kBufOptErrorformat] = kOptErrorformat,
  [kBufOptExpandtab] = kOptExpandtab,
  [kBufOptFileencoding] = kOptFileencoding,
  [kBufOptFileformat] = kOptFileformat,
  [kBufOptFiletype] = kOptFiletype,
  [kBufOptFindfunc] = kOptFindfunc,
  [kBufOptFixendofline] = kOptFixendofline,
  [kBufOptFormatexpr] = kOptFormatexpr,
  [kBufOptFormatlistpat] = kOptFormatlistpat,
  [kBufOptFormatoptions] = kOptFormatoptions,
  [kBufOptFormatprg] = kOptFormatprg,
  [kBufOptGrepprg] = kOptGrepprg,
  [kBufOptIminsert] = kOptIminsert,
  [kBufOptImsearch] = kOptImsearch,
  [kBufOptInclude] = kOptInclude,
  [kBufOptIncludeexpr] = kOptIncludeexpr,
  [kBufOptIndentexpr] = kOptIndentexpr,
  [kBufOptIndentkeys] = kOptIndentkeys,
  [kBufOptInfercase] = kOptInfercase,
  [kBufOptIskeyword] = kOptIskeyword,
  [kBufOptKeymap] = kOptKeymap,
  [kBufOptKeywordprg] = kOptKeywordprg,
  [kBufOptLisp] = kOptLisp,
  [kBufOptLispoptions] = kOptLispoptions,
  [kBufOptLispwords] = kOptLispwords,
  [kBufOptMakeencoding] = kOptMakeencoding,
  [kBufOptMakeprg] = kOptMakeprg,
  [kBufOptMatchpairs] = kOptMatchpairs,
  [kBufOptModeline] = kOptModeline,
  [kBufOptModifiable] = kOptModifiable,
  [kBufOptModified] = kOptModified,
  [kBufOptNrformats] = kOptNrformats,
  [kBufOptOmnifunc] = kOptOmnifunc,
  [kBufOptPath] = kOptPath,
  [kBufOptPreserveindent] = kOptPreserveindent,
  [kBufOptQuoteescape] = kOptQuoteescape,
  [kBufOptReadonly] = kOptReadonly,
  [kBufOptScrollback] = kOptScrollback,
  [kBufOptShiftwidth] = kOptShiftwidth,
  [kBufOptSmartindent] = kOptSmartindent,
  [kBufOptSofttabstop] = kOptSofttabstop,
  [kBufOptSpellcapcheck] = kOptSpellcapcheck,
  [kBufOptSpellfile] = kOptSpellfile,
  [kBufOptSpelllang] = kOptSpelllang,
  [kBufOptSpelloptions] = kOptSpelloptions,
  [kBufOptSuffixesadd] = kOptSuffixesadd,
  [kBufOptSwapfile] = kOptSwapfile,
  [kBufOptSynmaxcol] = kOptSynmaxcol,
  [kBufOptSyntax] = kOptSyntax,
  [kBufOptTabstop] = kOptTabstop,
  [kBufOptTagcase] = kOptTagcase,
  [kBufOptTagfunc] = kOptTagfunc,
  [kBufOptTags] = kOptTags,
  [kBufOptTextwidth] = kOptTextwidth,
  [kBufOptThesaurus] = kOptThesaurus,
  [kBufOptThesaurusfunc] = kOptThesaurusfunc,
  [kBufOptUndofile] = kOptUndofile,
  [kBufOptUndolevels] = kOptUndolevels,
  [kBufOptVarsofttabstop] = kOptVarsofttabstop,
  [kBufOptVartabstop] = kOptVartabstop,
  [kBufOptWrapmargin] = kOptWrapmargin,
});

EXTERN const OptIndex win_opt_idx[] INIT( = {
  [kWinOptArabic] = kOptArabic,
  [kWinOptBreakindent] = kOptBreakindent,
  [kWinOptBreakindentopt] = kOptBreakindentopt,
  [kWinOptColorcolumn] = kOptColorcolumn,
  [kWinOptConcealcursor] = kOptConcealcursor,
  [kWinOptConceallevel] = kOptConceallevel,
  [kWinOptCursorbind] = kOptCursorbind,
  [kWinOptCursorcolumn] = kOptCursorcolumn,
  [kWinOptCursorline] = kOptCursorline,
  [kWinOptCursorlineopt] = kOptCursorlineopt,
  [kWinOptDiff] = kOptDiff,
  [kWinOptEventignorewin] = kOptEventignorewin,
  [kWinOptFillchars] = kOptFillchars,
  [kWinOptFoldcolumn] = kOptFoldcolumn,
  [kWinOptFoldenable] = kOptFoldenable,
  [kWinOptFoldexpr] = kOptFoldexpr,
  [kWinOptFoldignore] = kOptFoldignore,
  [kWinOptFoldlevel] = kOptFoldlevel,
  [kWinOptFoldmarker] = kOptFoldmarker,
  [kWinOptFoldmethod] = kOptFoldmethod,
  [kWinOptFoldminlines] = kOptFoldminlines,
  [kWinOptFoldnestmax] = kOptFoldnestmax,
  [kWinOptFoldtext] = kOptFoldtext,
  [kWinOptLinebreak] = kOptLinebreak,
  [kWinOptList] = kOptList,
  [kWinOptListchars] = kOptListchars,
  [kWinOptNumber] = kOptNumber,
  [kWinOptNumberwidth] = kOptNumberwidth,
  [kWinOptPreviewwindow] = kOptPreviewwindow,
  [kWinOptRelativenumber] = kOptRelativenumber,
  [kWinOptRightleft] = kOptRightleft,
  [kWinOptRightleftcmd] = kOptRightleftcmd,
  [kWinOptScroll] = kOptScroll,
  [kWinOptScrollbind] = kOptScrollbind,
  [kWinOptScrolloff] = kOptScrolloff,
  [kWinOptShowbreak] = kOptShowbreak,
  [kWinOptSidescrolloff] = kOptSidescrolloff,
  [kWinOptSigncolumn] = kOptSigncolumn,
  [kWinOptSmoothscroll] = kOptSmoothscroll,
  [kWinOptSpell] = kOptSpell,
  [kWinOptStatuscolumn] = kOptStatuscolumn,
  [kWinOptStatusline] = kOptStatusline,
  [kWinOptVirtualedit] = kOptVirtualedit,
  [kWinOptWinbar] = kOptWinbar,
  [kWinOptWinblend] = kOptWinblend,
  [kWinOptWinfixbuf] = kOptWinfixbuf,
  [kWinOptWinfixheight] = kOptWinfixheight,
  [kWinOptWinfixwidth] = kOptWinfixwidth,
  [kWinOptWinhighlight] = kOptWinhighlight,
  [kWinOptWrap] = kOptWrap,
});
