static const struct { const char *name; OptIndex opt_idx; } option_hash_elems[] = {
  { .name = "ma", .opt_idx = kOptModifiable },
  { .name = "pa", .opt_idx = kOptPath },
  { .name = "ea", .opt_idx = kOptEqualalways },
  { .name = "wa", .opt_idx = kOptWriteany },
  { .name = "sb", .opt_idx = kOptSplitbelow },
  { .name = "eb", .opt_idx = kOptErrorbells },
  { .name = "vb", .opt_idx = kOptVisualbell },
  { .name = "cb", .opt_idx = kOptClipboard },
  { .name = "pb", .opt_idx = kOptPumblend },
  { .name = "wb", .opt_idx = kOptWritebackup },
  { .name = "sc", .opt_idx = kOptShowcmd },
  { .name = "ic", .opt_idx = kOptIgnorecase },
  { .name = "uc", .opt_idx = kOptUpdatecount },
  { .name = "tc", .opt_idx = kOptTagcase },
  { .name = "cc", .opt_idx = kOptColorcolumn },
  { .name = "wc", .opt_idx = kOptWildchar },
  { .name = "wd", .opt_idx = kOptWritedelay },
  { .name = "sd", .opt_idx = kOptShada },
  { .name = "gd", .opt_idx = kOptGdefault },
  { .name = "ed", .opt_idx = kOptEdcompatible },
  { .name = "cd", .opt_idx = kOptCdpath },
  { .name = "re", .opt_idx = kOptRegexpengine },
  { .name = "ve", .opt_idx = kOptVirtualedit },
  { .name = "qe", .opt_idx = kOptQuoteescape },
  { .name = "tf", .opt_idx = kOptTtyfast },
  { .name = "ef", .opt_idx = kOptErrorfile },
  { .name = "ff", .opt_idx = kOptFileformat },
  { .name = "nf", .opt_idx = kOptNrformats },
  { .name = "hf", .opt_idx = kOptHelpfile },
  { .name = "cf", .opt_idx = kOptConfirm },
  { .name = "bg", .opt_idx = kOptBackground },
  { .name = "dg", .opt_idx = kOptDigraph },
  { .name = "sh", .opt_idx = kOptShell },
  { .name = "mh", .opt_idx = kOptMousehide },
  { .name = "bh", .opt_idx = kOptBufhidden },
  { .name = "wh", .opt_idx = kOptWinheight },
  { .name = "ch", .opt_idx = kOptCmdheight },
  { .name = "ph", .opt_idx = kOptPumheight },
  { .name = "hh", .opt_idx = kOptHelpheight },
  { .name = "hi", .opt_idx = kOptHistory },
  { .name = "ci", .opt_idx = kOptCopyindent },
  { .name = "si", .opt_idx = kOptSmartindent },
  { .name = "pi", .opt_idx = kOptPreserveindent },
  { .name = "ei", .opt_idx = kOptEventignore },
  { .name = "ai", .opt_idx = kOptAutoindent },
  { .name = "ri", .opt_idx = kOptRevins },
  { .name = "vi", .opt_idx = kOptShada },
  { .name = "wi", .opt_idx = kOptWindow },
  { .name = "sj", .opt_idx = kOptScrolljump },
  { .name = "hk", .opt_idx = kOptHkmap },
  { .name = "bk", .opt_idx = kOptBackup },
  { .name = "hl", .opt_idx = kOptHighlight },
  { .name = "ul", .opt_idx = kOptUndolevels },
  { .name = "al", .opt_idx = kOptAleph },
  { .name = "rl", .opt_idx = kOptRightleft },
  { .name = "ml", .opt_idx = kOptModeline },
  { .name = "tl", .opt_idx = kOptTaglength },
  { .name = "bl", .opt_idx = kOptBuflisted },
  { .name = "im", .opt_idx = kOptInsertmode },
  { .name = "km", .opt_idx = kOptKeymodel },
  { .name = "pm", .opt_idx = kOptPatchmode },
  { .name = "tm", .opt_idx = kOptTimeoutlen },
  { .name = "sm", .opt_idx = kOptShowmatch },
  { .name = "lm", .opt_idx = kOptLangmenu },
  { .name = "wm", .opt_idx = kOptWrapmargin },
  { .name = "go", .opt_idx = kOptGuioptions },
  { .name = "so", .opt_idx = kOptScrolloff },
  { .name = "fo", .opt_idx = kOptFormatoptions },
  { .name = "co", .opt_idx = kOptColumns },
  { .name = "to", .opt_idx = kOptTimeout },
  { .name = "ro", .opt_idx = kOptReadonly },
  { .name = "bo", .opt_idx = kOptBelloff },
  { .name = "mp", .opt_idx = kOptMakeprg },
  { .name = "sp", .opt_idx = kOptShellpipe },
  { .name = "cp", .opt_idx = kOptCompatible },
  { .name = "fp", .opt_idx = kOptFormatprg },
  { .name = "kp", .opt_idx = kOptKeywordprg },
  { .name = "gp", .opt_idx = kOptGrepprg },
  { .name = "pp", .opt_idx = kOptPackpath },
  { .name = "ep", .opt_idx = kOptEqualprg },
  { .name = "sr", .opt_idx = kOptShiftround },
  { .name = "ur", .opt_idx = kOptUndoreload },
  { .name = "ar", .opt_idx = kOptAutoread },
  { .name = "tr", .opt_idx = kOptTagrelative },
  { .name = "bs", .opt_idx = kOptBackspace },
  { .name = "ts", .opt_idx = kOptTabstop },
  { .name = "ss", .opt_idx = kOptSidescroll },
  { .name = "is", .opt_idx = kOptIncsearch },
  { .name = "js", .opt_idx = kOptJoinspaces },
  { .name = "ls", .opt_idx = kOptLaststatus },
  { .name = "ws", .opt_idx = kOptWrapscan },
  { .name = "fs", .opt_idx = kOptFsync },
  { .name = "ut", .opt_idx = kOptUpdatetime },
  { .name = "et", .opt_idx = kOptExpandtab },
  { .name = "ft", .opt_idx = kOptFiletype },
  { .name = "bt", .opt_idx = kOptBuftype },
  { .name = "pt", .opt_idx = kOptPastetoggle },
  { .name = "ru", .opt_idx = kOptRuler },
  { .name = "nu", .opt_idx = kOptNumber },
  { .name = "su", .opt_idx = kOptSuffixes },
  { .name = "lw", .opt_idx = kOptLispwords },
  { .name = "sw", .opt_idx = kOptShiftwidth },
  { .name = "aw", .opt_idx = kOptAutowrite },
  { .name = "ww", .opt_idx = kOptWhichwrap },
  { .name = "pw", .opt_idx = kOptPumwidth },
  { .name = "tw", .opt_idx = kOptTextwidth },
  { .name = "ex", .opt_idx = kOptExrc },
  { .name = "dy", .opt_idx = kOptDisplay },
  { .name = "lz", .opt_idx = kOptLazyredraw },
  { .name = "cia", .opt_idx = kOptCompleteitemalign },
  { .name = "awa", .opt_idx = kOptAutowriteall },
  { .name = "sua", .opt_idx = kOptSuffixesadd },
  { .name = "sta", .opt_idx = kOptSmarttab },
  { .name = "crb", .opt_idx = kOptCursorbind },
  { .name = "scb", .opt_idx = kOptScrollbind },
  { .name = "wfb", .opt_idx = kOptWinfixbuf },
  { .name = "rdb", .opt_idx = kOptRedrawdebug },
  { .name = "swb", .opt_idx = kOptSwitchbuf },
  { .name = "fic", .opt_idx = kOptFileignorecase },
  { .name = "bkc", .opt_idx = kOptBackupcopy },
  { .name = "fdc", .opt_idx = kOptFoldcolumn },
  { .name = "wic", .opt_idx = kOptWildignorecase },
  { .name = "tgc", .opt_idx = kOptTermguicolors },
  { .name = "smc", .opt_idx = kOptSynmaxcol },
  { .name = "stc", .opt_idx = kOptStatuscolumn },
  { .name = "spc", .opt_idx = kOptSpellcapcheck },
  { .name = "enc", .opt_idx = kOptEncoding },
  { .name = "cfc", .opt_idx = kOptCompletefuzzycollect },
  { .name = "cuc", .opt_idx = kOptCursorcolumn },
  { .name = "imc", .opt_idx = kOptImcmdline },
  { .name = "inc", .opt_idx = kOptInclude },
  { .name = "rlc", .opt_idx = kOptRightleftcmd },
  { .name = "hid", .opt_idx = kOptHidden },
  { .name = "smd", .opt_idx = kOptShowmode },
  { .name = "imd", .opt_idx = kOptImdisable },
  { .name = "acd", .opt_idx = kOptAutochdir },
  { .name = "mmd", .opt_idx = kOptMaxmapdepth },
  { .name = "mod", .opt_idx = kOptModified },
  { .name = "mfd", .opt_idx = kOptMaxfuncdepth },
  { .name = "ead", .opt_idx = kOptEadirection },
  { .name = "sxe", .opt_idx = kOptShellxescape },
  { .name = "mle", .opt_idx = kOptModelineexpr },
  { .name = "fde", .opt_idx = kOptFoldexpr },
  { .name = "mef", .opt_idx = kOptMakeef },
  { .name = "sdf", .opt_idx = kOptShadafile },
  { .name = "vif", .opt_idx = kOptShadafile },
  { .name = "inf", .opt_idx = kOptInfercase },
  { .name = "def", .opt_idx = kOptDefine },
  { .name = "spf", .opt_idx = kOptSpellfile },
  { .name = "udf", .opt_idx = kOptUndofile },
  { .name = "ruf", .opt_idx = kOptRulerformat },
  { .name = "tpf", .opt_idx = kOptTermpastefilter },
  { .name = "swf", .opt_idx = kOptSwapfile },
  { .name = "eof", .opt_idx = kOptEndoffile },
  { .name = "isf", .opt_idx = kOptIsfname },
  { .name = "wig", .opt_idx = kOptWildignore },
  { .name = "hlg", .opt_idx = kOptHelplang },
  { .name = "tag", .opt_idx = kOptTags },
  { .name = "wmh", .opt_idx = kOptWinminheight },
  { .name = "cdh", .opt_idx = kOptCdhome },
  { .name = "wfh", .opt_idx = kOptWinfixheight },
  { .name = "cwh", .opt_idx = kOptCmdwinheight },
  { .name = "pvh", .opt_idx = kOptPreviewheight },
  { .name = "imi", .opt_idx = kOptIminsert },
  { .name = "isi", .opt_idx = kOptIsident },
  { .name = "ari", .opt_idx = kOptAllowrevins },
  { .name = "fdi", .opt_idx = kOptFoldignore },
  { .name = "bri", .opt_idx = kOptBreakindent },
  { .name = "isk", .opt_idx = kOptIskeyword },
  { .name = "spk", .opt_idx = kOptSplitkeep },
  { .name = "bsk", .opt_idx = kOptBackupskip },
  { .name = "wak", .opt_idx = kOptWinaltkeys },
  { .name = "brk", .opt_idx = kOptBreakat },
  { .name = "lpl", .opt_idx = kOptLoadplugins },
  { .name = "fml", .opt_idx = kOptFoldminlines },
  { .name = "ssl", .opt_idx = kOptShellslash },
  { .name = "csl", .opt_idx = kOptCompleteslash },
  { .name = "scl", .opt_idx = kOptSigncolumn },
  { .name = "cul", .opt_idx = kOptCursorline },
  { .name = "spl", .opt_idx = kOptSpelllang },
  { .name = "sol", .opt_idx = kOptStartofline },
  { .name = "eol", .opt_idx = kOptEndofline },
  { .name = "fcl", .opt_idx = kOptFoldclose },
  { .name = "sel", .opt_idx = kOptSelection },
  { .name = "tcl", .opt_idx = kOptTabclose },
  { .name = "tal", .opt_idx = kOptTabline },
  { .name = "stl", .opt_idx = kOptStatusline },
  { .name = "gtl", .opt_idx = kOptGuitablabel },
  { .name = "fdl", .opt_idx = kOptFoldlevel },
  { .name = "shm", .opt_idx = kOptShortmess },
  { .name = "ttm", .opt_idx = kOptTtimeoutlen },
  { .name = "efm", .opt_idx = kOptErrorformat },
  { .name = "wim", .opt_idx = kOptWildmode },
  { .name = "msm", .opt_idx = kOptMkspellmem },
  { .name = "slm", .opt_idx = kOptSelectmode },
  { .name = "gfm", .opt_idx = kOptGrepformat },
  { .name = "com", .opt_idx = kOptComments },
  { .name = "wcm", .opt_idx = kOptWildcharm },
  { .name = "tpm", .opt_idx = kOptTabpagemax },
  { .name = "fdm", .opt_idx = kOptFoldmethod },
  { .name = "icm", .opt_idx = kOptInccommand },
  { .name = "lrm", .opt_idx = kOptLangremap },
  { .name = "fdn", .opt_idx = kOptFoldnestmax },
  { .name = "fen", .opt_idx = kOptFoldenable },
  { .name = "bin", .opt_idx = kOptBinary },
  { .name = "syn", .opt_idx = kOptSyntax },
  { .name = "gfn", .opt_idx = kOptGuifont },
  { .name = "cin", .opt_idx = kOptCindent },
  { .name = "mco", .opt_idx = kOptMaxcombine },
  { .name = "fdo", .opt_idx = kOptFoldopen },
  { .name = "cpo", .opt_idx = kOptCpoptions },
  { .name = "sbo", .opt_idx = kOptScrollopt },
  { .name = "spo", .opt_idx = kOptSpelloptions },
  { .name = "emo", .opt_idx = kOptEmoji },
  { .name = "flp", .opt_idx = kOptFormatlistpat },
  { .name = "lsp", .opt_idx = kOptLinespace },
  { .name = "hkp", .opt_idx = kOptHkmapp },
  { .name = "isp", .opt_idx = kOptIsprint },
  { .name = "jop", .opt_idx = kOptJumpoptions },
  { .name = "kmp", .opt_idx = kOptKeymap },
  { .name = "top", .opt_idx = kOptTildeop },
  { .name = "mmp", .opt_idx = kOptMaxmempattern },
  { .name = "rtp", .opt_idx = kOptRuntimepath },
  { .name = "wop", .opt_idx = kOptWildoptions },
  { .name = "vop", .opt_idx = kOptViewoptions },
  { .name = "dip", .opt_idx = kOptDiffopt },
  { .name = "cmp", .opt_idx = kOptCasemap },
  { .name = "lop", .opt_idx = kOptLispoptions },
  { .name = "shq", .opt_idx = kOptShellquote },
  { .name = "sxq", .opt_idx = kOptShellxquote },
  { .name = "srr", .opt_idx = kOptShellredir },
  { .name = "spr", .opt_idx = kOptSplitright },
  { .name = "fmr", .opt_idx = kOptFoldmarker },
  { .name = "wbr", .opt_idx = kOptWinbar },
  { .name = "sbr", .opt_idx = kOptShowbreak },
  { .name = "gcr", .opt_idx = kOptGuicursor },
  { .name = "tsr", .opt_idx = kOptThesaurus },
  { .name = "dir", .opt_idx = kOptDirectory },
  { .name = "lnr", .opt_idx = kOptLangnoremap },
  { .name = "lbr", .opt_idx = kOptLinebreak },
  { .name = "scr", .opt_idx = kOptScroll },
  { .name = "lcs", .opt_idx = kOptListchars },
  { .name = "mps", .opt_idx = kOptMatchpairs },
  { .name = "hls", .opt_idx = kOptHlsearch },
  { .name = "sms", .opt_idx = kOptSmoothscroll },
  { .name = "sts", .opt_idx = kOptSofttabstop },
  { .name = "sps", .opt_idx = kOptSpellsuggest },
  { .name = "ffs", .opt_idx = kOptFileformats },
  { .name = "fcs", .opt_idx = kOptFillchars },
  { .name = "mis", .opt_idx = kOptMenuitems },
  { .name = "mls", .opt_idx = kOptModelines },
  { .name = "cms", .opt_idx = kOptCommentstring },
  { .name = "vbs", .opt_idx = kOptVerbose },
  { .name = "vts", .opt_idx = kOptVartabstop },
  { .name = "tbs", .opt_idx = kOptTagbsearch },
  { .name = "scs", .opt_idx = kOptSmartcase },
  { .name = "ims", .opt_idx = kOptImsearch },
  { .name = "mat", .opt_idx = kOptMatchtime },
  { .name = "fdt", .opt_idx = kOptFoldtext },
  { .name = "sft", .opt_idx = kOptShowfulltag },
  { .name = "rdt", .opt_idx = kOptRedrawtime },
  { .name = "cot", .opt_idx = kOptCompleteopt },
  { .name = "gtt", .opt_idx = kOptGuitabtooltip },
  { .name = "cpt", .opt_idx = kOptComplete },
  { .name = "cfu", .opt_idx = kOptCompletefunc },
  { .name = "ffu", .opt_idx = kOptFindfunc },
  { .name = "rnu", .opt_idx = kOptRelativenumber },
  { .name = "tfu", .opt_idx = kOptTagfunc },
  { .name = "ofu", .opt_idx = kOptOmnifunc },
  { .name = "ccv", .opt_idx = kOptCharconvert },
  { .name = "eiw", .opt_idx = kOptEventignorewin },
  { .name = "nuw", .opt_idx = kOptNumberwidth },
  { .name = "wfw", .opt_idx = kOptWinfixwidth },
  { .name = "gfw", .opt_idx = kOptGuifontwide },
  { .name = "pvw", .opt_idx = kOptPreviewwindow },
  { .name = "pmw", .opt_idx = kOptPummaxwidth },
  { .name = "wmw", .opt_idx = kOptWinminwidth },
  { .name = "wiw", .opt_idx = kOptWinwidth },
  { .name = "fex", .opt_idx = kOptFormatexpr },
  { .name = "dex", .opt_idx = kOptDiffexpr },
  { .name = "bex", .opt_idx = kOptBackupext },
  { .name = "pex", .opt_idx = kOptPatchexpr },
  { .name = "pyx", .opt_idx = kOptPyxversion },
  { .name = "para", .opt_idx = kOptParagraphs },
  { .name = "arab", .opt_idx = kOptArabic },
  { .name = "bomb", .opt_idx = kOptBomb },
  { .name = "menc", .opt_idx = kOptMakeencoding },
  { .name = "sloc", .opt_idx = kOptShowcmdloc },
  { .name = "exrc", .opt_idx = kOptExrc },
  { .name = "fenc", .opt_idx = kOptFileencoding },
  { .name = "tenc", .opt_idx = kOptTermencoding },
  { .name = "cole", .opt_idx = kOptConceallevel },
  { .name = "inde", .opt_idx = kOptIndentexpr },
  { .name = "more", .opt_idx = kOptMore },
  { .name = "shcf", .opt_idx = kOptShellcmdflag },
  { .name = "diff", .opt_idx = kOptDiff },
  { .name = "qftf", .opt_idx = kOptQuickfixtextfunc },
  { .name = "path", .opt_idx = kOptPath },
  { .name = "indk", .opt_idx = kOptIndentkeys },
  { .name = "scbk", .opt_idx = kOptScrollback },
  { .name = "cink", .opt_idx = kOptCinkeys },
  { .name = "stal", .opt_idx = kOptShowtabline },
  { .name = "icon", .opt_idx = kOptIcon },
  { .name = "warn", .opt_idx = kOptWarn },
  { .name = "deco", .opt_idx = kOptDelcombine },
  { .name = "cino", .opt_idx = kOptCinoptions },
  { .name = "siso", .opt_idx = kOptSidescrolloff },
  { .name = "stmp", .opt_idx = kOptShelltemp },
  { .name = "lisp", .opt_idx = kOptLisp },
  { .name = "ssop", .opt_idx = kOptSessionoptions },
  { .name = "wrap", .opt_idx = kOptWrap },
  { .name = "lmap", .opt_idx = kOptLangmap },
  { .name = "udir", .opt_idx = kOptUndodir },
  { .name = "bdir", .opt_idx = kOptBackupdir },
  { .name = "vdir", .opt_idx = kOptViewdir },
  { .name = "vsts", .opt_idx = kOptVarsofttabstop },
  { .name = "tags", .opt_idx = kOptTags },
  { .name = "fdls", .opt_idx = kOptFoldlevelstart },
  { .name = "dict", .opt_idx = kOptDictionary },
  { .name = "sect", .opt_idx = kOptSections },
  { .name = "tgst", .opt_idx = kOptTagstack },
  { .name = "list", .opt_idx = kOptList },
  { .name = "mopt", .opt_idx = kOptMessagesopt },
  { .name = "cocu", .opt_idx = kOptConcealcursor },
  { .name = "wmnu", .opt_idx = kOptWildmenu },
  { .name = "odev", .opt_idx = kOptOpendevice },
  { .name = "ambw", .opt_idx = kOptAmbiwidth },
  { .name = "cinw", .opt_idx = kOptCinwords },
  { .name = "inex", .opt_idx = kOptIncludeexpr },
  { .name = "aleph", .opt_idx = kOptAleph },
  { .name = "bsdir", .opt_idx = kOptBrowsedir },
  { .name = "cinsd", .opt_idx = kOptCinscopedecls },
  { .name = "cedit", .opt_idx = kOptCedit },
  { .name = "debug", .opt_idx = kOptDebug },
  { .name = "emoji", .opt_idx = kOptEmoji },
  { .name = "fsync", .opt_idx = kOptFsync },
  { .name = "fencs", .opt_idx = kOptFileencodings },
  { .name = "hkmap", .opt_idx = kOptHkmap },
  { .name = "lines", .opt_idx = kOptLines },
  { .name = "magic", .opt_idx = kOptMagic },
  { .name = "mouse", .opt_idx = kOptMouse },
  { .name = "paste", .opt_idx = kOptPaste },
  { .name = "ruler", .opt_idx = kOptRuler },
  { .name = "remap", .opt_idx = kOptRemap },
  { .name = "shada", .opt_idx = kOptShada },
  { .name = "spell", .opt_idx = kOptSpell },
  { .name = "shell", .opt_idx = kOptShell },
  { .name = "tsrfu", .opt_idx = kOptThesaurusfunc },
  { .name = "title", .opt_idx = kOptTitle },
  { .name = "terse", .opt_idx = kOptTerse },
  { .name = "tbidi", .opt_idx = kOptTermbidi },
  { .name = "vfile", .opt_idx = kOptVerbosefile },
  { .name = "winhl", .opt_idx = kOptWinhighlight },
  { .name = "write", .opt_idx = kOptWrite },
  { .name = "winbl", .opt_idx = kOptWinblend },
  { .name = "arabic", .opt_idx = kOptArabic },
  { .name = "backup", .opt_idx = kOptBackup },
  { .name = "secure", .opt_idx = kOptSecure },
  { .name = "hidden", .opt_idx = kOptHidden },
  { .name = "define", .opt_idx = kOptDefine },
  { .name = "opfunc", .opt_idx = kOptOperatorfunc },
  { .name = "cdhome", .opt_idx = kOptCdhome },
  { .name = "briopt", .opt_idx = kOptBreakindentopt },
  { .name = "makeef", .opt_idx = kOptMakeef },
  { .name = "culopt", .opt_idx = kOptCursorlineopt },
  { .name = "hkmapp", .opt_idx = kOptHkmapp },
  { .name = "number", .opt_idx = kOptNumber },
  { .name = "winbar", .opt_idx = kOptWinbar },
  { .name = "binary", .opt_idx = kOptBinary },
  { .name = "window", .opt_idx = kOptWindow },
  { .name = "syntax", .opt_idx = kOptSyntax },
  { .name = "prompt", .opt_idx = kOptPrompt },
  { .name = "report", .opt_idx = kOptReport },
  { .name = "cdpath", .opt_idx = kOptCdpath },
  { .name = "scroll", .opt_idx = kOptScroll },
  { .name = "mousef", .opt_idx = kOptMousefocus },
  { .name = "mousem", .opt_idx = kOptMousemodel },
  { .name = "mouses", .opt_idx = kOptMouseshape },
  { .name = "mouset", .opt_idx = kOptMousetime },
  { .name = "revins", .opt_idx = kOptRevins },
  { .name = "fixeol", .opt_idx = kOptFixendofline },
  { .name = "keymap", .opt_idx = kOptKeymap },
  { .name = "channel", .opt_idx = kOptChannel },
  { .name = "tabstop", .opt_idx = kOptTabstop },
  { .name = "tabline", .opt_idx = kOptTabline },
  { .name = "include", .opt_idx = kOptInclude },
  { .name = "undodir", .opt_idx = kOptUndodir },
  { .name = "breakat", .opt_idx = kOptBreakat },
  { .name = "grepprg", .opt_idx = kOptGrepprg },
  { .name = "viewdir", .opt_idx = kOptViewdir },
  { .name = "buftype", .opt_idx = kOptBuftype },
  { .name = "diffopt", .opt_idx = kOptDiffopt },
  { .name = "isfname", .opt_idx = kOptIsfname },
  { .name = "tagfunc", .opt_idx = kOptTagfunc },
  { .name = "tagcase", .opt_idx = kOptTagcase },
  { .name = "digraph", .opt_idx = kOptDigraph },
  { .name = "isident", .opt_idx = kOptIsident },
  { .name = "guifont", .opt_idx = kOptGuifont },
  { .name = "makeprg", .opt_idx = kOptMakeprg },
  { .name = "belloff", .opt_idx = kOptBelloff },
  { .name = "columns", .opt_idx = kOptColumns },
  { .name = "tildeop", .opt_idx = kOptTildeop },
  { .name = "viminfo", .opt_idx = kOptShada },
  { .name = "timeout", .opt_idx = kOptTimeout },
  { .name = "cindent", .opt_idx = kOptCindent },
  { .name = "cinkeys", .opt_idx = kOptCinkeys },
  { .name = "confirm", .opt_idx = kOptConfirm },
  { .name = "langmap", .opt_idx = kOptLangmap },
  { .name = "showcmd", .opt_idx = kOptShowcmd },
  { .name = "isprint", .opt_idx = kOptIsprint },
  { .name = "verbose", .opt_idx = kOptVerbose },
  { .name = "history", .opt_idx = kOptHistory },
  { .name = "arshape", .opt_idx = kOptArabicshape },
  { .name = "display", .opt_idx = kOptDisplay },
  { .name = "casemap", .opt_idx = kOptCasemap },
  { .name = "ttyfast", .opt_idx = kOptTtyfast },
  { .name = "autoread", .opt_idx = kOptAutoread },
  { .name = "complete", .opt_idx = kOptComplete },
  { .name = "cinwords", .opt_idx = kOptCinwords },
  { .name = "comments", .opt_idx = kOptComments },
  { .name = "diffexpr", .opt_idx = kOptDiffexpr },
  { .name = "encoding", .opt_idx = kOptEncoding },
  { .name = "equalprg", .opt_idx = kOptEqualprg },
  { .name = "foldopen", .opt_idx = kOptFoldopen },
  { .name = "foldtext", .opt_idx = kOptFoldtext },
  { .name = "filetype", .opt_idx = kOptFiletype },
  { .name = "findfunc", .opt_idx = kOptFindfunc },
  { .name = "foldexpr", .opt_idx = kOptFoldexpr },
  { .name = "gdefault", .opt_idx = kOptGdefault },
  { .name = "helplang", .opt_idx = kOptHelplang },
  { .name = "hlsearch", .opt_idx = kOptHlsearch },
  { .name = "helpfile", .opt_idx = kOptHelpfile },
  { .name = "imsearch", .opt_idx = kOptImsearch },
  { .name = "iminsert", .opt_idx = kOptIminsert },
  { .name = "keymodel", .opt_idx = kOptKeymodel },
  { .name = "langmenu", .opt_idx = kOptLangmenu },
  { .name = "modeline", .opt_idx = kOptModeline },
  { .name = "modified", .opt_idx = kOptModified },
  { .name = "mousemev", .opt_idx = kOptMousemoveevent },
  { .name = "omnifunc", .opt_idx = kOptOmnifunc },
  { .name = "packpath", .opt_idx = kOptPackpath },
  { .name = "pumblend", .opt_idx = kOptPumblend },
  { .name = "pumwidth", .opt_idx = kOptPumwidth },
  { .name = "readonly", .opt_idx = kOptReadonly },
  { .name = "smarttab", .opt_idx = kOptSmarttab },
  { .name = "suffixes", .opt_idx = kOptSuffixes },
  { .name = "sections", .opt_idx = kOptSections },
  { .name = "swapfile", .opt_idx = kOptSwapfile },
  { .name = "showmode", .opt_idx = kOptShowmode },
  { .name = "titlelen", .opt_idx = kOptTitlelen },
  { .name = "ttimeout", .opt_idx = kOptTtimeout },
  { .name = "termbidi", .opt_idx = kOptTermbidi },
  { .name = "titleold", .opt_idx = kOptTitleold },
  { .name = "termsync", .opt_idx = kOptTermsync },
  { .name = "tagstack", .opt_idx = kOptTagstack },
  { .name = "tabclose", .opt_idx = kOptTabclose },
  { .name = "undofile", .opt_idx = kOptUndofile },
  { .name = "wildchar", .opt_idx = kOptWildchar },
  { .name = "winblend", .opt_idx = kOptWinblend },
  { .name = "wildmode", .opt_idx = kOptWildmode },
  { .name = "wildmenu", .opt_idx = kOptWildmenu },
  { .name = "winwidth", .opt_idx = kOptWinwidth },
  { .name = "wrapscan", .opt_idx = kOptWrapscan },
  { .name = "writeany", .opt_idx = kOptWriteany },
  { .name = "linebreak", .opt_idx = kOptLinebreak },
  { .name = "showbreak", .opt_idx = kOptShowbreak },
  { .name = "expandtab", .opt_idx = kOptExpandtab },
  { .name = "whichwrap", .opt_idx = kOptWhichwrap },
  { .name = "langremap", .opt_idx = kOptLangremap },
  { .name = "linespace", .opt_idx = kOptLinespace },
  { .name = "incsearch", .opt_idx = kOptIncsearch },
  { .name = "backspace", .opt_idx = kOptBackspace },
  { .name = "showmatch", .opt_idx = kOptShowmatch },
  { .name = "lispwords", .opt_idx = kOptLispwords },
  { .name = "patchmode", .opt_idx = kOptPatchmode },
  { .name = "mousehide", .opt_idx = kOptMousehide },
  { .name = "splitkeep", .opt_idx = kOptSplitkeep },
  { .name = "foldlevel", .opt_idx = kOptFoldlevel },
  { .name = "modelines", .opt_idx = kOptModelines },
  { .name = "bufhidden", .opt_idx = kOptBufhidden },
  { .name = "buflisted", .opt_idx = kOptBuflisted },
  { .name = "winborder", .opt_idx = kOptWinborder },
  { .name = "rightleft", .opt_idx = kOptRightleft },
  { .name = "scrolloff", .opt_idx = kOptScrolloff },
  { .name = "highlight", .opt_idx = kOptHighlight },
  { .name = "winheight", .opt_idx = kOptWinheight },
  { .name = "cmdheight", .opt_idx = kOptCmdheight },
  { .name = "pumheight", .opt_idx = kOptPumheight },
  { .name = "autochdir", .opt_idx = kOptAutochdir },
  { .name = "backupdir", .opt_idx = kOptBackupdir },
  { .name = "browsedir", .opt_idx = kOptBrowsedir },
  { .name = "shadafile", .opt_idx = kOptShadafile },
  { .name = "imdisable", .opt_idx = kOptImdisable },
  { .name = "spellfile", .opt_idx = kOptSpellfile },
  { .name = "errorfile", .opt_idx = kOptErrorfile },
  { .name = "endoffile", .opt_idx = kOptEndoffile },
  { .name = "matchtime", .opt_idx = kOptMatchtime },
  { .name = "shelltemp", .opt_idx = kOptShelltemp },
  { .name = "mousetime", .opt_idx = kOptMousetime },
  { .name = "menuitems", .opt_idx = kOptMenuitems },
  { .name = "cpoptions", .opt_idx = kOptCpoptions },
  { .name = "imcmdline", .opt_idx = kOptImcmdline },
  { .name = "spelllang", .opt_idx = kOptSpelllang },
  { .name = "endofline", .opt_idx = kOptEndofline },
  { .name = "selection", .opt_idx = kOptSelection },
  { .name = "synmaxcol", .opt_idx = kOptSynmaxcol },
  { .name = "guicursor", .opt_idx = kOptGuicursor },
  { .name = "shellpipe", .opt_idx = kOptShellpipe },
  { .name = "patchexpr", .opt_idx = kOptPatchexpr },
  { .name = "scrollopt", .opt_idx = kOptScrollopt },
  { .name = "listchars", .opt_idx = kOptListchars },
  { .name = "iskeyword", .opt_idx = kOptIskeyword },
  { .name = "fillchars", .opt_idx = kOptFillchars },
  { .name = "clipboard", .opt_idx = kOptClipboard },
  { .name = "wildcharm", .opt_idx = kOptWildcharm },
  { .name = "directory", .opt_idx = kOptDirectory },
  { .name = "formatprg", .opt_idx = kOptFormatprg },
  { .name = "shortmess", .opt_idx = kOptShortmess },
  { .name = "infercase", .opt_idx = kOptInfercase },
  { .name = "foldclose", .opt_idx = kOptFoldclose },
  { .name = "smartcase", .opt_idx = kOptSmartcase },
  { .name = "ambiwidth", .opt_idx = kOptAmbiwidth },
  { .name = "autowrite", .opt_idx = kOptAutowrite },
  { .name = "textwidth", .opt_idx = kOptTextwidth },
  { .name = "taglength", .opt_idx = kOptTaglength },
  { .name = "nrformats", .opt_idx = kOptNrformats },
  { .name = "thesaurus", .opt_idx = kOptThesaurus },
  { .name = "switchbuf", .opt_idx = kOptSwitchbuf },
  { .name = "winfixbuf", .opt_idx = kOptWinfixbuf },
  { .name = "backupext", .opt_idx = kOptBackupext },
  { .name = "matchpairs", .opt_idx = kOptMatchpairs },
  { .name = "foldenable", .opt_idx = kOptFoldenable },
  { .name = "modifiable", .opt_idx = kOptModifiable },
  { .name = "tagbsearch", .opt_idx = kOptTagbsearch },
  { .name = "paragraphs", .opt_idx = kOptParagraphs },
  { .name = "joinspaces", .opt_idx = kOptJoinspaces },
  { .name = "laststatus", .opt_idx = kOptLaststatus },
  { .name = "cursorbind", .opt_idx = kOptCursorbind },
  { .name = "delcombine", .opt_idx = kOptDelcombine },
  { .name = "visualbell", .opt_idx = kOptVisualbell },
  { .name = "scrollback", .opt_idx = kOptScrollback },
  { .name = "scrollbind", .opt_idx = kOptScrollbind },
  { .name = "maxcombine", .opt_idx = kOptMaxcombine },
  { .name = "backupcopy", .opt_idx = kOptBackupcopy },
  { .name = "ignorecase", .opt_idx = kOptIgnorecase },
  { .name = "lazyredraw", .opt_idx = kOptLazyredraw },
  { .name = "showcmdloc", .opt_idx = kOptShowcmdloc },
  { .name = "autoindent", .opt_idx = kOptAutoindent },
  { .name = "copyindent", .opt_idx = kOptCopyindent },
  { .name = "keywordprg", .opt_idx = kOptKeywordprg },
  { .name = "shellredir", .opt_idx = kOptShellredir },
  { .name = "formatexpr", .opt_idx = kOptFormatexpr },
  { .name = "indentexpr", .opt_idx = kOptIndentexpr },
  { .name = "splitbelow", .opt_idx = kOptSplitbelow },
  { .name = "errorbells", .opt_idx = kOptErrorbells },
  { .name = "writedelay", .opt_idx = kOptWritedelay },
  { .name = "tabpagemax", .opt_idx = kOptTabpagemax },
  { .name = "mouseshape", .opt_idx = kOptMouseshape },
  { .name = "shiftwidth", .opt_idx = kOptShiftwidth },
  { .name = "splitright", .opt_idx = kOptSplitright },
  { .name = "cinoptions", .opt_idx = kOptCinoptions },
  { .name = "helpheight", .opt_idx = kOptHelpheight },
  { .name = "guioptions", .opt_idx = kOptGuioptions },
  { .name = "compatible", .opt_idx = kOptCompatible },
  { .name = "scrolljump", .opt_idx = kOptScrolljump },
  { .name = "indentkeys", .opt_idx = kOptIndentkeys },
  { .name = "winaltkeys", .opt_idx = kOptWinaltkeys },
  { .name = "shellslash", .opt_idx = kOptShellslash },
  { .name = "statusline", .opt_idx = kOptStatusline },
  { .name = "cursorline", .opt_idx = kOptCursorline },
  { .name = "undoreload", .opt_idx = kOptUndoreload },
  { .name = "foldcolumn", .opt_idx = kOptFoldcolumn },
  { .name = "mkspellmem", .opt_idx = kOptMkspellmem },
  { .name = "signcolumn", .opt_idx = kOptSigncolumn },
  { .name = "insertmode", .opt_idx = kOptInsertmode },
  { .name = "selectmode", .opt_idx = kOptSelectmode },
  { .name = "inccommand", .opt_idx = kOptInccommand },
  { .name = "dictionary", .opt_idx = kOptDictionary },
  { .name = "foldignore", .opt_idx = kOptFoldignore },
  { .name = "wildignore", .opt_idx = kOptWildignore },
  { .name = "shiftround", .opt_idx = kOptShiftround },
  { .name = "background", .opt_idx = kOptBackground },
  { .name = "mousemodel", .opt_idx = kOptMousemodel },
  { .name = "mousefocus", .opt_idx = kOptMousefocus },
  { .name = "fileformat", .opt_idx = kOptFileformat },
  { .name = "foldmarker", .opt_idx = kOptFoldmarker },
  { .name = "grepformat", .opt_idx = kOptGrepformat },
  { .name = "sidescroll", .opt_idx = kOptSidescroll },
  { .name = "iconstring", .opt_idx = kOptIconstring },
  { .name = "wrapmargin", .opt_idx = kOptWrapmargin },
  { .name = "vartabstop", .opt_idx = kOptVartabstop },
  { .name = "pyxversion", .opt_idx = kOptPyxversion },
  { .name = "backupskip", .opt_idx = kOptBackupskip },
  { .name = "foldmethod", .opt_idx = kOptFoldmethod },
  { .name = "updatetime", .opt_idx = kOptUpdatetime },
  { .name = "redrawtime", .opt_idx = kOptRedrawtime },
  { .name = "timeoutlen", .opt_idx = kOptTimeoutlen },
  { .name = "shellquote", .opt_idx = kOptShellquote },
  { .name = "undolevels", .opt_idx = kOptUndolevels },
  { .name = "opendevice", .opt_idx = kOptOpendevice },
  { .name = "showtabline", .opt_idx = kOptShowtabline },
  { .name = "virtualedit", .opt_idx = kOptVirtualedit },
  { .name = "softtabstop", .opt_idx = kOptSofttabstop },
  { .name = "equalalways", .opt_idx = kOptEqualalways },
  { .name = "writebackup", .opt_idx = kOptWritebackup },
  { .name = "guitablabel", .opt_idx = kOptGuitablabel },
  { .name = "arabicshape", .opt_idx = kOptArabicshape },
  { .name = "colorcolumn", .opt_idx = kOptColorcolumn },
  { .name = "includeexpr", .opt_idx = kOptIncludeexpr },
  { .name = "updatecount", .opt_idx = kOptUpdatecount },
  { .name = "completeopt", .opt_idx = kOptCompleteopt },
  { .name = "quoteescape", .opt_idx = kOptQuoteescape },
  { .name = "eadirection", .opt_idx = kOptEadirection },
  { .name = "foldnestmax", .opt_idx = kOptFoldnestmax },
  { .name = "viminfofile", .opt_idx = kOptShadafile },
  { .name = "errorformat", .opt_idx = kOptErrorformat },
  { .name = "rulerformat", .opt_idx = kOptRulerformat },
  { .name = "messagesopt", .opt_idx = kOptMessagesopt },
  { .name = "eventignore", .opt_idx = kOptEventignore },
  { .name = "smartindent", .opt_idx = kOptSmartindent },
  { .name = "breakindent", .opt_idx = kOptBreakindent },
  { .name = "loadplugins", .opt_idx = kOptLoadplugins },
  { .name = "tagrelative", .opt_idx = kOptTagrelative },
  { .name = "runtimepath", .opt_idx = kOptRuntimepath },
  { .name = "guifontwide", .opt_idx = kOptGuifontwide },
  { .name = "winminwidth", .opt_idx = kOptWinminwidth },
  { .name = "langnoremap", .opt_idx = kOptLangnoremap },
  { .name = "startofline", .opt_idx = kOptStartofline },
  { .name = "ttimeoutlen", .opt_idx = kOptTtimeoutlen },
  { .name = "fileformats", .opt_idx = kOptFileformats },
  { .name = "charconvert", .opt_idx = kOptCharconvert },
  { .name = "jumpoptions", .opt_idx = kOptJumpoptions },
  { .name = "maxmapdepth", .opt_idx = kOptMaxmapdepth },
  { .name = "wildoptions", .opt_idx = kOptWildoptions },
  { .name = "viewoptions", .opt_idx = kOptViewoptions },
  { .name = "lispoptions", .opt_idx = kOptLispoptions },
  { .name = "allowrevins", .opt_idx = kOptAllowrevins },
  { .name = "numberwidth", .opt_idx = kOptNumberwidth },
  { .name = "titlestring", .opt_idx = kOptTitlestring },
  { .name = "mousescroll", .opt_idx = kOptMousescroll },
  { .name = "verbosefile", .opt_idx = kOptVerbosefile },
  { .name = "pastetoggle", .opt_idx = kOptPastetoggle },
  { .name = "showfulltag", .opt_idx = kOptShowfulltag },
  { .name = "redrawdebug", .opt_idx = kOptRedrawdebug },
  { .name = "shellxquote", .opt_idx = kOptShellxquote },
  { .name = "suffixesadd", .opt_idx = kOptSuffixesadd },
  { .name = "winfixwidth", .opt_idx = kOptWinfixwidth },
  { .name = "pummaxwidth", .opt_idx = kOptPummaxwidth },
  { .name = "statuscolumn", .opt_idx = kOptStatuscolumn },
  { .name = "edcompatible", .opt_idx = kOptEdcompatible },
  { .name = "modelineexpr", .opt_idx = kOptModelineexpr },
  { .name = "cmdwinheight", .opt_idx = kOptCmdwinheight },
  { .name = "shellcmdflag", .opt_idx = kOptShellcmdflag },
  { .name = "shellxescape", .opt_idx = kOptShellxescape },
  { .name = "spelloptions", .opt_idx = kOptSpelloptions },
  { .name = "spellsuggest", .opt_idx = kOptSpellsuggest },
  { .name = "operatorfunc", .opt_idx = kOptOperatorfunc },
  { .name = "regexpengine", .opt_idx = kOptRegexpengine },
  { .name = "rightleftcmd", .opt_idx = kOptRightleftcmd },
  { .name = "makeencoding", .opt_idx = kOptMakeencoding },
  { .name = "fileencoding", .opt_idx = kOptFileencoding },
  { .name = "foldminlines", .opt_idx = kOptFoldminlines },
  { .name = "completefunc", .opt_idx = kOptCompletefunc },
  { .name = "winhighlight", .opt_idx = kOptWinhighlight },
  { .name = "winminheight", .opt_idx = kOptWinminheight },
  { .name = "conceallevel", .opt_idx = kOptConceallevel },
  { .name = "winfixheight", .opt_idx = kOptWinfixheight },
  { .name = "smoothscroll", .opt_idx = kOptSmoothscroll },
  { .name = "termencoding", .opt_idx = kOptTermencoding },
  { .name = "cursorcolumn", .opt_idx = kOptCursorcolumn },
  { .name = "autowriteall", .opt_idx = kOptAutowriteall },
  { .name = "fixendofline", .opt_idx = kOptFixendofline },
  { .name = "maxfuncdepth", .opt_idx = kOptMaxfuncdepth },
  { .name = "concealcursor", .opt_idx = kOptConcealcursor },
  { .name = "guitabtooltip", .opt_idx = kOptGuitabtooltip },
  { .name = "spellcapcheck", .opt_idx = kOptSpellcapcheck },
  { .name = "sidescrolloff", .opt_idx = kOptSidescrolloff },
  { .name = "completeslash", .opt_idx = kOptCompleteslash },
  { .name = "previewheight", .opt_idx = kOptPreviewheight },
  { .name = "previewwindow", .opt_idx = kOptPreviewwindow },
  { .name = "maxmempattern", .opt_idx = kOptMaxmempattern },
  { .name = "fileencodings", .opt_idx = kOptFileencodings },
  { .name = "commentstring", .opt_idx = kOptCommentstring },
  { .name = "cinscopedecls", .opt_idx = kOptCinscopedecls },
  { .name = "cursorlineopt", .opt_idx = kOptCursorlineopt },
  { .name = "formatoptions", .opt_idx = kOptFormatoptions },
  { .name = "formatlistpat", .opt_idx = kOptFormatlistpat },
  { .name = "thesaurusfunc", .opt_idx = kOptThesaurusfunc },
  { .name = "termguicolors", .opt_idx = kOptTermguicolors },
  { .name = "breakindentopt", .opt_idx = kOptBreakindentopt },
  { .name = "eventignorewin", .opt_idx = kOptEventignorewin },
  { .name = "foldlevelstart", .opt_idx = kOptFoldlevelstart },
  { .name = "fileignorecase", .opt_idx = kOptFileignorecase },
  { .name = "mousemoveevent", .opt_idx = kOptMousemoveevent },
  { .name = "preserveindent", .opt_idx = kOptPreserveindent },
  { .name = "relativenumber", .opt_idx = kOptRelativenumber },
  { .name = "sessionoptions", .opt_idx = kOptSessionoptions },
  { .name = "varsofttabstop", .opt_idx = kOptVarsofttabstop },
  { .name = "wildignorecase", .opt_idx = kOptWildignorecase },
  { .name = "termpastefilter", .opt_idx = kOptTermpastefilter },
  { .name = "quickfixtextfunc", .opt_idx = kOptQuickfixtextfunc },
  { .name = "completeitemalign", .opt_idx = kOptCompleteitemalign },
  { .name = "completefuzzycollect", .opt_idx = kOptCompletefuzzycollect },
};

static int find_option_hash(const char *str, size_t len)
{
  int low = 0, high = 0;
  switch (len) {
    case 2: switch (str[1]) {
      case 'a': low = 0; high = 4; break;
      case 'b': low = 4; high = 10; break;
      case 'c': low = 10; high = 16; break;
      case 'd': low = 16; high = 21; break;
      case 'e': low = 21; high = 24; break;
      case 'f': low = 24; high = 30; break;
      case 'g': low = 30; high = 32; break;
      case 'h': low = 32; high = 39; break;
      case 'i': low = 39; high = 48; break;
      case 'j': low = 48; high = 49; break;
      case 'k': low = 49; high = 51; break;
      case 'l': low = 51; high = 58; break;
      case 'm': low = 58; high = 65; break;
      case 'o': low = 65; high = 72; break;
      case 'p': low = 72; high = 80; break;
      case 'r': low = 80; high = 84; break;
      case 's': low = 84; high = 92; break;
      case 't': low = 92; high = 97; break;
      case 'u': low = 97; high = 100; break;
      case 'w': low = 100; high = 106; break;
      case 'x': low = 106; high = 107; break;
      case 'y': low = 107; high = 108; break;
      case 'z': low = 108; high = 109; break;
      default: break;
    }
    break;
    case 3: switch (str[2]) {
      case 'a': low = 109; high = 113; break;
      case 'b': low = 113; high = 118; break;
      case 'c': low = 118; high = 132; break;
      case 'd': low = 132; high = 140; break;
      case 'e': low = 140; high = 143; break;
      case 'f': low = 143; high = 155; break;
      case 'g': low = 155; high = 158; break;
      case 'h': low = 158; high = 163; break;
      case 'i': low = 163; high = 168; break;
      case 'k': low = 168; high = 173; break;
      case 'l': low = 173; high = 189; break;
      case 'm': low = 189; high = 202; break;
      case 'n': low = 202; high = 208; break;
      case 'o': low = 208; high = 214; break;
      case 'p': low = 214; high = 228; break;
      case 'q': low = 228; high = 230; break;
      case 'r': low = 230; high = 241; break;
      case 's': low = 241; high = 257; break;
      case 't': low = 257; high = 264; break;
      case 'u': low = 264; high = 269; break;
      case 'v': low = 269; high = 270; break;
      case 'w': low = 270; high = 278; break;
      case 'x': low = 278; high = 283; break;
      default: break;
    }
    break;
    case 4: switch (str[3]) {
      case 'a': low = 283; high = 284; break;
      case 'b': low = 284; high = 286; break;
      case 'c': low = 286; high = 291; break;
      case 'e': low = 291; high = 294; break;
      case 'f': low = 294; high = 297; break;
      case 'h': low = 297; high = 298; break;
      case 'k': low = 298; high = 301; break;
      case 'l': low = 301; high = 302; break;
      case 'n': low = 302; high = 304; break;
      case 'o': low = 304; high = 307; break;
      case 'p': low = 307; high = 312; break;
      case 'r': low = 312; high = 315; break;
      case 's': low = 315; high = 318; break;
      case 't': low = 318; high = 323; break;
      case 'u': low = 323; high = 325; break;
      case 'v': low = 325; high = 326; break;
      case 'w': low = 326; high = 328; break;
      case 'x': low = 328; high = 329; break;
      default: break;
    }
    break;
    case 5: switch (str[0]) {
      case 'a': low = 329; high = 330; break;
      case 'b': low = 330; high = 331; break;
      case 'c': low = 331; high = 333; break;
      case 'd': low = 333; high = 334; break;
      case 'e': low = 334; high = 335; break;
      case 'f': low = 335; high = 337; break;
      case 'h': low = 337; high = 338; break;
      case 'l': low = 338; high = 339; break;
      case 'm': low = 339; high = 341; break;
      case 'p': low = 341; high = 342; break;
      case 'r': low = 342; high = 344; break;
      case 's': low = 344; high = 347; break;
      case 't': low = 347; high = 351; break;
      case 'v': low = 351; high = 352; break;
      case 'w': low = 352; high = 355; break;
      default: break;
    }
    break;
    case 6: switch (str[2]) {
      case 'a': low = 355; high = 356; break;
      case 'c': low = 356; high = 358; break;
      case 'd': low = 358; high = 359; break;
      case 'f': low = 359; high = 361; break;
      case 'h': low = 361; high = 362; break;
      case 'i': low = 362; high = 363; break;
      case 'k': low = 363; high = 364; break;
      case 'l': low = 364; high = 365; break;
      case 'm': low = 365; high = 367; break;
      case 'n': low = 367; high = 371; break;
      case 'o': low = 371; high = 372; break;
      case 'p': low = 372; high = 374; break;
      case 'r': low = 374; high = 375; break;
      case 'u': low = 375; high = 379; break;
      case 'v': low = 379; high = 380; break;
      case 'x': low = 380; high = 381; break;
      case 'y': low = 381; high = 382; break;
      default: break;
    }
    break;
    case 7: switch (str[2]) {
      case 'a': low = 382; high = 383; break;
      case 'b': low = 383; high = 385; break;
      case 'c': low = 385; high = 386; break;
      case 'd': low = 386; high = 387; break;
      case 'e': low = 387; high = 390; break;
      case 'f': low = 390; high = 393; break;
      case 'g': low = 393; high = 396; break;
      case 'i': low = 396; high = 398; break;
      case 'k': low = 398; high = 399; break;
      case 'l': low = 399; high = 402; break;
      case 'm': low = 402; high = 404; break;
      case 'n': low = 404; high = 408; break;
      case 'o': low = 408; high = 409; break;
      case 'p': low = 409; high = 410; break;
      case 'r': low = 410; high = 411; break;
      case 's': low = 411; high = 415; break;
      case 'y': low = 415; high = 416; break;
      default: break;
    }
    break;
    case 8: switch (str[0]) {
      case 'a': low = 416; high = 417; break;
      case 'c': low = 417; high = 420; break;
      case 'd': low = 420; high = 421; break;
      case 'e': low = 421; high = 423; break;
      case 'f': low = 423; high = 428; break;
      case 'g': low = 428; high = 429; break;
      case 'h': low = 429; high = 432; break;
      case 'i': low = 432; high = 434; break;
      case 'k': low = 434; high = 435; break;
      case 'l': low = 435; high = 436; break;
      case 'm': low = 436; high = 439; break;
      case 'o': low = 439; high = 440; break;
      case 'p': low = 440; high = 443; break;
      case 'r': low = 443; high = 444; break;
      case 's': low = 444; high = 449; break;
      case 't': low = 449; high = 456; break;
      case 'u': low = 456; high = 457; break;
      case 'w': low = 457; high = 464; break;
      default: break;
    }
    break;
    case 9: switch (str[7]) {
      case 'a': low = 464; high = 469; break;
      case 'c': low = 469; high = 473; break;
      case 'd': low = 473; high = 476; break;
      case 'e': low = 476; high = 482; break;
      case 'f': low = 482; high = 484; break;
      case 'h': low = 484; high = 488; break;
      case 'i': low = 488; high = 491; break;
      case 'l': low = 491; high = 496; break;
      case 'm': low = 496; high = 500; break;
      case 'n': low = 500; high = 504; break;
      case 'o': low = 504; high = 507; break;
      case 'p': low = 507; high = 510; break;
      case 'r': low = 510; high = 517; break;
      case 's': low = 517; high = 521; break;
      case 't': low = 521; high = 526; break;
      case 'u': low = 526; high = 529; break;
      case 'x': low = 529; high = 530; break;
      default: break;
    }
    break;
    case 10: switch (str[6]) {
      case 'a': low = 530; high = 537; break;
      case 'b': low = 537; high = 543; break;
      case 'c': low = 543; high = 545; break;
      case 'd': low = 545; high = 550; break;
      case 'e': low = 550; high = 557; break;
      case 'h': low = 557; high = 558; break;
      case 'i': low = 558; high = 564; break;
      case 'j': low = 564; high = 565; break;
      case 'k': low = 565; high = 567; break;
      case 'l': low = 567; high = 574; break;
      case 'm': low = 574; high = 577; break;
      case 'n': low = 577; high = 580; break;
      case 'o': low = 580; high = 584; break;
      case 'r': low = 584; high = 590; break;
      case 's': low = 590; high = 593; break;
      case 't': low = 593; high = 597; break;
      case 'u': low = 597; high = 598; break;
      case 'v': low = 598; high = 600; break;
      default: break;
    }
    break;
    case 11: switch (str[5]) {
      case 'a': low = 600; high = 604; break;
      case 'b': low = 604; high = 606; break;
      case 'c': low = 606; high = 608; break;
      case 'd': low = 608; high = 609; break;
      case 'e': low = 609; high = 614; break;
      case 'f': low = 614; high = 617; break;
      case 'g': low = 617; high = 618; break;
      case 'i': low = 618; high = 621; break;
      case 'l': low = 621; high = 623; break;
      case 'm': low = 623; high = 624; break;
      case 'n': low = 624; high = 626; break;
      case 'o': low = 626; high = 631; break;
      case 'p': low = 631; high = 636; break;
      case 'r': low = 636; high = 638; break;
      case 's': low = 638; high = 641; break;
      case 't': low = 641; high = 642; break;
      case 'u': low = 642; high = 643; break;
      case 'w': low = 643; high = 644; break;
      case 'x': low = 644; high = 648; break;
      default: break;
    }
    break;
    case 12: switch (str[2]) {
      case 'a': low = 648; high = 649; break;
      case 'c': low = 649; high = 650; break;
      case 'd': low = 650; high = 652; break;
      case 'e': low = 652; high = 657; break;
      case 'g': low = 657; high = 659; break;
      case 'k': low = 659; high = 660; break;
      case 'l': low = 660; high = 662; break;
      case 'm': low = 662; high = 663; break;
      case 'n': low = 663; high = 667; break;
      case 'o': low = 667; high = 668; break;
      case 'r': low = 668; high = 670; break;
      case 't': low = 670; high = 671; break;
      case 'x': low = 671; high = 673; break;
      default: break;
    }
    break;
    case 13: switch (str[5]) {
      case 'a': low = 673; high = 674; break;
      case 'b': low = 674; high = 675; break;
      case 'c': low = 675; high = 677; break;
      case 'e': low = 677; high = 680; break;
      case 'm': low = 680; high = 681; break;
      case 'n': low = 681; high = 683; break;
      case 'o': low = 683; high = 684; break;
      case 'r': low = 684; high = 685; break;
      case 't': low = 685; high = 687; break;
      case 'u': low = 687; high = 689; break;
      default: break;
    }
    break;
    case 14: switch (str[0]) {
      case 'b': low = 689; high = 690; break;
      case 'e': low = 690; high = 691; break;
      case 'f': low = 691; high = 693; break;
      case 'm': low = 693; high = 694; break;
      case 'p': low = 694; high = 695; break;
      case 'r': low = 695; high = 696; break;
      case 's': low = 696; high = 697; break;
      case 'v': low = 697; high = 698; break;
      case 'w': low = 698; high = 699; break;
      default: break;
    }
    break;
    case 15: low = 699; high = 700; break;
    case 16: low = 700; high = 701; break;
    case 17: low = 701; high = 702; break;
    case 20: low = 702; high = 703; break;
    default: break;
  }
  for (int i = low; i < high; i++) {
    if (!memcmp(str, option_hash_elems[i].name, len)) {
      return i;
    }
  }
  return -1;
}


