/*
 * COPYRIGHT (c) International Business Machines Corp. 2025
 *
 * This program is provided under the terms of the Common Public License,
 * version 1.0 (CPL-1.0). Any use, reproduction or distribution for this
 * software constitutes recipient's acceptance of CPL-1.0 terms which can be
 * found in the file LICENSE file or at
 * https://opensource.org/licenses/cpl1.0.php
 */
/* AUTO-GENERATED on Sun Apr  6 16:40:01 2025.  DO NOT EDIT! */

#include <string.h>
#include <pkcs11types.h>
#include "mechtable.h"
#include "mechtable.inc"

static const unsigned char numericalphabet[] = {
  0, 1, 2, 3, 4, 5, 6, 7,
  0, 8, 9, 10, 11, 12, 13, 0,
  14, 15, 16, 0, 0, 0, 0, 0,
  0, 0, 0, 17, 18, 0, 19, 20,
  21, 22, 23, 24, 25, 26, 27, 28,
  29, 0, 0, 0, 0, 0, 0, 0,
  30, 31, 32, 33, 34, 35, 36, 37,
  38, 0, 0, 0, 0, 0, 0, 0,
  39, 40, 41, 42, 43, 44, 45, 46,
  47, 48, 49, 0, 50, 51, 52, 0,
  53, 54, 55, 56, 0, 57, 58, 59,
  0, 0, 0, 0, 0, 0, 0, 0,
  60, 61, 62, 63, 64, 65, 66, 67,
  0, 0, 0, 0, 0, 0, 0, 0,
  68, 69, 70, 0, 71, 0, 72, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  73, 74, 75, 76, 77, 78, 79, 80,
  0, 81, 82, 0, 0, 0, 0, 0,
  0, 0, 83, 84, 85, 86, 87, 88,
  89, 90, 91, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  92, 0, 0, 0, 0, 0, 0, 0,
  93, 94, 95, 0, 0, 96, 97, 98,
  0, 0, 0, 0, 0, 0, 0, 0,
  99, 100, 101, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  102, 103, 104, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
};
static const short numerictable[] = {
  -77, -76, 214, -80, 15, -74, -87, 2,
  -78, -82, -81, -89, -79, -88, -37, -36,
  -39, -38, -35, -53, 27, -34, -33, -16,
  -4, -5, -3, -151, -54, -71, -72, -73,
  182, 0, 0, 0, -83, -84, -85, -100,
  -106, -142, -101, -107, -143, -94, -95, -133,
  -134, -135, -136, -137, -138, 32, 4, 0,
  0, 0, 0, 20, -118, -124, -130, -119,
  -125, -131, -112, -113, -96, -97, -98, 0,
  -90, -91, -92, -102, -103, -104, 0, 0,
  52, 0, 0, -132, -139, -140, 0, 0,
  0, 0, -51, -41, -42, -43, -44, -45,
  -50, -46, -47, -48, -49, 0, 0, 0,
  -40, 0, 0, 0, -114, -115, -116, -108,
  -109, -110, -120, -121, -122, -126, -127, -128,
  -13, -12, -52, 0, -11, -9, -1, -14,
  -15, -2, -8, -10, -7, -6, 0, 0,
  0, -147, -145, -144, -150, -149, -146, -148,
  0, 0, 0, 0, 0, 0, 0, 0,
  -86, -99, -105, -141, -93, -117, -111, -123,
  -129, -75, -152, -31, -30, -26, 0, 0,
  -27, 0, 0, 0, -17, -23, -22, -18,
  -24, -25, -19, -21, -20, 0, 0, -63,
  -65, -67, -69, 0, 0, -55, 0, 0,
  0, 0, 0, -32, 0, -28, -29, -58,
  -60, -59, -61, 0, 0, 0, -56, -62,
  -64, -66, -68, -70, 0, -57, 0, 142,
  15, 69, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 51, 0, 0, 0,
  0, 0, 0, 17, 19, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0,
};
int mechtable_idx_from_numeric(CK_ULONG mech)
{
    unsigned int idx1, idx2, idx3, idx4;
    int o1, o2, o3;
    int midx;

    idx1 = numericalphabet[(mech & 0xff000000u) >> 24u];
    idx2 = numericalphabet[(mech & 0x00ff0000u) >> 16u];
    idx3 = numericalphabet[(mech & 0x0000ff00u) >> 8u];
    idx4 = numericalphabet[mech & 0x000000ffu];
    o1 = numerictable[7 + idx1];
    if (o1 < 0) return -1;
    o2 = numerictable[o1 + idx2];
    if (o2 < 0) return -1;
    o3 = numerictable[o2 + idx3];
    if (o3 < 0) return -1;
    midx = numerictable[o3 + idx4];
    midx = -(midx + 1);
    if (0 <= midx && midx < 152 && mechtable_rows[midx].numeric == mech)
        return midx;
    return -1;
}

const struct mechrow *mechrow_from_numeric(CK_ULONG mech)
{
    int idx = mechtable_idx_from_numeric(mech);

    if (idx < 0)
        return NULL;
    return &mechtable_rows[idx];
}

static const unsigned char stringalphabet[] = {
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  1, 2, 3, 4, 5, 6, 7, 0,
  8, 9, 0, 0, 0, 0, 0, 0,
  0, 10, 11, 12, 13, 14, 15, 16,
  17, 18, 0, 19, 20, 21, 22, 23,
  24, 0, 25, 26, 27, 28, 29, 30,
  31, 32, 0, 0, 0, 0, 0, 33,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0,
};
static const short stringtable[] = {
  0, 0, 235, 113, 66, -36, 385, -42,
  214, 100, 9, -50, 166, 3, 198, 183,
  -52, 150, 208, 186, 169, 232, 170, 10,
  421, 225, 37, 401, 37, 199, -9, 230,
  -10, 260, 230, 412, 13, 159, 106, -16,
  -53, -54, -55, -56, 102, 115, 16, 139,
  45, -62, -17, 144, 83, 1, 251, -22,
  208, 160, 151, 382, -23, -141, 173, 396,
  -8, 28, 231, 381, 240, 114, 346, 4,
  368, -30, 304, 260, -40, -93, -31, 275,
  59, -99, -32, 260, 289, 201, -105, 275,
  304, 319, -111, -117, 289, 336, 120, -123,
  304, 319, 352, 66, -129, 335, -144, -41,
  410, 235, 352, -147, -45, -148, 215, -48,
  129, -49, 113, 227, 275, 319, 384, 288,
  332, 389, -3, -33, 59, -37, -57, -4,
  -5, -34, -38, -71, -39, 107, -35, 226,
  187, -76, 224, -83, -90, -86, -96, -74,
  -51, -77, 193, 244, 256, -78, -79, -102,
  -108, -114, -120, -89, -126, -132, -133, -136,
  -1, 151, -80, 165, 118, -6, 141, 168,
  -13, 159, 126, 174, 246, 58, -14, 62,
  47, 41, 179, -18, 169, 182, -20, 176,
  67, 71, 72, 76, 194, 81, 42, 373,
  380, -2, -24, 196, -26, 192, -7, -28,
  -29, -12, 179, 185, 193, 180, 175, -15,
  110, 5, 111, 103, -19, 197, 206, -21,
  5, -43, -46, 201, -44, -47, 190, 30,
  223, 221, -58, -25, -59, -27, -60, 229,
  -61, 201, 62, 236, -63, 238, -65, 235,
  241, -67, 240, 244, -69, 240, 131, 238,
  237, 250, -72, 242, 220, 81, 243, 230,
  137, 254, 257, 260, -81, 0, 139, 243,
  255, 254, 267, -84, 122, -64, 262, -66,
  240, 124, -68, 264, 252, -70, 279, -87,
  140, 272, 272, -73, 285, -91, 277, 255,
  265, 271, 279, 266, 294, -82, -94, 142,
  287, 286, 299, -97, -85, 292, 270, 280,
  286, 294, 281, 308, -100, 151, 301, 301,
  -88, 314, -103, 306, 284, 295, -92, 301,
  309, 296, 323, -106, 152, 316, 316, -95,
  329, -109, 321, 300, -98, 310, 316, 324,
  311, 338, -112, 153, 332, -101, 331, 344,
  -115, 336, 315, -104, 325, 331, 339, 326,
  353, -118, 350, 154, -107, 348, 347, 360,
  -121, 353, -110, 331, 341, 347, 355, 342,
  369, -124, 369, -113, 156, 364, 363, 376,
  -127, -116, 369, 347, 357, 363, 371, 358,
  385, -130, -119, 385, 157, 158, 370, 382,
  382, -122, 395, -134, 159, 377, 389, 388,
  401, -137, -125, 394, 393, 406, -139, 398,
  377, -128, 387, 393, 401, 388, 415, -142,
  413, 386, -131, 83, -145, 396, 391, -146,
  406, -149, 395, 396, -135, 415, -150, -11,
  -75, 0, -138, 0, 0, 0, 0, -140,
  -152, 0, 0, 0, 0, -151, 0, 0,
  -143, 0, 0, 0, 0, 0, 0,
};
static const size_t commonprefixlength = 4;

int mechtable_idx_from_string(const char *mech)
{
    static const struct {
        const char *string;
        const char *alias;
    } aliaslist[] = {
        { "CKM_ECDSA_KEY_PAIR_GEN", "CKM_EC_KEY_PAIR_GEN" },
        { "CKM_IBM_EC_C25519", "CKM_IBM_EC_X25519" },
        { "CKM_IBM_EC_C448", "CKM_IBM_EC_X448" },
        { "CKM_IBM_EDDSA_SHA512", "CKM_IBM_ED25519_SHA512" },
        { "CKM_SHA3_224_KEY_DERIVE", "CKM_SHA3_224_KEY_DERIVATION" },
        { "CKM_SHA3_256_KEY_DERIVE", "CKM_SHA3_256_KEY_DERIVATION" },
        { "CKM_SHA3_384_KEY_DERIVE", "CKM_SHA3_384_KEY_DERIVATION" },
        { "CKM_SHA3_512_KEY_DERIVE", "CKM_SHA3_512_KEY_DERIVATION" },
    };
    size_t len = strlen(mech), i;
    short idx = 0;
    unsigned char h;

    for (i = commonprefixlength; i <= len; ++i) {
        h = stringalphabet[(int)mech[i]];
        idx = stringtable[idx + h];
        if (idx < 0) {
            idx = -(idx + 1);
            if (strcmp(mech, mechtable_rows[idx].string) == 0)
                return idx;
            goto outcheckaliases;
        }
    }
  outcheckaliases:
    for (i = 0; i < sizeof(aliaslist) / sizeof(aliaslist[0]); ++i) {
        if (strcmp(aliaslist[i].string, mech) == 0)
            return mechtable_idx_from_string(aliaslist[i].alias);
    }
    return -1;
}

const struct mechrow *mechrow_from_string(const char *mech)
{
    int idx = mechtable_idx_from_string(mech);

    if (idx < 0)
        return NULL;
    return &mechtable_rows[idx];
}

const struct mechtable_funcs mechtable_funcs = {
    .p_idx_from_num = &mechtable_idx_from_numeric,
    .p_idx_from_str = &mechtable_idx_from_string,
    .p_row_from_num = &mechrow_from_numeric,
    .p_row_from_str = &mechrow_from_string
};

