/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   Serializer.cpp
 * Author:
 *
 * Created on October 4, 2021, 10:53 PM
 */
#include <uhdm/Serializer.h>
#include <uhdm/UhdmListener.h>
#include <uhdm/vpi_visitor.h>

#include <algorithm>
#include <iomanip>
#include <iostream>
#include <map>
#include <string>
#include <vector>

#include <uhdm/uhdm.h>

namespace UHDM {

const uint32_t Serializer::kVersion = 1;

void Serializer::GarbageCollect() {
  if (!m_enableGC) return;

  UhdmListener* const listener = new UhdmListener();
  for (auto d : designMaker.objects_) {
    listener->listenDesign(d);
  }

  const AnySet visited(listener->getVisited().begin(), listener->getVisited().end());
  delete listener;

  attributeMaker.EraseIfNotIn(visited);
  virtual_interface_varMaker.EraseIfNotIn(visited);
  let_declMaker.EraseIfNotIn(visited);
  alwaysMaker.EraseIfNotIn(visited);
  final_stmtMaker.EraseIfNotIn(visited);
  initialMaker.EraseIfNotIn(visited);
  delay_controlMaker.EraseIfNotIn(visited);
  delay_termMaker.EraseIfNotIn(visited);
  event_controlMaker.EraseIfNotIn(visited);
  repeat_controlMaker.EraseIfNotIn(visited);
  beginMaker.EraseIfNotIn(visited);
  named_beginMaker.EraseIfNotIn(visited);
  named_forkMaker.EraseIfNotIn(visited);
  fork_stmtMaker.EraseIfNotIn(visited);
  for_stmtMaker.EraseIfNotIn(visited);
  if_stmtMaker.EraseIfNotIn(visited);
  event_stmtMaker.EraseIfNotIn(visited);
  thread_objMaker.EraseIfNotIn(visited);
  forever_stmtMaker.EraseIfNotIn(visited);
  wait_stmtMaker.EraseIfNotIn(visited);
  wait_forkMaker.EraseIfNotIn(visited);
  ordered_waitMaker.EraseIfNotIn(visited);
  disableMaker.EraseIfNotIn(visited);
  disable_forkMaker.EraseIfNotIn(visited);
  continue_stmtMaker.EraseIfNotIn(visited);
  break_stmtMaker.EraseIfNotIn(visited);
  return_stmtMaker.EraseIfNotIn(visited);
  while_stmtMaker.EraseIfNotIn(visited);
  repeatMaker.EraseIfNotIn(visited);
  do_whileMaker.EraseIfNotIn(visited);
  if_elseMaker.EraseIfNotIn(visited);
  case_stmtMaker.EraseIfNotIn(visited);
  forceMaker.EraseIfNotIn(visited);
  assign_stmtMaker.EraseIfNotIn(visited);
  deassignMaker.EraseIfNotIn(visited);
  releaseMaker.EraseIfNotIn(visited);
  null_stmtMaker.EraseIfNotIn(visited);
  expect_stmtMaker.EraseIfNotIn(visited);
  foreach_stmtMaker.EraseIfNotIn(visited);
  gen_scopeMaker.EraseIfNotIn(visited);
  gen_varMaker.EraseIfNotIn(visited);
  gen_scope_arrayMaker.EraseIfNotIn(visited);
  assert_stmtMaker.EraseIfNotIn(visited);
  coverMaker.EraseIfNotIn(visited);
  assumeMaker.EraseIfNotIn(visited);
  restrictMaker.EraseIfNotIn(visited);
  immediate_assertMaker.EraseIfNotIn(visited);
  immediate_assumeMaker.EraseIfNotIn(visited);
  immediate_coverMaker.EraseIfNotIn(visited);
  case_itemMaker.EraseIfNotIn(visited);
  assignmentMaker.EraseIfNotIn(visited);
  any_patternMaker.EraseIfNotIn(visited);
  tagged_patternMaker.EraseIfNotIn(visited);
  struct_patternMaker.EraseIfNotIn(visited);
  unsupported_exprMaker.EraseIfNotIn(visited);
  unsupported_stmtMaker.EraseIfNotIn(visited);
  include_file_infoMaker.EraseIfNotIn(visited);
  sequence_instMaker.EraseIfNotIn(visited);
  seq_formal_declMaker.EraseIfNotIn(visited);
  sequence_declMaker.EraseIfNotIn(visited);
  prop_formal_declMaker.EraseIfNotIn(visited);
  property_instMaker.EraseIfNotIn(visited);
  property_specMaker.EraseIfNotIn(visited);
  property_declMaker.EraseIfNotIn(visited);
  clocked_propertyMaker.EraseIfNotIn(visited);
  case_property_itemMaker.EraseIfNotIn(visited);
  case_propertyMaker.EraseIfNotIn(visited);
  multiclock_sequence_exprMaker.EraseIfNotIn(visited);
  clocked_seqMaker.EraseIfNotIn(visited);
  constantMaker.EraseIfNotIn(visited);
  let_exprMaker.EraseIfNotIn(visited);
  operationMaker.EraseIfNotIn(visited);
  ref_objMaker.EraseIfNotIn(visited);
  ref_moduleMaker.EraseIfNotIn(visited);
  ref_typespecMaker.EraseIfNotIn(visited);
  part_selectMaker.EraseIfNotIn(visited);
  indexed_part_selectMaker.EraseIfNotIn(visited);
  var_selectMaker.EraseIfNotIn(visited);
  bit_selectMaker.EraseIfNotIn(visited);
  hier_pathMaker.EraseIfNotIn(visited);
  ref_varMaker.EraseIfNotIn(visited);
  short_real_varMaker.EraseIfNotIn(visited);
  real_varMaker.EraseIfNotIn(visited);
  byte_varMaker.EraseIfNotIn(visited);
  short_int_varMaker.EraseIfNotIn(visited);
  int_varMaker.EraseIfNotIn(visited);
  long_int_varMaker.EraseIfNotIn(visited);
  integer_varMaker.EraseIfNotIn(visited);
  time_varMaker.EraseIfNotIn(visited);
  array_varMaker.EraseIfNotIn(visited);
  array_exprMaker.EraseIfNotIn(visited);
  reg_arrayMaker.EraseIfNotIn(visited);
  regMaker.EraseIfNotIn(visited);
  packed_array_varMaker.EraseIfNotIn(visited);
  bit_varMaker.EraseIfNotIn(visited);
  logic_varMaker.EraseIfNotIn(visited);
  struct_varMaker.EraseIfNotIn(visited);
  union_varMaker.EraseIfNotIn(visited);
  enum_varMaker.EraseIfNotIn(visited);
  string_varMaker.EraseIfNotIn(visited);
  chandle_varMaker.EraseIfNotIn(visited);
  var_bitMaker.EraseIfNotIn(visited);
  taskMaker.EraseIfNotIn(visited);
  functionMaker.EraseIfNotIn(visited);
  modportMaker.EraseIfNotIn(visited);
  interface_tf_declMaker.EraseIfNotIn(visited);
  cont_assignMaker.EraseIfNotIn(visited);
  cont_assign_bitMaker.EraseIfNotIn(visited);
  portMaker.EraseIfNotIn(visited);
  port_bitMaker.EraseIfNotIn(visited);
  checker_portMaker.EraseIfNotIn(visited);
  checker_inst_portMaker.EraseIfNotIn(visited);
  gateMaker.EraseIfNotIn(visited);
  switch_tranMaker.EraseIfNotIn(visited);
  udpMaker.EraseIfNotIn(visited);
  mod_pathMaker.EraseIfNotIn(visited);
  tchkMaker.EraseIfNotIn(visited);
  rangeMaker.EraseIfNotIn(visited);
  udp_defnMaker.EraseIfNotIn(visited);
  table_entryMaker.EraseIfNotIn(visited);
  io_declMaker.EraseIfNotIn(visited);
  alias_stmtMaker.EraseIfNotIn(visited);
  clocking_blockMaker.EraseIfNotIn(visited);
  clocking_io_declMaker.EraseIfNotIn(visited);
  param_assignMaker.EraseIfNotIn(visited);
  interface_arrayMaker.EraseIfNotIn(visited);
  program_arrayMaker.EraseIfNotIn(visited);
  module_arrayMaker.EraseIfNotIn(visited);
  gate_arrayMaker.EraseIfNotIn(visited);
  switch_arrayMaker.EraseIfNotIn(visited);
  udp_arrayMaker.EraseIfNotIn(visited);
  prim_termMaker.EraseIfNotIn(visited);
  path_termMaker.EraseIfNotIn(visited);
  tchk_termMaker.EraseIfNotIn(visited);
  net_bitMaker.EraseIfNotIn(visited);
  struct_netMaker.EraseIfNotIn(visited);
  enum_netMaker.EraseIfNotIn(visited);
  integer_netMaker.EraseIfNotIn(visited);
  time_netMaker.EraseIfNotIn(visited);
  logic_netMaker.EraseIfNotIn(visited);
  array_netMaker.EraseIfNotIn(visited);
  packed_array_netMaker.EraseIfNotIn(visited);
  event_typespecMaker.EraseIfNotIn(visited);
  named_eventMaker.EraseIfNotIn(visited);
  named_event_arrayMaker.EraseIfNotIn(visited);
  parameterMaker.EraseIfNotIn(visited);
  def_paramMaker.EraseIfNotIn(visited);
  spec_paramMaker.EraseIfNotIn(visited);
  class_typespecMaker.EraseIfNotIn(visited);
  extendsMaker.EraseIfNotIn(visited);
  class_defnMaker.EraseIfNotIn(visited);
  class_objMaker.EraseIfNotIn(visited);
  class_varMaker.EraseIfNotIn(visited);
  interface_instMaker.EraseIfNotIn(visited);
  programMaker.EraseIfNotIn(visited);
  module_instMaker.EraseIfNotIn(visited);
  checker_declMaker.EraseIfNotIn(visited);
  checker_instMaker.EraseIfNotIn(visited);
  short_real_typespecMaker.EraseIfNotIn(visited);
  real_typespecMaker.EraseIfNotIn(visited);
  byte_typespecMaker.EraseIfNotIn(visited);
  short_int_typespecMaker.EraseIfNotIn(visited);
  int_typespecMaker.EraseIfNotIn(visited);
  long_int_typespecMaker.EraseIfNotIn(visited);
  integer_typespecMaker.EraseIfNotIn(visited);
  time_typespecMaker.EraseIfNotIn(visited);
  enum_typespecMaker.EraseIfNotIn(visited);
  string_typespecMaker.EraseIfNotIn(visited);
  chandle_typespecMaker.EraseIfNotIn(visited);
  module_typespecMaker.EraseIfNotIn(visited);
  struct_typespecMaker.EraseIfNotIn(visited);
  union_typespecMaker.EraseIfNotIn(visited);
  logic_typespecMaker.EraseIfNotIn(visited);
  packed_array_typespecMaker.EraseIfNotIn(visited);
  array_typespecMaker.EraseIfNotIn(visited);
  void_typespecMaker.EraseIfNotIn(visited);
  unsupported_typespecMaker.EraseIfNotIn(visited);
  sequence_typespecMaker.EraseIfNotIn(visited);
  property_typespecMaker.EraseIfNotIn(visited);
  interface_typespecMaker.EraseIfNotIn(visited);
  type_parameterMaker.EraseIfNotIn(visited);
  typespec_memberMaker.EraseIfNotIn(visited);
  enum_constMaker.EraseIfNotIn(visited);
  bit_typespecMaker.EraseIfNotIn(visited);
  user_systfMaker.EraseIfNotIn(visited);
  sys_func_callMaker.EraseIfNotIn(visited);
  sys_task_callMaker.EraseIfNotIn(visited);
  method_func_callMaker.EraseIfNotIn(visited);
  method_task_callMaker.EraseIfNotIn(visited);
  func_callMaker.EraseIfNotIn(visited);
  task_callMaker.EraseIfNotIn(visited);
  constraint_orderingMaker.EraseIfNotIn(visited);
  constraintMaker.EraseIfNotIn(visited);
  import_typespecMaker.EraseIfNotIn(visited);
  dist_itemMaker.EraseIfNotIn(visited);
  distributionMaker.EraseIfNotIn(visited);
  implicationMaker.EraseIfNotIn(visited);
  constr_ifMaker.EraseIfNotIn(visited);
  constr_if_elseMaker.EraseIfNotIn(visited);
  constr_foreachMaker.EraseIfNotIn(visited);
  soft_disableMaker.EraseIfNotIn(visited);
  gen_ifMaker.EraseIfNotIn(visited);
  gen_if_elseMaker.EraseIfNotIn(visited);
  gen_forMaker.EraseIfNotIn(visited);
  gen_caseMaker.EraseIfNotIn(visited);
  gen_regionMaker.EraseIfNotIn(visited);
  designMaker.EraseIfNotIn(visited);
}

void DefaultErrorHandler(ErrorType errType, const std::string& errorMsg, const any* object1, const any* object2) {
  std::cerr << errorMsg << std::endl;
}

SymbolId Serializer::MakeSymbol(std::string_view symbol) {
  return symbolMaker.Make(symbol);
}

std::string_view Serializer::GetSymbol(SymbolId id) const {
  return symbolMaker.GetSymbol(id);
}

SymbolId Serializer::GetSymbolId(std::string_view symbol) const {
  return symbolMaker.GetId(symbol);
}

vpiHandle Serializer::MakeUhdmHandle(UHDM_OBJECT_TYPE type, const void* object) {
  return uhdm_handleMaker.Make(type, object);
}

Serializer::IdMap Serializer::AllObjects() const {
  IdMap idMap;
  attributeMaker.MapToIndex(idMap);
  virtual_interface_varMaker.MapToIndex(idMap);
  let_declMaker.MapToIndex(idMap);
  alwaysMaker.MapToIndex(idMap);
  final_stmtMaker.MapToIndex(idMap);
  initialMaker.MapToIndex(idMap);
  delay_controlMaker.MapToIndex(idMap);
  delay_termMaker.MapToIndex(idMap);
  event_controlMaker.MapToIndex(idMap);
  repeat_controlMaker.MapToIndex(idMap);
  beginMaker.MapToIndex(idMap);
  named_beginMaker.MapToIndex(idMap);
  named_forkMaker.MapToIndex(idMap);
  fork_stmtMaker.MapToIndex(idMap);
  for_stmtMaker.MapToIndex(idMap);
  if_stmtMaker.MapToIndex(idMap);
  event_stmtMaker.MapToIndex(idMap);
  thread_objMaker.MapToIndex(idMap);
  forever_stmtMaker.MapToIndex(idMap);
  wait_stmtMaker.MapToIndex(idMap);
  wait_forkMaker.MapToIndex(idMap);
  ordered_waitMaker.MapToIndex(idMap);
  disableMaker.MapToIndex(idMap);
  disable_forkMaker.MapToIndex(idMap);
  continue_stmtMaker.MapToIndex(idMap);
  break_stmtMaker.MapToIndex(idMap);
  return_stmtMaker.MapToIndex(idMap);
  while_stmtMaker.MapToIndex(idMap);
  repeatMaker.MapToIndex(idMap);
  do_whileMaker.MapToIndex(idMap);
  if_elseMaker.MapToIndex(idMap);
  case_stmtMaker.MapToIndex(idMap);
  forceMaker.MapToIndex(idMap);
  assign_stmtMaker.MapToIndex(idMap);
  deassignMaker.MapToIndex(idMap);
  releaseMaker.MapToIndex(idMap);
  null_stmtMaker.MapToIndex(idMap);
  expect_stmtMaker.MapToIndex(idMap);
  foreach_stmtMaker.MapToIndex(idMap);
  gen_scopeMaker.MapToIndex(idMap);
  gen_varMaker.MapToIndex(idMap);
  gen_scope_arrayMaker.MapToIndex(idMap);
  assert_stmtMaker.MapToIndex(idMap);
  coverMaker.MapToIndex(idMap);
  assumeMaker.MapToIndex(idMap);
  restrictMaker.MapToIndex(idMap);
  immediate_assertMaker.MapToIndex(idMap);
  immediate_assumeMaker.MapToIndex(idMap);
  immediate_coverMaker.MapToIndex(idMap);
  case_itemMaker.MapToIndex(idMap);
  assignmentMaker.MapToIndex(idMap);
  any_patternMaker.MapToIndex(idMap);
  tagged_patternMaker.MapToIndex(idMap);
  struct_patternMaker.MapToIndex(idMap);
  unsupported_exprMaker.MapToIndex(idMap);
  unsupported_stmtMaker.MapToIndex(idMap);
  include_file_infoMaker.MapToIndex(idMap);
  sequence_instMaker.MapToIndex(idMap);
  seq_formal_declMaker.MapToIndex(idMap);
  sequence_declMaker.MapToIndex(idMap);
  prop_formal_declMaker.MapToIndex(idMap);
  property_instMaker.MapToIndex(idMap);
  property_specMaker.MapToIndex(idMap);
  property_declMaker.MapToIndex(idMap);
  clocked_propertyMaker.MapToIndex(idMap);
  case_property_itemMaker.MapToIndex(idMap);
  case_propertyMaker.MapToIndex(idMap);
  multiclock_sequence_exprMaker.MapToIndex(idMap);
  clocked_seqMaker.MapToIndex(idMap);
  constantMaker.MapToIndex(idMap);
  let_exprMaker.MapToIndex(idMap);
  operationMaker.MapToIndex(idMap);
  ref_objMaker.MapToIndex(idMap);
  ref_moduleMaker.MapToIndex(idMap);
  ref_typespecMaker.MapToIndex(idMap);
  part_selectMaker.MapToIndex(idMap);
  indexed_part_selectMaker.MapToIndex(idMap);
  var_selectMaker.MapToIndex(idMap);
  bit_selectMaker.MapToIndex(idMap);
  hier_pathMaker.MapToIndex(idMap);
  ref_varMaker.MapToIndex(idMap);
  short_real_varMaker.MapToIndex(idMap);
  real_varMaker.MapToIndex(idMap);
  byte_varMaker.MapToIndex(idMap);
  short_int_varMaker.MapToIndex(idMap);
  int_varMaker.MapToIndex(idMap);
  long_int_varMaker.MapToIndex(idMap);
  integer_varMaker.MapToIndex(idMap);
  time_varMaker.MapToIndex(idMap);
  array_varMaker.MapToIndex(idMap);
  array_exprMaker.MapToIndex(idMap);
  reg_arrayMaker.MapToIndex(idMap);
  regMaker.MapToIndex(idMap);
  packed_array_varMaker.MapToIndex(idMap);
  bit_varMaker.MapToIndex(idMap);
  logic_varMaker.MapToIndex(idMap);
  struct_varMaker.MapToIndex(idMap);
  union_varMaker.MapToIndex(idMap);
  enum_varMaker.MapToIndex(idMap);
  string_varMaker.MapToIndex(idMap);
  chandle_varMaker.MapToIndex(idMap);
  var_bitMaker.MapToIndex(idMap);
  taskMaker.MapToIndex(idMap);
  functionMaker.MapToIndex(idMap);
  modportMaker.MapToIndex(idMap);
  interface_tf_declMaker.MapToIndex(idMap);
  cont_assignMaker.MapToIndex(idMap);
  cont_assign_bitMaker.MapToIndex(idMap);
  portMaker.MapToIndex(idMap);
  port_bitMaker.MapToIndex(idMap);
  checker_portMaker.MapToIndex(idMap);
  checker_inst_portMaker.MapToIndex(idMap);
  gateMaker.MapToIndex(idMap);
  switch_tranMaker.MapToIndex(idMap);
  udpMaker.MapToIndex(idMap);
  mod_pathMaker.MapToIndex(idMap);
  tchkMaker.MapToIndex(idMap);
  rangeMaker.MapToIndex(idMap);
  udp_defnMaker.MapToIndex(idMap);
  table_entryMaker.MapToIndex(idMap);
  io_declMaker.MapToIndex(idMap);
  alias_stmtMaker.MapToIndex(idMap);
  clocking_blockMaker.MapToIndex(idMap);
  clocking_io_declMaker.MapToIndex(idMap);
  param_assignMaker.MapToIndex(idMap);
  interface_arrayMaker.MapToIndex(idMap);
  program_arrayMaker.MapToIndex(idMap);
  module_arrayMaker.MapToIndex(idMap);
  gate_arrayMaker.MapToIndex(idMap);
  switch_arrayMaker.MapToIndex(idMap);
  udp_arrayMaker.MapToIndex(idMap);
  prim_termMaker.MapToIndex(idMap);
  path_termMaker.MapToIndex(idMap);
  tchk_termMaker.MapToIndex(idMap);
  net_bitMaker.MapToIndex(idMap);
  struct_netMaker.MapToIndex(idMap);
  enum_netMaker.MapToIndex(idMap);
  integer_netMaker.MapToIndex(idMap);
  time_netMaker.MapToIndex(idMap);
  logic_netMaker.MapToIndex(idMap);
  array_netMaker.MapToIndex(idMap);
  packed_array_netMaker.MapToIndex(idMap);
  event_typespecMaker.MapToIndex(idMap);
  named_eventMaker.MapToIndex(idMap);
  named_event_arrayMaker.MapToIndex(idMap);
  parameterMaker.MapToIndex(idMap);
  def_paramMaker.MapToIndex(idMap);
  spec_paramMaker.MapToIndex(idMap);
  class_typespecMaker.MapToIndex(idMap);
  extendsMaker.MapToIndex(idMap);
  class_defnMaker.MapToIndex(idMap);
  class_objMaker.MapToIndex(idMap);
  class_varMaker.MapToIndex(idMap);
  interface_instMaker.MapToIndex(idMap);
  programMaker.MapToIndex(idMap);
  packageMaker.MapToIndex(idMap);
  module_instMaker.MapToIndex(idMap);
  checker_declMaker.MapToIndex(idMap);
  checker_instMaker.MapToIndex(idMap);
  short_real_typespecMaker.MapToIndex(idMap);
  real_typespecMaker.MapToIndex(idMap);
  byte_typespecMaker.MapToIndex(idMap);
  short_int_typespecMaker.MapToIndex(idMap);
  int_typespecMaker.MapToIndex(idMap);
  long_int_typespecMaker.MapToIndex(idMap);
  integer_typespecMaker.MapToIndex(idMap);
  time_typespecMaker.MapToIndex(idMap);
  enum_typespecMaker.MapToIndex(idMap);
  string_typespecMaker.MapToIndex(idMap);
  chandle_typespecMaker.MapToIndex(idMap);
  module_typespecMaker.MapToIndex(idMap);
  struct_typespecMaker.MapToIndex(idMap);
  union_typespecMaker.MapToIndex(idMap);
  logic_typespecMaker.MapToIndex(idMap);
  packed_array_typespecMaker.MapToIndex(idMap);
  array_typespecMaker.MapToIndex(idMap);
  void_typespecMaker.MapToIndex(idMap);
  unsupported_typespecMaker.MapToIndex(idMap);
  sequence_typespecMaker.MapToIndex(idMap);
  property_typespecMaker.MapToIndex(idMap);
  interface_typespecMaker.MapToIndex(idMap);
  type_parameterMaker.MapToIndex(idMap);
  typespec_memberMaker.MapToIndex(idMap);
  enum_constMaker.MapToIndex(idMap);
  bit_typespecMaker.MapToIndex(idMap);
  user_systfMaker.MapToIndex(idMap);
  sys_func_callMaker.MapToIndex(idMap);
  sys_task_callMaker.MapToIndex(idMap);
  method_func_callMaker.MapToIndex(idMap);
  method_task_callMaker.MapToIndex(idMap);
  func_callMaker.MapToIndex(idMap);
  task_callMaker.MapToIndex(idMap);
  constraint_orderingMaker.MapToIndex(idMap);
  constraintMaker.MapToIndex(idMap);
  import_typespecMaker.MapToIndex(idMap);
  dist_itemMaker.MapToIndex(idMap);
  distributionMaker.MapToIndex(idMap);
  implicationMaker.MapToIndex(idMap);
  constr_ifMaker.MapToIndex(idMap);
  constr_if_elseMaker.MapToIndex(idMap);
  constr_foreachMaker.MapToIndex(idMap);
  soft_disableMaker.MapToIndex(idMap);
  gen_ifMaker.MapToIndex(idMap);
  gen_if_elseMaker.MapToIndex(idMap);
  gen_forMaker.MapToIndex(idMap);
  gen_caseMaker.MapToIndex(idMap);
  gen_regionMaker.MapToIndex(idMap);
  designMaker.MapToIndex(idMap);
  return idMap;
}

std::string UhdmName(UHDM_OBJECT_TYPE type) {
  switch (type) {
    case UHDM_OBJECT_TYPE::uhdmactual /* = 2001 */: return "actual";
    case UHDM_OBJECT_TYPE::uhdmactual_group /* = 2002 */: return "actual_group";
    case UHDM_OBJECT_TYPE::uhdmactual_typespec /* = 2003 */: return "actual_typespec";
    case UHDM_OBJECT_TYPE::uhdmalias_stmt /* = 2004 */: return "alias_stmt";
    case UHDM_OBJECT_TYPE::uhdmalias_stmts /* = 2005 */: return "alias_stmts";
    case UHDM_OBJECT_TYPE::uhdmallClasses /* = 2006 */: return "allClasses";
    case UHDM_OBJECT_TYPE::uhdmallInterfaces /* = 2007 */: return "allInterfaces";
    case UHDM_OBJECT_TYPE::uhdmallModules /* = 2008 */: return "allModules";
    case UHDM_OBJECT_TYPE::uhdmallPackages /* = 2009 */: return "allPackages";
    case UHDM_OBJECT_TYPE::uhdmallPrograms /* = 2010 */: return "allPrograms";
    case UHDM_OBJECT_TYPE::uhdmallUdps /* = 2011 */: return "allUdps";
    case UHDM_OBJECT_TYPE::uhdmalways /* = 2012 */: return "always";
    case UHDM_OBJECT_TYPE::uhdmany_pattern /* = 2013 */: return "any_pattern";
    case UHDM_OBJECT_TYPE::uhdmarguments /* = 2014 */: return "arguments";
    case UHDM_OBJECT_TYPE::uhdmarray_expr /* = 2015 */: return "array_expr";
    case UHDM_OBJECT_TYPE::uhdmarray_net /* = 2016 */: return "array_net";
    case UHDM_OBJECT_TYPE::uhdmarray_nets /* = 2017 */: return "array_nets";
    case UHDM_OBJECT_TYPE::uhdmarray_typespec /* = 2018 */: return "array_typespec";
    case UHDM_OBJECT_TYPE::uhdmarray_var /* = 2019 */: return "array_var";
    case UHDM_OBJECT_TYPE::uhdmarray_var_mems /* = 2020 */: return "array_var_mems";
    case UHDM_OBJECT_TYPE::uhdmarray_vars /* = 2021 */: return "array_vars";
    case UHDM_OBJECT_TYPE::uhdmassert_stmt /* = 2022 */: return "assert_stmt";
    case UHDM_OBJECT_TYPE::uhdmassertion /* = 2023 */: return "assertion";
    case UHDM_OBJECT_TYPE::uhdmassertions /* = 2024 */: return "assertions";
    case UHDM_OBJECT_TYPE::uhdmassign_stmt /* = 2025 */: return "assign_stmt";
    case UHDM_OBJECT_TYPE::uhdmassignment /* = 2026 */: return "assignment";
    case UHDM_OBJECT_TYPE::uhdmassume /* = 2027 */: return "assume";
    case UHDM_OBJECT_TYPE::uhdmatomic_stmt /* = 2028 */: return "atomic_stmt";
    case UHDM_OBJECT_TYPE::uhdmattribute /* = 2029 */: return "attribute";
    case UHDM_OBJECT_TYPE::uhdmattributes /* = 2030 */: return "attributes";
    case UHDM_OBJECT_TYPE::uhdmbase_expr /* = 2031 */: return "base_expr";
    case UHDM_OBJECT_TYPE::uhdmbase_typespec /* = 2032 */: return "base_typespec";
    case UHDM_OBJECT_TYPE::uhdmbegin /* = 2033 */: return "begin";
    case UHDM_OBJECT_TYPE::uhdmbit_select /* = 2034 */: return "bit_select";
    case UHDM_OBJECT_TYPE::uhdmbit_typespec /* = 2035 */: return "bit_typespec";
    case UHDM_OBJECT_TYPE::uhdmbit_var /* = 2036 */: return "bit_var";
    case UHDM_OBJECT_TYPE::uhdmbits /* = 2037 */: return "bits";
    case UHDM_OBJECT_TYPE::uhdmbreak_stmt /* = 2038 */: return "break_stmt";
    case UHDM_OBJECT_TYPE::uhdmbyte_typespec /* = 2039 */: return "byte_typespec";
    case UHDM_OBJECT_TYPE::uhdmbyte_var /* = 2040 */: return "byte_var";
    case UHDM_OBJECT_TYPE::uhdmcase_item /* = 2041 */: return "case_item";
    case UHDM_OBJECT_TYPE::uhdmcase_items /* = 2042 */: return "case_items";
    case UHDM_OBJECT_TYPE::uhdmcase_property /* = 2043 */: return "case_property";
    case UHDM_OBJECT_TYPE::uhdmcase_property_item /* = 2044 */: return "case_property_item";
    case UHDM_OBJECT_TYPE::uhdmcase_property_items /* = 2045 */: return "case_property_items";
    case UHDM_OBJECT_TYPE::uhdmcase_stmt /* = 2046 */: return "case_stmt";
    case UHDM_OBJECT_TYPE::uhdmcast_to_expr /* = 2047 */: return "cast_to_expr";
    case UHDM_OBJECT_TYPE::uhdmchandle_typespec /* = 2048 */: return "chandle_typespec";
    case UHDM_OBJECT_TYPE::uhdmchandle_var /* = 2049 */: return "chandle_var";
    case UHDM_OBJECT_TYPE::uhdmchecker_decl /* = 2050 */: return "checker_decl";
    case UHDM_OBJECT_TYPE::uhdmchecker_inst /* = 2051 */: return "checker_inst";
    case UHDM_OBJECT_TYPE::uhdmchecker_inst_port /* = 2052 */: return "checker_inst_port";
    case UHDM_OBJECT_TYPE::uhdmchecker_port /* = 2053 */: return "checker_port";
    case UHDM_OBJECT_TYPE::uhdmclass_defn /* = 2054 */: return "class_defn";
    case UHDM_OBJECT_TYPE::uhdmclass_defns /* = 2055 */: return "class_defns";
    case UHDM_OBJECT_TYPE::uhdmclass_obj /* = 2056 */: return "class_obj";
    case UHDM_OBJECT_TYPE::uhdmclass_typespec /* = 2057 */: return "class_typespec";
    case UHDM_OBJECT_TYPE::uhdmclass_typespecs /* = 2058 */: return "class_typespecs";
    case UHDM_OBJECT_TYPE::uhdmclass_var /* = 2059 */: return "class_var";
    case UHDM_OBJECT_TYPE::uhdmclocked_property /* = 2060 */: return "clocked_property";
    case UHDM_OBJECT_TYPE::uhdmclocked_seq /* = 2061 */: return "clocked_seq";
    case UHDM_OBJECT_TYPE::uhdmclocked_seqs /* = 2062 */: return "clocked_seqs";
    case UHDM_OBJECT_TYPE::uhdmclocking_block /* = 2063 */: return "clocking_block";
    case UHDM_OBJECT_TYPE::uhdmclocking_blocks /* = 2064 */: return "clocking_blocks";
    case UHDM_OBJECT_TYPE::uhdmclocking_event /* = 2065 */: return "clocking_event";
    case UHDM_OBJECT_TYPE::uhdmclocking_io_decl /* = 2066 */: return "clocking_io_decl";
    case UHDM_OBJECT_TYPE::uhdmclocking_io_decls /* = 2067 */: return "clocking_io_decls";
    case UHDM_OBJECT_TYPE::uhdmconcurrent_assertions /* = 2068 */: return "concurrent_assertions";
    case UHDM_OBJECT_TYPE::uhdmcondition /* = 2069 */: return "condition";
    case UHDM_OBJECT_TYPE::uhdmconstant /* = 2070 */: return "constant";
    case UHDM_OBJECT_TYPE::uhdmconstr_foreach /* = 2071 */: return "constr_foreach";
    case UHDM_OBJECT_TYPE::uhdmconstr_if /* = 2072 */: return "constr_if";
    case UHDM_OBJECT_TYPE::uhdmconstr_if_else /* = 2073 */: return "constr_if_else";
    case UHDM_OBJECT_TYPE::uhdmconstraint /* = 2074 */: return "constraint";
    case UHDM_OBJECT_TYPE::uhdmconstraint_expr /* = 2075 */: return "constraint_expr";
    case UHDM_OBJECT_TYPE::uhdmconstraint_exprs /* = 2076 */: return "constraint_exprs";
    case UHDM_OBJECT_TYPE::uhdmconstraint_item_group /* = 2077 */: return "constraint_item_group";
    case UHDM_OBJECT_TYPE::uhdmconstraint_items /* = 2078 */: return "constraint_items";
    case UHDM_OBJECT_TYPE::uhdmconstraint_ordering /* = 2079 */: return "constraint_ordering";
    case UHDM_OBJECT_TYPE::uhdmconstraints /* = 2080 */: return "constraints";
    case UHDM_OBJECT_TYPE::uhdmcont_assign /* = 2081 */: return "cont_assign";
    case UHDM_OBJECT_TYPE::uhdmcont_assign_bit /* = 2082 */: return "cont_assign_bit";
    case UHDM_OBJECT_TYPE::uhdmcont_assign_bits /* = 2083 */: return "cont_assign_bits";
    case UHDM_OBJECT_TYPE::uhdmcont_assigns /* = 2084 */: return "cont_assigns";
    case UHDM_OBJECT_TYPE::uhdmcontinue_stmt /* = 2085 */: return "continue_stmt";
    case UHDM_OBJECT_TYPE::uhdmcover /* = 2086 */: return "cover";
    case UHDM_OBJECT_TYPE::uhdmdeassign /* = 2087 */: return "deassign";
    case UHDM_OBJECT_TYPE::uhdmdef_param /* = 2088 */: return "def_param";
    case UHDM_OBJECT_TYPE::uhdmdef_params /* = 2089 */: return "def_params";
    case UHDM_OBJECT_TYPE::uhdmdefault_clocking /* = 2090 */: return "default_clocking";
    case UHDM_OBJECT_TYPE::uhdmdefault_value /* = 2091 */: return "default_value";
    case UHDM_OBJECT_TYPE::uhdmdelay /* = 2092 */: return "delay";
    case UHDM_OBJECT_TYPE::uhdmdelay_control /* = 2093 */: return "delay_control";
    case UHDM_OBJECT_TYPE::uhdmdelay_term /* = 2094 */: return "delay_term";
    case UHDM_OBJECT_TYPE::uhdmderiveds /* = 2095 */: return "deriveds";
    case UHDM_OBJECT_TYPE::uhdmdesign /* = 2096 */: return "design";
    case UHDM_OBJECT_TYPE::uhdmdisable /* = 2097 */: return "disable";
    case UHDM_OBJECT_TYPE::uhdmdisable_fork /* = 2098 */: return "disable_fork";
    case UHDM_OBJECT_TYPE::uhdmdisables /* = 2099 */: return "disables";
    case UHDM_OBJECT_TYPE::uhdmdist_item /* = 2100 */: return "dist_item";
    case UHDM_OBJECT_TYPE::uhdmdist_items /* = 2101 */: return "dist_items";
    case UHDM_OBJECT_TYPE::uhdmdistribution /* = 2102 */: return "distribution";
    case UHDM_OBJECT_TYPE::uhdmdo_while /* = 2103 */: return "do_while";
    case UHDM_OBJECT_TYPE::uhdmdrivers /* = 2104 */: return "drivers";
    case UHDM_OBJECT_TYPE::uhdmelab_tasks /* = 2105 */: return "elab_tasks";
    case UHDM_OBJECT_TYPE::uhdmelem_typespec /* = 2106 */: return "elem_typespec";
    case UHDM_OBJECT_TYPE::uhdmelements /* = 2107 */: return "elements";
    case UHDM_OBJECT_TYPE::uhdmelse_constraint_exprs /* = 2108 */: return "else_constraint_exprs";
    case UHDM_OBJECT_TYPE::uhdmelse_stmt /* = 2109 */: return "else_stmt";
    case UHDM_OBJECT_TYPE::uhdmenum_const /* = 2110 */: return "enum_const";
    case UHDM_OBJECT_TYPE::uhdmenum_consts /* = 2111 */: return "enum_consts";
    case UHDM_OBJECT_TYPE::uhdmenum_net /* = 2112 */: return "enum_net";
    case UHDM_OBJECT_TYPE::uhdmenum_struct_packed_net_group /* = 2113 */: return "enum_struct_packed_net_group";
    case UHDM_OBJECT_TYPE::uhdmenum_struct_union_packed_array_typespec_group /* = 2114 */: return "enum_struct_union_packed_array_typespec_group";
    case UHDM_OBJECT_TYPE::uhdmenum_struct_union_packed_var_group /* = 2115 */: return "enum_struct_union_packed_var_group";
    case UHDM_OBJECT_TYPE::uhdmenum_typespec /* = 2116 */: return "enum_typespec";
    case UHDM_OBJECT_TYPE::uhdmenum_var /* = 2117 */: return "enum_var";
    case UHDM_OBJECT_TYPE::uhdmevent_control /* = 2118 */: return "event_control";
    case UHDM_OBJECT_TYPE::uhdmevent_stmt /* = 2119 */: return "event_stmt";
    case UHDM_OBJECT_TYPE::uhdmevent_typespec /* = 2120 */: return "event_typespec";
    case UHDM_OBJECT_TYPE::uhdmexpect_stmt /* = 2121 */: return "expect_stmt";
    case UHDM_OBJECT_TYPE::uhdmexpr /* = 2122 */: return "expr";
    case UHDM_OBJECT_TYPE::uhdmexpr_constr_group /* = 2123 */: return "expr_constr_group";
    case UHDM_OBJECT_TYPE::uhdmexpr_dist /* = 2124 */: return "expr_dist";
    case UHDM_OBJECT_TYPE::uhdmexpr_index /* = 2125 */: return "expr_index";
    case UHDM_OBJECT_TYPE::uhdmexpr_indexes /* = 2126 */: return "expr_indexes";
    case UHDM_OBJECT_TYPE::uhdmexpr_interf_expr_group /* = 2127 */: return "expr_interf_expr_group";
    case UHDM_OBJECT_TYPE::uhdmexpr_range_group /* = 2128 */: return "expr_range_group";
    case UHDM_OBJECT_TYPE::uhdmexpr_ref_obj_group /* = 2129 */: return "expr_ref_obj_group";
    case UHDM_OBJECT_TYPE::uhdmexpr_sequence_inst_group /* = 2130 */: return "expr_sequence_inst_group";
    case UHDM_OBJECT_TYPE::uhdmexpr_sequence_inst_named_event_group /* = 2131 */: return "expr_sequence_inst_named_event_group";
    case UHDM_OBJECT_TYPE::uhdmexpr_tchk_term_group /* = 2132 */: return "expr_tchk_term_group";
    case UHDM_OBJECT_TYPE::uhdmexpr_tchk_terms /* = 2133 */: return "expr_tchk_terms";
    case UHDM_OBJECT_TYPE::uhdmexpr_typespec_group /* = 2134 */: return "expr_typespec_group";
    case UHDM_OBJECT_TYPE::uhdmexpressions /* = 2135 */: return "expressions";
    case UHDM_OBJECT_TYPE::uhdmexprs /* = 2136 */: return "exprs";
    case UHDM_OBJECT_TYPE::uhdmextends /* = 2137 */: return "extends";
    case UHDM_OBJECT_TYPE::uhdmfinal_stmt /* = 2138 */: return "final_stmt";
    case UHDM_OBJECT_TYPE::uhdmfor_stmt /* = 2139 */: return "for_stmt";
    case UHDM_OBJECT_TYPE::uhdmforce /* = 2140 */: return "force";
    case UHDM_OBJECT_TYPE::uhdmforeach_stmt /* = 2141 */: return "foreach_stmt";
    case UHDM_OBJECT_TYPE::uhdmforever_stmt /* = 2142 */: return "forever_stmt";
    case UHDM_OBJECT_TYPE::uhdmfork_stmt /* = 2143 */: return "fork_stmt";
    case UHDM_OBJECT_TYPE::uhdmfunc_call /* = 2144 */: return "func_call";
    case UHDM_OBJECT_TYPE::uhdmfunction /* = 2145 */: return "function";
    case UHDM_OBJECT_TYPE::uhdmfunctions /* = 2146 */: return "functions";
    case UHDM_OBJECT_TYPE::uhdmgate /* = 2147 */: return "gate";
    case UHDM_OBJECT_TYPE::uhdmgate_array /* = 2148 */: return "gate_array";
    case UHDM_OBJECT_TYPE::uhdmgen_case /* = 2149 */: return "gen_case";
    case UHDM_OBJECT_TYPE::uhdmgen_for /* = 2150 */: return "gen_for";
    case UHDM_OBJECT_TYPE::uhdmgen_if /* = 2151 */: return "gen_if";
    case UHDM_OBJECT_TYPE::uhdmgen_if_else /* = 2152 */: return "gen_if_else";
    case UHDM_OBJECT_TYPE::uhdmgen_region /* = 2153 */: return "gen_region";
    case UHDM_OBJECT_TYPE::uhdmgen_scope /* = 2154 */: return "gen_scope";
    case UHDM_OBJECT_TYPE::uhdmgen_scope_array /* = 2155 */: return "gen_scope_array";
    case UHDM_OBJECT_TYPE::uhdmgen_scope_arrays /* = 2156 */: return "gen_scope_arrays";
    case UHDM_OBJECT_TYPE::uhdmgen_scopes /* = 2157 */: return "gen_scopes";
    case UHDM_OBJECT_TYPE::uhdmgen_stmt /* = 2158 */: return "gen_stmt";
    case UHDM_OBJECT_TYPE::uhdmgen_stmts /* = 2159 */: return "gen_stmts";
    case UHDM_OBJECT_TYPE::uhdmgen_var /* = 2160 */: return "gen_var";
    case UHDM_OBJECT_TYPE::uhdmglobal_clocking /* = 2161 */: return "global_clocking";
    case UHDM_OBJECT_TYPE::uhdmhier_path /* = 2162 */: return "hier_path";
    case UHDM_OBJECT_TYPE::uhdmhigh_conn /* = 2163 */: return "high_conn";
    case UHDM_OBJECT_TYPE::uhdmif_else /* = 2164 */: return "if_else";
    case UHDM_OBJECT_TYPE::uhdmif_stmt /* = 2165 */: return "if_stmt";
    case UHDM_OBJECT_TYPE::uhdmimmediate_assert /* = 2166 */: return "immediate_assert";
    case UHDM_OBJECT_TYPE::uhdmimmediate_assume /* = 2167 */: return "immediate_assume";
    case UHDM_OBJECT_TYPE::uhdmimmediate_cover /* = 2168 */: return "immediate_cover";
    case UHDM_OBJECT_TYPE::uhdmimplication /* = 2169 */: return "implication";
    case UHDM_OBJECT_TYPE::uhdmimport_typespec /* = 2170 */: return "import_typespec";
    case UHDM_OBJECT_TYPE::uhdminclude_file_info /* = 2171 */: return "include_file_info";
    case UHDM_OBJECT_TYPE::uhdminclude_file_infos /* = 2172 */: return "include_file_infos";
    case UHDM_OBJECT_TYPE::uhdmindex /* = 2173 */: return "index";
    case UHDM_OBJECT_TYPE::uhdmindex_typespec /* = 2174 */: return "index_typespec";
    case UHDM_OBJECT_TYPE::uhdmindexed_part_select /* = 2175 */: return "indexed_part_select";
    case UHDM_OBJECT_TYPE::uhdmindexes /* = 2176 */: return "indexes";
    case UHDM_OBJECT_TYPE::uhdminitial /* = 2177 */: return "initial";
    case UHDM_OBJECT_TYPE::uhdminput_skew /* = 2178 */: return "input_skew";
    case UHDM_OBJECT_TYPE::uhdminstance /* = 2179 */: return "instance";
    case UHDM_OBJECT_TYPE::uhdminstance_array /* = 2180 */: return "instance_array";
    case UHDM_OBJECT_TYPE::uhdminstance_item /* = 2181 */: return "instance_item";
    case UHDM_OBJECT_TYPE::uhdminstance_items /* = 2182 */: return "instance_items";
    case UHDM_OBJECT_TYPE::uhdminstances /* = 2183 */: return "instances";
    case UHDM_OBJECT_TYPE::uhdmint_typespec /* = 2184 */: return "int_typespec";
    case UHDM_OBJECT_TYPE::uhdmint_var /* = 2185 */: return "int_var";
    case UHDM_OBJECT_TYPE::uhdminteger_net /* = 2186 */: return "integer_net";
    case UHDM_OBJECT_TYPE::uhdminteger_typespec /* = 2187 */: return "integer_typespec";
    case UHDM_OBJECT_TYPE::uhdminteger_var /* = 2188 */: return "integer_var";
    case UHDM_OBJECT_TYPE::uhdminterf_prog_mod_group /* = 2189 */: return "interf_prog_mod_group";
    case UHDM_OBJECT_TYPE::uhdminterface_array /* = 2190 */: return "interface_array";
    case UHDM_OBJECT_TYPE::uhdminterface_arrays /* = 2191 */: return "interface_arrays";
    case UHDM_OBJECT_TYPE::uhdminterface_expr /* = 2192 */: return "interface_expr";
    case UHDM_OBJECT_TYPE::uhdminterface_inst /* = 2193 */: return "interface_inst";
    case UHDM_OBJECT_TYPE::uhdminterface_tf_decl /* = 2194 */: return "interface_tf_decl";
    case UHDM_OBJECT_TYPE::uhdminterface_tf_decls /* = 2195 */: return "interface_tf_decls";
    case UHDM_OBJECT_TYPE::uhdminterface_typespec /* = 2196 */: return "interface_typespec";
    case UHDM_OBJECT_TYPE::uhdminterfaces /* = 2197 */: return "interfaces";
    case UHDM_OBJECT_TYPE::uhdmio_decl /* = 2198 */: return "io_decl";
    case UHDM_OBJECT_TYPE::uhdmio_decls /* = 2199 */: return "io_decls";
    case UHDM_OBJECT_TYPE::uhdmitem /* = 2200 */: return "item";
    case UHDM_OBJECT_TYPE::uhdmleft_expr /* = 2201 */: return "left_expr";
    case UHDM_OBJECT_TYPE::uhdmleft_range /* = 2202 */: return "left_range";
    case UHDM_OBJECT_TYPE::uhdmlet_decl /* = 2203 */: return "let_decl";
    case UHDM_OBJECT_TYPE::uhdmlet_decls /* = 2204 */: return "let_decls";
    case UHDM_OBJECT_TYPE::uhdmlet_expr /* = 2205 */: return "let_expr";
    case UHDM_OBJECT_TYPE::uhdmlhs /* = 2206 */: return "lhs";
    case UHDM_OBJECT_TYPE::uhdmloads /* = 2207 */: return "loads";
    case UHDM_OBJECT_TYPE::uhdmlocal_drivers /* = 2208 */: return "local_drivers";
    case UHDM_OBJECT_TYPE::uhdmlocal_loads /* = 2209 */: return "local_loads";
    case UHDM_OBJECT_TYPE::uhdmlogic_net /* = 2210 */: return "logic_net";
    case UHDM_OBJECT_TYPE::uhdmlogic_typespec /* = 2211 */: return "logic_typespec";
    case UHDM_OBJECT_TYPE::uhdmlogic_var /* = 2212 */: return "logic_var";
    case UHDM_OBJECT_TYPE::uhdmlogic_vars /* = 2213 */: return "logic_vars";
    case UHDM_OBJECT_TYPE::uhdmlong_int_typespec /* = 2214 */: return "long_int_typespec";
    case UHDM_OBJECT_TYPE::uhdmlong_int_var /* = 2215 */: return "long_int_var";
    case UHDM_OBJECT_TYPE::uhdmlow_conn /* = 2216 */: return "low_conn";
    case UHDM_OBJECT_TYPE::uhdmmembers /* = 2217 */: return "members";
    case UHDM_OBJECT_TYPE::uhdmmessages /* = 2218 */: return "messages";
    case UHDM_OBJECT_TYPE::uhdmmethod_func_call /* = 2219 */: return "method_func_call";
    case UHDM_OBJECT_TYPE::uhdmmethod_func_task_call_group /* = 2220 */: return "method_func_task_call_group";
    case UHDM_OBJECT_TYPE::uhdmmethod_task_call /* = 2221 */: return "method_task_call";
    case UHDM_OBJECT_TYPE::uhdmmod_path /* = 2222 */: return "mod_path";
    case UHDM_OBJECT_TYPE::uhdmmod_paths /* = 2223 */: return "mod_paths";
    case UHDM_OBJECT_TYPE::uhdmmodport /* = 2224 */: return "modport";
    case UHDM_OBJECT_TYPE::uhdmmodports /* = 2225 */: return "modports";
    case UHDM_OBJECT_TYPE::uhdmmodule_array /* = 2226 */: return "module_array";
    case UHDM_OBJECT_TYPE::uhdmmodule_arrays /* = 2227 */: return "module_arrays";
    case UHDM_OBJECT_TYPE::uhdmmodule_inst /* = 2228 */: return "module_inst";
    case UHDM_OBJECT_TYPE::uhdmmodule_typespec /* = 2229 */: return "module_typespec";
    case UHDM_OBJECT_TYPE::uhdmmodules /* = 2230 */: return "modules";
    case UHDM_OBJECT_TYPE::uhdmmulticlock_sequence_expr /* = 2231 */: return "multiclock_sequence_expr";
    case UHDM_OBJECT_TYPE::uhdmnamed_begin /* = 2232 */: return "named_begin";
    case UHDM_OBJECT_TYPE::uhdmnamed_event /* = 2233 */: return "named_event";
    case UHDM_OBJECT_TYPE::uhdmnamed_event_array /* = 2234 */: return "named_event_array";
    case UHDM_OBJECT_TYPE::uhdmnamed_event_arrays /* = 2235 */: return "named_event_arrays";
    case UHDM_OBJECT_TYPE::uhdmnamed_event_sequence_expr_group /* = 2236 */: return "named_event_sequence_expr_group";
    case UHDM_OBJECT_TYPE::uhdmnamed_event_sequence_expr_groups /* = 2237 */: return "named_event_sequence_expr_groups";
    case UHDM_OBJECT_TYPE::uhdmnamed_events /* = 2238 */: return "named_events";
    case UHDM_OBJECT_TYPE::uhdmnamed_fork /* = 2239 */: return "named_fork";
    case UHDM_OBJECT_TYPE::uhdmnet /* = 2240 */: return "net";
    case UHDM_OBJECT_TYPE::uhdmnet_bit /* = 2241 */: return "net_bit";
    case UHDM_OBJECT_TYPE::uhdmnet_bits /* = 2242 */: return "net_bits";
    case UHDM_OBJECT_TYPE::uhdmnet_drivers /* = 2243 */: return "net_drivers";
    case UHDM_OBJECT_TYPE::uhdmnet_loads /* = 2244 */: return "net_loads";
    case UHDM_OBJECT_TYPE::uhdmnets /* = 2245 */: return "nets";
    case UHDM_OBJECT_TYPE::uhdmnets_vars_ref_obj_group /* = 2246 */: return "nets_vars_ref_obj_group";
    case UHDM_OBJECT_TYPE::uhdmnull_stmt /* = 2247 */: return "null_stmt";
    case UHDM_OBJECT_TYPE::uhdmoperand_group /* = 2248 */: return "operand_group";
    case UHDM_OBJECT_TYPE::uhdmoperands /* = 2249 */: return "operands";
    case UHDM_OBJECT_TYPE::uhdmoperation /* = 2250 */: return "operation";
    case UHDM_OBJECT_TYPE::uhdmordered_wait /* = 2251 */: return "ordered_wait";
    case UHDM_OBJECT_TYPE::uhdmoutput_skew /* = 2252 */: return "output_skew";
    case UHDM_OBJECT_TYPE::uhdmpackage /* = 2253 */: return "package";
    case UHDM_OBJECT_TYPE::uhdmpacked_array_net /* = 2254 */: return "packed_array_net";
    case UHDM_OBJECT_TYPE::uhdmpacked_array_typespec /* = 2255 */: return "packed_array_typespec";
    case UHDM_OBJECT_TYPE::uhdmpacked_array_var /* = 2256 */: return "packed_array_var";
    case UHDM_OBJECT_TYPE::uhdmparam_assign /* = 2257 */: return "param_assign";
    case UHDM_OBJECT_TYPE::uhdmparam_assigns /* = 2258 */: return "param_assigns";
    case UHDM_OBJECT_TYPE::uhdmparameter /* = 2259 */: return "parameter";
    case UHDM_OBJECT_TYPE::uhdmparameters /* = 2260 */: return "parameters";
    case UHDM_OBJECT_TYPE::uhdmpart_select /* = 2261 */: return "part_select";
    case UHDM_OBJECT_TYPE::uhdmpath_elems /* = 2262 */: return "path_elems";
    case UHDM_OBJECT_TYPE::uhdmpath_term /* = 2263 */: return "path_term";
    case UHDM_OBJECT_TYPE::uhdmpath_terms /* = 2264 */: return "path_terms";
    case UHDM_OBJECT_TYPE::uhdmpattern /* = 2265 */: return "pattern";
    case UHDM_OBJECT_TYPE::uhdmpattern_expr_group /* = 2266 */: return "pattern_expr_group";
    case UHDM_OBJECT_TYPE::uhdmport /* = 2267 */: return "port";
    case UHDM_OBJECT_TYPE::uhdmport_bit /* = 2268 */: return "port_bit";
    case UHDM_OBJECT_TYPE::uhdmports /* = 2269 */: return "ports";
    case UHDM_OBJECT_TYPE::uhdmprefix /* = 2270 */: return "prefix";
    case UHDM_OBJECT_TYPE::uhdmprim_term /* = 2271 */: return "prim_term";
    case UHDM_OBJECT_TYPE::uhdmprim_terms /* = 2272 */: return "prim_terms";
    case UHDM_OBJECT_TYPE::uhdmprimitive /* = 2273 */: return "primitive";
    case UHDM_OBJECT_TYPE::uhdmprimitive_array /* = 2274 */: return "primitive_array";
    case UHDM_OBJECT_TYPE::uhdmprimitive_arrays /* = 2275 */: return "primitive_arrays";
    case UHDM_OBJECT_TYPE::uhdmprimitives /* = 2276 */: return "primitives";
    case UHDM_OBJECT_TYPE::uhdmprocess /* = 2277 */: return "process";
    case UHDM_OBJECT_TYPE::uhdmprocess_stmt /* = 2278 */: return "process_stmt";
    case UHDM_OBJECT_TYPE::uhdmprogram /* = 2279 */: return "program";
    case UHDM_OBJECT_TYPE::uhdmprogram_array /* = 2280 */: return "program_array";
    case UHDM_OBJECT_TYPE::uhdmprogram_arrays /* = 2281 */: return "program_arrays";
    case UHDM_OBJECT_TYPE::uhdmprograms /* = 2282 */: return "programs";
    case UHDM_OBJECT_TYPE::uhdmprop_formal_decl /* = 2283 */: return "prop_formal_decl";
    case UHDM_OBJECT_TYPE::uhdmprop_formal_decls /* = 2284 */: return "prop_formal_decls";
    case UHDM_OBJECT_TYPE::uhdmproperty /* = 2285 */: return "property";
    case UHDM_OBJECT_TYPE::uhdmproperty_decl /* = 2286 */: return "property_decl";
    case UHDM_OBJECT_TYPE::uhdmproperty_decls /* = 2287 */: return "property_decls";
    case UHDM_OBJECT_TYPE::uhdmproperty_expr /* = 2288 */: return "property_expr";
    case UHDM_OBJECT_TYPE::uhdmproperty_expr_group /* = 2289 */: return "property_expr_group";
    case UHDM_OBJECT_TYPE::uhdmproperty_expr_named_event_group /* = 2290 */: return "property_expr_named_event_group";
    case UHDM_OBJECT_TYPE::uhdmproperty_inst /* = 2291 */: return "property_inst";
    case UHDM_OBJECT_TYPE::uhdmproperty_inst_spec_group /* = 2292 */: return "property_inst_spec_group";
    case UHDM_OBJECT_TYPE::uhdmproperty_spec /* = 2293 */: return "property_spec";
    case UHDM_OBJECT_TYPE::uhdmproperty_typespec /* = 2294 */: return "property_typespec";
    case UHDM_OBJECT_TYPE::uhdmrange /* = 2295 */: return "range";
    case UHDM_OBJECT_TYPE::uhdmranges /* = 2296 */: return "ranges";
    case UHDM_OBJECT_TYPE::uhdmreal_typespec /* = 2297 */: return "real_typespec";
    case UHDM_OBJECT_TYPE::uhdmreal_var /* = 2298 */: return "real_var";
    case UHDM_OBJECT_TYPE::uhdmref_module /* = 2299 */: return "ref_module";
    case UHDM_OBJECT_TYPE::uhdmref_modules /* = 2300 */: return "ref_modules";
    case UHDM_OBJECT_TYPE::uhdmref_obj /* = 2301 */: return "ref_obj";
    case UHDM_OBJECT_TYPE::uhdmref_obj_interf_net_var_group /* = 2302 */: return "ref_obj_interf_net_var_group";
    case UHDM_OBJECT_TYPE::uhdmref_typespec /* = 2303 */: return "ref_typespec";
    case UHDM_OBJECT_TYPE::uhdmref_var /* = 2304 */: return "ref_var";
    case UHDM_OBJECT_TYPE::uhdmreg /* = 2305 */: return "reg";
    case UHDM_OBJECT_TYPE::uhdmreg_array /* = 2306 */: return "reg_array";
    case UHDM_OBJECT_TYPE::uhdmregs /* = 2307 */: return "regs";
    case UHDM_OBJECT_TYPE::uhdmrelease /* = 2308 */: return "release";
    case UHDM_OBJECT_TYPE::uhdmrepeat /* = 2309 */: return "repeat";
    case UHDM_OBJECT_TYPE::uhdmrepeat_control /* = 2310 */: return "repeat_control";
    case UHDM_OBJECT_TYPE::uhdmresolution_func /* = 2311 */: return "resolution_func";
    case UHDM_OBJECT_TYPE::uhdmrestrict /* = 2312 */: return "restrict";
    case UHDM_OBJECT_TYPE::uhdmreturn /* = 2313 */: return "return";
    case UHDM_OBJECT_TYPE::uhdmreturn_stmt /* = 2314 */: return "return_stmt";
    case UHDM_OBJECT_TYPE::uhdmrhs /* = 2315 */: return "rhs";
    case UHDM_OBJECT_TYPE::uhdmright_expr /* = 2316 */: return "right_expr";
    case UHDM_OBJECT_TYPE::uhdmright_range /* = 2317 */: return "right_range";
    case UHDM_OBJECT_TYPE::uhdmroot_value /* = 2318 */: return "root_value";
    case UHDM_OBJECT_TYPE::uhdmscope /* = 2319 */: return "scope";
    case UHDM_OBJECT_TYPE::uhdmscopes /* = 2320 */: return "scopes";
    case UHDM_OBJECT_TYPE::uhdmseq_formal_decl /* = 2321 */: return "seq_formal_decl";
    case UHDM_OBJECT_TYPE::uhdmseq_formal_decls /* = 2322 */: return "seq_formal_decls";
    case UHDM_OBJECT_TYPE::uhdmsequence /* = 2323 */: return "sequence";
    case UHDM_OBJECT_TYPE::uhdmsequence_decl /* = 2324 */: return "sequence_decl";
    case UHDM_OBJECT_TYPE::uhdmsequence_decls /* = 2325 */: return "sequence_decls";
    case UHDM_OBJECT_TYPE::uhdmsequence_expr_group /* = 2326 */: return "sequence_expr_group";
    case UHDM_OBJECT_TYPE::uhdmsequence_expr_multiclock_group /* = 2327 */: return "sequence_expr_multiclock_group";
    case UHDM_OBJECT_TYPE::uhdmsequence_inst /* = 2328 */: return "sequence_inst";
    case UHDM_OBJECT_TYPE::uhdmsequence_typespec /* = 2329 */: return "sequence_typespec";
    case UHDM_OBJECT_TYPE::uhdmshort_int_typespec /* = 2330 */: return "short_int_typespec";
    case UHDM_OBJECT_TYPE::uhdmshort_int_var /* = 2331 */: return "short_int_var";
    case UHDM_OBJECT_TYPE::uhdmshort_real_typespec /* = 2332 */: return "short_real_typespec";
    case UHDM_OBJECT_TYPE::uhdmshort_real_var /* = 2333 */: return "short_real_var";
    case UHDM_OBJECT_TYPE::uhdmsim_net /* = 2334 */: return "sim_net";
    case UHDM_OBJECT_TYPE::uhdmsimple_expr /* = 2335 */: return "simple_expr";
    case UHDM_OBJECT_TYPE::uhdmsimple_expr_use_group /* = 2336 */: return "simple_expr_use_group";
    case UHDM_OBJECT_TYPE::uhdmsoft_disable /* = 2337 */: return "soft_disable";
    case UHDM_OBJECT_TYPE::uhdmsolve_afters /* = 2338 */: return "solve_afters";
    case UHDM_OBJECT_TYPE::uhdmsolve_befores /* = 2339 */: return "solve_befores";
    case UHDM_OBJECT_TYPE::uhdmspec_param /* = 2340 */: return "spec_param";
    case UHDM_OBJECT_TYPE::uhdmspec_params /* = 2341 */: return "spec_params";
    case UHDM_OBJECT_TYPE::uhdmstmt /* = 2342 */: return "stmt";
    case UHDM_OBJECT_TYPE::uhdmstmts /* = 2343 */: return "stmts";
    case UHDM_OBJECT_TYPE::uhdmstring_typespec /* = 2344 */: return "string_typespec";
    case UHDM_OBJECT_TYPE::uhdmstring_var /* = 2345 */: return "string_var";
    case UHDM_OBJECT_TYPE::uhdmstruct_net /* = 2346 */: return "struct_net";
    case UHDM_OBJECT_TYPE::uhdmstruct_pattern /* = 2347 */: return "struct_pattern";
    case UHDM_OBJECT_TYPE::uhdmstruct_typespec /* = 2348 */: return "struct_typespec";
    case UHDM_OBJECT_TYPE::uhdmstruct_var /* = 2349 */: return "struct_var";
    case UHDM_OBJECT_TYPE::uhdmswitch_array /* = 2350 */: return "switch_array";
    case UHDM_OBJECT_TYPE::uhdmswitch_tran /* = 2351 */: return "switch_tran";
    case UHDM_OBJECT_TYPE::uhdmsys_func_call /* = 2352 */: return "sys_func_call";
    case UHDM_OBJECT_TYPE::uhdmsys_func_task_call_group /* = 2353 */: return "sys_func_task_call_group";
    case UHDM_OBJECT_TYPE::uhdmsys_task_call /* = 2354 */: return "sys_task_call";
    case UHDM_OBJECT_TYPE::uhdmtable_entry /* = 2355 */: return "table_entry";
    case UHDM_OBJECT_TYPE::uhdmtable_entrys /* = 2356 */: return "table_entrys";
    case UHDM_OBJECT_TYPE::uhdmtagged_pattern /* = 2357 */: return "tagged_pattern";
    case UHDM_OBJECT_TYPE::uhdmtask /* = 2358 */: return "task";
    case UHDM_OBJECT_TYPE::uhdmtask_call /* = 2359 */: return "task_call";
    case UHDM_OBJECT_TYPE::uhdmtask_func /* = 2360 */: return "task_func";
    case UHDM_OBJECT_TYPE::uhdmtask_func_named_begin_fork_group /* = 2361 */: return "task_func_named_begin_fork_group";
    case UHDM_OBJECT_TYPE::uhdmtask_funcs /* = 2362 */: return "task_funcs";
    case UHDM_OBJECT_TYPE::uhdmtasks /* = 2363 */: return "tasks";
    case UHDM_OBJECT_TYPE::uhdmtchk /* = 2364 */: return "tchk";
    case UHDM_OBJECT_TYPE::uhdmtchk_data_term /* = 2365 */: return "tchk_data_term";
    case UHDM_OBJECT_TYPE::uhdmtchk_ref_term /* = 2366 */: return "tchk_ref_term";
    case UHDM_OBJECT_TYPE::uhdmtchk_term /* = 2367 */: return "tchk_term";
    case UHDM_OBJECT_TYPE::uhdmtchk_terms /* = 2368 */: return "tchk_terms";
    case UHDM_OBJECT_TYPE::uhdmtchks /* = 2369 */: return "tchks";
    case UHDM_OBJECT_TYPE::uhdmtf_call /* = 2370 */: return "tf_call";
    case UHDM_OBJECT_TYPE::uhdmtf_call_args /* = 2371 */: return "tf_call_args";
    case UHDM_OBJECT_TYPE::uhdmthread_obj /* = 2372 */: return "thread_obj";
    case UHDM_OBJECT_TYPE::uhdmthreads /* = 2373 */: return "threads";
    case UHDM_OBJECT_TYPE::uhdmtime_net /* = 2374 */: return "time_net";
    case UHDM_OBJECT_TYPE::uhdmtime_typespec /* = 2375 */: return "time_typespec";
    case UHDM_OBJECT_TYPE::uhdmtime_var /* = 2376 */: return "time_var";
    case UHDM_OBJECT_TYPE::uhdmtopModules /* = 2377 */: return "topModules";
    case UHDM_OBJECT_TYPE::uhdmtopPackages /* = 2378 */: return "topPackages";
    case UHDM_OBJECT_TYPE::uhdmtype_parameter /* = 2379 */: return "type_parameter";
    case UHDM_OBJECT_TYPE::uhdmtypedef_alias /* = 2380 */: return "typedef_alias";
    case UHDM_OBJECT_TYPE::uhdmtypespec /* = 2381 */: return "typespec";
    case UHDM_OBJECT_TYPE::uhdmtypespec_member /* = 2382 */: return "typespec_member";
    case UHDM_OBJECT_TYPE::uhdmtypespecs /* = 2383 */: return "typespecs";
    case UHDM_OBJECT_TYPE::uhdmudp /* = 2384 */: return "udp";
    case UHDM_OBJECT_TYPE::uhdmudp_array /* = 2385 */: return "udp_array";
    case UHDM_OBJECT_TYPE::uhdmudp_defn /* = 2386 */: return "udp_defn";
    case UHDM_OBJECT_TYPE::uhdmunion_typespec /* = 2387 */: return "union_typespec";
    case UHDM_OBJECT_TYPE::uhdmunion_var /* = 2388 */: return "union_var";
    case UHDM_OBJECT_TYPE::uhdmunsupported_expr /* = 2389 */: return "unsupported_expr";
    case UHDM_OBJECT_TYPE::uhdmunsupported_stmt /* = 2390 */: return "unsupported_stmt";
    case UHDM_OBJECT_TYPE::uhdmunsupported_typespec /* = 2391 */: return "unsupported_typespec";
    case UHDM_OBJECT_TYPE::uhdmuser_systf /* = 2392 */: return "user_systf";
    case UHDM_OBJECT_TYPE::uhdmvalue_range /* = 2393 */: return "value_range";
    case UHDM_OBJECT_TYPE::uhdmvar_bit /* = 2394 */: return "var_bit";
    case UHDM_OBJECT_TYPE::uhdmvar_bits /* = 2395 */: return "var_bits";
    case UHDM_OBJECT_TYPE::uhdmvar_select /* = 2396 */: return "var_select";
    case UHDM_OBJECT_TYPE::uhdmvar_selects /* = 2397 */: return "var_selects";
    case UHDM_OBJECT_TYPE::uhdmvariable /* = 2398 */: return "variable";
    case UHDM_OBJECT_TYPE::uhdmvariable_drivers /* = 2399 */: return "variable_drivers";
    case UHDM_OBJECT_TYPE::uhdmvariable_drivers_group /* = 2400 */: return "variable_drivers_group";
    case UHDM_OBJECT_TYPE::uhdmvariable_loads /* = 2401 */: return "variable_loads";
    case UHDM_OBJECT_TYPE::uhdmvariable_loads_group /* = 2402 */: return "variable_loads_group";
    case UHDM_OBJECT_TYPE::uhdmvariables /* = 2403 */: return "variables";
    case UHDM_OBJECT_TYPE::uhdmvariables_operation_group /* = 2404 */: return "variables_operation_group";
    case UHDM_OBJECT_TYPE::uhdmvirtual_interface_var /* = 2405 */: return "virtual_interface_var";
    case UHDM_OBJECT_TYPE::uhdmvirtual_interface_vars /* = 2406 */: return "virtual_interface_vars";
    case UHDM_OBJECT_TYPE::uhdmvoid_typespec /* = 2407 */: return "void_typespec";
    case UHDM_OBJECT_TYPE::uhdmvpiArguments /* = 2408 */: return "vpiArguments";
    case UHDM_OBJECT_TYPE::uhdmvpiClockingEvent /* = 2409 */: return "vpiClockingEvent";
    case UHDM_OBJECT_TYPE::uhdmvpiCondition /* = 2410 */: return "vpiCondition";
    case UHDM_OBJECT_TYPE::uhdmvpiConditions /* = 2411 */: return "vpiConditions";
    case UHDM_OBJECT_TYPE::uhdmvpiDisableCondition /* = 2412 */: return "vpiDisableCondition";
    case UHDM_OBJECT_TYPE::uhdmvpiElseStmt /* = 2413 */: return "vpiElseStmt";
    case UHDM_OBJECT_TYPE::uhdmvpiExpr /* = 2414 */: return "vpiExpr";
    case UHDM_OBJECT_TYPE::uhdmvpiExprs /* = 2415 */: return "vpiExprs";
    case UHDM_OBJECT_TYPE::uhdmvpiForIncStmt /* = 2416 */: return "vpiForIncStmt";
    case UHDM_OBJECT_TYPE::uhdmvpiForIncStmts /* = 2417 */: return "vpiForIncStmts";
    case UHDM_OBJECT_TYPE::uhdmvpiForInitStmt /* = 2418 */: return "vpiForInitStmt";
    case UHDM_OBJECT_TYPE::uhdmvpiForInitStmts /* = 2419 */: return "vpiForInitStmts";
    case UHDM_OBJECT_TYPE::uhdmvpiIndex /* = 2420 */: return "vpiIndex";
    case UHDM_OBJECT_TYPE::uhdmvpiInstance /* = 2421 */: return "vpiInstance";
    case UHDM_OBJECT_TYPE::uhdmvpiLoopVars /* = 2422 */: return "vpiLoopVars";
    case UHDM_OBJECT_TYPE::uhdmvpiProperty /* = 2423 */: return "vpiProperty";
    case UHDM_OBJECT_TYPE::uhdmvpiPropertyExpr /* = 2424 */: return "vpiPropertyExpr";
    case UHDM_OBJECT_TYPE::uhdmvpiSequenceExpr /* = 2425 */: return "vpiSequenceExpr";
    case UHDM_OBJECT_TYPE::uhdmvpiStmt /* = 2426 */: return "vpiStmt";
    case UHDM_OBJECT_TYPE::uhdmvpiUses /* = 2427 */: return "vpiUses";
    case UHDM_OBJECT_TYPE::uhdmwait_fork /* = 2428 */: return "wait_fork";
    case UHDM_OBJECT_TYPE::uhdmwait_stmt /* = 2429 */: return "wait_stmt";
    case UHDM_OBJECT_TYPE::uhdmwaits /* = 2430 */: return "waits";
    case UHDM_OBJECT_TYPE::uhdmweight /* = 2431 */: return "weight";
    case UHDM_OBJECT_TYPE::uhdmwhile_stmt /* = 2432 */: return "while_stmt";
    case UHDM_OBJECT_TYPE::uhdmwidth_expr /* = 2433 */: return "width_expr";
    case UHDM_OBJECT_TYPE::uhdmwith /* = 2434 */: return "with";
    default: return "NO TYPE";
  }
}

// From uhdm_types.h
std::string VpiTypeName(vpiHandle h) {
  uhdm_handle* handle = (uhdm_handle*)h;
  BaseClass* obj = (BaseClass*)handle->object;
  return UhdmName(obj->UhdmType());
}

std::map<std::string, uint32_t, std::less<>> Serializer::ObjectStats() const {
  std::map<std::string, uint32_t, std::less<>> stats;
  stats.insert(std::make_pair("alias_stmt", alias_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("always", alwaysMaker.objects_.size()));
  stats.insert(std::make_pair("any_pattern", any_patternMaker.objects_.size()));
  stats.insert(std::make_pair("array_expr", array_exprMaker.objects_.size()));
  stats.insert(std::make_pair("array_net", array_netMaker.objects_.size()));
  stats.insert(std::make_pair("array_typespec", array_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("array_var", array_varMaker.objects_.size()));
  stats.insert(std::make_pair("assert_stmt", assert_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("assign_stmt", assign_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("assignment", assignmentMaker.objects_.size()));
  stats.insert(std::make_pair("assume", assumeMaker.objects_.size()));
  stats.insert(std::make_pair("attribute", attributeMaker.objects_.size()));
  stats.insert(std::make_pair("begin", beginMaker.objects_.size()));
  stats.insert(std::make_pair("bit_select", bit_selectMaker.objects_.size()));
  stats.insert(std::make_pair("bit_typespec", bit_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("bit_var", bit_varMaker.objects_.size()));
  stats.insert(std::make_pair("break_stmt", break_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("byte_typespec", byte_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("byte_var", byte_varMaker.objects_.size()));
  stats.insert(std::make_pair("case_item", case_itemMaker.objects_.size()));
  stats.insert(std::make_pair("case_property", case_propertyMaker.objects_.size()));
  stats.insert(std::make_pair("case_property_item", case_property_itemMaker.objects_.size()));
  stats.insert(std::make_pair("case_stmt", case_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("chandle_typespec", chandle_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("chandle_var", chandle_varMaker.objects_.size()));
  stats.insert(std::make_pair("checker_decl", checker_declMaker.objects_.size()));
  stats.insert(std::make_pair("checker_inst", checker_instMaker.objects_.size()));
  stats.insert(std::make_pair("checker_inst_port", checker_inst_portMaker.objects_.size()));
  stats.insert(std::make_pair("checker_port", checker_portMaker.objects_.size()));
  stats.insert(std::make_pair("class_defn", class_defnMaker.objects_.size()));
  stats.insert(std::make_pair("class_obj", class_objMaker.objects_.size()));
  stats.insert(std::make_pair("class_typespec", class_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("class_var", class_varMaker.objects_.size()));
  stats.insert(std::make_pair("clocked_property", clocked_propertyMaker.objects_.size()));
  stats.insert(std::make_pair("clocked_seq", clocked_seqMaker.objects_.size()));
  stats.insert(std::make_pair("clocking_block", clocking_blockMaker.objects_.size()));
  stats.insert(std::make_pair("clocking_io_decl", clocking_io_declMaker.objects_.size()));
  stats.insert(std::make_pair("constant", constantMaker.objects_.size()));
  stats.insert(std::make_pair("constr_foreach", constr_foreachMaker.objects_.size()));
  stats.insert(std::make_pair("constr_if", constr_ifMaker.objects_.size()));
  stats.insert(std::make_pair("constr_if_else", constr_if_elseMaker.objects_.size()));
  stats.insert(std::make_pair("constraint", constraintMaker.objects_.size()));
  stats.insert(std::make_pair("constraint_ordering", constraint_orderingMaker.objects_.size()));
  stats.insert(std::make_pair("cont_assign", cont_assignMaker.objects_.size()));
  stats.insert(std::make_pair("cont_assign_bit", cont_assign_bitMaker.objects_.size()));
  stats.insert(std::make_pair("continue_stmt", continue_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("cover", coverMaker.objects_.size()));
  stats.insert(std::make_pair("deassign", deassignMaker.objects_.size()));
  stats.insert(std::make_pair("def_param", def_paramMaker.objects_.size()));
  stats.insert(std::make_pair("delay_control", delay_controlMaker.objects_.size()));
  stats.insert(std::make_pair("delay_term", delay_termMaker.objects_.size()));
  stats.insert(std::make_pair("design", designMaker.objects_.size()));
  stats.insert(std::make_pair("disable", disableMaker.objects_.size()));
  stats.insert(std::make_pair("disable_fork", disable_forkMaker.objects_.size()));
  stats.insert(std::make_pair("dist_item", dist_itemMaker.objects_.size()));
  stats.insert(std::make_pair("distribution", distributionMaker.objects_.size()));
  stats.insert(std::make_pair("do_while", do_whileMaker.objects_.size()));
  stats.insert(std::make_pair("enum_const", enum_constMaker.objects_.size()));
  stats.insert(std::make_pair("enum_net", enum_netMaker.objects_.size()));
  stats.insert(std::make_pair("enum_typespec", enum_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("enum_var", enum_varMaker.objects_.size()));
  stats.insert(std::make_pair("event_control", event_controlMaker.objects_.size()));
  stats.insert(std::make_pair("event_stmt", event_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("event_typespec", event_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("expect_stmt", expect_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("extends", extendsMaker.objects_.size()));
  stats.insert(std::make_pair("final_stmt", final_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("for_stmt", for_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("force", forceMaker.objects_.size()));
  stats.insert(std::make_pair("foreach_stmt", foreach_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("forever_stmt", forever_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("fork_stmt", fork_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("func_call", func_callMaker.objects_.size()));
  stats.insert(std::make_pair("function", functionMaker.objects_.size()));
  stats.insert(std::make_pair("gate", gateMaker.objects_.size()));
  stats.insert(std::make_pair("gate_array", gate_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("gen_case", gen_caseMaker.objects_.size()));
  stats.insert(std::make_pair("gen_for", gen_forMaker.objects_.size()));
  stats.insert(std::make_pair("gen_if", gen_ifMaker.objects_.size()));
  stats.insert(std::make_pair("gen_if_else", gen_if_elseMaker.objects_.size()));
  stats.insert(std::make_pair("gen_region", gen_regionMaker.objects_.size()));
  stats.insert(std::make_pair("gen_scope", gen_scopeMaker.objects_.size()));
  stats.insert(std::make_pair("gen_scope_array", gen_scope_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("gen_var", gen_varMaker.objects_.size()));
  stats.insert(std::make_pair("hier_path", hier_pathMaker.objects_.size()));
  stats.insert(std::make_pair("if_else", if_elseMaker.objects_.size()));
  stats.insert(std::make_pair("if_stmt", if_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("immediate_assert", immediate_assertMaker.objects_.size()));
  stats.insert(std::make_pair("immediate_assume", immediate_assumeMaker.objects_.size()));
  stats.insert(std::make_pair("immediate_cover", immediate_coverMaker.objects_.size()));
  stats.insert(std::make_pair("implication", implicationMaker.objects_.size()));
  stats.insert(std::make_pair("import_typespec", import_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("include_file_info", include_file_infoMaker.objects_.size()));
  stats.insert(std::make_pair("indexed_part_select", indexed_part_selectMaker.objects_.size()));
  stats.insert(std::make_pair("initial", initialMaker.objects_.size()));
  stats.insert(std::make_pair("int_typespec", int_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("int_var", int_varMaker.objects_.size()));
  stats.insert(std::make_pair("integer_net", integer_netMaker.objects_.size()));
  stats.insert(std::make_pair("integer_typespec", integer_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("integer_var", integer_varMaker.objects_.size()));
  stats.insert(std::make_pair("interface_array", interface_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("interface_inst", interface_instMaker.objects_.size()));
  stats.insert(std::make_pair("interface_tf_decl", interface_tf_declMaker.objects_.size()));
  stats.insert(std::make_pair("interface_typespec", interface_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("io_decl", io_declMaker.objects_.size()));
  stats.insert(std::make_pair("let_decl", let_declMaker.objects_.size()));
  stats.insert(std::make_pair("let_expr", let_exprMaker.objects_.size()));
  stats.insert(std::make_pair("logic_net", logic_netMaker.objects_.size()));
  stats.insert(std::make_pair("logic_typespec", logic_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("logic_var", logic_varMaker.objects_.size()));
  stats.insert(std::make_pair("long_int_typespec", long_int_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("long_int_var", long_int_varMaker.objects_.size()));
  stats.insert(std::make_pair("method_func_call", method_func_callMaker.objects_.size()));
  stats.insert(std::make_pair("method_task_call", method_task_callMaker.objects_.size()));
  stats.insert(std::make_pair("mod_path", mod_pathMaker.objects_.size()));
  stats.insert(std::make_pair("modport", modportMaker.objects_.size()));
  stats.insert(std::make_pair("module_array", module_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("module_inst", module_instMaker.objects_.size()));
  stats.insert(std::make_pair("module_typespec", module_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("multiclock_sequence_expr", multiclock_sequence_exprMaker.objects_.size()));
  stats.insert(std::make_pair("named_begin", named_beginMaker.objects_.size()));
  stats.insert(std::make_pair("named_event", named_eventMaker.objects_.size()));
  stats.insert(std::make_pair("named_event_array", named_event_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("named_fork", named_forkMaker.objects_.size()));
  stats.insert(std::make_pair("net_bit", net_bitMaker.objects_.size()));
  stats.insert(std::make_pair("null_stmt", null_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("operation", operationMaker.objects_.size()));
  stats.insert(std::make_pair("ordered_wait", ordered_waitMaker.objects_.size()));
  stats.insert(std::make_pair("package", packageMaker.objects_.size()));
  stats.insert(std::make_pair("packed_array_net", packed_array_netMaker.objects_.size()));
  stats.insert(std::make_pair("packed_array_typespec", packed_array_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("packed_array_var", packed_array_varMaker.objects_.size()));
  stats.insert(std::make_pair("param_assign", param_assignMaker.objects_.size()));
  stats.insert(std::make_pair("parameter", parameterMaker.objects_.size()));
  stats.insert(std::make_pair("part_select", part_selectMaker.objects_.size()));
  stats.insert(std::make_pair("path_term", path_termMaker.objects_.size()));
  stats.insert(std::make_pair("port", portMaker.objects_.size()));
  stats.insert(std::make_pair("port_bit", port_bitMaker.objects_.size()));
  stats.insert(std::make_pair("prim_term", prim_termMaker.objects_.size()));
  stats.insert(std::make_pair("program", programMaker.objects_.size()));
  stats.insert(std::make_pair("program_array", program_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("prop_formal_decl", prop_formal_declMaker.objects_.size()));
  stats.insert(std::make_pair("property_decl", property_declMaker.objects_.size()));
  stats.insert(std::make_pair("property_inst", property_instMaker.objects_.size()));
  stats.insert(std::make_pair("property_spec", property_specMaker.objects_.size()));
  stats.insert(std::make_pair("property_typespec", property_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("range", rangeMaker.objects_.size()));
  stats.insert(std::make_pair("real_typespec", real_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("real_var", real_varMaker.objects_.size()));
  stats.insert(std::make_pair("ref_module", ref_moduleMaker.objects_.size()));
  stats.insert(std::make_pair("ref_obj", ref_objMaker.objects_.size()));
  stats.insert(std::make_pair("ref_typespec", ref_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("ref_var", ref_varMaker.objects_.size()));
  stats.insert(std::make_pair("reg", regMaker.objects_.size()));
  stats.insert(std::make_pair("reg_array", reg_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("release", releaseMaker.objects_.size()));
  stats.insert(std::make_pair("repeat", repeatMaker.objects_.size()));
  stats.insert(std::make_pair("repeat_control", repeat_controlMaker.objects_.size()));
  stats.insert(std::make_pair("restrict", restrictMaker.objects_.size()));
  stats.insert(std::make_pair("return_stmt", return_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("seq_formal_decl", seq_formal_declMaker.objects_.size()));
  stats.insert(std::make_pair("sequence_decl", sequence_declMaker.objects_.size()));
  stats.insert(std::make_pair("sequence_inst", sequence_instMaker.objects_.size()));
  stats.insert(std::make_pair("sequence_typespec", sequence_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("short_int_typespec", short_int_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("short_int_var", short_int_varMaker.objects_.size()));
  stats.insert(std::make_pair("short_real_typespec", short_real_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("short_real_var", short_real_varMaker.objects_.size()));
  stats.insert(std::make_pair("soft_disable", soft_disableMaker.objects_.size()));
  stats.insert(std::make_pair("spec_param", spec_paramMaker.objects_.size()));
  stats.insert(std::make_pair("string_typespec", string_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("string_var", string_varMaker.objects_.size()));
  stats.insert(std::make_pair("struct_net", struct_netMaker.objects_.size()));
  stats.insert(std::make_pair("struct_pattern", struct_patternMaker.objects_.size()));
  stats.insert(std::make_pair("struct_typespec", struct_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("struct_var", struct_varMaker.objects_.size()));
  stats.insert(std::make_pair("switch_array", switch_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("switch_tran", switch_tranMaker.objects_.size()));
  stats.insert(std::make_pair("sys_func_call", sys_func_callMaker.objects_.size()));
  stats.insert(std::make_pair("sys_task_call", sys_task_callMaker.objects_.size()));
  stats.insert(std::make_pair("table_entry", table_entryMaker.objects_.size()));
  stats.insert(std::make_pair("tagged_pattern", tagged_patternMaker.objects_.size()));
  stats.insert(std::make_pair("task", taskMaker.objects_.size()));
  stats.insert(std::make_pair("task_call", task_callMaker.objects_.size()));
  stats.insert(std::make_pair("tchk", tchkMaker.objects_.size()));
  stats.insert(std::make_pair("tchk_term", tchk_termMaker.objects_.size()));
  stats.insert(std::make_pair("thread_obj", thread_objMaker.objects_.size()));
  stats.insert(std::make_pair("time_net", time_netMaker.objects_.size()));
  stats.insert(std::make_pair("time_typespec", time_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("time_var", time_varMaker.objects_.size()));
  stats.insert(std::make_pair("type_parameter", type_parameterMaker.objects_.size()));
  stats.insert(std::make_pair("typespec_member", typespec_memberMaker.objects_.size()));
  stats.insert(std::make_pair("udp", udpMaker.objects_.size()));
  stats.insert(std::make_pair("udp_array", udp_arrayMaker.objects_.size()));
  stats.insert(std::make_pair("udp_defn", udp_defnMaker.objects_.size()));
  stats.insert(std::make_pair("union_typespec", union_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("union_var", union_varMaker.objects_.size()));
  stats.insert(std::make_pair("unsupported_expr", unsupported_exprMaker.objects_.size()));
  stats.insert(std::make_pair("unsupported_stmt", unsupported_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("unsupported_typespec", unsupported_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("user_systf", user_systfMaker.objects_.size()));
  stats.insert(std::make_pair("var_bit", var_bitMaker.objects_.size()));
  stats.insert(std::make_pair("var_select", var_selectMaker.objects_.size()));
  stats.insert(std::make_pair("virtual_interface_var", virtual_interface_varMaker.objects_.size()));
  stats.insert(std::make_pair("void_typespec", void_typespecMaker.objects_.size()));
  stats.insert(std::make_pair("wait_fork", wait_forkMaker.objects_.size()));
  stats.insert(std::make_pair("wait_stmt", wait_stmtMaker.objects_.size()));
  stats.insert(std::make_pair("while_stmt", while_stmtMaker.objects_.size()));
  return stats;
}

void Serializer::PrintStats(std::ostream& strm,
                            std::string_view infoText) const {
  strm << "=== UHDM Object Stats Begin (" << infoText << ") ===" << std::endl;
  auto stats = ObjectStats();
  std::vector<std::string_view> names;
  names.reserve(stats.size());
  std::transform(stats.begin(), stats.end(), std::back_inserter(names),
                 [](decltype(stats)::value_type const& pair) {
                   return std::string_view(pair.first);
                 });
  std::sort(names.begin(), names.end());
  for (std::string_view name : names) {
    auto it = stats.find(name);
    if (it->second > 0) {
      // The longest model name is
      // "enum_struct_union_packed_array_typespec_group"
      strm << std::setw(48) << std::left << name << std::setw(8) << std::right
           << it->second << std::endl;
    }
  }
  strm << "=== UHDM Object Stats End ===" << std::endl;
}

bool Serializer::Erase(const BaseClass* p) {
  if (p == nullptr) {
    return true;
  }

  switch (p->UhdmType()) {
    case UHDM_OBJECT_TYPE::uhdmalias_stmt /* = 2004 */: return alias_stmtMaker.Erase(static_cast<const alias_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmalways /* = 2012 */: return alwaysMaker.Erase(static_cast<const always*>(p));
    case UHDM_OBJECT_TYPE::uhdmany_pattern /* = 2013 */: return any_patternMaker.Erase(static_cast<const any_pattern*>(p));
    case UHDM_OBJECT_TYPE::uhdmarray_expr /* = 2015 */: return array_exprMaker.Erase(static_cast<const array_expr*>(p));
    case UHDM_OBJECT_TYPE::uhdmarray_net /* = 2016 */: return array_netMaker.Erase(static_cast<const array_net*>(p));
    case UHDM_OBJECT_TYPE::uhdmarray_typespec /* = 2018 */: return array_typespecMaker.Erase(static_cast<const array_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmarray_var /* = 2019 */: return array_varMaker.Erase(static_cast<const array_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmassert_stmt /* = 2022 */: return assert_stmtMaker.Erase(static_cast<const assert_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmassign_stmt /* = 2025 */: return assign_stmtMaker.Erase(static_cast<const assign_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmassignment /* = 2026 */: return assignmentMaker.Erase(static_cast<const assignment*>(p));
    case UHDM_OBJECT_TYPE::uhdmassume /* = 2027 */: return assumeMaker.Erase(static_cast<const assume*>(p));
    case UHDM_OBJECT_TYPE::uhdmattribute /* = 2029 */: return attributeMaker.Erase(static_cast<const attribute*>(p));
    case UHDM_OBJECT_TYPE::uhdmbegin /* = 2033 */: return beginMaker.Erase(static_cast<const begin*>(p));
    case UHDM_OBJECT_TYPE::uhdmbit_select /* = 2034 */: return bit_selectMaker.Erase(static_cast<const bit_select*>(p));
    case UHDM_OBJECT_TYPE::uhdmbit_typespec /* = 2035 */: return bit_typespecMaker.Erase(static_cast<const bit_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmbit_var /* = 2036 */: return bit_varMaker.Erase(static_cast<const bit_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmbreak_stmt /* = 2038 */: return break_stmtMaker.Erase(static_cast<const break_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmbyte_typespec /* = 2039 */: return byte_typespecMaker.Erase(static_cast<const byte_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmbyte_var /* = 2040 */: return byte_varMaker.Erase(static_cast<const byte_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmcase_item /* = 2041 */: return case_itemMaker.Erase(static_cast<const case_item*>(p));
    case UHDM_OBJECT_TYPE::uhdmcase_property /* = 2043 */: return case_propertyMaker.Erase(static_cast<const case_property*>(p));
    case UHDM_OBJECT_TYPE::uhdmcase_property_item /* = 2044 */: return case_property_itemMaker.Erase(static_cast<const case_property_item*>(p));
    case UHDM_OBJECT_TYPE::uhdmcase_stmt /* = 2046 */: return case_stmtMaker.Erase(static_cast<const case_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmchandle_typespec /* = 2048 */: return chandle_typespecMaker.Erase(static_cast<const chandle_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmchandle_var /* = 2049 */: return chandle_varMaker.Erase(static_cast<const chandle_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmchecker_decl /* = 2050 */: return checker_declMaker.Erase(static_cast<const checker_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmchecker_inst /* = 2051 */: return checker_instMaker.Erase(static_cast<const checker_inst*>(p));
    case UHDM_OBJECT_TYPE::uhdmchecker_inst_port /* = 2052 */: return checker_inst_portMaker.Erase(static_cast<const checker_inst_port*>(p));
    case UHDM_OBJECT_TYPE::uhdmchecker_port /* = 2053 */: return checker_portMaker.Erase(static_cast<const checker_port*>(p));
    case UHDM_OBJECT_TYPE::uhdmclass_defn /* = 2054 */: return class_defnMaker.Erase(static_cast<const class_defn*>(p));
    case UHDM_OBJECT_TYPE::uhdmclass_obj /* = 2056 */: return class_objMaker.Erase(static_cast<const class_obj*>(p));
    case UHDM_OBJECT_TYPE::uhdmclass_typespec /* = 2057 */: return class_typespecMaker.Erase(static_cast<const class_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmclass_var /* = 2059 */: return class_varMaker.Erase(static_cast<const class_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmclocked_property /* = 2060 */: return clocked_propertyMaker.Erase(static_cast<const clocked_property*>(p));
    case UHDM_OBJECT_TYPE::uhdmclocked_seq /* = 2061 */: return clocked_seqMaker.Erase(static_cast<const clocked_seq*>(p));
    case UHDM_OBJECT_TYPE::uhdmclocking_block /* = 2063 */: return clocking_blockMaker.Erase(static_cast<const clocking_block*>(p));
    case UHDM_OBJECT_TYPE::uhdmclocking_io_decl /* = 2066 */: return clocking_io_declMaker.Erase(static_cast<const clocking_io_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmconstant /* = 2070 */: return constantMaker.Erase(static_cast<const constant*>(p));
    case UHDM_OBJECT_TYPE::uhdmconstr_foreach /* = 2071 */: return constr_foreachMaker.Erase(static_cast<const constr_foreach*>(p));
    case UHDM_OBJECT_TYPE::uhdmconstr_if /* = 2072 */: return constr_ifMaker.Erase(static_cast<const constr_if*>(p));
    case UHDM_OBJECT_TYPE::uhdmconstr_if_else /* = 2073 */: return constr_if_elseMaker.Erase(static_cast<const constr_if_else*>(p));
    case UHDM_OBJECT_TYPE::uhdmconstraint /* = 2074 */: return constraintMaker.Erase(static_cast<const constraint*>(p));
    case UHDM_OBJECT_TYPE::uhdmconstraint_ordering /* = 2079 */: return constraint_orderingMaker.Erase(static_cast<const constraint_ordering*>(p));
    case UHDM_OBJECT_TYPE::uhdmcont_assign /* = 2081 */: return cont_assignMaker.Erase(static_cast<const cont_assign*>(p));
    case UHDM_OBJECT_TYPE::uhdmcont_assign_bit /* = 2082 */: return cont_assign_bitMaker.Erase(static_cast<const cont_assign_bit*>(p));
    case UHDM_OBJECT_TYPE::uhdmcontinue_stmt /* = 2085 */: return continue_stmtMaker.Erase(static_cast<const continue_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmcover /* = 2086 */: return coverMaker.Erase(static_cast<const cover*>(p));
    case UHDM_OBJECT_TYPE::uhdmdeassign /* = 2087 */: return deassignMaker.Erase(static_cast<const deassign*>(p));
    case UHDM_OBJECT_TYPE::uhdmdef_param /* = 2088 */: return def_paramMaker.Erase(static_cast<const def_param*>(p));
    case UHDM_OBJECT_TYPE::uhdmdelay_control /* = 2093 */: return delay_controlMaker.Erase(static_cast<const delay_control*>(p));
    case UHDM_OBJECT_TYPE::uhdmdelay_term /* = 2094 */: return delay_termMaker.Erase(static_cast<const delay_term*>(p));
    case UHDM_OBJECT_TYPE::uhdmdesign /* = 2096 */: return designMaker.Erase(static_cast<const design*>(p));
    case UHDM_OBJECT_TYPE::uhdmdisable /* = 2097 */: return disableMaker.Erase(static_cast<const disable*>(p));
    case UHDM_OBJECT_TYPE::uhdmdisable_fork /* = 2098 */: return disable_forkMaker.Erase(static_cast<const disable_fork*>(p));
    case UHDM_OBJECT_TYPE::uhdmdist_item /* = 2100 */: return dist_itemMaker.Erase(static_cast<const dist_item*>(p));
    case UHDM_OBJECT_TYPE::uhdmdistribution /* = 2102 */: return distributionMaker.Erase(static_cast<const distribution*>(p));
    case UHDM_OBJECT_TYPE::uhdmdo_while /* = 2103 */: return do_whileMaker.Erase(static_cast<const do_while*>(p));
    case UHDM_OBJECT_TYPE::uhdmenum_const /* = 2110 */: return enum_constMaker.Erase(static_cast<const enum_const*>(p));
    case UHDM_OBJECT_TYPE::uhdmenum_net /* = 2112 */: return enum_netMaker.Erase(static_cast<const enum_net*>(p));
    case UHDM_OBJECT_TYPE::uhdmenum_typespec /* = 2116 */: return enum_typespecMaker.Erase(static_cast<const enum_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmenum_var /* = 2117 */: return enum_varMaker.Erase(static_cast<const enum_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmevent_control /* = 2118 */: return event_controlMaker.Erase(static_cast<const event_control*>(p));
    case UHDM_OBJECT_TYPE::uhdmevent_stmt /* = 2119 */: return event_stmtMaker.Erase(static_cast<const event_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmevent_typespec /* = 2120 */: return event_typespecMaker.Erase(static_cast<const event_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmexpect_stmt /* = 2121 */: return expect_stmtMaker.Erase(static_cast<const expect_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmextends /* = 2137 */: return extendsMaker.Erase(static_cast<const extends*>(p));
    case UHDM_OBJECT_TYPE::uhdmfinal_stmt /* = 2138 */: return final_stmtMaker.Erase(static_cast<const final_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmfor_stmt /* = 2139 */: return for_stmtMaker.Erase(static_cast<const for_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmforce /* = 2140 */: return forceMaker.Erase(static_cast<const force*>(p));
    case UHDM_OBJECT_TYPE::uhdmforeach_stmt /* = 2141 */: return foreach_stmtMaker.Erase(static_cast<const foreach_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmforever_stmt /* = 2142 */: return forever_stmtMaker.Erase(static_cast<const forever_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmfork_stmt /* = 2143 */: return fork_stmtMaker.Erase(static_cast<const fork_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmfunc_call /* = 2144 */: return func_callMaker.Erase(static_cast<const func_call*>(p));
    case UHDM_OBJECT_TYPE::uhdmfunction /* = 2145 */: return functionMaker.Erase(static_cast<const function*>(p));
    case UHDM_OBJECT_TYPE::uhdmgate /* = 2147 */: return gateMaker.Erase(static_cast<const gate*>(p));
    case UHDM_OBJECT_TYPE::uhdmgate_array /* = 2148 */: return gate_arrayMaker.Erase(static_cast<const gate_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_case /* = 2149 */: return gen_caseMaker.Erase(static_cast<const gen_case*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_for /* = 2150 */: return gen_forMaker.Erase(static_cast<const gen_for*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_if /* = 2151 */: return gen_ifMaker.Erase(static_cast<const gen_if*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_if_else /* = 2152 */: return gen_if_elseMaker.Erase(static_cast<const gen_if_else*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_region /* = 2153 */: return gen_regionMaker.Erase(static_cast<const gen_region*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_scope /* = 2154 */: return gen_scopeMaker.Erase(static_cast<const gen_scope*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_scope_array /* = 2155 */: return gen_scope_arrayMaker.Erase(static_cast<const gen_scope_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmgen_var /* = 2160 */: return gen_varMaker.Erase(static_cast<const gen_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmhier_path /* = 2162 */: return hier_pathMaker.Erase(static_cast<const hier_path*>(p));
    case UHDM_OBJECT_TYPE::uhdmif_else /* = 2164 */: return if_elseMaker.Erase(static_cast<const if_else*>(p));
    case UHDM_OBJECT_TYPE::uhdmif_stmt /* = 2165 */: return if_stmtMaker.Erase(static_cast<const if_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmimmediate_assert /* = 2166 */: return immediate_assertMaker.Erase(static_cast<const immediate_assert*>(p));
    case UHDM_OBJECT_TYPE::uhdmimmediate_assume /* = 2167 */: return immediate_assumeMaker.Erase(static_cast<const immediate_assume*>(p));
    case UHDM_OBJECT_TYPE::uhdmimmediate_cover /* = 2168 */: return immediate_coverMaker.Erase(static_cast<const immediate_cover*>(p));
    case UHDM_OBJECT_TYPE::uhdmimplication /* = 2169 */: return implicationMaker.Erase(static_cast<const implication*>(p));
    case UHDM_OBJECT_TYPE::uhdmimport_typespec /* = 2170 */: return import_typespecMaker.Erase(static_cast<const import_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdminclude_file_info /* = 2171 */: return include_file_infoMaker.Erase(static_cast<const include_file_info*>(p));
    case UHDM_OBJECT_TYPE::uhdmindexed_part_select /* = 2175 */: return indexed_part_selectMaker.Erase(static_cast<const indexed_part_select*>(p));
    case UHDM_OBJECT_TYPE::uhdminitial /* = 2177 */: return initialMaker.Erase(static_cast<const initial*>(p));
    case UHDM_OBJECT_TYPE::uhdmint_typespec /* = 2184 */: return int_typespecMaker.Erase(static_cast<const int_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmint_var /* = 2185 */: return int_varMaker.Erase(static_cast<const int_var*>(p));
    case UHDM_OBJECT_TYPE::uhdminteger_net /* = 2186 */: return integer_netMaker.Erase(static_cast<const integer_net*>(p));
    case UHDM_OBJECT_TYPE::uhdminteger_typespec /* = 2187 */: return integer_typespecMaker.Erase(static_cast<const integer_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdminteger_var /* = 2188 */: return integer_varMaker.Erase(static_cast<const integer_var*>(p));
    case UHDM_OBJECT_TYPE::uhdminterface_array /* = 2190 */: return interface_arrayMaker.Erase(static_cast<const interface_array*>(p));
    case UHDM_OBJECT_TYPE::uhdminterface_inst /* = 2193 */: return interface_instMaker.Erase(static_cast<const interface_inst*>(p));
    case UHDM_OBJECT_TYPE::uhdminterface_tf_decl /* = 2194 */: return interface_tf_declMaker.Erase(static_cast<const interface_tf_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdminterface_typespec /* = 2196 */: return interface_typespecMaker.Erase(static_cast<const interface_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmio_decl /* = 2198 */: return io_declMaker.Erase(static_cast<const io_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmlet_decl /* = 2203 */: return let_declMaker.Erase(static_cast<const let_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmlet_expr /* = 2205 */: return let_exprMaker.Erase(static_cast<const let_expr*>(p));
    case UHDM_OBJECT_TYPE::uhdmlogic_net /* = 2210 */: return logic_netMaker.Erase(static_cast<const logic_net*>(p));
    case UHDM_OBJECT_TYPE::uhdmlogic_typespec /* = 2211 */: return logic_typespecMaker.Erase(static_cast<const logic_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmlogic_var /* = 2212 */: return logic_varMaker.Erase(static_cast<const logic_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmlong_int_typespec /* = 2214 */: return long_int_typespecMaker.Erase(static_cast<const long_int_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmlong_int_var /* = 2215 */: return long_int_varMaker.Erase(static_cast<const long_int_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmmethod_func_call /* = 2219 */: return method_func_callMaker.Erase(static_cast<const method_func_call*>(p));
    case UHDM_OBJECT_TYPE::uhdmmethod_task_call /* = 2221 */: return method_task_callMaker.Erase(static_cast<const method_task_call*>(p));
    case UHDM_OBJECT_TYPE::uhdmmod_path /* = 2222 */: return mod_pathMaker.Erase(static_cast<const mod_path*>(p));
    case UHDM_OBJECT_TYPE::uhdmmodport /* = 2224 */: return modportMaker.Erase(static_cast<const modport*>(p));
    case UHDM_OBJECT_TYPE::uhdmmodule_array /* = 2226 */: return module_arrayMaker.Erase(static_cast<const module_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmmodule_inst /* = 2228 */: return module_instMaker.Erase(static_cast<const module_inst*>(p));
    case UHDM_OBJECT_TYPE::uhdmmodule_typespec /* = 2229 */: return module_typespecMaker.Erase(static_cast<const module_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmmulticlock_sequence_expr /* = 2231 */: return multiclock_sequence_exprMaker.Erase(static_cast<const multiclock_sequence_expr*>(p));
    case UHDM_OBJECT_TYPE::uhdmnamed_begin /* = 2232 */: return named_beginMaker.Erase(static_cast<const named_begin*>(p));
    case UHDM_OBJECT_TYPE::uhdmnamed_event /* = 2233 */: return named_eventMaker.Erase(static_cast<const named_event*>(p));
    case UHDM_OBJECT_TYPE::uhdmnamed_event_array /* = 2234 */: return named_event_arrayMaker.Erase(static_cast<const named_event_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmnamed_fork /* = 2239 */: return named_forkMaker.Erase(static_cast<const named_fork*>(p));
    case UHDM_OBJECT_TYPE::uhdmnet_bit /* = 2241 */: return net_bitMaker.Erase(static_cast<const net_bit*>(p));
    case UHDM_OBJECT_TYPE::uhdmnull_stmt /* = 2247 */: return null_stmtMaker.Erase(static_cast<const null_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmoperation /* = 2250 */: return operationMaker.Erase(static_cast<const operation*>(p));
    case UHDM_OBJECT_TYPE::uhdmordered_wait /* = 2251 */: return ordered_waitMaker.Erase(static_cast<const ordered_wait*>(p));
    case UHDM_OBJECT_TYPE::uhdmpackage /* = 2253 */: return packageMaker.Erase(static_cast<const package*>(p));
    case UHDM_OBJECT_TYPE::uhdmpacked_array_net /* = 2254 */: return packed_array_netMaker.Erase(static_cast<const packed_array_net*>(p));
    case UHDM_OBJECT_TYPE::uhdmpacked_array_typespec /* = 2255 */: return packed_array_typespecMaker.Erase(static_cast<const packed_array_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmpacked_array_var /* = 2256 */: return packed_array_varMaker.Erase(static_cast<const packed_array_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmparam_assign /* = 2257 */: return param_assignMaker.Erase(static_cast<const param_assign*>(p));
    case UHDM_OBJECT_TYPE::uhdmparameter /* = 2259 */: return parameterMaker.Erase(static_cast<const parameter*>(p));
    case UHDM_OBJECT_TYPE::uhdmpart_select /* = 2261 */: return part_selectMaker.Erase(static_cast<const part_select*>(p));
    case UHDM_OBJECT_TYPE::uhdmpath_term /* = 2263 */: return path_termMaker.Erase(static_cast<const path_term*>(p));
    case UHDM_OBJECT_TYPE::uhdmport /* = 2267 */: return portMaker.Erase(static_cast<const port*>(p));
    case UHDM_OBJECT_TYPE::uhdmport_bit /* = 2268 */: return port_bitMaker.Erase(static_cast<const port_bit*>(p));
    case UHDM_OBJECT_TYPE::uhdmprim_term /* = 2271 */: return prim_termMaker.Erase(static_cast<const prim_term*>(p));
    case UHDM_OBJECT_TYPE::uhdmprogram /* = 2279 */: return programMaker.Erase(static_cast<const program*>(p));
    case UHDM_OBJECT_TYPE::uhdmprogram_array /* = 2280 */: return program_arrayMaker.Erase(static_cast<const program_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmprop_formal_decl /* = 2283 */: return prop_formal_declMaker.Erase(static_cast<const prop_formal_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmproperty_decl /* = 2286 */: return property_declMaker.Erase(static_cast<const property_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmproperty_inst /* = 2291 */: return property_instMaker.Erase(static_cast<const property_inst*>(p));
    case UHDM_OBJECT_TYPE::uhdmproperty_spec /* = 2293 */: return property_specMaker.Erase(static_cast<const property_spec*>(p));
    case UHDM_OBJECT_TYPE::uhdmproperty_typespec /* = 2294 */: return property_typespecMaker.Erase(static_cast<const property_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmrange /* = 2295 */: return rangeMaker.Erase(static_cast<const range*>(p));
    case UHDM_OBJECT_TYPE::uhdmreal_typespec /* = 2297 */: return real_typespecMaker.Erase(static_cast<const real_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmreal_var /* = 2298 */: return real_varMaker.Erase(static_cast<const real_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmref_module /* = 2299 */: return ref_moduleMaker.Erase(static_cast<const ref_module*>(p));
    case UHDM_OBJECT_TYPE::uhdmref_obj /* = 2301 */: return ref_objMaker.Erase(static_cast<const ref_obj*>(p));
    case UHDM_OBJECT_TYPE::uhdmref_typespec /* = 2303 */: return ref_typespecMaker.Erase(static_cast<const ref_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmref_var /* = 2304 */: return ref_varMaker.Erase(static_cast<const ref_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmreg /* = 2305 */: return regMaker.Erase(static_cast<const reg*>(p));
    case UHDM_OBJECT_TYPE::uhdmreg_array /* = 2306 */: return reg_arrayMaker.Erase(static_cast<const reg_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmrelease /* = 2308 */: return releaseMaker.Erase(static_cast<const release*>(p));
    case UHDM_OBJECT_TYPE::uhdmrepeat /* = 2309 */: return repeatMaker.Erase(static_cast<const repeat*>(p));
    case UHDM_OBJECT_TYPE::uhdmrepeat_control /* = 2310 */: return repeat_controlMaker.Erase(static_cast<const repeat_control*>(p));
    case UHDM_OBJECT_TYPE::uhdmrestrict /* = 2312 */: return restrictMaker.Erase(static_cast<const restrict*>(p));
    case UHDM_OBJECT_TYPE::uhdmreturn_stmt /* = 2314 */: return return_stmtMaker.Erase(static_cast<const return_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmseq_formal_decl /* = 2321 */: return seq_formal_declMaker.Erase(static_cast<const seq_formal_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmsequence_decl /* = 2324 */: return sequence_declMaker.Erase(static_cast<const sequence_decl*>(p));
    case UHDM_OBJECT_TYPE::uhdmsequence_inst /* = 2328 */: return sequence_instMaker.Erase(static_cast<const sequence_inst*>(p));
    case UHDM_OBJECT_TYPE::uhdmsequence_typespec /* = 2329 */: return sequence_typespecMaker.Erase(static_cast<const sequence_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmshort_int_typespec /* = 2330 */: return short_int_typespecMaker.Erase(static_cast<const short_int_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmshort_int_var /* = 2331 */: return short_int_varMaker.Erase(static_cast<const short_int_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmshort_real_typespec /* = 2332 */: return short_real_typespecMaker.Erase(static_cast<const short_real_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmshort_real_var /* = 2333 */: return short_real_varMaker.Erase(static_cast<const short_real_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmsoft_disable /* = 2337 */: return soft_disableMaker.Erase(static_cast<const soft_disable*>(p));
    case UHDM_OBJECT_TYPE::uhdmspec_param /* = 2340 */: return spec_paramMaker.Erase(static_cast<const spec_param*>(p));
    case UHDM_OBJECT_TYPE::uhdmstring_typespec /* = 2344 */: return string_typespecMaker.Erase(static_cast<const string_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmstring_var /* = 2345 */: return string_varMaker.Erase(static_cast<const string_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmstruct_net /* = 2346 */: return struct_netMaker.Erase(static_cast<const struct_net*>(p));
    case UHDM_OBJECT_TYPE::uhdmstruct_pattern /* = 2347 */: return struct_patternMaker.Erase(static_cast<const struct_pattern*>(p));
    case UHDM_OBJECT_TYPE::uhdmstruct_typespec /* = 2348 */: return struct_typespecMaker.Erase(static_cast<const struct_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmstruct_var /* = 2349 */: return struct_varMaker.Erase(static_cast<const struct_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmswitch_array /* = 2350 */: return switch_arrayMaker.Erase(static_cast<const switch_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmswitch_tran /* = 2351 */: return switch_tranMaker.Erase(static_cast<const switch_tran*>(p));
    case UHDM_OBJECT_TYPE::uhdmsys_func_call /* = 2352 */: return sys_func_callMaker.Erase(static_cast<const sys_func_call*>(p));
    case UHDM_OBJECT_TYPE::uhdmsys_task_call /* = 2354 */: return sys_task_callMaker.Erase(static_cast<const sys_task_call*>(p));
    case UHDM_OBJECT_TYPE::uhdmtable_entry /* = 2355 */: return table_entryMaker.Erase(static_cast<const table_entry*>(p));
    case UHDM_OBJECT_TYPE::uhdmtagged_pattern /* = 2357 */: return tagged_patternMaker.Erase(static_cast<const tagged_pattern*>(p));
    case UHDM_OBJECT_TYPE::uhdmtask /* = 2358 */: return taskMaker.Erase(static_cast<const task*>(p));
    case UHDM_OBJECT_TYPE::uhdmtask_call /* = 2359 */: return task_callMaker.Erase(static_cast<const task_call*>(p));
    case UHDM_OBJECT_TYPE::uhdmtchk /* = 2364 */: return tchkMaker.Erase(static_cast<const tchk*>(p));
    case UHDM_OBJECT_TYPE::uhdmtchk_term /* = 2367 */: return tchk_termMaker.Erase(static_cast<const tchk_term*>(p));
    case UHDM_OBJECT_TYPE::uhdmthread_obj /* = 2372 */: return thread_objMaker.Erase(static_cast<const thread_obj*>(p));
    case UHDM_OBJECT_TYPE::uhdmtime_net /* = 2374 */: return time_netMaker.Erase(static_cast<const time_net*>(p));
    case UHDM_OBJECT_TYPE::uhdmtime_typespec /* = 2375 */: return time_typespecMaker.Erase(static_cast<const time_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmtime_var /* = 2376 */: return time_varMaker.Erase(static_cast<const time_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmtype_parameter /* = 2379 */: return type_parameterMaker.Erase(static_cast<const type_parameter*>(p));
    case UHDM_OBJECT_TYPE::uhdmtypespec_member /* = 2382 */: return typespec_memberMaker.Erase(static_cast<const typespec_member*>(p));
    case UHDM_OBJECT_TYPE::uhdmudp /* = 2384 */: return udpMaker.Erase(static_cast<const udp*>(p));
    case UHDM_OBJECT_TYPE::uhdmudp_array /* = 2385 */: return udp_arrayMaker.Erase(static_cast<const udp_array*>(p));
    case UHDM_OBJECT_TYPE::uhdmudp_defn /* = 2386 */: return udp_defnMaker.Erase(static_cast<const udp_defn*>(p));
    case UHDM_OBJECT_TYPE::uhdmunion_typespec /* = 2387 */: return union_typespecMaker.Erase(static_cast<const union_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmunion_var /* = 2388 */: return union_varMaker.Erase(static_cast<const union_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmunsupported_expr /* = 2389 */: return unsupported_exprMaker.Erase(static_cast<const unsupported_expr*>(p));
    case UHDM_OBJECT_TYPE::uhdmunsupported_stmt /* = 2390 */: return unsupported_stmtMaker.Erase(static_cast<const unsupported_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmunsupported_typespec /* = 2391 */: return unsupported_typespecMaker.Erase(static_cast<const unsupported_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmuser_systf /* = 2392 */: return user_systfMaker.Erase(static_cast<const user_systf*>(p));
    case UHDM_OBJECT_TYPE::uhdmvar_bit /* = 2394 */: return var_bitMaker.Erase(static_cast<const var_bit*>(p));
    case UHDM_OBJECT_TYPE::uhdmvar_select /* = 2396 */: return var_selectMaker.Erase(static_cast<const var_select*>(p));
    case UHDM_OBJECT_TYPE::uhdmvirtual_interface_var /* = 2405 */: return virtual_interface_varMaker.Erase(static_cast<const virtual_interface_var*>(p));
    case UHDM_OBJECT_TYPE::uhdmvoid_typespec /* = 2407 */: return void_typespecMaker.Erase(static_cast<const void_typespec*>(p));
    case UHDM_OBJECT_TYPE::uhdmwait_fork /* = 2428 */: return wait_forkMaker.Erase(static_cast<const wait_fork*>(p));
    case UHDM_OBJECT_TYPE::uhdmwait_stmt /* = 2429 */: return wait_stmtMaker.Erase(static_cast<const wait_stmt*>(p));
    case UHDM_OBJECT_TYPE::uhdmwhile_stmt /* = 2432 */: return while_stmtMaker.Erase(static_cast<const while_stmt*>(p));
    default: return false;
  }
}

Serializer::~Serializer() {
  Purge();
}

void Serializer::Purge() {
  anyVectMaker.Purge();
  symbolMaker.Purge();
  uhdm_handleMaker.Purge();
  alias_stmtMaker.Purge();
  alwaysMaker.Purge();
  any_patternMaker.Purge();
  array_exprMaker.Purge();
  array_netMaker.Purge();
  array_typespecMaker.Purge();
  array_varMaker.Purge();
  assert_stmtMaker.Purge();
  assign_stmtMaker.Purge();
  assignmentMaker.Purge();
  assumeMaker.Purge();
  attributeMaker.Purge();
  beginMaker.Purge();
  bit_selectMaker.Purge();
  bit_typespecMaker.Purge();
  bit_varMaker.Purge();
  break_stmtMaker.Purge();
  byte_typespecMaker.Purge();
  byte_varMaker.Purge();
  case_itemMaker.Purge();
  case_propertyMaker.Purge();
  case_property_itemMaker.Purge();
  case_stmtMaker.Purge();
  chandle_typespecMaker.Purge();
  chandle_varMaker.Purge();
  checker_declMaker.Purge();
  checker_instMaker.Purge();
  checker_inst_portMaker.Purge();
  checker_portMaker.Purge();
  class_defnMaker.Purge();
  class_objMaker.Purge();
  class_typespecMaker.Purge();
  class_varMaker.Purge();
  clocked_propertyMaker.Purge();
  clocked_seqMaker.Purge();
  clocking_blockMaker.Purge();
  clocking_io_declMaker.Purge();
  constantMaker.Purge();
  constr_foreachMaker.Purge();
  constr_ifMaker.Purge();
  constr_if_elseMaker.Purge();
  constraintMaker.Purge();
  constraint_orderingMaker.Purge();
  cont_assignMaker.Purge();
  cont_assign_bitMaker.Purge();
  continue_stmtMaker.Purge();
  coverMaker.Purge();
  deassignMaker.Purge();
  def_paramMaker.Purge();
  delay_controlMaker.Purge();
  delay_termMaker.Purge();
  designMaker.Purge();
  disableMaker.Purge();
  disable_forkMaker.Purge();
  dist_itemMaker.Purge();
  distributionMaker.Purge();
  do_whileMaker.Purge();
  enum_constMaker.Purge();
  enum_netMaker.Purge();
  enum_typespecMaker.Purge();
  enum_varMaker.Purge();
  event_controlMaker.Purge();
  event_stmtMaker.Purge();
  event_typespecMaker.Purge();
  expect_stmtMaker.Purge();
  extendsMaker.Purge();
  final_stmtMaker.Purge();
  for_stmtMaker.Purge();
  forceMaker.Purge();
  foreach_stmtMaker.Purge();
  forever_stmtMaker.Purge();
  fork_stmtMaker.Purge();
  func_callMaker.Purge();
  functionMaker.Purge();
  gateMaker.Purge();
  gate_arrayMaker.Purge();
  gen_caseMaker.Purge();
  gen_forMaker.Purge();
  gen_ifMaker.Purge();
  gen_if_elseMaker.Purge();
  gen_regionMaker.Purge();
  gen_scopeMaker.Purge();
  gen_scope_arrayMaker.Purge();
  gen_varMaker.Purge();
  hier_pathMaker.Purge();
  if_elseMaker.Purge();
  if_stmtMaker.Purge();
  immediate_assertMaker.Purge();
  immediate_assumeMaker.Purge();
  immediate_coverMaker.Purge();
  implicationMaker.Purge();
  import_typespecMaker.Purge();
  include_file_infoMaker.Purge();
  indexed_part_selectMaker.Purge();
  initialMaker.Purge();
  int_typespecMaker.Purge();
  int_varMaker.Purge();
  integer_netMaker.Purge();
  integer_typespecMaker.Purge();
  integer_varMaker.Purge();
  interface_arrayMaker.Purge();
  interface_instMaker.Purge();
  interface_tf_declMaker.Purge();
  interface_typespecMaker.Purge();
  io_declMaker.Purge();
  let_declMaker.Purge();
  let_exprMaker.Purge();
  logic_netMaker.Purge();
  logic_typespecMaker.Purge();
  logic_varMaker.Purge();
  long_int_typespecMaker.Purge();
  long_int_varMaker.Purge();
  method_func_callMaker.Purge();
  method_task_callMaker.Purge();
  mod_pathMaker.Purge();
  modportMaker.Purge();
  module_arrayMaker.Purge();
  module_instMaker.Purge();
  module_typespecMaker.Purge();
  multiclock_sequence_exprMaker.Purge();
  named_beginMaker.Purge();
  named_eventMaker.Purge();
  named_event_arrayMaker.Purge();
  named_forkMaker.Purge();
  net_bitMaker.Purge();
  null_stmtMaker.Purge();
  operationMaker.Purge();
  ordered_waitMaker.Purge();
  packageMaker.Purge();
  packed_array_netMaker.Purge();
  packed_array_typespecMaker.Purge();
  packed_array_varMaker.Purge();
  param_assignMaker.Purge();
  parameterMaker.Purge();
  part_selectMaker.Purge();
  path_termMaker.Purge();
  portMaker.Purge();
  port_bitMaker.Purge();
  prim_termMaker.Purge();
  programMaker.Purge();
  program_arrayMaker.Purge();
  prop_formal_declMaker.Purge();
  property_declMaker.Purge();
  property_instMaker.Purge();
  property_specMaker.Purge();
  property_typespecMaker.Purge();
  rangeMaker.Purge();
  real_typespecMaker.Purge();
  real_varMaker.Purge();
  ref_moduleMaker.Purge();
  ref_objMaker.Purge();
  ref_typespecMaker.Purge();
  ref_varMaker.Purge();
  regMaker.Purge();
  reg_arrayMaker.Purge();
  releaseMaker.Purge();
  repeatMaker.Purge();
  repeat_controlMaker.Purge();
  restrictMaker.Purge();
  return_stmtMaker.Purge();
  seq_formal_declMaker.Purge();
  sequence_declMaker.Purge();
  sequence_instMaker.Purge();
  sequence_typespecMaker.Purge();
  short_int_typespecMaker.Purge();
  short_int_varMaker.Purge();
  short_real_typespecMaker.Purge();
  short_real_varMaker.Purge();
  soft_disableMaker.Purge();
  spec_paramMaker.Purge();
  string_typespecMaker.Purge();
  string_varMaker.Purge();
  struct_netMaker.Purge();
  struct_patternMaker.Purge();
  struct_typespecMaker.Purge();
  struct_varMaker.Purge();
  switch_arrayMaker.Purge();
  switch_tranMaker.Purge();
  sys_func_callMaker.Purge();
  sys_task_callMaker.Purge();
  table_entryMaker.Purge();
  tagged_patternMaker.Purge();
  taskMaker.Purge();
  task_callMaker.Purge();
  tchkMaker.Purge();
  tchk_termMaker.Purge();
  thread_objMaker.Purge();
  time_netMaker.Purge();
  time_typespecMaker.Purge();
  time_varMaker.Purge();
  type_parameterMaker.Purge();
  typespec_memberMaker.Purge();
  udpMaker.Purge();
  udp_arrayMaker.Purge();
  udp_defnMaker.Purge();
  union_typespecMaker.Purge();
  union_varMaker.Purge();
  unsupported_exprMaker.Purge();
  unsupported_stmtMaker.Purge();
  unsupported_typespecMaker.Purge();
  user_systfMaker.Purge();
  var_bitMaker.Purge();
  var_selectMaker.Purge();
  virtual_interface_varMaker.Purge();
  void_typespecMaker.Purge();
  wait_forkMaker.Purge();
  wait_stmtMaker.Purge();
  while_stmtMaker.Purge();
}
}  // namespace UHDM
