/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   Serializer_restore.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/Serializer.h>

#include <fcntl.h>
#include <limits.h>
#include <sys/stat.h>
#include <sys/types.h>

#if defined(_MSC_VER)
  #include <io.h>
#else
  #include <unistd.h>
#endif

#include <iostream>
#include <vector>

#include <capnp/message.h>
#include <capnp/serialize-packed.h>

#include "UHDM.capnp.h"
#include <uhdm/uhdm.h>

#include "uhdm/config.h"

namespace UHDM {
static constexpr std::string_view kUnknownRawSymbol = "<unknown>";

template <typename T>
inline T* Serializer::Make(FactoryT<T>* const factory) {
  T* const obj = factory->Make();
  obj->SetSerializer(this);
  obj->UhdmId(++m_objId);
  return obj;
}

template <typename T>
void Serializer::Make(FactoryT<T>* const factory, uint32_t count) {
  for (uint32_t i = 0; i < count; ++i) Make(factory);
}

template <typename T>
inline std::vector<T*>* Serializer::Make(FactoryT<std::vector<T*>>* const factory) {
  return factory->Make();
}

BaseClass* Serializer::GetObject(uint32_t objectType, uint32_t index) const {
  if (index == kBadIndex) {
    return nullptr;
  }

  // TODO: have objectTyp enum UHDM_OBJECT_TYPE type in the first place
  switch (static_cast<UHDM_OBJECT_TYPE>(objectType)) {
    case UHDM_OBJECT_TYPE::uhdmalias_stmt /* = 2004 */: return alias_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmalways /* = 2012 */: return alwaysMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmany_pattern /* = 2013 */: return any_patternMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmarray_expr /* = 2015 */: return array_exprMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmarray_net /* = 2016 */: return array_netMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmarray_typespec /* = 2018 */: return array_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmarray_var /* = 2019 */: return array_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmassert_stmt /* = 2022 */: return assert_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmassign_stmt /* = 2025 */: return assign_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmassignment /* = 2026 */: return assignmentMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmassume /* = 2027 */: return assumeMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmattribute /* = 2029 */: return attributeMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmbegin /* = 2033 */: return beginMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmbit_select /* = 2034 */: return bit_selectMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmbit_typespec /* = 2035 */: return bit_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmbit_var /* = 2036 */: return bit_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmbreak_stmt /* = 2038 */: return break_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmbyte_typespec /* = 2039 */: return byte_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmbyte_var /* = 2040 */: return byte_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcase_item /* = 2041 */: return case_itemMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcase_property /* = 2043 */: return case_propertyMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcase_property_item /* = 2044 */: return case_property_itemMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcase_stmt /* = 2046 */: return case_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmchandle_typespec /* = 2048 */: return chandle_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmchandle_var /* = 2049 */: return chandle_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmchecker_decl /* = 2050 */: return checker_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmchecker_inst /* = 2051 */: return checker_instMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmchecker_inst_port /* = 2052 */: return checker_inst_portMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmchecker_port /* = 2053 */: return checker_portMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclass_defn /* = 2054 */: return class_defnMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclass_obj /* = 2056 */: return class_objMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclass_typespec /* = 2057 */: return class_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclass_var /* = 2059 */: return class_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclocked_property /* = 2060 */: return clocked_propertyMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclocked_seq /* = 2061 */: return clocked_seqMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclocking_block /* = 2063 */: return clocking_blockMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmclocking_io_decl /* = 2066 */: return clocking_io_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmconstant /* = 2070 */: return constantMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmconstr_foreach /* = 2071 */: return constr_foreachMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmconstr_if /* = 2072 */: return constr_ifMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmconstr_if_else /* = 2073 */: return constr_if_elseMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmconstraint /* = 2074 */: return constraintMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmconstraint_ordering /* = 2079 */: return constraint_orderingMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcont_assign /* = 2081 */: return cont_assignMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcont_assign_bit /* = 2082 */: return cont_assign_bitMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcontinue_stmt /* = 2085 */: return continue_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmcover /* = 2086 */: return coverMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdeassign /* = 2087 */: return deassignMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdef_param /* = 2088 */: return def_paramMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdelay_control /* = 2093 */: return delay_controlMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdelay_term /* = 2094 */: return delay_termMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdesign /* = 2096 */: return designMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdisable /* = 2097 */: return disableMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdisable_fork /* = 2098 */: return disable_forkMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdist_item /* = 2100 */: return dist_itemMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdistribution /* = 2102 */: return distributionMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmdo_while /* = 2103 */: return do_whileMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmenum_const /* = 2110 */: return enum_constMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmenum_net /* = 2112 */: return enum_netMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmenum_typespec /* = 2116 */: return enum_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmenum_var /* = 2117 */: return enum_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmevent_control /* = 2118 */: return event_controlMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmevent_stmt /* = 2119 */: return event_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmevent_typespec /* = 2120 */: return event_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmexpect_stmt /* = 2121 */: return expect_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmextends /* = 2137 */: return extendsMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmfinal_stmt /* = 2138 */: return final_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmfor_stmt /* = 2139 */: return for_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmforce /* = 2140 */: return forceMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmforeach_stmt /* = 2141 */: return foreach_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmforever_stmt /* = 2142 */: return forever_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmfork_stmt /* = 2143 */: return fork_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmfunc_call /* = 2144 */: return func_callMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmfunction /* = 2145 */: return functionMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgate /* = 2147 */: return gateMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgate_array /* = 2148 */: return gate_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_case /* = 2149 */: return gen_caseMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_for /* = 2150 */: return gen_forMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_if /* = 2151 */: return gen_ifMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_if_else /* = 2152 */: return gen_if_elseMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_region /* = 2153 */: return gen_regionMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_scope /* = 2154 */: return gen_scopeMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_scope_array /* = 2155 */: return gen_scope_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmgen_var /* = 2160 */: return gen_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmhier_path /* = 2162 */: return hier_pathMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmif_else /* = 2164 */: return if_elseMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmif_stmt /* = 2165 */: return if_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmimmediate_assert /* = 2166 */: return immediate_assertMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmimmediate_assume /* = 2167 */: return immediate_assumeMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmimmediate_cover /* = 2168 */: return immediate_coverMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmimplication /* = 2169 */: return implicationMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmimport_typespec /* = 2170 */: return import_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminclude_file_info /* = 2171 */: return include_file_infoMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmindexed_part_select /* = 2175 */: return indexed_part_selectMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminitial /* = 2177 */: return initialMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmint_typespec /* = 2184 */: return int_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmint_var /* = 2185 */: return int_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminteger_net /* = 2186 */: return integer_netMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminteger_typespec /* = 2187 */: return integer_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminteger_var /* = 2188 */: return integer_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminterface_array /* = 2190 */: return interface_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminterface_inst /* = 2193 */: return interface_instMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminterface_tf_decl /* = 2194 */: return interface_tf_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdminterface_typespec /* = 2196 */: return interface_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmio_decl /* = 2198 */: return io_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmlet_decl /* = 2203 */: return let_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmlet_expr /* = 2205 */: return let_exprMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmlogic_net /* = 2210 */: return logic_netMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmlogic_typespec /* = 2211 */: return logic_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmlogic_var /* = 2212 */: return logic_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmlong_int_typespec /* = 2214 */: return long_int_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmlong_int_var /* = 2215 */: return long_int_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmethod_func_call /* = 2219 */: return method_func_callMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmethod_task_call /* = 2221 */: return method_task_callMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmod_path /* = 2222 */: return mod_pathMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmodport /* = 2224 */: return modportMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmodule_array /* = 2226 */: return module_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmodule_inst /* = 2228 */: return module_instMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmodule_typespec /* = 2229 */: return module_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmmulticlock_sequence_expr /* = 2231 */: return multiclock_sequence_exprMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmnamed_begin /* = 2232 */: return named_beginMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmnamed_event /* = 2233 */: return named_eventMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmnamed_event_array /* = 2234 */: return named_event_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmnamed_fork /* = 2239 */: return named_forkMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmnet_bit /* = 2241 */: return net_bitMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmnull_stmt /* = 2247 */: return null_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmoperation /* = 2250 */: return operationMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmordered_wait /* = 2251 */: return ordered_waitMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmpackage /* = 2253 */: return packageMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmpacked_array_net /* = 2254 */: return packed_array_netMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmpacked_array_typespec /* = 2255 */: return packed_array_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmpacked_array_var /* = 2256 */: return packed_array_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmparam_assign /* = 2257 */: return param_assignMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmparameter /* = 2259 */: return parameterMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmpart_select /* = 2261 */: return part_selectMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmpath_term /* = 2263 */: return path_termMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmport /* = 2267 */: return portMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmport_bit /* = 2268 */: return port_bitMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmprim_term /* = 2271 */: return prim_termMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmprogram /* = 2279 */: return programMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmprogram_array /* = 2280 */: return program_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmprop_formal_decl /* = 2283 */: return prop_formal_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmproperty_decl /* = 2286 */: return property_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmproperty_inst /* = 2291 */: return property_instMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmproperty_spec /* = 2293 */: return property_specMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmproperty_typespec /* = 2294 */: return property_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmrange /* = 2295 */: return rangeMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmreal_typespec /* = 2297 */: return real_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmreal_var /* = 2298 */: return real_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmref_module /* = 2299 */: return ref_moduleMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmref_obj /* = 2301 */: return ref_objMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmref_typespec /* = 2303 */: return ref_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmref_var /* = 2304 */: return ref_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmreg /* = 2305 */: return regMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmreg_array /* = 2306 */: return reg_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmrelease /* = 2308 */: return releaseMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmrepeat /* = 2309 */: return repeatMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmrepeat_control /* = 2310 */: return repeat_controlMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmrestrict /* = 2312 */: return restrictMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmreturn_stmt /* = 2314 */: return return_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmseq_formal_decl /* = 2321 */: return seq_formal_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmsequence_decl /* = 2324 */: return sequence_declMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmsequence_inst /* = 2328 */: return sequence_instMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmsequence_typespec /* = 2329 */: return sequence_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmshort_int_typespec /* = 2330 */: return short_int_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmshort_int_var /* = 2331 */: return short_int_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmshort_real_typespec /* = 2332 */: return short_real_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmshort_real_var /* = 2333 */: return short_real_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmsoft_disable /* = 2337 */: return soft_disableMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmspec_param /* = 2340 */: return spec_paramMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmstring_typespec /* = 2344 */: return string_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmstring_var /* = 2345 */: return string_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmstruct_net /* = 2346 */: return struct_netMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmstruct_pattern /* = 2347 */: return struct_patternMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmstruct_typespec /* = 2348 */: return struct_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmstruct_var /* = 2349 */: return struct_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmswitch_array /* = 2350 */: return switch_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmswitch_tran /* = 2351 */: return switch_tranMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmsys_func_call /* = 2352 */: return sys_func_callMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmsys_task_call /* = 2354 */: return sys_task_callMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtable_entry /* = 2355 */: return table_entryMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtagged_pattern /* = 2357 */: return tagged_patternMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtask /* = 2358 */: return taskMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtask_call /* = 2359 */: return task_callMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtchk /* = 2364 */: return tchkMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtchk_term /* = 2367 */: return tchk_termMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmthread_obj /* = 2372 */: return thread_objMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtime_net /* = 2374 */: return time_netMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtime_typespec /* = 2375 */: return time_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtime_var /* = 2376 */: return time_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtype_parameter /* = 2379 */: return type_parameterMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmtypespec_member /* = 2382 */: return typespec_memberMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmudp /* = 2384 */: return udpMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmudp_array /* = 2385 */: return udp_arrayMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmudp_defn /* = 2386 */: return udp_defnMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmunion_typespec /* = 2387 */: return union_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmunion_var /* = 2388 */: return union_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmunsupported_expr /* = 2389 */: return unsupported_exprMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmunsupported_stmt /* = 2390 */: return unsupported_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmunsupported_typespec /* = 2391 */: return unsupported_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmuser_systf /* = 2392 */: return user_systfMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmvar_bit /* = 2394 */: return var_bitMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmvar_select /* = 2396 */: return var_selectMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmvirtual_interface_var /* = 2405 */: return virtual_interface_varMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmvoid_typespec /* = 2407 */: return void_typespecMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmwait_fork /* = 2428 */: return wait_forkMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmwait_stmt /* = 2429 */: return wait_stmtMaker.objects_[index];
    case UHDM_OBJECT_TYPE::uhdmwhile_stmt /* = 2432 */: return while_stmtMaker.objects_[index];
    default: return nullptr;
  }
}

attribute* Serializer::MakeAttribute() { return Make<attribute>(&attributeMaker); }
std::vector<attribute*>* Serializer::MakeAttributeVec() { return Make<attribute>(&attributeVectMaker); }
virtual_interface_var* Serializer::MakeVirtual_interface_var() { return Make<virtual_interface_var>(&virtual_interface_varMaker); }
std::vector<virtual_interface_var*>* Serializer::MakeVirtual_interface_varVec() { return Make<virtual_interface_var>(&virtual_interface_varVectMaker); }
let_decl* Serializer::MakeLet_decl() { return Make<let_decl>(&let_declMaker); }
std::vector<let_decl*>* Serializer::MakeLet_declVec() { return Make<let_decl>(&let_declVectMaker); }
std::vector<concurrent_assertions*>* Serializer::MakeConcurrent_assertionsVec() { return Make<concurrent_assertions>(&concurrent_assertionsVectMaker); }
std::vector<process_stmt*>* Serializer::MakeProcess_stmtVec() { return Make<process_stmt>(&process_stmtVectMaker); }
always* Serializer::MakeAlways() { return Make<always>(&alwaysMaker); }
std::vector<always*>* Serializer::MakeAlwaysVec() { return Make<always>(&alwaysVectMaker); }
final_stmt* Serializer::MakeFinal_stmt() { return Make<final_stmt>(&final_stmtMaker); }
std::vector<final_stmt*>* Serializer::MakeFinal_stmtVec() { return Make<final_stmt>(&final_stmtVectMaker); }
initial* Serializer::MakeInitial() { return Make<initial>(&initialMaker); }
std::vector<initial*>* Serializer::MakeInitialVec() { return Make<initial>(&initialVectMaker); }
std::vector<atomic_stmt*>* Serializer::MakeAtomic_stmtVec() { return Make<atomic_stmt>(&atomic_stmtVectMaker); }
delay_control* Serializer::MakeDelay_control() { return Make<delay_control>(&delay_controlMaker); }
std::vector<delay_control*>* Serializer::MakeDelay_controlVec() { return Make<delay_control>(&delay_controlVectMaker); }
delay_term* Serializer::MakeDelay_term() { return Make<delay_term>(&delay_termMaker); }
std::vector<delay_term*>* Serializer::MakeDelay_termVec() { return Make<delay_term>(&delay_termVectMaker); }
event_control* Serializer::MakeEvent_control() { return Make<event_control>(&event_controlMaker); }
std::vector<event_control*>* Serializer::MakeEvent_controlVec() { return Make<event_control>(&event_controlVectMaker); }
repeat_control* Serializer::MakeRepeat_control() { return Make<repeat_control>(&repeat_controlMaker); }
std::vector<repeat_control*>* Serializer::MakeRepeat_controlVec() { return Make<repeat_control>(&repeat_controlVectMaker); }
std::vector<scope*>* Serializer::MakeScopeVec() { return Make<scope>(&scopeVectMaker); }
begin* Serializer::MakeBegin() { return Make<begin>(&beginMaker); }
std::vector<begin*>* Serializer::MakeBeginVec() { return Make<begin>(&beginVectMaker); }
named_begin* Serializer::MakeNamed_begin() { return Make<named_begin>(&named_beginMaker); }
std::vector<named_begin*>* Serializer::MakeNamed_beginVec() { return Make<named_begin>(&named_beginVectMaker); }
named_fork* Serializer::MakeNamed_fork() { return Make<named_fork>(&named_forkMaker); }
std::vector<named_fork*>* Serializer::MakeNamed_forkVec() { return Make<named_fork>(&named_forkVectMaker); }
fork_stmt* Serializer::MakeFork_stmt() { return Make<fork_stmt>(&fork_stmtMaker); }
std::vector<fork_stmt*>* Serializer::MakeFork_stmtVec() { return Make<fork_stmt>(&fork_stmtVectMaker); }
for_stmt* Serializer::MakeFor_stmt() { return Make<for_stmt>(&for_stmtMaker); }
std::vector<for_stmt*>* Serializer::MakeFor_stmtVec() { return Make<for_stmt>(&for_stmtVectMaker); }
if_stmt* Serializer::MakeIf_stmt() { return Make<if_stmt>(&if_stmtMaker); }
std::vector<if_stmt*>* Serializer::MakeIf_stmtVec() { return Make<if_stmt>(&if_stmtVectMaker); }
event_stmt* Serializer::MakeEvent_stmt() { return Make<event_stmt>(&event_stmtMaker); }
std::vector<event_stmt*>* Serializer::MakeEvent_stmtVec() { return Make<event_stmt>(&event_stmtVectMaker); }
thread_obj* Serializer::MakeThread_obj() { return Make<thread_obj>(&thread_objMaker); }
std::vector<thread_obj*>* Serializer::MakeThread_objVec() { return Make<thread_obj>(&thread_objVectMaker); }
forever_stmt* Serializer::MakeForever_stmt() { return Make<forever_stmt>(&forever_stmtMaker); }
std::vector<forever_stmt*>* Serializer::MakeForever_stmtVec() { return Make<forever_stmt>(&forever_stmtVectMaker); }
std::vector<waits*>* Serializer::MakeWaitsVec() { return Make<waits>(&waitsVectMaker); }
wait_stmt* Serializer::MakeWait_stmt() { return Make<wait_stmt>(&wait_stmtMaker); }
std::vector<wait_stmt*>* Serializer::MakeWait_stmtVec() { return Make<wait_stmt>(&wait_stmtVectMaker); }
wait_fork* Serializer::MakeWait_fork() { return Make<wait_fork>(&wait_forkMaker); }
std::vector<wait_fork*>* Serializer::MakeWait_forkVec() { return Make<wait_fork>(&wait_forkVectMaker); }
ordered_wait* Serializer::MakeOrdered_wait() { return Make<ordered_wait>(&ordered_waitMaker); }
std::vector<ordered_wait*>* Serializer::MakeOrdered_waitVec() { return Make<ordered_wait>(&ordered_waitVectMaker); }
std::vector<disables*>* Serializer::MakeDisablesVec() { return Make<disables>(&disablesVectMaker); }
disable* Serializer::MakeDisable() { return Make<disable>(&disableMaker); }
std::vector<disable*>* Serializer::MakeDisableVec() { return Make<disable>(&disableVectMaker); }
disable_fork* Serializer::MakeDisable_fork() { return Make<disable_fork>(&disable_forkMaker); }
std::vector<disable_fork*>* Serializer::MakeDisable_forkVec() { return Make<disable_fork>(&disable_forkVectMaker); }
continue_stmt* Serializer::MakeContinue_stmt() { return Make<continue_stmt>(&continue_stmtMaker); }
std::vector<continue_stmt*>* Serializer::MakeContinue_stmtVec() { return Make<continue_stmt>(&continue_stmtVectMaker); }
break_stmt* Serializer::MakeBreak_stmt() { return Make<break_stmt>(&break_stmtMaker); }
std::vector<break_stmt*>* Serializer::MakeBreak_stmtVec() { return Make<break_stmt>(&break_stmtVectMaker); }
return_stmt* Serializer::MakeReturn_stmt() { return Make<return_stmt>(&return_stmtMaker); }
std::vector<return_stmt*>* Serializer::MakeReturn_stmtVec() { return Make<return_stmt>(&return_stmtVectMaker); }
while_stmt* Serializer::MakeWhile_stmt() { return Make<while_stmt>(&while_stmtMaker); }
std::vector<while_stmt*>* Serializer::MakeWhile_stmtVec() { return Make<while_stmt>(&while_stmtVectMaker); }
repeat* Serializer::MakeRepeat() { return Make<repeat>(&repeatMaker); }
std::vector<repeat*>* Serializer::MakeRepeatVec() { return Make<repeat>(&repeatVectMaker); }
do_while* Serializer::MakeDo_while() { return Make<do_while>(&do_whileMaker); }
std::vector<do_while*>* Serializer::MakeDo_whileVec() { return Make<do_while>(&do_whileVectMaker); }
if_else* Serializer::MakeIf_else() { return Make<if_else>(&if_elseMaker); }
std::vector<if_else*>* Serializer::MakeIf_elseVec() { return Make<if_else>(&if_elseVectMaker); }
case_stmt* Serializer::MakeCase_stmt() { return Make<case_stmt>(&case_stmtMaker); }
std::vector<case_stmt*>* Serializer::MakeCase_stmtVec() { return Make<case_stmt>(&case_stmtVectMaker); }
force* Serializer::MakeForce() { return Make<force>(&forceMaker); }
std::vector<force*>* Serializer::MakeForceVec() { return Make<force>(&forceVectMaker); }
assign_stmt* Serializer::MakeAssign_stmt() { return Make<assign_stmt>(&assign_stmtMaker); }
std::vector<assign_stmt*>* Serializer::MakeAssign_stmtVec() { return Make<assign_stmt>(&assign_stmtVectMaker); }
deassign* Serializer::MakeDeassign() { return Make<deassign>(&deassignMaker); }
std::vector<deassign*>* Serializer::MakeDeassignVec() { return Make<deassign>(&deassignVectMaker); }
release* Serializer::MakeRelease() { return Make<release>(&releaseMaker); }
std::vector<release*>* Serializer::MakeReleaseVec() { return Make<release>(&releaseVectMaker); }
null_stmt* Serializer::MakeNull_stmt() { return Make<null_stmt>(&null_stmtMaker); }
std::vector<null_stmt*>* Serializer::MakeNull_stmtVec() { return Make<null_stmt>(&null_stmtVectMaker); }
expect_stmt* Serializer::MakeExpect_stmt() { return Make<expect_stmt>(&expect_stmtMaker); }
std::vector<expect_stmt*>* Serializer::MakeExpect_stmtVec() { return Make<expect_stmt>(&expect_stmtVectMaker); }
foreach_stmt* Serializer::MakeForeach_stmt() { return Make<foreach_stmt>(&foreach_stmtMaker); }
std::vector<foreach_stmt*>* Serializer::MakeForeach_stmtVec() { return Make<foreach_stmt>(&foreach_stmtVectMaker); }
gen_scope* Serializer::MakeGen_scope() { return Make<gen_scope>(&gen_scopeMaker); }
std::vector<gen_scope*>* Serializer::MakeGen_scopeVec() { return Make<gen_scope>(&gen_scopeVectMaker); }
gen_var* Serializer::MakeGen_var() { return Make<gen_var>(&gen_varMaker); }
std::vector<gen_var*>* Serializer::MakeGen_varVec() { return Make<gen_var>(&gen_varVectMaker); }
gen_scope_array* Serializer::MakeGen_scope_array() { return Make<gen_scope_array>(&gen_scope_arrayMaker); }
std::vector<gen_scope_array*>* Serializer::MakeGen_scope_arrayVec() { return Make<gen_scope_array>(&gen_scope_arrayVectMaker); }
assert_stmt* Serializer::MakeAssert_stmt() { return Make<assert_stmt>(&assert_stmtMaker); }
std::vector<assert_stmt*>* Serializer::MakeAssert_stmtVec() { return Make<assert_stmt>(&assert_stmtVectMaker); }
cover* Serializer::MakeCover() { return Make<cover>(&coverMaker); }
std::vector<cover*>* Serializer::MakeCoverVec() { return Make<cover>(&coverVectMaker); }
assume* Serializer::MakeAssume() { return Make<assume>(&assumeMaker); }
std::vector<assume*>* Serializer::MakeAssumeVec() { return Make<assume>(&assumeVectMaker); }
restrict* Serializer::MakeRestrict() { return Make<restrict>(&restrictMaker); }
std::vector<restrict*>* Serializer::MakeRestrictVec() { return Make<restrict>(&restrictVectMaker); }
immediate_assert* Serializer::MakeImmediate_assert() { return Make<immediate_assert>(&immediate_assertMaker); }
std::vector<immediate_assert*>* Serializer::MakeImmediate_assertVec() { return Make<immediate_assert>(&immediate_assertVectMaker); }
immediate_assume* Serializer::MakeImmediate_assume() { return Make<immediate_assume>(&immediate_assumeMaker); }
std::vector<immediate_assume*>* Serializer::MakeImmediate_assumeVec() { return Make<immediate_assume>(&immediate_assumeVectMaker); }
immediate_cover* Serializer::MakeImmediate_cover() { return Make<immediate_cover>(&immediate_coverMaker); }
std::vector<immediate_cover*>* Serializer::MakeImmediate_coverVec() { return Make<immediate_cover>(&immediate_coverVectMaker); }
std::vector<expr*>* Serializer::MakeExprVec() { return Make<expr>(&exprVectMaker); }
case_item* Serializer::MakeCase_item() { return Make<case_item>(&case_itemMaker); }
std::vector<case_item*>* Serializer::MakeCase_itemVec() { return Make<case_item>(&case_itemVectMaker); }
assignment* Serializer::MakeAssignment() { return Make<assignment>(&assignmentMaker); }
std::vector<assignment*>* Serializer::MakeAssignmentVec() { return Make<assignment>(&assignmentVectMaker); }
any_pattern* Serializer::MakeAny_pattern() { return Make<any_pattern>(&any_patternMaker); }
std::vector<any_pattern*>* Serializer::MakeAny_patternVec() { return Make<any_pattern>(&any_patternVectMaker); }
tagged_pattern* Serializer::MakeTagged_pattern() { return Make<tagged_pattern>(&tagged_patternMaker); }
std::vector<tagged_pattern*>* Serializer::MakeTagged_patternVec() { return Make<tagged_pattern>(&tagged_patternVectMaker); }
struct_pattern* Serializer::MakeStruct_pattern() { return Make<struct_pattern>(&struct_patternMaker); }
std::vector<struct_pattern*>* Serializer::MakeStruct_patternVec() { return Make<struct_pattern>(&struct_patternVectMaker); }
unsupported_expr* Serializer::MakeUnsupported_expr() { return Make<unsupported_expr>(&unsupported_exprMaker); }
std::vector<unsupported_expr*>* Serializer::MakeUnsupported_exprVec() { return Make<unsupported_expr>(&unsupported_exprVectMaker); }
unsupported_stmt* Serializer::MakeUnsupported_stmt() { return Make<unsupported_stmt>(&unsupported_stmtMaker); }
std::vector<unsupported_stmt*>* Serializer::MakeUnsupported_stmtVec() { return Make<unsupported_stmt>(&unsupported_stmtVectMaker); }
include_file_info* Serializer::MakeInclude_file_info() { return Make<include_file_info>(&include_file_infoMaker); }
std::vector<include_file_info*>* Serializer::MakeInclude_file_infoVec() { return Make<include_file_info>(&include_file_infoVectMaker); }
sequence_inst* Serializer::MakeSequence_inst() { return Make<sequence_inst>(&sequence_instMaker); }
std::vector<sequence_inst*>* Serializer::MakeSequence_instVec() { return Make<sequence_inst>(&sequence_instVectMaker); }
seq_formal_decl* Serializer::MakeSeq_formal_decl() { return Make<seq_formal_decl>(&seq_formal_declMaker); }
std::vector<seq_formal_decl*>* Serializer::MakeSeq_formal_declVec() { return Make<seq_formal_decl>(&seq_formal_declVectMaker); }
sequence_decl* Serializer::MakeSequence_decl() { return Make<sequence_decl>(&sequence_declMaker); }
std::vector<sequence_decl*>* Serializer::MakeSequence_declVec() { return Make<sequence_decl>(&sequence_declVectMaker); }
prop_formal_decl* Serializer::MakeProp_formal_decl() { return Make<prop_formal_decl>(&prop_formal_declMaker); }
std::vector<prop_formal_decl*>* Serializer::MakeProp_formal_declVec() { return Make<prop_formal_decl>(&prop_formal_declVectMaker); }
property_inst* Serializer::MakeProperty_inst() { return Make<property_inst>(&property_instMaker); }
std::vector<property_inst*>* Serializer::MakeProperty_instVec() { return Make<property_inst>(&property_instVectMaker); }
property_spec* Serializer::MakeProperty_spec() { return Make<property_spec>(&property_specMaker); }
std::vector<property_spec*>* Serializer::MakeProperty_specVec() { return Make<property_spec>(&property_specVectMaker); }
property_decl* Serializer::MakeProperty_decl() { return Make<property_decl>(&property_declMaker); }
std::vector<property_decl*>* Serializer::MakeProperty_declVec() { return Make<property_decl>(&property_declVectMaker); }
clocked_property* Serializer::MakeClocked_property() { return Make<clocked_property>(&clocked_propertyMaker); }
std::vector<clocked_property*>* Serializer::MakeClocked_propertyVec() { return Make<clocked_property>(&clocked_propertyVectMaker); }
case_property_item* Serializer::MakeCase_property_item() { return Make<case_property_item>(&case_property_itemMaker); }
std::vector<case_property_item*>* Serializer::MakeCase_property_itemVec() { return Make<case_property_item>(&case_property_itemVectMaker); }
case_property* Serializer::MakeCase_property() { return Make<case_property>(&case_propertyMaker); }
std::vector<case_property*>* Serializer::MakeCase_propertyVec() { return Make<case_property>(&case_propertyVectMaker); }
multiclock_sequence_expr* Serializer::MakeMulticlock_sequence_expr() { return Make<multiclock_sequence_expr>(&multiclock_sequence_exprMaker); }
std::vector<multiclock_sequence_expr*>* Serializer::MakeMulticlock_sequence_exprVec() { return Make<multiclock_sequence_expr>(&multiclock_sequence_exprVectMaker); }
clocked_seq* Serializer::MakeClocked_seq() { return Make<clocked_seq>(&clocked_seqMaker); }
std::vector<clocked_seq*>* Serializer::MakeClocked_seqVec() { return Make<clocked_seq>(&clocked_seqVectMaker); }
std::vector<simple_expr*>* Serializer::MakeSimple_exprVec() { return Make<simple_expr>(&simple_exprVectMaker); }
constant* Serializer::MakeConstant() { return Make<constant>(&constantMaker); }
std::vector<constant*>* Serializer::MakeConstantVec() { return Make<constant>(&constantVectMaker); }
let_expr* Serializer::MakeLet_expr() { return Make<let_expr>(&let_exprMaker); }
std::vector<let_expr*>* Serializer::MakeLet_exprVec() { return Make<let_expr>(&let_exprVectMaker); }
operation* Serializer::MakeOperation() { return Make<operation>(&operationMaker); }
std::vector<operation*>* Serializer::MakeOperationVec() { return Make<operation>(&operationVectMaker); }
ref_obj* Serializer::MakeRef_obj() { return Make<ref_obj>(&ref_objMaker); }
std::vector<ref_obj*>* Serializer::MakeRef_objVec() { return Make<ref_obj>(&ref_objVectMaker); }
ref_module* Serializer::MakeRef_module() { return Make<ref_module>(&ref_moduleMaker); }
std::vector<ref_module*>* Serializer::MakeRef_moduleVec() { return Make<ref_module>(&ref_moduleVectMaker); }
ref_typespec* Serializer::MakeRef_typespec() { return Make<ref_typespec>(&ref_typespecMaker); }
std::vector<ref_typespec*>* Serializer::MakeRef_typespecVec() { return Make<ref_typespec>(&ref_typespecVectMaker); }
part_select* Serializer::MakePart_select() { return Make<part_select>(&part_selectMaker); }
std::vector<part_select*>* Serializer::MakePart_selectVec() { return Make<part_select>(&part_selectVectMaker); }
indexed_part_select* Serializer::MakeIndexed_part_select() { return Make<indexed_part_select>(&indexed_part_selectMaker); }
std::vector<indexed_part_select*>* Serializer::MakeIndexed_part_selectVec() { return Make<indexed_part_select>(&indexed_part_selectVectMaker); }
var_select* Serializer::MakeVar_select() { return Make<var_select>(&var_selectMaker); }
std::vector<var_select*>* Serializer::MakeVar_selectVec() { return Make<var_select>(&var_selectVectMaker); }
bit_select* Serializer::MakeBit_select() { return Make<bit_select>(&bit_selectMaker); }
std::vector<bit_select*>* Serializer::MakeBit_selectVec() { return Make<bit_select>(&bit_selectVectMaker); }
std::vector<variables*>* Serializer::MakeVariablesVec() { return Make<variables>(&variablesVectMaker); }
hier_path* Serializer::MakeHier_path() { return Make<hier_path>(&hier_pathMaker); }
std::vector<hier_path*>* Serializer::MakeHier_pathVec() { return Make<hier_path>(&hier_pathVectMaker); }
ref_var* Serializer::MakeRef_var() { return Make<ref_var>(&ref_varMaker); }
std::vector<ref_var*>* Serializer::MakeRef_varVec() { return Make<ref_var>(&ref_varVectMaker); }
short_real_var* Serializer::MakeShort_real_var() { return Make<short_real_var>(&short_real_varMaker); }
std::vector<short_real_var*>* Serializer::MakeShort_real_varVec() { return Make<short_real_var>(&short_real_varVectMaker); }
real_var* Serializer::MakeReal_var() { return Make<real_var>(&real_varMaker); }
std::vector<real_var*>* Serializer::MakeReal_varVec() { return Make<real_var>(&real_varVectMaker); }
byte_var* Serializer::MakeByte_var() { return Make<byte_var>(&byte_varMaker); }
std::vector<byte_var*>* Serializer::MakeByte_varVec() { return Make<byte_var>(&byte_varVectMaker); }
short_int_var* Serializer::MakeShort_int_var() { return Make<short_int_var>(&short_int_varMaker); }
std::vector<short_int_var*>* Serializer::MakeShort_int_varVec() { return Make<short_int_var>(&short_int_varVectMaker); }
int_var* Serializer::MakeInt_var() { return Make<int_var>(&int_varMaker); }
std::vector<int_var*>* Serializer::MakeInt_varVec() { return Make<int_var>(&int_varVectMaker); }
long_int_var* Serializer::MakeLong_int_var() { return Make<long_int_var>(&long_int_varMaker); }
std::vector<long_int_var*>* Serializer::MakeLong_int_varVec() { return Make<long_int_var>(&long_int_varVectMaker); }
integer_var* Serializer::MakeInteger_var() { return Make<integer_var>(&integer_varMaker); }
std::vector<integer_var*>* Serializer::MakeInteger_varVec() { return Make<integer_var>(&integer_varVectMaker); }
time_var* Serializer::MakeTime_var() { return Make<time_var>(&time_varMaker); }
std::vector<time_var*>* Serializer::MakeTime_varVec() { return Make<time_var>(&time_varVectMaker); }
array_var* Serializer::MakeArray_var() { return Make<array_var>(&array_varMaker); }
std::vector<array_var*>* Serializer::MakeArray_varVec() { return Make<array_var>(&array_varVectMaker); }
array_expr* Serializer::MakeArray_expr() { return Make<array_expr>(&array_exprMaker); }
std::vector<array_expr*>* Serializer::MakeArray_exprVec() { return Make<array_expr>(&array_exprVectMaker); }
reg_array* Serializer::MakeReg_array() { return Make<reg_array>(&reg_arrayMaker); }
std::vector<reg_array*>* Serializer::MakeReg_arrayVec() { return Make<reg_array>(&reg_arrayVectMaker); }
reg* Serializer::MakeReg() { return Make<reg>(&regMaker); }
std::vector<reg*>* Serializer::MakeRegVec() { return Make<reg>(&regVectMaker); }
packed_array_var* Serializer::MakePacked_array_var() { return Make<packed_array_var>(&packed_array_varMaker); }
std::vector<packed_array_var*>* Serializer::MakePacked_array_varVec() { return Make<packed_array_var>(&packed_array_varVectMaker); }
bit_var* Serializer::MakeBit_var() { return Make<bit_var>(&bit_varMaker); }
std::vector<bit_var*>* Serializer::MakeBit_varVec() { return Make<bit_var>(&bit_varVectMaker); }
logic_var* Serializer::MakeLogic_var() { return Make<logic_var>(&logic_varMaker); }
std::vector<logic_var*>* Serializer::MakeLogic_varVec() { return Make<logic_var>(&logic_varVectMaker); }
struct_var* Serializer::MakeStruct_var() { return Make<struct_var>(&struct_varMaker); }
std::vector<struct_var*>* Serializer::MakeStruct_varVec() { return Make<struct_var>(&struct_varVectMaker); }
union_var* Serializer::MakeUnion_var() { return Make<union_var>(&union_varMaker); }
std::vector<union_var*>* Serializer::MakeUnion_varVec() { return Make<union_var>(&union_varVectMaker); }
enum_var* Serializer::MakeEnum_var() { return Make<enum_var>(&enum_varMaker); }
std::vector<enum_var*>* Serializer::MakeEnum_varVec() { return Make<enum_var>(&enum_varVectMaker); }
string_var* Serializer::MakeString_var() { return Make<string_var>(&string_varMaker); }
std::vector<string_var*>* Serializer::MakeString_varVec() { return Make<string_var>(&string_varVectMaker); }
chandle_var* Serializer::MakeChandle_var() { return Make<chandle_var>(&chandle_varMaker); }
std::vector<chandle_var*>* Serializer::MakeChandle_varVec() { return Make<chandle_var>(&chandle_varVectMaker); }
var_bit* Serializer::MakeVar_bit() { return Make<var_bit>(&var_bitMaker); }
std::vector<var_bit*>* Serializer::MakeVar_bitVec() { return Make<var_bit>(&var_bitVectMaker); }
std::vector<task_func*>* Serializer::MakeTask_funcVec() { return Make<task_func>(&task_funcVectMaker); }
task* Serializer::MakeTask() { return Make<task>(&taskMaker); }
std::vector<task*>* Serializer::MakeTaskVec() { return Make<task>(&taskVectMaker); }
function* Serializer::MakeFunction() { return Make<function>(&functionMaker); }
std::vector<function*>* Serializer::MakeFunctionVec() { return Make<function>(&functionVectMaker); }
modport* Serializer::MakeModport() { return Make<modport>(&modportMaker); }
std::vector<modport*>* Serializer::MakeModportVec() { return Make<modport>(&modportVectMaker); }
interface_tf_decl* Serializer::MakeInterface_tf_decl() { return Make<interface_tf_decl>(&interface_tf_declMaker); }
std::vector<interface_tf_decl*>* Serializer::MakeInterface_tf_declVec() { return Make<interface_tf_decl>(&interface_tf_declVectMaker); }
cont_assign* Serializer::MakeCont_assign() { return Make<cont_assign>(&cont_assignMaker); }
std::vector<cont_assign*>* Serializer::MakeCont_assignVec() { return Make<cont_assign>(&cont_assignVectMaker); }
cont_assign_bit* Serializer::MakeCont_assign_bit() { return Make<cont_assign_bit>(&cont_assign_bitMaker); }
std::vector<cont_assign_bit*>* Serializer::MakeCont_assign_bitVec() { return Make<cont_assign_bit>(&cont_assign_bitVectMaker); }
std::vector<ports*>* Serializer::MakePortsVec() { return Make<ports>(&portsVectMaker); }
port* Serializer::MakePort() { return Make<port>(&portMaker); }
std::vector<port*>* Serializer::MakePortVec() { return Make<port>(&portVectMaker); }
port_bit* Serializer::MakePort_bit() { return Make<port_bit>(&port_bitMaker); }
std::vector<port_bit*>* Serializer::MakePort_bitVec() { return Make<port_bit>(&port_bitVectMaker); }
checker_port* Serializer::MakeChecker_port() { return Make<checker_port>(&checker_portMaker); }
std::vector<checker_port*>* Serializer::MakeChecker_portVec() { return Make<checker_port>(&checker_portVectMaker); }
checker_inst_port* Serializer::MakeChecker_inst_port() { return Make<checker_inst_port>(&checker_inst_portMaker); }
std::vector<checker_inst_port*>* Serializer::MakeChecker_inst_portVec() { return Make<checker_inst_port>(&checker_inst_portVectMaker); }
std::vector<primitive*>* Serializer::MakePrimitiveVec() { return Make<primitive>(&primitiveVectMaker); }
gate* Serializer::MakeGate() { return Make<gate>(&gateMaker); }
std::vector<gate*>* Serializer::MakeGateVec() { return Make<gate>(&gateVectMaker); }
switch_tran* Serializer::MakeSwitch_tran() { return Make<switch_tran>(&switch_tranMaker); }
std::vector<switch_tran*>* Serializer::MakeSwitch_tranVec() { return Make<switch_tran>(&switch_tranVectMaker); }
udp* Serializer::MakeUdp() { return Make<udp>(&udpMaker); }
std::vector<udp*>* Serializer::MakeUdpVec() { return Make<udp>(&udpVectMaker); }
mod_path* Serializer::MakeMod_path() { return Make<mod_path>(&mod_pathMaker); }
std::vector<mod_path*>* Serializer::MakeMod_pathVec() { return Make<mod_path>(&mod_pathVectMaker); }
tchk* Serializer::MakeTchk() { return Make<tchk>(&tchkMaker); }
std::vector<tchk*>* Serializer::MakeTchkVec() { return Make<tchk>(&tchkVectMaker); }
range* Serializer::MakeRange() { return Make<range>(&rangeMaker); }
std::vector<range*>* Serializer::MakeRangeVec() { return Make<range>(&rangeVectMaker); }
udp_defn* Serializer::MakeUdp_defn() { return Make<udp_defn>(&udp_defnMaker); }
std::vector<udp_defn*>* Serializer::MakeUdp_defnVec() { return Make<udp_defn>(&udp_defnVectMaker); }
table_entry* Serializer::MakeTable_entry() { return Make<table_entry>(&table_entryMaker); }
std::vector<table_entry*>* Serializer::MakeTable_entryVec() { return Make<table_entry>(&table_entryVectMaker); }
io_decl* Serializer::MakeIo_decl() { return Make<io_decl>(&io_declMaker); }
std::vector<io_decl*>* Serializer::MakeIo_declVec() { return Make<io_decl>(&io_declVectMaker); }
alias_stmt* Serializer::MakeAlias_stmt() { return Make<alias_stmt>(&alias_stmtMaker); }
std::vector<alias_stmt*>* Serializer::MakeAlias_stmtVec() { return Make<alias_stmt>(&alias_stmtVectMaker); }
clocking_block* Serializer::MakeClocking_block() { return Make<clocking_block>(&clocking_blockMaker); }
std::vector<clocking_block*>* Serializer::MakeClocking_blockVec() { return Make<clocking_block>(&clocking_blockVectMaker); }
clocking_io_decl* Serializer::MakeClocking_io_decl() { return Make<clocking_io_decl>(&clocking_io_declMaker); }
std::vector<clocking_io_decl*>* Serializer::MakeClocking_io_declVec() { return Make<clocking_io_decl>(&clocking_io_declVectMaker); }
param_assign* Serializer::MakeParam_assign() { return Make<param_assign>(&param_assignMaker); }
std::vector<param_assign*>* Serializer::MakeParam_assignVec() { return Make<param_assign>(&param_assignVectMaker); }
std::vector<instance_array*>* Serializer::MakeInstance_arrayVec() { return Make<instance_array>(&instance_arrayVectMaker); }
interface_array* Serializer::MakeInterface_array() { return Make<interface_array>(&interface_arrayMaker); }
std::vector<interface_array*>* Serializer::MakeInterface_arrayVec() { return Make<interface_array>(&interface_arrayVectMaker); }
program_array* Serializer::MakeProgram_array() { return Make<program_array>(&program_arrayMaker); }
std::vector<program_array*>* Serializer::MakeProgram_arrayVec() { return Make<program_array>(&program_arrayVectMaker); }
module_array* Serializer::MakeModule_array() { return Make<module_array>(&module_arrayMaker); }
std::vector<module_array*>* Serializer::MakeModule_arrayVec() { return Make<module_array>(&module_arrayVectMaker); }
std::vector<primitive_array*>* Serializer::MakePrimitive_arrayVec() { return Make<primitive_array>(&primitive_arrayVectMaker); }
gate_array* Serializer::MakeGate_array() { return Make<gate_array>(&gate_arrayMaker); }
std::vector<gate_array*>* Serializer::MakeGate_arrayVec() { return Make<gate_array>(&gate_arrayVectMaker); }
switch_array* Serializer::MakeSwitch_array() { return Make<switch_array>(&switch_arrayMaker); }
std::vector<switch_array*>* Serializer::MakeSwitch_arrayVec() { return Make<switch_array>(&switch_arrayVectMaker); }
udp_array* Serializer::MakeUdp_array() { return Make<udp_array>(&udp_arrayMaker); }
std::vector<udp_array*>* Serializer::MakeUdp_arrayVec() { return Make<udp_array>(&udp_arrayVectMaker); }
std::vector<typespec*>* Serializer::MakeTypespecVec() { return Make<typespec>(&typespecVectMaker); }
std::vector<net_drivers*>* Serializer::MakeNet_driversVec() { return Make<net_drivers>(&net_driversVectMaker); }
std::vector<net_loads*>* Serializer::MakeNet_loadsVec() { return Make<net_loads>(&net_loadsVectMaker); }
prim_term* Serializer::MakePrim_term() { return Make<prim_term>(&prim_termMaker); }
std::vector<prim_term*>* Serializer::MakePrim_termVec() { return Make<prim_term>(&prim_termVectMaker); }
path_term* Serializer::MakePath_term() { return Make<path_term>(&path_termMaker); }
std::vector<path_term*>* Serializer::MakePath_termVec() { return Make<path_term>(&path_termVectMaker); }
tchk_term* Serializer::MakeTchk_term() { return Make<tchk_term>(&tchk_termMaker); }
std::vector<tchk_term*>* Serializer::MakeTchk_termVec() { return Make<tchk_term>(&tchk_termVectMaker); }
std::vector<nets*>* Serializer::MakeNetsVec() { return Make<nets>(&netsVectMaker); }
net_bit* Serializer::MakeNet_bit() { return Make<net_bit>(&net_bitMaker); }
std::vector<net_bit*>* Serializer::MakeNet_bitVec() { return Make<net_bit>(&net_bitVectMaker); }
std::vector<net*>* Serializer::MakeNetVec() { return Make<net>(&netVectMaker); }
struct_net* Serializer::MakeStruct_net() { return Make<struct_net>(&struct_netMaker); }
std::vector<struct_net*>* Serializer::MakeStruct_netVec() { return Make<struct_net>(&struct_netVectMaker); }
enum_net* Serializer::MakeEnum_net() { return Make<enum_net>(&enum_netMaker); }
std::vector<enum_net*>* Serializer::MakeEnum_netVec() { return Make<enum_net>(&enum_netVectMaker); }
integer_net* Serializer::MakeInteger_net() { return Make<integer_net>(&integer_netMaker); }
std::vector<integer_net*>* Serializer::MakeInteger_netVec() { return Make<integer_net>(&integer_netVectMaker); }
time_net* Serializer::MakeTime_net() { return Make<time_net>(&time_netMaker); }
std::vector<time_net*>* Serializer::MakeTime_netVec() { return Make<time_net>(&time_netVectMaker); }
logic_net* Serializer::MakeLogic_net() { return Make<logic_net>(&logic_netMaker); }
std::vector<logic_net*>* Serializer::MakeLogic_netVec() { return Make<logic_net>(&logic_netVectMaker); }
array_net* Serializer::MakeArray_net() { return Make<array_net>(&array_netMaker); }
std::vector<array_net*>* Serializer::MakeArray_netVec() { return Make<array_net>(&array_netVectMaker); }
packed_array_net* Serializer::MakePacked_array_net() { return Make<packed_array_net>(&packed_array_netMaker); }
std::vector<packed_array_net*>* Serializer::MakePacked_array_netVec() { return Make<packed_array_net>(&packed_array_netVectMaker); }
event_typespec* Serializer::MakeEvent_typespec() { return Make<event_typespec>(&event_typespecMaker); }
std::vector<event_typespec*>* Serializer::MakeEvent_typespecVec() { return Make<event_typespec>(&event_typespecVectMaker); }
named_event* Serializer::MakeNamed_event() { return Make<named_event>(&named_eventMaker); }
std::vector<named_event*>* Serializer::MakeNamed_eventVec() { return Make<named_event>(&named_eventVectMaker); }
named_event_array* Serializer::MakeNamed_event_array() { return Make<named_event_array>(&named_event_arrayMaker); }
std::vector<named_event_array*>* Serializer::MakeNamed_event_arrayVec() { return Make<named_event_array>(&named_event_arrayVectMaker); }
parameter* Serializer::MakeParameter() { return Make<parameter>(&parameterMaker); }
std::vector<parameter*>* Serializer::MakeParameterVec() { return Make<parameter>(&parameterVectMaker); }
def_param* Serializer::MakeDef_param() { return Make<def_param>(&def_paramMaker); }
std::vector<def_param*>* Serializer::MakeDef_paramVec() { return Make<def_param>(&def_paramVectMaker); }
spec_param* Serializer::MakeSpec_param() { return Make<spec_param>(&spec_paramMaker); }
std::vector<spec_param*>* Serializer::MakeSpec_paramVec() { return Make<spec_param>(&spec_paramVectMaker); }
class_typespec* Serializer::MakeClass_typespec() { return Make<class_typespec>(&class_typespecMaker); }
std::vector<class_typespec*>* Serializer::MakeClass_typespecVec() { return Make<class_typespec>(&class_typespecVectMaker); }
extends* Serializer::MakeExtends() { return Make<extends>(&extendsMaker); }
std::vector<extends*>* Serializer::MakeExtendsVec() { return Make<extends>(&extendsVectMaker); }
class_defn* Serializer::MakeClass_defn() { return Make<class_defn>(&class_defnMaker); }
std::vector<class_defn*>* Serializer::MakeClass_defnVec() { return Make<class_defn>(&class_defnVectMaker); }
class_obj* Serializer::MakeClass_obj() { return Make<class_obj>(&class_objMaker); }
std::vector<class_obj*>* Serializer::MakeClass_objVec() { return Make<class_obj>(&class_objVectMaker); }
class_var* Serializer::MakeClass_var() { return Make<class_var>(&class_varMaker); }
std::vector<class_var*>* Serializer::MakeClass_varVec() { return Make<class_var>(&class_varVectMaker); }
std::vector<instance*>* Serializer::MakeInstanceVec() { return Make<instance>(&instanceVectMaker); }
interface_inst* Serializer::MakeInterface_inst() { return Make<interface_inst>(&interface_instMaker); }
std::vector<interface_inst*>* Serializer::MakeInterface_instVec() { return Make<interface_inst>(&interface_instVectMaker); }
program* Serializer::MakeProgram() { return Make<program>(&programMaker); }
std::vector<program*>* Serializer::MakeProgramVec() { return Make<program>(&programVectMaker); }
package* Serializer::MakePackage() { return Make<package>(&packageMaker); }
std::vector<package*>* Serializer::MakePackageVec() { return Make<package>(&packageVectMaker); }
module_inst* Serializer::MakeModule_inst() { return Make<module_inst>(&module_instMaker); }
std::vector<module_inst*>* Serializer::MakeModule_instVec() { return Make<module_inst>(&module_instVectMaker); }
checker_decl* Serializer::MakeChecker_decl() { return Make<checker_decl>(&checker_declMaker); }
std::vector<checker_decl*>* Serializer::MakeChecker_declVec() { return Make<checker_decl>(&checker_declVectMaker); }
checker_inst* Serializer::MakeChecker_inst() { return Make<checker_inst>(&checker_instMaker); }
std::vector<checker_inst*>* Serializer::MakeChecker_instVec() { return Make<checker_inst>(&checker_instVectMaker); }
short_real_typespec* Serializer::MakeShort_real_typespec() { return Make<short_real_typespec>(&short_real_typespecMaker); }
std::vector<short_real_typespec*>* Serializer::MakeShort_real_typespecVec() { return Make<short_real_typespec>(&short_real_typespecVectMaker); }
real_typespec* Serializer::MakeReal_typespec() { return Make<real_typespec>(&real_typespecMaker); }
std::vector<real_typespec*>* Serializer::MakeReal_typespecVec() { return Make<real_typespec>(&real_typespecVectMaker); }
byte_typespec* Serializer::MakeByte_typespec() { return Make<byte_typespec>(&byte_typespecMaker); }
std::vector<byte_typespec*>* Serializer::MakeByte_typespecVec() { return Make<byte_typespec>(&byte_typespecVectMaker); }
short_int_typespec* Serializer::MakeShort_int_typespec() { return Make<short_int_typespec>(&short_int_typespecMaker); }
std::vector<short_int_typespec*>* Serializer::MakeShort_int_typespecVec() { return Make<short_int_typespec>(&short_int_typespecVectMaker); }
int_typespec* Serializer::MakeInt_typespec() { return Make<int_typespec>(&int_typespecMaker); }
std::vector<int_typespec*>* Serializer::MakeInt_typespecVec() { return Make<int_typespec>(&int_typespecVectMaker); }
long_int_typespec* Serializer::MakeLong_int_typespec() { return Make<long_int_typespec>(&long_int_typespecMaker); }
std::vector<long_int_typespec*>* Serializer::MakeLong_int_typespecVec() { return Make<long_int_typespec>(&long_int_typespecVectMaker); }
integer_typespec* Serializer::MakeInteger_typespec() { return Make<integer_typespec>(&integer_typespecMaker); }
std::vector<integer_typespec*>* Serializer::MakeInteger_typespecVec() { return Make<integer_typespec>(&integer_typespecVectMaker); }
time_typespec* Serializer::MakeTime_typespec() { return Make<time_typespec>(&time_typespecMaker); }
std::vector<time_typespec*>* Serializer::MakeTime_typespecVec() { return Make<time_typespec>(&time_typespecVectMaker); }
enum_typespec* Serializer::MakeEnum_typespec() { return Make<enum_typespec>(&enum_typespecMaker); }
std::vector<enum_typespec*>* Serializer::MakeEnum_typespecVec() { return Make<enum_typespec>(&enum_typespecVectMaker); }
string_typespec* Serializer::MakeString_typespec() { return Make<string_typespec>(&string_typespecMaker); }
std::vector<string_typespec*>* Serializer::MakeString_typespecVec() { return Make<string_typespec>(&string_typespecVectMaker); }
chandle_typespec* Serializer::MakeChandle_typespec() { return Make<chandle_typespec>(&chandle_typespecMaker); }
std::vector<chandle_typespec*>* Serializer::MakeChandle_typespecVec() { return Make<chandle_typespec>(&chandle_typespecVectMaker); }
module_typespec* Serializer::MakeModule_typespec() { return Make<module_typespec>(&module_typespecMaker); }
std::vector<module_typespec*>* Serializer::MakeModule_typespecVec() { return Make<module_typespec>(&module_typespecVectMaker); }
struct_typespec* Serializer::MakeStruct_typespec() { return Make<struct_typespec>(&struct_typespecMaker); }
std::vector<struct_typespec*>* Serializer::MakeStruct_typespecVec() { return Make<struct_typespec>(&struct_typespecVectMaker); }
union_typespec* Serializer::MakeUnion_typespec() { return Make<union_typespec>(&union_typespecMaker); }
std::vector<union_typespec*>* Serializer::MakeUnion_typespecVec() { return Make<union_typespec>(&union_typespecVectMaker); }
logic_typespec* Serializer::MakeLogic_typespec() { return Make<logic_typespec>(&logic_typespecMaker); }
std::vector<logic_typespec*>* Serializer::MakeLogic_typespecVec() { return Make<logic_typespec>(&logic_typespecVectMaker); }
packed_array_typespec* Serializer::MakePacked_array_typespec() { return Make<packed_array_typespec>(&packed_array_typespecMaker); }
std::vector<packed_array_typespec*>* Serializer::MakePacked_array_typespecVec() { return Make<packed_array_typespec>(&packed_array_typespecVectMaker); }
array_typespec* Serializer::MakeArray_typespec() { return Make<array_typespec>(&array_typespecMaker); }
std::vector<array_typespec*>* Serializer::MakeArray_typespecVec() { return Make<array_typespec>(&array_typespecVectMaker); }
void_typespec* Serializer::MakeVoid_typespec() { return Make<void_typespec>(&void_typespecMaker); }
std::vector<void_typespec*>* Serializer::MakeVoid_typespecVec() { return Make<void_typespec>(&void_typespecVectMaker); }
unsupported_typespec* Serializer::MakeUnsupported_typespec() { return Make<unsupported_typespec>(&unsupported_typespecMaker); }
std::vector<unsupported_typespec*>* Serializer::MakeUnsupported_typespecVec() { return Make<unsupported_typespec>(&unsupported_typespecVectMaker); }
sequence_typespec* Serializer::MakeSequence_typespec() { return Make<sequence_typespec>(&sequence_typespecMaker); }
std::vector<sequence_typespec*>* Serializer::MakeSequence_typespecVec() { return Make<sequence_typespec>(&sequence_typespecVectMaker); }
property_typespec* Serializer::MakeProperty_typespec() { return Make<property_typespec>(&property_typespecMaker); }
std::vector<property_typespec*>* Serializer::MakeProperty_typespecVec() { return Make<property_typespec>(&property_typespecVectMaker); }
interface_typespec* Serializer::MakeInterface_typespec() { return Make<interface_typespec>(&interface_typespecMaker); }
std::vector<interface_typespec*>* Serializer::MakeInterface_typespecVec() { return Make<interface_typespec>(&interface_typespecVectMaker); }
type_parameter* Serializer::MakeType_parameter() { return Make<type_parameter>(&type_parameterMaker); }
std::vector<type_parameter*>* Serializer::MakeType_parameterVec() { return Make<type_parameter>(&type_parameterVectMaker); }
typespec_member* Serializer::MakeTypespec_member() { return Make<typespec_member>(&typespec_memberMaker); }
std::vector<typespec_member*>* Serializer::MakeTypespec_memberVec() { return Make<typespec_member>(&typespec_memberVectMaker); }
enum_const* Serializer::MakeEnum_const() { return Make<enum_const>(&enum_constMaker); }
std::vector<enum_const*>* Serializer::MakeEnum_constVec() { return Make<enum_const>(&enum_constVectMaker); }
bit_typespec* Serializer::MakeBit_typespec() { return Make<bit_typespec>(&bit_typespecMaker); }
std::vector<bit_typespec*>* Serializer::MakeBit_typespecVec() { return Make<bit_typespec>(&bit_typespecVectMaker); }
std::vector<tf_call*>* Serializer::MakeTf_callVec() { return Make<tf_call>(&tf_callVectMaker); }
user_systf* Serializer::MakeUser_systf() { return Make<user_systf>(&user_systfMaker); }
std::vector<user_systf*>* Serializer::MakeUser_systfVec() { return Make<user_systf>(&user_systfVectMaker); }
sys_func_call* Serializer::MakeSys_func_call() { return Make<sys_func_call>(&sys_func_callMaker); }
std::vector<sys_func_call*>* Serializer::MakeSys_func_callVec() { return Make<sys_func_call>(&sys_func_callVectMaker); }
sys_task_call* Serializer::MakeSys_task_call() { return Make<sys_task_call>(&sys_task_callMaker); }
std::vector<sys_task_call*>* Serializer::MakeSys_task_callVec() { return Make<sys_task_call>(&sys_task_callVectMaker); }
method_func_call* Serializer::MakeMethod_func_call() { return Make<method_func_call>(&method_func_callMaker); }
std::vector<method_func_call*>* Serializer::MakeMethod_func_callVec() { return Make<method_func_call>(&method_func_callVectMaker); }
method_task_call* Serializer::MakeMethod_task_call() { return Make<method_task_call>(&method_task_callMaker); }
std::vector<method_task_call*>* Serializer::MakeMethod_task_callVec() { return Make<method_task_call>(&method_task_callVectMaker); }
func_call* Serializer::MakeFunc_call() { return Make<func_call>(&func_callMaker); }
std::vector<func_call*>* Serializer::MakeFunc_callVec() { return Make<func_call>(&func_callVectMaker); }
task_call* Serializer::MakeTask_call() { return Make<task_call>(&task_callMaker); }
std::vector<task_call*>* Serializer::MakeTask_callVec() { return Make<task_call>(&task_callVectMaker); }
std::vector<constraint_expr*>* Serializer::MakeConstraint_exprVec() { return Make<constraint_expr>(&constraint_exprVectMaker); }
constraint_ordering* Serializer::MakeConstraint_ordering() { return Make<constraint_ordering>(&constraint_orderingMaker); }
std::vector<constraint_ordering*>* Serializer::MakeConstraint_orderingVec() { return Make<constraint_ordering>(&constraint_orderingVectMaker); }
constraint* Serializer::MakeConstraint() { return Make<constraint>(&constraintMaker); }
std::vector<constraint*>* Serializer::MakeConstraintVec() { return Make<constraint>(&constraintVectMaker); }
import_typespec* Serializer::MakeImport_typespec() { return Make<import_typespec>(&import_typespecMaker); }
std::vector<import_typespec*>* Serializer::MakeImport_typespecVec() { return Make<import_typespec>(&import_typespecVectMaker); }
dist_item* Serializer::MakeDist_item() { return Make<dist_item>(&dist_itemMaker); }
std::vector<dist_item*>* Serializer::MakeDist_itemVec() { return Make<dist_item>(&dist_itemVectMaker); }
distribution* Serializer::MakeDistribution() { return Make<distribution>(&distributionMaker); }
std::vector<distribution*>* Serializer::MakeDistributionVec() { return Make<distribution>(&distributionVectMaker); }
implication* Serializer::MakeImplication() { return Make<implication>(&implicationMaker); }
std::vector<implication*>* Serializer::MakeImplicationVec() { return Make<implication>(&implicationVectMaker); }
constr_if* Serializer::MakeConstr_if() { return Make<constr_if>(&constr_ifMaker); }
std::vector<constr_if*>* Serializer::MakeConstr_ifVec() { return Make<constr_if>(&constr_ifVectMaker); }
constr_if_else* Serializer::MakeConstr_if_else() { return Make<constr_if_else>(&constr_if_elseMaker); }
std::vector<constr_if_else*>* Serializer::MakeConstr_if_elseVec() { return Make<constr_if_else>(&constr_if_elseVectMaker); }
constr_foreach* Serializer::MakeConstr_foreach() { return Make<constr_foreach>(&constr_foreachMaker); }
std::vector<constr_foreach*>* Serializer::MakeConstr_foreachVec() { return Make<constr_foreach>(&constr_foreachVectMaker); }
soft_disable* Serializer::MakeSoft_disable() { return Make<soft_disable>(&soft_disableMaker); }
std::vector<soft_disable*>* Serializer::MakeSoft_disableVec() { return Make<soft_disable>(&soft_disableVectMaker); }
std::vector<gen_stmt*>* Serializer::MakeGen_stmtVec() { return Make<gen_stmt>(&gen_stmtVectMaker); }
gen_if* Serializer::MakeGen_if() { return Make<gen_if>(&gen_ifMaker); }
std::vector<gen_if*>* Serializer::MakeGen_ifVec() { return Make<gen_if>(&gen_ifVectMaker); }
gen_if_else* Serializer::MakeGen_if_else() { return Make<gen_if_else>(&gen_if_elseMaker); }
std::vector<gen_if_else*>* Serializer::MakeGen_if_elseVec() { return Make<gen_if_else>(&gen_if_elseVectMaker); }
gen_for* Serializer::MakeGen_for() { return Make<gen_for>(&gen_forMaker); }
std::vector<gen_for*>* Serializer::MakeGen_forVec() { return Make<gen_for>(&gen_forVectMaker); }
gen_case* Serializer::MakeGen_case() { return Make<gen_case>(&gen_caseMaker); }
std::vector<gen_case*>* Serializer::MakeGen_caseVec() { return Make<gen_case>(&gen_caseVectMaker); }
gen_region* Serializer::MakeGen_region() { return Make<gen_region>(&gen_regionMaker); }
std::vector<gen_region*>* Serializer::MakeGen_regionVec() { return Make<gen_region>(&gen_regionVectMaker); }
design* Serializer::MakeDesign() { return Make<design>(&designMaker); }
std::vector<design*>* Serializer::MakeDesignVec() { return Make<design>(&designVectMaker); }

struct Serializer::RestoreAdapter {
  void operator()(Any::Reader reader, Serializer *const serializer, BaseClass *const obj) const {
    obj->VpiParent(serializer->GetObject(reader.getVpiParent().getType(), reader.getVpiParent().getIndex() - 1));
    obj->VpiFile(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFile(), kUnknownRawSymbol)));
    obj->VpiLineNo(reader.getVpiLineNo());
    obj->VpiColumnNo(reader.getVpiColumnNo());
    obj->VpiEndLineNo(reader.getVpiEndLineNo());
    obj->VpiEndColumnNo(reader.getVpiEndColumnNo());
    obj->UhdmId(reader.getUhdmId());
  };

  void operator()(Attribute::Reader reader, Serializer *const serializer, attribute *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiDefAttribute(reader.getVpiDefAttribute());
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->VpiDefFile(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefFile(), kUnknownRawSymbol)));
    obj->VpiDefLineNo(reader.getVpiDefLineNo());
  }

  void operator()(Virtualinterfacevar::Reader reader, Serializer *const serializer, virtual_interface_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Letdecl::Reader reader, Serializer *const serializer, let_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (uint32_t n = reader.getExpressions().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getExpressions()[i].getType(), reader.getExpressions()[i].getIndex() - 1));
      }
      obj->Expressions(vect);
    }
    if (uint32_t n = reader.getSeqformaldecls().size()) {
      std::vector<seq_formal_decl*>* vect = serializer->seq_formal_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->seq_formal_declMaker.objects_[reader.getSeqformaldecls()[i] - 1]);
      }
      obj->Seq_formal_decls(vect);
    }
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
  }

  void operator()(Concurrentassertions::Reader reader, Serializer *const serializer, concurrent_assertions *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiIsClockInferred(reader.getVpiIsClockInferred());
    obj->Clocking_event((expr*)serializer->GetObject(reader.getClockingevent().getType(), reader.getClockingevent().getIndex() - 1));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    obj->VpiProperty((any*)serializer->GetObject(reader.getVpiProperty().getType(), reader.getVpiProperty().getIndex() - 1));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Processstmt::Reader reader, Serializer *const serializer, process_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    if (reader.getModuleinst()) {
      obj->Module_inst(serializer->module_instMaker.objects_[reader.getModuleinst() - 1]);
    }
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Always::Reader reader, Serializer *const serializer, always *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<process_stmt*>(obj));
    obj->VpiAlwaysType(reader.getVpiAlwaysType());
  }

  void operator()(Finalstmt::Reader reader, Serializer *const serializer, final_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<process_stmt*>(obj));
  }

  void operator()(Initial::Reader reader, Serializer *const serializer, initial *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<process_stmt*>(obj));
  }

  void operator()(Atomicstmt::Reader reader, Serializer *const serializer, atomic_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Delaycontrol::Reader reader, Serializer *const serializer, delay_control *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiDelay(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDelay(), kUnknownRawSymbol)));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    obj->Delay((expr*)serializer->GetObject(reader.getDelay().getType(), reader.getDelay().getIndex() - 1));
  }

  void operator()(Delayterm::Reader reader, Serializer *const serializer, delay_term *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Eventcontrol::Reader reader, Serializer *const serializer, event_control *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiCondition((any*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
  }

  void operator()(Repeatcontrol::Reader reader, Serializer *const serializer, repeat_control *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
  }

  void operator()(Scope::Reader reader, Serializer *const serializer, scope *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getPropertydecls().size()) {
      std::vector<property_decl*>* vect = serializer->property_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->property_declMaker.objects_[reader.getPropertydecls()[i] - 1]);
      }
      obj->Property_decls(vect);
    }
    if (uint32_t n = reader.getSequencedecls().size()) {
      std::vector<sequence_decl*>* vect = serializer->sequence_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->sequence_declMaker.objects_[reader.getSequencedecls()[i] - 1]);
      }
      obj->Sequence_decls(vect);
    }
    if (uint32_t n = reader.getConcurrentassertions().size()) {
      std::vector<concurrent_assertions*>* vect = serializer->concurrent_assertionsVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((concurrent_assertions*)serializer->GetObject(reader.getConcurrentassertions()[i].getType(), reader.getConcurrentassertions()[i].getIndex() - 1));
      }
      obj->Concurrent_assertions(vect);
    }
    if (uint32_t n = reader.getNamedevents().size()) {
      std::vector<named_event*>* vect = serializer->named_eventVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->named_eventMaker.objects_[reader.getNamedevents()[i] - 1]);
      }
      obj->Named_events(vect);
    }
    if (uint32_t n = reader.getNamedeventarrays().size()) {
      std::vector<named_event_array*>* vect = serializer->named_event_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->named_event_arrayMaker.objects_[reader.getNamedeventarrays()[i] - 1]);
      }
      obj->Named_event_arrays(vect);
    }
    if (uint32_t n = reader.getVariables().size()) {
      std::vector<variables*>* vect = serializer->variablesVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((variables*)serializer->GetObject(reader.getVariables()[i].getType(), reader.getVariables()[i].getIndex() - 1));
      }
      obj->Variables(vect);
    }
    if (uint32_t n = reader.getVirtualinterfacevars().size()) {
      std::vector<virtual_interface_var*>* vect = serializer->virtual_interface_varVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->virtual_interface_varMaker.objects_[reader.getVirtualinterfacevars()[i] - 1]);
      }
      obj->Virtual_interface_vars(vect);
    }
    if (uint32_t n = reader.getLogicvars().size()) {
      std::vector<logic_var*>* vect = serializer->logic_varVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->logic_varMaker.objects_[reader.getLogicvars()[i] - 1]);
      }
      obj->Logic_vars(vect);
    }
    if (uint32_t n = reader.getArrayvars().size()) {
      std::vector<array_var*>* vect = serializer->array_varVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->array_varMaker.objects_[reader.getArrayvars()[i] - 1]);
      }
      obj->Array_vars(vect);
    }
    if (uint32_t n = reader.getArrayvarmems().size()) {
      std::vector<array_var*>* vect = serializer->array_varVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->array_varMaker.objects_[reader.getArrayvarmems()[i] - 1]);
      }
      obj->Array_var_mems(vect);
    }
    if (uint32_t n = reader.getParameters().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getParameters()[i].getType(), reader.getParameters()[i].getIndex() - 1));
      }
      obj->Parameters(vect);
    }
    if (uint32_t n = reader.getParamassigns().size()) {
      std::vector<param_assign*>* vect = serializer->param_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->param_assignMaker.objects_[reader.getParamassigns()[i] - 1]);
      }
      obj->Param_assigns(vect);
    }
    if (uint32_t n = reader.getScopes().size()) {
      std::vector<scope*>* vect = serializer->scopeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((scope*)serializer->GetObject(reader.getScopes()[i].getType(), reader.getScopes()[i].getIndex() - 1));
      }
      obj->Scopes(vect);
    }
    if (uint32_t n = reader.getTypespecs().size()) {
      std::vector<typespec*>* vect = serializer->typespecVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((typespec*)serializer->GetObject(reader.getTypespecs()[i].getType(), reader.getTypespecs()[i].getIndex() - 1));
      }
      obj->Typespecs(vect);
    }
    if (uint32_t n = reader.getInstanceitems().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getInstanceitems()[i].getType(), reader.getInstanceitems()[i].getIndex() - 1));
      }
      obj->Instance_items(vect);
    }
    if (uint32_t n = reader.getLetdecls().size()) {
      std::vector<let_decl*>* vect = serializer->let_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->let_declMaker.objects_[reader.getLetdecls()[i] - 1]);
      }
      obj->Let_decls(vect);
    }
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Begin::Reader reader, Serializer *const serializer, begin *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    if (uint32_t n = reader.getStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getStmts()[i].getType(), reader.getStmts()[i].getIndex() - 1));
      }
      obj->Stmts(vect);
    }
  }

  void operator()(Namedbegin::Reader reader, Serializer *const serializer, named_begin *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    if (uint32_t n = reader.getStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getStmts()[i].getType(), reader.getStmts()[i].getIndex() - 1));
      }
      obj->Stmts(vect);
    }
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Namedfork::Reader reader, Serializer *const serializer, named_fork *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiJoinType(reader.getVpiJoinType());
    if (uint32_t n = reader.getStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getStmts()[i].getType(), reader.getStmts()[i].getIndex() - 1));
      }
      obj->Stmts(vect);
    }
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Forkstmt::Reader reader, Serializer *const serializer, fork_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiJoinType(reader.getVpiJoinType());
    if (uint32_t n = reader.getStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getStmts()[i].getType(), reader.getStmts()[i].getIndex() - 1));
      }
      obj->Stmts(vect);
    }
  }

  void operator()(Forstmt::Reader reader, Serializer *const serializer, for_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiLocalVarDecls(reader.getVpiLocalVarDecls());
    if (uint32_t n = reader.getVpiForInitStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiForInitStmts()[i].getType(), reader.getVpiForInitStmts()[i].getIndex() - 1));
      }
      obj->VpiForInitStmts(vect);
    }
    if (uint32_t n = reader.getVpiForIncStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiForIncStmts()[i].getType(), reader.getVpiForIncStmts()[i].getIndex() - 1));
      }
      obj->VpiForIncStmts(vect);
    }
    obj->VpiForInitStmt((any*)serializer->GetObject(reader.getVpiForInitStmt().getType(), reader.getVpiForInitStmt().getIndex() - 1));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiForIncStmt((any*)serializer->GetObject(reader.getVpiForIncStmt().getType(), reader.getVpiForIncStmt().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Ifstmt::Reader reader, Serializer *const serializer, if_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiQualifier(reader.getVpiQualifier());
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Eventstmt::Reader reader, Serializer *const serializer, event_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiBlocking(reader.getVpiBlocking());
    if (reader.getNamedevent()) {
      obj->Named_event(serializer->named_eventMaker.objects_[reader.getNamedevent() - 1]);
    }
  }

  void operator()(Threadobj::Reader reader, Serializer *const serializer, thread_obj *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Foreverstmt::Reader reader, Serializer *const serializer, forever_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Waits::Reader reader, Serializer *const serializer, waits *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Waitstmt::Reader reader, Serializer *const serializer, wait_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<waits*>(obj));
    obj->VpiCondition((any*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
  }

  void operator()(Waitfork::Reader reader, Serializer *const serializer, wait_fork *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<waits*>(obj));
  }

  void operator()(Orderedwait::Reader reader, Serializer *const serializer, ordered_wait *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<waits*>(obj));
    if (uint32_t n = reader.getVpiConditions().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiConditions()[i].getType(), reader.getVpiConditions()[i].getIndex() - 1));
      }
      obj->VpiConditions(vect);
    }
    obj->VpiElseStmt((any*)serializer->GetObject(reader.getVpiElseStmt().getType(), reader.getVpiElseStmt().getIndex() - 1));
  }

  void operator()(Disables::Reader reader, Serializer *const serializer, disables *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
  }

  void operator()(Disable::Reader reader, Serializer *const serializer, disable *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<disables*>(obj));
    obj->VpiExpr((any*)serializer->GetObject(reader.getVpiExpr().getType(), reader.getVpiExpr().getIndex() - 1));
  }

  void operator()(Disablefork::Reader reader, Serializer *const serializer, disable_fork *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<disables*>(obj));
  }

  void operator()(Continuestmt::Reader reader, Serializer *const serializer, continue_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
  }

  void operator()(Breakstmt::Reader reader, Serializer *const serializer, break_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
  }

  void operator()(Returnstmt::Reader reader, Serializer *const serializer, return_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
  }

  void operator()(Whilestmt::Reader reader, Serializer *const serializer, while_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Repeat::Reader reader, Serializer *const serializer, repeat *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Dowhile::Reader reader, Serializer *const serializer, do_while *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Ifelse::Reader reader, Serializer *const serializer, if_else *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiQualifier(reader.getVpiQualifier());
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
    obj->VpiElseStmt((any*)serializer->GetObject(reader.getVpiElseStmt().getType(), reader.getVpiElseStmt().getIndex() - 1));
  }

  void operator()(Casestmt::Reader reader, Serializer *const serializer, case_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiRandType(reader.getVpiRandType());
    obj->VpiCaseType(reader.getVpiCaseType());
    obj->VpiQualifier(reader.getVpiQualifier());
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    if (uint32_t n = reader.getCaseitems().size()) {
      std::vector<case_item*>* vect = serializer->case_itemVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->case_itemMaker.objects_[reader.getCaseitems()[i] - 1]);
      }
      obj->Case_items(vect);
    }
  }

  void operator()(Force::Reader reader, Serializer *const serializer, force *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->Rhs((expr*)serializer->GetObject(reader.getRhs().getType(), reader.getRhs().getIndex() - 1));
    obj->Lhs((expr*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
  }

  void operator()(Assignstmt::Reader reader, Serializer *const serializer, assign_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->Rhs((expr*)serializer->GetObject(reader.getRhs().getType(), reader.getRhs().getIndex() - 1));
    obj->Lhs((expr*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
  }

  void operator()(Deassign::Reader reader, Serializer *const serializer, deassign *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->Lhs((expr*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
  }

  void operator()(Release::Reader reader, Serializer *const serializer, release *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->Lhs((expr*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
  }

  void operator()(Nullstmt::Reader reader, Serializer *const serializer, null_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
  }

  void operator()(Expectstmt::Reader reader, Serializer *const serializer, expect_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    obj->Else_stmt((any*)serializer->GetObject(reader.getElsestmt().getType(), reader.getElsestmt().getIndex() - 1));
    if (reader.getPropertyspec()) {
      obj->Property_spec(serializer->property_specMaker.objects_[reader.getPropertyspec() - 1]);
    }
  }

  void operator()(Foreachstmt::Reader reader, Serializer *const serializer, foreach_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->Variable((variables*)serializer->GetObject(reader.getVariable().getType(), reader.getVariable().getIndex() - 1));
    if (uint32_t n = reader.getVpiLoopVars().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiLoopVars()[i].getType(), reader.getVpiLoopVars()[i].getIndex() - 1));
      }
      obj->VpiLoopVars(vect);
    }
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Genscope::Reader reader, Serializer *const serializer, gen_scope *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiIndex((expr*)serializer->GetObject(reader.getVpiIndex().getType(), reader.getVpiIndex().getIndex() - 1));
    obj->VpiArrayMember(reader.getVpiArrayMember());
    obj->VpiProtected(reader.getVpiProtected());
    obj->VpiImplicitDecl(reader.getVpiImplicitDecl());
    if (uint32_t n = reader.getNets().size()) {
      std::vector<net*>* vect = serializer->netVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((net*)serializer->GetObject(reader.getNets()[i].getType(), reader.getNets()[i].getIndex() - 1));
      }
      obj->Nets(vect);
    }
    if (uint32_t n = reader.getArraynets().size()) {
      std::vector<array_net*>* vect = serializer->array_netVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->array_netMaker.objects_[reader.getArraynets()[i] - 1]);
      }
      obj->Array_nets(vect);
    }
    if (uint32_t n = reader.getProcess().size()) {
      std::vector<process_stmt*>* vect = serializer->process_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((process_stmt*)serializer->GetObject(reader.getProcess()[i].getType(), reader.getProcess()[i].getIndex() - 1));
      }
      obj->Process(vect);
    }
    if (uint32_t n = reader.getContassigns().size()) {
      std::vector<cont_assign*>* vect = serializer->cont_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assignMaker.objects_[reader.getContassigns()[i] - 1]);
      }
      obj->Cont_assigns(vect);
    }
    if (uint32_t n = reader.getModules().size()) {
      std::vector<module_inst*>* vect = serializer->module_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->module_instMaker.objects_[reader.getModules()[i] - 1]);
      }
      obj->Modules(vect);
    }
    if (uint32_t n = reader.getModulearrays().size()) {
      std::vector<module_array*>* vect = serializer->module_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->module_arrayMaker.objects_[reader.getModulearrays()[i] - 1]);
      }
      obj->Module_arrays(vect);
    }
    if (uint32_t n = reader.getPrimitives().size()) {
      std::vector<primitive*>* vect = serializer->primitiveVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((primitive*)serializer->GetObject(reader.getPrimitives()[i].getType(), reader.getPrimitives()[i].getIndex() - 1));
      }
      obj->Primitives(vect);
    }
    if (uint32_t n = reader.getPrimitivearrays().size()) {
      std::vector<primitive_array*>* vect = serializer->primitive_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((primitive_array*)serializer->GetObject(reader.getPrimitivearrays()[i].getType(), reader.getPrimitivearrays()[i].getIndex() - 1));
      }
      obj->Primitive_arrays(vect);
    }
    if (uint32_t n = reader.getDefparams().size()) {
      std::vector<def_param*>* vect = serializer->def_paramVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->def_paramMaker.objects_[reader.getDefparams()[i] - 1]);
      }
      obj->Def_params(vect);
    }
    if (uint32_t n = reader.getGenscopearrays().size()) {
      std::vector<gen_scope_array*>* vect = serializer->gen_scope_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->gen_scope_arrayMaker.objects_[reader.getGenscopearrays()[i] - 1]);
      }
      obj->Gen_scope_arrays(vect);
    }
    if (uint32_t n = reader.getPrograms().size()) {
      std::vector<program*>* vect = serializer->programVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->programMaker.objects_[reader.getPrograms()[i] - 1]);
      }
      obj->Programs(vect);
    }
    if (uint32_t n = reader.getProgramarrays().size()) {
      std::vector<program*>* vect = serializer->programVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->programMaker.objects_[reader.getProgramarrays()[i] - 1]);
      }
      obj->Program_arrays(vect);
    }
    if (uint32_t n = reader.getAssertions().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getAssertions()[i].getType(), reader.getAssertions()[i].getIndex() - 1));
      }
      obj->Assertions(vect);
    }
    if (uint32_t n = reader.getInterfaces().size()) {
      std::vector<interface_inst*>* vect = serializer->interface_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_instMaker.objects_[reader.getInterfaces()[i] - 1]);
      }
      obj->Interfaces(vect);
    }
    if (uint32_t n = reader.getInterfacearrays().size()) {
      std::vector<interface_array*>* vect = serializer->interface_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_arrayMaker.objects_[reader.getInterfacearrays()[i] - 1]);
      }
      obj->Interface_arrays(vect);
    }
    if (uint32_t n = reader.getAliasstmts().size()) {
      std::vector<alias_stmt*>* vect = serializer->alias_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->alias_stmtMaker.objects_[reader.getAliasstmts()[i] - 1]);
      }
      obj->Alias_stmts(vect);
    }
    if (uint32_t n = reader.getClockingblocks().size()) {
      std::vector<clocking_block*>* vect = serializer->clocking_blockVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->clocking_blockMaker.objects_[reader.getClockingblocks()[i] - 1]);
      }
      obj->Clocking_blocks(vect);
    }
    if (uint32_t n = reader.getTaskfuncs().size()) {
      std::vector<task_func*>* vect = serializer->task_funcVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((task_func*)serializer->GetObject(reader.getTaskfuncs()[i].getType(), reader.getTaskfuncs()[i].getIndex() - 1));
      }
      obj->Task_funcs(vect);
    }
    if (uint32_t n = reader.getElabtasks().size()) {
      std::vector<tf_call*>* vect = serializer->tf_callVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((tf_call*)serializer->GetObject(reader.getElabtasks()[i].getType(), reader.getElabtasks()[i].getIndex() - 1));
      }
      obj->Elab_tasks(vect);
    }
  }

  void operator()(Genvar::Reader reader, Serializer *const serializer, gen_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getGenscopearrays().size()) {
      std::vector<gen_scope_array*>* vect = serializer->gen_scope_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->gen_scope_arrayMaker.objects_[reader.getGenscopearrays()[i] - 1]);
      }
      obj->Gen_scope_arrays(vect);
    }
  }

  void operator()(Genscopearray::Reader reader, Serializer *const serializer, gen_scope_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiSize(reader.getVpiSize());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    if (reader.getGenvar()) {
      obj->Gen_var(serializer->gen_varMaker.objects_[reader.getGenvar() - 1]);
    }
    if (uint32_t n = reader.getGenscopes().size()) {
      std::vector<gen_scope*>* vect = serializer->gen_scopeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->gen_scopeMaker.objects_[reader.getGenscopes()[i] - 1]);
      }
      obj->Gen_scopes(vect);
    }
    obj->VpiInstance((any*)serializer->GetObject(reader.getVpiInstance().getType(), reader.getVpiInstance().getIndex() - 1));
  }

  void operator()(Assertstmt::Reader reader, Serializer *const serializer, assert_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<concurrent_assertions*>(obj));
    obj->Else_stmt((any*)serializer->GetObject(reader.getElsestmt().getType(), reader.getElsestmt().getIndex() - 1));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Cover::Reader reader, Serializer *const serializer, cover *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<concurrent_assertions*>(obj));
    obj->VpiIsCoverSequence(reader.getVpiIsCoverSequence());
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Assume::Reader reader, Serializer *const serializer, assume *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<concurrent_assertions*>(obj));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Restrict::Reader reader, Serializer *const serializer, restrict *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<concurrent_assertions*>(obj));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Immediateassert::Reader reader, Serializer *const serializer, immediate_assert *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiIsDeferred(reader.getVpiIsDeferred());
    obj->VpiIsFinal(reader.getVpiIsFinal());
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    obj->Else_stmt((any*)serializer->GetObject(reader.getElsestmt().getType(), reader.getElsestmt().getIndex() - 1));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Immediateassume::Reader reader, Serializer *const serializer, immediate_assume *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiIsDeferred(reader.getVpiIsDeferred());
    obj->VpiIsFinal(reader.getVpiIsFinal());
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    obj->Else_stmt((any*)serializer->GetObject(reader.getElsestmt().getType(), reader.getElsestmt().getIndex() - 1));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Immediatecover::Reader reader, Serializer *const serializer, immediate_cover *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiIsDeferred(reader.getVpiIsDeferred());
    obj->VpiIsFinal(reader.getVpiIsFinal());
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Expr::Reader reader, Serializer *const serializer, expr *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDecompile(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDecompile(), kUnknownRawSymbol)));
    obj->VpiSize(reader.getVpiSize());
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
  }

  void operator()(Caseitem::Reader reader, Serializer *const serializer, case_item *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (uint32_t n = reader.getVpiExprs().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiExprs()[i].getType(), reader.getVpiExprs()[i].getIndex() - 1));
      }
      obj->VpiExprs(vect);
    }
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
  }

  void operator()(Assignment::Reader reader, Serializer *const serializer, assignment *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiOpType(reader.getVpiOpType());
    obj->VpiBlocking(reader.getVpiBlocking());
    obj->Rhs((any*)serializer->GetObject(reader.getRhs().getType(), reader.getRhs().getIndex() - 1));
    obj->Lhs((expr*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
    if (reader.getDelaycontrol()) {
      obj->Delay_control(serializer->delay_controlMaker.objects_[reader.getDelaycontrol() - 1]);
    }
    if (reader.getEventcontrol()) {
      obj->Event_control(serializer->event_controlMaker.objects_[reader.getEventcontrol() - 1]);
    }
    if (reader.getRepeatcontrol()) {
      obj->Repeat_control(serializer->repeat_controlMaker.objects_[reader.getRepeatcontrol() - 1]);
    }
  }

  void operator()(Anypattern::Reader reader, Serializer *const serializer, any_pattern *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
  }

  void operator()(Taggedpattern::Reader reader, Serializer *const serializer, tagged_pattern *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->Pattern((any*)serializer->GetObject(reader.getPattern().getType(), reader.getPattern().getIndex() - 1));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
  }

  void operator()(Structpattern::Reader reader, Serializer *const serializer, struct_pattern *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->Pattern((any*)serializer->GetObject(reader.getPattern().getType(), reader.getPattern().getIndex() - 1));
  }

  void operator()(Unsupportedexpr::Reader reader, Serializer *const serializer, unsupported_expr *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<expr*>(obj));
  }

  void operator()(Unsupportedstmt::Reader reader, Serializer *const serializer, unsupported_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<atomic_stmt*>(obj));
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
  }

  void operator()(Includefileinfo::Reader reader, Serializer *const serializer, include_file_info *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiIncludedFile(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiIncludedFile(), kUnknownRawSymbol)));
  }

  void operator()(Sequenceinst::Reader reader, Serializer *const serializer, sequence_inst *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (reader.getSequencedecl()) {
      obj->Sequence_decl(serializer->sequence_declMaker.objects_[reader.getSequencedecl() - 1]);
    }
    if (uint32_t n = reader.getNamedeventsequenceexprgroups().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getNamedeventsequenceexprgroups()[i].getType(), reader.getNamedeventsequenceexprgroups()[i].getIndex() - 1));
      }
      obj->Named_event_sequence_expr_groups(vect);
    }
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Seqformaldecl::Reader reader, Serializer *const serializer, seq_formal_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiDirection(reader.getVpiDirection());
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    obj->Named_event_sequence_expr_group((any*)serializer->GetObject(reader.getNamedeventsequenceexprgroup().getType(), reader.getNamedeventsequenceexprgroup().getIndex() - 1));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
  }

  void operator()(Sequencedecl::Reader reader, Serializer *const serializer, sequence_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    if (uint32_t n = reader.getVariables().size()) {
      std::vector<variables*>* vect = serializer->variablesVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((variables*)serializer->GetObject(reader.getVariables()[i].getType(), reader.getVariables()[i].getIndex() - 1));
      }
      obj->Variables(vect);
    }
    obj->Sequence_expr_multiclock_group((any*)serializer->GetObject(reader.getSequenceexprmulticlockgroup().getType(), reader.getSequenceexprmulticlockgroup().getIndex() - 1));
    if (uint32_t n = reader.getSeqformaldecls().size()) {
      std::vector<seq_formal_decl*>* vect = serializer->seq_formal_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->seq_formal_declMaker.objects_[reader.getSeqformaldecls()[i] - 1]);
      }
      obj->Seq_formal_decls(vect);
    }
  }

  void operator()(Propformaldecl::Reader reader, Serializer *const serializer, prop_formal_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiDirection(reader.getVpiDirection());
    obj->VpiExpr((any*)serializer->GetObject(reader.getVpiExpr().getType(), reader.getVpiExpr().getIndex() - 1));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
  }

  void operator()(Propertyinst::Reader reader, Serializer *const serializer, property_inst *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDisableCondition((any*)serializer->GetObject(reader.getVpiDisableCondition().getType(), reader.getVpiDisableCondition().getIndex() - 1));
    if (uint32_t n = reader.getVpiArguments().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiArguments()[i].getType(), reader.getVpiArguments()[i].getIndex() - 1));
      }
      obj->VpiArguments(vect);
    }
    if (reader.getPropertydecl()) {
      obj->Property_decl(serializer->property_declMaker.objects_[reader.getPropertydecl() - 1]);
    }
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    if (reader.getClockingblock()) {
      obj->Clocking_block(serializer->clocking_blockMaker.objects_[reader.getClockingblock() - 1]);
    }
  }

  void operator()(Propertyspec::Reader reader, Serializer *const serializer, property_spec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDisableCondition((any*)serializer->GetObject(reader.getVpiDisableCondition().getType(), reader.getVpiDisableCondition().getIndex() - 1));
    obj->VpiClockingEvent((expr*)serializer->GetObject(reader.getVpiClockingEvent().getType(), reader.getVpiClockingEvent().getIndex() - 1));
    obj->VpiPropertyExpr((any*)serializer->GetObject(reader.getVpiPropertyExpr().getType(), reader.getVpiPropertyExpr().getIndex() - 1));
  }

  void operator()(Propertydecl::Reader reader, Serializer *const serializer, property_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    if (uint32_t n = reader.getPropformaldecls().size()) {
      std::vector<prop_formal_decl*>* vect = serializer->prop_formal_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->prop_formal_declMaker.objects_[reader.getPropformaldecls()[i] - 1]);
      }
      obj->Prop_formal_decls(vect);
    }
    if (uint32_t n = reader.getVariables().size()) {
      std::vector<variables*>* vect = serializer->variablesVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((variables*)serializer->GetObject(reader.getVariables()[i].getType(), reader.getVariables()[i].getIndex() - 1));
      }
      obj->Variables(vect);
    }
    if (reader.getPropertyspec()) {
      obj->Property_spec(serializer->property_specMaker.objects_[reader.getPropertyspec() - 1]);
    }
  }

  void operator()(Clockedproperty::Reader reader, Serializer *const serializer, clocked_property *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiClockingEvent((expr*)serializer->GetObject(reader.getVpiClockingEvent().getType(), reader.getVpiClockingEvent().getIndex() - 1));
    obj->VpiPropertyExpr((any*)serializer->GetObject(reader.getVpiPropertyExpr().getType(), reader.getVpiPropertyExpr().getIndex() - 1));
  }

  void operator()(Casepropertyitem::Reader reader, Serializer *const serializer, case_property_item *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (uint32_t n = reader.getExpressions().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getExpressions()[i].getType(), reader.getExpressions()[i].getIndex() - 1));
      }
      obj->Expressions(vect);
    }
    obj->Property_expr((any*)serializer->GetObject(reader.getPropertyexpr().getType(), reader.getPropertyexpr().getIndex() - 1));
  }

  void operator()(Caseproperty::Reader reader, Serializer *const serializer, case_property *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    if (uint32_t n = reader.getCasepropertyitems().size()) {
      std::vector<case_property_item*>* vect = serializer->case_property_itemVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->case_property_itemMaker.objects_[reader.getCasepropertyitems()[i] - 1]);
      }
      obj->Case_property_items(vect);
    }
  }

  void operator()(Multiclocksequenceexpr::Reader reader, Serializer *const serializer, multiclock_sequence_expr *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (uint32_t n = reader.getClockedseqs().size()) {
      std::vector<clocked_seq*>* vect = serializer->clocked_seqVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->clocked_seqMaker.objects_[reader.getClockedseqs()[i] - 1]);
      }
      obj->Clocked_seqs(vect);
    }
  }

  void operator()(Clockedseq::Reader reader, Serializer *const serializer, clocked_seq *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiClockingEvent((expr*)serializer->GetObject(reader.getVpiClockingEvent().getType(), reader.getVpiClockingEvent().getIndex() - 1));
    obj->VpiSequenceExpr((any*)serializer->GetObject(reader.getVpiSequenceExpr().getType(), reader.getVpiSequenceExpr().getIndex() - 1));
  }

  void operator()(Simpleexpr::Reader reader, Serializer *const serializer, simple_expr *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<expr*>(obj));
    if (uint32_t n = reader.getVpiUses().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiUses()[i].getType(), reader.getVpiUses()[i].getIndex() - 1));
      }
      obj->VpiUses(vect);
    }
  }

  void operator()(Constant::Reader reader, Serializer *const serializer, constant *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<expr*>(obj));
    obj->VpiConstType(reader.getVpiConstType());
  }

  void operator()(Letexpr::Reader reader, Serializer *const serializer, let_expr *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<expr*>(obj));
    if (uint32_t n = reader.getArguments().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getArguments()[i].getType(), reader.getArguments()[i].getIndex() - 1));
      }
      obj->Arguments(vect);
    }
    if (reader.getLetdecl()) {
      obj->Let_decl(serializer->let_declMaker.objects_[reader.getLetdecl() - 1]);
    }
  }

  void operator()(Operation::Reader reader, Serializer *const serializer, operation *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<expr*>(obj));
    obj->VpiOpType(reader.getVpiOpType());
    obj->VpiReordered(reader.getVpiReordered());
    obj->VpiFlattened(reader.getVpiFlattened());
    obj->VpiOpStrong(reader.getVpiOpStrong());
    if (uint32_t n = reader.getOperands().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getOperands()[i].getType(), reader.getOperands()[i].getIndex() - 1));
      }
      obj->Operands(vect);
    }
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Refobj::Reader reader, Serializer *const serializer, ref_obj *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<simple_expr*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->VpiGeneric(reader.getVpiGeneric());
    obj->Actual_group((any*)serializer->GetObject(reader.getActualgroup().getType(), reader.getActualgroup().getIndex() - 1));
    obj->VpiStructMember(reader.getVpiStructMember());
  }

  void operator()(Refmodule::Reader reader, Serializer *const serializer, ref_module *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->Actual_group((any*)serializer->GetObject(reader.getActualgroup().getType(), reader.getActualgroup().getIndex() - 1));
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<port*>* vect = serializer->portVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->portMaker.objects_[reader.getPorts()[i] - 1]);
      }
      obj->Ports(vect);
    }
  }

  void operator()(Reftypespec::Reader reader, Serializer *const serializer, ref_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<simple_expr*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->Actual_typespec((typespec*)serializer->GetObject(reader.getActualtypespec().getType(), reader.getActualtypespec().getIndex() - 1));
  }

  void operator()(Partselect::Reader reader, Serializer *const serializer, part_select *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<ref_obj*>(obj));
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->Left_range((expr*)serializer->GetObject(reader.getLeftrange().getType(), reader.getLeftrange().getIndex() - 1));
    obj->Right_range((expr*)serializer->GetObject(reader.getRightrange().getType(), reader.getRightrange().getIndex() - 1));
  }

  void operator()(Indexedpartselect::Reader reader, Serializer *const serializer, indexed_part_select *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<ref_obj*>(obj));
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->VpiIndexedPartSelectType(reader.getVpiIndexedPartSelectType());
    obj->Base_expr((expr*)serializer->GetObject(reader.getBaseexpr().getType(), reader.getBaseexpr().getIndex() - 1));
    obj->Width_expr((expr*)serializer->GetObject(reader.getWidthexpr().getType(), reader.getWidthexpr().getIndex() - 1));
  }

  void operator()(Varselect::Reader reader, Serializer *const serializer, var_select *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<ref_obj*>(obj));
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    if (uint32_t n = reader.getExprs().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getExprs()[i].getType(), reader.getExprs()[i].getIndex() - 1));
      }
      obj->Exprs(vect);
    }
  }

  void operator()(Bitselect::Reader reader, Serializer *const serializer, bit_select *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<ref_obj*>(obj));
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->VpiIndex((expr*)serializer->GetObject(reader.getVpiIndex().getType(), reader.getVpiIndex().getIndex() - 1));
  }

  void operator()(Variables::Reader reader, Serializer *const serializer, variables *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<simple_expr*>(obj));
    obj->VpiArrayMember(reader.getVpiArrayMember());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiSigned(reader.getVpiSigned());
    obj->VpiAutomatic(reader.getVpiAutomatic());
    obj->VpiAllocScheme(reader.getVpiAllocScheme());
    obj->VpiConstantVariable(reader.getVpiConstantVariable());
    obj->VpiIsRandomized(reader.getVpiIsRandomized());
    obj->VpiRandType(reader.getVpiRandType());
    obj->VpiStructUnionMember(reader.getVpiStructUnionMember());
    obj->VpiScalar(reader.getVpiScalar());
    obj->VpiVisibility(reader.getVpiVisibility());
    obj->VpiVector(reader.getVpiVector());
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<ports*>* vect = serializer->portsVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((ports*)serializer->GetObject(reader.getPorts()[i].getType(), reader.getPorts()[i].getIndex() - 1));
      }
      obj->Ports(vect);
    }
    if (uint32_t n = reader.getVariabledrivers().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVariabledrivers()[i].getType(), reader.getVariabledrivers()[i].getIndex() - 1));
      }
      obj->Variable_drivers(vect);
    }
    if (uint32_t n = reader.getVariableloads().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVariableloads()[i].getType(), reader.getVariableloads()[i].getIndex() - 1));
      }
      obj->Variable_loads(vect);
    }
    if (uint32_t n = reader.getPrimterms().size()) {
      std::vector<prim_term*>* vect = serializer->prim_termVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->prim_termMaker.objects_[reader.getPrimterms()[i] - 1]);
      }
      obj->Prim_terms(vect);
    }
    if (uint32_t n = reader.getContassigns().size()) {
      std::vector<cont_assign*>* vect = serializer->cont_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assignMaker.objects_[reader.getContassigns()[i] - 1]);
      }
      obj->Cont_assigns(vect);
    }
    if (reader.getPathterm()) {
      obj->Path_term(serializer->path_termMaker.objects_[reader.getPathterm() - 1]);
    }
    if (reader.getTchkterm()) {
      obj->Tchk_term(serializer->tchk_termMaker.objects_[reader.getTchkterm() - 1]);
    }
    if (reader.getModuleinst()) {
      obj->Module_inst(serializer->module_instMaker.objects_[reader.getModuleinst() - 1]);
    }
    obj->Instance((instance*)serializer->GetObject(reader.getInstance().getType(), reader.getInstance().getIndex() - 1));
    obj->Scope((scope*)serializer->GetObject(reader.getScope().getType(), reader.getScope().getIndex() - 1));
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    if (uint32_t n = reader.getIndexes().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getIndexes()[i].getType(), reader.getIndexes()[i].getIndex() - 1));
      }
      obj->Indexes(vect);
    }
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Hierpath::Reader reader, Serializer *const serializer, hier_path *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<simple_expr*>(obj));
    if (uint32_t n = reader.getPathelems().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getPathelems()[i].getType(), reader.getPathelems()[i].getIndex() - 1));
      }
      obj->Path_elems(vect);
    }
    obj->Root_value((any*)serializer->GetObject(reader.getRootvalue().getType(), reader.getRootvalue().getIndex() - 1));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
  }

  void operator()(Refvar::Reader reader, Serializer *const serializer, ref_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->VpiGeneric(reader.getVpiGeneric());
    obj->Actual_group((any*)serializer->GetObject(reader.getActualgroup().getType(), reader.getActualgroup().getIndex() - 1));
    obj->Task_func((task_func*)serializer->GetObject(reader.getTaskfunc().getType(), reader.getTaskfunc().getIndex() - 1));
    obj->VpiStructMember(reader.getVpiStructMember());
  }

  void operator()(Shortrealvar::Reader reader, Serializer *const serializer, short_real_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Realvar::Reader reader, Serializer *const serializer, real_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Bytevar::Reader reader, Serializer *const serializer, byte_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Shortintvar::Reader reader, Serializer *const serializer, short_int_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Intvar::Reader reader, Serializer *const serializer, int_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Longintvar::Reader reader, Serializer *const serializer, long_int_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Integervar::Reader reader, Serializer *const serializer, integer_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Timevar::Reader reader, Serializer *const serializer, time_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Arrayvar::Reader reader, Serializer *const serializer, array_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiArrayType(reader.getVpiArrayType());
    if (uint32_t n = reader.getVarselects().size()) {
      std::vector<var_select*>* vect = serializer->var_selectVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->var_selectMaker.objects_[reader.getVarselects()[i] - 1]);
      }
      obj->Var_selects(vect);
    }
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getVariables().size()) {
      std::vector<variables*>* vect = serializer->variablesVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((variables*)serializer->GetObject(reader.getVariables()[i].getType(), reader.getVariables()[i].getIndex() - 1));
      }
      obj->Variables(vect);
    }
  }

  void operator()(Arrayexpr::Reader reader, Serializer *const serializer, array_expr *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<expr*>(obj));
    if (uint32_t n = reader.getExprs().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getExprs()[i].getType(), reader.getExprs()[i].getIndex() - 1));
      }
      obj->Exprs(vect);
    }
  }

  void operator()(Regarray::Reader reader, Serializer *const serializer, reg_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiIsMemory(reader.getVpiIsMemory());
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getRegs().size()) {
      std::vector<reg*>* vect = serializer->regVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->regMaker.objects_[reader.getRegs()[i] - 1]);
      }
      obj->Regs(vect);
    }
  }

  void operator()(Reg::Reader reader, Serializer *const serializer, reg *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    obj->Index((expr*)serializer->GetObject(reader.getIndex().getType(), reader.getIndex().getIndex() - 1));
  }

  void operator()(Packedarrayvar::Reader reader, Serializer *const serializer, packed_array_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiPackedArrayMember(reader.getVpiPackedArrayMember());
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->VpiPacked(reader.getVpiPacked());
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getVarbits().size()) {
      std::vector<var_bit*>* vect = serializer->var_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->var_bitMaker.objects_[reader.getVarbits()[i] - 1]);
      }
      obj->Var_bits(vect);
    }
    if (uint32_t n = reader.getElements().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getElements()[i].getType(), reader.getElements()[i].getIndex() - 1));
      }
      obj->Elements(vect);
    }
    obj->Expr_index((expr*)serializer->GetObject(reader.getExprindex().getType(), reader.getExprindex().getIndex() - 1));
  }

  void operator()(Bitvar::Reader reader, Serializer *const serializer, bit_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getVarbits().size()) {
      std::vector<var_bit*>* vect = serializer->var_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->var_bitMaker.objects_[reader.getVarbits()[i] - 1]);
      }
      obj->Var_bits(vect);
    }
  }

  void operator()(Logicvar::Reader reader, Serializer *const serializer, logic_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getVarbits().size()) {
      std::vector<var_bit*>* vect = serializer->var_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->var_bitMaker.objects_[reader.getVarbits()[i] - 1]);
      }
      obj->Var_bits(vect);
    }
  }

  void operator()(Structvar::Reader reader, Serializer *const serializer, struct_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiPackedArrayMember(reader.getVpiPackedArrayMember());
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    if (uint32_t n = reader.getVarbits().size()) {
      std::vector<var_bit*>* vect = serializer->var_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->var_bitMaker.objects_[reader.getVarbits()[i] - 1]);
      }
      obj->Var_bits(vect);
    }
    if (uint32_t n = reader.getVariables().size()) {
      std::vector<variables*>* vect = serializer->variablesVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((variables*)serializer->GetObject(reader.getVariables()[i].getType(), reader.getVariables()[i].getIndex() - 1));
      }
      obj->Variables(vect);
    }
    obj->Expr_index((expr*)serializer->GetObject(reader.getExprindex().getType(), reader.getExprindex().getIndex() - 1));
  }

  void operator()(Unionvar::Reader reader, Serializer *const serializer, union_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiPackedArrayMember(reader.getVpiPackedArrayMember());
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    if (uint32_t n = reader.getVarbits().size()) {
      std::vector<var_bit*>* vect = serializer->var_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->var_bitMaker.objects_[reader.getVarbits()[i] - 1]);
      }
      obj->Var_bits(vect);
    }
    if (uint32_t n = reader.getVariables().size()) {
      std::vector<variables*>* vect = serializer->variablesVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((variables*)serializer->GetObject(reader.getVariables()[i].getType(), reader.getVariables()[i].getIndex() - 1));
      }
      obj->Variables(vect);
    }
    obj->Expr_index((expr*)serializer->GetObject(reader.getExprindex().getType(), reader.getExprindex().getIndex() - 1));
  }

  void operator()(Enumvar::Reader reader, Serializer *const serializer, enum_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiPackedArrayMember(reader.getVpiPackedArrayMember());
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->Expr_index((expr*)serializer->GetObject(reader.getExprindex().getType(), reader.getExprindex().getIndex() - 1));
  }

  void operator()(Stringvar::Reader reader, Serializer *const serializer, string_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
  }

  void operator()(Chandlevar::Reader reader, Serializer *const serializer, chandle_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->Actual_group((any*)serializer->GetObject(reader.getActualgroup().getType(), reader.getActualgroup().getIndex() - 1));
  }

  void operator()(Varbit::Reader reader, Serializer *const serializer, var_bit *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->Expr_index((expr*)serializer->GetObject(reader.getExprindex().getType(), reader.getExprindex().getIndex() - 1));
    if (uint32_t n = reader.getExprindexes().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getExprindexes()[i].getType(), reader.getExprindexes()[i].getIndex() - 1));
      }
      obj->Expr_indexes(vect);
    }
  }

  void operator()(Taskfunc::Reader reader, Serializer *const serializer, task_func *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiMethod(reader.getVpiMethod());
    obj->VpiAccessType(reader.getVpiAccessType());
    obj->VpiVisibility(reader.getVpiVisibility());
    obj->VpiVirtual(reader.getVpiVirtual());
    obj->VpiAutomatic(reader.getVpiAutomatic());
    obj->VpiDPIPure(reader.getVpiDPIPure());
    obj->VpiDPIContext(reader.getVpiDPIContext());
    obj->VpiDPICStr(reader.getVpiDPICStr());
    obj->VpiDPICIdentifier(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDPICIdentifier(), kUnknownRawSymbol)));
    obj->Left_range((expr*)serializer->GetObject(reader.getLeftrange().getType(), reader.getLeftrange().getIndex() - 1));
    obj->Right_range((expr*)serializer->GetObject(reader.getRightrange().getType(), reader.getRightrange().getIndex() - 1));
    obj->Return((variables*)serializer->GetObject(reader.getReturn().getType(), reader.getReturn().getIndex() - 1));
    if (reader.getClassdefn()) {
      obj->Class_defn(serializer->clocking_blockMaker.objects_[reader.getClassdefn() - 1]);
    }
    if (uint32_t n = reader.getIodecls().size()) {
      std::vector<io_decl*>* vect = serializer->io_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->io_declMaker.objects_[reader.getIodecls()[i] - 1]);
      }
      obj->Io_decls(vect);
    }
    obj->Stmt((any*)serializer->GetObject(reader.getStmt().getType(), reader.getStmt().getIndex() - 1));
    obj->Instance((instance*)serializer->GetObject(reader.getInstance().getType(), reader.getInstance().getIndex() - 1));
  }

  void operator()(Task::Reader reader, Serializer *const serializer, task *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<task_func*>(obj));
  }

  void operator()(Function::Reader reader, Serializer *const serializer, function *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<task_func*>(obj));
    obj->VpiSigned(reader.getVpiSigned());
    obj->VpiSize(reader.getVpiSize());
    obj->VpiFuncType(reader.getVpiFuncType());
  }

  void operator()(Modport::Reader reader, Serializer *const serializer, modport *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getIodecls().size()) {
      std::vector<io_decl*>* vect = serializer->io_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->io_declMaker.objects_[reader.getIodecls()[i] - 1]);
      }
      obj->Io_decls(vect);
    }
    if (reader.getInterfaceinst()) {
      obj->Interface_inst(serializer->interface_instMaker.objects_[reader.getInterfaceinst() - 1]);
    }
  }

  void operator()(Interfacetfdecl::Reader reader, Serializer *const serializer, interface_tf_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiAccessType(reader.getVpiAccessType());
    if (uint32_t n = reader.getTasks().size()) {
      std::vector<task*>* vect = serializer->taskVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->taskMaker.objects_[reader.getTasks()[i] - 1]);
      }
      obj->Tasks(vect);
    }
    if (uint32_t n = reader.getFunctions().size()) {
      std::vector<function*>* vect = serializer->functionVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->functionMaker.objects_[reader.getFunctions()[i] - 1]);
      }
      obj->Functions(vect);
    }
  }

  void operator()(Contassign::Reader reader, Serializer *const serializer, cont_assign *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiNetDeclAssign(reader.getVpiNetDeclAssign());
    obj->VpiStrength0(reader.getVpiStrength0());
    obj->VpiStrength1(reader.getVpiStrength1());
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->Delay((expr*)serializer->GetObject(reader.getDelay().getType(), reader.getDelay().getIndex() - 1));
    obj->Rhs((expr*)serializer->GetObject(reader.getRhs().getType(), reader.getRhs().getIndex() - 1));
    obj->Lhs((expr*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
    if (uint32_t n = reader.getContassignbits().size()) {
      std::vector<cont_assign_bit*>* vect = serializer->cont_assign_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assign_bitMaker.objects_[reader.getContassignbits()[i] - 1]);
      }
      obj->Cont_assign_bits(vect);
    }
  }

  void operator()(Contassignbit::Reader reader, Serializer *const serializer, cont_assign_bit *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiOffset(reader.getVpiOffset());
    obj->VpiNetDeclAssign(reader.getVpiNetDeclAssign());
    obj->VpiStrength0(reader.getVpiStrength0());
    obj->VpiStrength1(reader.getVpiStrength1());
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->Delay((expr*)serializer->GetObject(reader.getDelay().getType(), reader.getDelay().getIndex() - 1));
    obj->Rhs((expr*)serializer->GetObject(reader.getRhs().getType(), reader.getRhs().getIndex() - 1));
    obj->Lhs((expr*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
  }

  void operator()(Ports::Reader reader, Serializer *const serializer, ports *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiPortIndex(reader.getVpiPortIndex());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiPortType(reader.getVpiPortType());
    obj->VpiScalar(reader.getVpiScalar());
    obj->VpiVector(reader.getVpiVector());
    obj->VpiConnByName(reader.getVpiConnByName());
    obj->VpiDirection(reader.getVpiDirection());
    obj->VpiSize(reader.getVpiSize());
    obj->VpiExplicitName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiExplicitName(), kUnknownRawSymbol)));
    obj->High_conn((any*)serializer->GetObject(reader.getHighconn().getType(), reader.getHighconn().getIndex() - 1));
    obj->Low_conn((any*)serializer->GetObject(reader.getLowconn().getType(), reader.getLowconn().getIndex() - 1));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
    obj->Instance((instance*)serializer->GetObject(reader.getInstance().getType(), reader.getInstance().getIndex() - 1));
    if (reader.getModuleinst()) {
      obj->Module_inst(serializer->module_instMaker.objects_[reader.getModuleinst() - 1]);
    }
  }

  void operator()(Port::Reader reader, Serializer *const serializer, port *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<ports*>(obj));
    if (uint32_t n = reader.getBits().size()) {
      std::vector<port_bit*>* vect = serializer->port_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->port_bitMaker.objects_[reader.getBits()[i] - 1]);
      }
      obj->Bits(vect);
    }
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Portbit::Reader reader, Serializer *const serializer, port_bit *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<ports*>(obj));
  }

  void operator()(Checkerport::Reader reader, Serializer *const serializer, checker_port *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<ports*>(obj));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    if (reader.getProperty()) {
      obj->Property(serializer->property_declMaker.objects_[reader.getProperty() - 1]);
    }
    if (reader.getSequence()) {
      obj->Sequence(serializer->sequence_declMaker.objects_[reader.getSequence() - 1]);
    }
  }

  void operator()(Checkerinstport::Reader reader, Serializer *const serializer, checker_inst_port *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (reader.getProperty()) {
      obj->Property(serializer->property_instMaker.objects_[reader.getProperty() - 1]);
    }
    if (reader.getSequence()) {
      obj->Sequence(serializer->sequence_instMaker.objects_[reader.getSequence() - 1]);
    }
  }

  void operator()(Primitive::Reader reader, Serializer *const serializer, primitive *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiArrayMember(reader.getVpiArrayMember());
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->VpiDelay(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDelay(), kUnknownRawSymbol)));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiPrimType(reader.getVpiPrimType());
    obj->VpiStrength0(reader.getVpiStrength0());
    obj->VpiStrength1(reader.getVpiStrength1());
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->Delay((expr*)serializer->GetObject(reader.getDelay().getType(), reader.getDelay().getIndex() - 1));
    obj->Index((expr*)serializer->GetObject(reader.getIndex().getType(), reader.getIndex().getIndex() - 1));
    if (uint32_t n = reader.getPrimterms().size()) {
      std::vector<prim_term*>* vect = serializer->prim_termVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->prim_termMaker.objects_[reader.getPrimterms()[i] - 1]);
      }
      obj->Prim_terms(vect);
    }
  }

  void operator()(Gate::Reader reader, Serializer *const serializer, gate *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<primitive*>(obj));
  }

  void operator()(Switchtran::Reader reader, Serializer *const serializer, switch_tran *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<primitive*>(obj));
  }

  void operator()(Udp::Reader reader, Serializer *const serializer, udp *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<primitive*>(obj));
    if (reader.getUdpdefn()) {
      obj->Udp_defn(serializer->udp_defnMaker.objects_[reader.getUdpdefn() - 1]);
    }
  }

  void operator()(Modpath::Reader reader, Serializer *const serializer, mod_path *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Tchk::Reader reader, Serializer *const serializer, tchk *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (reader.getModuleinst()) {
      obj->Module_inst(serializer->module_instMaker.objects_[reader.getModuleinst() - 1]);
    }
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    if (uint32_t n = reader.getExprtchkterms().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getExprtchkterms()[i].getType(), reader.getExprtchkterms()[i].getIndex() - 1));
      }
      obj->Expr_tchk_terms(vect);
    }
    if (reader.getTchkrefterm()) {
      obj->Tchk_ref_term(serializer->tchk_termMaker.objects_[reader.getTchkrefterm() - 1]);
    }
    if (reader.getTchkdataterm()) {
      obj->Tchk_data_term(serializer->tchk_termMaker.objects_[reader.getTchkdataterm() - 1]);
    }
    if (reader.getReg()) {
      obj->Reg(serializer->regMaker.objects_[reader.getReg() - 1]);
    }
    obj->VpiDelay(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDelay(), kUnknownRawSymbol)));
    obj->VpiTchkType(reader.getVpiTchkType());
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Range::Reader reader, Serializer *const serializer, range *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiSize(reader.getVpiSize());
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
  }

  void operator()(Udpdefn::Reader reader, Serializer *const serializer, udp_defn *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->VpiSize(reader.getVpiSize());
    obj->VpiProtected(reader.getVpiProtected());
    obj->VpiPrimType(reader.getVpiPrimType());
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    if (uint32_t n = reader.getIodecls().size()) {
      std::vector<io_decl*>* vect = serializer->io_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->io_declMaker.objects_[reader.getIodecls()[i] - 1]);
      }
      obj->Io_decls(vect);
    }
    if (uint32_t n = reader.getTableentrys().size()) {
      std::vector<table_entry*>* vect = serializer->table_entryVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->table_entryMaker.objects_[reader.getTableentrys()[i] - 1]);
      }
      obj->Table_entrys(vect);
    }
    if (reader.getInitial()) {
      obj->Initial(serializer->initialMaker.objects_[reader.getInitial() - 1]);
    }
  }

  void operator()(Tableentry::Reader reader, Serializer *const serializer, table_entry *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiSize(reader.getVpiSize());
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Iodecl::Reader reader, Serializer *const serializer, io_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDirection(reader.getVpiDirection());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiScalar(reader.getVpiScalar());
    obj->VpiSigned(reader.getVpiSigned());
    obj->VpiSize(reader.getVpiSize());
    obj->VpiVector(reader.getVpiVector());
    obj->Expr((any*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
  }

  void operator()(Aliasstmt::Reader reader, Serializer *const serializer, alias_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Clockingblock::Reader reader, Serializer *const serializer, clocking_block *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiInputEdge(reader.getVpiInputEdge());
    obj->VpiOutputEdge(reader.getVpiOutputEdge());
    if (reader.getInputskew()) {
      obj->Input_skew(serializer->delay_controlMaker.objects_[reader.getInputskew() - 1]);
    }
    if (reader.getOutputskew()) {
      obj->Output_skew(serializer->delay_controlMaker.objects_[reader.getOutputskew() - 1]);
    }
    if (reader.getClockingevent()) {
      obj->Clocking_event(serializer->event_controlMaker.objects_[reader.getClockingevent() - 1]);
    }
    obj->Instance((instance*)serializer->GetObject(reader.getInstance().getType(), reader.getInstance().getIndex() - 1));
    if (uint32_t n = reader.getClockingiodecls().size()) {
      std::vector<clocking_io_decl*>* vect = serializer->clocking_io_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->clocking_io_declMaker.objects_[reader.getClockingiodecls()[i] - 1]);
      }
      obj->Clocking_io_decls(vect);
    }
    if (reader.getPrefix()) {
      obj->Prefix(serializer->virtual_interface_varMaker.objects_[reader.getPrefix() - 1]);
    }
    if (reader.getActual()) {
      obj->Actual(serializer->clocking_blockMaker.objects_[reader.getActual() - 1]);
    }
  }

  void operator()(Clockingiodecl::Reader reader, Serializer *const serializer, clocking_io_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDirection(reader.getVpiDirection());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiInputEdge(reader.getVpiInputEdge());
    obj->VpiOutputEdge(reader.getVpiOutputEdge());
    if (reader.getInputskew()) {
      obj->Input_skew(serializer->delay_controlMaker.objects_[reader.getInputskew() - 1]);
    }
    if (reader.getOutputskew()) {
      obj->Output_skew(serializer->delay_controlMaker.objects_[reader.getOutputskew() - 1]);
    }
    obj->Expr((any*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
  }

  void operator()(Paramassign::Reader reader, Serializer *const serializer, param_assign *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiConnByName(reader.getVpiConnByName());
    obj->VpiOverriden(reader.getVpiOverriden());
    obj->Rhs((any*)serializer->GetObject(reader.getRhs().getType(), reader.getRhs().getIndex() - 1));
    obj->Lhs((any*)serializer->GetObject(reader.getLhs().getType(), reader.getLhs().getIndex() - 1));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Instancearray::Reader reader, Serializer *const serializer, instance_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiSize(reader.getVpiSize());
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getInstances().size()) {
      std::vector<instance*>* vect = serializer->instanceVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((instance*)serializer->GetObject(reader.getInstances()[i].getType(), reader.getInstances()[i].getIndex() - 1));
      }
      obj->Instances(vect);
    }
    if (uint32_t n = reader.getModules().size()) {
      std::vector<module_inst*>* vect = serializer->module_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->module_instMaker.objects_[reader.getModules()[i] - 1]);
      }
      obj->Modules(vect);
    }
    obj->Elem_typespec((ref_typespec*)serializer->GetObject(reader.getElemtypespec().getType(), reader.getElemtypespec().getIndex() - 1));
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<port*>* vect = serializer->portVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->portMaker.objects_[reader.getPorts()[i] - 1]);
      }
      obj->Ports(vect);
    }
  }

  void operator()(Interfacearray::Reader reader, Serializer *const serializer, interface_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance_array*>(obj));
    if (uint32_t n = reader.getParamassigns().size()) {
      std::vector<param_assign*>* vect = serializer->param_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->param_assignMaker.objects_[reader.getParamassigns()[i] - 1]);
      }
      obj->Param_assigns(vect);
    }
  }

  void operator()(Programarray::Reader reader, Serializer *const serializer, program_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance_array*>(obj));
  }

  void operator()(Modulearray::Reader reader, Serializer *const serializer, module_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance_array*>(obj));
    if (uint32_t n = reader.getParamassigns().size()) {
      std::vector<param_assign*>* vect = serializer->param_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->param_assignMaker.objects_[reader.getParamassigns()[i] - 1]);
      }
      obj->Param_assigns(vect);
    }
  }

  void operator()(Primitivearray::Reader reader, Serializer *const serializer, primitive_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance_array*>(obj));
    obj->Delay((expr*)serializer->GetObject(reader.getDelay().getType(), reader.getDelay().getIndex() - 1));
    if (uint32_t n = reader.getPrimitives().size()) {
      std::vector<primitive*>* vect = serializer->primitiveVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((primitive*)serializer->GetObject(reader.getPrimitives()[i].getType(), reader.getPrimitives()[i].getIndex() - 1));
      }
      obj->Primitives(vect);
    }
  }

  void operator()(Gatearray::Reader reader, Serializer *const serializer, gate_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<primitive_array*>(obj));
  }

  void operator()(Switcharray::Reader reader, Serializer *const serializer, switch_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<primitive_array*>(obj));
  }

  void operator()(Udparray::Reader reader, Serializer *const serializer, udp_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<primitive_array*>(obj));
  }

  void operator()(Typespec::Reader reader, Serializer *const serializer, typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->Typedef_alias((ref_typespec*)serializer->GetObject(reader.getTypedefalias().getType(), reader.getTypedefalias().getIndex() - 1));
    obj->Instance((instance*)serializer->GetObject(reader.getInstance().getType(), reader.getInstance().getIndex() - 1));
  }

  void operator()(Netdrivers::Reader reader, Serializer *const serializer, net_drivers *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Netloads::Reader reader, Serializer *const serializer, net_loads *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Primterm::Reader reader, Serializer *const serializer, prim_term *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDirection(reader.getVpiDirection());
    obj->VpiTermIndex(reader.getVpiTermIndex());
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
  }

  void operator()(Pathterm::Reader reader, Serializer *const serializer, path_term *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Tchkterm::Reader reader, Serializer *const serializer, tchk_term *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    obj->Condition((expr*)serializer->GetObject(reader.getCondition().getType(), reader.getCondition().getIndex() - 1));
    obj->VpiEdge(reader.getVpiEdge());
  }

  void operator()(Nets::Reader reader, Serializer *const serializer, nets *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<simple_expr*>(obj));
    obj->VpiArrayMember(reader.getVpiArrayMember());
    obj->VpiConstantSelect(reader.getVpiConstantSelect());
    obj->VpiExpanded(reader.getVpiExpanded());
    obj->VpiImplicitDecl(reader.getVpiImplicitDecl());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiNetDeclAssign(reader.getVpiNetDeclAssign());
    obj->VpiNetType(reader.getVpiNetType());
    obj->VpiResolvedNetType(reader.getVpiResolvedNetType());
    obj->VpiScalar(reader.getVpiScalar());
    obj->VpiExplicitScalared(reader.getVpiExplicitScalared());
    obj->VpiSigned(reader.getVpiSigned());
    obj->VpiStrength0(reader.getVpiStrength0());
    obj->VpiStrength1(reader.getVpiStrength1());
    obj->VpiChargeStrength(reader.getVpiChargeStrength());
    obj->VpiVector(reader.getVpiVector());
    obj->VpiExplicitVectored(reader.getVpiExplicitVectored());
    obj->VpiStructUnionMember(reader.getVpiStructUnionMember());
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<ports*>* vect = serializer->portsVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((ports*)serializer->GetObject(reader.getPorts()[i].getType(), reader.getPorts()[i].getIndex() - 1));
      }
      obj->Ports(vect);
    }
    if (uint32_t n = reader.getDrivers().size()) {
      std::vector<net_drivers*>* vect = serializer->net_driversVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((net_drivers*)serializer->GetObject(reader.getDrivers()[i].getType(), reader.getDrivers()[i].getIndex() - 1));
      }
      obj->Drivers(vect);
    }
    if (uint32_t n = reader.getLoads().size()) {
      std::vector<net_loads*>* vect = serializer->net_loadsVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((net_loads*)serializer->GetObject(reader.getLoads()[i].getType(), reader.getLoads()[i].getIndex() - 1));
      }
      obj->Loads(vect);
    }
    if (uint32_t n = reader.getLocaldrivers().size()) {
      std::vector<net_drivers*>* vect = serializer->net_driversVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((net_drivers*)serializer->GetObject(reader.getLocaldrivers()[i].getType(), reader.getLocaldrivers()[i].getIndex() - 1));
      }
      obj->Local_drivers(vect);
    }
    if (uint32_t n = reader.getLocalloads().size()) {
      std::vector<net_loads*>* vect = serializer->net_loadsVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((net_loads*)serializer->GetObject(reader.getLocalloads()[i].getType(), reader.getLocalloads()[i].getIndex() - 1));
      }
      obj->Local_loads(vect);
    }
    if (uint32_t n = reader.getPrimterms().size()) {
      std::vector<prim_term*>* vect = serializer->prim_termVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->prim_termMaker.objects_[reader.getPrimterms()[i] - 1]);
      }
      obj->Prim_terms(vect);
    }
    if (uint32_t n = reader.getContassigns().size()) {
      std::vector<cont_assign*>* vect = serializer->cont_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assignMaker.objects_[reader.getContassigns()[i] - 1]);
      }
      obj->Cont_assigns(vect);
    }
    if (uint32_t n = reader.getPathterms().size()) {
      std::vector<path_term*>* vect = serializer->path_termVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->path_termMaker.objects_[reader.getPathterms()[i] - 1]);
      }
      obj->Path_terms(vect);
    }
    if (uint32_t n = reader.getTchkterms().size()) {
      std::vector<tchk_term*>* vect = serializer->tchk_termVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->tchk_termMaker.objects_[reader.getTchkterms()[i] - 1]);
      }
      obj->Tchk_terms(vect);
    }
    obj->Sim_net((nets*)serializer->GetObject(reader.getSimnet().getType(), reader.getSimnet().getIndex() - 1));
    if (reader.getModuleinst()) {
      obj->Module_inst(serializer->module_instMaker.objects_[reader.getModuleinst() - 1]);
    }
  }

  void operator()(Netbit::Reader reader, Serializer *const serializer, net_bit *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<nets*>(obj));
    if (uint32_t n = reader.getExprs().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getExprs()[i].getType(), reader.getExprs()[i].getIndex() - 1));
      }
      obj->Exprs(vect);
    }
  }

  void operator()(Net::Reader reader, Serializer *const serializer, net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<nets*>(obj));
    if (uint32_t n = reader.getNetbits().size()) {
      std::vector<net_bit*>* vect = serializer->net_bitVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->net_bitMaker.objects_[reader.getNetbits()[i] - 1]);
      }
      obj->Net_bits(vect);
    }
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    if (uint32_t n = reader.getExprs().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getExprs()[i].getType(), reader.getExprs()[i].getIndex() - 1));
      }
      obj->Exprs(vect);
    }
  }

  void operator()(Structnet::Reader reader, Serializer *const serializer, struct_net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<net*>(obj));
    obj->VpiPackedArrayMember(reader.getVpiPackedArrayMember());
    if (uint32_t n = reader.getNets().size()) {
      std::vector<nets*>* vect = serializer->netsVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((nets*)serializer->GetObject(reader.getNets()[i].getType(), reader.getNets()[i].getIndex() - 1));
      }
      obj->Nets(vect);
    }
  }

  void operator()(Enumnet::Reader reader, Serializer *const serializer, enum_net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<net*>(obj));
    obj->VpiPackedArrayMember(reader.getVpiPackedArrayMember());
  }

  void operator()(Integernet::Reader reader, Serializer *const serializer, integer_net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<net*>(obj));
  }

  void operator()(Timenet::Reader reader, Serializer *const serializer, time_net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<net*>(obj));
  }

  void operator()(Logicnet::Reader reader, Serializer *const serializer, logic_net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<net*>(obj));
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
  }

  void operator()(Arraynet::Reader reader, Serializer *const serializer, array_net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<nets*>(obj));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    if (uint32_t n = reader.getNets().size()) {
      std::vector<net*>* vect = serializer->netVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((net*)serializer->GetObject(reader.getNets()[i].getType(), reader.getNets()[i].getIndex() - 1));
      }
      obj->Nets(vect);
    }
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Packedarraynet::Reader reader, Serializer *const serializer, packed_array_net *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<net*>(obj));
    obj->VpiPackedArrayMember(reader.getVpiPackedArrayMember());
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    if (uint32_t n = reader.getElements().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getElements()[i].getType(), reader.getElements()[i].getIndex() - 1));
      }
      obj->Elements(vect);
    }
  }

  void operator()(Eventtypespec::Reader reader, Serializer *const serializer, event_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
  }

  void operator()(Namedevent::Reader reader, Serializer *const serializer, named_event *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiArrayMember(reader.getVpiArrayMember());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiAutomatic(reader.getVpiAutomatic());
    obj->VpiAllocScheme(reader.getVpiAllocScheme());
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    if (reader.getEventtypespec()) {
      obj->Event_typespec(serializer->ref_typespecMaker.objects_[reader.getEventtypespec() - 1]);
    }
    if (uint32_t n = reader.getThreads().size()) {
      std::vector<thread_obj*>* vect = serializer->thread_objVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->thread_objMaker.objects_[reader.getThreads()[i] - 1]);
      }
      obj->Threads(vect);
    }
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Namedeventarray::Reader reader, Serializer *const serializer, named_event_array *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Parameter::Reader reader, Serializer *const serializer, parameter *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<simple_expr*>(obj));
    obj->VpiConstType(reader.getVpiConstType());
    obj->VpiSigned(reader.getVpiSigned());
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_range((expr*)serializer->GetObject(reader.getLeftrange().getType(), reader.getLeftrange().getIndex() - 1));
    obj->Right_range((expr*)serializer->GetObject(reader.getRightrange().getType(), reader.getRightrange().getIndex() - 1));
    obj->VpiLocalParam(reader.getVpiLocalParam());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiImported(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiImported(), kUnknownRawSymbol)));
  }

  void operator()(Defparam::Reader reader, Serializer *const serializer, def_param *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->Rhs((expr*)serializer->GetObject(reader.getRhs().getType(), reader.getRhs().getIndex() - 1));
    if (reader.getLhs()) {
      obj->Lhs(serializer->parameterMaker.objects_[reader.getLhs() - 1]);
    }
  }

  void operator()(Specparam::Reader reader, Serializer *const serializer, spec_param *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<simple_expr*>(obj));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Classtypespec::Reader reader, Serializer *const serializer, class_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiClassType(reader.getVpiClassType());
    obj->VpiAutomatic(reader.getVpiAutomatic());
    if (reader.getExtends()) {
      obj->Extends(serializer->ref_typespecMaker.objects_[reader.getExtends() - 1]);
    }
    if (uint32_t n = reader.getVariables().size()) {
      std::vector<variables*>* vect = serializer->variablesVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((variables*)serializer->GetObject(reader.getVariables()[i].getType(), reader.getVariables()[i].getIndex() - 1));
      }
      obj->Variables(vect);
    }
    if (uint32_t n = reader.getTaskfuncs().size()) {
      std::vector<task_func*>* vect = serializer->task_funcVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((task_func*)serializer->GetObject(reader.getTaskfuncs()[i].getType(), reader.getTaskfuncs()[i].getIndex() - 1));
      }
      obj->Task_funcs(vect);
    }
    if (uint32_t n = reader.getConstraints().size()) {
      std::vector<constraint*>* vect = serializer->constraintVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->constraintMaker.objects_[reader.getConstraints()[i] - 1]);
      }
      obj->Constraints(vect);
    }
    if (uint32_t n = reader.getParameters().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getParameters()[i].getType(), reader.getParameters()[i].getIndex() - 1));
      }
      obj->Parameters(vect);
    }
    if (uint32_t n = reader.getParamassigns().size()) {
      std::vector<param_assign*>* vect = serializer->param_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->param_assignMaker.objects_[reader.getParamassigns()[i] - 1]);
      }
      obj->Param_assigns(vect);
    }
    if (uint32_t n = reader.getVirtualinterfacevars().size()) {
      std::vector<virtual_interface_var*>* vect = serializer->virtual_interface_varVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->virtual_interface_varMaker.objects_[reader.getVirtualinterfacevars()[i] - 1]);
      }
      obj->Virtual_interface_vars(vect);
    }
    if (uint32_t n = reader.getNamedevents().size()) {
      std::vector<named_event*>* vect = serializer->named_eventVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->named_eventMaker.objects_[reader.getNamedevents()[i] - 1]);
      }
      obj->Named_events(vect);
    }
    if (uint32_t n = reader.getNamedeventarrays().size()) {
      std::vector<named_event_array*>* vect = serializer->named_event_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->named_event_arrayMaker.objects_[reader.getNamedeventarrays()[i] - 1]);
      }
      obj->Named_event_arrays(vect);
    }
    if (uint32_t n = reader.getScopes().size()) {
      std::vector<scope*>* vect = serializer->scopeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((scope*)serializer->GetObject(reader.getScopes()[i].getType(), reader.getScopes()[i].getIndex() - 1));
      }
      obj->Scopes(vect);
    }
    if (reader.getClassdefn()) {
      obj->Class_defn(serializer->class_defnMaker.objects_[reader.getClassdefn() - 1]);
    }
  }

  void operator()(Extends::Reader reader, Serializer *const serializer, extends *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (reader.getClasstypespec()) {
      obj->Class_typespec(serializer->ref_typespecMaker.objects_[reader.getClasstypespec() - 1]);
    }
    if (uint32_t n = reader.getArguments().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getArguments()[i].getType(), reader.getArguments()[i].getIndex() - 1));
      }
      obj->Arguments(vect);
    }
  }

  void operator()(Classdefn::Reader reader, Serializer *const serializer, class_defn *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiVirtual(reader.getVpiVirtual());
    obj->VpiAutomatic(reader.getVpiAutomatic());
    if (reader.getExtends()) {
      obj->Extends(serializer->extendsMaker.objects_[reader.getExtends() - 1]);
    }
    if (uint32_t n = reader.getTaskfuncs().size()) {
      std::vector<task_func*>* vect = serializer->task_funcVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((task_func*)serializer->GetObject(reader.getTaskfuncs()[i].getType(), reader.getTaskfuncs()[i].getIndex() - 1));
      }
      obj->Task_funcs(vect);
    }
    if (uint32_t n = reader.getConstraints().size()) {
      std::vector<constraint*>* vect = serializer->constraintVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->constraintMaker.objects_[reader.getConstraints()[i] - 1]);
      }
      obj->Constraints(vect);
    }
    if (uint32_t n = reader.getDeriveds().size()) {
      std::vector<class_defn*>* vect = serializer->class_defnVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->class_defnMaker.objects_[reader.getDeriveds()[i] - 1]);
      }
      obj->Deriveds(vect);
    }
    if (uint32_t n = reader.getClasstypespecs().size()) {
      std::vector<class_typespec*>* vect = serializer->class_typespecVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->class_typespecMaker.objects_[reader.getClasstypespecs()[i] - 1]);
      }
      obj->Class_typespecs(vect);
    }
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Classobj::Reader reader, Serializer *const serializer, class_obj *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiObjId(reader.getVpiObjId());
    if (reader.getClasstypespec()) {
      obj->Class_typespec(serializer->ref_typespecMaker.objects_[reader.getClasstypespec() - 1]);
    }
    if (uint32_t n = reader.getThreads().size()) {
      std::vector<thread_obj*>* vect = serializer->thread_objVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->thread_objMaker.objects_[reader.getThreads()[i] - 1]);
      }
      obj->Threads(vect);
    }
    if (uint32_t n = reader.getMessages().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getMessages()[i].getType(), reader.getMessages()[i].getIndex() - 1));
      }
      obj->Messages(vect);
    }
    if (uint32_t n = reader.getTaskfuncs().size()) {
      std::vector<task_func*>* vect = serializer->task_funcVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((task_func*)serializer->GetObject(reader.getTaskfuncs()[i].getType(), reader.getTaskfuncs()[i].getIndex() - 1));
      }
      obj->Task_funcs(vect);
    }
    if (uint32_t n = reader.getConstraints().size()) {
      std::vector<constraint*>* vect = serializer->constraintVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->constraintMaker.objects_[reader.getConstraints()[i] - 1]);
      }
      obj->Constraints(vect);
    }
  }

  void operator()(Classvar::Reader reader, Serializer *const serializer, class_var *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<variables*>(obj));
    obj->VpiObjId(reader.getVpiObjId());
    if (reader.getClassobj()) {
      obj->Class_obj(serializer->class_objMaker.objects_[reader.getClassobj() - 1]);
    }
  }

  void operator()(Instance::Reader reader, Serializer *const serializer, instance *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<scope*>(obj));
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->VpiArrayMember(reader.getVpiArrayMember());
    obj->VpiCellInstance(reader.getVpiCellInstance());
    obj->VpiDefNetType(reader.getVpiDefNetType());
    obj->VpiDefFile(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefFile(), kUnknownRawSymbol)));
    obj->VpiDefLineNo(reader.getVpiDefLineNo());
    obj->VpiDefDelayMode(reader.getVpiDefDelayMode());
    obj->VpiProtected(reader.getVpiProtected());
    obj->VpiTimePrecision(reader.getVpiTimePrecision());
    obj->VpiTimeUnit(reader.getVpiTimeUnit());
    obj->VpiUnconnDrive(reader.getVpiUnconnDrive());
    obj->VpiLibrary(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiLibrary(), kUnknownRawSymbol)));
    obj->VpiCell(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiCell(), kUnknownRawSymbol)));
    obj->VpiConfig(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiConfig(), kUnknownRawSymbol)));
    obj->VpiAutomatic(reader.getVpiAutomatic());
    obj->VpiTop(reader.getVpiTop());
    if (uint32_t n = reader.getPrograms().size()) {
      std::vector<program*>* vect = serializer->programVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->programMaker.objects_[reader.getPrograms()[i] - 1]);
      }
      obj->Programs(vect);
    }
    if (uint32_t n = reader.getProgramarrays().size()) {
      std::vector<program*>* vect = serializer->programVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->programMaker.objects_[reader.getProgramarrays()[i] - 1]);
      }
      obj->Program_arrays(vect);
    }
    if (uint32_t n = reader.getClassdefns().size()) {
      std::vector<class_defn*>* vect = serializer->class_defnVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->class_defnMaker.objects_[reader.getClassdefns()[i] - 1]);
      }
      obj->Class_defns(vect);
    }
    if (uint32_t n = reader.getTaskfuncs().size()) {
      std::vector<task_func*>* vect = serializer->task_funcVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((task_func*)serializer->GetObject(reader.getTaskfuncs()[i].getType(), reader.getTaskfuncs()[i].getIndex() - 1));
      }
      obj->Task_funcs(vect);
    }
    if (uint32_t n = reader.getNets().size()) {
      std::vector<net*>* vect = serializer->netVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((net*)serializer->GetObject(reader.getNets()[i].getType(), reader.getNets()[i].getIndex() - 1));
      }
      obj->Nets(vect);
    }
    if (uint32_t n = reader.getArraynets().size()) {
      std::vector<array_net*>* vect = serializer->array_netVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->array_netMaker.objects_[reader.getArraynets()[i] - 1]);
      }
      obj->Array_nets(vect);
    }
    if (uint32_t n = reader.getSpecparams().size()) {
      std::vector<spec_param*>* vect = serializer->spec_paramVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->spec_paramMaker.objects_[reader.getSpecparams()[i] - 1]);
      }
      obj->Spec_params(vect);
    }
    if (uint32_t n = reader.getAssertions().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getAssertions()[i].getType(), reader.getAssertions()[i].getIndex() - 1));
      }
      obj->Assertions(vect);
    }
    if (reader.getModuleinst()) {
      obj->Module_inst(serializer->module_instMaker.objects_[reader.getModuleinst() - 1]);
    }
    obj->Instance((instance*)serializer->GetObject(reader.getInstance().getType(), reader.getInstance().getIndex() - 1));
  }

  void operator()(Interfaceinst::Reader reader, Serializer *const serializer, interface_inst *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance*>(obj));
    obj->VpiIndex(reader.getVpiIndex());
    if (uint32_t n = reader.getInterfacetfdecls().size()) {
      std::vector<interface_tf_decl*>* vect = serializer->interface_tf_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_tf_declMaker.objects_[reader.getInterfacetfdecls()[i] - 1]);
      }
      obj->Interface_tf_decls(vect);
    }
    if (uint32_t n = reader.getModports().size()) {
      std::vector<modport*>* vect = serializer->modportVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->modportMaker.objects_[reader.getModports()[i] - 1]);
      }
      obj->Modports(vect);
    }
    if (reader.getGlobalclocking()) {
      obj->Global_clocking(serializer->clocking_blockMaker.objects_[reader.getGlobalclocking() - 1]);
    }
    if (reader.getDefaultclocking()) {
      obj->Default_clocking(serializer->clocking_blockMaker.objects_[reader.getDefaultclocking() - 1]);
    }
    obj->Expr_dist((any*)serializer->GetObject(reader.getExprdist().getType(), reader.getExprdist().getIndex() - 1));
    obj->Instance_array((instance_array*)serializer->GetObject(reader.getInstancearray().getType(), reader.getInstancearray().getIndex() - 1));
    if (uint32_t n = reader.getModpaths().size()) {
      std::vector<mod_path*>* vect = serializer->mod_pathVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->mod_pathMaker.objects_[reader.getModpaths()[i] - 1]);
      }
      obj->Mod_paths(vect);
    }
    if (uint32_t n = reader.getContassigns().size()) {
      std::vector<cont_assign*>* vect = serializer->cont_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assignMaker.objects_[reader.getContassigns()[i] - 1]);
      }
      obj->Cont_assigns(vect);
    }
    if (uint32_t n = reader.getClockingblocks().size()) {
      std::vector<clocking_block*>* vect = serializer->clocking_blockVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->clocking_blockMaker.objects_[reader.getClockingblocks()[i] - 1]);
      }
      obj->Clocking_blocks(vect);
    }
    if (uint32_t n = reader.getInterfaces().size()) {
      std::vector<interface_inst*>* vect = serializer->interface_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_instMaker.objects_[reader.getInterfaces()[i] - 1]);
      }
      obj->Interfaces(vect);
    }
    if (uint32_t n = reader.getInterfacearrays().size()) {
      std::vector<interface_array*>* vect = serializer->interface_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_arrayMaker.objects_[reader.getInterfacearrays()[i] - 1]);
      }
      obj->Interface_arrays(vect);
    }
    if (uint32_t n = reader.getProcess().size()) {
      std::vector<process_stmt*>* vect = serializer->process_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((process_stmt*)serializer->GetObject(reader.getProcess()[i].getType(), reader.getProcess()[i].getIndex() - 1));
      }
      obj->Process(vect);
    }
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<port*>* vect = serializer->portVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->portMaker.objects_[reader.getPorts()[i] - 1]);
      }
      obj->Ports(vect);
    }
    if (uint32_t n = reader.getGenscopearrays().size()) {
      std::vector<gen_scope_array*>* vect = serializer->gen_scope_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->gen_scope_arrayMaker.objects_[reader.getGenscopearrays()[i] - 1]);
      }
      obj->Gen_scope_arrays(vect);
    }
    if (uint32_t n = reader.getElabtasks().size()) {
      std::vector<tf_call*>* vect = serializer->tf_callVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((tf_call*)serializer->GetObject(reader.getElabtasks()[i].getType(), reader.getElabtasks()[i].getIndex() - 1));
      }
      obj->Elab_tasks(vect);
    }
    if (uint32_t n = reader.getGenstmts().size()) {
      std::vector<gen_stmt*>* vect = serializer->gen_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((gen_stmt*)serializer->GetObject(reader.getGenstmts()[i].getType(), reader.getGenstmts()[i].getIndex() - 1));
      }
      obj->Gen_stmts(vect);
    }
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Program::Reader reader, Serializer *const serializer, program *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance*>(obj));
    obj->VpiIndex(reader.getVpiIndex());
    if (reader.getDefaultclocking()) {
      obj->Default_clocking(serializer->clocking_blockMaker.objects_[reader.getDefaultclocking() - 1]);
    }
    obj->Instance_array((instance_array*)serializer->GetObject(reader.getInstancearray().getType(), reader.getInstancearray().getIndex() - 1));
    if (uint32_t n = reader.getInterfaces().size()) {
      std::vector<interface_inst*>* vect = serializer->interface_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_instMaker.objects_[reader.getInterfaces()[i] - 1]);
      }
      obj->Interfaces(vect);
    }
    obj->Expr_dist((any*)serializer->GetObject(reader.getExprdist().getType(), reader.getExprdist().getIndex() - 1));
    if (uint32_t n = reader.getInterfacearrays().size()) {
      std::vector<interface_array*>* vect = serializer->interface_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_arrayMaker.objects_[reader.getInterfacearrays()[i] - 1]);
      }
      obj->Interface_arrays(vect);
    }
    if (uint32_t n = reader.getProcess().size()) {
      std::vector<process_stmt*>* vect = serializer->process_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((process_stmt*)serializer->GetObject(reader.getProcess()[i].getType(), reader.getProcess()[i].getIndex() - 1));
      }
      obj->Process(vect);
    }
    if (uint32_t n = reader.getContassigns().size()) {
      std::vector<cont_assign*>* vect = serializer->cont_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assignMaker.objects_[reader.getContassigns()[i] - 1]);
      }
      obj->Cont_assigns(vect);
    }
    if (uint32_t n = reader.getClockingblocks().size()) {
      std::vector<clocking_block*>* vect = serializer->clocking_blockVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->clocking_blockMaker.objects_[reader.getClockingblocks()[i] - 1]);
      }
      obj->Clocking_blocks(vect);
    }
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<port*>* vect = serializer->portVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->portMaker.objects_[reader.getPorts()[i] - 1]);
      }
      obj->Ports(vect);
    }
    if (uint32_t n = reader.getGenscopearrays().size()) {
      std::vector<gen_scope_array*>* vect = serializer->gen_scope_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->gen_scope_arrayMaker.objects_[reader.getGenscopearrays()[i] - 1]);
      }
      obj->Gen_scope_arrays(vect);
    }
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Package::Reader reader, Serializer *const serializer, package *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance*>(obj));
    obj->VpiUnit(reader.getVpiUnit());
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Moduleinst::Reader reader, Serializer *const serializer, module_inst *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance*>(obj));
    obj->VpiIndex(reader.getVpiIndex());
    obj->VpiTopModule(reader.getVpiTopModule());
    obj->VpiDefDecayTime(reader.getVpiDefDecayTime());
    if (reader.getGlobalclocking()) {
      obj->Global_clocking(serializer->clocking_blockMaker.objects_[reader.getGlobalclocking() - 1]);
    }
    if (reader.getDefaultclocking()) {
      obj->Default_clocking(serializer->clocking_blockMaker.objects_[reader.getDefaultclocking() - 1]);
    }
    obj->Expr_dist((any*)serializer->GetObject(reader.getExprdist().getType(), reader.getExprdist().getIndex() - 1));
    if (reader.getModulearray()) {
      obj->Module_array(serializer->module_arrayMaker.objects_[reader.getModulearray() - 1]);
    }
    obj->Instance_array((instance_array*)serializer->GetObject(reader.getInstancearray().getType(), reader.getInstancearray().getIndex() - 1));
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<port*>* vect = serializer->portVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->portMaker.objects_[reader.getPorts()[i] - 1]);
      }
      obj->Ports(vect);
    }
    if (uint32_t n = reader.getInterfaces().size()) {
      std::vector<interface_inst*>* vect = serializer->interface_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_instMaker.objects_[reader.getInterfaces()[i] - 1]);
      }
      obj->Interfaces(vect);
    }
    if (uint32_t n = reader.getInterfacearrays().size()) {
      std::vector<interface_array*>* vect = serializer->interface_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_arrayMaker.objects_[reader.getInterfacearrays()[i] - 1]);
      }
      obj->Interface_arrays(vect);
    }
    if (uint32_t n = reader.getProcess().size()) {
      std::vector<process_stmt*>* vect = serializer->process_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((process_stmt*)serializer->GetObject(reader.getProcess()[i].getType(), reader.getProcess()[i].getIndex() - 1));
      }
      obj->Process(vect);
    }
    if (uint32_t n = reader.getModules().size()) {
      std::vector<module_inst*>* vect = serializer->module_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->module_instMaker.objects_[reader.getModules()[i] - 1]);
      }
      obj->Modules(vect);
    }
    if (uint32_t n = reader.getModulearrays().size()) {
      std::vector<module_array*>* vect = serializer->module_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->module_arrayMaker.objects_[reader.getModulearrays()[i] - 1]);
      }
      obj->Module_arrays(vect);
    }
    if (uint32_t n = reader.getGenscopearrays().size()) {
      std::vector<gen_scope_array*>* vect = serializer->gen_scope_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->gen_scope_arrayMaker.objects_[reader.getGenscopearrays()[i] - 1]);
      }
      obj->Gen_scope_arrays(vect);
    }
    if (uint32_t n = reader.getContassigns().size()) {
      std::vector<cont_assign*>* vect = serializer->cont_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assignMaker.objects_[reader.getContassigns()[i] - 1]);
      }
      obj->Cont_assigns(vect);
    }
    if (uint32_t n = reader.getPrimitives().size()) {
      std::vector<primitive*>* vect = serializer->primitiveVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((primitive*)serializer->GetObject(reader.getPrimitives()[i].getType(), reader.getPrimitives()[i].getIndex() - 1));
      }
      obj->Primitives(vect);
    }
    if (uint32_t n = reader.getPrimitivearrays().size()) {
      std::vector<primitive_array*>* vect = serializer->primitive_arrayVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((primitive_array*)serializer->GetObject(reader.getPrimitivearrays()[i].getType(), reader.getPrimitivearrays()[i].getIndex() - 1));
      }
      obj->Primitive_arrays(vect);
    }
    if (uint32_t n = reader.getModpaths().size()) {
      std::vector<mod_path*>* vect = serializer->mod_pathVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->mod_pathMaker.objects_[reader.getModpaths()[i] - 1]);
      }
      obj->Mod_paths(vect);
    }
    if (uint32_t n = reader.getTchks().size()) {
      std::vector<tchk*>* vect = serializer->tchkVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->tchkMaker.objects_[reader.getTchks()[i] - 1]);
      }
      obj->Tchks(vect);
    }
    if (uint32_t n = reader.getDefparams().size()) {
      std::vector<def_param*>* vect = serializer->def_paramVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->def_paramMaker.objects_[reader.getDefparams()[i] - 1]);
      }
      obj->Def_params(vect);
    }
    if (uint32_t n = reader.getIodecls().size()) {
      std::vector<io_decl*>* vect = serializer->io_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->io_declMaker.objects_[reader.getIodecls()[i] - 1]);
      }
      obj->Io_decls(vect);
    }
    if (uint32_t n = reader.getAliasstmts().size()) {
      std::vector<alias_stmt*>* vect = serializer->alias_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->alias_stmtMaker.objects_[reader.getAliasstmts()[i] - 1]);
      }
      obj->Alias_stmts(vect);
    }
    if (uint32_t n = reader.getClockingblocks().size()) {
      std::vector<clocking_block*>* vect = serializer->clocking_blockVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->clocking_blockMaker.objects_[reader.getClockingblocks()[i] - 1]);
      }
      obj->Clocking_blocks(vect);
    }
    if (uint32_t n = reader.getElabtasks().size()) {
      std::vector<tf_call*>* vect = serializer->tf_callVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((tf_call*)serializer->GetObject(reader.getElabtasks()[i].getType(), reader.getElabtasks()[i].getIndex() - 1));
      }
      obj->Elab_tasks(vect);
    }
    if (uint32_t n = reader.getRefmodules().size()) {
      std::vector<ref_module*>* vect = serializer->ref_moduleVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->ref_moduleMaker.objects_[reader.getRefmodules()[i] - 1]);
      }
      obj->Ref_modules(vect);
    }
    if (uint32_t n = reader.getGenstmts().size()) {
      std::vector<gen_stmt*>* vect = serializer->gen_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((gen_stmt*)serializer->GetObject(reader.getGenstmts()[i].getType(), reader.getGenstmts()[i].getIndex() - 1));
      }
      obj->Gen_stmts(vect);
    }
    obj->VpiEndLabel(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiEndLabel(), kUnknownRawSymbol)));
  }

  void operator()(Checkerdecl::Reader reader, Serializer *const serializer, checker_decl *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance*>(obj));
    if (reader.getDefaultclocking()) {
      obj->Default_clocking(serializer->clocking_blockMaker.objects_[reader.getDefaultclocking() - 1]);
    }
    if (uint32_t n = reader.getProcess().size()) {
      std::vector<process_stmt*>* vect = serializer->process_stmtVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((process_stmt*)serializer->GetObject(reader.getProcess()[i].getType(), reader.getProcess()[i].getIndex() - 1));
      }
      obj->Process(vect);
    }
    if (uint32_t n = reader.getContassigns().size()) {
      std::vector<cont_assign*>* vect = serializer->cont_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->cont_assignMaker.objects_[reader.getContassigns()[i] - 1]);
      }
      obj->Cont_assigns(vect);
    }
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<checker_port*>* vect = serializer->checker_portVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->checker_portMaker.objects_[reader.getPorts()[i] - 1]);
      }
      obj->Ports(vect);
    }
  }

  void operator()(Checkerinst::Reader reader, Serializer *const serializer, checker_inst *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<instance*>(obj));
    if (uint32_t n = reader.getPorts().size()) {
      std::vector<checker_inst_port*>* vect = serializer->checker_inst_portVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->checker_inst_portMaker.objects_[reader.getPorts()[i] - 1]);
      }
      obj->Ports(vect);
    }
  }

  void operator()(Shortrealtypespec::Reader reader, Serializer *const serializer, short_real_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    if (reader.getResolutionfunc()) {
      obj->Resolution_func(serializer->functionMaker.objects_[reader.getResolutionfunc() - 1]);
    }
  }

  void operator()(Realtypespec::Reader reader, Serializer *const serializer, real_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    if (reader.getResolutionfunc()) {
      obj->Resolution_func(serializer->functionMaker.objects_[reader.getResolutionfunc() - 1]);
    }
  }

  void operator()(Bytetypespec::Reader reader, Serializer *const serializer, byte_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiSigned(reader.getVpiSigned());
  }

  void operator()(Shortinttypespec::Reader reader, Serializer *const serializer, short_int_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiSigned(reader.getVpiSigned());
  }

  void operator()(Inttypespec::Reader reader, Serializer *const serializer, int_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->Cast_to_expr((expr*)serializer->GetObject(reader.getCasttoexpr().getType(), reader.getCasttoexpr().getIndex() - 1));
    obj->VpiSigned(reader.getVpiSigned());
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
  }

  void operator()(Longinttypespec::Reader reader, Serializer *const serializer, long_int_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiSigned(reader.getVpiSigned());
  }

  void operator()(Integertypespec::Reader reader, Serializer *const serializer, integer_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    obj->VpiSigned(reader.getVpiSigned());
  }

  void operator()(Timetypespec::Reader reader, Serializer *const serializer, time_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiSigned(reader.getVpiSigned());
  }

  void operator()(Enumtypespec::Reader reader, Serializer *const serializer, enum_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->Base_typespec((ref_typespec*)serializer->GetObject(reader.getBasetypespec().getType(), reader.getBasetypespec().getIndex() - 1));
    if (uint32_t n = reader.getEnumconsts().size()) {
      std::vector<enum_const*>* vect = serializer->enum_constVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->enum_constMaker.objects_[reader.getEnumconsts()[i] - 1]);
      }
      obj->Enum_consts(vect);
    }
  }

  void operator()(Stringtypespec::Reader reader, Serializer *const serializer, string_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
  }

  void operator()(Chandletypespec::Reader reader, Serializer *const serializer, chandle_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
  }

  void operator()(Moduletypespec::Reader reader, Serializer *const serializer, module_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
  }

  void operator()(Structtypespec::Reader reader, Serializer *const serializer, struct_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiPacked(reader.getVpiPacked());
    if (uint32_t n = reader.getMembers().size()) {
      std::vector<typespec_member*>* vect = serializer->typespec_memberVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->typespec_memberMaker.objects_[reader.getMembers()[i] - 1]);
      }
      obj->Members(vect);
    }
    if (reader.getResolutionfunc()) {
      obj->Resolution_func(serializer->functionMaker.objects_[reader.getResolutionfunc() - 1]);
    }
  }

  void operator()(Uniontypespec::Reader reader, Serializer *const serializer, union_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiPacked(reader.getVpiPacked());
    obj->VpiTagged(reader.getVpiTagged());
    if (uint32_t n = reader.getMembers().size()) {
      std::vector<typespec_member*>* vect = serializer->typespec_memberVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->typespec_memberMaker.objects_[reader.getMembers()[i] - 1]);
      }
      obj->Members(vect);
    }
  }

  void operator()(Logictypespec::Reader reader, Serializer *const serializer, logic_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiVector(reader.getVpiVector());
    if (reader.getElemtypespec()) {
      obj->Elem_typespec(serializer->ref_typespecMaker.objects_[reader.getElemtypespec() - 1]);
    }
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    obj->Index_typespec((ref_typespec*)serializer->GetObject(reader.getIndextypespec().getType(), reader.getIndextypespec().getIndex() - 1));
    obj->VpiSigned(reader.getVpiSigned());
    if (reader.getResolutionfunc()) {
      obj->Resolution_func(serializer->functionMaker.objects_[reader.getResolutionfunc() - 1]);
    }
  }

  void operator()(Packedarraytypespec::Reader reader, Serializer *const serializer, packed_array_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiVector(reader.getVpiVector());
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    obj->Elem_typespec((ref_typespec*)serializer->GetObject(reader.getElemtypespec().getType(), reader.getElemtypespec().getIndex() - 1));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
    if (reader.getResolutionfunc()) {
      obj->Resolution_func(serializer->functionMaker.objects_[reader.getResolutionfunc() - 1]);
    }
  }

  void operator()(Arraytypespec::Reader reader, Serializer *const serializer, array_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiArrayType(reader.getVpiArrayType());
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    obj->Index_typespec((ref_typespec*)serializer->GetObject(reader.getIndextypespec().getType(), reader.getIndextypespec().getIndex() - 1));
    obj->Elem_typespec((ref_typespec*)serializer->GetObject(reader.getElemtypespec().getType(), reader.getElemtypespec().getIndex() - 1));
    if (reader.getResolutionfunc()) {
      obj->Resolution_func(serializer->functionMaker.objects_[reader.getResolutionfunc() - 1]);
    }
  }

  void operator()(Voidtypespec::Reader reader, Serializer *const serializer, void_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
  }

  void operator()(Unsupportedtypespec::Reader reader, Serializer *const serializer, unsupported_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiPacked(reader.getVpiPacked());
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
  }

  void operator()(Sequencetypespec::Reader reader, Serializer *const serializer, sequence_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
  }

  void operator()(Propertytypespec::Reader reader, Serializer *const serializer, property_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
  }

  void operator()(Interfacetypespec::Reader reader, Serializer *const serializer, interface_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiDefName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDefName(), kUnknownRawSymbol)));
    obj->VpiIsModPort(reader.getVpiIsModPort());
    if (uint32_t n = reader.getParamassigns().size()) {
      std::vector<param_assign*>* vect = serializer->param_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->param_assignMaker.objects_[reader.getParamassigns()[i] - 1]);
      }
      obj->Param_assigns(vect);
    }
  }

  void operator()(Typeparameter::Reader reader, Serializer *const serializer, type_parameter *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiLocalParam(reader.getVpiLocalParam());
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
    obj->Expr((ref_typespec*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
    obj->VpiImported(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiImported(), kUnknownRawSymbol)));
  }

  void operator()(Typespecmember::Reader reader, Serializer *const serializer, typespec_member *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiRandType(reader.getVpiRandType());
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
    obj->Default_value((expr*)serializer->GetObject(reader.getDefaultvalue().getType(), reader.getDefaultvalue().getIndex() - 1));
    obj->VpiRefFile(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiRefFile(), kUnknownRawSymbol)));
    obj->VpiRefLineNo(reader.getVpiRefLineNo());
    obj->VpiRefColumnNo(reader.getVpiRefColumnNo());
    obj->VpiRefEndLineNo(reader.getVpiRefEndLineNo());
    obj->VpiRefEndColumnNo(reader.getVpiRefEndColumnNo());
  }

  void operator()(Enumconst::Reader reader, Serializer *const serializer, enum_const *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiValue(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiValue(), kUnknownRawSymbol)));
    obj->VpiDecompile(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiDecompile(), kUnknownRawSymbol)));
    obj->VpiSize(reader.getVpiSize());
  }

  void operator()(Bittypespec::Reader reader, Serializer *const serializer, bit_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    obj->VpiVector(reader.getVpiVector());
    if (reader.getBittypespec()) {
      obj->Bit_typespec(serializer->ref_typespecMaker.objects_[reader.getBittypespec() - 1]);
    }
    if (uint32_t n = reader.getRanges().size()) {
      std::vector<range*>* vect = serializer->rangeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->rangeMaker.objects_[reader.getRanges()[i] - 1]);
      }
      obj->Ranges(vect);
    }
    obj->Left_expr((expr*)serializer->GetObject(reader.getLeftexpr().getType(), reader.getLeftexpr().getIndex() - 1));
    obj->Right_expr((expr*)serializer->GetObject(reader.getRightexpr().getType(), reader.getRightexpr().getIndex() - 1));
    obj->Typespec((ref_typespec*)serializer->GetObject(reader.getTypespec().getType(), reader.getTypespec().getIndex() - 1));
    obj->VpiSigned(reader.getVpiSigned());
    if (reader.getResolutionfunc()) {
      obj->Resolution_func(serializer->functionMaker.objects_[reader.getResolutionfunc() - 1]);
    }
  }

  void operator()(Tfcall::Reader reader, Serializer *const serializer, tf_call *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<expr*>(obj));
    obj->Scope((scope*)serializer->GetObject(reader.getScope().getType(), reader.getScope().getIndex() - 1));
    if (uint32_t n = reader.getTfcallargs().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getTfcallargs()[i].getType(), reader.getTfcallargs()[i].getIndex() - 1));
      }
      obj->Tf_call_args(vect);
    }
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
  }

  void operator()(Usersystf::Reader reader, Serializer *const serializer, user_systf *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Sysfunccall::Reader reader, Serializer *const serializer, sys_func_call *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<tf_call*>(obj));
    obj->VpiFuncType(reader.getVpiFuncType());
    obj->VpiUserDefn(reader.getVpiUserDefn());
    if (reader.getUsersystf()) {
      obj->User_systf(serializer->user_systfMaker.objects_[reader.getUsersystf() - 1]);
    }
  }

  void operator()(Systaskcall::Reader reader, Serializer *const serializer, sys_task_call *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<tf_call*>(obj));
    obj->VpiUserDefn(reader.getVpiUserDefn());
    if (reader.getUsersystf()) {
      obj->User_systf(serializer->user_systfMaker.objects_[reader.getUsersystf() - 1]);
    }
  }

  void operator()(Methodfunccall::Reader reader, Serializer *const serializer, method_func_call *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<tf_call*>(obj));
    obj->VpiUserDefn(reader.getVpiUserDefn());
    obj->Prefix((expr*)serializer->GetObject(reader.getPrefix().getType(), reader.getPrefix().getIndex() - 1));
    obj->With((any*)serializer->GetObject(reader.getWith().getType(), reader.getWith().getIndex() - 1));
    if (reader.getFunction()) {
      obj->Function(serializer->functionMaker.objects_[reader.getFunction() - 1]);
    }
  }

  void operator()(Methodtaskcall::Reader reader, Serializer *const serializer, method_task_call *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<tf_call*>(obj));
    obj->VpiUserDefn(reader.getVpiUserDefn());
    obj->Prefix((expr*)serializer->GetObject(reader.getPrefix().getType(), reader.getPrefix().getIndex() - 1));
    obj->With((any*)serializer->GetObject(reader.getWith().getType(), reader.getWith().getIndex() - 1));
    if (reader.getTask()) {
      obj->Task(serializer->taskMaker.objects_[reader.getTask() - 1]);
    }
  }

  void operator()(Funccall::Reader reader, Serializer *const serializer, func_call *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<tf_call*>(obj));
    obj->VpiFuncType(reader.getVpiFuncType());
    if (reader.getFunction()) {
      obj->Function(serializer->functionMaker.objects_[reader.getFunction() - 1]);
    }
  }

  void operator()(Taskcall::Reader reader, Serializer *const serializer, task_call *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<tf_call*>(obj));
    if (reader.getTask()) {
      obj->Task(serializer->taskMaker.objects_[reader.getTask() - 1]);
    }
  }

  void operator()(Constraintexpr::Reader reader, Serializer *const serializer, constraint_expr *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
  }

  void operator()(Constraintordering::Reader reader, Serializer *const serializer, constraint_ordering *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    if (uint32_t n = reader.getSolvebefores().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getSolvebefores()[i].getType(), reader.getSolvebefores()[i].getIndex() - 1));
      }
      obj->Solve_befores(vect);
    }
    if (uint32_t n = reader.getSolveafters().size()) {
      std::vector<expr*>* vect = serializer->exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((expr*)serializer->GetObject(reader.getSolveafters()[i].getType(), reader.getSolveafters()[i].getIndex() - 1));
      }
      obj->Solve_afters(vect);
    }
  }

  void operator()(Constraint::Reader reader, Serializer *const serializer, constraint *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    obj->VpiFullName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiFullName(), kUnknownRawSymbol)));
    obj->VpiVirtual(reader.getVpiVirtual());
    obj->VpiAutomatic(reader.getVpiAutomatic());
    obj->VpiAllocScheme(reader.getVpiAllocScheme());
    obj->VpiAccessType(reader.getVpiAccessType());
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
    obj->VpiIsConstraintEnabled(reader.getVpiIsConstraintEnabled());
    if (uint32_t n = reader.getConstraintitems().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getConstraintitems()[i].getType(), reader.getConstraintitems()[i].getIndex() - 1));
      }
      obj->Constraint_items(vect);
    }
  }

  void operator()(Importtypespec::Reader reader, Serializer *const serializer, import_typespec *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<typespec*>(obj));
    if (reader.getItem()) {
      obj->Item(serializer->constantMaker.objects_[reader.getItem() - 1]);
    }
  }

  void operator()(Distitem::Reader reader, Serializer *const serializer, dist_item *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiDistType(reader.getVpiDistType());
    obj->Value_range((any*)serializer->GetObject(reader.getValuerange().getType(), reader.getValuerange().getIndex() - 1));
    obj->Weight((expr*)serializer->GetObject(reader.getWeight().getType(), reader.getWeight().getIndex() - 1));
  }

  void operator()(Distribution::Reader reader, Serializer *const serializer, distribution *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<constraint_expr*>(obj));
    obj->VpiSoft(reader.getVpiSoft());
    if (uint32_t n = reader.getDistitems().size()) {
      std::vector<dist_item*>* vect = serializer->dist_itemVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->dist_itemMaker.objects_[reader.getDistitems()[i] - 1]);
      }
      obj->Dist_items(vect);
    }
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
  }

  void operator()(Implication::Reader reader, Serializer *const serializer, implication *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<constraint_expr*>(obj));
    obj->Condition((expr*)serializer->GetObject(reader.getCondition().getType(), reader.getCondition().getIndex() - 1));
    if (uint32_t n = reader.getConstraintexprs().size()) {
      std::vector<constraint_expr*>* vect = serializer->constraint_exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((constraint_expr*)serializer->GetObject(reader.getConstraintexprs()[i].getType(), reader.getConstraintexprs()[i].getIndex() - 1));
      }
      obj->Constraint_exprs(vect);
    }
  }

  void operator()(Constrif::Reader reader, Serializer *const serializer, constr_if *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<constraint_expr*>(obj));
    obj->Condition((expr*)serializer->GetObject(reader.getCondition().getType(), reader.getCondition().getIndex() - 1));
    if (uint32_t n = reader.getConstraintexprs().size()) {
      std::vector<constraint_expr*>* vect = serializer->constraint_exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((constraint_expr*)serializer->GetObject(reader.getConstraintexprs()[i].getType(), reader.getConstraintexprs()[i].getIndex() - 1));
      }
      obj->Constraint_exprs(vect);
    }
  }

  void operator()(Constrifelse::Reader reader, Serializer *const serializer, constr_if_else *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<constraint_expr*>(obj));
    obj->Condition((expr*)serializer->GetObject(reader.getCondition().getType(), reader.getCondition().getIndex() - 1));
    if (uint32_t n = reader.getConstraintexprs().size()) {
      std::vector<constraint_expr*>* vect = serializer->constraint_exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((constraint_expr*)serializer->GetObject(reader.getConstraintexprs()[i].getType(), reader.getConstraintexprs()[i].getIndex() - 1));
      }
      obj->Constraint_exprs(vect);
    }
    if (uint32_t n = reader.getElseconstraintexprs().size()) {
      std::vector<constraint_expr*>* vect = serializer->constraint_exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((constraint_expr*)serializer->GetObject(reader.getElseconstraintexprs()[i].getType(), reader.getElseconstraintexprs()[i].getIndex() - 1));
      }
      obj->Else_constraint_exprs(vect);
    }
  }

  void operator()(Constrforeach::Reader reader, Serializer *const serializer, constr_foreach *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<constraint_expr*>(obj));
    obj->Variable((variables*)serializer->GetObject(reader.getVariable().getType(), reader.getVariable().getIndex() - 1));
    if (uint32_t n = reader.getVpiLoopVars().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiLoopVars()[i].getType(), reader.getVpiLoopVars()[i].getIndex() - 1));
      }
      obj->VpiLoopVars(vect);
    }
    if (uint32_t n = reader.getConstraintexprs().size()) {
      std::vector<constraint_expr*>* vect = serializer->constraint_exprVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((constraint_expr*)serializer->GetObject(reader.getConstraintexprs()[i].getType(), reader.getConstraintexprs()[i].getIndex() - 1));
      }
      obj->Constraint_exprs(vect);
    }
  }

  void operator()(Softdisable::Reader reader, Serializer *const serializer, soft_disable *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<constraint_expr*>(obj));
    obj->Expr((expr*)serializer->GetObject(reader.getExpr().getType(), reader.getExpr().getIndex() - 1));
  }

  void operator()(Genstmt::Reader reader, Serializer *const serializer, gen_stmt *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getAttributes().size()) {
      std::vector<attribute*>* vect = serializer->attributeVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->attributeMaker.objects_[reader.getAttributes()[i] - 1]);
      }
      obj->Attributes(vect);
    }
  }

  void operator()(Genif::Reader reader, Serializer *const serializer, gen_if *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<gen_stmt*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Genifelse::Reader reader, Serializer *const serializer, gen_if_else *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<gen_stmt*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
    obj->VpiElseStmt((any*)serializer->GetObject(reader.getVpiElseStmt().getType(), reader.getVpiElseStmt().getIndex() - 1));
  }

  void operator()(Genfor::Reader reader, Serializer *const serializer, gen_for *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<gen_stmt*>(obj));
    obj->VpiLocalVarDecls(reader.getVpiLocalVarDecls());
    if (uint32_t n = reader.getVpiForInitStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiForInitStmts()[i].getType(), reader.getVpiForInitStmts()[i].getIndex() - 1));
      }
      obj->VpiForInitStmts(vect);
    }
    if (uint32_t n = reader.getVpiForIncStmts().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getVpiForIncStmts()[i].getType(), reader.getVpiForIncStmts()[i].getIndex() - 1));
      }
      obj->VpiForIncStmts(vect);
    }
    obj->VpiForInitStmt((any*)serializer->GetObject(reader.getVpiForInitStmt().getType(), reader.getVpiForInitStmt().getIndex() - 1));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    obj->VpiForIncStmt((any*)serializer->GetObject(reader.getVpiForIncStmt().getType(), reader.getVpiForIncStmt().getIndex() - 1));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Gencase::Reader reader, Serializer *const serializer, gen_case *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<gen_stmt*>(obj));
    obj->VpiCondition((expr*)serializer->GetObject(reader.getVpiCondition().getType(), reader.getVpiCondition().getIndex() - 1));
    if (uint32_t n = reader.getCaseitems().size()) {
      std::vector<case_item*>* vect = serializer->case_itemVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->case_itemMaker.objects_[reader.getCaseitems()[i] - 1]);
      }
      obj->Case_items(vect);
    }
  }

  void operator()(Genregion::Reader reader, Serializer *const serializer, gen_region *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<gen_stmt*>(obj));
    obj->VpiStmt((any*)serializer->GetObject(reader.getVpiStmt().getType(), reader.getVpiStmt().getIndex() - 1));
  }

  void operator()(Design::Reader reader, Serializer *const serializer, design *const obj) const {
    operator()(reader.getBase(), serializer, static_cast<BaseClass*>(obj));
    obj->VpiElaborated(reader.getVpiElaborated());
    obj->VpiName(serializer->symbolMaker.GetSymbol(SymbolId(reader.getVpiName(), kUnknownRawSymbol)));
    if (uint32_t n = reader.getIncludefileinfos().size()) {
      std::vector<include_file_info*>* vect = serializer->include_file_infoVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->include_file_infoMaker.objects_[reader.getIncludefileinfos()[i] - 1]);
      }
      obj->Include_file_infos(vect);
    }
    if (uint32_t n = reader.getAllPackages().size()) {
      std::vector<package*>* vect = serializer->packageVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->packageMaker.objects_[reader.getAllPackages()[i] - 1]);
      }
      obj->AllPackages(vect);
    }
    if (uint32_t n = reader.getTopPackages().size()) {
      std::vector<package*>* vect = serializer->packageVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->packageMaker.objects_[reader.getTopPackages()[i] - 1]);
      }
      obj->TopPackages(vect);
    }
    if (uint32_t n = reader.getAllClasses().size()) {
      std::vector<class_defn*>* vect = serializer->class_defnVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->class_defnMaker.objects_[reader.getAllClasses()[i] - 1]);
      }
      obj->AllClasses(vect);
    }
    if (uint32_t n = reader.getAllInterfaces().size()) {
      std::vector<interface_inst*>* vect = serializer->interface_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->interface_instMaker.objects_[reader.getAllInterfaces()[i] - 1]);
      }
      obj->AllInterfaces(vect);
    }
    if (uint32_t n = reader.getAllUdps().size()) {
      std::vector<udp_defn*>* vect = serializer->udp_defnVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->udp_defnMaker.objects_[reader.getAllUdps()[i] - 1]);
      }
      obj->AllUdps(vect);
    }
    if (uint32_t n = reader.getAllPrograms().size()) {
      std::vector<program*>* vect = serializer->programVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->programMaker.objects_[reader.getAllPrograms()[i] - 1]);
      }
      obj->AllPrograms(vect);
    }
    if (uint32_t n = reader.getAllModules().size()) {
      std::vector<module_inst*>* vect = serializer->module_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->module_instMaker.objects_[reader.getAllModules()[i] - 1]);
      }
      obj->AllModules(vect);
    }
    if (uint32_t n = reader.getTypespecs().size()) {
      std::vector<typespec*>* vect = serializer->typespecVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((typespec*)serializer->GetObject(reader.getTypespecs()[i].getType(), reader.getTypespecs()[i].getIndex() - 1));
      }
      obj->Typespecs(vect);
    }
    if (uint32_t n = reader.getLetdecls().size()) {
      std::vector<let_decl*>* vect = serializer->let_declVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->let_declMaker.objects_[reader.getLetdecls()[i] - 1]);
      }
      obj->Let_decls(vect);
    }
    if (uint32_t n = reader.getTaskfuncs().size()) {
      std::vector<task_func*>* vect = serializer->task_funcVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((task_func*)serializer->GetObject(reader.getTaskfuncs()[i].getType(), reader.getTaskfuncs()[i].getIndex() - 1));
      }
      obj->Task_funcs(vect);
    }
    if (uint32_t n = reader.getParameters().size()) {
      std::vector<any*>* vect = serializer->anyVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back((any*)serializer->GetObject(reader.getParameters()[i].getType(), reader.getParameters()[i].getIndex() - 1));
      }
      obj->Parameters(vect);
    }
    if (uint32_t n = reader.getParamassigns().size()) {
      std::vector<param_assign*>* vect = serializer->param_assignVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->param_assignMaker.objects_[reader.getParamassigns()[i] - 1]);
      }
      obj->Param_assigns(vect);
    }
    if (uint32_t n = reader.getTopModules().size()) {
      std::vector<module_inst*>* vect = serializer->module_instVectMaker.Make();
      vect->reserve(n);
      for (uint32_t i = 0; i < n; ++i) {
        vect->emplace_back(serializer->module_instMaker.objects_[reader.getTopModules()[i] - 1]);
      }
      obj->TopModules(vect);
    }
  }


  template<typename T, typename U, typename = typename std::enable_if<std::is_base_of<BaseClass, T>::value>::type>
  void operator()(typename ::capnp::List<U>::Reader reader, Serializer *serializer, typename FactoryT<T>::objects_t &objects) const {
    uint32_t index = 0;
    for (typename U::Reader obj : reader)
      operator()(obj, serializer, objects[index++]);
  }
};

const std::vector<vpiHandle> Serializer::Restore(const std::filesystem::path& filepath) {
    return Restore( filepath.string());
}
const std::vector<vpiHandle> Serializer::Restore(const std::string& filepath) {
  Purge();
  std::vector<vpiHandle> designs;
  const std::string file = filepath;
  int32_t fileid = open(file.c_str(), O_RDONLY | O_BINARY);
  ::capnp::ReaderOptions options;
  options.traversalLimitInWords = ULLONG_MAX;
  options.nestingLimit = 1024;
  ::capnp::PackedFdMessageReader message(fileid, options);
  UhdmRoot::Reader cap_root = message.getRoot<UhdmRoot>();
  m_version = cap_root.getVersion();
  if (m_version != kVersion) return designs;

  const ::capnp::List<::capnp::Text>::Reader& symbols = cap_root.getSymbols();
  for (const auto& symbol : symbols) {
    symbolMaker.Make(symbol.cStr());
  }

  Make(&alias_stmtMaker, cap_root.getFactoryAliasstmt().size());
  Make(&alwaysMaker, cap_root.getFactoryAlways().size());
  Make(&any_patternMaker, cap_root.getFactoryAnypattern().size());
  Make(&array_exprMaker, cap_root.getFactoryArrayexpr().size());
  Make(&array_netMaker, cap_root.getFactoryArraynet().size());
  Make(&array_typespecMaker, cap_root.getFactoryArraytypespec().size());
  Make(&array_varMaker, cap_root.getFactoryArrayvar().size());
  Make(&assert_stmtMaker, cap_root.getFactoryAssertstmt().size());
  Make(&assign_stmtMaker, cap_root.getFactoryAssignstmt().size());
  Make(&assignmentMaker, cap_root.getFactoryAssignment().size());
  Make(&assumeMaker, cap_root.getFactoryAssume().size());
  Make(&attributeMaker, cap_root.getFactoryAttribute().size());
  Make(&beginMaker, cap_root.getFactoryBegin().size());
  Make(&bit_selectMaker, cap_root.getFactoryBitselect().size());
  Make(&bit_typespecMaker, cap_root.getFactoryBittypespec().size());
  Make(&bit_varMaker, cap_root.getFactoryBitvar().size());
  Make(&break_stmtMaker, cap_root.getFactoryBreakstmt().size());
  Make(&byte_typespecMaker, cap_root.getFactoryBytetypespec().size());
  Make(&byte_varMaker, cap_root.getFactoryBytevar().size());
  Make(&case_itemMaker, cap_root.getFactoryCaseitem().size());
  Make(&case_propertyMaker, cap_root.getFactoryCaseproperty().size());
  Make(&case_property_itemMaker, cap_root.getFactoryCasepropertyitem().size());
  Make(&case_stmtMaker, cap_root.getFactoryCasestmt().size());
  Make(&chandle_typespecMaker, cap_root.getFactoryChandletypespec().size());
  Make(&chandle_varMaker, cap_root.getFactoryChandlevar().size());
  Make(&checker_declMaker, cap_root.getFactoryCheckerdecl().size());
  Make(&checker_instMaker, cap_root.getFactoryCheckerinst().size());
  Make(&checker_inst_portMaker, cap_root.getFactoryCheckerinstport().size());
  Make(&checker_portMaker, cap_root.getFactoryCheckerport().size());
  Make(&class_defnMaker, cap_root.getFactoryClassdefn().size());
  Make(&class_objMaker, cap_root.getFactoryClassobj().size());
  Make(&class_typespecMaker, cap_root.getFactoryClasstypespec().size());
  Make(&class_varMaker, cap_root.getFactoryClassvar().size());
  Make(&clocked_propertyMaker, cap_root.getFactoryClockedproperty().size());
  Make(&clocked_seqMaker, cap_root.getFactoryClockedseq().size());
  Make(&clocking_blockMaker, cap_root.getFactoryClockingblock().size());
  Make(&clocking_io_declMaker, cap_root.getFactoryClockingiodecl().size());
  Make(&constantMaker, cap_root.getFactoryConstant().size());
  Make(&constr_foreachMaker, cap_root.getFactoryConstrforeach().size());
  Make(&constr_ifMaker, cap_root.getFactoryConstrif().size());
  Make(&constr_if_elseMaker, cap_root.getFactoryConstrifelse().size());
  Make(&constraintMaker, cap_root.getFactoryConstraint().size());
  Make(&constraint_orderingMaker, cap_root.getFactoryConstraintordering().size());
  Make(&cont_assignMaker, cap_root.getFactoryContassign().size());
  Make(&cont_assign_bitMaker, cap_root.getFactoryContassignbit().size());
  Make(&continue_stmtMaker, cap_root.getFactoryContinuestmt().size());
  Make(&coverMaker, cap_root.getFactoryCover().size());
  Make(&deassignMaker, cap_root.getFactoryDeassign().size());
  Make(&def_paramMaker, cap_root.getFactoryDefparam().size());
  Make(&delay_controlMaker, cap_root.getFactoryDelaycontrol().size());
  Make(&delay_termMaker, cap_root.getFactoryDelayterm().size());
  Make(&designMaker, cap_root.getFactoryDesign().size());
  Make(&disableMaker, cap_root.getFactoryDisable().size());
  Make(&disable_forkMaker, cap_root.getFactoryDisablefork().size());
  Make(&dist_itemMaker, cap_root.getFactoryDistitem().size());
  Make(&distributionMaker, cap_root.getFactoryDistribution().size());
  Make(&do_whileMaker, cap_root.getFactoryDowhile().size());
  Make(&enum_constMaker, cap_root.getFactoryEnumconst().size());
  Make(&enum_netMaker, cap_root.getFactoryEnumnet().size());
  Make(&enum_typespecMaker, cap_root.getFactoryEnumtypespec().size());
  Make(&enum_varMaker, cap_root.getFactoryEnumvar().size());
  Make(&event_controlMaker, cap_root.getFactoryEventcontrol().size());
  Make(&event_stmtMaker, cap_root.getFactoryEventstmt().size());
  Make(&event_typespecMaker, cap_root.getFactoryEventtypespec().size());
  Make(&expect_stmtMaker, cap_root.getFactoryExpectstmt().size());
  Make(&extendsMaker, cap_root.getFactoryExtends().size());
  Make(&final_stmtMaker, cap_root.getFactoryFinalstmt().size());
  Make(&for_stmtMaker, cap_root.getFactoryForstmt().size());
  Make(&forceMaker, cap_root.getFactoryForce().size());
  Make(&foreach_stmtMaker, cap_root.getFactoryForeachstmt().size());
  Make(&forever_stmtMaker, cap_root.getFactoryForeverstmt().size());
  Make(&fork_stmtMaker, cap_root.getFactoryForkstmt().size());
  Make(&func_callMaker, cap_root.getFactoryFunccall().size());
  Make(&functionMaker, cap_root.getFactoryFunction().size());
  Make(&gateMaker, cap_root.getFactoryGate().size());
  Make(&gate_arrayMaker, cap_root.getFactoryGatearray().size());
  Make(&gen_caseMaker, cap_root.getFactoryGencase().size());
  Make(&gen_forMaker, cap_root.getFactoryGenfor().size());
  Make(&gen_ifMaker, cap_root.getFactoryGenif().size());
  Make(&gen_if_elseMaker, cap_root.getFactoryGenifelse().size());
  Make(&gen_regionMaker, cap_root.getFactoryGenregion().size());
  Make(&gen_scopeMaker, cap_root.getFactoryGenscope().size());
  Make(&gen_scope_arrayMaker, cap_root.getFactoryGenscopearray().size());
  Make(&gen_varMaker, cap_root.getFactoryGenvar().size());
  Make(&hier_pathMaker, cap_root.getFactoryHierpath().size());
  Make(&if_elseMaker, cap_root.getFactoryIfelse().size());
  Make(&if_stmtMaker, cap_root.getFactoryIfstmt().size());
  Make(&immediate_assertMaker, cap_root.getFactoryImmediateassert().size());
  Make(&immediate_assumeMaker, cap_root.getFactoryImmediateassume().size());
  Make(&immediate_coverMaker, cap_root.getFactoryImmediatecover().size());
  Make(&implicationMaker, cap_root.getFactoryImplication().size());
  Make(&import_typespecMaker, cap_root.getFactoryImporttypespec().size());
  Make(&include_file_infoMaker, cap_root.getFactoryIncludefileinfo().size());
  Make(&indexed_part_selectMaker, cap_root.getFactoryIndexedpartselect().size());
  Make(&initialMaker, cap_root.getFactoryInitial().size());
  Make(&int_typespecMaker, cap_root.getFactoryInttypespec().size());
  Make(&int_varMaker, cap_root.getFactoryIntvar().size());
  Make(&integer_netMaker, cap_root.getFactoryIntegernet().size());
  Make(&integer_typespecMaker, cap_root.getFactoryIntegertypespec().size());
  Make(&integer_varMaker, cap_root.getFactoryIntegervar().size());
  Make(&interface_arrayMaker, cap_root.getFactoryInterfacearray().size());
  Make(&interface_instMaker, cap_root.getFactoryInterfaceinst().size());
  Make(&interface_tf_declMaker, cap_root.getFactoryInterfacetfdecl().size());
  Make(&interface_typespecMaker, cap_root.getFactoryInterfacetypespec().size());
  Make(&io_declMaker, cap_root.getFactoryIodecl().size());
  Make(&let_declMaker, cap_root.getFactoryLetdecl().size());
  Make(&let_exprMaker, cap_root.getFactoryLetexpr().size());
  Make(&logic_netMaker, cap_root.getFactoryLogicnet().size());
  Make(&logic_typespecMaker, cap_root.getFactoryLogictypespec().size());
  Make(&logic_varMaker, cap_root.getFactoryLogicvar().size());
  Make(&long_int_typespecMaker, cap_root.getFactoryLonginttypespec().size());
  Make(&long_int_varMaker, cap_root.getFactoryLongintvar().size());
  Make(&method_func_callMaker, cap_root.getFactoryMethodfunccall().size());
  Make(&method_task_callMaker, cap_root.getFactoryMethodtaskcall().size());
  Make(&mod_pathMaker, cap_root.getFactoryModpath().size());
  Make(&modportMaker, cap_root.getFactoryModport().size());
  Make(&module_arrayMaker, cap_root.getFactoryModulearray().size());
  Make(&module_instMaker, cap_root.getFactoryModuleinst().size());
  Make(&module_typespecMaker, cap_root.getFactoryModuletypespec().size());
  Make(&multiclock_sequence_exprMaker, cap_root.getFactoryMulticlocksequenceexpr().size());
  Make(&named_beginMaker, cap_root.getFactoryNamedbegin().size());
  Make(&named_eventMaker, cap_root.getFactoryNamedevent().size());
  Make(&named_event_arrayMaker, cap_root.getFactoryNamedeventarray().size());
  Make(&named_forkMaker, cap_root.getFactoryNamedfork().size());
  Make(&net_bitMaker, cap_root.getFactoryNetbit().size());
  Make(&null_stmtMaker, cap_root.getFactoryNullstmt().size());
  Make(&operationMaker, cap_root.getFactoryOperation().size());
  Make(&ordered_waitMaker, cap_root.getFactoryOrderedwait().size());
  Make(&packageMaker, cap_root.getFactoryPackage().size());
  Make(&packed_array_netMaker, cap_root.getFactoryPackedarraynet().size());
  Make(&packed_array_typespecMaker, cap_root.getFactoryPackedarraytypespec().size());
  Make(&packed_array_varMaker, cap_root.getFactoryPackedarrayvar().size());
  Make(&param_assignMaker, cap_root.getFactoryParamassign().size());
  Make(&parameterMaker, cap_root.getFactoryParameter().size());
  Make(&part_selectMaker, cap_root.getFactoryPartselect().size());
  Make(&path_termMaker, cap_root.getFactoryPathterm().size());
  Make(&portMaker, cap_root.getFactoryPort().size());
  Make(&port_bitMaker, cap_root.getFactoryPortbit().size());
  Make(&prim_termMaker, cap_root.getFactoryPrimterm().size());
  Make(&programMaker, cap_root.getFactoryProgram().size());
  Make(&program_arrayMaker, cap_root.getFactoryProgramarray().size());
  Make(&prop_formal_declMaker, cap_root.getFactoryPropformaldecl().size());
  Make(&property_declMaker, cap_root.getFactoryPropertydecl().size());
  Make(&property_instMaker, cap_root.getFactoryPropertyinst().size());
  Make(&property_specMaker, cap_root.getFactoryPropertyspec().size());
  Make(&property_typespecMaker, cap_root.getFactoryPropertytypespec().size());
  Make(&rangeMaker, cap_root.getFactoryRange().size());
  Make(&real_typespecMaker, cap_root.getFactoryRealtypespec().size());
  Make(&real_varMaker, cap_root.getFactoryRealvar().size());
  Make(&ref_moduleMaker, cap_root.getFactoryRefmodule().size());
  Make(&ref_objMaker, cap_root.getFactoryRefobj().size());
  Make(&ref_typespecMaker, cap_root.getFactoryReftypespec().size());
  Make(&ref_varMaker, cap_root.getFactoryRefvar().size());
  Make(&regMaker, cap_root.getFactoryReg().size());
  Make(&reg_arrayMaker, cap_root.getFactoryRegarray().size());
  Make(&releaseMaker, cap_root.getFactoryRelease().size());
  Make(&repeatMaker, cap_root.getFactoryRepeat().size());
  Make(&repeat_controlMaker, cap_root.getFactoryRepeatcontrol().size());
  Make(&restrictMaker, cap_root.getFactoryRestrict().size());
  Make(&return_stmtMaker, cap_root.getFactoryReturnstmt().size());
  Make(&seq_formal_declMaker, cap_root.getFactorySeqformaldecl().size());
  Make(&sequence_declMaker, cap_root.getFactorySequencedecl().size());
  Make(&sequence_instMaker, cap_root.getFactorySequenceinst().size());
  Make(&sequence_typespecMaker, cap_root.getFactorySequencetypespec().size());
  Make(&short_int_typespecMaker, cap_root.getFactoryShortinttypespec().size());
  Make(&short_int_varMaker, cap_root.getFactoryShortintvar().size());
  Make(&short_real_typespecMaker, cap_root.getFactoryShortrealtypespec().size());
  Make(&short_real_varMaker, cap_root.getFactoryShortrealvar().size());
  Make(&soft_disableMaker, cap_root.getFactorySoftdisable().size());
  Make(&spec_paramMaker, cap_root.getFactorySpecparam().size());
  Make(&string_typespecMaker, cap_root.getFactoryStringtypespec().size());
  Make(&string_varMaker, cap_root.getFactoryStringvar().size());
  Make(&struct_netMaker, cap_root.getFactoryStructnet().size());
  Make(&struct_patternMaker, cap_root.getFactoryStructpattern().size());
  Make(&struct_typespecMaker, cap_root.getFactoryStructtypespec().size());
  Make(&struct_varMaker, cap_root.getFactoryStructvar().size());
  Make(&switch_arrayMaker, cap_root.getFactorySwitcharray().size());
  Make(&switch_tranMaker, cap_root.getFactorySwitchtran().size());
  Make(&sys_func_callMaker, cap_root.getFactorySysfunccall().size());
  Make(&sys_task_callMaker, cap_root.getFactorySystaskcall().size());
  Make(&table_entryMaker, cap_root.getFactoryTableentry().size());
  Make(&tagged_patternMaker, cap_root.getFactoryTaggedpattern().size());
  Make(&taskMaker, cap_root.getFactoryTask().size());
  Make(&task_callMaker, cap_root.getFactoryTaskcall().size());
  Make(&tchkMaker, cap_root.getFactoryTchk().size());
  Make(&tchk_termMaker, cap_root.getFactoryTchkterm().size());
  Make(&thread_objMaker, cap_root.getFactoryThreadobj().size());
  Make(&time_netMaker, cap_root.getFactoryTimenet().size());
  Make(&time_typespecMaker, cap_root.getFactoryTimetypespec().size());
  Make(&time_varMaker, cap_root.getFactoryTimevar().size());
  Make(&type_parameterMaker, cap_root.getFactoryTypeparameter().size());
  Make(&typespec_memberMaker, cap_root.getFactoryTypespecmember().size());
  Make(&udpMaker, cap_root.getFactoryUdp().size());
  Make(&udp_arrayMaker, cap_root.getFactoryUdparray().size());
  Make(&udp_defnMaker, cap_root.getFactoryUdpdefn().size());
  Make(&union_typespecMaker, cap_root.getFactoryUniontypespec().size());
  Make(&union_varMaker, cap_root.getFactoryUnionvar().size());
  Make(&unsupported_exprMaker, cap_root.getFactoryUnsupportedexpr().size());
  Make(&unsupported_stmtMaker, cap_root.getFactoryUnsupportedstmt().size());
  Make(&unsupported_typespecMaker, cap_root.getFactoryUnsupportedtypespec().size());
  Make(&user_systfMaker, cap_root.getFactoryUsersystf().size());
  Make(&var_bitMaker, cap_root.getFactoryVarbit().size());
  Make(&var_selectMaker, cap_root.getFactoryVarselect().size());
  Make(&virtual_interface_varMaker, cap_root.getFactoryVirtualinterfacevar().size());
  Make(&void_typespecMaker, cap_root.getFactoryVoidtypespec().size());
  Make(&wait_forkMaker, cap_root.getFactoryWaitfork().size());
  Make(&wait_stmtMaker, cap_root.getFactoryWaitstmt().size());
  Make(&while_stmtMaker, cap_root.getFactoryWhilestmt().size());
  // This assignment should happen only after the necessary objects are created.
  m_objId = cap_root.getObjectId();

  RestoreAdapter adapter;
  adapter.template operator()<alias_stmt, Aliasstmt>(cap_root.getFactoryAliasstmt(), this, alias_stmtMaker.objects_);
  adapter.template operator()<always, Always>(cap_root.getFactoryAlways(), this, alwaysMaker.objects_);
  adapter.template operator()<any_pattern, Anypattern>(cap_root.getFactoryAnypattern(), this, any_patternMaker.objects_);
  adapter.template operator()<array_expr, Arrayexpr>(cap_root.getFactoryArrayexpr(), this, array_exprMaker.objects_);
  adapter.template operator()<array_net, Arraynet>(cap_root.getFactoryArraynet(), this, array_netMaker.objects_);
  adapter.template operator()<array_typespec, Arraytypespec>(cap_root.getFactoryArraytypespec(), this, array_typespecMaker.objects_);
  adapter.template operator()<array_var, Arrayvar>(cap_root.getFactoryArrayvar(), this, array_varMaker.objects_);
  adapter.template operator()<assert_stmt, Assertstmt>(cap_root.getFactoryAssertstmt(), this, assert_stmtMaker.objects_);
  adapter.template operator()<assign_stmt, Assignstmt>(cap_root.getFactoryAssignstmt(), this, assign_stmtMaker.objects_);
  adapter.template operator()<assignment, Assignment>(cap_root.getFactoryAssignment(), this, assignmentMaker.objects_);
  adapter.template operator()<assume, Assume>(cap_root.getFactoryAssume(), this, assumeMaker.objects_);
  adapter.template operator()<attribute, Attribute>(cap_root.getFactoryAttribute(), this, attributeMaker.objects_);
  adapter.template operator()<begin, Begin>(cap_root.getFactoryBegin(), this, beginMaker.objects_);
  adapter.template operator()<bit_select, Bitselect>(cap_root.getFactoryBitselect(), this, bit_selectMaker.objects_);
  adapter.template operator()<bit_typespec, Bittypespec>(cap_root.getFactoryBittypespec(), this, bit_typespecMaker.objects_);
  adapter.template operator()<bit_var, Bitvar>(cap_root.getFactoryBitvar(), this, bit_varMaker.objects_);
  adapter.template operator()<break_stmt, Breakstmt>(cap_root.getFactoryBreakstmt(), this, break_stmtMaker.objects_);
  adapter.template operator()<byte_typespec, Bytetypespec>(cap_root.getFactoryBytetypespec(), this, byte_typespecMaker.objects_);
  adapter.template operator()<byte_var, Bytevar>(cap_root.getFactoryBytevar(), this, byte_varMaker.objects_);
  adapter.template operator()<case_item, Caseitem>(cap_root.getFactoryCaseitem(), this, case_itemMaker.objects_);
  adapter.template operator()<case_property, Caseproperty>(cap_root.getFactoryCaseproperty(), this, case_propertyMaker.objects_);
  adapter.template operator()<case_property_item, Casepropertyitem>(cap_root.getFactoryCasepropertyitem(), this, case_property_itemMaker.objects_);
  adapter.template operator()<case_stmt, Casestmt>(cap_root.getFactoryCasestmt(), this, case_stmtMaker.objects_);
  adapter.template operator()<chandle_typespec, Chandletypespec>(cap_root.getFactoryChandletypespec(), this, chandle_typespecMaker.objects_);
  adapter.template operator()<chandle_var, Chandlevar>(cap_root.getFactoryChandlevar(), this, chandle_varMaker.objects_);
  adapter.template operator()<checker_decl, Checkerdecl>(cap_root.getFactoryCheckerdecl(), this, checker_declMaker.objects_);
  adapter.template operator()<checker_inst, Checkerinst>(cap_root.getFactoryCheckerinst(), this, checker_instMaker.objects_);
  adapter.template operator()<checker_inst_port, Checkerinstport>(cap_root.getFactoryCheckerinstport(), this, checker_inst_portMaker.objects_);
  adapter.template operator()<checker_port, Checkerport>(cap_root.getFactoryCheckerport(), this, checker_portMaker.objects_);
  adapter.template operator()<class_defn, Classdefn>(cap_root.getFactoryClassdefn(), this, class_defnMaker.objects_);
  adapter.template operator()<class_obj, Classobj>(cap_root.getFactoryClassobj(), this, class_objMaker.objects_);
  adapter.template operator()<class_typespec, Classtypespec>(cap_root.getFactoryClasstypespec(), this, class_typespecMaker.objects_);
  adapter.template operator()<class_var, Classvar>(cap_root.getFactoryClassvar(), this, class_varMaker.objects_);
  adapter.template operator()<clocked_property, Clockedproperty>(cap_root.getFactoryClockedproperty(), this, clocked_propertyMaker.objects_);
  adapter.template operator()<clocked_seq, Clockedseq>(cap_root.getFactoryClockedseq(), this, clocked_seqMaker.objects_);
  adapter.template operator()<clocking_block, Clockingblock>(cap_root.getFactoryClockingblock(), this, clocking_blockMaker.objects_);
  adapter.template operator()<clocking_io_decl, Clockingiodecl>(cap_root.getFactoryClockingiodecl(), this, clocking_io_declMaker.objects_);
  adapter.template operator()<constant, Constant>(cap_root.getFactoryConstant(), this, constantMaker.objects_);
  adapter.template operator()<constr_foreach, Constrforeach>(cap_root.getFactoryConstrforeach(), this, constr_foreachMaker.objects_);
  adapter.template operator()<constr_if, Constrif>(cap_root.getFactoryConstrif(), this, constr_ifMaker.objects_);
  adapter.template operator()<constr_if_else, Constrifelse>(cap_root.getFactoryConstrifelse(), this, constr_if_elseMaker.objects_);
  adapter.template operator()<constraint, Constraint>(cap_root.getFactoryConstraint(), this, constraintMaker.objects_);
  adapter.template operator()<constraint_ordering, Constraintordering>(cap_root.getFactoryConstraintordering(), this, constraint_orderingMaker.objects_);
  adapter.template operator()<cont_assign, Contassign>(cap_root.getFactoryContassign(), this, cont_assignMaker.objects_);
  adapter.template operator()<cont_assign_bit, Contassignbit>(cap_root.getFactoryContassignbit(), this, cont_assign_bitMaker.objects_);
  adapter.template operator()<continue_stmt, Continuestmt>(cap_root.getFactoryContinuestmt(), this, continue_stmtMaker.objects_);
  adapter.template operator()<cover, Cover>(cap_root.getFactoryCover(), this, coverMaker.objects_);
  adapter.template operator()<deassign, Deassign>(cap_root.getFactoryDeassign(), this, deassignMaker.objects_);
  adapter.template operator()<def_param, Defparam>(cap_root.getFactoryDefparam(), this, def_paramMaker.objects_);
  adapter.template operator()<delay_control, Delaycontrol>(cap_root.getFactoryDelaycontrol(), this, delay_controlMaker.objects_);
  adapter.template operator()<delay_term, Delayterm>(cap_root.getFactoryDelayterm(), this, delay_termMaker.objects_);
  adapter.template operator()<design, Design>(cap_root.getFactoryDesign(), this, designMaker.objects_);
  adapter.template operator()<disable, Disable>(cap_root.getFactoryDisable(), this, disableMaker.objects_);
  adapter.template operator()<disable_fork, Disablefork>(cap_root.getFactoryDisablefork(), this, disable_forkMaker.objects_);
  adapter.template operator()<dist_item, Distitem>(cap_root.getFactoryDistitem(), this, dist_itemMaker.objects_);
  adapter.template operator()<distribution, Distribution>(cap_root.getFactoryDistribution(), this, distributionMaker.objects_);
  adapter.template operator()<do_while, Dowhile>(cap_root.getFactoryDowhile(), this, do_whileMaker.objects_);
  adapter.template operator()<enum_const, Enumconst>(cap_root.getFactoryEnumconst(), this, enum_constMaker.objects_);
  adapter.template operator()<enum_net, Enumnet>(cap_root.getFactoryEnumnet(), this, enum_netMaker.objects_);
  adapter.template operator()<enum_typespec, Enumtypespec>(cap_root.getFactoryEnumtypespec(), this, enum_typespecMaker.objects_);
  adapter.template operator()<enum_var, Enumvar>(cap_root.getFactoryEnumvar(), this, enum_varMaker.objects_);
  adapter.template operator()<event_control, Eventcontrol>(cap_root.getFactoryEventcontrol(), this, event_controlMaker.objects_);
  adapter.template operator()<event_stmt, Eventstmt>(cap_root.getFactoryEventstmt(), this, event_stmtMaker.objects_);
  adapter.template operator()<event_typespec, Eventtypespec>(cap_root.getFactoryEventtypespec(), this, event_typespecMaker.objects_);
  adapter.template operator()<expect_stmt, Expectstmt>(cap_root.getFactoryExpectstmt(), this, expect_stmtMaker.objects_);
  adapter.template operator()<extends, Extends>(cap_root.getFactoryExtends(), this, extendsMaker.objects_);
  adapter.template operator()<final_stmt, Finalstmt>(cap_root.getFactoryFinalstmt(), this, final_stmtMaker.objects_);
  adapter.template operator()<for_stmt, Forstmt>(cap_root.getFactoryForstmt(), this, for_stmtMaker.objects_);
  adapter.template operator()<force, Force>(cap_root.getFactoryForce(), this, forceMaker.objects_);
  adapter.template operator()<foreach_stmt, Foreachstmt>(cap_root.getFactoryForeachstmt(), this, foreach_stmtMaker.objects_);
  adapter.template operator()<forever_stmt, Foreverstmt>(cap_root.getFactoryForeverstmt(), this, forever_stmtMaker.objects_);
  adapter.template operator()<fork_stmt, Forkstmt>(cap_root.getFactoryForkstmt(), this, fork_stmtMaker.objects_);
  adapter.template operator()<func_call, Funccall>(cap_root.getFactoryFunccall(), this, func_callMaker.objects_);
  adapter.template operator()<function, Function>(cap_root.getFactoryFunction(), this, functionMaker.objects_);
  adapter.template operator()<gate, Gate>(cap_root.getFactoryGate(), this, gateMaker.objects_);
  adapter.template operator()<gate_array, Gatearray>(cap_root.getFactoryGatearray(), this, gate_arrayMaker.objects_);
  adapter.template operator()<gen_case, Gencase>(cap_root.getFactoryGencase(), this, gen_caseMaker.objects_);
  adapter.template operator()<gen_for, Genfor>(cap_root.getFactoryGenfor(), this, gen_forMaker.objects_);
  adapter.template operator()<gen_if, Genif>(cap_root.getFactoryGenif(), this, gen_ifMaker.objects_);
  adapter.template operator()<gen_if_else, Genifelse>(cap_root.getFactoryGenifelse(), this, gen_if_elseMaker.objects_);
  adapter.template operator()<gen_region, Genregion>(cap_root.getFactoryGenregion(), this, gen_regionMaker.objects_);
  adapter.template operator()<gen_scope, Genscope>(cap_root.getFactoryGenscope(), this, gen_scopeMaker.objects_);
  adapter.template operator()<gen_scope_array, Genscopearray>(cap_root.getFactoryGenscopearray(), this, gen_scope_arrayMaker.objects_);
  adapter.template operator()<gen_var, Genvar>(cap_root.getFactoryGenvar(), this, gen_varMaker.objects_);
  adapter.template operator()<hier_path, Hierpath>(cap_root.getFactoryHierpath(), this, hier_pathMaker.objects_);
  adapter.template operator()<if_else, Ifelse>(cap_root.getFactoryIfelse(), this, if_elseMaker.objects_);
  adapter.template operator()<if_stmt, Ifstmt>(cap_root.getFactoryIfstmt(), this, if_stmtMaker.objects_);
  adapter.template operator()<immediate_assert, Immediateassert>(cap_root.getFactoryImmediateassert(), this, immediate_assertMaker.objects_);
  adapter.template operator()<immediate_assume, Immediateassume>(cap_root.getFactoryImmediateassume(), this, immediate_assumeMaker.objects_);
  adapter.template operator()<immediate_cover, Immediatecover>(cap_root.getFactoryImmediatecover(), this, immediate_coverMaker.objects_);
  adapter.template operator()<implication, Implication>(cap_root.getFactoryImplication(), this, implicationMaker.objects_);
  adapter.template operator()<import_typespec, Importtypespec>(cap_root.getFactoryImporttypespec(), this, import_typespecMaker.objects_);
  adapter.template operator()<include_file_info, Includefileinfo>(cap_root.getFactoryIncludefileinfo(), this, include_file_infoMaker.objects_);
  adapter.template operator()<indexed_part_select, Indexedpartselect>(cap_root.getFactoryIndexedpartselect(), this, indexed_part_selectMaker.objects_);
  adapter.template operator()<initial, Initial>(cap_root.getFactoryInitial(), this, initialMaker.objects_);
  adapter.template operator()<int_typespec, Inttypespec>(cap_root.getFactoryInttypespec(), this, int_typespecMaker.objects_);
  adapter.template operator()<int_var, Intvar>(cap_root.getFactoryIntvar(), this, int_varMaker.objects_);
  adapter.template operator()<integer_net, Integernet>(cap_root.getFactoryIntegernet(), this, integer_netMaker.objects_);
  adapter.template operator()<integer_typespec, Integertypespec>(cap_root.getFactoryIntegertypespec(), this, integer_typespecMaker.objects_);
  adapter.template operator()<integer_var, Integervar>(cap_root.getFactoryIntegervar(), this, integer_varMaker.objects_);
  adapter.template operator()<interface_array, Interfacearray>(cap_root.getFactoryInterfacearray(), this, interface_arrayMaker.objects_);
  adapter.template operator()<interface_inst, Interfaceinst>(cap_root.getFactoryInterfaceinst(), this, interface_instMaker.objects_);
  adapter.template operator()<interface_tf_decl, Interfacetfdecl>(cap_root.getFactoryInterfacetfdecl(), this, interface_tf_declMaker.objects_);
  adapter.template operator()<interface_typespec, Interfacetypespec>(cap_root.getFactoryInterfacetypespec(), this, interface_typespecMaker.objects_);
  adapter.template operator()<io_decl, Iodecl>(cap_root.getFactoryIodecl(), this, io_declMaker.objects_);
  adapter.template operator()<let_decl, Letdecl>(cap_root.getFactoryLetdecl(), this, let_declMaker.objects_);
  adapter.template operator()<let_expr, Letexpr>(cap_root.getFactoryLetexpr(), this, let_exprMaker.objects_);
  adapter.template operator()<logic_net, Logicnet>(cap_root.getFactoryLogicnet(), this, logic_netMaker.objects_);
  adapter.template operator()<logic_typespec, Logictypespec>(cap_root.getFactoryLogictypespec(), this, logic_typespecMaker.objects_);
  adapter.template operator()<logic_var, Logicvar>(cap_root.getFactoryLogicvar(), this, logic_varMaker.objects_);
  adapter.template operator()<long_int_typespec, Longinttypespec>(cap_root.getFactoryLonginttypespec(), this, long_int_typespecMaker.objects_);
  adapter.template operator()<long_int_var, Longintvar>(cap_root.getFactoryLongintvar(), this, long_int_varMaker.objects_);
  adapter.template operator()<method_func_call, Methodfunccall>(cap_root.getFactoryMethodfunccall(), this, method_func_callMaker.objects_);
  adapter.template operator()<method_task_call, Methodtaskcall>(cap_root.getFactoryMethodtaskcall(), this, method_task_callMaker.objects_);
  adapter.template operator()<mod_path, Modpath>(cap_root.getFactoryModpath(), this, mod_pathMaker.objects_);
  adapter.template operator()<modport, Modport>(cap_root.getFactoryModport(), this, modportMaker.objects_);
  adapter.template operator()<module_array, Modulearray>(cap_root.getFactoryModulearray(), this, module_arrayMaker.objects_);
  adapter.template operator()<module_inst, Moduleinst>(cap_root.getFactoryModuleinst(), this, module_instMaker.objects_);
  adapter.template operator()<module_typespec, Moduletypespec>(cap_root.getFactoryModuletypespec(), this, module_typespecMaker.objects_);
  adapter.template operator()<multiclock_sequence_expr, Multiclocksequenceexpr>(cap_root.getFactoryMulticlocksequenceexpr(), this, multiclock_sequence_exprMaker.objects_);
  adapter.template operator()<named_begin, Namedbegin>(cap_root.getFactoryNamedbegin(), this, named_beginMaker.objects_);
  adapter.template operator()<named_event, Namedevent>(cap_root.getFactoryNamedevent(), this, named_eventMaker.objects_);
  adapter.template operator()<named_event_array, Namedeventarray>(cap_root.getFactoryNamedeventarray(), this, named_event_arrayMaker.objects_);
  adapter.template operator()<named_fork, Namedfork>(cap_root.getFactoryNamedfork(), this, named_forkMaker.objects_);
  adapter.template operator()<net_bit, Netbit>(cap_root.getFactoryNetbit(), this, net_bitMaker.objects_);
  adapter.template operator()<null_stmt, Nullstmt>(cap_root.getFactoryNullstmt(), this, null_stmtMaker.objects_);
  adapter.template operator()<operation, Operation>(cap_root.getFactoryOperation(), this, operationMaker.objects_);
  adapter.template operator()<ordered_wait, Orderedwait>(cap_root.getFactoryOrderedwait(), this, ordered_waitMaker.objects_);
  adapter.template operator()<package, Package>(cap_root.getFactoryPackage(), this, packageMaker.objects_);
  adapter.template operator()<packed_array_net, Packedarraynet>(cap_root.getFactoryPackedarraynet(), this, packed_array_netMaker.objects_);
  adapter.template operator()<packed_array_typespec, Packedarraytypespec>(cap_root.getFactoryPackedarraytypespec(), this, packed_array_typespecMaker.objects_);
  adapter.template operator()<packed_array_var, Packedarrayvar>(cap_root.getFactoryPackedarrayvar(), this, packed_array_varMaker.objects_);
  adapter.template operator()<param_assign, Paramassign>(cap_root.getFactoryParamassign(), this, param_assignMaker.objects_);
  adapter.template operator()<parameter, Parameter>(cap_root.getFactoryParameter(), this, parameterMaker.objects_);
  adapter.template operator()<part_select, Partselect>(cap_root.getFactoryPartselect(), this, part_selectMaker.objects_);
  adapter.template operator()<path_term, Pathterm>(cap_root.getFactoryPathterm(), this, path_termMaker.objects_);
  adapter.template operator()<port, Port>(cap_root.getFactoryPort(), this, portMaker.objects_);
  adapter.template operator()<port_bit, Portbit>(cap_root.getFactoryPortbit(), this, port_bitMaker.objects_);
  adapter.template operator()<prim_term, Primterm>(cap_root.getFactoryPrimterm(), this, prim_termMaker.objects_);
  adapter.template operator()<program, Program>(cap_root.getFactoryProgram(), this, programMaker.objects_);
  adapter.template operator()<program_array, Programarray>(cap_root.getFactoryProgramarray(), this, program_arrayMaker.objects_);
  adapter.template operator()<prop_formal_decl, Propformaldecl>(cap_root.getFactoryPropformaldecl(), this, prop_formal_declMaker.objects_);
  adapter.template operator()<property_decl, Propertydecl>(cap_root.getFactoryPropertydecl(), this, property_declMaker.objects_);
  adapter.template operator()<property_inst, Propertyinst>(cap_root.getFactoryPropertyinst(), this, property_instMaker.objects_);
  adapter.template operator()<property_spec, Propertyspec>(cap_root.getFactoryPropertyspec(), this, property_specMaker.objects_);
  adapter.template operator()<property_typespec, Propertytypespec>(cap_root.getFactoryPropertytypespec(), this, property_typespecMaker.objects_);
  adapter.template operator()<range, Range>(cap_root.getFactoryRange(), this, rangeMaker.objects_);
  adapter.template operator()<real_typespec, Realtypespec>(cap_root.getFactoryRealtypespec(), this, real_typespecMaker.objects_);
  adapter.template operator()<real_var, Realvar>(cap_root.getFactoryRealvar(), this, real_varMaker.objects_);
  adapter.template operator()<ref_module, Refmodule>(cap_root.getFactoryRefmodule(), this, ref_moduleMaker.objects_);
  adapter.template operator()<ref_obj, Refobj>(cap_root.getFactoryRefobj(), this, ref_objMaker.objects_);
  adapter.template operator()<ref_typespec, Reftypespec>(cap_root.getFactoryReftypespec(), this, ref_typespecMaker.objects_);
  adapter.template operator()<ref_var, Refvar>(cap_root.getFactoryRefvar(), this, ref_varMaker.objects_);
  adapter.template operator()<reg, Reg>(cap_root.getFactoryReg(), this, regMaker.objects_);
  adapter.template operator()<reg_array, Regarray>(cap_root.getFactoryRegarray(), this, reg_arrayMaker.objects_);
  adapter.template operator()<release, Release>(cap_root.getFactoryRelease(), this, releaseMaker.objects_);
  adapter.template operator()<repeat, Repeat>(cap_root.getFactoryRepeat(), this, repeatMaker.objects_);
  adapter.template operator()<repeat_control, Repeatcontrol>(cap_root.getFactoryRepeatcontrol(), this, repeat_controlMaker.objects_);
  adapter.template operator()<restrict, Restrict>(cap_root.getFactoryRestrict(), this, restrictMaker.objects_);
  adapter.template operator()<return_stmt, Returnstmt>(cap_root.getFactoryReturnstmt(), this, return_stmtMaker.objects_);
  adapter.template operator()<seq_formal_decl, Seqformaldecl>(cap_root.getFactorySeqformaldecl(), this, seq_formal_declMaker.objects_);
  adapter.template operator()<sequence_decl, Sequencedecl>(cap_root.getFactorySequencedecl(), this, sequence_declMaker.objects_);
  adapter.template operator()<sequence_inst, Sequenceinst>(cap_root.getFactorySequenceinst(), this, sequence_instMaker.objects_);
  adapter.template operator()<sequence_typespec, Sequencetypespec>(cap_root.getFactorySequencetypespec(), this, sequence_typespecMaker.objects_);
  adapter.template operator()<short_int_typespec, Shortinttypespec>(cap_root.getFactoryShortinttypespec(), this, short_int_typespecMaker.objects_);
  adapter.template operator()<short_int_var, Shortintvar>(cap_root.getFactoryShortintvar(), this, short_int_varMaker.objects_);
  adapter.template operator()<short_real_typespec, Shortrealtypespec>(cap_root.getFactoryShortrealtypespec(), this, short_real_typespecMaker.objects_);
  adapter.template operator()<short_real_var, Shortrealvar>(cap_root.getFactoryShortrealvar(), this, short_real_varMaker.objects_);
  adapter.template operator()<soft_disable, Softdisable>(cap_root.getFactorySoftdisable(), this, soft_disableMaker.objects_);
  adapter.template operator()<spec_param, Specparam>(cap_root.getFactorySpecparam(), this, spec_paramMaker.objects_);
  adapter.template operator()<string_typespec, Stringtypespec>(cap_root.getFactoryStringtypespec(), this, string_typespecMaker.objects_);
  adapter.template operator()<string_var, Stringvar>(cap_root.getFactoryStringvar(), this, string_varMaker.objects_);
  adapter.template operator()<struct_net, Structnet>(cap_root.getFactoryStructnet(), this, struct_netMaker.objects_);
  adapter.template operator()<struct_pattern, Structpattern>(cap_root.getFactoryStructpattern(), this, struct_patternMaker.objects_);
  adapter.template operator()<struct_typespec, Structtypespec>(cap_root.getFactoryStructtypespec(), this, struct_typespecMaker.objects_);
  adapter.template operator()<struct_var, Structvar>(cap_root.getFactoryStructvar(), this, struct_varMaker.objects_);
  adapter.template operator()<switch_array, Switcharray>(cap_root.getFactorySwitcharray(), this, switch_arrayMaker.objects_);
  adapter.template operator()<switch_tran, Switchtran>(cap_root.getFactorySwitchtran(), this, switch_tranMaker.objects_);
  adapter.template operator()<sys_func_call, Sysfunccall>(cap_root.getFactorySysfunccall(), this, sys_func_callMaker.objects_);
  adapter.template operator()<sys_task_call, Systaskcall>(cap_root.getFactorySystaskcall(), this, sys_task_callMaker.objects_);
  adapter.template operator()<table_entry, Tableentry>(cap_root.getFactoryTableentry(), this, table_entryMaker.objects_);
  adapter.template operator()<tagged_pattern, Taggedpattern>(cap_root.getFactoryTaggedpattern(), this, tagged_patternMaker.objects_);
  adapter.template operator()<task, Task>(cap_root.getFactoryTask(), this, taskMaker.objects_);
  adapter.template operator()<task_call, Taskcall>(cap_root.getFactoryTaskcall(), this, task_callMaker.objects_);
  adapter.template operator()<tchk, Tchk>(cap_root.getFactoryTchk(), this, tchkMaker.objects_);
  adapter.template operator()<tchk_term, Tchkterm>(cap_root.getFactoryTchkterm(), this, tchk_termMaker.objects_);
  adapter.template operator()<thread_obj, Threadobj>(cap_root.getFactoryThreadobj(), this, thread_objMaker.objects_);
  adapter.template operator()<time_net, Timenet>(cap_root.getFactoryTimenet(), this, time_netMaker.objects_);
  adapter.template operator()<time_typespec, Timetypespec>(cap_root.getFactoryTimetypespec(), this, time_typespecMaker.objects_);
  adapter.template operator()<time_var, Timevar>(cap_root.getFactoryTimevar(), this, time_varMaker.objects_);
  adapter.template operator()<type_parameter, Typeparameter>(cap_root.getFactoryTypeparameter(), this, type_parameterMaker.objects_);
  adapter.template operator()<typespec_member, Typespecmember>(cap_root.getFactoryTypespecmember(), this, typespec_memberMaker.objects_);
  adapter.template operator()<udp, Udp>(cap_root.getFactoryUdp(), this, udpMaker.objects_);
  adapter.template operator()<udp_array, Udparray>(cap_root.getFactoryUdparray(), this, udp_arrayMaker.objects_);
  adapter.template operator()<udp_defn, Udpdefn>(cap_root.getFactoryUdpdefn(), this, udp_defnMaker.objects_);
  adapter.template operator()<union_typespec, Uniontypespec>(cap_root.getFactoryUniontypespec(), this, union_typespecMaker.objects_);
  adapter.template operator()<union_var, Unionvar>(cap_root.getFactoryUnionvar(), this, union_varMaker.objects_);
  adapter.template operator()<unsupported_expr, Unsupportedexpr>(cap_root.getFactoryUnsupportedexpr(), this, unsupported_exprMaker.objects_);
  adapter.template operator()<unsupported_stmt, Unsupportedstmt>(cap_root.getFactoryUnsupportedstmt(), this, unsupported_stmtMaker.objects_);
  adapter.template operator()<unsupported_typespec, Unsupportedtypespec>(cap_root.getFactoryUnsupportedtypespec(), this, unsupported_typespecMaker.objects_);
  adapter.template operator()<user_systf, Usersystf>(cap_root.getFactoryUsersystf(), this, user_systfMaker.objects_);
  adapter.template operator()<var_bit, Varbit>(cap_root.getFactoryVarbit(), this, var_bitMaker.objects_);
  adapter.template operator()<var_select, Varselect>(cap_root.getFactoryVarselect(), this, var_selectMaker.objects_);
  adapter.template operator()<virtual_interface_var, Virtualinterfacevar>(cap_root.getFactoryVirtualinterfacevar(), this, virtual_interface_varMaker.objects_);
  adapter.template operator()<void_typespec, Voidtypespec>(cap_root.getFactoryVoidtypespec(), this, void_typespecMaker.objects_);
  adapter.template operator()<wait_fork, Waitfork>(cap_root.getFactoryWaitfork(), this, wait_forkMaker.objects_);
  adapter.template operator()<wait_stmt, Waitstmt>(cap_root.getFactoryWaitstmt(), this, wait_stmtMaker.objects_);
  adapter.template operator()<while_stmt, Whilestmt>(cap_root.getFactoryWhilestmt(), this, while_stmtMaker.objects_);

   for (auto d : designMaker.objects_) {
    vpiHandle designH = uhdm_handleMaker.Make(UHDM_OBJECT_TYPE::uhdmdesign, d);
    designs.push_back(designH);
  }

  close(fileid);
  return designs;
}
}  // namespace UHDM
