/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   Serializer_save.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */
#include <uhdm/Serializer.h>

#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>

#if defined(_MSC_VER)
  #include <io.h>
#else
  #include <unistd.h>
#endif

#include <iostream>
#include <string>
#include <vector>

#include <capnp/message.h>
#include <capnp/serialize-packed.h>

#include "UHDM.capnp.h"
#include <uhdm/containers.h>
#include <uhdm/uhdm.h>
#include <uhdm/uhdm_types.h>

#include "uhdm/config.h"

namespace UHDM {
inline static uint32_t GetId(const BaseClass* p, const Serializer::IdMap &idMap) {
  auto it = idMap.find(p);
  return (it == idMap.end()) ? Serializer::kBadIndex : it->second;
}

struct Serializer::SaveAdapter {
  void operator()(const BaseClass *const obj, Serializer *const serializer, const IdMap& idMap, Any::Builder builder) const {
    if (obj->VpiParent() != nullptr) {
      ::ObjIndexType::Builder vpiParentBuilder = builder.getVpiParent();
      vpiParentBuilder.setIndex(GetId(obj->VpiParent(), idMap));
      vpiParentBuilder.setType(static_cast<uint32_t>(obj->VpiParent()->UhdmType()));
    }
    builder.setVpiFile((RawSymbolId)obj->GetSerializer()->symbolMaker.Make(obj->VpiFile()));
    builder.setVpiLineNo(obj->VpiLineNo());
    builder.setVpiColumnNo(obj->VpiColumnNo());
    builder.setVpiEndLineNo(obj->VpiEndLineNo());
    builder.setVpiEndColumnNo(obj->VpiEndColumnNo());
    builder.setUhdmId(obj->UhdmId());
  }

  void operator()(const attribute *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Attribute::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiDefAttribute(obj->VpiDefAttribute());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    builder.setVpiDefFile((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefFile()));
    builder.setVpiDefLineNo(obj->VpiDefLineNo());
  }

  void operator()(const virtual_interface_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Virtualinterfacevar::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const let_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Letdecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Expressions() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Expressionss = builder.initExpressions(obj->Expressions()->size());
      for (int32_t i = 0, n = obj->Expressions()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Expressionss[i];
        tmp.setIndex(GetId((*obj->Expressions())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Expressions())[i]))->UhdmType()));
      }
    }
    if (obj->Seq_formal_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Seqformaldeclss = builder.initSeqformaldecls(obj->Seq_formal_decls()->size());
      for (int32_t i = 0, n = obj->Seq_formal_decls()->size(); i < n; ++i) {
        Seqformaldeclss.set(i, GetId((*obj->Seq_formal_decls())[i], idMap));
      }
    }
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
  }

  void operator()(const concurrent_assertions *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Concurrentassertions::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiIsClockInferred(obj->VpiIsClockInferred());
    if (obj->Clocking_event() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getClockingevent();
      tmp.setIndex(GetId(obj->Clocking_event(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Clocking_event())->UhdmType()));
    }
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->VpiProperty() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiProperty();
      tmp.setIndex(GetId(obj->VpiProperty(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiProperty())->UhdmType()));
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const process_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Processstmt::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->Module_inst() != nullptr) builder.setModuleinst(GetId(obj->Module_inst(), idMap));
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const always *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Always::Builder builder) const {
    operator()(static_cast<const process_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiAlwaysType(obj->VpiAlwaysType());
  }

  void operator()(const final_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Finalstmt::Builder builder) const {
    operator()(static_cast<const process_stmt*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const initial *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Initial::Builder builder) const {
    operator()(static_cast<const process_stmt*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const atomic_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Atomicstmt::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const delay_control *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Delaycontrol::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDelay((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDelay()));
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->Delay() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getDelay();
      tmp.setIndex(GetId(obj->Delay(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Delay())->UhdmType()));
    }
  }

  void operator()(const delay_term *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Delayterm::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const event_control *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Eventcontrol::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
  }

  void operator()(const repeat_control *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Repeatcontrol::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const scope *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Scope::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    if (obj->Property_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Propertydeclss = builder.initPropertydecls(obj->Property_decls()->size());
      for (int32_t i = 0, n = obj->Property_decls()->size(); i < n; ++i) {
        Propertydeclss.set(i, GetId((*obj->Property_decls())[i], idMap));
      }
    }
    if (obj->Sequence_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Sequencedeclss = builder.initSequencedecls(obj->Sequence_decls()->size());
      for (int32_t i = 0, n = obj->Sequence_decls()->size(); i < n; ++i) {
        Sequencedeclss.set(i, GetId((*obj->Sequence_decls())[i], idMap));
      }
    }
    if (obj->Concurrent_assertions() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Concurrentassertionss = builder.initConcurrentassertions(obj->Concurrent_assertions()->size());
      for (int32_t i = 0, n = obj->Concurrent_assertions()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Concurrentassertionss[i];
        tmp.setIndex(GetId((*obj->Concurrent_assertions())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Concurrent_assertions())[i]))->UhdmType()));
      }
    }
    if (obj->Named_events() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Namedeventss = builder.initNamedevents(obj->Named_events()->size());
      for (int32_t i = 0, n = obj->Named_events()->size(); i < n; ++i) {
        Namedeventss.set(i, GetId((*obj->Named_events())[i], idMap));
      }
    }
    if (obj->Named_event_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Namedeventarrayss = builder.initNamedeventarrays(obj->Named_event_arrays()->size());
      for (int32_t i = 0, n = obj->Named_event_arrays()->size(); i < n; ++i) {
        Namedeventarrayss.set(i, GetId((*obj->Named_event_arrays())[i], idMap));
      }
    }
    if (obj->Variables() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabless = builder.initVariables(obj->Variables()->size());
      for (int32_t i = 0, n = obj->Variables()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabless[i];
        tmp.setIndex(GetId((*obj->Variables())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variables())[i]))->UhdmType()));
      }
    }
    if (obj->Virtual_interface_vars() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Virtualinterfacevarss = builder.initVirtualinterfacevars(obj->Virtual_interface_vars()->size());
      for (int32_t i = 0, n = obj->Virtual_interface_vars()->size(); i < n; ++i) {
        Virtualinterfacevarss.set(i, GetId((*obj->Virtual_interface_vars())[i], idMap));
      }
    }
    if (obj->Logic_vars() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Logicvarss = builder.initLogicvars(obj->Logic_vars()->size());
      for (int32_t i = 0, n = obj->Logic_vars()->size(); i < n; ++i) {
        Logicvarss.set(i, GetId((*obj->Logic_vars())[i], idMap));
      }
    }
    if (obj->Array_vars() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Arrayvarss = builder.initArrayvars(obj->Array_vars()->size());
      for (int32_t i = 0, n = obj->Array_vars()->size(); i < n; ++i) {
        Arrayvarss.set(i, GetId((*obj->Array_vars())[i], idMap));
      }
    }
    if (obj->Array_var_mems() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Arrayvarmemss = builder.initArrayvarmems(obj->Array_var_mems()->size());
      for (int32_t i = 0, n = obj->Array_var_mems()->size(); i < n; ++i) {
        Arrayvarmemss.set(i, GetId((*obj->Array_var_mems())[i], idMap));
      }
    }
    if (obj->Parameters() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Parameterss = builder.initParameters(obj->Parameters()->size());
      for (int32_t i = 0, n = obj->Parameters()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Parameterss[i];
        tmp.setIndex(GetId((*obj->Parameters())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Parameters())[i]))->UhdmType()));
      }
    }
    if (obj->Param_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Paramassignss = builder.initParamassigns(obj->Param_assigns()->size());
      for (int32_t i = 0, n = obj->Param_assigns()->size(); i < n; ++i) {
        Paramassignss.set(i, GetId((*obj->Param_assigns())[i], idMap));
      }
    }
    if (obj->Scopes() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Scopess = builder.initScopes(obj->Scopes()->size());
      for (int32_t i = 0, n = obj->Scopes()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Scopess[i];
        tmp.setIndex(GetId((*obj->Scopes())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Scopes())[i]))->UhdmType()));
      }
    }
    if (obj->Typespecs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Typespecss = builder.initTypespecs(obj->Typespecs()->size());
      for (int32_t i = 0, n = obj->Typespecs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Typespecss[i];
        tmp.setIndex(GetId((*obj->Typespecs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Typespecs())[i]))->UhdmType()));
      }
    }
    if (obj->Instance_items() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Instanceitemss = builder.initInstanceitems(obj->Instance_items()->size());
      for (int32_t i = 0, n = obj->Instance_items()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Instanceitemss[i];
        tmp.setIndex(GetId((*obj->Instance_items())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Instance_items())[i]))->UhdmType()));
      }
    }
    if (obj->Let_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Letdeclss = builder.initLetdecls(obj->Let_decls()->size());
      for (int32_t i = 0, n = obj->Let_decls()->size(); i < n; ++i) {
        Letdeclss.set(i, GetId((*obj->Let_decls())[i], idMap));
      }
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const begin *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Begin::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    if (obj->Stmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Stmtss = builder.initStmts(obj->Stmts()->size());
      for (int32_t i = 0, n = obj->Stmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Stmtss[i];
        tmp.setIndex(GetId((*obj->Stmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Stmts())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const named_begin *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Namedbegin::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    if (obj->Stmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Stmtss = builder.initStmts(obj->Stmts()->size());
      for (int32_t i = 0, n = obj->Stmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Stmtss[i];
        tmp.setIndex(GetId((*obj->Stmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Stmts())[i]))->UhdmType()));
      }
    }
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const named_fork *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Namedfork::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiJoinType(obj->VpiJoinType());
    if (obj->Stmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Stmtss = builder.initStmts(obj->Stmts()->size());
      for (int32_t i = 0, n = obj->Stmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Stmtss[i];
        tmp.setIndex(GetId((*obj->Stmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Stmts())[i]))->UhdmType()));
      }
    }
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const fork_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Forkstmt::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiJoinType(obj->VpiJoinType());
    if (obj->Stmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Stmtss = builder.initStmts(obj->Stmts()->size());
      for (int32_t i = 0, n = obj->Stmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Stmtss[i];
        tmp.setIndex(GetId((*obj->Stmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Stmts())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const for_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Forstmt::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiLocalVarDecls(obj->VpiLocalVarDecls());
    if (obj->VpiForInitStmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiForInitStmtss = builder.initVpiForInitStmts(obj->VpiForInitStmts()->size());
      for (int32_t i = 0, n = obj->VpiForInitStmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiForInitStmtss[i];
        tmp.setIndex(GetId((*obj->VpiForInitStmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiForInitStmts())[i]))->UhdmType()));
      }
    }
    if (obj->VpiForIncStmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiForIncStmtss = builder.initVpiForIncStmts(obj->VpiForIncStmts()->size());
      for (int32_t i = 0, n = obj->VpiForIncStmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiForIncStmtss[i];
        tmp.setIndex(GetId((*obj->VpiForIncStmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiForIncStmts())[i]))->UhdmType()));
      }
    }
    if (obj->VpiForInitStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiForInitStmt();
      tmp.setIndex(GetId(obj->VpiForInitStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiForInitStmt())->UhdmType()));
    }
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiForIncStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiForIncStmt();
      tmp.setIndex(GetId(obj->VpiForIncStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiForIncStmt())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const if_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Ifstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiQualifier(obj->VpiQualifier());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const event_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Eventstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiBlocking(obj->VpiBlocking());
    if (obj->Named_event() != nullptr) builder.setNamedevent(GetId(obj->Named_event(), idMap));
  }

  void operator()(const thread_obj *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Threadobj::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const forever_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Foreverstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const waits *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Waits::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const wait_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Waitstmt::Builder builder) const {
    operator()(static_cast<const waits*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
  }

  void operator()(const wait_fork *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Waitfork::Builder builder) const {
    operator()(static_cast<const waits*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const ordered_wait *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Orderedwait::Builder builder) const {
    operator()(static_cast<const waits*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiConditions() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiConditionss = builder.initVpiConditions(obj->VpiConditions()->size());
      for (int32_t i = 0, n = obj->VpiConditions()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiConditionss[i];
        tmp.setIndex(GetId((*obj->VpiConditions())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiConditions())[i]))->UhdmType()));
      }
    }
    if (obj->VpiElseStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiElseStmt();
      tmp.setIndex(GetId(obj->VpiElseStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiElseStmt())->UhdmType()));
    }
  }

  void operator()(const disables *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Disables::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const disable *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Disable::Builder builder) const {
    operator()(static_cast<const disables*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiExpr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiExpr();
      tmp.setIndex(GetId(obj->VpiExpr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiExpr())->UhdmType()));
    }
  }

  void operator()(const disable_fork *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Disablefork::Builder builder) const {
    operator()(static_cast<const disables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const continue_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Continuestmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const break_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Breakstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const return_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Returnstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
  }

  void operator()(const while_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Whilestmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const repeat *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Repeat::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const do_while *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Dowhile::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const if_else *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Ifelse::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiQualifier(obj->VpiQualifier());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
    if (obj->VpiElseStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiElseStmt();
      tmp.setIndex(GetId(obj->VpiElseStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiElseStmt())->UhdmType()));
    }
  }

  void operator()(const case_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Casestmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiRandType(obj->VpiRandType());
    builder.setVpiCaseType(obj->VpiCaseType());
    builder.setVpiQualifier(obj->VpiQualifier());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->Case_items() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Caseitemss = builder.initCaseitems(obj->Case_items()->size());
      for (int32_t i = 0, n = obj->Case_items()->size(); i < n; ++i) {
        Caseitemss.set(i, GetId((*obj->Case_items())[i], idMap));
      }
    }
  }

  void operator()(const force *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Force::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->Rhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRhs();
      tmp.setIndex(GetId(obj->Rhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Rhs())->UhdmType()));
    }
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
  }

  void operator()(const assign_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Assignstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->Rhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRhs();
      tmp.setIndex(GetId(obj->Rhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Rhs())->UhdmType()));
    }
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
  }

  void operator()(const deassign *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Deassign::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
  }

  void operator()(const release *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Release::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
  }

  void operator()(const null_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Nullstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const expect_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Expectstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->Else_stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getElsestmt();
      tmp.setIndex(GetId(obj->Else_stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Else_stmt())->UhdmType()));
    }
    if (obj->Property_spec() != nullptr) builder.setPropertyspec(GetId(obj->Property_spec(), idMap));
  }

  void operator()(const foreach_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Foreachstmt::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    if (obj->Variable() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVariable();
      tmp.setIndex(GetId(obj->Variable(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Variable())->UhdmType()));
    }
    if (obj->VpiLoopVars() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiLoopVarss = builder.initVpiLoopVars(obj->VpiLoopVars()->size());
      for (int32_t i = 0, n = obj->VpiLoopVars()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiLoopVarss[i];
        tmp.setIndex(GetId((*obj->VpiLoopVars())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiLoopVars())[i]))->UhdmType()));
      }
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const gen_scope *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genscope::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiIndex() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiIndex();
      tmp.setIndex(GetId(obj->VpiIndex(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiIndex())->UhdmType()));
    }
    builder.setVpiArrayMember(obj->VpiArrayMember());
    builder.setVpiProtected(obj->VpiProtected());
    builder.setVpiImplicitDecl(obj->VpiImplicitDecl());
    if (obj->Nets() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Netss = builder.initNets(obj->Nets()->size());
      for (int32_t i = 0, n = obj->Nets()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Netss[i];
        tmp.setIndex(GetId((*obj->Nets())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Nets())[i]))->UhdmType()));
      }
    }
    if (obj->Array_nets() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Arraynetss = builder.initArraynets(obj->Array_nets()->size());
      for (int32_t i = 0, n = obj->Array_nets()->size(); i < n; ++i) {
        Arraynetss.set(i, GetId((*obj->Array_nets())[i], idMap));
      }
    }
    if (obj->Process() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Processs = builder.initProcess(obj->Process()->size());
      for (int32_t i = 0, n = obj->Process()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Processs[i];
        tmp.setIndex(GetId((*obj->Process())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Process())[i]))->UhdmType()));
      }
    }
    if (obj->Cont_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignss = builder.initContassigns(obj->Cont_assigns()->size());
      for (int32_t i = 0, n = obj->Cont_assigns()->size(); i < n; ++i) {
        Contassignss.set(i, GetId((*obj->Cont_assigns())[i], idMap));
      }
    }
    if (obj->Modules() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Moduless = builder.initModules(obj->Modules()->size());
      for (int32_t i = 0, n = obj->Modules()->size(); i < n; ++i) {
        Moduless.set(i, GetId((*obj->Modules())[i], idMap));
      }
    }
    if (obj->Module_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Modulearrayss = builder.initModulearrays(obj->Module_arrays()->size());
      for (int32_t i = 0, n = obj->Module_arrays()->size(); i < n; ++i) {
        Modulearrayss.set(i, GetId((*obj->Module_arrays())[i], idMap));
      }
    }
    if (obj->Primitives() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Primitivess = builder.initPrimitives(obj->Primitives()->size());
      for (int32_t i = 0, n = obj->Primitives()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Primitivess[i];
        tmp.setIndex(GetId((*obj->Primitives())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Primitives())[i]))->UhdmType()));
      }
    }
    if (obj->Primitive_arrays() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Primitivearrayss = builder.initPrimitivearrays(obj->Primitive_arrays()->size());
      for (int32_t i = 0, n = obj->Primitive_arrays()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Primitivearrayss[i];
        tmp.setIndex(GetId((*obj->Primitive_arrays())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Primitive_arrays())[i]))->UhdmType()));
      }
    }
    if (obj->Def_params() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Defparamss = builder.initDefparams(obj->Def_params()->size());
      for (int32_t i = 0, n = obj->Def_params()->size(); i < n; ++i) {
        Defparamss.set(i, GetId((*obj->Def_params())[i], idMap));
      }
    }
    if (obj->Gen_scope_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Genscopearrayss = builder.initGenscopearrays(obj->Gen_scope_arrays()->size());
      for (int32_t i = 0, n = obj->Gen_scope_arrays()->size(); i < n; ++i) {
        Genscopearrayss.set(i, GetId((*obj->Gen_scope_arrays())[i], idMap));
      }
    }
    if (obj->Programs() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Programss = builder.initPrograms(obj->Programs()->size());
      for (int32_t i = 0, n = obj->Programs()->size(); i < n; ++i) {
        Programss.set(i, GetId((*obj->Programs())[i], idMap));
      }
    }
    if (obj->Program_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Programarrayss = builder.initProgramarrays(obj->Program_arrays()->size());
      for (int32_t i = 0, n = obj->Program_arrays()->size(); i < n; ++i) {
        Programarrayss.set(i, GetId((*obj->Program_arrays())[i], idMap));
      }
    }
    if (obj->Assertions() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Assertionss = builder.initAssertions(obj->Assertions()->size());
      for (int32_t i = 0, n = obj->Assertions()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Assertionss[i];
        tmp.setIndex(GetId((*obj->Assertions())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Assertions())[i]))->UhdmType()));
      }
    }
    if (obj->Interfaces() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacess = builder.initInterfaces(obj->Interfaces()->size());
      for (int32_t i = 0, n = obj->Interfaces()->size(); i < n; ++i) {
        Interfacess.set(i, GetId((*obj->Interfaces())[i], idMap));
      }
    }
    if (obj->Interface_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacearrayss = builder.initInterfacearrays(obj->Interface_arrays()->size());
      for (int32_t i = 0, n = obj->Interface_arrays()->size(); i < n; ++i) {
        Interfacearrayss.set(i, GetId((*obj->Interface_arrays())[i], idMap));
      }
    }
    if (obj->Alias_stmts() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Aliasstmtss = builder.initAliasstmts(obj->Alias_stmts()->size());
      for (int32_t i = 0, n = obj->Alias_stmts()->size(); i < n; ++i) {
        Aliasstmtss.set(i, GetId((*obj->Alias_stmts())[i], idMap));
      }
    }
    if (obj->Clocking_blocks() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Clockingblockss = builder.initClockingblocks(obj->Clocking_blocks()->size());
      for (int32_t i = 0, n = obj->Clocking_blocks()->size(); i < n; ++i) {
        Clockingblockss.set(i, GetId((*obj->Clocking_blocks())[i], idMap));
      }
    }
    if (obj->Task_funcs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Taskfuncss = builder.initTaskfuncs(obj->Task_funcs()->size());
      for (int32_t i = 0, n = obj->Task_funcs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Taskfuncss[i];
        tmp.setIndex(GetId((*obj->Task_funcs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Task_funcs())[i]))->UhdmType()));
      }
    }
    if (obj->Elab_tasks() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Elabtaskss = builder.initElabtasks(obj->Elab_tasks()->size());
      for (int32_t i = 0, n = obj->Elab_tasks()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Elabtaskss[i];
        tmp.setIndex(GetId((*obj->Elab_tasks())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Elab_tasks())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const gen_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genvar::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    if (obj->Gen_scope_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Genscopearrayss = builder.initGenscopearrays(obj->Gen_scope_arrays()->size());
      for (int32_t i = 0, n = obj->Gen_scope_arrays()->size(); i < n; ++i) {
        Genscopearrayss.set(i, GetId((*obj->Gen_scope_arrays())[i], idMap));
      }
    }
  }

  void operator()(const gen_scope_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genscopearray::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSize(obj->VpiSize());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    if (obj->Gen_var() != nullptr) builder.setGenvar(GetId(obj->Gen_var(), idMap));
    if (obj->Gen_scopes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Genscopess = builder.initGenscopes(obj->Gen_scopes()->size());
      for (int32_t i = 0, n = obj->Gen_scopes()->size(); i < n; ++i) {
        Genscopess.set(i, GetId((*obj->Gen_scopes())[i], idMap));
      }
    }
    if (obj->VpiInstance() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiInstance();
      tmp.setIndex(GetId(obj->VpiInstance(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiInstance())->UhdmType()));
    }
  }

  void operator()(const assert_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Assertstmt::Builder builder) const {
    operator()(static_cast<const concurrent_assertions*>(obj), serializer, idMap, builder.getBase());
    if (obj->Else_stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getElsestmt();
      tmp.setIndex(GetId(obj->Else_stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Else_stmt())->UhdmType()));
    }
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const cover *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Cover::Builder builder) const {
    operator()(static_cast<const concurrent_assertions*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIsCoverSequence(obj->VpiIsCoverSequence());
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const assume *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Assume::Builder builder) const {
    operator()(static_cast<const concurrent_assertions*>(obj), serializer, idMap, builder.getBase());
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const restrict *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Restrict::Builder builder) const {
    operator()(static_cast<const concurrent_assertions*>(obj), serializer, idMap, builder.getBase());
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const immediate_assert *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Immediateassert::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIsDeferred(obj->VpiIsDeferred());
    builder.setVpiIsFinal(obj->VpiIsFinal());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->Else_stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getElsestmt();
      tmp.setIndex(GetId(obj->Else_stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Else_stmt())->UhdmType()));
    }
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const immediate_assume *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Immediateassume::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIsDeferred(obj->VpiIsDeferred());
    builder.setVpiIsFinal(obj->VpiIsFinal());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->Else_stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getElsestmt();
      tmp.setIndex(GetId(obj->Else_stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Else_stmt())->UhdmType()));
    }
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const immediate_cover *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Immediatecover::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIsDeferred(obj->VpiIsDeferred());
    builder.setVpiIsFinal(obj->VpiIsFinal());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const expr *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Expr::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDecompile((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDecompile()));
    builder.setVpiSize(obj->VpiSize());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
  }

  void operator()(const case_item *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Caseitem::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiExprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiExprss = builder.initVpiExprs(obj->VpiExprs()->size());
      for (int32_t i = 0, n = obj->VpiExprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiExprss[i];
        tmp.setIndex(GetId((*obj->VpiExprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiExprs())[i]))->UhdmType()));
      }
    }
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
  }

  void operator()(const assignment *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Assignment::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiOpType(obj->VpiOpType());
    builder.setVpiBlocking(obj->VpiBlocking());
    if (obj->Rhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRhs();
      tmp.setIndex(GetId(obj->Rhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Rhs())->UhdmType()));
    }
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
    if (obj->Delay_control() != nullptr) builder.setDelaycontrol(GetId(obj->Delay_control(), idMap));
    if (obj->Event_control() != nullptr) builder.setEventcontrol(GetId(obj->Event_control(), idMap));
    if (obj->Repeat_control() != nullptr) builder.setRepeatcontrol(GetId(obj->Repeat_control(), idMap));
  }

  void operator()(const any_pattern *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Anypattern::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
  }

  void operator()(const tagged_pattern *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Taggedpattern::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Pattern() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getPattern();
      tmp.setIndex(GetId(obj->Pattern(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Pattern())->UhdmType()));
    }
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
  }

  void operator()(const struct_pattern *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Structpattern::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Pattern() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getPattern();
      tmp.setIndex(GetId(obj->Pattern(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Pattern())->UhdmType()));
    }
  }

  void operator()(const unsupported_expr *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Unsupportedexpr::Builder builder) const {
    operator()(static_cast<const expr*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const unsupported_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Unsupportedstmt::Builder builder) const {
    operator()(static_cast<const atomic_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
  }

  void operator()(const include_file_info *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Includefileinfo::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIncludedFile((RawSymbolId)serializer->symbolMaker.Make(obj->VpiIncludedFile()));
  }

  void operator()(const sequence_inst *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Sequenceinst::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Sequence_decl() != nullptr) builder.setSequencedecl(GetId(obj->Sequence_decl(), idMap));
    if (obj->Named_event_sequence_expr_groups() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Namedeventsequenceexprgroupss = builder.initNamedeventsequenceexprgroups(obj->Named_event_sequence_expr_groups()->size());
      for (int32_t i = 0, n = obj->Named_event_sequence_expr_groups()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Namedeventsequenceexprgroupss[i];
        tmp.setIndex(GetId((*obj->Named_event_sequence_expr_groups())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Named_event_sequence_expr_groups())[i]))->UhdmType()));
      }
    }
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const seq_formal_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Seqformaldecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiDirection(obj->VpiDirection());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Named_event_sequence_expr_group() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getNamedeventsequenceexprgroup();
      tmp.setIndex(GetId(obj->Named_event_sequence_expr_group(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Named_event_sequence_expr_group())->UhdmType()));
    }
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
  }

  void operator()(const sequence_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Sequencedecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Variables() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabless = builder.initVariables(obj->Variables()->size());
      for (int32_t i = 0, n = obj->Variables()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabless[i];
        tmp.setIndex(GetId((*obj->Variables())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variables())[i]))->UhdmType()));
      }
    }
    if (obj->Sequence_expr_multiclock_group() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getSequenceexprmulticlockgroup();
      tmp.setIndex(GetId(obj->Sequence_expr_multiclock_group(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Sequence_expr_multiclock_group())->UhdmType()));
    }
    if (obj->Seq_formal_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Seqformaldeclss = builder.initSeqformaldecls(obj->Seq_formal_decls()->size());
      for (int32_t i = 0, n = obj->Seq_formal_decls()->size(); i < n; ++i) {
        Seqformaldeclss.set(i, GetId((*obj->Seq_formal_decls())[i], idMap));
      }
    }
  }

  void operator()(const prop_formal_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Propformaldecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiDirection(obj->VpiDirection());
    if (obj->VpiExpr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiExpr();
      tmp.setIndex(GetId(obj->VpiExpr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiExpr())->UhdmType()));
    }
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
  }

  void operator()(const property_inst *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Propertyinst::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiDisableCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiDisableCondition();
      tmp.setIndex(GetId(obj->VpiDisableCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiDisableCondition())->UhdmType()));
    }
    if (obj->VpiArguments() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiArgumentss = builder.initVpiArguments(obj->VpiArguments()->size());
      for (int32_t i = 0, n = obj->VpiArguments()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiArgumentss[i];
        tmp.setIndex(GetId((*obj->VpiArguments())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiArguments())[i]))->UhdmType()));
      }
    }
    if (obj->Property_decl() != nullptr) builder.setPropertydecl(GetId(obj->Property_decl(), idMap));
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Clocking_block() != nullptr) builder.setClockingblock(GetId(obj->Clocking_block(), idMap));
  }

  void operator()(const property_spec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Propertyspec::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiDisableCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiDisableCondition();
      tmp.setIndex(GetId(obj->VpiDisableCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiDisableCondition())->UhdmType()));
    }
    if (obj->VpiClockingEvent() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiClockingEvent();
      tmp.setIndex(GetId(obj->VpiClockingEvent(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiClockingEvent())->UhdmType()));
    }
    if (obj->VpiPropertyExpr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiPropertyExpr();
      tmp.setIndex(GetId(obj->VpiPropertyExpr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiPropertyExpr())->UhdmType()));
    }
  }

  void operator()(const property_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Propertydecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Prop_formal_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Propformaldeclss = builder.initPropformaldecls(obj->Prop_formal_decls()->size());
      for (int32_t i = 0, n = obj->Prop_formal_decls()->size(); i < n; ++i) {
        Propformaldeclss.set(i, GetId((*obj->Prop_formal_decls())[i], idMap));
      }
    }
    if (obj->Variables() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabless = builder.initVariables(obj->Variables()->size());
      for (int32_t i = 0, n = obj->Variables()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabless[i];
        tmp.setIndex(GetId((*obj->Variables())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variables())[i]))->UhdmType()));
      }
    }
    if (obj->Property_spec() != nullptr) builder.setPropertyspec(GetId(obj->Property_spec(), idMap));
  }

  void operator()(const clocked_property *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Clockedproperty::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiClockingEvent() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiClockingEvent();
      tmp.setIndex(GetId(obj->VpiClockingEvent(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiClockingEvent())->UhdmType()));
    }
    if (obj->VpiPropertyExpr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiPropertyExpr();
      tmp.setIndex(GetId(obj->VpiPropertyExpr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiPropertyExpr())->UhdmType()));
    }
  }

  void operator()(const case_property_item *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Casepropertyitem::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Expressions() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Expressionss = builder.initExpressions(obj->Expressions()->size());
      for (int32_t i = 0, n = obj->Expressions()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Expressionss[i];
        tmp.setIndex(GetId((*obj->Expressions())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Expressions())[i]))->UhdmType()));
      }
    }
    if (obj->Property_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getPropertyexpr();
      tmp.setIndex(GetId(obj->Property_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Property_expr())->UhdmType()));
    }
  }

  void operator()(const case_property *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Caseproperty::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->Case_property_items() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Casepropertyitemss = builder.initCasepropertyitems(obj->Case_property_items()->size());
      for (int32_t i = 0, n = obj->Case_property_items()->size(); i < n; ++i) {
        Casepropertyitemss.set(i, GetId((*obj->Case_property_items())[i], idMap));
      }
    }
  }

  void operator()(const multiclock_sequence_expr *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Multiclocksequenceexpr::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Clocked_seqs() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Clockedseqss = builder.initClockedseqs(obj->Clocked_seqs()->size());
      for (int32_t i = 0, n = obj->Clocked_seqs()->size(); i < n; ++i) {
        Clockedseqss.set(i, GetId((*obj->Clocked_seqs())[i], idMap));
      }
    }
  }

  void operator()(const clocked_seq *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Clockedseq::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiClockingEvent() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiClockingEvent();
      tmp.setIndex(GetId(obj->VpiClockingEvent(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiClockingEvent())->UhdmType()));
    }
    if (obj->VpiSequenceExpr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiSequenceExpr();
      tmp.setIndex(GetId(obj->VpiSequenceExpr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiSequenceExpr())->UhdmType()));
    }
  }

  void operator()(const simple_expr *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Simpleexpr::Builder builder) const {
    operator()(static_cast<const expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiUses() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiUsess = builder.initVpiUses(obj->VpiUses()->size());
      for (int32_t i = 0, n = obj->VpiUses()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiUsess[i];
        tmp.setIndex(GetId((*obj->VpiUses())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiUses())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const constant *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Constant::Builder builder) const {
    operator()(static_cast<const expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConstType(obj->VpiConstType());
  }

  void operator()(const let_expr *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Letexpr::Builder builder) const {
    operator()(static_cast<const expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Arguments() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Argumentss = builder.initArguments(obj->Arguments()->size());
      for (int32_t i = 0, n = obj->Arguments()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Argumentss[i];
        tmp.setIndex(GetId((*obj->Arguments())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Arguments())[i]))->UhdmType()));
      }
    }
    if (obj->Let_decl() != nullptr) builder.setLetdecl(GetId(obj->Let_decl(), idMap));
  }

  void operator()(const operation *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Operation::Builder builder) const {
    operator()(static_cast<const expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiOpType(obj->VpiOpType());
    builder.setVpiReordered(obj->VpiReordered());
    builder.setVpiFlattened(obj->VpiFlattened());
    builder.setVpiOpStrong(obj->VpiOpStrong());
    if (obj->Operands() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Operandss = builder.initOperands(obj->Operands()->size());
      for (int32_t i = 0, n = obj->Operands()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Operandss[i];
        tmp.setIndex(GetId((*obj->Operands())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Operands())[i]))->UhdmType()));
      }
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const ref_obj *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Refobj::Builder builder) const {
    operator()(static_cast<const simple_expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    builder.setVpiGeneric(obj->VpiGeneric());
    if (obj->Actual_group() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getActualgroup();
      tmp.setIndex(GetId(obj->Actual_group(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Actual_group())->UhdmType()));
    }
    builder.setVpiStructMember(obj->VpiStructMember());
  }

  void operator()(const ref_module *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Refmodule::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    if (obj->Actual_group() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getActualgroup();
      tmp.setIndex(GetId(obj->Actual_group(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Actual_group())->UhdmType()));
    }
    if (obj->Ports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        Portss.set(i, GetId((*obj->Ports())[i], idMap));
      }
    }
  }

  void operator()(const ref_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Reftypespec::Builder builder) const {
    operator()(static_cast<const simple_expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    if (obj->Actual_typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getActualtypespec();
      tmp.setIndex(GetId(obj->Actual_typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Actual_typespec())->UhdmType()));
    }
  }

  void operator()(const part_select *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Partselect::Builder builder) const {
    operator()(static_cast<const ref_obj*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    if (obj->Left_range() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftrange();
      tmp.setIndex(GetId(obj->Left_range(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_range())->UhdmType()));
    }
    if (obj->Right_range() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightrange();
      tmp.setIndex(GetId(obj->Right_range(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_range())->UhdmType()));
    }
  }

  void operator()(const indexed_part_select *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Indexedpartselect::Builder builder) const {
    operator()(static_cast<const ref_obj*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    builder.setVpiIndexedPartSelectType(obj->VpiIndexedPartSelectType());
    if (obj->Base_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getBaseexpr();
      tmp.setIndex(GetId(obj->Base_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Base_expr())->UhdmType()));
    }
    if (obj->Width_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getWidthexpr();
      tmp.setIndex(GetId(obj->Width_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Width_expr())->UhdmType()));
    }
  }

  void operator()(const var_select *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Varselect::Builder builder) const {
    operator()(static_cast<const ref_obj*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Exprss = builder.initExprs(obj->Exprs()->size());
      for (int32_t i = 0, n = obj->Exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Exprss[i];
        tmp.setIndex(GetId((*obj->Exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const bit_select *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Bitselect::Builder builder) const {
    operator()(static_cast<const ref_obj*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    if (obj->VpiIndex() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiIndex();
      tmp.setIndex(GetId(obj->VpiIndex(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiIndex())->UhdmType()));
    }
  }

  void operator()(const variables *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Variables::Builder builder) const {
    operator()(static_cast<const simple_expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiArrayMember(obj->VpiArrayMember());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiSigned(obj->VpiSigned());
    builder.setVpiAutomatic(obj->VpiAutomatic());
    builder.setVpiAllocScheme(obj->VpiAllocScheme());
    builder.setVpiConstantVariable(obj->VpiConstantVariable());
    builder.setVpiIsRandomized(obj->VpiIsRandomized());
    builder.setVpiRandType(obj->VpiRandType());
    builder.setVpiStructUnionMember(obj->VpiStructUnionMember());
    builder.setVpiScalar(obj->VpiScalar());
    builder.setVpiVisibility(obj->VpiVisibility());
    builder.setVpiVector(obj->VpiVector());
    if (obj->Ports() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Portss[i];
        tmp.setIndex(GetId((*obj->Ports())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Ports())[i]))->UhdmType()));
      }
    }
    if (obj->Variable_drivers() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabledriverss = builder.initVariabledrivers(obj->Variable_drivers()->size());
      for (int32_t i = 0, n = obj->Variable_drivers()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabledriverss[i];
        tmp.setIndex(GetId((*obj->Variable_drivers())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variable_drivers())[i]))->UhdmType()));
      }
    }
    if (obj->Variable_loads() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variableloadss = builder.initVariableloads(obj->Variable_loads()->size());
      for (int32_t i = 0, n = obj->Variable_loads()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variableloadss[i];
        tmp.setIndex(GetId((*obj->Variable_loads())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variable_loads())[i]))->UhdmType()));
      }
    }
    if (obj->Prim_terms() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Primtermss = builder.initPrimterms(obj->Prim_terms()->size());
      for (int32_t i = 0, n = obj->Prim_terms()->size(); i < n; ++i) {
        Primtermss.set(i, GetId((*obj->Prim_terms())[i], idMap));
      }
    }
    if (obj->Cont_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignss = builder.initContassigns(obj->Cont_assigns()->size());
      for (int32_t i = 0, n = obj->Cont_assigns()->size(); i < n; ++i) {
        Contassignss.set(i, GetId((*obj->Cont_assigns())[i], idMap));
      }
    }
    if (obj->Path_term() != nullptr) builder.setPathterm(GetId(obj->Path_term(), idMap));
    if (obj->Tchk_term() != nullptr) builder.setTchkterm(GetId(obj->Tchk_term(), idMap));
    if (obj->Module_inst() != nullptr) builder.setModuleinst(GetId(obj->Module_inst(), idMap));
    if (obj->Instance() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstance();
      tmp.setIndex(GetId(obj->Instance(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance())->UhdmType()));
    }
    if (obj->Scope() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getScope();
      tmp.setIndex(GetId(obj->Scope(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Scope())->UhdmType()));
    }
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Indexes() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Indexess = builder.initIndexes(obj->Indexes()->size());
      for (int32_t i = 0, n = obj->Indexes()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Indexess[i];
        tmp.setIndex(GetId((*obj->Indexes())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Indexes())[i]))->UhdmType()));
      }
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const hier_path *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Hierpath::Builder builder) const {
    operator()(static_cast<const simple_expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Path_elems() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Pathelemss = builder.initPathelems(obj->Path_elems()->size());
      for (int32_t i = 0, n = obj->Path_elems()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Pathelemss[i];
        tmp.setIndex(GetId((*obj->Path_elems())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Path_elems())[i]))->UhdmType()));
      }
    }
    if (obj->Root_value() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRootvalue();
      tmp.setIndex(GetId(obj->Root_value(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Root_value())->UhdmType()));
    }
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
  }

  void operator()(const ref_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Refvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    builder.setVpiGeneric(obj->VpiGeneric());
    if (obj->Actual_group() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getActualgroup();
      tmp.setIndex(GetId(obj->Actual_group(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Actual_group())->UhdmType()));
    }
    if (obj->Task_func() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTaskfunc();
      tmp.setIndex(GetId(obj->Task_func(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Task_func())->UhdmType()));
    }
    builder.setVpiStructMember(obj->VpiStructMember());
  }

  void operator()(const short_real_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Shortrealvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const real_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Realvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const byte_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Bytevar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const short_int_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Shortintvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const int_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Intvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const long_int_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Longintvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const integer_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Integervar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const time_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Timevar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const array_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Arrayvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiArrayType(obj->VpiArrayType());
    if (obj->Var_selects() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Varselectss = builder.initVarselects(obj->Var_selects()->size());
      for (int32_t i = 0, n = obj->Var_selects()->size(); i < n; ++i) {
        Varselectss.set(i, GetId((*obj->Var_selects())[i], idMap));
      }
    }
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Variables() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabless = builder.initVariables(obj->Variables()->size());
      for (int32_t i = 0, n = obj->Variables()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabless[i];
        tmp.setIndex(GetId((*obj->Variables())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variables())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const array_expr *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Arrayexpr::Builder builder) const {
    operator()(static_cast<const expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Exprss = builder.initExprs(obj->Exprs()->size());
      for (int32_t i = 0, n = obj->Exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Exprss[i];
        tmp.setIndex(GetId((*obj->Exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const reg_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Regarray::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIsMemory(obj->VpiIsMemory());
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Regs() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Regss = builder.initRegs(obj->Regs()->size());
      for (int32_t i = 0, n = obj->Regs()->size(); i < n; ++i) {
        Regss.set(i, GetId((*obj->Regs())[i], idMap));
      }
    }
  }

  void operator()(const reg *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Reg::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Index() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getIndex();
      tmp.setIndex(GetId(obj->Index(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Index())->UhdmType()));
    }
  }

  void operator()(const packed_array_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Packedarrayvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPackedArrayMember(obj->VpiPackedArrayMember());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    builder.setVpiPacked(obj->VpiPacked());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Var_bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Varbitss = builder.initVarbits(obj->Var_bits()->size());
      for (int32_t i = 0, n = obj->Var_bits()->size(); i < n; ++i) {
        Varbitss.set(i, GetId((*obj->Var_bits())[i], idMap));
      }
    }
    if (obj->Elements() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Elementss = builder.initElements(obj->Elements()->size());
      for (int32_t i = 0, n = obj->Elements()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Elementss[i];
        tmp.setIndex(GetId((*obj->Elements())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Elements())[i]))->UhdmType()));
      }
    }
    if (obj->Expr_index() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprindex();
      tmp.setIndex(GetId(obj->Expr_index(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_index())->UhdmType()));
    }
  }

  void operator()(const bit_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Bitvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Var_bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Varbitss = builder.initVarbits(obj->Var_bits()->size());
      for (int32_t i = 0, n = obj->Var_bits()->size(); i < n; ++i) {
        Varbitss.set(i, GetId((*obj->Var_bits())[i], idMap));
      }
    }
  }

  void operator()(const logic_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Logicvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Var_bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Varbitss = builder.initVarbits(obj->Var_bits()->size());
      for (int32_t i = 0, n = obj->Var_bits()->size(); i < n; ++i) {
        Varbitss.set(i, GetId((*obj->Var_bits())[i], idMap));
      }
    }
  }

  void operator()(const struct_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Structvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPackedArrayMember(obj->VpiPackedArrayMember());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    if (obj->Var_bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Varbitss = builder.initVarbits(obj->Var_bits()->size());
      for (int32_t i = 0, n = obj->Var_bits()->size(); i < n; ++i) {
        Varbitss.set(i, GetId((*obj->Var_bits())[i], idMap));
      }
    }
    if (obj->Variables() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabless = builder.initVariables(obj->Variables()->size());
      for (int32_t i = 0, n = obj->Variables()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabless[i];
        tmp.setIndex(GetId((*obj->Variables())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variables())[i]))->UhdmType()));
      }
    }
    if (obj->Expr_index() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprindex();
      tmp.setIndex(GetId(obj->Expr_index(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_index())->UhdmType()));
    }
  }

  void operator()(const union_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Unionvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPackedArrayMember(obj->VpiPackedArrayMember());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    if (obj->Var_bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Varbitss = builder.initVarbits(obj->Var_bits()->size());
      for (int32_t i = 0, n = obj->Var_bits()->size(); i < n; ++i) {
        Varbitss.set(i, GetId((*obj->Var_bits())[i], idMap));
      }
    }
    if (obj->Variables() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabless = builder.initVariables(obj->Variables()->size());
      for (int32_t i = 0, n = obj->Variables()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabless[i];
        tmp.setIndex(GetId((*obj->Variables())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variables())[i]))->UhdmType()));
      }
    }
    if (obj->Expr_index() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprindex();
      tmp.setIndex(GetId(obj->Expr_index(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_index())->UhdmType()));
    }
  }

  void operator()(const enum_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Enumvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPackedArrayMember(obj->VpiPackedArrayMember());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    if (obj->Expr_index() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprindex();
      tmp.setIndex(GetId(obj->Expr_index(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_index())->UhdmType()));
    }
  }

  void operator()(const string_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Stringvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const chandle_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Chandlevar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    if (obj->Actual_group() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getActualgroup();
      tmp.setIndex(GetId(obj->Actual_group(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Actual_group())->UhdmType()));
    }
  }

  void operator()(const var_bit *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Varbit::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    if (obj->Expr_index() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprindex();
      tmp.setIndex(GetId(obj->Expr_index(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_index())->UhdmType()));
    }
    if (obj->Expr_indexes() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Exprindexess = builder.initExprindexes(obj->Expr_indexes()->size());
      for (int32_t i = 0, n = obj->Expr_indexes()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Exprindexess[i];
        tmp.setIndex(GetId((*obj->Expr_indexes())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Expr_indexes())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const task_func *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Taskfunc::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiMethod(obj->VpiMethod());
    builder.setVpiAccessType(obj->VpiAccessType());
    builder.setVpiVisibility(obj->VpiVisibility());
    builder.setVpiVirtual(obj->VpiVirtual());
    builder.setVpiAutomatic(obj->VpiAutomatic());
    builder.setVpiDPIPure(obj->VpiDPIPure());
    builder.setVpiDPIContext(obj->VpiDPIContext());
    builder.setVpiDPICStr(obj->VpiDPICStr());
    builder.setVpiDPICIdentifier((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDPICIdentifier()));
    if (obj->Left_range() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftrange();
      tmp.setIndex(GetId(obj->Left_range(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_range())->UhdmType()));
    }
    if (obj->Right_range() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightrange();
      tmp.setIndex(GetId(obj->Right_range(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_range())->UhdmType()));
    }
    if (obj->Return() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getReturn();
      tmp.setIndex(GetId(obj->Return(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Return())->UhdmType()));
    }
    if (obj->Class_defn() != nullptr) builder.setClassdefn(GetId(obj->Class_defn(), idMap));
    if (obj->Io_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Iodeclss = builder.initIodecls(obj->Io_decls()->size());
      for (int32_t i = 0, n = obj->Io_decls()->size(); i < n; ++i) {
        Iodeclss.set(i, GetId((*obj->Io_decls())[i], idMap));
      }
    }
    if (obj->Stmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getStmt();
      tmp.setIndex(GetId(obj->Stmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Stmt())->UhdmType()));
    }
    if (obj->Instance() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstance();
      tmp.setIndex(GetId(obj->Instance(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance())->UhdmType()));
    }
  }

  void operator()(const task *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Task::Builder builder) const {
    operator()(static_cast<const task_func*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const function *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Function::Builder builder) const {
    operator()(static_cast<const task_func*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSigned(obj->VpiSigned());
    builder.setVpiSize(obj->VpiSize());
    builder.setVpiFuncType(obj->VpiFuncType());
  }

  void operator()(const modport *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Modport::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Io_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Iodeclss = builder.initIodecls(obj->Io_decls()->size());
      for (int32_t i = 0, n = obj->Io_decls()->size(); i < n; ++i) {
        Iodeclss.set(i, GetId((*obj->Io_decls())[i], idMap));
      }
    }
    if (obj->Interface_inst() != nullptr) builder.setInterfaceinst(GetId(obj->Interface_inst(), idMap));
  }

  void operator()(const interface_tf_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Interfacetfdecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiAccessType(obj->VpiAccessType());
    if (obj->Tasks() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Taskss = builder.initTasks(obj->Tasks()->size());
      for (int32_t i = 0, n = obj->Tasks()->size(); i < n; ++i) {
        Taskss.set(i, GetId((*obj->Tasks())[i], idMap));
      }
    }
    if (obj->Functions() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Functionss = builder.initFunctions(obj->Functions()->size());
      for (int32_t i = 0, n = obj->Functions()->size(); i < n; ++i) {
        Functionss.set(i, GetId((*obj->Functions())[i], idMap));
      }
    }
  }

  void operator()(const cont_assign *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Contassign::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiNetDeclAssign(obj->VpiNetDeclAssign());
    builder.setVpiStrength0(obj->VpiStrength0());
    builder.setVpiStrength1(obj->VpiStrength1());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Delay() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getDelay();
      tmp.setIndex(GetId(obj->Delay(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Delay())->UhdmType()));
    }
    if (obj->Rhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRhs();
      tmp.setIndex(GetId(obj->Rhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Rhs())->UhdmType()));
    }
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
    if (obj->Cont_assign_bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignbitss = builder.initContassignbits(obj->Cont_assign_bits()->size());
      for (int32_t i = 0, n = obj->Cont_assign_bits()->size(); i < n; ++i) {
        Contassignbitss.set(i, GetId((*obj->Cont_assign_bits())[i], idMap));
      }
    }
  }

  void operator()(const cont_assign_bit *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Contassignbit::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiOffset(obj->VpiOffset());
    builder.setVpiNetDeclAssign(obj->VpiNetDeclAssign());
    builder.setVpiStrength0(obj->VpiStrength0());
    builder.setVpiStrength1(obj->VpiStrength1());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Delay() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getDelay();
      tmp.setIndex(GetId(obj->Delay(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Delay())->UhdmType()));
    }
    if (obj->Rhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRhs();
      tmp.setIndex(GetId(obj->Rhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Rhs())->UhdmType()));
    }
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
  }

  void operator()(const ports *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Ports::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPortIndex(obj->VpiPortIndex());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiPortType(obj->VpiPortType());
    builder.setVpiScalar(obj->VpiScalar());
    builder.setVpiVector(obj->VpiVector());
    builder.setVpiConnByName(obj->VpiConnByName());
    builder.setVpiDirection(obj->VpiDirection());
    builder.setVpiSize(obj->VpiSize());
    builder.setVpiExplicitName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiExplicitName()));
    if (obj->High_conn() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getHighconn();
      tmp.setIndex(GetId(obj->High_conn(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->High_conn())->UhdmType()));
    }
    if (obj->Low_conn() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLowconn();
      tmp.setIndex(GetId(obj->Low_conn(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Low_conn())->UhdmType()));
    }
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
    if (obj->Instance() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstance();
      tmp.setIndex(GetId(obj->Instance(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance())->UhdmType()));
    }
    if (obj->Module_inst() != nullptr) builder.setModuleinst(GetId(obj->Module_inst(), idMap));
  }

  void operator()(const port *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Port::Builder builder) const {
    operator()(static_cast<const ports*>(obj), serializer, idMap, builder.getBase());
    if (obj->Bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Bitss = builder.initBits(obj->Bits()->size());
      for (int32_t i = 0, n = obj->Bits()->size(); i < n; ++i) {
        Bitss.set(i, GetId((*obj->Bits())[i], idMap));
      }
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const port_bit *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Portbit::Builder builder) const {
    operator()(static_cast<const ports*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const checker_port *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Checkerport::Builder builder) const {
    operator()(static_cast<const ports*>(obj), serializer, idMap, builder.getBase());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Property() != nullptr) builder.setProperty(GetId(obj->Property(), idMap));
    if (obj->Sequence() != nullptr) builder.setSequence(GetId(obj->Sequence(), idMap));
  }

  void operator()(const checker_inst_port *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Checkerinstport::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Property() != nullptr) builder.setProperty(GetId(obj->Property(), idMap));
    if (obj->Sequence() != nullptr) builder.setSequence(GetId(obj->Sequence(), idMap));
  }

  void operator()(const primitive *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Primitive::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiArrayMember(obj->VpiArrayMember());
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    builder.setVpiDelay((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDelay()));
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiPrimType(obj->VpiPrimType());
    builder.setVpiStrength0(obj->VpiStrength0());
    builder.setVpiStrength1(obj->VpiStrength1());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Delay() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getDelay();
      tmp.setIndex(GetId(obj->Delay(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Delay())->UhdmType()));
    }
    if (obj->Index() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getIndex();
      tmp.setIndex(GetId(obj->Index(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Index())->UhdmType()));
    }
    if (obj->Prim_terms() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Primtermss = builder.initPrimterms(obj->Prim_terms()->size());
      for (int32_t i = 0, n = obj->Prim_terms()->size(); i < n; ++i) {
        Primtermss.set(i, GetId((*obj->Prim_terms())[i], idMap));
      }
    }
  }

  void operator()(const gate *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Gate::Builder builder) const {
    operator()(static_cast<const primitive*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const switch_tran *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Switchtran::Builder builder) const {
    operator()(static_cast<const primitive*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const udp *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Udp::Builder builder) const {
    operator()(static_cast<const primitive*>(obj), serializer, idMap, builder.getBase());
    if (obj->Udp_defn() != nullptr) builder.setUdpdefn(GetId(obj->Udp_defn(), idMap));
  }

  void operator()(const mod_path *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Modpath::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const tchk *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Tchk::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Module_inst() != nullptr) builder.setModuleinst(GetId(obj->Module_inst(), idMap));
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Expr_tchk_terms() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Exprtchktermss = builder.initExprtchkterms(obj->Expr_tchk_terms()->size());
      for (int32_t i = 0, n = obj->Expr_tchk_terms()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Exprtchktermss[i];
        tmp.setIndex(GetId((*obj->Expr_tchk_terms())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Expr_tchk_terms())[i]))->UhdmType()));
      }
    }
    if (obj->Tchk_ref_term() != nullptr) builder.setTchkrefterm(GetId(obj->Tchk_ref_term(), idMap));
    if (obj->Tchk_data_term() != nullptr) builder.setTchkdataterm(GetId(obj->Tchk_data_term(), idMap));
    if (obj->Reg() != nullptr) builder.setReg(GetId(obj->Reg(), idMap));
    builder.setVpiDelay((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDelay()));
    builder.setVpiTchkType(obj->VpiTchkType());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const range *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Range::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSize(obj->VpiSize());
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
  }

  void operator()(const udp_defn *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Udpdefn::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    builder.setVpiSize(obj->VpiSize());
    builder.setVpiProtected(obj->VpiProtected());
    builder.setVpiPrimType(obj->VpiPrimType());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Io_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Iodeclss = builder.initIodecls(obj->Io_decls()->size());
      for (int32_t i = 0, n = obj->Io_decls()->size(); i < n; ++i) {
        Iodeclss.set(i, GetId((*obj->Io_decls())[i], idMap));
      }
    }
    if (obj->Table_entrys() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Tableentryss = builder.initTableentrys(obj->Table_entrys()->size());
      for (int32_t i = 0, n = obj->Table_entrys()->size(); i < n; ++i) {
        Tableentryss.set(i, GetId((*obj->Table_entrys())[i], idMap));
      }
    }
    if (obj->Initial() != nullptr) builder.setInitial(GetId(obj->Initial(), idMap));
  }

  void operator()(const table_entry *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Tableentry::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSize(obj->VpiSize());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const io_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Iodecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDirection(obj->VpiDirection());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiScalar(obj->VpiScalar());
    builder.setVpiSigned(obj->VpiSigned());
    builder.setVpiSize(obj->VpiSize());
    builder.setVpiVector(obj->VpiVector());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
  }

  void operator()(const alias_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Aliasstmt::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const clocking_block *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Clockingblock::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiInputEdge(obj->VpiInputEdge());
    builder.setVpiOutputEdge(obj->VpiOutputEdge());
    if (obj->Input_skew() != nullptr) builder.setInputskew(GetId(obj->Input_skew(), idMap));
    if (obj->Output_skew() != nullptr) builder.setOutputskew(GetId(obj->Output_skew(), idMap));
    if (obj->Clocking_event() != nullptr) builder.setClockingevent(GetId(obj->Clocking_event(), idMap));
    if (obj->Instance() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstance();
      tmp.setIndex(GetId(obj->Instance(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance())->UhdmType()));
    }
    if (obj->Clocking_io_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Clockingiodeclss = builder.initClockingiodecls(obj->Clocking_io_decls()->size());
      for (int32_t i = 0, n = obj->Clocking_io_decls()->size(); i < n; ++i) {
        Clockingiodeclss.set(i, GetId((*obj->Clocking_io_decls())[i], idMap));
      }
    }
    if (obj->Prefix() != nullptr) builder.setPrefix(GetId(obj->Prefix(), idMap));
    if (obj->Actual() != nullptr) builder.setActual(GetId(obj->Actual(), idMap));
  }

  void operator()(const clocking_io_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Clockingiodecl::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDirection(obj->VpiDirection());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiInputEdge(obj->VpiInputEdge());
    builder.setVpiOutputEdge(obj->VpiOutputEdge());
    if (obj->Input_skew() != nullptr) builder.setInputskew(GetId(obj->Input_skew(), idMap));
    if (obj->Output_skew() != nullptr) builder.setOutputskew(GetId(obj->Output_skew(), idMap));
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
  }

  void operator()(const param_assign *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Paramassign::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConnByName(obj->VpiConnByName());
    builder.setVpiOverriden(obj->VpiOverriden());
    if (obj->Rhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRhs();
      tmp.setIndex(GetId(obj->Rhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Rhs())->UhdmType()));
    }
    if (obj->Lhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLhs();
      tmp.setIndex(GetId(obj->Lhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Lhs())->UhdmType()));
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const instance_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Instancearray::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiSize(obj->VpiSize());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Instances() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Instancess = builder.initInstances(obj->Instances()->size());
      for (int32_t i = 0, n = obj->Instances()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Instancess[i];
        tmp.setIndex(GetId((*obj->Instances())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Instances())[i]))->UhdmType()));
      }
    }
    if (obj->Modules() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Moduless = builder.initModules(obj->Modules()->size());
      for (int32_t i = 0, n = obj->Modules()->size(); i < n; ++i) {
        Moduless.set(i, GetId((*obj->Modules())[i], idMap));
      }
    }
    if (obj->Elem_typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getElemtypespec();
      tmp.setIndex(GetId(obj->Elem_typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Elem_typespec())->UhdmType()));
    }
    if (obj->Ports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        Portss.set(i, GetId((*obj->Ports())[i], idMap));
      }
    }
  }

  void operator()(const interface_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Interfacearray::Builder builder) const {
    operator()(static_cast<const instance_array*>(obj), serializer, idMap, builder.getBase());
    if (obj->Param_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Paramassignss = builder.initParamassigns(obj->Param_assigns()->size());
      for (int32_t i = 0, n = obj->Param_assigns()->size(); i < n; ++i) {
        Paramassignss.set(i, GetId((*obj->Param_assigns())[i], idMap));
      }
    }
  }

  void operator()(const program_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Programarray::Builder builder) const {
    operator()(static_cast<const instance_array*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const module_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Modulearray::Builder builder) const {
    operator()(static_cast<const instance_array*>(obj), serializer, idMap, builder.getBase());
    if (obj->Param_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Paramassignss = builder.initParamassigns(obj->Param_assigns()->size());
      for (int32_t i = 0, n = obj->Param_assigns()->size(); i < n; ++i) {
        Paramassignss.set(i, GetId((*obj->Param_assigns())[i], idMap));
      }
    }
  }

  void operator()(const primitive_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Primitivearray::Builder builder) const {
    operator()(static_cast<const instance_array*>(obj), serializer, idMap, builder.getBase());
    if (obj->Delay() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getDelay();
      tmp.setIndex(GetId(obj->Delay(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Delay())->UhdmType()));
    }
    if (obj->Primitives() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Primitivess = builder.initPrimitives(obj->Primitives()->size());
      for (int32_t i = 0, n = obj->Primitives()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Primitivess[i];
        tmp.setIndex(GetId((*obj->Primitives())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Primitives())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const gate_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Gatearray::Builder builder) const {
    operator()(static_cast<const primitive_array*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const switch_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Switcharray::Builder builder) const {
    operator()(static_cast<const primitive_array*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const udp_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Udparray::Builder builder) const {
    operator()(static_cast<const primitive_array*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Typespec::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Typedef_alias() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypedefalias();
      tmp.setIndex(GetId(obj->Typedef_alias(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typedef_alias())->UhdmType()));
    }
    if (obj->Instance() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstance();
      tmp.setIndex(GetId(obj->Instance(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance())->UhdmType()));
    }
  }

  void operator()(const net_drivers *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Netdrivers::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const net_loads *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Netloads::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const prim_term *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Primterm::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDirection(obj->VpiDirection());
    builder.setVpiTermIndex(obj->VpiTermIndex());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
  }

  void operator()(const path_term *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Pathterm::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const tchk_term *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Tchkterm::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Condition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getCondition();
      tmp.setIndex(GetId(obj->Condition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Condition())->UhdmType()));
    }
    builder.setVpiEdge(obj->VpiEdge());
  }

  void operator()(const nets *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Nets::Builder builder) const {
    operator()(static_cast<const simple_expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiArrayMember(obj->VpiArrayMember());
    builder.setVpiConstantSelect(obj->VpiConstantSelect());
    builder.setVpiExpanded(obj->VpiExpanded());
    builder.setVpiImplicitDecl(obj->VpiImplicitDecl());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiNetDeclAssign(obj->VpiNetDeclAssign());
    builder.setVpiNetType(obj->VpiNetType());
    builder.setVpiResolvedNetType(obj->VpiResolvedNetType());
    builder.setVpiScalar(obj->VpiScalar());
    builder.setVpiExplicitScalared(obj->VpiExplicitScalared());
    builder.setVpiSigned(obj->VpiSigned());
    builder.setVpiStrength0(obj->VpiStrength0());
    builder.setVpiStrength1(obj->VpiStrength1());
    builder.setVpiChargeStrength(obj->VpiChargeStrength());
    builder.setVpiVector(obj->VpiVector());
    builder.setVpiExplicitVectored(obj->VpiExplicitVectored());
    builder.setVpiStructUnionMember(obj->VpiStructUnionMember());
    if (obj->Ports() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Portss[i];
        tmp.setIndex(GetId((*obj->Ports())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Ports())[i]))->UhdmType()));
      }
    }
    if (obj->Drivers() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Driverss = builder.initDrivers(obj->Drivers()->size());
      for (int32_t i = 0, n = obj->Drivers()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Driverss[i];
        tmp.setIndex(GetId((*obj->Drivers())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Drivers())[i]))->UhdmType()));
      }
    }
    if (obj->Loads() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Loadss = builder.initLoads(obj->Loads()->size());
      for (int32_t i = 0, n = obj->Loads()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Loadss[i];
        tmp.setIndex(GetId((*obj->Loads())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Loads())[i]))->UhdmType()));
      }
    }
    if (obj->Local_drivers() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Localdriverss = builder.initLocaldrivers(obj->Local_drivers()->size());
      for (int32_t i = 0, n = obj->Local_drivers()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Localdriverss[i];
        tmp.setIndex(GetId((*obj->Local_drivers())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Local_drivers())[i]))->UhdmType()));
      }
    }
    if (obj->Local_loads() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Localloadss = builder.initLocalloads(obj->Local_loads()->size());
      for (int32_t i = 0, n = obj->Local_loads()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Localloadss[i];
        tmp.setIndex(GetId((*obj->Local_loads())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Local_loads())[i]))->UhdmType()));
      }
    }
    if (obj->Prim_terms() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Primtermss = builder.initPrimterms(obj->Prim_terms()->size());
      for (int32_t i = 0, n = obj->Prim_terms()->size(); i < n; ++i) {
        Primtermss.set(i, GetId((*obj->Prim_terms())[i], idMap));
      }
    }
    if (obj->Cont_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignss = builder.initContassigns(obj->Cont_assigns()->size());
      for (int32_t i = 0, n = obj->Cont_assigns()->size(); i < n; ++i) {
        Contassignss.set(i, GetId((*obj->Cont_assigns())[i], idMap));
      }
    }
    if (obj->Path_terms() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Pathtermss = builder.initPathterms(obj->Path_terms()->size());
      for (int32_t i = 0, n = obj->Path_terms()->size(); i < n; ++i) {
        Pathtermss.set(i, GetId((*obj->Path_terms())[i], idMap));
      }
    }
    if (obj->Tchk_terms() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Tchktermss = builder.initTchkterms(obj->Tchk_terms()->size());
      for (int32_t i = 0, n = obj->Tchk_terms()->size(); i < n; ++i) {
        Tchktermss.set(i, GetId((*obj->Tchk_terms())[i], idMap));
      }
    }
    if (obj->Sim_net() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getSimnet();
      tmp.setIndex(GetId(obj->Sim_net(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Sim_net())->UhdmType()));
    }
    if (obj->Module_inst() != nullptr) builder.setModuleinst(GetId(obj->Module_inst(), idMap));
  }

  void operator()(const net_bit *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Netbit::Builder builder) const {
    operator()(static_cast<const nets*>(obj), serializer, idMap, builder.getBase());
    if (obj->Exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Exprss = builder.initExprs(obj->Exprs()->size());
      for (int32_t i = 0, n = obj->Exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Exprss[i];
        tmp.setIndex(GetId((*obj->Exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Net::Builder builder) const {
    operator()(static_cast<const nets*>(obj), serializer, idMap, builder.getBase());
    if (obj->Net_bits() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Netbitss = builder.initNetbits(obj->Net_bits()->size());
      for (int32_t i = 0, n = obj->Net_bits()->size(); i < n; ++i) {
        Netbitss.set(i, GetId((*obj->Net_bits())[i], idMap));
      }
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Exprss = builder.initExprs(obj->Exprs()->size());
      for (int32_t i = 0, n = obj->Exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Exprss[i];
        tmp.setIndex(GetId((*obj->Exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const struct_net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Structnet::Builder builder) const {
    operator()(static_cast<const net*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPackedArrayMember(obj->VpiPackedArrayMember());
    if (obj->Nets() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Netss = builder.initNets(obj->Nets()->size());
      for (int32_t i = 0, n = obj->Nets()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Netss[i];
        tmp.setIndex(GetId((*obj->Nets())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Nets())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const enum_net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Enumnet::Builder builder) const {
    operator()(static_cast<const net*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPackedArrayMember(obj->VpiPackedArrayMember());
  }

  void operator()(const integer_net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Integernet::Builder builder) const {
    operator()(static_cast<const net*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const time_net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Timenet::Builder builder) const {
    operator()(static_cast<const net*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const logic_net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Logicnet::Builder builder) const {
    operator()(static_cast<const net*>(obj), serializer, idMap, builder.getBase());
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
  }

  void operator()(const array_net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Arraynet::Builder builder) const {
    operator()(static_cast<const nets*>(obj), serializer, idMap, builder.getBase());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Nets() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Netss = builder.initNets(obj->Nets()->size());
      for (int32_t i = 0, n = obj->Nets()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Netss[i];
        tmp.setIndex(GetId((*obj->Nets())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Nets())[i]))->UhdmType()));
      }
    }
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const packed_array_net *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Packedarraynet::Builder builder) const {
    operator()(static_cast<const net*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPackedArrayMember(obj->VpiPackedArrayMember());
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Elements() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Elementss = builder.initElements(obj->Elements()->size());
      for (int32_t i = 0, n = obj->Elements()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Elementss[i];
        tmp.setIndex(GetId((*obj->Elements())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Elements())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const event_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Eventtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const named_event *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Namedevent::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiArrayMember(obj->VpiArrayMember());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiAutomatic(obj->VpiAutomatic());
    builder.setVpiAllocScheme(obj->VpiAllocScheme());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    if (obj->Event_typespec() != nullptr) builder.setEventtypespec(GetId(obj->Event_typespec(), idMap));
    if (obj->Threads() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Threadss = builder.initThreads(obj->Threads()->size());
      for (int32_t i = 0, n = obj->Threads()->size(); i < n; ++i) {
        Threadss.set(i, GetId((*obj->Threads())[i], idMap));
      }
    }
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const named_event_array *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Namedeventarray::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const parameter *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Parameter::Builder builder) const {
    operator()(static_cast<const simple_expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiConstType(obj->VpiConstType());
    builder.setVpiSigned(obj->VpiSigned());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_range() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftrange();
      tmp.setIndex(GetId(obj->Left_range(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_range())->UhdmType()));
    }
    if (obj->Right_range() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightrange();
      tmp.setIndex(GetId(obj->Right_range(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_range())->UhdmType()));
    }
    builder.setVpiLocalParam(obj->VpiLocalParam());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiImported((RawSymbolId)serializer->symbolMaker.Make(obj->VpiImported()));
  }

  void operator()(const def_param *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Defparam::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Rhs() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRhs();
      tmp.setIndex(GetId(obj->Rhs(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Rhs())->UhdmType()));
    }
    if (obj->Lhs() != nullptr) builder.setLhs(GetId(obj->Lhs(), idMap));
  }

  void operator()(const spec_param *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Specparam::Builder builder) const {
    operator()(static_cast<const simple_expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const class_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Classtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiClassType(obj->VpiClassType());
    builder.setVpiAutomatic(obj->VpiAutomatic());
    if (obj->Extends() != nullptr) builder.setExtends(GetId(obj->Extends(), idMap));
    if (obj->Variables() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Variabless = builder.initVariables(obj->Variables()->size());
      for (int32_t i = 0, n = obj->Variables()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Variabless[i];
        tmp.setIndex(GetId((*obj->Variables())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Variables())[i]))->UhdmType()));
      }
    }
    if (obj->Task_funcs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Taskfuncss = builder.initTaskfuncs(obj->Task_funcs()->size());
      for (int32_t i = 0, n = obj->Task_funcs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Taskfuncss[i];
        tmp.setIndex(GetId((*obj->Task_funcs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Task_funcs())[i]))->UhdmType()));
      }
    }
    if (obj->Constraints() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Constraintss = builder.initConstraints(obj->Constraints()->size());
      for (int32_t i = 0, n = obj->Constraints()->size(); i < n; ++i) {
        Constraintss.set(i, GetId((*obj->Constraints())[i], idMap));
      }
    }
    if (obj->Parameters() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Parameterss = builder.initParameters(obj->Parameters()->size());
      for (int32_t i = 0, n = obj->Parameters()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Parameterss[i];
        tmp.setIndex(GetId((*obj->Parameters())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Parameters())[i]))->UhdmType()));
      }
    }
    if (obj->Param_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Paramassignss = builder.initParamassigns(obj->Param_assigns()->size());
      for (int32_t i = 0, n = obj->Param_assigns()->size(); i < n; ++i) {
        Paramassignss.set(i, GetId((*obj->Param_assigns())[i], idMap));
      }
    }
    if (obj->Virtual_interface_vars() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Virtualinterfacevarss = builder.initVirtualinterfacevars(obj->Virtual_interface_vars()->size());
      for (int32_t i = 0, n = obj->Virtual_interface_vars()->size(); i < n; ++i) {
        Virtualinterfacevarss.set(i, GetId((*obj->Virtual_interface_vars())[i], idMap));
      }
    }
    if (obj->Named_events() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Namedeventss = builder.initNamedevents(obj->Named_events()->size());
      for (int32_t i = 0, n = obj->Named_events()->size(); i < n; ++i) {
        Namedeventss.set(i, GetId((*obj->Named_events())[i], idMap));
      }
    }
    if (obj->Named_event_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Namedeventarrayss = builder.initNamedeventarrays(obj->Named_event_arrays()->size());
      for (int32_t i = 0, n = obj->Named_event_arrays()->size(); i < n; ++i) {
        Namedeventarrayss.set(i, GetId((*obj->Named_event_arrays())[i], idMap));
      }
    }
    if (obj->Scopes() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Scopess = builder.initScopes(obj->Scopes()->size());
      for (int32_t i = 0, n = obj->Scopes()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Scopess[i];
        tmp.setIndex(GetId((*obj->Scopes())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Scopes())[i]))->UhdmType()));
      }
    }
    if (obj->Class_defn() != nullptr) builder.setClassdefn(GetId(obj->Class_defn(), idMap));
  }

  void operator()(const extends *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Extends::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Class_typespec() != nullptr) builder.setClasstypespec(GetId(obj->Class_typespec(), idMap));
    if (obj->Arguments() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Argumentss = builder.initArguments(obj->Arguments()->size());
      for (int32_t i = 0, n = obj->Arguments()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Argumentss[i];
        tmp.setIndex(GetId((*obj->Arguments())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Arguments())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const class_defn *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Classdefn::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiVirtual(obj->VpiVirtual());
    builder.setVpiAutomatic(obj->VpiAutomatic());
    if (obj->Extends() != nullptr) builder.setExtends(GetId(obj->Extends(), idMap));
    if (obj->Task_funcs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Taskfuncss = builder.initTaskfuncs(obj->Task_funcs()->size());
      for (int32_t i = 0, n = obj->Task_funcs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Taskfuncss[i];
        tmp.setIndex(GetId((*obj->Task_funcs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Task_funcs())[i]))->UhdmType()));
      }
    }
    if (obj->Constraints() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Constraintss = builder.initConstraints(obj->Constraints()->size());
      for (int32_t i = 0, n = obj->Constraints()->size(); i < n; ++i) {
        Constraintss.set(i, GetId((*obj->Constraints())[i], idMap));
      }
    }
    if (obj->Deriveds() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Derivedss = builder.initDeriveds(obj->Deriveds()->size());
      for (int32_t i = 0, n = obj->Deriveds()->size(); i < n; ++i) {
        Derivedss.set(i, GetId((*obj->Deriveds())[i], idMap));
      }
    }
    if (obj->Class_typespecs() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Classtypespecss = builder.initClasstypespecs(obj->Class_typespecs()->size());
      for (int32_t i = 0, n = obj->Class_typespecs()->size(); i < n; ++i) {
        Classtypespecss.set(i, GetId((*obj->Class_typespecs())[i], idMap));
      }
    }
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const class_obj *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Classobj::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiObjId(obj->VpiObjId());
    if (obj->Class_typespec() != nullptr) builder.setClasstypespec(GetId(obj->Class_typespec(), idMap));
    if (obj->Threads() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Threadss = builder.initThreads(obj->Threads()->size());
      for (int32_t i = 0, n = obj->Threads()->size(); i < n; ++i) {
        Threadss.set(i, GetId((*obj->Threads())[i], idMap));
      }
    }
    if (obj->Messages() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Messagess = builder.initMessages(obj->Messages()->size());
      for (int32_t i = 0, n = obj->Messages()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Messagess[i];
        tmp.setIndex(GetId((*obj->Messages())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Messages())[i]))->UhdmType()));
      }
    }
    if (obj->Task_funcs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Taskfuncss = builder.initTaskfuncs(obj->Task_funcs()->size());
      for (int32_t i = 0, n = obj->Task_funcs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Taskfuncss[i];
        tmp.setIndex(GetId((*obj->Task_funcs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Task_funcs())[i]))->UhdmType()));
      }
    }
    if (obj->Constraints() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Constraintss = builder.initConstraints(obj->Constraints()->size());
      for (int32_t i = 0, n = obj->Constraints()->size(); i < n; ++i) {
        Constraintss.set(i, GetId((*obj->Constraints())[i], idMap));
      }
    }
  }

  void operator()(const class_var *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Classvar::Builder builder) const {
    operator()(static_cast<const variables*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiObjId(obj->VpiObjId());
    if (obj->Class_obj() != nullptr) builder.setClassobj(GetId(obj->Class_obj(), idMap));
  }

  void operator()(const instance *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Instance::Builder builder) const {
    operator()(static_cast<const scope*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    builder.setVpiArrayMember(obj->VpiArrayMember());
    builder.setVpiCellInstance(obj->VpiCellInstance());
    builder.setVpiDefNetType(obj->VpiDefNetType());
    builder.setVpiDefFile((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefFile()));
    builder.setVpiDefLineNo(obj->VpiDefLineNo());
    builder.setVpiDefDelayMode(obj->VpiDefDelayMode());
    builder.setVpiProtected(obj->VpiProtected());
    builder.setVpiTimePrecision(obj->VpiTimePrecision());
    builder.setVpiTimeUnit(obj->VpiTimeUnit());
    builder.setVpiUnconnDrive(obj->VpiUnconnDrive());
    builder.setVpiLibrary((RawSymbolId)serializer->symbolMaker.Make(obj->VpiLibrary()));
    builder.setVpiCell((RawSymbolId)serializer->symbolMaker.Make(obj->VpiCell()));
    builder.setVpiConfig((RawSymbolId)serializer->symbolMaker.Make(obj->VpiConfig()));
    builder.setVpiAutomatic(obj->VpiAutomatic());
    builder.setVpiTop(obj->VpiTop());
    if (obj->Programs() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Programss = builder.initPrograms(obj->Programs()->size());
      for (int32_t i = 0, n = obj->Programs()->size(); i < n; ++i) {
        Programss.set(i, GetId((*obj->Programs())[i], idMap));
      }
    }
    if (obj->Program_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Programarrayss = builder.initProgramarrays(obj->Program_arrays()->size());
      for (int32_t i = 0, n = obj->Program_arrays()->size(); i < n; ++i) {
        Programarrayss.set(i, GetId((*obj->Program_arrays())[i], idMap));
      }
    }
    if (obj->Class_defns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Classdefnss = builder.initClassdefns(obj->Class_defns()->size());
      for (int32_t i = 0, n = obj->Class_defns()->size(); i < n; ++i) {
        Classdefnss.set(i, GetId((*obj->Class_defns())[i], idMap));
      }
    }
    if (obj->Task_funcs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Taskfuncss = builder.initTaskfuncs(obj->Task_funcs()->size());
      for (int32_t i = 0, n = obj->Task_funcs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Taskfuncss[i];
        tmp.setIndex(GetId((*obj->Task_funcs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Task_funcs())[i]))->UhdmType()));
      }
    }
    if (obj->Nets() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Netss = builder.initNets(obj->Nets()->size());
      for (int32_t i = 0, n = obj->Nets()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Netss[i];
        tmp.setIndex(GetId((*obj->Nets())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Nets())[i]))->UhdmType()));
      }
    }
    if (obj->Array_nets() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Arraynetss = builder.initArraynets(obj->Array_nets()->size());
      for (int32_t i = 0, n = obj->Array_nets()->size(); i < n; ++i) {
        Arraynetss.set(i, GetId((*obj->Array_nets())[i], idMap));
      }
    }
    if (obj->Spec_params() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Specparamss = builder.initSpecparams(obj->Spec_params()->size());
      for (int32_t i = 0, n = obj->Spec_params()->size(); i < n; ++i) {
        Specparamss.set(i, GetId((*obj->Spec_params())[i], idMap));
      }
    }
    if (obj->Assertions() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Assertionss = builder.initAssertions(obj->Assertions()->size());
      for (int32_t i = 0, n = obj->Assertions()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Assertionss[i];
        tmp.setIndex(GetId((*obj->Assertions())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Assertions())[i]))->UhdmType()));
      }
    }
    if (obj->Module_inst() != nullptr) builder.setModuleinst(GetId(obj->Module_inst(), idMap));
    if (obj->Instance() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstance();
      tmp.setIndex(GetId(obj->Instance(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance())->UhdmType()));
    }
  }

  void operator()(const interface_inst *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Interfaceinst::Builder builder) const {
    operator()(static_cast<const instance*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIndex(obj->VpiIndex());
    if (obj->Interface_tf_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacetfdeclss = builder.initInterfacetfdecls(obj->Interface_tf_decls()->size());
      for (int32_t i = 0, n = obj->Interface_tf_decls()->size(); i < n; ++i) {
        Interfacetfdeclss.set(i, GetId((*obj->Interface_tf_decls())[i], idMap));
      }
    }
    if (obj->Modports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Modportss = builder.initModports(obj->Modports()->size());
      for (int32_t i = 0, n = obj->Modports()->size(); i < n; ++i) {
        Modportss.set(i, GetId((*obj->Modports())[i], idMap));
      }
    }
    if (obj->Global_clocking() != nullptr) builder.setGlobalclocking(GetId(obj->Global_clocking(), idMap));
    if (obj->Default_clocking() != nullptr) builder.setDefaultclocking(GetId(obj->Default_clocking(), idMap));
    if (obj->Expr_dist() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprdist();
      tmp.setIndex(GetId(obj->Expr_dist(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_dist())->UhdmType()));
    }
    if (obj->Instance_array() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstancearray();
      tmp.setIndex(GetId(obj->Instance_array(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance_array())->UhdmType()));
    }
    if (obj->Mod_paths() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Modpathss = builder.initModpaths(obj->Mod_paths()->size());
      for (int32_t i = 0, n = obj->Mod_paths()->size(); i < n; ++i) {
        Modpathss.set(i, GetId((*obj->Mod_paths())[i], idMap));
      }
    }
    if (obj->Cont_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignss = builder.initContassigns(obj->Cont_assigns()->size());
      for (int32_t i = 0, n = obj->Cont_assigns()->size(); i < n; ++i) {
        Contassignss.set(i, GetId((*obj->Cont_assigns())[i], idMap));
      }
    }
    if (obj->Clocking_blocks() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Clockingblockss = builder.initClockingblocks(obj->Clocking_blocks()->size());
      for (int32_t i = 0, n = obj->Clocking_blocks()->size(); i < n; ++i) {
        Clockingblockss.set(i, GetId((*obj->Clocking_blocks())[i], idMap));
      }
    }
    if (obj->Interfaces() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacess = builder.initInterfaces(obj->Interfaces()->size());
      for (int32_t i = 0, n = obj->Interfaces()->size(); i < n; ++i) {
        Interfacess.set(i, GetId((*obj->Interfaces())[i], idMap));
      }
    }
    if (obj->Interface_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacearrayss = builder.initInterfacearrays(obj->Interface_arrays()->size());
      for (int32_t i = 0, n = obj->Interface_arrays()->size(); i < n; ++i) {
        Interfacearrayss.set(i, GetId((*obj->Interface_arrays())[i], idMap));
      }
    }
    if (obj->Process() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Processs = builder.initProcess(obj->Process()->size());
      for (int32_t i = 0, n = obj->Process()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Processs[i];
        tmp.setIndex(GetId((*obj->Process())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Process())[i]))->UhdmType()));
      }
    }
    if (obj->Ports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        Portss.set(i, GetId((*obj->Ports())[i], idMap));
      }
    }
    if (obj->Gen_scope_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Genscopearrayss = builder.initGenscopearrays(obj->Gen_scope_arrays()->size());
      for (int32_t i = 0, n = obj->Gen_scope_arrays()->size(); i < n; ++i) {
        Genscopearrayss.set(i, GetId((*obj->Gen_scope_arrays())[i], idMap));
      }
    }
    if (obj->Elab_tasks() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Elabtaskss = builder.initElabtasks(obj->Elab_tasks()->size());
      for (int32_t i = 0, n = obj->Elab_tasks()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Elabtaskss[i];
        tmp.setIndex(GetId((*obj->Elab_tasks())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Elab_tasks())[i]))->UhdmType()));
      }
    }
    if (obj->Gen_stmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Genstmtss = builder.initGenstmts(obj->Gen_stmts()->size());
      for (int32_t i = 0, n = obj->Gen_stmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Genstmtss[i];
        tmp.setIndex(GetId((*obj->Gen_stmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Gen_stmts())[i]))->UhdmType()));
      }
    }
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const program *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Program::Builder builder) const {
    operator()(static_cast<const instance*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIndex(obj->VpiIndex());
    if (obj->Default_clocking() != nullptr) builder.setDefaultclocking(GetId(obj->Default_clocking(), idMap));
    if (obj->Instance_array() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstancearray();
      tmp.setIndex(GetId(obj->Instance_array(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance_array())->UhdmType()));
    }
    if (obj->Interfaces() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacess = builder.initInterfaces(obj->Interfaces()->size());
      for (int32_t i = 0, n = obj->Interfaces()->size(); i < n; ++i) {
        Interfacess.set(i, GetId((*obj->Interfaces())[i], idMap));
      }
    }
    if (obj->Expr_dist() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprdist();
      tmp.setIndex(GetId(obj->Expr_dist(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_dist())->UhdmType()));
    }
    if (obj->Interface_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacearrayss = builder.initInterfacearrays(obj->Interface_arrays()->size());
      for (int32_t i = 0, n = obj->Interface_arrays()->size(); i < n; ++i) {
        Interfacearrayss.set(i, GetId((*obj->Interface_arrays())[i], idMap));
      }
    }
    if (obj->Process() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Processs = builder.initProcess(obj->Process()->size());
      for (int32_t i = 0, n = obj->Process()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Processs[i];
        tmp.setIndex(GetId((*obj->Process())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Process())[i]))->UhdmType()));
      }
    }
    if (obj->Cont_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignss = builder.initContassigns(obj->Cont_assigns()->size());
      for (int32_t i = 0, n = obj->Cont_assigns()->size(); i < n; ++i) {
        Contassignss.set(i, GetId((*obj->Cont_assigns())[i], idMap));
      }
    }
    if (obj->Clocking_blocks() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Clockingblockss = builder.initClockingblocks(obj->Clocking_blocks()->size());
      for (int32_t i = 0, n = obj->Clocking_blocks()->size(); i < n; ++i) {
        Clockingblockss.set(i, GetId((*obj->Clocking_blocks())[i], idMap));
      }
    }
    if (obj->Ports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        Portss.set(i, GetId((*obj->Ports())[i], idMap));
      }
    }
    if (obj->Gen_scope_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Genscopearrayss = builder.initGenscopearrays(obj->Gen_scope_arrays()->size());
      for (int32_t i = 0, n = obj->Gen_scope_arrays()->size(); i < n; ++i) {
        Genscopearrayss.set(i, GetId((*obj->Gen_scope_arrays())[i], idMap));
      }
    }
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const package *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Package::Builder builder) const {
    operator()(static_cast<const instance*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiUnit(obj->VpiUnit());
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const module_inst *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Moduleinst::Builder builder) const {
    operator()(static_cast<const instance*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiIndex(obj->VpiIndex());
    builder.setVpiTopModule(obj->VpiTopModule());
    builder.setVpiDefDecayTime(obj->VpiDefDecayTime());
    if (obj->Global_clocking() != nullptr) builder.setGlobalclocking(GetId(obj->Global_clocking(), idMap));
    if (obj->Default_clocking() != nullptr) builder.setDefaultclocking(GetId(obj->Default_clocking(), idMap));
    if (obj->Expr_dist() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExprdist();
      tmp.setIndex(GetId(obj->Expr_dist(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr_dist())->UhdmType()));
    }
    if (obj->Module_array() != nullptr) builder.setModulearray(GetId(obj->Module_array(), idMap));
    if (obj->Instance_array() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getInstancearray();
      tmp.setIndex(GetId(obj->Instance_array(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Instance_array())->UhdmType()));
    }
    if (obj->Ports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        Portss.set(i, GetId((*obj->Ports())[i], idMap));
      }
    }
    if (obj->Interfaces() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacess = builder.initInterfaces(obj->Interfaces()->size());
      for (int32_t i = 0, n = obj->Interfaces()->size(); i < n; ++i) {
        Interfacess.set(i, GetId((*obj->Interfaces())[i], idMap));
      }
    }
    if (obj->Interface_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Interfacearrayss = builder.initInterfacearrays(obj->Interface_arrays()->size());
      for (int32_t i = 0, n = obj->Interface_arrays()->size(); i < n; ++i) {
        Interfacearrayss.set(i, GetId((*obj->Interface_arrays())[i], idMap));
      }
    }
    if (obj->Process() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Processs = builder.initProcess(obj->Process()->size());
      for (int32_t i = 0, n = obj->Process()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Processs[i];
        tmp.setIndex(GetId((*obj->Process())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Process())[i]))->UhdmType()));
      }
    }
    if (obj->Modules() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Moduless = builder.initModules(obj->Modules()->size());
      for (int32_t i = 0, n = obj->Modules()->size(); i < n; ++i) {
        Moduless.set(i, GetId((*obj->Modules())[i], idMap));
      }
    }
    if (obj->Module_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Modulearrayss = builder.initModulearrays(obj->Module_arrays()->size());
      for (int32_t i = 0, n = obj->Module_arrays()->size(); i < n; ++i) {
        Modulearrayss.set(i, GetId((*obj->Module_arrays())[i], idMap));
      }
    }
    if (obj->Gen_scope_arrays() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Genscopearrayss = builder.initGenscopearrays(obj->Gen_scope_arrays()->size());
      for (int32_t i = 0, n = obj->Gen_scope_arrays()->size(); i < n; ++i) {
        Genscopearrayss.set(i, GetId((*obj->Gen_scope_arrays())[i], idMap));
      }
    }
    if (obj->Cont_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignss = builder.initContassigns(obj->Cont_assigns()->size());
      for (int32_t i = 0, n = obj->Cont_assigns()->size(); i < n; ++i) {
        Contassignss.set(i, GetId((*obj->Cont_assigns())[i], idMap));
      }
    }
    if (obj->Primitives() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Primitivess = builder.initPrimitives(obj->Primitives()->size());
      for (int32_t i = 0, n = obj->Primitives()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Primitivess[i];
        tmp.setIndex(GetId((*obj->Primitives())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Primitives())[i]))->UhdmType()));
      }
    }
    if (obj->Primitive_arrays() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Primitivearrayss = builder.initPrimitivearrays(obj->Primitive_arrays()->size());
      for (int32_t i = 0, n = obj->Primitive_arrays()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Primitivearrayss[i];
        tmp.setIndex(GetId((*obj->Primitive_arrays())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Primitive_arrays())[i]))->UhdmType()));
      }
    }
    if (obj->Mod_paths() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Modpathss = builder.initModpaths(obj->Mod_paths()->size());
      for (int32_t i = 0, n = obj->Mod_paths()->size(); i < n; ++i) {
        Modpathss.set(i, GetId((*obj->Mod_paths())[i], idMap));
      }
    }
    if (obj->Tchks() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Tchkss = builder.initTchks(obj->Tchks()->size());
      for (int32_t i = 0, n = obj->Tchks()->size(); i < n; ++i) {
        Tchkss.set(i, GetId((*obj->Tchks())[i], idMap));
      }
    }
    if (obj->Def_params() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Defparamss = builder.initDefparams(obj->Def_params()->size());
      for (int32_t i = 0, n = obj->Def_params()->size(); i < n; ++i) {
        Defparamss.set(i, GetId((*obj->Def_params())[i], idMap));
      }
    }
    if (obj->Io_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Iodeclss = builder.initIodecls(obj->Io_decls()->size());
      for (int32_t i = 0, n = obj->Io_decls()->size(); i < n; ++i) {
        Iodeclss.set(i, GetId((*obj->Io_decls())[i], idMap));
      }
    }
    if (obj->Alias_stmts() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Aliasstmtss = builder.initAliasstmts(obj->Alias_stmts()->size());
      for (int32_t i = 0, n = obj->Alias_stmts()->size(); i < n; ++i) {
        Aliasstmtss.set(i, GetId((*obj->Alias_stmts())[i], idMap));
      }
    }
    if (obj->Clocking_blocks() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Clockingblockss = builder.initClockingblocks(obj->Clocking_blocks()->size());
      for (int32_t i = 0, n = obj->Clocking_blocks()->size(); i < n; ++i) {
        Clockingblockss.set(i, GetId((*obj->Clocking_blocks())[i], idMap));
      }
    }
    if (obj->Elab_tasks() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Elabtaskss = builder.initElabtasks(obj->Elab_tasks()->size());
      for (int32_t i = 0, n = obj->Elab_tasks()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Elabtaskss[i];
        tmp.setIndex(GetId((*obj->Elab_tasks())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Elab_tasks())[i]))->UhdmType()));
      }
    }
    if (obj->Ref_modules() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Refmoduless = builder.initRefmodules(obj->Ref_modules()->size());
      for (int32_t i = 0, n = obj->Ref_modules()->size(); i < n; ++i) {
        Refmoduless.set(i, GetId((*obj->Ref_modules())[i], idMap));
      }
    }
    if (obj->Gen_stmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Genstmtss = builder.initGenstmts(obj->Gen_stmts()->size());
      for (int32_t i = 0, n = obj->Gen_stmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Genstmtss[i];
        tmp.setIndex(GetId((*obj->Gen_stmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Gen_stmts())[i]))->UhdmType()));
      }
    }
    builder.setVpiEndLabel((RawSymbolId)serializer->symbolMaker.Make(obj->VpiEndLabel()));
  }

  void operator()(const checker_decl *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Checkerdecl::Builder builder) const {
    operator()(static_cast<const instance*>(obj), serializer, idMap, builder.getBase());
    if (obj->Default_clocking() != nullptr) builder.setDefaultclocking(GetId(obj->Default_clocking(), idMap));
    if (obj->Process() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Processs = builder.initProcess(obj->Process()->size());
      for (int32_t i = 0, n = obj->Process()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Processs[i];
        tmp.setIndex(GetId((*obj->Process())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Process())[i]))->UhdmType()));
      }
    }
    if (obj->Cont_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Contassignss = builder.initContassigns(obj->Cont_assigns()->size());
      for (int32_t i = 0, n = obj->Cont_assigns()->size(); i < n; ++i) {
        Contassignss.set(i, GetId((*obj->Cont_assigns())[i], idMap));
      }
    }
    if (obj->Ports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        Portss.set(i, GetId((*obj->Ports())[i], idMap));
      }
    }
  }

  void operator()(const checker_inst *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Checkerinst::Builder builder) const {
    operator()(static_cast<const instance*>(obj), serializer, idMap, builder.getBase());
    if (obj->Ports() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Portss = builder.initPorts(obj->Ports()->size());
      for (int32_t i = 0, n = obj->Ports()->size(); i < n; ++i) {
        Portss.set(i, GetId((*obj->Ports())[i], idMap));
      }
    }
  }

  void operator()(const short_real_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Shortrealtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    if (obj->Resolution_func() != nullptr) builder.setResolutionfunc(GetId(obj->Resolution_func(), idMap));
  }

  void operator()(const real_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Realtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    if (obj->Resolution_func() != nullptr) builder.setResolutionfunc(GetId(obj->Resolution_func(), idMap));
  }

  void operator()(const byte_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Bytetypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSigned(obj->VpiSigned());
  }

  void operator()(const short_int_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Shortinttypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSigned(obj->VpiSigned());
  }

  void operator()(const int_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Inttypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Cast_to_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getCasttoexpr();
      tmp.setIndex(GetId(obj->Cast_to_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Cast_to_expr())->UhdmType()));
    }
    builder.setVpiSigned(obj->VpiSigned());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
  }

  void operator()(const long_int_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Longinttypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSigned(obj->VpiSigned());
  }

  void operator()(const integer_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Integertypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    builder.setVpiSigned(obj->VpiSigned());
  }

  void operator()(const time_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Timetypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSigned(obj->VpiSigned());
  }

  void operator()(const enum_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Enumtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    if (obj->Base_typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getBasetypespec();
      tmp.setIndex(GetId(obj->Base_typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Base_typespec())->UhdmType()));
    }
    if (obj->Enum_consts() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Enumconstss = builder.initEnumconsts(obj->Enum_consts()->size());
      for (int32_t i = 0, n = obj->Enum_consts()->size(); i < n; ++i) {
        Enumconstss.set(i, GetId((*obj->Enum_consts())[i], idMap));
      }
    }
  }

  void operator()(const string_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Stringtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const chandle_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Chandletypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const module_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Moduletypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const struct_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Structtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPacked(obj->VpiPacked());
    if (obj->Members() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Memberss = builder.initMembers(obj->Members()->size());
      for (int32_t i = 0, n = obj->Members()->size(); i < n; ++i) {
        Memberss.set(i, GetId((*obj->Members())[i], idMap));
      }
    }
    if (obj->Resolution_func() != nullptr) builder.setResolutionfunc(GetId(obj->Resolution_func(), idMap));
  }

  void operator()(const union_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Uniontypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPacked(obj->VpiPacked());
    builder.setVpiTagged(obj->VpiTagged());
    if (obj->Members() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Memberss = builder.initMembers(obj->Members()->size());
      for (int32_t i = 0, n = obj->Members()->size(); i < n; ++i) {
        Memberss.set(i, GetId((*obj->Members())[i], idMap));
      }
    }
  }

  void operator()(const logic_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Logictypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiVector(obj->VpiVector());
    if (obj->Elem_typespec() != nullptr) builder.setElemtypespec(GetId(obj->Elem_typespec(), idMap));
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Index_typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getIndextypespec();
      tmp.setIndex(GetId(obj->Index_typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Index_typespec())->UhdmType()));
    }
    builder.setVpiSigned(obj->VpiSigned());
    if (obj->Resolution_func() != nullptr) builder.setResolutionfunc(GetId(obj->Resolution_func(), idMap));
  }

  void operator()(const packed_array_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Packedarraytypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiVector(obj->VpiVector());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Elem_typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getElemtypespec();
      tmp.setIndex(GetId(obj->Elem_typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Elem_typespec())->UhdmType()));
    }
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
    if (obj->Resolution_func() != nullptr) builder.setResolutionfunc(GetId(obj->Resolution_func(), idMap));
  }

  void operator()(const array_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Arraytypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiArrayType(obj->VpiArrayType());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Index_typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getIndextypespec();
      tmp.setIndex(GetId(obj->Index_typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Index_typespec())->UhdmType()));
    }
    if (obj->Elem_typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getElemtypespec();
      tmp.setIndex(GetId(obj->Elem_typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Elem_typespec())->UhdmType()));
    }
    if (obj->Resolution_func() != nullptr) builder.setResolutionfunc(GetId(obj->Resolution_func(), idMap));
  }

  void operator()(const void_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Voidtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const unsupported_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Unsupportedtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiPacked(obj->VpiPacked());
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
  }

  void operator()(const sequence_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Sequencetypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const property_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Propertytypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const interface_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Interfacetypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDefName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDefName()));
    builder.setVpiIsModPort(obj->VpiIsModPort());
    if (obj->Param_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Paramassignss = builder.initParamassigns(obj->Param_assigns()->size());
      for (int32_t i = 0, n = obj->Param_assigns()->size(); i < n; ++i) {
        Paramassignss.set(i, GetId((*obj->Param_assigns())[i], idMap));
      }
    }
  }

  void operator()(const type_parameter *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Typeparameter::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiLocalParam(obj->VpiLocalParam());
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
    builder.setVpiImported((RawSymbolId)serializer->symbolMaker.Make(obj->VpiImported()));
  }

  void operator()(const typespec_member *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Typespecmember::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiRandType(obj->VpiRandType());
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
    if (obj->Default_value() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getDefaultvalue();
      tmp.setIndex(GetId(obj->Default_value(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Default_value())->UhdmType()));
    }
    builder.setVpiRefFile((RawSymbolId)serializer->symbolMaker.Make(obj->VpiRefFile()));
    builder.setVpiRefLineNo(obj->VpiRefLineNo());
    builder.setVpiRefColumnNo(obj->VpiRefColumnNo());
    builder.setVpiRefEndLineNo(obj->VpiRefEndLineNo());
    builder.setVpiRefEndColumnNo(obj->VpiRefEndColumnNo());
  }

  void operator()(const enum_const *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Enumconst::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiValue((RawSymbolId)serializer->symbolMaker.Make(obj->VpiValue()));
    builder.setVpiDecompile((RawSymbolId)serializer->symbolMaker.Make(obj->VpiDecompile()));
    builder.setVpiSize(obj->VpiSize());
  }

  void operator()(const bit_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Bittypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiVector(obj->VpiVector());
    if (obj->Bit_typespec() != nullptr) builder.setBittypespec(GetId(obj->Bit_typespec(), idMap));
    if (obj->Ranges() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Rangess = builder.initRanges(obj->Ranges()->size());
      for (int32_t i = 0, n = obj->Ranges()->size(); i < n; ++i) {
        Rangess.set(i, GetId((*obj->Ranges())[i], idMap));
      }
    }
    if (obj->Left_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getLeftexpr();
      tmp.setIndex(GetId(obj->Left_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Left_expr())->UhdmType()));
    }
    if (obj->Right_expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getRightexpr();
      tmp.setIndex(GetId(obj->Right_expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Right_expr())->UhdmType()));
    }
    if (obj->Typespec() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getTypespec();
      tmp.setIndex(GetId(obj->Typespec(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Typespec())->UhdmType()));
    }
    builder.setVpiSigned(obj->VpiSigned());
    if (obj->Resolution_func() != nullptr) builder.setResolutionfunc(GetId(obj->Resolution_func(), idMap));
  }

  void operator()(const tf_call *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Tfcall::Builder builder) const {
    operator()(static_cast<const expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Scope() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getScope();
      tmp.setIndex(GetId(obj->Scope(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Scope())->UhdmType()));
    }
    if (obj->Tf_call_args() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Tfcallargss = builder.initTfcallargs(obj->Tf_call_args()->size());
      for (int32_t i = 0, n = obj->Tf_call_args()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Tfcallargss[i];
        tmp.setIndex(GetId((*obj->Tf_call_args())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Tf_call_args())[i]))->UhdmType()));
      }
    }
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
  }

  void operator()(const user_systf *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Usersystf::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const sys_func_call *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Sysfunccall::Builder builder) const {
    operator()(static_cast<const tf_call*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiFuncType(obj->VpiFuncType());
    builder.setVpiUserDefn(obj->VpiUserDefn());
    if (obj->User_systf() != nullptr) builder.setUsersystf(GetId(obj->User_systf(), idMap));
  }

  void operator()(const sys_task_call *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Systaskcall::Builder builder) const {
    operator()(static_cast<const tf_call*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiUserDefn(obj->VpiUserDefn());
    if (obj->User_systf() != nullptr) builder.setUsersystf(GetId(obj->User_systf(), idMap));
  }

  void operator()(const method_func_call *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Methodfunccall::Builder builder) const {
    operator()(static_cast<const tf_call*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiUserDefn(obj->VpiUserDefn());
    if (obj->Prefix() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getPrefix();
      tmp.setIndex(GetId(obj->Prefix(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Prefix())->UhdmType()));
    }
    if (obj->With() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getWith();
      tmp.setIndex(GetId(obj->With(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->With())->UhdmType()));
    }
    if (obj->Function() != nullptr) builder.setFunction(GetId(obj->Function(), idMap));
  }

  void operator()(const method_task_call *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Methodtaskcall::Builder builder) const {
    operator()(static_cast<const tf_call*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiUserDefn(obj->VpiUserDefn());
    if (obj->Prefix() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getPrefix();
      tmp.setIndex(GetId(obj->Prefix(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Prefix())->UhdmType()));
    }
    if (obj->With() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getWith();
      tmp.setIndex(GetId(obj->With(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->With())->UhdmType()));
    }
    if (obj->Task() != nullptr) builder.setTask(GetId(obj->Task(), idMap));
  }

  void operator()(const func_call *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Funccall::Builder builder) const {
    operator()(static_cast<const tf_call*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiFuncType(obj->VpiFuncType());
    if (obj->Function() != nullptr) builder.setFunction(GetId(obj->Function(), idMap));
  }

  void operator()(const task_call *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Taskcall::Builder builder) const {
    operator()(static_cast<const tf_call*>(obj), serializer, idMap, builder.getBase());
    if (obj->Task() != nullptr) builder.setTask(GetId(obj->Task(), idMap));
  }

  void operator()(const constraint_expr *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Constraintexpr::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
  }

  void operator()(const constraint_ordering *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Constraintordering::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    if (obj->Solve_befores() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Solvebeforess = builder.initSolvebefores(obj->Solve_befores()->size());
      for (int32_t i = 0, n = obj->Solve_befores()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Solvebeforess[i];
        tmp.setIndex(GetId((*obj->Solve_befores())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Solve_befores())[i]))->UhdmType()));
      }
    }
    if (obj->Solve_afters() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Solveafterss = builder.initSolveafters(obj->Solve_afters()->size());
      for (int32_t i = 0, n = obj->Solve_afters()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Solveafterss[i];
        tmp.setIndex(GetId((*obj->Solve_afters())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Solve_afters())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const constraint *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Constraint::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    builder.setVpiFullName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiFullName()));
    builder.setVpiVirtual(obj->VpiVirtual());
    builder.setVpiAutomatic(obj->VpiAutomatic());
    builder.setVpiAllocScheme(obj->VpiAllocScheme());
    builder.setVpiAccessType(obj->VpiAccessType());
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
    builder.setVpiIsConstraintEnabled(obj->VpiIsConstraintEnabled());
    if (obj->Constraint_items() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Constraintitemss = builder.initConstraintitems(obj->Constraint_items()->size());
      for (int32_t i = 0, n = obj->Constraint_items()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Constraintitemss[i];
        tmp.setIndex(GetId((*obj->Constraint_items())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Constraint_items())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const import_typespec *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Importtypespec::Builder builder) const {
    operator()(static_cast<const typespec*>(obj), serializer, idMap, builder.getBase());
    if (obj->Item() != nullptr) builder.setItem(GetId(obj->Item(), idMap));
  }

  void operator()(const dist_item *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Distitem::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiDistType(obj->VpiDistType());
    if (obj->Value_range() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getValuerange();
      tmp.setIndex(GetId(obj->Value_range(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Value_range())->UhdmType()));
    }
    if (obj->Weight() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getWeight();
      tmp.setIndex(GetId(obj->Weight(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Weight())->UhdmType()));
    }
  }

  void operator()(const distribution *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Distribution::Builder builder) const {
    operator()(static_cast<const constraint_expr*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiSoft(obj->VpiSoft());
    if (obj->Dist_items() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Distitemss = builder.initDistitems(obj->Dist_items()->size());
      for (int32_t i = 0, n = obj->Dist_items()->size(); i < n; ++i) {
        Distitemss.set(i, GetId((*obj->Dist_items())[i], idMap));
      }
    }
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
  }

  void operator()(const implication *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Implication::Builder builder) const {
    operator()(static_cast<const constraint_expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Condition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getCondition();
      tmp.setIndex(GetId(obj->Condition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Condition())->UhdmType()));
    }
    if (obj->Constraint_exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Constraintexprss = builder.initConstraintexprs(obj->Constraint_exprs()->size());
      for (int32_t i = 0, n = obj->Constraint_exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Constraintexprss[i];
        tmp.setIndex(GetId((*obj->Constraint_exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Constraint_exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const constr_if *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Constrif::Builder builder) const {
    operator()(static_cast<const constraint_expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Condition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getCondition();
      tmp.setIndex(GetId(obj->Condition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Condition())->UhdmType()));
    }
    if (obj->Constraint_exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Constraintexprss = builder.initConstraintexprs(obj->Constraint_exprs()->size());
      for (int32_t i = 0, n = obj->Constraint_exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Constraintexprss[i];
        tmp.setIndex(GetId((*obj->Constraint_exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Constraint_exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const constr_if_else *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Constrifelse::Builder builder) const {
    operator()(static_cast<const constraint_expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Condition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getCondition();
      tmp.setIndex(GetId(obj->Condition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Condition())->UhdmType()));
    }
    if (obj->Constraint_exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Constraintexprss = builder.initConstraintexprs(obj->Constraint_exprs()->size());
      for (int32_t i = 0, n = obj->Constraint_exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Constraintexprss[i];
        tmp.setIndex(GetId((*obj->Constraint_exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Constraint_exprs())[i]))->UhdmType()));
      }
    }
    if (obj->Else_constraint_exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Elseconstraintexprss = builder.initElseconstraintexprs(obj->Else_constraint_exprs()->size());
      for (int32_t i = 0, n = obj->Else_constraint_exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Elseconstraintexprss[i];
        tmp.setIndex(GetId((*obj->Else_constraint_exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Else_constraint_exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const constr_foreach *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Constrforeach::Builder builder) const {
    operator()(static_cast<const constraint_expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Variable() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVariable();
      tmp.setIndex(GetId(obj->Variable(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Variable())->UhdmType()));
    }
    if (obj->VpiLoopVars() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiLoopVarss = builder.initVpiLoopVars(obj->VpiLoopVars()->size());
      for (int32_t i = 0, n = obj->VpiLoopVars()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiLoopVarss[i];
        tmp.setIndex(GetId((*obj->VpiLoopVars())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiLoopVars())[i]))->UhdmType()));
      }
    }
    if (obj->Constraint_exprs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Constraintexprss = builder.initConstraintexprs(obj->Constraint_exprs()->size());
      for (int32_t i = 0, n = obj->Constraint_exprs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Constraintexprss[i];
        tmp.setIndex(GetId((*obj->Constraint_exprs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Constraint_exprs())[i]))->UhdmType()));
      }
    }
  }

  void operator()(const soft_disable *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Softdisable::Builder builder) const {
    operator()(static_cast<const constraint_expr*>(obj), serializer, idMap, builder.getBase());
    if (obj->Expr() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getExpr();
      tmp.setIndex(GetId(obj->Expr(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->Expr())->UhdmType()));
    }
  }

  void operator()(const gen_stmt *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genstmt::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Attributes() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Attributess = builder.initAttributes(obj->Attributes()->size());
      for (int32_t i = 0, n = obj->Attributes()->size(); i < n; ++i) {
        Attributess.set(i, GetId((*obj->Attributes())[i], idMap));
      }
    }
  }

  void operator()(const gen_if *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genif::Builder builder) const {
    operator()(static_cast<const gen_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const gen_if_else *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genifelse::Builder builder) const {
    operator()(static_cast<const gen_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
    if (obj->VpiElseStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiElseStmt();
      tmp.setIndex(GetId(obj->VpiElseStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiElseStmt())->UhdmType()));
    }
  }

  void operator()(const gen_for *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genfor::Builder builder) const {
    operator()(static_cast<const gen_stmt*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiLocalVarDecls(obj->VpiLocalVarDecls());
    if (obj->VpiForInitStmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiForInitStmtss = builder.initVpiForInitStmts(obj->VpiForInitStmts()->size());
      for (int32_t i = 0, n = obj->VpiForInitStmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiForInitStmtss[i];
        tmp.setIndex(GetId((*obj->VpiForInitStmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiForInitStmts())[i]))->UhdmType()));
      }
    }
    if (obj->VpiForIncStmts() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder VpiForIncStmtss = builder.initVpiForIncStmts(obj->VpiForIncStmts()->size());
      for (int32_t i = 0, n = obj->VpiForIncStmts()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = VpiForIncStmtss[i];
        tmp.setIndex(GetId((*obj->VpiForIncStmts())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->VpiForIncStmts())[i]))->UhdmType()));
      }
    }
    if (obj->VpiForInitStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiForInitStmt();
      tmp.setIndex(GetId(obj->VpiForInitStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiForInitStmt())->UhdmType()));
    }
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->VpiForIncStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiForIncStmt();
      tmp.setIndex(GetId(obj->VpiForIncStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiForIncStmt())->UhdmType()));
    }
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const gen_case *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Gencase::Builder builder) const {
    operator()(static_cast<const gen_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiCondition() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiCondition();
      tmp.setIndex(GetId(obj->VpiCondition(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiCondition())->UhdmType()));
    }
    if (obj->Case_items() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Caseitemss = builder.initCaseitems(obj->Case_items()->size());
      for (int32_t i = 0, n = obj->Case_items()->size(); i < n; ++i) {
        Caseitemss.set(i, GetId((*obj->Case_items())[i], idMap));
      }
    }
  }

  void operator()(const gen_region *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Genregion::Builder builder) const {
    operator()(static_cast<const gen_stmt*>(obj), serializer, idMap, builder.getBase());
    if (obj->VpiStmt() != nullptr) {
      ::ObjIndexType::Builder tmp = builder.getVpiStmt();
      tmp.setIndex(GetId(obj->VpiStmt(), idMap));
      tmp.setType(static_cast<uint32_t>((obj->VpiStmt())->UhdmType()));
    }
  }

  void operator()(const design *const obj, Serializer *const serializer, const Serializer::IdMap &idMap, Design::Builder builder) const {
    operator()(static_cast<const BaseClass*>(obj), serializer, idMap, builder.getBase());
    builder.setVpiElaborated(obj->VpiElaborated());
    builder.setVpiName((RawSymbolId)serializer->symbolMaker.Make(obj->VpiName()));
    if (obj->Include_file_infos() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Includefileinfoss = builder.initIncludefileinfos(obj->Include_file_infos()->size());
      for (int32_t i = 0, n = obj->Include_file_infos()->size(); i < n; ++i) {
        Includefileinfoss.set(i, GetId((*obj->Include_file_infos())[i], idMap));
      }
    }
    if (obj->AllPackages() != nullptr) {
      ::capnp::List<::uint64_t>::Builder AllPackagess = builder.initAllPackages(obj->AllPackages()->size());
      for (int32_t i = 0, n = obj->AllPackages()->size(); i < n; ++i) {
        AllPackagess.set(i, GetId((*obj->AllPackages())[i], idMap));
      }
    }
    if (obj->TopPackages() != nullptr) {
      ::capnp::List<::uint64_t>::Builder TopPackagess = builder.initTopPackages(obj->TopPackages()->size());
      for (int32_t i = 0, n = obj->TopPackages()->size(); i < n; ++i) {
        TopPackagess.set(i, GetId((*obj->TopPackages())[i], idMap));
      }
    }
    if (obj->AllClasses() != nullptr) {
      ::capnp::List<::uint64_t>::Builder AllClassess = builder.initAllClasses(obj->AllClasses()->size());
      for (int32_t i = 0, n = obj->AllClasses()->size(); i < n; ++i) {
        AllClassess.set(i, GetId((*obj->AllClasses())[i], idMap));
      }
    }
    if (obj->AllInterfaces() != nullptr) {
      ::capnp::List<::uint64_t>::Builder AllInterfacess = builder.initAllInterfaces(obj->AllInterfaces()->size());
      for (int32_t i = 0, n = obj->AllInterfaces()->size(); i < n; ++i) {
        AllInterfacess.set(i, GetId((*obj->AllInterfaces())[i], idMap));
      }
    }
    if (obj->AllUdps() != nullptr) {
      ::capnp::List<::uint64_t>::Builder AllUdpss = builder.initAllUdps(obj->AllUdps()->size());
      for (int32_t i = 0, n = obj->AllUdps()->size(); i < n; ++i) {
        AllUdpss.set(i, GetId((*obj->AllUdps())[i], idMap));
      }
    }
    if (obj->AllPrograms() != nullptr) {
      ::capnp::List<::uint64_t>::Builder AllProgramss = builder.initAllPrograms(obj->AllPrograms()->size());
      for (int32_t i = 0, n = obj->AllPrograms()->size(); i < n; ++i) {
        AllProgramss.set(i, GetId((*obj->AllPrograms())[i], idMap));
      }
    }
    if (obj->AllModules() != nullptr) {
      ::capnp::List<::uint64_t>::Builder AllModuless = builder.initAllModules(obj->AllModules()->size());
      for (int32_t i = 0, n = obj->AllModules()->size(); i < n; ++i) {
        AllModuless.set(i, GetId((*obj->AllModules())[i], idMap));
      }
    }
    if (obj->Typespecs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Typespecss = builder.initTypespecs(obj->Typespecs()->size());
      for (int32_t i = 0, n = obj->Typespecs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Typespecss[i];
        tmp.setIndex(GetId((*obj->Typespecs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Typespecs())[i]))->UhdmType()));
      }
    }
    if (obj->Let_decls() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Letdeclss = builder.initLetdecls(obj->Let_decls()->size());
      for (int32_t i = 0, n = obj->Let_decls()->size(); i < n; ++i) {
        Letdeclss.set(i, GetId((*obj->Let_decls())[i], idMap));
      }
    }
    if (obj->Task_funcs() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Taskfuncss = builder.initTaskfuncs(obj->Task_funcs()->size());
      for (int32_t i = 0, n = obj->Task_funcs()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Taskfuncss[i];
        tmp.setIndex(GetId((*obj->Task_funcs())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Task_funcs())[i]))->UhdmType()));
      }
    }
    if (obj->Parameters() != nullptr) {
      ::capnp::List<::ObjIndexType>::Builder Parameterss = builder.initParameters(obj->Parameters()->size());
      for (int32_t i = 0, n = obj->Parameters()->size(); i < n; ++i) {
        ::ObjIndexType::Builder tmp = Parameterss[i];
        tmp.setIndex(GetId((*obj->Parameters())[i], idMap));
        tmp.setType(static_cast<uint32_t>(((BaseClass*)((*obj->Parameters())[i]))->UhdmType()));
      }
    }
    if (obj->Param_assigns() != nullptr) {
      ::capnp::List<::uint64_t>::Builder Paramassignss = builder.initParamassigns(obj->Param_assigns()->size());
      for (int32_t i = 0, n = obj->Param_assigns()->size(); i < n; ++i) {
        Paramassignss.set(i, GetId((*obj->Param_assigns())[i], idMap));
      }
    }
    if (obj->TopModules() != nullptr) {
      ::capnp::List<::uint64_t>::Builder TopModuless = builder.initTopModules(obj->TopModules()->size());
      for (int32_t i = 0, n = obj->TopModules()->size(); i < n; ++i) {
        TopModuless.set(i, GetId((*obj->TopModules())[i], idMap));
      }
    }
  }


  template<typename T, typename U, typename = typename std::enable_if<std::is_base_of<BaseClass, T>::value>::type>
  void operator()(const FactoryT<T>& factory, Serializer* serializer, const Serializer::IdMap& idMap,
                  typename ::capnp::List<U>::Builder builder) const {
    uint32_t index = 0;
    for (const T* obj : factory.objects_)
      operator()(obj, serializer, idMap, builder[index++]);
  }
};

void Serializer::Save(const std::filesystem::path& filepath) {
    Save(filepath.string());
}

void Serializer::Save(const std::string& filepath) {
  if (m_enableGC) GarbageCollect();

  uint32_t index = 0;
  const std::string file = filepath;
  const int32_t fileid = open(file.c_str(), O_CREAT | O_WRONLY | O_BINARY, S_IRWXU);

  ::capnp::MallocMessageBuilder message;
  UhdmRoot::Builder cap_root = message.initRoot<UhdmRoot>();
  cap_root.setVersion(kVersion);
  cap_root.setObjectId(m_objId);

  ::capnp::List<Design>::Builder designs = cap_root.initDesigns(designMaker.objects_.size());
  index = 0;
  for (auto design : designMaker.objects_) {
    designs[index].setVpiName((RawSymbolId)design->GetSerializer()->symbolMaker.Make(design->VpiName()));
    index++;
  }

  const IdMap idMap = AllObjects();
  SaveAdapter adapter;
    adapter.template operator()<attribute, Attribute>(attributeMaker, this, idMap, cap_root.initFactoryAttribute(attributeMaker.objects_.size()));
  adapter.template operator()<virtual_interface_var, Virtualinterfacevar>(virtual_interface_varMaker, this, idMap, cap_root.initFactoryVirtualinterfacevar(virtual_interface_varMaker.objects_.size()));
  adapter.template operator()<let_decl, Letdecl>(let_declMaker, this, idMap, cap_root.initFactoryLetdecl(let_declMaker.objects_.size()));
  adapter.template operator()<always, Always>(alwaysMaker, this, idMap, cap_root.initFactoryAlways(alwaysMaker.objects_.size()));
  adapter.template operator()<final_stmt, Finalstmt>(final_stmtMaker, this, idMap, cap_root.initFactoryFinalstmt(final_stmtMaker.objects_.size()));
  adapter.template operator()<initial, Initial>(initialMaker, this, idMap, cap_root.initFactoryInitial(initialMaker.objects_.size()));
  adapter.template operator()<delay_control, Delaycontrol>(delay_controlMaker, this, idMap, cap_root.initFactoryDelaycontrol(delay_controlMaker.objects_.size()));
  adapter.template operator()<delay_term, Delayterm>(delay_termMaker, this, idMap, cap_root.initFactoryDelayterm(delay_termMaker.objects_.size()));
  adapter.template operator()<event_control, Eventcontrol>(event_controlMaker, this, idMap, cap_root.initFactoryEventcontrol(event_controlMaker.objects_.size()));
  adapter.template operator()<repeat_control, Repeatcontrol>(repeat_controlMaker, this, idMap, cap_root.initFactoryRepeatcontrol(repeat_controlMaker.objects_.size()));
  adapter.template operator()<begin, Begin>(beginMaker, this, idMap, cap_root.initFactoryBegin(beginMaker.objects_.size()));
  adapter.template operator()<named_begin, Namedbegin>(named_beginMaker, this, idMap, cap_root.initFactoryNamedbegin(named_beginMaker.objects_.size()));
  adapter.template operator()<named_fork, Namedfork>(named_forkMaker, this, idMap, cap_root.initFactoryNamedfork(named_forkMaker.objects_.size()));
  adapter.template operator()<fork_stmt, Forkstmt>(fork_stmtMaker, this, idMap, cap_root.initFactoryForkstmt(fork_stmtMaker.objects_.size()));
  adapter.template operator()<for_stmt, Forstmt>(for_stmtMaker, this, idMap, cap_root.initFactoryForstmt(for_stmtMaker.objects_.size()));
  adapter.template operator()<if_stmt, Ifstmt>(if_stmtMaker, this, idMap, cap_root.initFactoryIfstmt(if_stmtMaker.objects_.size()));
  adapter.template operator()<event_stmt, Eventstmt>(event_stmtMaker, this, idMap, cap_root.initFactoryEventstmt(event_stmtMaker.objects_.size()));
  adapter.template operator()<thread_obj, Threadobj>(thread_objMaker, this, idMap, cap_root.initFactoryThreadobj(thread_objMaker.objects_.size()));
  adapter.template operator()<forever_stmt, Foreverstmt>(forever_stmtMaker, this, idMap, cap_root.initFactoryForeverstmt(forever_stmtMaker.objects_.size()));
  adapter.template operator()<wait_stmt, Waitstmt>(wait_stmtMaker, this, idMap, cap_root.initFactoryWaitstmt(wait_stmtMaker.objects_.size()));
  adapter.template operator()<wait_fork, Waitfork>(wait_forkMaker, this, idMap, cap_root.initFactoryWaitfork(wait_forkMaker.objects_.size()));
  adapter.template operator()<ordered_wait, Orderedwait>(ordered_waitMaker, this, idMap, cap_root.initFactoryOrderedwait(ordered_waitMaker.objects_.size()));
  adapter.template operator()<disable, Disable>(disableMaker, this, idMap, cap_root.initFactoryDisable(disableMaker.objects_.size()));
  adapter.template operator()<disable_fork, Disablefork>(disable_forkMaker, this, idMap, cap_root.initFactoryDisablefork(disable_forkMaker.objects_.size()));
  adapter.template operator()<continue_stmt, Continuestmt>(continue_stmtMaker, this, idMap, cap_root.initFactoryContinuestmt(continue_stmtMaker.objects_.size()));
  adapter.template operator()<break_stmt, Breakstmt>(break_stmtMaker, this, idMap, cap_root.initFactoryBreakstmt(break_stmtMaker.objects_.size()));
  adapter.template operator()<return_stmt, Returnstmt>(return_stmtMaker, this, idMap, cap_root.initFactoryReturnstmt(return_stmtMaker.objects_.size()));
  adapter.template operator()<while_stmt, Whilestmt>(while_stmtMaker, this, idMap, cap_root.initFactoryWhilestmt(while_stmtMaker.objects_.size()));
  adapter.template operator()<repeat, Repeat>(repeatMaker, this, idMap, cap_root.initFactoryRepeat(repeatMaker.objects_.size()));
  adapter.template operator()<do_while, Dowhile>(do_whileMaker, this, idMap, cap_root.initFactoryDowhile(do_whileMaker.objects_.size()));
  adapter.template operator()<if_else, Ifelse>(if_elseMaker, this, idMap, cap_root.initFactoryIfelse(if_elseMaker.objects_.size()));
  adapter.template operator()<case_stmt, Casestmt>(case_stmtMaker, this, idMap, cap_root.initFactoryCasestmt(case_stmtMaker.objects_.size()));
  adapter.template operator()<force, Force>(forceMaker, this, idMap, cap_root.initFactoryForce(forceMaker.objects_.size()));
  adapter.template operator()<assign_stmt, Assignstmt>(assign_stmtMaker, this, idMap, cap_root.initFactoryAssignstmt(assign_stmtMaker.objects_.size()));
  adapter.template operator()<deassign, Deassign>(deassignMaker, this, idMap, cap_root.initFactoryDeassign(deassignMaker.objects_.size()));
  adapter.template operator()<release, Release>(releaseMaker, this, idMap, cap_root.initFactoryRelease(releaseMaker.objects_.size()));
  adapter.template operator()<null_stmt, Nullstmt>(null_stmtMaker, this, idMap, cap_root.initFactoryNullstmt(null_stmtMaker.objects_.size()));
  adapter.template operator()<expect_stmt, Expectstmt>(expect_stmtMaker, this, idMap, cap_root.initFactoryExpectstmt(expect_stmtMaker.objects_.size()));
  adapter.template operator()<foreach_stmt, Foreachstmt>(foreach_stmtMaker, this, idMap, cap_root.initFactoryForeachstmt(foreach_stmtMaker.objects_.size()));
  adapter.template operator()<gen_scope, Genscope>(gen_scopeMaker, this, idMap, cap_root.initFactoryGenscope(gen_scopeMaker.objects_.size()));
  adapter.template operator()<gen_var, Genvar>(gen_varMaker, this, idMap, cap_root.initFactoryGenvar(gen_varMaker.objects_.size()));
  adapter.template operator()<gen_scope_array, Genscopearray>(gen_scope_arrayMaker, this, idMap, cap_root.initFactoryGenscopearray(gen_scope_arrayMaker.objects_.size()));
  adapter.template operator()<assert_stmt, Assertstmt>(assert_stmtMaker, this, idMap, cap_root.initFactoryAssertstmt(assert_stmtMaker.objects_.size()));
  adapter.template operator()<cover, Cover>(coverMaker, this, idMap, cap_root.initFactoryCover(coverMaker.objects_.size()));
  adapter.template operator()<assume, Assume>(assumeMaker, this, idMap, cap_root.initFactoryAssume(assumeMaker.objects_.size()));
  adapter.template operator()<restrict, Restrict>(restrictMaker, this, idMap, cap_root.initFactoryRestrict(restrictMaker.objects_.size()));
  adapter.template operator()<immediate_assert, Immediateassert>(immediate_assertMaker, this, idMap, cap_root.initFactoryImmediateassert(immediate_assertMaker.objects_.size()));
  adapter.template operator()<immediate_assume, Immediateassume>(immediate_assumeMaker, this, idMap, cap_root.initFactoryImmediateassume(immediate_assumeMaker.objects_.size()));
  adapter.template operator()<immediate_cover, Immediatecover>(immediate_coverMaker, this, idMap, cap_root.initFactoryImmediatecover(immediate_coverMaker.objects_.size()));
  adapter.template operator()<case_item, Caseitem>(case_itemMaker, this, idMap, cap_root.initFactoryCaseitem(case_itemMaker.objects_.size()));
  adapter.template operator()<assignment, Assignment>(assignmentMaker, this, idMap, cap_root.initFactoryAssignment(assignmentMaker.objects_.size()));
  adapter.template operator()<any_pattern, Anypattern>(any_patternMaker, this, idMap, cap_root.initFactoryAnypattern(any_patternMaker.objects_.size()));
  adapter.template operator()<tagged_pattern, Taggedpattern>(tagged_patternMaker, this, idMap, cap_root.initFactoryTaggedpattern(tagged_patternMaker.objects_.size()));
  adapter.template operator()<struct_pattern, Structpattern>(struct_patternMaker, this, idMap, cap_root.initFactoryStructpattern(struct_patternMaker.objects_.size()));
  adapter.template operator()<unsupported_expr, Unsupportedexpr>(unsupported_exprMaker, this, idMap, cap_root.initFactoryUnsupportedexpr(unsupported_exprMaker.objects_.size()));
  adapter.template operator()<unsupported_stmt, Unsupportedstmt>(unsupported_stmtMaker, this, idMap, cap_root.initFactoryUnsupportedstmt(unsupported_stmtMaker.objects_.size()));
  adapter.template operator()<include_file_info, Includefileinfo>(include_file_infoMaker, this, idMap, cap_root.initFactoryIncludefileinfo(include_file_infoMaker.objects_.size()));
  adapter.template operator()<sequence_inst, Sequenceinst>(sequence_instMaker, this, idMap, cap_root.initFactorySequenceinst(sequence_instMaker.objects_.size()));
  adapter.template operator()<seq_formal_decl, Seqformaldecl>(seq_formal_declMaker, this, idMap, cap_root.initFactorySeqformaldecl(seq_formal_declMaker.objects_.size()));
  adapter.template operator()<sequence_decl, Sequencedecl>(sequence_declMaker, this, idMap, cap_root.initFactorySequencedecl(sequence_declMaker.objects_.size()));
  adapter.template operator()<prop_formal_decl, Propformaldecl>(prop_formal_declMaker, this, idMap, cap_root.initFactoryPropformaldecl(prop_formal_declMaker.objects_.size()));
  adapter.template operator()<property_inst, Propertyinst>(property_instMaker, this, idMap, cap_root.initFactoryPropertyinst(property_instMaker.objects_.size()));
  adapter.template operator()<property_spec, Propertyspec>(property_specMaker, this, idMap, cap_root.initFactoryPropertyspec(property_specMaker.objects_.size()));
  adapter.template operator()<property_decl, Propertydecl>(property_declMaker, this, idMap, cap_root.initFactoryPropertydecl(property_declMaker.objects_.size()));
  adapter.template operator()<clocked_property, Clockedproperty>(clocked_propertyMaker, this, idMap, cap_root.initFactoryClockedproperty(clocked_propertyMaker.objects_.size()));
  adapter.template operator()<case_property_item, Casepropertyitem>(case_property_itemMaker, this, idMap, cap_root.initFactoryCasepropertyitem(case_property_itemMaker.objects_.size()));
  adapter.template operator()<case_property, Caseproperty>(case_propertyMaker, this, idMap, cap_root.initFactoryCaseproperty(case_propertyMaker.objects_.size()));
  adapter.template operator()<multiclock_sequence_expr, Multiclocksequenceexpr>(multiclock_sequence_exprMaker, this, idMap, cap_root.initFactoryMulticlocksequenceexpr(multiclock_sequence_exprMaker.objects_.size()));
  adapter.template operator()<clocked_seq, Clockedseq>(clocked_seqMaker, this, idMap, cap_root.initFactoryClockedseq(clocked_seqMaker.objects_.size()));
  adapter.template operator()<constant, Constant>(constantMaker, this, idMap, cap_root.initFactoryConstant(constantMaker.objects_.size()));
  adapter.template operator()<let_expr, Letexpr>(let_exprMaker, this, idMap, cap_root.initFactoryLetexpr(let_exprMaker.objects_.size()));
  adapter.template operator()<operation, Operation>(operationMaker, this, idMap, cap_root.initFactoryOperation(operationMaker.objects_.size()));
  adapter.template operator()<ref_obj, Refobj>(ref_objMaker, this, idMap, cap_root.initFactoryRefobj(ref_objMaker.objects_.size()));
  adapter.template operator()<ref_module, Refmodule>(ref_moduleMaker, this, idMap, cap_root.initFactoryRefmodule(ref_moduleMaker.objects_.size()));
  adapter.template operator()<ref_typespec, Reftypespec>(ref_typespecMaker, this, idMap, cap_root.initFactoryReftypespec(ref_typespecMaker.objects_.size()));
  adapter.template operator()<part_select, Partselect>(part_selectMaker, this, idMap, cap_root.initFactoryPartselect(part_selectMaker.objects_.size()));
  adapter.template operator()<indexed_part_select, Indexedpartselect>(indexed_part_selectMaker, this, idMap, cap_root.initFactoryIndexedpartselect(indexed_part_selectMaker.objects_.size()));
  adapter.template operator()<var_select, Varselect>(var_selectMaker, this, idMap, cap_root.initFactoryVarselect(var_selectMaker.objects_.size()));
  adapter.template operator()<bit_select, Bitselect>(bit_selectMaker, this, idMap, cap_root.initFactoryBitselect(bit_selectMaker.objects_.size()));
  adapter.template operator()<hier_path, Hierpath>(hier_pathMaker, this, idMap, cap_root.initFactoryHierpath(hier_pathMaker.objects_.size()));
  adapter.template operator()<ref_var, Refvar>(ref_varMaker, this, idMap, cap_root.initFactoryRefvar(ref_varMaker.objects_.size()));
  adapter.template operator()<short_real_var, Shortrealvar>(short_real_varMaker, this, idMap, cap_root.initFactoryShortrealvar(short_real_varMaker.objects_.size()));
  adapter.template operator()<real_var, Realvar>(real_varMaker, this, idMap, cap_root.initFactoryRealvar(real_varMaker.objects_.size()));
  adapter.template operator()<byte_var, Bytevar>(byte_varMaker, this, idMap, cap_root.initFactoryBytevar(byte_varMaker.objects_.size()));
  adapter.template operator()<short_int_var, Shortintvar>(short_int_varMaker, this, idMap, cap_root.initFactoryShortintvar(short_int_varMaker.objects_.size()));
  adapter.template operator()<int_var, Intvar>(int_varMaker, this, idMap, cap_root.initFactoryIntvar(int_varMaker.objects_.size()));
  adapter.template operator()<long_int_var, Longintvar>(long_int_varMaker, this, idMap, cap_root.initFactoryLongintvar(long_int_varMaker.objects_.size()));
  adapter.template operator()<integer_var, Integervar>(integer_varMaker, this, idMap, cap_root.initFactoryIntegervar(integer_varMaker.objects_.size()));
  adapter.template operator()<time_var, Timevar>(time_varMaker, this, idMap, cap_root.initFactoryTimevar(time_varMaker.objects_.size()));
  adapter.template operator()<array_var, Arrayvar>(array_varMaker, this, idMap, cap_root.initFactoryArrayvar(array_varMaker.objects_.size()));
  adapter.template operator()<array_expr, Arrayexpr>(array_exprMaker, this, idMap, cap_root.initFactoryArrayexpr(array_exprMaker.objects_.size()));
  adapter.template operator()<reg_array, Regarray>(reg_arrayMaker, this, idMap, cap_root.initFactoryRegarray(reg_arrayMaker.objects_.size()));
  adapter.template operator()<reg, Reg>(regMaker, this, idMap, cap_root.initFactoryReg(regMaker.objects_.size()));
  adapter.template operator()<packed_array_var, Packedarrayvar>(packed_array_varMaker, this, idMap, cap_root.initFactoryPackedarrayvar(packed_array_varMaker.objects_.size()));
  adapter.template operator()<bit_var, Bitvar>(bit_varMaker, this, idMap, cap_root.initFactoryBitvar(bit_varMaker.objects_.size()));
  adapter.template operator()<logic_var, Logicvar>(logic_varMaker, this, idMap, cap_root.initFactoryLogicvar(logic_varMaker.objects_.size()));
  adapter.template operator()<struct_var, Structvar>(struct_varMaker, this, idMap, cap_root.initFactoryStructvar(struct_varMaker.objects_.size()));
  adapter.template operator()<union_var, Unionvar>(union_varMaker, this, idMap, cap_root.initFactoryUnionvar(union_varMaker.objects_.size()));
  adapter.template operator()<enum_var, Enumvar>(enum_varMaker, this, idMap, cap_root.initFactoryEnumvar(enum_varMaker.objects_.size()));
  adapter.template operator()<string_var, Stringvar>(string_varMaker, this, idMap, cap_root.initFactoryStringvar(string_varMaker.objects_.size()));
  adapter.template operator()<chandle_var, Chandlevar>(chandle_varMaker, this, idMap, cap_root.initFactoryChandlevar(chandle_varMaker.objects_.size()));
  adapter.template operator()<var_bit, Varbit>(var_bitMaker, this, idMap, cap_root.initFactoryVarbit(var_bitMaker.objects_.size()));
  adapter.template operator()<task, Task>(taskMaker, this, idMap, cap_root.initFactoryTask(taskMaker.objects_.size()));
  adapter.template operator()<function, Function>(functionMaker, this, idMap, cap_root.initFactoryFunction(functionMaker.objects_.size()));
  adapter.template operator()<modport, Modport>(modportMaker, this, idMap, cap_root.initFactoryModport(modportMaker.objects_.size()));
  adapter.template operator()<interface_tf_decl, Interfacetfdecl>(interface_tf_declMaker, this, idMap, cap_root.initFactoryInterfacetfdecl(interface_tf_declMaker.objects_.size()));
  adapter.template operator()<cont_assign, Contassign>(cont_assignMaker, this, idMap, cap_root.initFactoryContassign(cont_assignMaker.objects_.size()));
  adapter.template operator()<cont_assign_bit, Contassignbit>(cont_assign_bitMaker, this, idMap, cap_root.initFactoryContassignbit(cont_assign_bitMaker.objects_.size()));
  adapter.template operator()<port, Port>(portMaker, this, idMap, cap_root.initFactoryPort(portMaker.objects_.size()));
  adapter.template operator()<port_bit, Portbit>(port_bitMaker, this, idMap, cap_root.initFactoryPortbit(port_bitMaker.objects_.size()));
  adapter.template operator()<checker_port, Checkerport>(checker_portMaker, this, idMap, cap_root.initFactoryCheckerport(checker_portMaker.objects_.size()));
  adapter.template operator()<checker_inst_port, Checkerinstport>(checker_inst_portMaker, this, idMap, cap_root.initFactoryCheckerinstport(checker_inst_portMaker.objects_.size()));
  adapter.template operator()<gate, Gate>(gateMaker, this, idMap, cap_root.initFactoryGate(gateMaker.objects_.size()));
  adapter.template operator()<switch_tran, Switchtran>(switch_tranMaker, this, idMap, cap_root.initFactorySwitchtran(switch_tranMaker.objects_.size()));
  adapter.template operator()<udp, Udp>(udpMaker, this, idMap, cap_root.initFactoryUdp(udpMaker.objects_.size()));
  adapter.template operator()<mod_path, Modpath>(mod_pathMaker, this, idMap, cap_root.initFactoryModpath(mod_pathMaker.objects_.size()));
  adapter.template operator()<tchk, Tchk>(tchkMaker, this, idMap, cap_root.initFactoryTchk(tchkMaker.objects_.size()));
  adapter.template operator()<range, Range>(rangeMaker, this, idMap, cap_root.initFactoryRange(rangeMaker.objects_.size()));
  adapter.template operator()<udp_defn, Udpdefn>(udp_defnMaker, this, idMap, cap_root.initFactoryUdpdefn(udp_defnMaker.objects_.size()));
  adapter.template operator()<table_entry, Tableentry>(table_entryMaker, this, idMap, cap_root.initFactoryTableentry(table_entryMaker.objects_.size()));
  adapter.template operator()<io_decl, Iodecl>(io_declMaker, this, idMap, cap_root.initFactoryIodecl(io_declMaker.objects_.size()));
  adapter.template operator()<alias_stmt, Aliasstmt>(alias_stmtMaker, this, idMap, cap_root.initFactoryAliasstmt(alias_stmtMaker.objects_.size()));
  adapter.template operator()<clocking_block, Clockingblock>(clocking_blockMaker, this, idMap, cap_root.initFactoryClockingblock(clocking_blockMaker.objects_.size()));
  adapter.template operator()<clocking_io_decl, Clockingiodecl>(clocking_io_declMaker, this, idMap, cap_root.initFactoryClockingiodecl(clocking_io_declMaker.objects_.size()));
  adapter.template operator()<param_assign, Paramassign>(param_assignMaker, this, idMap, cap_root.initFactoryParamassign(param_assignMaker.objects_.size()));
  adapter.template operator()<interface_array, Interfacearray>(interface_arrayMaker, this, idMap, cap_root.initFactoryInterfacearray(interface_arrayMaker.objects_.size()));
  adapter.template operator()<program_array, Programarray>(program_arrayMaker, this, idMap, cap_root.initFactoryProgramarray(program_arrayMaker.objects_.size()));
  adapter.template operator()<module_array, Modulearray>(module_arrayMaker, this, idMap, cap_root.initFactoryModulearray(module_arrayMaker.objects_.size()));
  adapter.template operator()<gate_array, Gatearray>(gate_arrayMaker, this, idMap, cap_root.initFactoryGatearray(gate_arrayMaker.objects_.size()));
  adapter.template operator()<switch_array, Switcharray>(switch_arrayMaker, this, idMap, cap_root.initFactorySwitcharray(switch_arrayMaker.objects_.size()));
  adapter.template operator()<udp_array, Udparray>(udp_arrayMaker, this, idMap, cap_root.initFactoryUdparray(udp_arrayMaker.objects_.size()));
  adapter.template operator()<prim_term, Primterm>(prim_termMaker, this, idMap, cap_root.initFactoryPrimterm(prim_termMaker.objects_.size()));
  adapter.template operator()<path_term, Pathterm>(path_termMaker, this, idMap, cap_root.initFactoryPathterm(path_termMaker.objects_.size()));
  adapter.template operator()<tchk_term, Tchkterm>(tchk_termMaker, this, idMap, cap_root.initFactoryTchkterm(tchk_termMaker.objects_.size()));
  adapter.template operator()<net_bit, Netbit>(net_bitMaker, this, idMap, cap_root.initFactoryNetbit(net_bitMaker.objects_.size()));
  adapter.template operator()<struct_net, Structnet>(struct_netMaker, this, idMap, cap_root.initFactoryStructnet(struct_netMaker.objects_.size()));
  adapter.template operator()<enum_net, Enumnet>(enum_netMaker, this, idMap, cap_root.initFactoryEnumnet(enum_netMaker.objects_.size()));
  adapter.template operator()<integer_net, Integernet>(integer_netMaker, this, idMap, cap_root.initFactoryIntegernet(integer_netMaker.objects_.size()));
  adapter.template operator()<time_net, Timenet>(time_netMaker, this, idMap, cap_root.initFactoryTimenet(time_netMaker.objects_.size()));
  adapter.template operator()<logic_net, Logicnet>(logic_netMaker, this, idMap, cap_root.initFactoryLogicnet(logic_netMaker.objects_.size()));
  adapter.template operator()<array_net, Arraynet>(array_netMaker, this, idMap, cap_root.initFactoryArraynet(array_netMaker.objects_.size()));
  adapter.template operator()<packed_array_net, Packedarraynet>(packed_array_netMaker, this, idMap, cap_root.initFactoryPackedarraynet(packed_array_netMaker.objects_.size()));
  adapter.template operator()<event_typespec, Eventtypespec>(event_typespecMaker, this, idMap, cap_root.initFactoryEventtypespec(event_typespecMaker.objects_.size()));
  adapter.template operator()<named_event, Namedevent>(named_eventMaker, this, idMap, cap_root.initFactoryNamedevent(named_eventMaker.objects_.size()));
  adapter.template operator()<named_event_array, Namedeventarray>(named_event_arrayMaker, this, idMap, cap_root.initFactoryNamedeventarray(named_event_arrayMaker.objects_.size()));
  adapter.template operator()<parameter, Parameter>(parameterMaker, this, idMap, cap_root.initFactoryParameter(parameterMaker.objects_.size()));
  adapter.template operator()<def_param, Defparam>(def_paramMaker, this, idMap, cap_root.initFactoryDefparam(def_paramMaker.objects_.size()));
  adapter.template operator()<spec_param, Specparam>(spec_paramMaker, this, idMap, cap_root.initFactorySpecparam(spec_paramMaker.objects_.size()));
  adapter.template operator()<class_typespec, Classtypespec>(class_typespecMaker, this, idMap, cap_root.initFactoryClasstypespec(class_typespecMaker.objects_.size()));
  adapter.template operator()<extends, Extends>(extendsMaker, this, idMap, cap_root.initFactoryExtends(extendsMaker.objects_.size()));
  adapter.template operator()<class_defn, Classdefn>(class_defnMaker, this, idMap, cap_root.initFactoryClassdefn(class_defnMaker.objects_.size()));
  adapter.template operator()<class_obj, Classobj>(class_objMaker, this, idMap, cap_root.initFactoryClassobj(class_objMaker.objects_.size()));
  adapter.template operator()<class_var, Classvar>(class_varMaker, this, idMap, cap_root.initFactoryClassvar(class_varMaker.objects_.size()));
  adapter.template operator()<interface_inst, Interfaceinst>(interface_instMaker, this, idMap, cap_root.initFactoryInterfaceinst(interface_instMaker.objects_.size()));
  adapter.template operator()<program, Program>(programMaker, this, idMap, cap_root.initFactoryProgram(programMaker.objects_.size()));
  adapter.template operator()<package, Package>(packageMaker, this, idMap, cap_root.initFactoryPackage(packageMaker.objects_.size()));
  adapter.template operator()<module_inst, Moduleinst>(module_instMaker, this, idMap, cap_root.initFactoryModuleinst(module_instMaker.objects_.size()));
  adapter.template operator()<checker_decl, Checkerdecl>(checker_declMaker, this, idMap, cap_root.initFactoryCheckerdecl(checker_declMaker.objects_.size()));
  adapter.template operator()<checker_inst, Checkerinst>(checker_instMaker, this, idMap, cap_root.initFactoryCheckerinst(checker_instMaker.objects_.size()));
  adapter.template operator()<short_real_typespec, Shortrealtypespec>(short_real_typespecMaker, this, idMap, cap_root.initFactoryShortrealtypespec(short_real_typespecMaker.objects_.size()));
  adapter.template operator()<real_typespec, Realtypespec>(real_typespecMaker, this, idMap, cap_root.initFactoryRealtypespec(real_typespecMaker.objects_.size()));
  adapter.template operator()<byte_typespec, Bytetypespec>(byte_typespecMaker, this, idMap, cap_root.initFactoryBytetypespec(byte_typespecMaker.objects_.size()));
  adapter.template operator()<short_int_typespec, Shortinttypespec>(short_int_typespecMaker, this, idMap, cap_root.initFactoryShortinttypespec(short_int_typespecMaker.objects_.size()));
  adapter.template operator()<int_typespec, Inttypespec>(int_typespecMaker, this, idMap, cap_root.initFactoryInttypespec(int_typespecMaker.objects_.size()));
  adapter.template operator()<long_int_typespec, Longinttypespec>(long_int_typespecMaker, this, idMap, cap_root.initFactoryLonginttypespec(long_int_typespecMaker.objects_.size()));
  adapter.template operator()<integer_typespec, Integertypespec>(integer_typespecMaker, this, idMap, cap_root.initFactoryIntegertypespec(integer_typespecMaker.objects_.size()));
  adapter.template operator()<time_typespec, Timetypespec>(time_typespecMaker, this, idMap, cap_root.initFactoryTimetypespec(time_typespecMaker.objects_.size()));
  adapter.template operator()<enum_typespec, Enumtypespec>(enum_typespecMaker, this, idMap, cap_root.initFactoryEnumtypespec(enum_typespecMaker.objects_.size()));
  adapter.template operator()<string_typespec, Stringtypespec>(string_typespecMaker, this, idMap, cap_root.initFactoryStringtypespec(string_typespecMaker.objects_.size()));
  adapter.template operator()<chandle_typespec, Chandletypespec>(chandle_typespecMaker, this, idMap, cap_root.initFactoryChandletypespec(chandle_typespecMaker.objects_.size()));
  adapter.template operator()<module_typespec, Moduletypespec>(module_typespecMaker, this, idMap, cap_root.initFactoryModuletypespec(module_typespecMaker.objects_.size()));
  adapter.template operator()<struct_typespec, Structtypespec>(struct_typespecMaker, this, idMap, cap_root.initFactoryStructtypespec(struct_typespecMaker.objects_.size()));
  adapter.template operator()<union_typespec, Uniontypespec>(union_typespecMaker, this, idMap, cap_root.initFactoryUniontypespec(union_typespecMaker.objects_.size()));
  adapter.template operator()<logic_typespec, Logictypespec>(logic_typespecMaker, this, idMap, cap_root.initFactoryLogictypespec(logic_typespecMaker.objects_.size()));
  adapter.template operator()<packed_array_typespec, Packedarraytypespec>(packed_array_typespecMaker, this, idMap, cap_root.initFactoryPackedarraytypespec(packed_array_typespecMaker.objects_.size()));
  adapter.template operator()<array_typespec, Arraytypespec>(array_typespecMaker, this, idMap, cap_root.initFactoryArraytypespec(array_typespecMaker.objects_.size()));
  adapter.template operator()<void_typespec, Voidtypespec>(void_typespecMaker, this, idMap, cap_root.initFactoryVoidtypespec(void_typespecMaker.objects_.size()));
  adapter.template operator()<unsupported_typespec, Unsupportedtypespec>(unsupported_typespecMaker, this, idMap, cap_root.initFactoryUnsupportedtypespec(unsupported_typespecMaker.objects_.size()));
  adapter.template operator()<sequence_typespec, Sequencetypespec>(sequence_typespecMaker, this, idMap, cap_root.initFactorySequencetypespec(sequence_typespecMaker.objects_.size()));
  adapter.template operator()<property_typespec, Propertytypespec>(property_typespecMaker, this, idMap, cap_root.initFactoryPropertytypespec(property_typespecMaker.objects_.size()));
  adapter.template operator()<interface_typespec, Interfacetypespec>(interface_typespecMaker, this, idMap, cap_root.initFactoryInterfacetypespec(interface_typespecMaker.objects_.size()));
  adapter.template operator()<type_parameter, Typeparameter>(type_parameterMaker, this, idMap, cap_root.initFactoryTypeparameter(type_parameterMaker.objects_.size()));
  adapter.template operator()<typespec_member, Typespecmember>(typespec_memberMaker, this, idMap, cap_root.initFactoryTypespecmember(typespec_memberMaker.objects_.size()));
  adapter.template operator()<enum_const, Enumconst>(enum_constMaker, this, idMap, cap_root.initFactoryEnumconst(enum_constMaker.objects_.size()));
  adapter.template operator()<bit_typespec, Bittypespec>(bit_typespecMaker, this, idMap, cap_root.initFactoryBittypespec(bit_typespecMaker.objects_.size()));
  adapter.template operator()<user_systf, Usersystf>(user_systfMaker, this, idMap, cap_root.initFactoryUsersystf(user_systfMaker.objects_.size()));
  adapter.template operator()<sys_func_call, Sysfunccall>(sys_func_callMaker, this, idMap, cap_root.initFactorySysfunccall(sys_func_callMaker.objects_.size()));
  adapter.template operator()<sys_task_call, Systaskcall>(sys_task_callMaker, this, idMap, cap_root.initFactorySystaskcall(sys_task_callMaker.objects_.size()));
  adapter.template operator()<method_func_call, Methodfunccall>(method_func_callMaker, this, idMap, cap_root.initFactoryMethodfunccall(method_func_callMaker.objects_.size()));
  adapter.template operator()<method_task_call, Methodtaskcall>(method_task_callMaker, this, idMap, cap_root.initFactoryMethodtaskcall(method_task_callMaker.objects_.size()));
  adapter.template operator()<func_call, Funccall>(func_callMaker, this, idMap, cap_root.initFactoryFunccall(func_callMaker.objects_.size()));
  adapter.template operator()<task_call, Taskcall>(task_callMaker, this, idMap, cap_root.initFactoryTaskcall(task_callMaker.objects_.size()));
  adapter.template operator()<constraint_ordering, Constraintordering>(constraint_orderingMaker, this, idMap, cap_root.initFactoryConstraintordering(constraint_orderingMaker.objects_.size()));
  adapter.template operator()<constraint, Constraint>(constraintMaker, this, idMap, cap_root.initFactoryConstraint(constraintMaker.objects_.size()));
  adapter.template operator()<import_typespec, Importtypespec>(import_typespecMaker, this, idMap, cap_root.initFactoryImporttypespec(import_typespecMaker.objects_.size()));
  adapter.template operator()<dist_item, Distitem>(dist_itemMaker, this, idMap, cap_root.initFactoryDistitem(dist_itemMaker.objects_.size()));
  adapter.template operator()<distribution, Distribution>(distributionMaker, this, idMap, cap_root.initFactoryDistribution(distributionMaker.objects_.size()));
  adapter.template operator()<implication, Implication>(implicationMaker, this, idMap, cap_root.initFactoryImplication(implicationMaker.objects_.size()));
  adapter.template operator()<constr_if, Constrif>(constr_ifMaker, this, idMap, cap_root.initFactoryConstrif(constr_ifMaker.objects_.size()));
  adapter.template operator()<constr_if_else, Constrifelse>(constr_if_elseMaker, this, idMap, cap_root.initFactoryConstrifelse(constr_if_elseMaker.objects_.size()));
  adapter.template operator()<constr_foreach, Constrforeach>(constr_foreachMaker, this, idMap, cap_root.initFactoryConstrforeach(constr_foreachMaker.objects_.size()));
  adapter.template operator()<soft_disable, Softdisable>(soft_disableMaker, this, idMap, cap_root.initFactorySoftdisable(soft_disableMaker.objects_.size()));
  adapter.template operator()<gen_if, Genif>(gen_ifMaker, this, idMap, cap_root.initFactoryGenif(gen_ifMaker.objects_.size()));
  adapter.template operator()<gen_if_else, Genifelse>(gen_if_elseMaker, this, idMap, cap_root.initFactoryGenifelse(gen_if_elseMaker.objects_.size()));
  adapter.template operator()<gen_for, Genfor>(gen_forMaker, this, idMap, cap_root.initFactoryGenfor(gen_forMaker.objects_.size()));
  adapter.template operator()<gen_case, Gencase>(gen_caseMaker, this, idMap, cap_root.initFactoryGencase(gen_caseMaker.objects_.size()));
  adapter.template operator()<gen_region, Genregion>(gen_regionMaker, this, idMap, cap_root.initFactoryGenregion(gen_regionMaker.objects_.size()));
  adapter.template operator()<design, Design>(designMaker, this, idMap, cap_root.initFactoryDesign(designMaker.objects_.size()));

  // Save the symbols after all save function have been invoked, some symbols are made doing so (VpiFullName)
  // This is not ideal.
  // Ideally, the save should not include the hierarchical nets that can be recreated on the fly.
  // Something broke this mechanism that saved a lot of memory/disk space.
  // Until that is repaired we go for the more disk-hungry and memory hungry method which gives correct results.
  ::capnp::List<::capnp::Text>::Builder symbols = cap_root.initSymbols(symbolMaker.m_id2SymbolMap.size());
  index = 0;
  for (const auto& symbol : symbolMaker.m_id2SymbolMap) {
    symbols.set(index, symbol.c_str());
    index++;
  }

  writePackedMessageToFd(fileid, message);
  close(fileid);
}
}  // namespace UHDM
