/*
 Do not modify, auto-generated by script

 Copyright 2019-2020 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   UhdmListener.cpp
 * Author: hs
 *
 * Created on March 11, 2022, 00:00 AM
 */
#include <uhdm/UhdmListener.h>
#include <uhdm/uhdm.h>
#include <unordered_map>

namespace UHDM {
ScopedVpiHandle::ScopedVpiHandle(const UHDM::any* const any)
    : handle(NewVpiHandle(any)) {}

ScopedVpiHandle::~ScopedVpiHandle() {
  if (handle != nullptr) {
    vpi_release_handle(handle);
  }
}

bool UhdmListener::didVisitAll(const Serializer& serializer) const {
  std::set<const any*> allVisited;
  std::copy(visited.begin(), visited.end(),
            std::inserter(allVisited, allVisited.begin()));

  const Serializer::IdMap idMap = serializer.AllObjects();
  std::set<const any*> allObjects;
  std::transform(
      idMap.cbegin(), idMap.cend(),
      std::inserter(allObjects, allObjects.begin()),
      [](std::unordered_map<const BaseClass*, uint32_t>::const_reference
             entry) { return entry.first; });

  std::set<const any*> diffObjects;
  std::set_difference(allObjects.begin(), allObjects.end(), allVisited.begin(),
                      allVisited.end(),
                      std::inserter(diffObjects, diffObjects.begin()));

  return diffObjects.empty();
}

void UhdmListener::listenBaseClass_(const any* const object) {
  if (const any* const vpiParent_ = object->VpiParent()) {
    listenAny(vpiParent_);
  }
}

void UhdmListener::listenAttribute_(const attribute* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenVirtual_interface_var_(const virtual_interface_var* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenLet_decl_(const let_decl* const object) {
  listenBaseClass_(object);
  if (const VectorOfexpr *const expressions_ = object->Expressions()) {
    enterExpressions(object, *expressions_);
    for (VectorOfexpr::const_reference element : *expressions_) {
      listenAny(element);
    }
    leaveExpressions(object, *expressions_);
  }
  if (const VectorOfseq_formal_decl *const seq_formal_decls_ = object->Seq_formal_decls()) {
    enterSeq_formal_decls(object, *seq_formal_decls_);
    for (VectorOfseq_formal_decl::const_reference element : *seq_formal_decls_) {
      listenAny(element);
    }
    leaveSeq_formal_decls(object, *seq_formal_decls_);
  }
}

void UhdmListener::listenConcurrent_assertions_(const concurrent_assertions* const object) {
  listenBaseClass_(object);
  if (const any *const clocking_event_ = object->Clocking_event()) {
    listenAny(clocking_event_);
  }
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const vpiProperty_ = object->VpiProperty()) {
    listenAny(vpiProperty_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenProcess_stmt_(const process_stmt* const object) {
  listenBaseClass_(object);
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const module_inst_ = object->Module_inst()) {
    listenAny(module_inst_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenAlways_(const always* const object) {
  listenProcess_stmt_(object);
}

void UhdmListener::listenFinal_stmt_(const final_stmt* const object) {
  listenProcess_stmt_(object);
}

void UhdmListener::listenInitial_(const initial* const object) {
  listenProcess_stmt_(object);
}

void UhdmListener::listenAtomic_stmt_(const atomic_stmt* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenDelay_control_(const delay_control* const object) {
  listenAtomic_stmt_(object);
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const delay_ = object->Delay()) {
    listenAny(delay_);
  }
}

void UhdmListener::listenDelay_term_(const delay_term* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenEvent_control_(const event_control* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
}

void UhdmListener::listenRepeat_control_(const repeat_control* const object) {
  listenAtomic_stmt_(object);
}

void UhdmListener::listenScope_(const scope* const object) {
  listenBaseClass_(object);
  if (const VectorOfproperty_decl *const property_decls_ = object->Property_decls()) {
    enterProperty_decls(object, *property_decls_);
    for (VectorOfproperty_decl::const_reference element : *property_decls_) {
      listenAny(element);
    }
    leaveProperty_decls(object, *property_decls_);
  }
  if (const VectorOfsequence_decl *const sequence_decls_ = object->Sequence_decls()) {
    enterSequence_decls(object, *sequence_decls_);
    for (VectorOfsequence_decl::const_reference element : *sequence_decls_) {
      listenAny(element);
    }
    leaveSequence_decls(object, *sequence_decls_);
  }
  if (const VectorOfconcurrent_assertions *const concurrent_assertions_ = object->Concurrent_assertions()) {
    enterConcurrent_assertions(object, *concurrent_assertions_);
    for (VectorOfconcurrent_assertions::const_reference element : *concurrent_assertions_) {
      listenAny(element);
    }
    leaveConcurrent_assertions(object, *concurrent_assertions_);
  }
  if (const VectorOfnamed_event *const named_events_ = object->Named_events()) {
    enterNamed_events(object, *named_events_);
    for (VectorOfnamed_event::const_reference element : *named_events_) {
      listenAny(element);
    }
    leaveNamed_events(object, *named_events_);
  }
  if (const VectorOfnamed_event_array *const named_event_arrays_ = object->Named_event_arrays()) {
    enterNamed_event_arrays(object, *named_event_arrays_);
    for (VectorOfnamed_event_array::const_reference element : *named_event_arrays_) {
      listenAny(element);
    }
    leaveNamed_event_arrays(object, *named_event_arrays_);
  }
  if (const VectorOfvariables *const variables_ = object->Variables()) {
    enterVariables(object, *variables_);
    for (VectorOfvariables::const_reference element : *variables_) {
      listenAny(element);
    }
    leaveVariables(object, *variables_);
  }
  if (const VectorOfvirtual_interface_var *const virtual_interface_vars_ = object->Virtual_interface_vars()) {
    enterVirtual_interface_vars(object, *virtual_interface_vars_);
    for (VectorOfvirtual_interface_var::const_reference element : *virtual_interface_vars_) {
      listenAny(element);
    }
    leaveVirtual_interface_vars(object, *virtual_interface_vars_);
  }
  if (const VectorOflogic_var *const logic_vars_ = object->Logic_vars()) {
    enterLogic_vars(object, *logic_vars_);
    for (VectorOflogic_var::const_reference element : *logic_vars_) {
      listenAny(element);
    }
    leaveLogic_vars(object, *logic_vars_);
  }
  if (const VectorOfarray_var *const array_vars_ = object->Array_vars()) {
    enterArray_vars(object, *array_vars_);
    for (VectorOfarray_var::const_reference element : *array_vars_) {
      listenAny(element);
    }
    leaveArray_vars(object, *array_vars_);
  }
  if (const VectorOfarray_var *const array_var_mems_ = object->Array_var_mems()) {
    enterArray_var_mems(object, *array_var_mems_);
    for (VectorOfarray_var::const_reference element : *array_var_mems_) {
      listenAny(element);
    }
    leaveArray_var_mems(object, *array_var_mems_);
  }
  if (const VectorOfany *const parameters_ = object->Parameters()) {
    enterParameters(object, *parameters_);
    for (VectorOfany::const_reference element : *parameters_) {
      listenAny(element);
    }
    leaveParameters(object, *parameters_);
  }
  if (const VectorOfparam_assign *const param_assigns_ = object->Param_assigns()) {
    enterParam_assigns(object, *param_assigns_);
    for (VectorOfparam_assign::const_reference element : *param_assigns_) {
      listenAny(element);
    }
    leaveParam_assigns(object, *param_assigns_);
  }
  if (const VectorOfscope *const scopes_ = object->Scopes()) {
    enterScopes(object, *scopes_);
    for (VectorOfscope::const_reference element : *scopes_) {
      listenAny(element);
    }
    leaveScopes(object, *scopes_);
  }
  if (const VectorOftypespec *const typespecs_ = object->Typespecs()) {
    enterTypespecs(object, *typespecs_);
    for (VectorOftypespec::const_reference element : *typespecs_) {
      listenAny(element);
    }
    leaveTypespecs(object, *typespecs_);
  }
  if (const VectorOfany *const instance_items_ = object->Instance_items()) {
    enterInstance_items(object, *instance_items_);
    for (VectorOfany::const_reference element : *instance_items_) {
      listenAny(element);
    }
    leaveInstance_items(object, *instance_items_);
  }
  if (const VectorOflet_decl *const let_decls_ = object->Let_decls()) {
    enterLet_decls(object, *let_decls_);
    for (VectorOflet_decl::const_reference element : *let_decls_) {
      listenAny(element);
    }
    leaveLet_decls(object, *let_decls_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenBegin_(const begin* const object) {
  listenScope_(object);
  if (const VectorOfany *const stmts_ = object->Stmts()) {
    enterStmts(object, *stmts_);
    for (VectorOfany::const_reference element : *stmts_) {
      listenAny(element);
    }
    leaveStmts(object, *stmts_);
  }
}

void UhdmListener::listenNamed_begin_(const named_begin* const object) {
  listenScope_(object);
  if (const VectorOfany *const stmts_ = object->Stmts()) {
    enterStmts(object, *stmts_);
    for (VectorOfany::const_reference element : *stmts_) {
      listenAny(element);
    }
    leaveStmts(object, *stmts_);
  }
}

void UhdmListener::listenNamed_fork_(const named_fork* const object) {
  listenScope_(object);
  if (const VectorOfany *const stmts_ = object->Stmts()) {
    enterStmts(object, *stmts_);
    for (VectorOfany::const_reference element : *stmts_) {
      listenAny(element);
    }
    leaveStmts(object, *stmts_);
  }
}

void UhdmListener::listenFork_stmt_(const fork_stmt* const object) {
  listenScope_(object);
  if (const VectorOfany *const stmts_ = object->Stmts()) {
    enterStmts(object, *stmts_);
    for (VectorOfany::const_reference element : *stmts_) {
      listenAny(element);
    }
    leaveStmts(object, *stmts_);
  }
}

void UhdmListener::listenFor_stmt_(const for_stmt* const object) {
  listenScope_(object);
  if (const VectorOfany *const vpiForInitStmts_ = object->VpiForInitStmts()) {
    enterVpiForInitStmts(object, *vpiForInitStmts_);
    for (VectorOfany::const_reference element : *vpiForInitStmts_) {
      listenAny(element);
    }
    leaveVpiForInitStmts(object, *vpiForInitStmts_);
  }
  if (const VectorOfany *const vpiForIncStmts_ = object->VpiForIncStmts()) {
    enterVpiForIncStmts(object, *vpiForIncStmts_);
    for (VectorOfany::const_reference element : *vpiForIncStmts_) {
      listenAny(element);
    }
    leaveVpiForIncStmts(object, *vpiForIncStmts_);
  }
  if (const any *const vpiForInitStmt_ = object->VpiForInitStmt()) {
    listenAny(vpiForInitStmt_);
  }
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiForIncStmt_ = object->VpiForIncStmt()) {
    listenAny(vpiForIncStmt_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenIf_stmt_(const if_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenEvent_stmt_(const event_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const named_event_ = object->Named_event()) {
    listenAny(named_event_);
  }
}

void UhdmListener::listenThread_obj_(const thread_obj* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenForever_stmt_(const forever_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenWaits_(const waits* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenWait_stmt_(const wait_stmt* const object) {
  listenWaits_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
}

void UhdmListener::listenWait_fork_(const wait_fork* const object) {
  listenWaits_(object);
}

void UhdmListener::listenOrdered_wait_(const ordered_wait* const object) {
  listenWaits_(object);
  if (const VectorOfany *const vpiConditions_ = object->VpiConditions()) {
    enterVpiConditions(object, *vpiConditions_);
    for (VectorOfany::const_reference element : *vpiConditions_) {
      listenAny(element);
    }
    leaveVpiConditions(object, *vpiConditions_);
  }
  if (const any *const vpiElseStmt_ = object->VpiElseStmt()) {
    listenAny(vpiElseStmt_);
  }
}

void UhdmListener::listenDisables_(const disables* const object) {
  listenAtomic_stmt_(object);
}

void UhdmListener::listenDisable_(const disable* const object) {
  listenDisables_(object);
  if (const any *const vpiExpr_ = object->VpiExpr()) {
    listenAny(vpiExpr_);
  }
}

void UhdmListener::listenDisable_fork_(const disable_fork* const object) {
  listenDisables_(object);
}

void UhdmListener::listenContinue_stmt_(const continue_stmt* const object) {
  listenAtomic_stmt_(object);
}

void UhdmListener::listenBreak_stmt_(const break_stmt* const object) {
  listenAtomic_stmt_(object);
}

void UhdmListener::listenReturn_stmt_(const return_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
}

void UhdmListener::listenWhile_stmt_(const while_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenRepeat_(const repeat* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenDo_while_(const do_while* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenIf_else_(const if_else* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
  if (const any *const vpiElseStmt_ = object->VpiElseStmt()) {
    listenAny(vpiElseStmt_);
  }
}

void UhdmListener::listenCase_stmt_(const case_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const VectorOfcase_item *const case_items_ = object->Case_items()) {
    enterCase_items(object, *case_items_);
    for (VectorOfcase_item::const_reference element : *case_items_) {
      listenAny(element);
    }
    leaveCase_items(object, *case_items_);
  }
}

void UhdmListener::listenForce_(const force* const object) {
  listenAtomic_stmt_(object);
  if (const any *const rhs_ = object->Rhs()) {
    listenAny(rhs_);
  }
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
}

void UhdmListener::listenAssign_stmt_(const assign_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const rhs_ = object->Rhs()) {
    listenAny(rhs_);
  }
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
}

void UhdmListener::listenDeassign_(const deassign* const object) {
  listenAtomic_stmt_(object);
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
}

void UhdmListener::listenRelease_(const release* const object) {
  listenAtomic_stmt_(object);
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
}

void UhdmListener::listenNull_stmt_(const null_stmt* const object) {
  listenAtomic_stmt_(object);
}

void UhdmListener::listenExpect_stmt_(const expect_stmt* const object) {
  listenAtomic_stmt_(object);
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const else_stmt_ = object->Else_stmt()) {
    listenAny(else_stmt_);
  }
  if (const any *const property_spec_ = object->Property_spec()) {
    listenAny(property_spec_);
  }
}

void UhdmListener::listenForeach_stmt_(const foreach_stmt* const object) {
  listenScope_(object);
  if (const any *const variable_ = object->Variable()) {
    listenAny(variable_);
  }
  if (const VectorOfany *const vpiLoopVars_ = object->VpiLoopVars()) {
    enterVpiLoopVars(object, *vpiLoopVars_);
    for (VectorOfany::const_reference element : *vpiLoopVars_) {
      listenAny(element);
    }
    leaveVpiLoopVars(object, *vpiLoopVars_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenGen_scope_(const gen_scope* const object) {
  listenScope_(object);
  if (const any *const vpiIndex_ = object->VpiIndex()) {
    listenAny(vpiIndex_);
  }
  if (const VectorOfnet *const nets_ = object->Nets()) {
    enterNets(object, *nets_);
    for (VectorOfnet::const_reference element : *nets_) {
      listenAny(element);
    }
    leaveNets(object, *nets_);
  }
  if (const VectorOfarray_net *const array_nets_ = object->Array_nets()) {
    enterArray_nets(object, *array_nets_);
    for (VectorOfarray_net::const_reference element : *array_nets_) {
      listenAny(element);
    }
    leaveArray_nets(object, *array_nets_);
  }
  if (const VectorOfprocess_stmt *const process_ = object->Process()) {
    enterProcess(object, *process_);
    for (VectorOfprocess_stmt::const_reference element : *process_) {
      listenAny(element);
    }
    leaveProcess(object, *process_);
  }
  if (const VectorOfcont_assign *const cont_assigns_ = object->Cont_assigns()) {
    enterCont_assigns(object, *cont_assigns_);
    for (VectorOfcont_assign::const_reference element : *cont_assigns_) {
      listenAny(element);
    }
    leaveCont_assigns(object, *cont_assigns_);
  }
  if (const VectorOfmodule_inst *const modules_ = object->Modules()) {
    enterModules(object, *modules_);
    for (VectorOfmodule_inst::const_reference element : *modules_) {
      listenAny(element);
    }
    leaveModules(object, *modules_);
  }
  if (const VectorOfmodule_array *const module_arrays_ = object->Module_arrays()) {
    enterModule_arrays(object, *module_arrays_);
    for (VectorOfmodule_array::const_reference element : *module_arrays_) {
      listenAny(element);
    }
    leaveModule_arrays(object, *module_arrays_);
  }
  if (const VectorOfprimitive *const primitives_ = object->Primitives()) {
    enterPrimitives(object, *primitives_);
    for (VectorOfprimitive::const_reference element : *primitives_) {
      listenAny(element);
    }
    leavePrimitives(object, *primitives_);
  }
  if (const VectorOfprimitive_array *const primitive_arrays_ = object->Primitive_arrays()) {
    enterPrimitive_arrays(object, *primitive_arrays_);
    for (VectorOfprimitive_array::const_reference element : *primitive_arrays_) {
      listenAny(element);
    }
    leavePrimitive_arrays(object, *primitive_arrays_);
  }
  if (const VectorOfdef_param *const def_params_ = object->Def_params()) {
    enterDef_params(object, *def_params_);
    for (VectorOfdef_param::const_reference element : *def_params_) {
      listenAny(element);
    }
    leaveDef_params(object, *def_params_);
  }
  if (const VectorOfgen_scope_array *const gen_scope_arrays_ = object->Gen_scope_arrays()) {
    enterGen_scope_arrays(object, *gen_scope_arrays_);
    for (VectorOfgen_scope_array::const_reference element : *gen_scope_arrays_) {
      listenAny(element);
    }
    leaveGen_scope_arrays(object, *gen_scope_arrays_);
  }
  if (const VectorOfprogram *const programs_ = object->Programs()) {
    enterPrograms(object, *programs_);
    for (VectorOfprogram::const_reference element : *programs_) {
      listenAny(element);
    }
    leavePrograms(object, *programs_);
  }
  if (const VectorOfprogram *const program_arrays_ = object->Program_arrays()) {
    enterProgram_arrays(object, *program_arrays_);
    for (VectorOfprogram::const_reference element : *program_arrays_) {
      listenAny(element);
    }
    leaveProgram_arrays(object, *program_arrays_);
  }
  if (const VectorOfany *const assertions_ = object->Assertions()) {
    enterAssertions(object, *assertions_);
    for (VectorOfany::const_reference element : *assertions_) {
      listenAny(element);
    }
    leaveAssertions(object, *assertions_);
  }
  if (const VectorOfinterface_inst *const interfaces_ = object->Interfaces()) {
    enterInterfaces(object, *interfaces_);
    for (VectorOfinterface_inst::const_reference element : *interfaces_) {
      listenAny(element);
    }
    leaveInterfaces(object, *interfaces_);
  }
  if (const VectorOfinterface_array *const interface_arrays_ = object->Interface_arrays()) {
    enterInterface_arrays(object, *interface_arrays_);
    for (VectorOfinterface_array::const_reference element : *interface_arrays_) {
      listenAny(element);
    }
    leaveInterface_arrays(object, *interface_arrays_);
  }
  if (const VectorOfalias_stmt *const alias_stmts_ = object->Alias_stmts()) {
    enterAlias_stmts(object, *alias_stmts_);
    for (VectorOfalias_stmt::const_reference element : *alias_stmts_) {
      listenAny(element);
    }
    leaveAlias_stmts(object, *alias_stmts_);
  }
  if (const VectorOfclocking_block *const clocking_blocks_ = object->Clocking_blocks()) {
    enterClocking_blocks(object, *clocking_blocks_);
    for (VectorOfclocking_block::const_reference element : *clocking_blocks_) {
      listenAny(element);
    }
    leaveClocking_blocks(object, *clocking_blocks_);
  }
  if (const VectorOftask_func *const task_funcs_ = object->Task_funcs()) {
    enterTask_funcs(object, *task_funcs_);
    for (VectorOftask_func::const_reference element : *task_funcs_) {
      listenAny(element);
    }
    leaveTask_funcs(object, *task_funcs_);
  }
  if (const VectorOftf_call *const elab_tasks_ = object->Elab_tasks()) {
    enterElab_tasks(object, *elab_tasks_);
    for (VectorOftf_call::const_reference element : *elab_tasks_) {
      listenAny(element);
    }
    leaveElab_tasks(object, *elab_tasks_);
  }
}

void UhdmListener::listenGen_var_(const gen_var* const object) {
  listenBaseClass_(object);
  if (const VectorOfgen_scope_array *const gen_scope_arrays_ = object->Gen_scope_arrays()) {
    enterGen_scope_arrays(object, *gen_scope_arrays_);
    for (VectorOfgen_scope_array::const_reference element : *gen_scope_arrays_) {
      listenAny(element);
    }
    leaveGen_scope_arrays(object, *gen_scope_arrays_);
  }
}

void UhdmListener::listenGen_scope_array_(const gen_scope_array* const object) {
  listenBaseClass_(object);
  if (const any *const gen_var_ = object->Gen_var()) {
    listenAny(gen_var_);
  }
  if (const VectorOfgen_scope *const gen_scopes_ = object->Gen_scopes()) {
    enterGen_scopes(object, *gen_scopes_);
    for (VectorOfgen_scope::const_reference element : *gen_scopes_) {
      listenAny(element);
    }
    leaveGen_scopes(object, *gen_scopes_);
  }
  if (const any *const vpiInstance_ = object->VpiInstance()) {
    listenAny(vpiInstance_);
  }
}

void UhdmListener::listenAssert_stmt_(const assert_stmt* const object) {
  listenConcurrent_assertions_(object);
  if (const any *const else_stmt_ = object->Else_stmt()) {
    listenAny(else_stmt_);
  }
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenCover_(const cover* const object) {
  listenConcurrent_assertions_(object);
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenAssume_(const assume* const object) {
  listenConcurrent_assertions_(object);
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenRestrict_(const restrict* const object) {
  listenConcurrent_assertions_(object);
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenImmediate_assert_(const immediate_assert* const object) {
  listenAtomic_stmt_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const else_stmt_ = object->Else_stmt()) {
    listenAny(else_stmt_);
  }
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenImmediate_assume_(const immediate_assume* const object) {
  listenAtomic_stmt_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const else_stmt_ = object->Else_stmt()) {
    listenAny(else_stmt_);
  }
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenImmediate_cover_(const immediate_cover* const object) {
  listenAtomic_stmt_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenExpr_(const expr* const object) {
  listenBaseClass_(object);
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
}

void UhdmListener::listenCase_item_(const case_item* const object) {
  listenBaseClass_(object);
  if (const VectorOfany *const vpiExprs_ = object->VpiExprs()) {
    enterVpiExprs(object, *vpiExprs_);
    for (VectorOfany::const_reference element : *vpiExprs_) {
      listenAny(element);
    }
    leaveVpiExprs(object, *vpiExprs_);
  }
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
}

void UhdmListener::listenAssignment_(const assignment* const object) {
  listenAtomic_stmt_(object);
  if (const any *const rhs_ = object->Rhs()) {
    listenAny(rhs_);
  }
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
  if (const any *const delay_control_ = object->Delay_control()) {
    listenAny(delay_control_);
  }
  if (const any *const event_control_ = object->Event_control()) {
    listenAny(event_control_);
  }
  if (const any *const repeat_control_ = object->Repeat_control()) {
    listenAny(repeat_control_);
  }
}

void UhdmListener::listenAny_pattern_(const any_pattern* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenTagged_pattern_(const tagged_pattern* const object) {
  listenBaseClass_(object);
  if (const any *const pattern_ = object->Pattern()) {
    listenAny(pattern_);
  }
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
}

void UhdmListener::listenStruct_pattern_(const struct_pattern* const object) {
  listenBaseClass_(object);
  if (const any *const pattern_ = object->Pattern()) {
    listenAny(pattern_);
  }
}

void UhdmListener::listenUnsupported_expr_(const unsupported_expr* const object) {
  listenExpr_(object);
}

void UhdmListener::listenUnsupported_stmt_(const unsupported_stmt* const object) {
  listenAtomic_stmt_(object);
}

void UhdmListener::listenInclude_file_info_(const include_file_info* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenSequence_inst_(const sequence_inst* const object) {
  listenBaseClass_(object);
  if (const any *const sequence_decl_ = object->Sequence_decl()) {
    listenAny(sequence_decl_);
  }
  if (const VectorOfany *const named_event_sequence_expr_groups_ = object->Named_event_sequence_expr_groups()) {
    enterNamed_event_sequence_expr_groups(object, *named_event_sequence_expr_groups_);
    for (VectorOfany::const_reference element : *named_event_sequence_expr_groups_) {
      listenAny(element);
    }
    leaveNamed_event_sequence_expr_groups(object, *named_event_sequence_expr_groups_);
  }
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenSeq_formal_decl_(const seq_formal_decl* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const any *const named_event_sequence_expr_group_ = object->Named_event_sequence_expr_group()) {
    listenAny(named_event_sequence_expr_group_);
  }
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
}

void UhdmListener::listenSequence_decl_(const sequence_decl* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const VectorOfvariables *const variables_ = object->Variables()) {
    enterVariables(object, *variables_);
    for (VectorOfvariables::const_reference element : *variables_) {
      listenAny(element);
    }
    leaveVariables(object, *variables_);
  }
  if (const any *const sequence_expr_multiclock_group_ = object->Sequence_expr_multiclock_group()) {
    listenAny(sequence_expr_multiclock_group_);
  }
  if (const VectorOfseq_formal_decl *const seq_formal_decls_ = object->Seq_formal_decls()) {
    enterSeq_formal_decls(object, *seq_formal_decls_);
    for (VectorOfseq_formal_decl::const_reference element : *seq_formal_decls_) {
      listenAny(element);
    }
    leaveSeq_formal_decls(object, *seq_formal_decls_);
  }
}

void UhdmListener::listenProp_formal_decl_(const prop_formal_decl* const object) {
  listenBaseClass_(object);
  if (const any *const vpiExpr_ = object->VpiExpr()) {
    listenAny(vpiExpr_);
  }
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
}

void UhdmListener::listenProperty_inst_(const property_inst* const object) {
  listenBaseClass_(object);
  if (const any *const vpiDisableCondition_ = object->VpiDisableCondition()) {
    listenAny(vpiDisableCondition_);
  }
  if (const VectorOfany *const vpiArguments_ = object->VpiArguments()) {
    enterVpiArguments(object, *vpiArguments_);
    for (VectorOfany::const_reference element : *vpiArguments_) {
      listenAny(element);
    }
    leaveVpiArguments(object, *vpiArguments_);
  }
  if (const any *const property_decl_ = object->Property_decl()) {
    listenAny(property_decl_);
  }
  if (const any *const clocking_block_ = object->Clocking_block()) {
    listenAny(clocking_block_);
  }
}

void UhdmListener::listenProperty_spec_(const property_spec* const object) {
  listenBaseClass_(object);
  if (const any *const vpiDisableCondition_ = object->VpiDisableCondition()) {
    listenAny(vpiDisableCondition_);
  }
  if (const any *const vpiClockingEvent_ = object->VpiClockingEvent()) {
    listenAny(vpiClockingEvent_);
  }
  if (const any *const vpiPropertyExpr_ = object->VpiPropertyExpr()) {
    listenAny(vpiPropertyExpr_);
  }
}

void UhdmListener::listenProperty_decl_(const property_decl* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const VectorOfprop_formal_decl *const prop_formal_decls_ = object->Prop_formal_decls()) {
    enterProp_formal_decls(object, *prop_formal_decls_);
    for (VectorOfprop_formal_decl::const_reference element : *prop_formal_decls_) {
      listenAny(element);
    }
    leaveProp_formal_decls(object, *prop_formal_decls_);
  }
  if (const VectorOfvariables *const variables_ = object->Variables()) {
    enterVariables(object, *variables_);
    for (VectorOfvariables::const_reference element : *variables_) {
      listenAny(element);
    }
    leaveVariables(object, *variables_);
  }
  if (const any *const property_spec_ = object->Property_spec()) {
    listenAny(property_spec_);
  }
}

void UhdmListener::listenClocked_property_(const clocked_property* const object) {
  listenBaseClass_(object);
  if (const any *const vpiClockingEvent_ = object->VpiClockingEvent()) {
    listenAny(vpiClockingEvent_);
  }
  if (const any *const vpiPropertyExpr_ = object->VpiPropertyExpr()) {
    listenAny(vpiPropertyExpr_);
  }
}

void UhdmListener::listenCase_property_item_(const case_property_item* const object) {
  listenBaseClass_(object);
  if (const VectorOfexpr *const expressions_ = object->Expressions()) {
    enterExpressions(object, *expressions_);
    for (VectorOfexpr::const_reference element : *expressions_) {
      listenAny(element);
    }
    leaveExpressions(object, *expressions_);
  }
  if (const any *const property_expr_ = object->Property_expr()) {
    listenAny(property_expr_);
  }
}

void UhdmListener::listenCase_property_(const case_property* const object) {
  listenBaseClass_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const VectorOfcase_property_item *const case_property_items_ = object->Case_property_items()) {
    enterCase_property_items(object, *case_property_items_);
    for (VectorOfcase_property_item::const_reference element : *case_property_items_) {
      listenAny(element);
    }
    leaveCase_property_items(object, *case_property_items_);
  }
}

void UhdmListener::listenMulticlock_sequence_expr_(const multiclock_sequence_expr* const object) {
  listenBaseClass_(object);
  if (const VectorOfclocked_seq *const clocked_seqs_ = object->Clocked_seqs()) {
    enterClocked_seqs(object, *clocked_seqs_);
    for (VectorOfclocked_seq::const_reference element : *clocked_seqs_) {
      listenAny(element);
    }
    leaveClocked_seqs(object, *clocked_seqs_);
  }
}

void UhdmListener::listenClocked_seq_(const clocked_seq* const object) {
  listenBaseClass_(object);
  if (const any *const vpiClockingEvent_ = object->VpiClockingEvent()) {
    listenAny(vpiClockingEvent_);
  }
  if (const any *const vpiSequenceExpr_ = object->VpiSequenceExpr()) {
    listenAny(vpiSequenceExpr_);
  }
}

void UhdmListener::listenSimple_expr_(const simple_expr* const object) {
  listenExpr_(object);
  if (const VectorOfany *const vpiUses_ = object->VpiUses()) {
    enterVpiUses(object, *vpiUses_);
    for (VectorOfany::const_reference element : *vpiUses_) {
      listenAny(element);
    }
    leaveVpiUses(object, *vpiUses_);
  }
}

void UhdmListener::listenConstant_(const constant* const object) {
  listenExpr_(object);
}

void UhdmListener::listenLet_expr_(const let_expr* const object) {
  listenExpr_(object);
  if (const VectorOfexpr *const arguments_ = object->Arguments()) {
    enterArguments(object, *arguments_);
    for (VectorOfexpr::const_reference element : *arguments_) {
      listenAny(element);
    }
    leaveArguments(object, *arguments_);
  }
  if (const any *const let_decl_ = object->Let_decl()) {
    listenAny(let_decl_);
  }
}

void UhdmListener::listenOperation_(const operation* const object) {
  listenExpr_(object);
  if (const VectorOfany *const operands_ = object->Operands()) {
    enterOperands(object, *operands_);
    for (VectorOfany::const_reference element : *operands_) {
      listenAny(element);
    }
    leaveOperands(object, *operands_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenRef_obj_(const ref_obj* const object) {
  listenSimple_expr_(object);
  if (const any *const actual_group_ = object->Actual_group()) {
    listenAny(actual_group_);
  }
}

void UhdmListener::listenRef_module_(const ref_module* const object) {
  listenBaseClass_(object);
  if (const any *const actual_group_ = object->Actual_group()) {
    listenAny(actual_group_);
  }
  if (const VectorOfport *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfport::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
}

void UhdmListener::listenRef_typespec_(const ref_typespec* const object) {
  listenSimple_expr_(object);
  if (const any *const actual_typespec_ = object->Actual_typespec()) {
    listenAny(actual_typespec_);
  }
}

void UhdmListener::listenPart_select_(const part_select* const object) {
  listenRef_obj_(object);
  if (const any *const left_range_ = object->Left_range()) {
    listenAny(left_range_);
  }
  if (const any *const right_range_ = object->Right_range()) {
    listenAny(right_range_);
  }
}

void UhdmListener::listenIndexed_part_select_(const indexed_part_select* const object) {
  listenRef_obj_(object);
  if (const any *const base_expr_ = object->Base_expr()) {
    listenAny(base_expr_);
  }
  if (const any *const width_expr_ = object->Width_expr()) {
    listenAny(width_expr_);
  }
}

void UhdmListener::listenVar_select_(const var_select* const object) {
  listenRef_obj_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const VectorOfexpr *const exprs_ = object->Exprs()) {
    enterExprs(object, *exprs_);
    for (VectorOfexpr::const_reference element : *exprs_) {
      listenAny(element);
    }
    leaveExprs(object, *exprs_);
  }
}

void UhdmListener::listenBit_select_(const bit_select* const object) {
  listenRef_obj_(object);
  if (const any *const vpiIndex_ = object->VpiIndex()) {
    listenAny(vpiIndex_);
  }
}

void UhdmListener::listenVariables_(const variables* const object) {
  listenSimple_expr_(object);
  if (const VectorOfports *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfports::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
  if (const VectorOfany *const variable_drivers_ = object->Variable_drivers()) {
    enterVariable_drivers(object, *variable_drivers_);
    for (VectorOfany::const_reference element : *variable_drivers_) {
      listenAny(element);
    }
    leaveVariable_drivers(object, *variable_drivers_);
  }
  if (const VectorOfany *const variable_loads_ = object->Variable_loads()) {
    enterVariable_loads(object, *variable_loads_);
    for (VectorOfany::const_reference element : *variable_loads_) {
      listenAny(element);
    }
    leaveVariable_loads(object, *variable_loads_);
  }
  if (const VectorOfprim_term *const prim_terms_ = object->Prim_terms()) {
    enterPrim_terms(object, *prim_terms_);
    for (VectorOfprim_term::const_reference element : *prim_terms_) {
      listenAny(element);
    }
    leavePrim_terms(object, *prim_terms_);
  }
  if (const VectorOfcont_assign *const cont_assigns_ = object->Cont_assigns()) {
    enterCont_assigns(object, *cont_assigns_);
    for (VectorOfcont_assign::const_reference element : *cont_assigns_) {
      listenAny(element);
    }
    leaveCont_assigns(object, *cont_assigns_);
  }
  if (const any *const path_term_ = object->Path_term()) {
    listenAny(path_term_);
  }
  if (const any *const tchk_term_ = object->Tchk_term()) {
    listenAny(tchk_term_);
  }
  if (const any *const module_inst_ = object->Module_inst()) {
    listenAny(module_inst_);
  }
  if (const any *const instance_ = object->Instance()) {
    listenAny(instance_);
  }
  if (const any *const scope_ = object->Scope()) {
    listenAny(scope_);
  }
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const VectorOfexpr *const indexes_ = object->Indexes()) {
    enterIndexes(object, *indexes_);
    for (VectorOfexpr::const_reference element : *indexes_) {
      listenAny(element);
    }
    leaveIndexes(object, *indexes_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenHier_path_(const hier_path* const object) {
  listenSimple_expr_(object);
  if (const VectorOfany *const path_elems_ = object->Path_elems()) {
    enterPath_elems(object, *path_elems_);
    for (VectorOfany::const_reference element : *path_elems_) {
      listenAny(element);
    }
    leavePath_elems(object, *path_elems_);
  }
  if (const any *const root_value_ = object->Root_value()) {
    listenAny(root_value_);
  }
}

void UhdmListener::listenRef_var_(const ref_var* const object) {
  listenVariables_(object);
  if (const any *const actual_group_ = object->Actual_group()) {
    listenAny(actual_group_);
  }
  if (const any *const task_func_ = object->Task_func()) {
    listenAny(task_func_);
  }
}

void UhdmListener::listenShort_real_var_(const short_real_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenReal_var_(const real_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenByte_var_(const byte_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenShort_int_var_(const short_int_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenInt_var_(const int_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenLong_int_var_(const long_int_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenInteger_var_(const integer_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenTime_var_(const time_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenArray_var_(const array_var* const object) {
  listenVariables_(object);
  if (const VectorOfvar_select *const var_selects_ = object->Var_selects()) {
    enterVar_selects(object, *var_selects_);
    for (VectorOfvar_select::const_reference element : *var_selects_) {
      listenAny(element);
    }
    leaveVar_selects(object, *var_selects_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfvariables *const variables_ = object->Variables()) {
    enterVariables(object, *variables_);
    for (VectorOfvariables::const_reference element : *variables_) {
      listenAny(element);
    }
    leaveVariables(object, *variables_);
  }
}

void UhdmListener::listenArray_expr_(const array_expr* const object) {
  listenExpr_(object);
  if (const VectorOfexpr *const exprs_ = object->Exprs()) {
    enterExprs(object, *exprs_);
    for (VectorOfexpr::const_reference element : *exprs_) {
      listenAny(element);
    }
    leaveExprs(object, *exprs_);
  }
}

void UhdmListener::listenReg_array_(const reg_array* const object) {
  listenBaseClass_(object);
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfreg *const regs_ = object->Regs()) {
    enterRegs(object, *regs_);
    for (VectorOfreg::const_reference element : *regs_) {
      listenAny(element);
    }
    leaveRegs(object, *regs_);
  }
}

void UhdmListener::listenReg_(const reg* const object) {
  listenBaseClass_(object);
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const any *const index_ = object->Index()) {
    listenAny(index_);
  }
}

void UhdmListener::listenPacked_array_var_(const packed_array_var* const object) {
  listenVariables_(object);
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfvar_bit *const var_bits_ = object->Var_bits()) {
    enterVar_bits(object, *var_bits_);
    for (VectorOfvar_bit::const_reference element : *var_bits_) {
      listenAny(element);
    }
    leaveVar_bits(object, *var_bits_);
  }
  if (const VectorOfany *const elements_ = object->Elements()) {
    enterElements(object, *elements_);
    for (VectorOfany::const_reference element : *elements_) {
      listenAny(element);
    }
    leaveElements(object, *elements_);
  }
  if (const any *const expr_index_ = object->Expr_index()) {
    listenAny(expr_index_);
  }
}

void UhdmListener::listenBit_var_(const bit_var* const object) {
  listenVariables_(object);
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfvar_bit *const var_bits_ = object->Var_bits()) {
    enterVar_bits(object, *var_bits_);
    for (VectorOfvar_bit::const_reference element : *var_bits_) {
      listenAny(element);
    }
    leaveVar_bits(object, *var_bits_);
  }
}

void UhdmListener::listenLogic_var_(const logic_var* const object) {
  listenVariables_(object);
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfvar_bit *const var_bits_ = object->Var_bits()) {
    enterVar_bits(object, *var_bits_);
    for (VectorOfvar_bit::const_reference element : *var_bits_) {
      listenAny(element);
    }
    leaveVar_bits(object, *var_bits_);
  }
}

void UhdmListener::listenStruct_var_(const struct_var* const object) {
  listenVariables_(object);
  if (const VectorOfvar_bit *const var_bits_ = object->Var_bits()) {
    enterVar_bits(object, *var_bits_);
    for (VectorOfvar_bit::const_reference element : *var_bits_) {
      listenAny(element);
    }
    leaveVar_bits(object, *var_bits_);
  }
  if (const VectorOfvariables *const variables_ = object->Variables()) {
    enterVariables(object, *variables_);
    for (VectorOfvariables::const_reference element : *variables_) {
      listenAny(element);
    }
    leaveVariables(object, *variables_);
  }
  if (const any *const expr_index_ = object->Expr_index()) {
    listenAny(expr_index_);
  }
}

void UhdmListener::listenUnion_var_(const union_var* const object) {
  listenVariables_(object);
  if (const VectorOfvar_bit *const var_bits_ = object->Var_bits()) {
    enterVar_bits(object, *var_bits_);
    for (VectorOfvar_bit::const_reference element : *var_bits_) {
      listenAny(element);
    }
    leaveVar_bits(object, *var_bits_);
  }
  if (const VectorOfvariables *const variables_ = object->Variables()) {
    enterVariables(object, *variables_);
    for (VectorOfvariables::const_reference element : *variables_) {
      listenAny(element);
    }
    leaveVariables(object, *variables_);
  }
  if (const any *const expr_index_ = object->Expr_index()) {
    listenAny(expr_index_);
  }
}

void UhdmListener::listenEnum_var_(const enum_var* const object) {
  listenVariables_(object);
  if (const any *const expr_index_ = object->Expr_index()) {
    listenAny(expr_index_);
  }
}

void UhdmListener::listenString_var_(const string_var* const object) {
  listenVariables_(object);
}

void UhdmListener::listenChandle_var_(const chandle_var* const object) {
  listenVariables_(object);
  if (const any *const actual_group_ = object->Actual_group()) {
    listenAny(actual_group_);
  }
}

void UhdmListener::listenVar_bit_(const var_bit* const object) {
  listenVariables_(object);
  if (const any *const expr_index_ = object->Expr_index()) {
    listenAny(expr_index_);
  }
  if (const VectorOfexpr *const expr_indexes_ = object->Expr_indexes()) {
    enterExpr_indexes(object, *expr_indexes_);
    for (VectorOfexpr::const_reference element : *expr_indexes_) {
      listenAny(element);
    }
    leaveExpr_indexes(object, *expr_indexes_);
  }
}

void UhdmListener::listenTask_func_(const task_func* const object) {
  listenScope_(object);
  if (const any *const left_range_ = object->Left_range()) {
    listenAny(left_range_);
  }
  if (const any *const right_range_ = object->Right_range()) {
    listenAny(right_range_);
  }
  if (const any *const return_ = object->Return()) {
    listenAny(return_);
  }
  if (const any *const class_defn_ = object->Class_defn()) {
    listenAny(class_defn_);
  }
  if (const VectorOfio_decl *const io_decls_ = object->Io_decls()) {
    enterIo_decls(object, *io_decls_);
    for (VectorOfio_decl::const_reference element : *io_decls_) {
      listenAny(element);
    }
    leaveIo_decls(object, *io_decls_);
  }
  if (const any *const stmt_ = object->Stmt()) {
    listenAny(stmt_);
  }
  if (const any *const instance_ = object->Instance()) {
    listenAny(instance_);
  }
}

void UhdmListener::listenTask_(const task* const object) {
  listenTask_func_(object);
}

void UhdmListener::listenFunction_(const function* const object) {
  listenTask_func_(object);
}

void UhdmListener::listenModport_(const modport* const object) {
  listenBaseClass_(object);
  if (const VectorOfio_decl *const io_decls_ = object->Io_decls()) {
    enterIo_decls(object, *io_decls_);
    for (VectorOfio_decl::const_reference element : *io_decls_) {
      listenAny(element);
    }
    leaveIo_decls(object, *io_decls_);
  }
  if (const any *const interface_inst_ = object->Interface_inst()) {
    listenAny(interface_inst_);
  }
}

void UhdmListener::listenInterface_tf_decl_(const interface_tf_decl* const object) {
  listenBaseClass_(object);
  if (const VectorOftask *const tasks_ = object->Tasks()) {
    enterTasks(object, *tasks_);
    for (VectorOftask::const_reference element : *tasks_) {
      listenAny(element);
    }
    leaveTasks(object, *tasks_);
  }
  if (const VectorOffunction *const functions_ = object->Functions()) {
    enterFunctions(object, *functions_);
    for (VectorOffunction::const_reference element : *functions_) {
      listenAny(element);
    }
    leaveFunctions(object, *functions_);
  }
}

void UhdmListener::listenCont_assign_(const cont_assign* const object) {
  listenBaseClass_(object);
  if (const any *const delay_ = object->Delay()) {
    listenAny(delay_);
  }
  if (const any *const rhs_ = object->Rhs()) {
    listenAny(rhs_);
  }
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
  if (const VectorOfcont_assign_bit *const cont_assign_bits_ = object->Cont_assign_bits()) {
    enterCont_assign_bits(object, *cont_assign_bits_);
    for (VectorOfcont_assign_bit::const_reference element : *cont_assign_bits_) {
      listenAny(element);
    }
    leaveCont_assign_bits(object, *cont_assign_bits_);
  }
}

void UhdmListener::listenCont_assign_bit_(const cont_assign_bit* const object) {
  listenBaseClass_(object);
  if (const any *const delay_ = object->Delay()) {
    listenAny(delay_);
  }
  if (const any *const rhs_ = object->Rhs()) {
    listenAny(rhs_);
  }
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
}

void UhdmListener::listenPorts_(const ports* const object) {
  listenBaseClass_(object);
  if (const any *const high_conn_ = object->High_conn()) {
    listenAny(high_conn_);
  }
  if (const any *const low_conn_ = object->Low_conn()) {
    listenAny(low_conn_);
  }
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
  if (const any *const instance_ = object->Instance()) {
    listenAny(instance_);
  }
  if (const any *const module_inst_ = object->Module_inst()) {
    listenAny(module_inst_);
  }
}

void UhdmListener::listenPort_(const port* const object) {
  listenPorts_(object);
  if (const VectorOfport_bit *const bits_ = object->Bits()) {
    enterBits(object, *bits_);
    for (VectorOfport_bit::const_reference element : *bits_) {
      listenAny(element);
    }
    leaveBits(object, *bits_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenPort_bit_(const port_bit* const object) {
  listenPorts_(object);
}

void UhdmListener::listenChecker_port_(const checker_port* const object) {
  listenPorts_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const any *const property_ = object->Property()) {
    listenAny(property_);
  }
  if (const any *const sequence_ = object->Sequence()) {
    listenAny(sequence_);
  }
}

void UhdmListener::listenChecker_inst_port_(const checker_inst_port* const object) {
  listenBaseClass_(object);
  if (const any *const property_ = object->Property()) {
    listenAny(property_);
  }
  if (const any *const sequence_ = object->Sequence()) {
    listenAny(sequence_);
  }
}

void UhdmListener::listenPrimitive_(const primitive* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const any *const delay_ = object->Delay()) {
    listenAny(delay_);
  }
  if (const any *const index_ = object->Index()) {
    listenAny(index_);
  }
  if (const VectorOfprim_term *const prim_terms_ = object->Prim_terms()) {
    enterPrim_terms(object, *prim_terms_);
    for (VectorOfprim_term::const_reference element : *prim_terms_) {
      listenAny(element);
    }
    leavePrim_terms(object, *prim_terms_);
  }
}

void UhdmListener::listenGate_(const gate* const object) {
  listenPrimitive_(object);
}

void UhdmListener::listenSwitch_tran_(const switch_tran* const object) {
  listenPrimitive_(object);
}

void UhdmListener::listenUdp_(const udp* const object) {
  listenPrimitive_(object);
  if (const any *const udp_defn_ = object->Udp_defn()) {
    listenAny(udp_defn_);
  }
}

void UhdmListener::listenMod_path_(const mod_path* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenTchk_(const tchk* const object) {
  listenBaseClass_(object);
  if (const any *const module_inst_ = object->Module_inst()) {
    listenAny(module_inst_);
  }
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const VectorOfany *const expr_tchk_terms_ = object->Expr_tchk_terms()) {
    enterExpr_tchk_terms(object, *expr_tchk_terms_);
    for (VectorOfany::const_reference element : *expr_tchk_terms_) {
      listenAny(element);
    }
    leaveExpr_tchk_terms(object, *expr_tchk_terms_);
  }
  if (const any *const tchk_ref_term_ = object->Tchk_ref_term()) {
    listenAny(tchk_ref_term_);
  }
  if (const any *const tchk_data_term_ = object->Tchk_data_term()) {
    listenAny(tchk_data_term_);
  }
  if (const any *const reg_ = object->Reg()) {
    listenAny(reg_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenRange_(const range* const object) {
  listenBaseClass_(object);
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
}

void UhdmListener::listenUdp_defn_(const udp_defn* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const VectorOfio_decl *const io_decls_ = object->Io_decls()) {
    enterIo_decls(object, *io_decls_);
    for (VectorOfio_decl::const_reference element : *io_decls_) {
      listenAny(element);
    }
    leaveIo_decls(object, *io_decls_);
  }
  if (const VectorOftable_entry *const table_entrys_ = object->Table_entrys()) {
    enterTable_entrys(object, *table_entrys_);
    for (VectorOftable_entry::const_reference element : *table_entrys_) {
      listenAny(element);
    }
    leaveTable_entrys(object, *table_entrys_);
  }
  if (const any *const initial_ = object->Initial()) {
    listenAny(initial_);
  }
}

void UhdmListener::listenTable_entry_(const table_entry* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenIo_decl_(const io_decl* const object) {
  listenBaseClass_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
}

void UhdmListener::listenAlias_stmt_(const alias_stmt* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenClocking_block_(const clocking_block* const object) {
  listenScope_(object);
  if (const any *const input_skew_ = object->Input_skew()) {
    listenAny(input_skew_);
  }
  if (const any *const output_skew_ = object->Output_skew()) {
    listenAny(output_skew_);
  }
  if (const any *const clocking_event_ = object->Clocking_event()) {
    listenAny(clocking_event_);
  }
  if (const any *const instance_ = object->Instance()) {
    listenAny(instance_);
  }
  if (const VectorOfclocking_io_decl *const clocking_io_decls_ = object->Clocking_io_decls()) {
    enterClocking_io_decls(object, *clocking_io_decls_);
    for (VectorOfclocking_io_decl::const_reference element : *clocking_io_decls_) {
      listenAny(element);
    }
    leaveClocking_io_decls(object, *clocking_io_decls_);
  }
  if (const any *const prefix_ = object->Prefix()) {
    listenAny(prefix_);
  }
  if (const any *const actual_ = object->Actual()) {
    listenAny(actual_);
  }
}

void UhdmListener::listenClocking_io_decl_(const clocking_io_decl* const object) {
  listenBaseClass_(object);
  if (const any *const input_skew_ = object->Input_skew()) {
    listenAny(input_skew_);
  }
  if (const any *const output_skew_ = object->Output_skew()) {
    listenAny(output_skew_);
  }
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
}

void UhdmListener::listenParam_assign_(const param_assign* const object) {
  listenBaseClass_(object);
  if (const any *const rhs_ = object->Rhs()) {
    listenAny(rhs_);
  }
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenInstance_array_(const instance_array* const object) {
  listenBaseClass_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfinstance *const instances_ = object->Instances()) {
    enterInstances(object, *instances_);
    for (VectorOfinstance::const_reference element : *instances_) {
      listenAny(element);
    }
    leaveInstances(object, *instances_);
  }
  if (const VectorOfmodule_inst *const modules_ = object->Modules()) {
    enterModules(object, *modules_);
    for (VectorOfmodule_inst::const_reference element : *modules_) {
      listenAny(element);
    }
    leaveModules(object, *modules_);
  }
  if (const any *const elem_typespec_ = object->Elem_typespec()) {
    listenAny(elem_typespec_);
  }
  if (const VectorOfport *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfport::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
}

void UhdmListener::listenInterface_array_(const interface_array* const object) {
  listenInstance_array_(object);
  if (const VectorOfparam_assign *const param_assigns_ = object->Param_assigns()) {
    enterParam_assigns(object, *param_assigns_);
    for (VectorOfparam_assign::const_reference element : *param_assigns_) {
      listenAny(element);
    }
    leaveParam_assigns(object, *param_assigns_);
  }
}

void UhdmListener::listenProgram_array_(const program_array* const object) {
  listenInstance_array_(object);
}

void UhdmListener::listenModule_array_(const module_array* const object) {
  listenInstance_array_(object);
  if (const VectorOfparam_assign *const param_assigns_ = object->Param_assigns()) {
    enterParam_assigns(object, *param_assigns_);
    for (VectorOfparam_assign::const_reference element : *param_assigns_) {
      listenAny(element);
    }
    leaveParam_assigns(object, *param_assigns_);
  }
}

void UhdmListener::listenPrimitive_array_(const primitive_array* const object) {
  listenInstance_array_(object);
  if (const any *const delay_ = object->Delay()) {
    listenAny(delay_);
  }
  if (const VectorOfprimitive *const primitives_ = object->Primitives()) {
    enterPrimitives(object, *primitives_);
    for (VectorOfprimitive::const_reference element : *primitives_) {
      listenAny(element);
    }
    leavePrimitives(object, *primitives_);
  }
}

void UhdmListener::listenGate_array_(const gate_array* const object) {
  listenPrimitive_array_(object);
}

void UhdmListener::listenSwitch_array_(const switch_array* const object) {
  listenPrimitive_array_(object);
}

void UhdmListener::listenUdp_array_(const udp_array* const object) {
  listenPrimitive_array_(object);
}

void UhdmListener::listenTypespec_(const typespec* const object) {
  listenBaseClass_(object);
  if (const any *const typedef_alias_ = object->Typedef_alias()) {
    listenAny(typedef_alias_);
  }
  if (const any *const instance_ = object->Instance()) {
    listenAny(instance_);
  }
}

void UhdmListener::listenPrim_term_(const prim_term* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
}

void UhdmListener::listenPath_term_(const path_term* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenTchk_term_(const tchk_term* const object) {
  listenBaseClass_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const any *const condition_ = object->Condition()) {
    listenAny(condition_);
  }
}

void UhdmListener::listenNets_(const nets* const object) {
  listenSimple_expr_(object);
  if (const VectorOfports *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfports::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
  if (const VectorOfnet_drivers *const drivers_ = object->Drivers()) {
    enterDrivers(object, *drivers_);
    for (VectorOfnet_drivers::const_reference element : *drivers_) {
      listenAny(element);
    }
    leaveDrivers(object, *drivers_);
  }
  if (const VectorOfnet_loads *const loads_ = object->Loads()) {
    enterLoads(object, *loads_);
    for (VectorOfnet_loads::const_reference element : *loads_) {
      listenAny(element);
    }
    leaveLoads(object, *loads_);
  }
  if (const VectorOfnet_drivers *const local_drivers_ = object->Local_drivers()) {
    enterLocal_drivers(object, *local_drivers_);
    for (VectorOfnet_drivers::const_reference element : *local_drivers_) {
      listenAny(element);
    }
    leaveLocal_drivers(object, *local_drivers_);
  }
  if (const VectorOfnet_loads *const local_loads_ = object->Local_loads()) {
    enterLocal_loads(object, *local_loads_);
    for (VectorOfnet_loads::const_reference element : *local_loads_) {
      listenAny(element);
    }
    leaveLocal_loads(object, *local_loads_);
  }
  if (const VectorOfprim_term *const prim_terms_ = object->Prim_terms()) {
    enterPrim_terms(object, *prim_terms_);
    for (VectorOfprim_term::const_reference element : *prim_terms_) {
      listenAny(element);
    }
    leavePrim_terms(object, *prim_terms_);
  }
  if (const VectorOfcont_assign *const cont_assigns_ = object->Cont_assigns()) {
    enterCont_assigns(object, *cont_assigns_);
    for (VectorOfcont_assign::const_reference element : *cont_assigns_) {
      listenAny(element);
    }
    leaveCont_assigns(object, *cont_assigns_);
  }
  if (const VectorOfpath_term *const path_terms_ = object->Path_terms()) {
    enterPath_terms(object, *path_terms_);
    for (VectorOfpath_term::const_reference element : *path_terms_) {
      listenAny(element);
    }
    leavePath_terms(object, *path_terms_);
  }
  if (const VectorOftchk_term *const tchk_terms_ = object->Tchk_terms()) {
    enterTchk_terms(object, *tchk_terms_);
    for (VectorOftchk_term::const_reference element : *tchk_terms_) {
      listenAny(element);
    }
    leaveTchk_terms(object, *tchk_terms_);
  }
  if (const any *const sim_net_ = object->Sim_net()) {
    listenAny(sim_net_);
  }
  if (const any *const module_inst_ = object->Module_inst()) {
    listenAny(module_inst_);
  }
}

void UhdmListener::listenNet_bit_(const net_bit* const object) {
  listenNets_(object);
  if (const VectorOfexpr *const exprs_ = object->Exprs()) {
    enterExprs(object, *exprs_);
    for (VectorOfexpr::const_reference element : *exprs_) {
      listenAny(element);
    }
    leaveExprs(object, *exprs_);
  }
}

void UhdmListener::listenNet_(const net* const object) {
  listenNets_(object);
  if (const VectorOfnet_bit *const net_bits_ = object->Net_bits()) {
    enterNet_bits(object, *net_bits_);
    for (VectorOfnet_bit::const_reference element : *net_bits_) {
      listenAny(element);
    }
    leaveNet_bits(object, *net_bits_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const VectorOfexpr *const exprs_ = object->Exprs()) {
    enterExprs(object, *exprs_);
    for (VectorOfexpr::const_reference element : *exprs_) {
      listenAny(element);
    }
    leaveExprs(object, *exprs_);
  }
}

void UhdmListener::listenStruct_net_(const struct_net* const object) {
  listenNet_(object);
  if (const VectorOfnets *const nets_ = object->Nets()) {
    enterNets(object, *nets_);
    for (VectorOfnets::const_reference element : *nets_) {
      listenAny(element);
    }
    leaveNets(object, *nets_);
  }
}

void UhdmListener::listenEnum_net_(const enum_net* const object) {
  listenNet_(object);
}

void UhdmListener::listenInteger_net_(const integer_net* const object) {
  listenNet_(object);
}

void UhdmListener::listenTime_net_(const time_net* const object) {
  listenNet_(object);
}

void UhdmListener::listenLogic_net_(const logic_net* const object) {
  listenNet_(object);
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
}

void UhdmListener::listenArray_net_(const array_net* const object) {
  listenNets_(object);
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const VectorOfnet *const nets_ = object->Nets()) {
    enterNets(object, *nets_);
    for (VectorOfnet::const_reference element : *nets_) {
      listenAny(element);
    }
    leaveNets(object, *nets_);
  }
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenPacked_array_net_(const packed_array_net* const object) {
  listenNet_(object);
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const VectorOfany *const elements_ = object->Elements()) {
    enterElements(object, *elements_);
    for (VectorOfany::const_reference element : *elements_) {
      listenAny(element);
    }
    leaveElements(object, *elements_);
  }
}

void UhdmListener::listenEvent_typespec_(const event_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenNamed_event_(const named_event* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const any *const event_typespec_ = object->Event_typespec()) {
    listenAny(event_typespec_);
  }
  if (const VectorOfthread_obj *const threads_ = object->Threads()) {
    enterThreads(object, *threads_);
    for (VectorOfthread_obj::const_reference element : *threads_) {
      listenAny(element);
    }
    leaveThreads(object, *threads_);
  }
}

void UhdmListener::listenNamed_event_array_(const named_event_array* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenParameter_(const parameter* const object) {
  listenSimple_expr_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_range_ = object->Left_range()) {
    listenAny(left_range_);
  }
  if (const any *const right_range_ = object->Right_range()) {
    listenAny(right_range_);
  }
}

void UhdmListener::listenDef_param_(const def_param* const object) {
  listenBaseClass_(object);
  if (const any *const rhs_ = object->Rhs()) {
    listenAny(rhs_);
  }
  if (const any *const lhs_ = object->Lhs()) {
    listenAny(lhs_);
  }
}

void UhdmListener::listenSpec_param_(const spec_param* const object) {
  listenSimple_expr_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenClass_typespec_(const class_typespec* const object) {
  listenTypespec_(object);
  if (const any *const extends_ = object->Extends()) {
    listenAny(extends_);
  }
  if (const VectorOfvariables *const variables_ = object->Variables()) {
    enterVariables(object, *variables_);
    for (VectorOfvariables::const_reference element : *variables_) {
      listenAny(element);
    }
    leaveVariables(object, *variables_);
  }
  if (const VectorOftask_func *const task_funcs_ = object->Task_funcs()) {
    enterTask_funcs(object, *task_funcs_);
    for (VectorOftask_func::const_reference element : *task_funcs_) {
      listenAny(element);
    }
    leaveTask_funcs(object, *task_funcs_);
  }
  if (const VectorOfconstraint *const constraints_ = object->Constraints()) {
    enterConstraints(object, *constraints_);
    for (VectorOfconstraint::const_reference element : *constraints_) {
      listenAny(element);
    }
    leaveConstraints(object, *constraints_);
  }
  if (const VectorOfany *const parameters_ = object->Parameters()) {
    enterParameters(object, *parameters_);
    for (VectorOfany::const_reference element : *parameters_) {
      listenAny(element);
    }
    leaveParameters(object, *parameters_);
  }
  if (const VectorOfparam_assign *const param_assigns_ = object->Param_assigns()) {
    enterParam_assigns(object, *param_assigns_);
    for (VectorOfparam_assign::const_reference element : *param_assigns_) {
      listenAny(element);
    }
    leaveParam_assigns(object, *param_assigns_);
  }
  if (const VectorOfvirtual_interface_var *const virtual_interface_vars_ = object->Virtual_interface_vars()) {
    enterVirtual_interface_vars(object, *virtual_interface_vars_);
    for (VectorOfvirtual_interface_var::const_reference element : *virtual_interface_vars_) {
      listenAny(element);
    }
    leaveVirtual_interface_vars(object, *virtual_interface_vars_);
  }
  if (const VectorOfnamed_event *const named_events_ = object->Named_events()) {
    enterNamed_events(object, *named_events_);
    for (VectorOfnamed_event::const_reference element : *named_events_) {
      listenAny(element);
    }
    leaveNamed_events(object, *named_events_);
  }
  if (const VectorOfnamed_event_array *const named_event_arrays_ = object->Named_event_arrays()) {
    enterNamed_event_arrays(object, *named_event_arrays_);
    for (VectorOfnamed_event_array::const_reference element : *named_event_arrays_) {
      listenAny(element);
    }
    leaveNamed_event_arrays(object, *named_event_arrays_);
  }
  if (const VectorOfscope *const scopes_ = object->Scopes()) {
    enterScopes(object, *scopes_);
    for (VectorOfscope::const_reference element : *scopes_) {
      listenAny(element);
    }
    leaveScopes(object, *scopes_);
  }
  if (const any *const class_defn_ = object->Class_defn()) {
    listenAny(class_defn_);
  }
}

void UhdmListener::listenExtends_(const extends* const object) {
  listenBaseClass_(object);
  if (const any *const class_typespec_ = object->Class_typespec()) {
    listenAny(class_typespec_);
  }
  if (const VectorOfexpr *const arguments_ = object->Arguments()) {
    enterArguments(object, *arguments_);
    for (VectorOfexpr::const_reference element : *arguments_) {
      listenAny(element);
    }
    leaveArguments(object, *arguments_);
  }
}

void UhdmListener::listenClass_defn_(const class_defn* const object) {
  listenScope_(object);
  if (const any *const extends_ = object->Extends()) {
    listenAny(extends_);
  }
  if (const VectorOftask_func *const task_funcs_ = object->Task_funcs()) {
    enterTask_funcs(object, *task_funcs_);
    for (VectorOftask_func::const_reference element : *task_funcs_) {
      listenAny(element);
    }
    leaveTask_funcs(object, *task_funcs_);
  }
  if (const VectorOfconstraint *const constraints_ = object->Constraints()) {
    enterConstraints(object, *constraints_);
    for (VectorOfconstraint::const_reference element : *constraints_) {
      listenAny(element);
    }
    leaveConstraints(object, *constraints_);
  }
  if (const VectorOfclass_defn *const deriveds_ = object->Deriveds()) {
    enterDeriveds(object, *deriveds_);
    for (VectorOfclass_defn::const_reference element : *deriveds_) {
      listenAny(element);
    }
    leaveDeriveds(object, *deriveds_);
  }
  if (const VectorOfclass_typespec *const class_typespecs_ = object->Class_typespecs()) {
    enterClass_typespecs(object, *class_typespecs_);
    for (VectorOfclass_typespec::const_reference element : *class_typespecs_) {
      listenAny(element);
    }
    leaveClass_typespecs(object, *class_typespecs_);
  }
}

void UhdmListener::listenClass_obj_(const class_obj* const object) {
  listenScope_(object);
  if (const any *const class_typespec_ = object->Class_typespec()) {
    listenAny(class_typespec_);
  }
  if (const VectorOfthread_obj *const threads_ = object->Threads()) {
    enterThreads(object, *threads_);
    for (VectorOfthread_obj::const_reference element : *threads_) {
      listenAny(element);
    }
    leaveThreads(object, *threads_);
  }
  if (const VectorOfexpr *const messages_ = object->Messages()) {
    enterMessages(object, *messages_);
    for (VectorOfexpr::const_reference element : *messages_) {
      listenAny(element);
    }
    leaveMessages(object, *messages_);
  }
  if (const VectorOftask_func *const task_funcs_ = object->Task_funcs()) {
    enterTask_funcs(object, *task_funcs_);
    for (VectorOftask_func::const_reference element : *task_funcs_) {
      listenAny(element);
    }
    leaveTask_funcs(object, *task_funcs_);
  }
  if (const VectorOfconstraint *const constraints_ = object->Constraints()) {
    enterConstraints(object, *constraints_);
    for (VectorOfconstraint::const_reference element : *constraints_) {
      listenAny(element);
    }
    leaveConstraints(object, *constraints_);
  }
}

void UhdmListener::listenClass_var_(const class_var* const object) {
  listenVariables_(object);
  if (const any *const class_obj_ = object->Class_obj()) {
    listenAny(class_obj_);
  }
}

void UhdmListener::listenInstance_(const instance* const object) {
  listenScope_(object);
  if (const VectorOfprogram *const programs_ = object->Programs()) {
    enterPrograms(object, *programs_);
    for (VectorOfprogram::const_reference element : *programs_) {
      listenAny(element);
    }
    leavePrograms(object, *programs_);
  }
  if (const VectorOfprogram *const program_arrays_ = object->Program_arrays()) {
    enterProgram_arrays(object, *program_arrays_);
    for (VectorOfprogram::const_reference element : *program_arrays_) {
      listenAny(element);
    }
    leaveProgram_arrays(object, *program_arrays_);
  }
  if (const VectorOfclass_defn *const class_defns_ = object->Class_defns()) {
    enterClass_defns(object, *class_defns_);
    for (VectorOfclass_defn::const_reference element : *class_defns_) {
      listenAny(element);
    }
    leaveClass_defns(object, *class_defns_);
  }
  if (const VectorOftask_func *const task_funcs_ = object->Task_funcs()) {
    enterTask_funcs(object, *task_funcs_);
    for (VectorOftask_func::const_reference element : *task_funcs_) {
      listenAny(element);
    }
    leaveTask_funcs(object, *task_funcs_);
  }
  if (const VectorOfnet *const nets_ = object->Nets()) {
    enterNets(object, *nets_);
    for (VectorOfnet::const_reference element : *nets_) {
      listenAny(element);
    }
    leaveNets(object, *nets_);
  }
  if (const VectorOfarray_net *const array_nets_ = object->Array_nets()) {
    enterArray_nets(object, *array_nets_);
    for (VectorOfarray_net::const_reference element : *array_nets_) {
      listenAny(element);
    }
    leaveArray_nets(object, *array_nets_);
  }
  if (const VectorOfspec_param *const spec_params_ = object->Spec_params()) {
    enterSpec_params(object, *spec_params_);
    for (VectorOfspec_param::const_reference element : *spec_params_) {
      listenAny(element);
    }
    leaveSpec_params(object, *spec_params_);
  }
  if (const VectorOfany *const assertions_ = object->Assertions()) {
    enterAssertions(object, *assertions_);
    for (VectorOfany::const_reference element : *assertions_) {
      listenAny(element);
    }
    leaveAssertions(object, *assertions_);
  }
  if (const any *const module_inst_ = object->Module_inst()) {
    listenAny(module_inst_);
  }
  if (const any *const instance_ = object->Instance()) {
    listenAny(instance_);
  }
}

void UhdmListener::listenInterface_inst_(const interface_inst* const object) {
  listenInstance_(object);
  if (const VectorOfinterface_tf_decl *const interface_tf_decls_ = object->Interface_tf_decls()) {
    enterInterface_tf_decls(object, *interface_tf_decls_);
    for (VectorOfinterface_tf_decl::const_reference element : *interface_tf_decls_) {
      listenAny(element);
    }
    leaveInterface_tf_decls(object, *interface_tf_decls_);
  }
  if (const VectorOfmodport *const modports_ = object->Modports()) {
    enterModports(object, *modports_);
    for (VectorOfmodport::const_reference element : *modports_) {
      listenAny(element);
    }
    leaveModports(object, *modports_);
  }
  if (const any *const global_clocking_ = object->Global_clocking()) {
    listenAny(global_clocking_);
  }
  if (const any *const default_clocking_ = object->Default_clocking()) {
    listenAny(default_clocking_);
  }
  if (const any *const expr_dist_ = object->Expr_dist()) {
    listenAny(expr_dist_);
  }
  if (const any *const instance_array_ = object->Instance_array()) {
    listenAny(instance_array_);
  }
  if (const VectorOfmod_path *const mod_paths_ = object->Mod_paths()) {
    enterMod_paths(object, *mod_paths_);
    for (VectorOfmod_path::const_reference element : *mod_paths_) {
      listenAny(element);
    }
    leaveMod_paths(object, *mod_paths_);
  }
  if (const VectorOfcont_assign *const cont_assigns_ = object->Cont_assigns()) {
    enterCont_assigns(object, *cont_assigns_);
    for (VectorOfcont_assign::const_reference element : *cont_assigns_) {
      listenAny(element);
    }
    leaveCont_assigns(object, *cont_assigns_);
  }
  if (const VectorOfclocking_block *const clocking_blocks_ = object->Clocking_blocks()) {
    enterClocking_blocks(object, *clocking_blocks_);
    for (VectorOfclocking_block::const_reference element : *clocking_blocks_) {
      listenAny(element);
    }
    leaveClocking_blocks(object, *clocking_blocks_);
  }
  if (const VectorOfinterface_inst *const interfaces_ = object->Interfaces()) {
    enterInterfaces(object, *interfaces_);
    for (VectorOfinterface_inst::const_reference element : *interfaces_) {
      listenAny(element);
    }
    leaveInterfaces(object, *interfaces_);
  }
  if (const VectorOfinterface_array *const interface_arrays_ = object->Interface_arrays()) {
    enterInterface_arrays(object, *interface_arrays_);
    for (VectorOfinterface_array::const_reference element : *interface_arrays_) {
      listenAny(element);
    }
    leaveInterface_arrays(object, *interface_arrays_);
  }
  if (const VectorOfprocess_stmt *const process_ = object->Process()) {
    enterProcess(object, *process_);
    for (VectorOfprocess_stmt::const_reference element : *process_) {
      listenAny(element);
    }
    leaveProcess(object, *process_);
  }
  if (const VectorOfport *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfport::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
  if (const VectorOfgen_scope_array *const gen_scope_arrays_ = object->Gen_scope_arrays()) {
    enterGen_scope_arrays(object, *gen_scope_arrays_);
    for (VectorOfgen_scope_array::const_reference element : *gen_scope_arrays_) {
      listenAny(element);
    }
    leaveGen_scope_arrays(object, *gen_scope_arrays_);
  }
  if (const VectorOftf_call *const elab_tasks_ = object->Elab_tasks()) {
    enterElab_tasks(object, *elab_tasks_);
    for (VectorOftf_call::const_reference element : *elab_tasks_) {
      listenAny(element);
    }
    leaveElab_tasks(object, *elab_tasks_);
  }
  if (const VectorOfgen_stmt *const gen_stmts_ = object->Gen_stmts()) {
    enterGen_stmts(object, *gen_stmts_);
    for (VectorOfgen_stmt::const_reference element : *gen_stmts_) {
      listenAny(element);
    }
    leaveGen_stmts(object, *gen_stmts_);
  }
}

void UhdmListener::listenProgram_(const program* const object) {
  listenInstance_(object);
  if (const any *const default_clocking_ = object->Default_clocking()) {
    listenAny(default_clocking_);
  }
  if (const any *const instance_array_ = object->Instance_array()) {
    listenAny(instance_array_);
  }
  if (const VectorOfinterface_inst *const interfaces_ = object->Interfaces()) {
    enterInterfaces(object, *interfaces_);
    for (VectorOfinterface_inst::const_reference element : *interfaces_) {
      listenAny(element);
    }
    leaveInterfaces(object, *interfaces_);
  }
  if (const any *const expr_dist_ = object->Expr_dist()) {
    listenAny(expr_dist_);
  }
  if (const VectorOfinterface_array *const interface_arrays_ = object->Interface_arrays()) {
    enterInterface_arrays(object, *interface_arrays_);
    for (VectorOfinterface_array::const_reference element : *interface_arrays_) {
      listenAny(element);
    }
    leaveInterface_arrays(object, *interface_arrays_);
  }
  if (const VectorOfprocess_stmt *const process_ = object->Process()) {
    enterProcess(object, *process_);
    for (VectorOfprocess_stmt::const_reference element : *process_) {
      listenAny(element);
    }
    leaveProcess(object, *process_);
  }
  if (const VectorOfcont_assign *const cont_assigns_ = object->Cont_assigns()) {
    enterCont_assigns(object, *cont_assigns_);
    for (VectorOfcont_assign::const_reference element : *cont_assigns_) {
      listenAny(element);
    }
    leaveCont_assigns(object, *cont_assigns_);
  }
  if (const VectorOfclocking_block *const clocking_blocks_ = object->Clocking_blocks()) {
    enterClocking_blocks(object, *clocking_blocks_);
    for (VectorOfclocking_block::const_reference element : *clocking_blocks_) {
      listenAny(element);
    }
    leaveClocking_blocks(object, *clocking_blocks_);
  }
  if (const VectorOfport *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfport::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
  if (const VectorOfgen_scope_array *const gen_scope_arrays_ = object->Gen_scope_arrays()) {
    enterGen_scope_arrays(object, *gen_scope_arrays_);
    for (VectorOfgen_scope_array::const_reference element : *gen_scope_arrays_) {
      listenAny(element);
    }
    leaveGen_scope_arrays(object, *gen_scope_arrays_);
  }
}

void UhdmListener::listenPackage_(const package* const object) {
  listenInstance_(object);
}

void UhdmListener::listenModule_inst_(const module_inst* const object) {
  listenInstance_(object);
  if (const any *const global_clocking_ = object->Global_clocking()) {
    listenAny(global_clocking_);
  }
  if (const any *const default_clocking_ = object->Default_clocking()) {
    listenAny(default_clocking_);
  }
  if (const any *const expr_dist_ = object->Expr_dist()) {
    listenAny(expr_dist_);
  }
  if (const any *const module_array_ = object->Module_array()) {
    listenAny(module_array_);
  }
  if (const any *const instance_array_ = object->Instance_array()) {
    listenAny(instance_array_);
  }
  if (const VectorOfport *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfport::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
  if (const VectorOfinterface_inst *const interfaces_ = object->Interfaces()) {
    enterInterfaces(object, *interfaces_);
    for (VectorOfinterface_inst::const_reference element : *interfaces_) {
      listenAny(element);
    }
    leaveInterfaces(object, *interfaces_);
  }
  if (const VectorOfinterface_array *const interface_arrays_ = object->Interface_arrays()) {
    enterInterface_arrays(object, *interface_arrays_);
    for (VectorOfinterface_array::const_reference element : *interface_arrays_) {
      listenAny(element);
    }
    leaveInterface_arrays(object, *interface_arrays_);
  }
  if (const VectorOfprocess_stmt *const process_ = object->Process()) {
    enterProcess(object, *process_);
    for (VectorOfprocess_stmt::const_reference element : *process_) {
      listenAny(element);
    }
    leaveProcess(object, *process_);
  }
  if (const VectorOfmodule_inst *const modules_ = object->Modules()) {
    enterModules(object, *modules_);
    for (VectorOfmodule_inst::const_reference element : *modules_) {
      listenAny(element);
    }
    leaveModules(object, *modules_);
  }
  if (const VectorOfmodule_array *const module_arrays_ = object->Module_arrays()) {
    enterModule_arrays(object, *module_arrays_);
    for (VectorOfmodule_array::const_reference element : *module_arrays_) {
      listenAny(element);
    }
    leaveModule_arrays(object, *module_arrays_);
  }
  if (const VectorOfgen_scope_array *const gen_scope_arrays_ = object->Gen_scope_arrays()) {
    enterGen_scope_arrays(object, *gen_scope_arrays_);
    for (VectorOfgen_scope_array::const_reference element : *gen_scope_arrays_) {
      listenAny(element);
    }
    leaveGen_scope_arrays(object, *gen_scope_arrays_);
  }
  if (const VectorOfcont_assign *const cont_assigns_ = object->Cont_assigns()) {
    enterCont_assigns(object, *cont_assigns_);
    for (VectorOfcont_assign::const_reference element : *cont_assigns_) {
      listenAny(element);
    }
    leaveCont_assigns(object, *cont_assigns_);
  }
  if (const VectorOfprimitive *const primitives_ = object->Primitives()) {
    enterPrimitives(object, *primitives_);
    for (VectorOfprimitive::const_reference element : *primitives_) {
      listenAny(element);
    }
    leavePrimitives(object, *primitives_);
  }
  if (const VectorOfprimitive_array *const primitive_arrays_ = object->Primitive_arrays()) {
    enterPrimitive_arrays(object, *primitive_arrays_);
    for (VectorOfprimitive_array::const_reference element : *primitive_arrays_) {
      listenAny(element);
    }
    leavePrimitive_arrays(object, *primitive_arrays_);
  }
  if (const VectorOfmod_path *const mod_paths_ = object->Mod_paths()) {
    enterMod_paths(object, *mod_paths_);
    for (VectorOfmod_path::const_reference element : *mod_paths_) {
      listenAny(element);
    }
    leaveMod_paths(object, *mod_paths_);
  }
  if (const VectorOftchk *const tchks_ = object->Tchks()) {
    enterTchks(object, *tchks_);
    for (VectorOftchk::const_reference element : *tchks_) {
      listenAny(element);
    }
    leaveTchks(object, *tchks_);
  }
  if (const VectorOfdef_param *const def_params_ = object->Def_params()) {
    enterDef_params(object, *def_params_);
    for (VectorOfdef_param::const_reference element : *def_params_) {
      listenAny(element);
    }
    leaveDef_params(object, *def_params_);
  }
  if (const VectorOfio_decl *const io_decls_ = object->Io_decls()) {
    enterIo_decls(object, *io_decls_);
    for (VectorOfio_decl::const_reference element : *io_decls_) {
      listenAny(element);
    }
    leaveIo_decls(object, *io_decls_);
  }
  if (const VectorOfalias_stmt *const alias_stmts_ = object->Alias_stmts()) {
    enterAlias_stmts(object, *alias_stmts_);
    for (VectorOfalias_stmt::const_reference element : *alias_stmts_) {
      listenAny(element);
    }
    leaveAlias_stmts(object, *alias_stmts_);
  }
  if (const VectorOfclocking_block *const clocking_blocks_ = object->Clocking_blocks()) {
    enterClocking_blocks(object, *clocking_blocks_);
    for (VectorOfclocking_block::const_reference element : *clocking_blocks_) {
      listenAny(element);
    }
    leaveClocking_blocks(object, *clocking_blocks_);
  }
  if (const VectorOftf_call *const elab_tasks_ = object->Elab_tasks()) {
    enterElab_tasks(object, *elab_tasks_);
    for (VectorOftf_call::const_reference element : *elab_tasks_) {
      listenAny(element);
    }
    leaveElab_tasks(object, *elab_tasks_);
  }
  if (const VectorOfref_module *const ref_modules_ = object->Ref_modules()) {
    enterRef_modules(object, *ref_modules_);
    for (VectorOfref_module::const_reference element : *ref_modules_) {
      listenAny(element);
    }
    leaveRef_modules(object, *ref_modules_);
  }
  if (const VectorOfgen_stmt *const gen_stmts_ = object->Gen_stmts()) {
    enterGen_stmts(object, *gen_stmts_);
    for (VectorOfgen_stmt::const_reference element : *gen_stmts_) {
      listenAny(element);
    }
    leaveGen_stmts(object, *gen_stmts_);
  }
}

void UhdmListener::listenChecker_decl_(const checker_decl* const object) {
  listenInstance_(object);
  if (const any *const default_clocking_ = object->Default_clocking()) {
    listenAny(default_clocking_);
  }
  if (const VectorOfprocess_stmt *const process_ = object->Process()) {
    enterProcess(object, *process_);
    for (VectorOfprocess_stmt::const_reference element : *process_) {
      listenAny(element);
    }
    leaveProcess(object, *process_);
  }
  if (const VectorOfcont_assign *const cont_assigns_ = object->Cont_assigns()) {
    enterCont_assigns(object, *cont_assigns_);
    for (VectorOfcont_assign::const_reference element : *cont_assigns_) {
      listenAny(element);
    }
    leaveCont_assigns(object, *cont_assigns_);
  }
  if (const VectorOfchecker_port *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfchecker_port::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
}

void UhdmListener::listenChecker_inst_(const checker_inst* const object) {
  listenInstance_(object);
  if (const VectorOfchecker_inst_port *const ports_ = object->Ports()) {
    enterPorts(object, *ports_);
    for (VectorOfchecker_inst_port::const_reference element : *ports_) {
      listenAny(element);
    }
    leavePorts(object, *ports_);
  }
}

void UhdmListener::listenShort_real_typespec_(const short_real_typespec* const object) {
  listenTypespec_(object);
  if (const any *const resolution_func_ = object->Resolution_func()) {
    listenAny(resolution_func_);
  }
}

void UhdmListener::listenReal_typespec_(const real_typespec* const object) {
  listenTypespec_(object);
  if (const any *const resolution_func_ = object->Resolution_func()) {
    listenAny(resolution_func_);
  }
}

void UhdmListener::listenByte_typespec_(const byte_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenShort_int_typespec_(const short_int_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenInt_typespec_(const int_typespec* const object) {
  listenTypespec_(object);
  if (const any *const cast_to_expr_ = object->Cast_to_expr()) {
    listenAny(cast_to_expr_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
}

void UhdmListener::listenLong_int_typespec_(const long_int_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenInteger_typespec_(const integer_typespec* const object) {
  listenTypespec_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
}

void UhdmListener::listenTime_typespec_(const time_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenEnum_typespec_(const enum_typespec* const object) {
  listenTypespec_(object);
  if (const any *const base_typespec_ = object->Base_typespec()) {
    listenAny(base_typespec_);
  }
  if (const VectorOfenum_const *const enum_consts_ = object->Enum_consts()) {
    enterEnum_consts(object, *enum_consts_);
    for (VectorOfenum_const::const_reference element : *enum_consts_) {
      listenAny(element);
    }
    leaveEnum_consts(object, *enum_consts_);
  }
}

void UhdmListener::listenString_typespec_(const string_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenChandle_typespec_(const chandle_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenModule_typespec_(const module_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenStruct_typespec_(const struct_typespec* const object) {
  listenTypespec_(object);
  if (const VectorOftypespec_member *const members_ = object->Members()) {
    enterMembers(object, *members_);
    for (VectorOftypespec_member::const_reference element : *members_) {
      listenAny(element);
    }
    leaveMembers(object, *members_);
  }
  if (const any *const resolution_func_ = object->Resolution_func()) {
    listenAny(resolution_func_);
  }
}

void UhdmListener::listenUnion_typespec_(const union_typespec* const object) {
  listenTypespec_(object);
  if (const VectorOftypespec_member *const members_ = object->Members()) {
    enterMembers(object, *members_);
    for (VectorOftypespec_member::const_reference element : *members_) {
      listenAny(element);
    }
    leaveMembers(object, *members_);
  }
}

void UhdmListener::listenLogic_typespec_(const logic_typespec* const object) {
  listenTypespec_(object);
  if (const any *const elem_typespec_ = object->Elem_typespec()) {
    listenAny(elem_typespec_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const any *const index_typespec_ = object->Index_typespec()) {
    listenAny(index_typespec_);
  }
  if (const any *const resolution_func_ = object->Resolution_func()) {
    listenAny(resolution_func_);
  }
}

void UhdmListener::listenPacked_array_typespec_(const packed_array_typespec* const object) {
  listenTypespec_(object);
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const any *const elem_typespec_ = object->Elem_typespec()) {
    listenAny(elem_typespec_);
  }
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
  if (const any *const resolution_func_ = object->Resolution_func()) {
    listenAny(resolution_func_);
  }
}

void UhdmListener::listenArray_typespec_(const array_typespec* const object) {
  listenTypespec_(object);
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const any *const index_typespec_ = object->Index_typespec()) {
    listenAny(index_typespec_);
  }
  if (const any *const elem_typespec_ = object->Elem_typespec()) {
    listenAny(elem_typespec_);
  }
  if (const any *const resolution_func_ = object->Resolution_func()) {
    listenAny(resolution_func_);
  }
}

void UhdmListener::listenVoid_typespec_(const void_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenUnsupported_typespec_(const unsupported_typespec* const object) {
  listenTypespec_(object);
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
}

void UhdmListener::listenSequence_typespec_(const sequence_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenProperty_typespec_(const property_typespec* const object) {
  listenTypespec_(object);
}

void UhdmListener::listenInterface_typespec_(const interface_typespec* const object) {
  listenTypespec_(object);
  if (const VectorOfparam_assign *const param_assigns_ = object->Param_assigns()) {
    enterParam_assigns(object, *param_assigns_);
    for (VectorOfparam_assign::const_reference element : *param_assigns_) {
      listenAny(element);
    }
    leaveParam_assigns(object, *param_assigns_);
  }
}

void UhdmListener::listenType_parameter_(const type_parameter* const object) {
  listenTypespec_(object);
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
}

void UhdmListener::listenTypespec_member_(const typespec_member* const object) {
  listenBaseClass_(object);
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
  if (const any *const default_value_ = object->Default_value()) {
    listenAny(default_value_);
  }
}

void UhdmListener::listenEnum_const_(const enum_const* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenBit_typespec_(const bit_typespec* const object) {
  listenTypespec_(object);
  if (const any *const bit_typespec_ = object->Bit_typespec()) {
    listenAny(bit_typespec_);
  }
  if (const VectorOfrange *const ranges_ = object->Ranges()) {
    enterRanges(object, *ranges_);
    for (VectorOfrange::const_reference element : *ranges_) {
      listenAny(element);
    }
    leaveRanges(object, *ranges_);
  }
  if (const any *const left_expr_ = object->Left_expr()) {
    listenAny(left_expr_);
  }
  if (const any *const right_expr_ = object->Right_expr()) {
    listenAny(right_expr_);
  }
  if (const any *const typespec_ = object->Typespec()) {
    listenAny(typespec_);
  }
  if (const any *const resolution_func_ = object->Resolution_func()) {
    listenAny(resolution_func_);
  }
}

void UhdmListener::listenTf_call_(const tf_call* const object) {
  listenExpr_(object);
  if (const any *const scope_ = object->Scope()) {
    listenAny(scope_);
  }
  if (const VectorOfany *const tf_call_args_ = object->Tf_call_args()) {
    enterTf_call_args(object, *tf_call_args_);
    for (VectorOfany::const_reference element : *tf_call_args_) {
      listenAny(element);
    }
    leaveTf_call_args(object, *tf_call_args_);
  }
}

void UhdmListener::listenUser_systf_(const user_systf* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenSys_func_call_(const sys_func_call* const object) {
  listenTf_call_(object);
  if (const any *const user_systf_ = object->User_systf()) {
    listenAny(user_systf_);
  }
}

void UhdmListener::listenSys_task_call_(const sys_task_call* const object) {
  listenTf_call_(object);
  if (const any *const user_systf_ = object->User_systf()) {
    listenAny(user_systf_);
  }
}

void UhdmListener::listenMethod_func_call_(const method_func_call* const object) {
  listenTf_call_(object);
  if (const any *const prefix_ = object->Prefix()) {
    listenAny(prefix_);
  }
  if (const any *const with_ = object->With()) {
    listenAny(with_);
  }
  if (const any *const function_ = object->Function()) {
    listenAny(function_);
  }
}

void UhdmListener::listenMethod_task_call_(const method_task_call* const object) {
  listenTf_call_(object);
  if (const any *const prefix_ = object->Prefix()) {
    listenAny(prefix_);
  }
  if (const any *const with_ = object->With()) {
    listenAny(with_);
  }
  if (const any *const task_ = object->Task()) {
    listenAny(task_);
  }
}

void UhdmListener::listenFunc_call_(const func_call* const object) {
  listenTf_call_(object);
  if (const any *const function_ = object->Function()) {
    listenAny(function_);
  }
}

void UhdmListener::listenTask_call_(const task_call* const object) {
  listenTf_call_(object);
  if (const any *const task_ = object->Task()) {
    listenAny(task_);
  }
}

void UhdmListener::listenConstraint_expr_(const constraint_expr* const object) {
  listenBaseClass_(object);
}

void UhdmListener::listenConstraint_ordering_(const constraint_ordering* const object) {
  listenBaseClass_(object);
  if (const VectorOfexpr *const solve_befores_ = object->Solve_befores()) {
    enterSolve_befores(object, *solve_befores_);
    for (VectorOfexpr::const_reference element : *solve_befores_) {
      listenAny(element);
    }
    leaveSolve_befores(object, *solve_befores_);
  }
  if (const VectorOfexpr *const solve_afters_ = object->Solve_afters()) {
    enterSolve_afters(object, *solve_afters_);
    for (VectorOfexpr::const_reference element : *solve_afters_) {
      listenAny(element);
    }
    leaveSolve_afters(object, *solve_afters_);
  }
}

void UhdmListener::listenConstraint_(const constraint* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
  if (const VectorOfany *const constraint_items_ = object->Constraint_items()) {
    enterConstraint_items(object, *constraint_items_);
    for (VectorOfany::const_reference element : *constraint_items_) {
      listenAny(element);
    }
    leaveConstraint_items(object, *constraint_items_);
  }
}

void UhdmListener::listenImport_typespec_(const import_typespec* const object) {
  listenTypespec_(object);
  if (const any *const item_ = object->Item()) {
    listenAny(item_);
  }
}

void UhdmListener::listenDist_item_(const dist_item* const object) {
  listenBaseClass_(object);
  if (const any *const value_range_ = object->Value_range()) {
    listenAny(value_range_);
  }
  if (const any *const weight_ = object->Weight()) {
    listenAny(weight_);
  }
}

void UhdmListener::listenDistribution_(const distribution* const object) {
  listenConstraint_expr_(object);
  if (const VectorOfdist_item *const dist_items_ = object->Dist_items()) {
    enterDist_items(object, *dist_items_);
    for (VectorOfdist_item::const_reference element : *dist_items_) {
      listenAny(element);
    }
    leaveDist_items(object, *dist_items_);
  }
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
}

void UhdmListener::listenImplication_(const implication* const object) {
  listenConstraint_expr_(object);
  if (const any *const condition_ = object->Condition()) {
    listenAny(condition_);
  }
  if (const VectorOfconstraint_expr *const constraint_exprs_ = object->Constraint_exprs()) {
    enterConstraint_exprs(object, *constraint_exprs_);
    for (VectorOfconstraint_expr::const_reference element : *constraint_exprs_) {
      listenAny(element);
    }
    leaveConstraint_exprs(object, *constraint_exprs_);
  }
}

void UhdmListener::listenConstr_if_(const constr_if* const object) {
  listenConstraint_expr_(object);
  if (const any *const condition_ = object->Condition()) {
    listenAny(condition_);
  }
  if (const VectorOfconstraint_expr *const constraint_exprs_ = object->Constraint_exprs()) {
    enterConstraint_exprs(object, *constraint_exprs_);
    for (VectorOfconstraint_expr::const_reference element : *constraint_exprs_) {
      listenAny(element);
    }
    leaveConstraint_exprs(object, *constraint_exprs_);
  }
}

void UhdmListener::listenConstr_if_else_(const constr_if_else* const object) {
  listenConstraint_expr_(object);
  if (const any *const condition_ = object->Condition()) {
    listenAny(condition_);
  }
  if (const VectorOfconstraint_expr *const constraint_exprs_ = object->Constraint_exprs()) {
    enterConstraint_exprs(object, *constraint_exprs_);
    for (VectorOfconstraint_expr::const_reference element : *constraint_exprs_) {
      listenAny(element);
    }
    leaveConstraint_exprs(object, *constraint_exprs_);
  }
  if (const VectorOfconstraint_expr *const else_constraint_exprs_ = object->Else_constraint_exprs()) {
    enterElse_constraint_exprs(object, *else_constraint_exprs_);
    for (VectorOfconstraint_expr::const_reference element : *else_constraint_exprs_) {
      listenAny(element);
    }
    leaveElse_constraint_exprs(object, *else_constraint_exprs_);
  }
}

void UhdmListener::listenConstr_foreach_(const constr_foreach* const object) {
  listenConstraint_expr_(object);
  if (const any *const variable_ = object->Variable()) {
    listenAny(variable_);
  }
  if (const VectorOfany *const vpiLoopVars_ = object->VpiLoopVars()) {
    enterVpiLoopVars(object, *vpiLoopVars_);
    for (VectorOfany::const_reference element : *vpiLoopVars_) {
      listenAny(element);
    }
    leaveVpiLoopVars(object, *vpiLoopVars_);
  }
  if (const VectorOfconstraint_expr *const constraint_exprs_ = object->Constraint_exprs()) {
    enterConstraint_exprs(object, *constraint_exprs_);
    for (VectorOfconstraint_expr::const_reference element : *constraint_exprs_) {
      listenAny(element);
    }
    leaveConstraint_exprs(object, *constraint_exprs_);
  }
}

void UhdmListener::listenSoft_disable_(const soft_disable* const object) {
  listenConstraint_expr_(object);
  if (const any *const expr_ = object->Expr()) {
    listenAny(expr_);
  }
}

void UhdmListener::listenGen_stmt_(const gen_stmt* const object) {
  listenBaseClass_(object);
  if (const VectorOfattribute *const attributes_ = object->Attributes()) {
    enterAttributes(object, *attributes_);
    for (VectorOfattribute::const_reference element : *attributes_) {
      listenAny(element);
    }
    leaveAttributes(object, *attributes_);
  }
}

void UhdmListener::listenGen_if_(const gen_if* const object) {
  listenGen_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenGen_if_else_(const gen_if_else* const object) {
  listenGen_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
  if (const any *const vpiElseStmt_ = object->VpiElseStmt()) {
    listenAny(vpiElseStmt_);
  }
}

void UhdmListener::listenGen_for_(const gen_for* const object) {
  listenGen_stmt_(object);
  if (const VectorOfany *const vpiForInitStmts_ = object->VpiForInitStmts()) {
    enterVpiForInitStmts(object, *vpiForInitStmts_);
    for (VectorOfany::const_reference element : *vpiForInitStmts_) {
      listenAny(element);
    }
    leaveVpiForInitStmts(object, *vpiForInitStmts_);
  }
  if (const VectorOfany *const vpiForIncStmts_ = object->VpiForIncStmts()) {
    enterVpiForIncStmts(object, *vpiForIncStmts_);
    for (VectorOfany::const_reference element : *vpiForIncStmts_) {
      listenAny(element);
    }
    leaveVpiForIncStmts(object, *vpiForIncStmts_);
  }
  if (const any *const vpiForInitStmt_ = object->VpiForInitStmt()) {
    listenAny(vpiForInitStmt_);
  }
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const any *const vpiForIncStmt_ = object->VpiForIncStmt()) {
    listenAny(vpiForIncStmt_);
  }
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenGen_case_(const gen_case* const object) {
  listenGen_stmt_(object);
  if (const any *const vpiCondition_ = object->VpiCondition()) {
    listenAny(vpiCondition_);
  }
  if (const VectorOfcase_item *const case_items_ = object->Case_items()) {
    enterCase_items(object, *case_items_);
    for (VectorOfcase_item::const_reference element : *case_items_) {
      listenAny(element);
    }
    leaveCase_items(object, *case_items_);
  }
}

void UhdmListener::listenGen_region_(const gen_region* const object) {
  listenGen_stmt_(object);
  if (const any *const vpiStmt_ = object->VpiStmt()) {
    listenAny(vpiStmt_);
  }
}

void UhdmListener::listenDesign_(const design* const object) {
  listenBaseClass_(object);
  if (const VectorOfinclude_file_info *const include_file_infos_ = object->Include_file_infos()) {
    enterInclude_file_infos(object, *include_file_infos_);
    for (VectorOfinclude_file_info::const_reference element : *include_file_infos_) {
      listenAny(element);
    }
    leaveInclude_file_infos(object, *include_file_infos_);
  }
  if (const VectorOfpackage *const allPackages_ = object->AllPackages()) {
    enterAllPackages(object, *allPackages_);
    for (VectorOfpackage::const_reference element : *allPackages_) {
      listenAny(element);
    }
    leaveAllPackages(object, *allPackages_);
  }
  if (const VectorOfpackage *const topPackages_ = object->TopPackages()) {
    enterTopPackages(object, *topPackages_);
    for (VectorOfpackage::const_reference element : *topPackages_) {
      listenAny(element);
    }
    leaveTopPackages(object, *topPackages_);
  }
  if (const VectorOfclass_defn *const allClasses_ = object->AllClasses()) {
    enterAllClasses(object, *allClasses_);
    for (VectorOfclass_defn::const_reference element : *allClasses_) {
      listenAny(element);
    }
    leaveAllClasses(object, *allClasses_);
  }
  if (const VectorOfinterface_inst *const allInterfaces_ = object->AllInterfaces()) {
    enterAllInterfaces(object, *allInterfaces_);
    for (VectorOfinterface_inst::const_reference element : *allInterfaces_) {
      listenAny(element);
    }
    leaveAllInterfaces(object, *allInterfaces_);
  }
  if (const VectorOfudp_defn *const allUdps_ = object->AllUdps()) {
    enterAllUdps(object, *allUdps_);
    for (VectorOfudp_defn::const_reference element : *allUdps_) {
      listenAny(element);
    }
    leaveAllUdps(object, *allUdps_);
  }
  if (const VectorOfprogram *const allPrograms_ = object->AllPrograms()) {
    enterAllPrograms(object, *allPrograms_);
    for (VectorOfprogram::const_reference element : *allPrograms_) {
      listenAny(element);
    }
    leaveAllPrograms(object, *allPrograms_);
  }
  if (const VectorOfmodule_inst *const allModules_ = object->AllModules()) {
    enterAllModules(object, *allModules_);
    for (VectorOfmodule_inst::const_reference element : *allModules_) {
      listenAny(element);
    }
    leaveAllModules(object, *allModules_);
  }
  if (const VectorOftypespec *const typespecs_ = object->Typespecs()) {
    enterTypespecs(object, *typespecs_);
    for (VectorOftypespec::const_reference element : *typespecs_) {
      listenAny(element);
    }
    leaveTypespecs(object, *typespecs_);
  }
  if (const VectorOflet_decl *const let_decls_ = object->Let_decls()) {
    enterLet_decls(object, *let_decls_);
    for (VectorOflet_decl::const_reference element : *let_decls_) {
      listenAny(element);
    }
    leaveLet_decls(object, *let_decls_);
  }
  if (const VectorOftask_func *const task_funcs_ = object->Task_funcs()) {
    enterTask_funcs(object, *task_funcs_);
    for (VectorOftask_func::const_reference element : *task_funcs_) {
      listenAny(element);
    }
    leaveTask_funcs(object, *task_funcs_);
  }
  if (const VectorOfany *const parameters_ = object->Parameters()) {
    enterParameters(object, *parameters_);
    for (VectorOfany::const_reference element : *parameters_) {
      listenAny(element);
    }
    leaveParameters(object, *parameters_);
  }
  if (const VectorOfparam_assign *const param_assigns_ = object->Param_assigns()) {
    enterParam_assigns(object, *param_assigns_);
    for (VectorOfparam_assign::const_reference element : *param_assigns_) {
      listenAny(element);
    }
    leaveParam_assigns(object, *param_assigns_);
  }
  if (const VectorOfmodule_inst *const topModules_ = object->TopModules()) {
    enterTopModules(object, *topModules_);
    for (VectorOfmodule_inst::const_reference element : *topModules_) {
      listenAny(element);
    }
    leaveTopModules(object, *topModules_);
  }
}

void UhdmListener::listenAttribute(const attribute* const object) {
  callstack.push_back(object);
  enterAttribute(object);
  if (visited.insert(object).second) {
    listenAttribute_(object);
  }
  leaveAttribute(object);
  callstack.pop_back();
}

void UhdmListener::listenVirtual_interface_var(const virtual_interface_var* const object) {
  callstack.push_back(object);
  enterVirtual_interface_var(object);
  if (visited.insert(object).second) {
    listenVirtual_interface_var_(object);
  }
  leaveVirtual_interface_var(object);
  callstack.pop_back();
}

void UhdmListener::listenLet_decl(const let_decl* const object) {
  callstack.push_back(object);
  enterLet_decl(object);
  if (visited.insert(object).second) {
    listenLet_decl_(object);
  }
  leaveLet_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenAlways(const always* const object) {
  callstack.push_back(object);
  enterAlways(object);
  if (visited.insert(object).second) {
    listenAlways_(object);
  }
  leaveAlways(object);
  callstack.pop_back();
}

void UhdmListener::listenFinal_stmt(const final_stmt* const object) {
  callstack.push_back(object);
  enterFinal_stmt(object);
  if (visited.insert(object).second) {
    listenFinal_stmt_(object);
  }
  leaveFinal_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenInitial(const initial* const object) {
  callstack.push_back(object);
  enterInitial(object);
  if (visited.insert(object).second) {
    listenInitial_(object);
  }
  leaveInitial(object);
  callstack.pop_back();
}

void UhdmListener::listenDelay_control(const delay_control* const object) {
  callstack.push_back(object);
  enterDelay_control(object);
  if (visited.insert(object).second) {
    listenDelay_control_(object);
  }
  leaveDelay_control(object);
  callstack.pop_back();
}

void UhdmListener::listenDelay_term(const delay_term* const object) {
  callstack.push_back(object);
  enterDelay_term(object);
  if (visited.insert(object).second) {
    listenDelay_term_(object);
  }
  leaveDelay_term(object);
  callstack.pop_back();
}

void UhdmListener::listenEvent_control(const event_control* const object) {
  callstack.push_back(object);
  enterEvent_control(object);
  if (visited.insert(object).second) {
    listenEvent_control_(object);
  }
  leaveEvent_control(object);
  callstack.pop_back();
}

void UhdmListener::listenRepeat_control(const repeat_control* const object) {
  callstack.push_back(object);
  enterRepeat_control(object);
  if (visited.insert(object).second) {
    listenRepeat_control_(object);
  }
  leaveRepeat_control(object);
  callstack.pop_back();
}

void UhdmListener::listenBegin(const begin* const object) {
  callstack.push_back(object);
  enterBegin(object);
  if (visited.insert(object).second) {
    listenBegin_(object);
  }
  leaveBegin(object);
  callstack.pop_back();
}

void UhdmListener::listenNamed_begin(const named_begin* const object) {
  callstack.push_back(object);
  enterNamed_begin(object);
  if (visited.insert(object).second) {
    listenNamed_begin_(object);
  }
  leaveNamed_begin(object);
  callstack.pop_back();
}

void UhdmListener::listenNamed_fork(const named_fork* const object) {
  callstack.push_back(object);
  enterNamed_fork(object);
  if (visited.insert(object).second) {
    listenNamed_fork_(object);
  }
  leaveNamed_fork(object);
  callstack.pop_back();
}

void UhdmListener::listenFork_stmt(const fork_stmt* const object) {
  callstack.push_back(object);
  enterFork_stmt(object);
  if (visited.insert(object).second) {
    listenFork_stmt_(object);
  }
  leaveFork_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenFor_stmt(const for_stmt* const object) {
  callstack.push_back(object);
  enterFor_stmt(object);
  if (visited.insert(object).second) {
    listenFor_stmt_(object);
  }
  leaveFor_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenIf_stmt(const if_stmt* const object) {
  callstack.push_back(object);
  enterIf_stmt(object);
  if (visited.insert(object).second) {
    listenIf_stmt_(object);
  }
  leaveIf_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenEvent_stmt(const event_stmt* const object) {
  callstack.push_back(object);
  enterEvent_stmt(object);
  if (visited.insert(object).second) {
    listenEvent_stmt_(object);
  }
  leaveEvent_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenThread_obj(const thread_obj* const object) {
  callstack.push_back(object);
  enterThread_obj(object);
  if (visited.insert(object).second) {
    listenThread_obj_(object);
  }
  leaveThread_obj(object);
  callstack.pop_back();
}

void UhdmListener::listenForever_stmt(const forever_stmt* const object) {
  callstack.push_back(object);
  enterForever_stmt(object);
  if (visited.insert(object).second) {
    listenForever_stmt_(object);
  }
  leaveForever_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenWait_stmt(const wait_stmt* const object) {
  callstack.push_back(object);
  enterWait_stmt(object);
  if (visited.insert(object).second) {
    listenWait_stmt_(object);
  }
  leaveWait_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenWait_fork(const wait_fork* const object) {
  callstack.push_back(object);
  enterWait_fork(object);
  if (visited.insert(object).second) {
    listenWait_fork_(object);
  }
  leaveWait_fork(object);
  callstack.pop_back();
}

void UhdmListener::listenOrdered_wait(const ordered_wait* const object) {
  callstack.push_back(object);
  enterOrdered_wait(object);
  if (visited.insert(object).second) {
    listenOrdered_wait_(object);
  }
  leaveOrdered_wait(object);
  callstack.pop_back();
}

void UhdmListener::listenDisable(const disable* const object) {
  callstack.push_back(object);
  enterDisable(object);
  if (visited.insert(object).second) {
    listenDisable_(object);
  }
  leaveDisable(object);
  callstack.pop_back();
}

void UhdmListener::listenDisable_fork(const disable_fork* const object) {
  callstack.push_back(object);
  enterDisable_fork(object);
  if (visited.insert(object).second) {
    listenDisable_fork_(object);
  }
  leaveDisable_fork(object);
  callstack.pop_back();
}

void UhdmListener::listenContinue_stmt(const continue_stmt* const object) {
  callstack.push_back(object);
  enterContinue_stmt(object);
  if (visited.insert(object).second) {
    listenContinue_stmt_(object);
  }
  leaveContinue_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenBreak_stmt(const break_stmt* const object) {
  callstack.push_back(object);
  enterBreak_stmt(object);
  if (visited.insert(object).second) {
    listenBreak_stmt_(object);
  }
  leaveBreak_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenReturn_stmt(const return_stmt* const object) {
  callstack.push_back(object);
  enterReturn_stmt(object);
  if (visited.insert(object).second) {
    listenReturn_stmt_(object);
  }
  leaveReturn_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenWhile_stmt(const while_stmt* const object) {
  callstack.push_back(object);
  enterWhile_stmt(object);
  if (visited.insert(object).second) {
    listenWhile_stmt_(object);
  }
  leaveWhile_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenRepeat(const repeat* const object) {
  callstack.push_back(object);
  enterRepeat(object);
  if (visited.insert(object).second) {
    listenRepeat_(object);
  }
  leaveRepeat(object);
  callstack.pop_back();
}

void UhdmListener::listenDo_while(const do_while* const object) {
  callstack.push_back(object);
  enterDo_while(object);
  if (visited.insert(object).second) {
    listenDo_while_(object);
  }
  leaveDo_while(object);
  callstack.pop_back();
}

void UhdmListener::listenIf_else(const if_else* const object) {
  callstack.push_back(object);
  enterIf_else(object);
  if (visited.insert(object).second) {
    listenIf_else_(object);
  }
  leaveIf_else(object);
  callstack.pop_back();
}

void UhdmListener::listenCase_stmt(const case_stmt* const object) {
  callstack.push_back(object);
  enterCase_stmt(object);
  if (visited.insert(object).second) {
    listenCase_stmt_(object);
  }
  leaveCase_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenForce(const force* const object) {
  callstack.push_back(object);
  enterForce(object);
  if (visited.insert(object).second) {
    listenForce_(object);
  }
  leaveForce(object);
  callstack.pop_back();
}

void UhdmListener::listenAssign_stmt(const assign_stmt* const object) {
  callstack.push_back(object);
  enterAssign_stmt(object);
  if (visited.insert(object).second) {
    listenAssign_stmt_(object);
  }
  leaveAssign_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenDeassign(const deassign* const object) {
  callstack.push_back(object);
  enterDeassign(object);
  if (visited.insert(object).second) {
    listenDeassign_(object);
  }
  leaveDeassign(object);
  callstack.pop_back();
}

void UhdmListener::listenRelease(const release* const object) {
  callstack.push_back(object);
  enterRelease(object);
  if (visited.insert(object).second) {
    listenRelease_(object);
  }
  leaveRelease(object);
  callstack.pop_back();
}

void UhdmListener::listenNull_stmt(const null_stmt* const object) {
  callstack.push_back(object);
  enterNull_stmt(object);
  if (visited.insert(object).second) {
    listenNull_stmt_(object);
  }
  leaveNull_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenExpect_stmt(const expect_stmt* const object) {
  callstack.push_back(object);
  enterExpect_stmt(object);
  if (visited.insert(object).second) {
    listenExpect_stmt_(object);
  }
  leaveExpect_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenForeach_stmt(const foreach_stmt* const object) {
  callstack.push_back(object);
  enterForeach_stmt(object);
  if (visited.insert(object).second) {
    listenForeach_stmt_(object);
  }
  leaveForeach_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_scope(const gen_scope* const object) {
  callstack.push_back(object);
  enterGen_scope(object);
  if (visited.insert(object).second) {
    listenGen_scope_(object);
  }
  leaveGen_scope(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_var(const gen_var* const object) {
  callstack.push_back(object);
  enterGen_var(object);
  if (visited.insert(object).second) {
    listenGen_var_(object);
  }
  leaveGen_var(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_scope_array(const gen_scope_array* const object) {
  callstack.push_back(object);
  enterGen_scope_array(object);
  if (visited.insert(object).second) {
    listenGen_scope_array_(object);
  }
  leaveGen_scope_array(object);
  callstack.pop_back();
}

void UhdmListener::listenAssert_stmt(const assert_stmt* const object) {
  callstack.push_back(object);
  enterAssert_stmt(object);
  if (visited.insert(object).second) {
    listenAssert_stmt_(object);
  }
  leaveAssert_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenCover(const cover* const object) {
  callstack.push_back(object);
  enterCover(object);
  if (visited.insert(object).second) {
    listenCover_(object);
  }
  leaveCover(object);
  callstack.pop_back();
}

void UhdmListener::listenAssume(const assume* const object) {
  callstack.push_back(object);
  enterAssume(object);
  if (visited.insert(object).second) {
    listenAssume_(object);
  }
  leaveAssume(object);
  callstack.pop_back();
}

void UhdmListener::listenRestrict(const restrict* const object) {
  callstack.push_back(object);
  enterRestrict(object);
  if (visited.insert(object).second) {
    listenRestrict_(object);
  }
  leaveRestrict(object);
  callstack.pop_back();
}

void UhdmListener::listenImmediate_assert(const immediate_assert* const object) {
  callstack.push_back(object);
  enterImmediate_assert(object);
  if (visited.insert(object).second) {
    listenImmediate_assert_(object);
  }
  leaveImmediate_assert(object);
  callstack.pop_back();
}

void UhdmListener::listenImmediate_assume(const immediate_assume* const object) {
  callstack.push_back(object);
  enterImmediate_assume(object);
  if (visited.insert(object).second) {
    listenImmediate_assume_(object);
  }
  leaveImmediate_assume(object);
  callstack.pop_back();
}

void UhdmListener::listenImmediate_cover(const immediate_cover* const object) {
  callstack.push_back(object);
  enterImmediate_cover(object);
  if (visited.insert(object).second) {
    listenImmediate_cover_(object);
  }
  leaveImmediate_cover(object);
  callstack.pop_back();
}

void UhdmListener::listenCase_item(const case_item* const object) {
  callstack.push_back(object);
  enterCase_item(object);
  if (visited.insert(object).second) {
    listenCase_item_(object);
  }
  leaveCase_item(object);
  callstack.pop_back();
}

void UhdmListener::listenAssignment(const assignment* const object) {
  callstack.push_back(object);
  enterAssignment(object);
  if (visited.insert(object).second) {
    listenAssignment_(object);
  }
  leaveAssignment(object);
  callstack.pop_back();
}

void UhdmListener::listenAny_pattern(const any_pattern* const object) {
  callstack.push_back(object);
  enterAny_pattern(object);
  if (visited.insert(object).second) {
    listenAny_pattern_(object);
  }
  leaveAny_pattern(object);
  callstack.pop_back();
}

void UhdmListener::listenTagged_pattern(const tagged_pattern* const object) {
  callstack.push_back(object);
  enterTagged_pattern(object);
  if (visited.insert(object).second) {
    listenTagged_pattern_(object);
  }
  leaveTagged_pattern(object);
  callstack.pop_back();
}

void UhdmListener::listenStruct_pattern(const struct_pattern* const object) {
  callstack.push_back(object);
  enterStruct_pattern(object);
  if (visited.insert(object).second) {
    listenStruct_pattern_(object);
  }
  leaveStruct_pattern(object);
  callstack.pop_back();
}

void UhdmListener::listenUnsupported_expr(const unsupported_expr* const object) {
  callstack.push_back(object);
  enterUnsupported_expr(object);
  if (visited.insert(object).second) {
    listenUnsupported_expr_(object);
  }
  leaveUnsupported_expr(object);
  callstack.pop_back();
}

void UhdmListener::listenUnsupported_stmt(const unsupported_stmt* const object) {
  callstack.push_back(object);
  enterUnsupported_stmt(object);
  if (visited.insert(object).second) {
    listenUnsupported_stmt_(object);
  }
  leaveUnsupported_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenInclude_file_info(const include_file_info* const object) {
  callstack.push_back(object);
  enterInclude_file_info(object);
  if (visited.insert(object).second) {
    listenInclude_file_info_(object);
  }
  leaveInclude_file_info(object);
  callstack.pop_back();
}

void UhdmListener::listenSequence_inst(const sequence_inst* const object) {
  callstack.push_back(object);
  enterSequence_inst(object);
  if (visited.insert(object).second) {
    listenSequence_inst_(object);
  }
  leaveSequence_inst(object);
  callstack.pop_back();
}

void UhdmListener::listenSeq_formal_decl(const seq_formal_decl* const object) {
  callstack.push_back(object);
  enterSeq_formal_decl(object);
  if (visited.insert(object).second) {
    listenSeq_formal_decl_(object);
  }
  leaveSeq_formal_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenSequence_decl(const sequence_decl* const object) {
  callstack.push_back(object);
  enterSequence_decl(object);
  if (visited.insert(object).second) {
    listenSequence_decl_(object);
  }
  leaveSequence_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenProp_formal_decl(const prop_formal_decl* const object) {
  callstack.push_back(object);
  enterProp_formal_decl(object);
  if (visited.insert(object).second) {
    listenProp_formal_decl_(object);
  }
  leaveProp_formal_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenProperty_inst(const property_inst* const object) {
  callstack.push_back(object);
  enterProperty_inst(object);
  if (visited.insert(object).second) {
    listenProperty_inst_(object);
  }
  leaveProperty_inst(object);
  callstack.pop_back();
}

void UhdmListener::listenProperty_spec(const property_spec* const object) {
  callstack.push_back(object);
  enterProperty_spec(object);
  if (visited.insert(object).second) {
    listenProperty_spec_(object);
  }
  leaveProperty_spec(object);
  callstack.pop_back();
}

void UhdmListener::listenProperty_decl(const property_decl* const object) {
  callstack.push_back(object);
  enterProperty_decl(object);
  if (visited.insert(object).second) {
    listenProperty_decl_(object);
  }
  leaveProperty_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenClocked_property(const clocked_property* const object) {
  callstack.push_back(object);
  enterClocked_property(object);
  if (visited.insert(object).second) {
    listenClocked_property_(object);
  }
  leaveClocked_property(object);
  callstack.pop_back();
}

void UhdmListener::listenCase_property_item(const case_property_item* const object) {
  callstack.push_back(object);
  enterCase_property_item(object);
  if (visited.insert(object).second) {
    listenCase_property_item_(object);
  }
  leaveCase_property_item(object);
  callstack.pop_back();
}

void UhdmListener::listenCase_property(const case_property* const object) {
  callstack.push_back(object);
  enterCase_property(object);
  if (visited.insert(object).second) {
    listenCase_property_(object);
  }
  leaveCase_property(object);
  callstack.pop_back();
}

void UhdmListener::listenMulticlock_sequence_expr(const multiclock_sequence_expr* const object) {
  callstack.push_back(object);
  enterMulticlock_sequence_expr(object);
  if (visited.insert(object).second) {
    listenMulticlock_sequence_expr_(object);
  }
  leaveMulticlock_sequence_expr(object);
  callstack.pop_back();
}

void UhdmListener::listenClocked_seq(const clocked_seq* const object) {
  callstack.push_back(object);
  enterClocked_seq(object);
  if (visited.insert(object).second) {
    listenClocked_seq_(object);
  }
  leaveClocked_seq(object);
  callstack.pop_back();
}

void UhdmListener::listenConstant(const constant* const object) {
  callstack.push_back(object);
  enterConstant(object);
  if (visited.insert(object).second) {
    listenConstant_(object);
  }
  leaveConstant(object);
  callstack.pop_back();
}

void UhdmListener::listenLet_expr(const let_expr* const object) {
  callstack.push_back(object);
  enterLet_expr(object);
  if (visited.insert(object).second) {
    listenLet_expr_(object);
  }
  leaveLet_expr(object);
  callstack.pop_back();
}

void UhdmListener::listenOperation(const operation* const object) {
  callstack.push_back(object);
  enterOperation(object);
  if (visited.insert(object).second) {
    listenOperation_(object);
  }
  leaveOperation(object);
  callstack.pop_back();
}

void UhdmListener::listenRef_obj(const ref_obj* const object) {
  callstack.push_back(object);
  enterRef_obj(object);
  if (visited.insert(object).second) {
    listenRef_obj_(object);
  }
  leaveRef_obj(object);
  callstack.pop_back();
}

void UhdmListener::listenRef_module(const ref_module* const object) {
  callstack.push_back(object);
  enterRef_module(object);
  if (visited.insert(object).second) {
    listenRef_module_(object);
  }
  leaveRef_module(object);
  callstack.pop_back();
}

void UhdmListener::listenRef_typespec(const ref_typespec* const object) {
  callstack.push_back(object);
  enterRef_typespec(object);
  if (visited.insert(object).second) {
    listenRef_typespec_(object);
  }
  leaveRef_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenPart_select(const part_select* const object) {
  callstack.push_back(object);
  enterPart_select(object);
  if (visited.insert(object).second) {
    listenPart_select_(object);
  }
  leavePart_select(object);
  callstack.pop_back();
}

void UhdmListener::listenIndexed_part_select(const indexed_part_select* const object) {
  callstack.push_back(object);
  enterIndexed_part_select(object);
  if (visited.insert(object).second) {
    listenIndexed_part_select_(object);
  }
  leaveIndexed_part_select(object);
  callstack.pop_back();
}

void UhdmListener::listenVar_select(const var_select* const object) {
  callstack.push_back(object);
  enterVar_select(object);
  if (visited.insert(object).second) {
    listenVar_select_(object);
  }
  leaveVar_select(object);
  callstack.pop_back();
}

void UhdmListener::listenBit_select(const bit_select* const object) {
  callstack.push_back(object);
  enterBit_select(object);
  if (visited.insert(object).second) {
    listenBit_select_(object);
  }
  leaveBit_select(object);
  callstack.pop_back();
}

void UhdmListener::listenHier_path(const hier_path* const object) {
  callstack.push_back(object);
  enterHier_path(object);
  if (visited.insert(object).second) {
    listenHier_path_(object);
  }
  leaveHier_path(object);
  callstack.pop_back();
}

void UhdmListener::listenRef_var(const ref_var* const object) {
  callstack.push_back(object);
  enterRef_var(object);
  if (visited.insert(object).second) {
    listenRef_var_(object);
  }
  leaveRef_var(object);
  callstack.pop_back();
}

void UhdmListener::listenShort_real_var(const short_real_var* const object) {
  callstack.push_back(object);
  enterShort_real_var(object);
  if (visited.insert(object).second) {
    listenShort_real_var_(object);
  }
  leaveShort_real_var(object);
  callstack.pop_back();
}

void UhdmListener::listenReal_var(const real_var* const object) {
  callstack.push_back(object);
  enterReal_var(object);
  if (visited.insert(object).second) {
    listenReal_var_(object);
  }
  leaveReal_var(object);
  callstack.pop_back();
}

void UhdmListener::listenByte_var(const byte_var* const object) {
  callstack.push_back(object);
  enterByte_var(object);
  if (visited.insert(object).second) {
    listenByte_var_(object);
  }
  leaveByte_var(object);
  callstack.pop_back();
}

void UhdmListener::listenShort_int_var(const short_int_var* const object) {
  callstack.push_back(object);
  enterShort_int_var(object);
  if (visited.insert(object).second) {
    listenShort_int_var_(object);
  }
  leaveShort_int_var(object);
  callstack.pop_back();
}

void UhdmListener::listenInt_var(const int_var* const object) {
  callstack.push_back(object);
  enterInt_var(object);
  if (visited.insert(object).second) {
    listenInt_var_(object);
  }
  leaveInt_var(object);
  callstack.pop_back();
}

void UhdmListener::listenLong_int_var(const long_int_var* const object) {
  callstack.push_back(object);
  enterLong_int_var(object);
  if (visited.insert(object).second) {
    listenLong_int_var_(object);
  }
  leaveLong_int_var(object);
  callstack.pop_back();
}

void UhdmListener::listenInteger_var(const integer_var* const object) {
  callstack.push_back(object);
  enterInteger_var(object);
  if (visited.insert(object).second) {
    listenInteger_var_(object);
  }
  leaveInteger_var(object);
  callstack.pop_back();
}

void UhdmListener::listenTime_var(const time_var* const object) {
  callstack.push_back(object);
  enterTime_var(object);
  if (visited.insert(object).second) {
    listenTime_var_(object);
  }
  leaveTime_var(object);
  callstack.pop_back();
}

void UhdmListener::listenArray_var(const array_var* const object) {
  callstack.push_back(object);
  enterArray_var(object);
  if (visited.insert(object).second) {
    listenArray_var_(object);
  }
  leaveArray_var(object);
  callstack.pop_back();
}

void UhdmListener::listenArray_expr(const array_expr* const object) {
  callstack.push_back(object);
  enterArray_expr(object);
  if (visited.insert(object).second) {
    listenArray_expr_(object);
  }
  leaveArray_expr(object);
  callstack.pop_back();
}

void UhdmListener::listenReg_array(const reg_array* const object) {
  callstack.push_back(object);
  enterReg_array(object);
  if (visited.insert(object).second) {
    listenReg_array_(object);
  }
  leaveReg_array(object);
  callstack.pop_back();
}

void UhdmListener::listenReg(const reg* const object) {
  callstack.push_back(object);
  enterReg(object);
  if (visited.insert(object).second) {
    listenReg_(object);
  }
  leaveReg(object);
  callstack.pop_back();
}

void UhdmListener::listenPacked_array_var(const packed_array_var* const object) {
  callstack.push_back(object);
  enterPacked_array_var(object);
  if (visited.insert(object).second) {
    listenPacked_array_var_(object);
  }
  leavePacked_array_var(object);
  callstack.pop_back();
}

void UhdmListener::listenBit_var(const bit_var* const object) {
  callstack.push_back(object);
  enterBit_var(object);
  if (visited.insert(object).second) {
    listenBit_var_(object);
  }
  leaveBit_var(object);
  callstack.pop_back();
}

void UhdmListener::listenLogic_var(const logic_var* const object) {
  callstack.push_back(object);
  enterLogic_var(object);
  if (visited.insert(object).second) {
    listenLogic_var_(object);
  }
  leaveLogic_var(object);
  callstack.pop_back();
}

void UhdmListener::listenStruct_var(const struct_var* const object) {
  callstack.push_back(object);
  enterStruct_var(object);
  if (visited.insert(object).second) {
    listenStruct_var_(object);
  }
  leaveStruct_var(object);
  callstack.pop_back();
}

void UhdmListener::listenUnion_var(const union_var* const object) {
  callstack.push_back(object);
  enterUnion_var(object);
  if (visited.insert(object).second) {
    listenUnion_var_(object);
  }
  leaveUnion_var(object);
  callstack.pop_back();
}

void UhdmListener::listenEnum_var(const enum_var* const object) {
  callstack.push_back(object);
  enterEnum_var(object);
  if (visited.insert(object).second) {
    listenEnum_var_(object);
  }
  leaveEnum_var(object);
  callstack.pop_back();
}

void UhdmListener::listenString_var(const string_var* const object) {
  callstack.push_back(object);
  enterString_var(object);
  if (visited.insert(object).second) {
    listenString_var_(object);
  }
  leaveString_var(object);
  callstack.pop_back();
}

void UhdmListener::listenChandle_var(const chandle_var* const object) {
  callstack.push_back(object);
  enterChandle_var(object);
  if (visited.insert(object).second) {
    listenChandle_var_(object);
  }
  leaveChandle_var(object);
  callstack.pop_back();
}

void UhdmListener::listenVar_bit(const var_bit* const object) {
  callstack.push_back(object);
  enterVar_bit(object);
  if (visited.insert(object).second) {
    listenVar_bit_(object);
  }
  leaveVar_bit(object);
  callstack.pop_back();
}

void UhdmListener::listenTask(const task* const object) {
  callstack.push_back(object);
  enterTask(object);
  if (visited.insert(object).second) {
    listenTask_(object);
  }
  leaveTask(object);
  callstack.pop_back();
}

void UhdmListener::listenFunction(const function* const object) {
  callstack.push_back(object);
  enterFunction(object);
  if (visited.insert(object).second) {
    listenFunction_(object);
  }
  leaveFunction(object);
  callstack.pop_back();
}

void UhdmListener::listenModport(const modport* const object) {
  callstack.push_back(object);
  enterModport(object);
  if (visited.insert(object).second) {
    listenModport_(object);
  }
  leaveModport(object);
  callstack.pop_back();
}

void UhdmListener::listenInterface_tf_decl(const interface_tf_decl* const object) {
  callstack.push_back(object);
  enterInterface_tf_decl(object);
  if (visited.insert(object).second) {
    listenInterface_tf_decl_(object);
  }
  leaveInterface_tf_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenCont_assign(const cont_assign* const object) {
  callstack.push_back(object);
  enterCont_assign(object);
  if (visited.insert(object).second) {
    listenCont_assign_(object);
  }
  leaveCont_assign(object);
  callstack.pop_back();
}

void UhdmListener::listenCont_assign_bit(const cont_assign_bit* const object) {
  callstack.push_back(object);
  enterCont_assign_bit(object);
  if (visited.insert(object).second) {
    listenCont_assign_bit_(object);
  }
  leaveCont_assign_bit(object);
  callstack.pop_back();
}

void UhdmListener::listenPort(const port* const object) {
  callstack.push_back(object);
  enterPort(object);
  if (visited.insert(object).second) {
    listenPort_(object);
  }
  leavePort(object);
  callstack.pop_back();
}

void UhdmListener::listenPort_bit(const port_bit* const object) {
  callstack.push_back(object);
  enterPort_bit(object);
  if (visited.insert(object).second) {
    listenPort_bit_(object);
  }
  leavePort_bit(object);
  callstack.pop_back();
}

void UhdmListener::listenChecker_port(const checker_port* const object) {
  callstack.push_back(object);
  enterChecker_port(object);
  if (visited.insert(object).second) {
    listenChecker_port_(object);
  }
  leaveChecker_port(object);
  callstack.pop_back();
}

void UhdmListener::listenChecker_inst_port(const checker_inst_port* const object) {
  callstack.push_back(object);
  enterChecker_inst_port(object);
  if (visited.insert(object).second) {
    listenChecker_inst_port_(object);
  }
  leaveChecker_inst_port(object);
  callstack.pop_back();
}

void UhdmListener::listenGate(const gate* const object) {
  callstack.push_back(object);
  enterGate(object);
  if (visited.insert(object).second) {
    listenGate_(object);
  }
  leaveGate(object);
  callstack.pop_back();
}

void UhdmListener::listenSwitch_tran(const switch_tran* const object) {
  callstack.push_back(object);
  enterSwitch_tran(object);
  if (visited.insert(object).second) {
    listenSwitch_tran_(object);
  }
  leaveSwitch_tran(object);
  callstack.pop_back();
}

void UhdmListener::listenUdp(const udp* const object) {
  callstack.push_back(object);
  enterUdp(object);
  if (visited.insert(object).second) {
    listenUdp_(object);
  }
  leaveUdp(object);
  callstack.pop_back();
}

void UhdmListener::listenMod_path(const mod_path* const object) {
  callstack.push_back(object);
  enterMod_path(object);
  if (visited.insert(object).second) {
    listenMod_path_(object);
  }
  leaveMod_path(object);
  callstack.pop_back();
}

void UhdmListener::listenTchk(const tchk* const object) {
  callstack.push_back(object);
  enterTchk(object);
  if (visited.insert(object).second) {
    listenTchk_(object);
  }
  leaveTchk(object);
  callstack.pop_back();
}

void UhdmListener::listenRange(const range* const object) {
  callstack.push_back(object);
  enterRange(object);
  if (visited.insert(object).second) {
    listenRange_(object);
  }
  leaveRange(object);
  callstack.pop_back();
}

void UhdmListener::listenUdp_defn(const udp_defn* const object) {
  callstack.push_back(object);
  enterUdp_defn(object);
  if (visited.insert(object).second) {
    listenUdp_defn_(object);
  }
  leaveUdp_defn(object);
  callstack.pop_back();
}

void UhdmListener::listenTable_entry(const table_entry* const object) {
  callstack.push_back(object);
  enterTable_entry(object);
  if (visited.insert(object).second) {
    listenTable_entry_(object);
  }
  leaveTable_entry(object);
  callstack.pop_back();
}

void UhdmListener::listenIo_decl(const io_decl* const object) {
  callstack.push_back(object);
  enterIo_decl(object);
  if (visited.insert(object).second) {
    listenIo_decl_(object);
  }
  leaveIo_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenAlias_stmt(const alias_stmt* const object) {
  callstack.push_back(object);
  enterAlias_stmt(object);
  if (visited.insert(object).second) {
    listenAlias_stmt_(object);
  }
  leaveAlias_stmt(object);
  callstack.pop_back();
}

void UhdmListener::listenClocking_block(const clocking_block* const object) {
  callstack.push_back(object);
  enterClocking_block(object);
  if (visited.insert(object).second) {
    listenClocking_block_(object);
  }
  leaveClocking_block(object);
  callstack.pop_back();
}

void UhdmListener::listenClocking_io_decl(const clocking_io_decl* const object) {
  callstack.push_back(object);
  enterClocking_io_decl(object);
  if (visited.insert(object).second) {
    listenClocking_io_decl_(object);
  }
  leaveClocking_io_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenParam_assign(const param_assign* const object) {
  callstack.push_back(object);
  enterParam_assign(object);
  if (visited.insert(object).second) {
    listenParam_assign_(object);
  }
  leaveParam_assign(object);
  callstack.pop_back();
}

void UhdmListener::listenInterface_array(const interface_array* const object) {
  callstack.push_back(object);
  enterInterface_array(object);
  if (visited.insert(object).second) {
    listenInterface_array_(object);
  }
  leaveInterface_array(object);
  callstack.pop_back();
}

void UhdmListener::listenProgram_array(const program_array* const object) {
  callstack.push_back(object);
  enterProgram_array(object);
  if (visited.insert(object).second) {
    listenProgram_array_(object);
  }
  leaveProgram_array(object);
  callstack.pop_back();
}

void UhdmListener::listenModule_array(const module_array* const object) {
  callstack.push_back(object);
  enterModule_array(object);
  if (visited.insert(object).second) {
    listenModule_array_(object);
  }
  leaveModule_array(object);
  callstack.pop_back();
}

void UhdmListener::listenGate_array(const gate_array* const object) {
  callstack.push_back(object);
  enterGate_array(object);
  if (visited.insert(object).second) {
    listenGate_array_(object);
  }
  leaveGate_array(object);
  callstack.pop_back();
}

void UhdmListener::listenSwitch_array(const switch_array* const object) {
  callstack.push_back(object);
  enterSwitch_array(object);
  if (visited.insert(object).second) {
    listenSwitch_array_(object);
  }
  leaveSwitch_array(object);
  callstack.pop_back();
}

void UhdmListener::listenUdp_array(const udp_array* const object) {
  callstack.push_back(object);
  enterUdp_array(object);
  if (visited.insert(object).second) {
    listenUdp_array_(object);
  }
  leaveUdp_array(object);
  callstack.pop_back();
}

void UhdmListener::listenPrim_term(const prim_term* const object) {
  callstack.push_back(object);
  enterPrim_term(object);
  if (visited.insert(object).second) {
    listenPrim_term_(object);
  }
  leavePrim_term(object);
  callstack.pop_back();
}

void UhdmListener::listenPath_term(const path_term* const object) {
  callstack.push_back(object);
  enterPath_term(object);
  if (visited.insert(object).second) {
    listenPath_term_(object);
  }
  leavePath_term(object);
  callstack.pop_back();
}

void UhdmListener::listenTchk_term(const tchk_term* const object) {
  callstack.push_back(object);
  enterTchk_term(object);
  if (visited.insert(object).second) {
    listenTchk_term_(object);
  }
  leaveTchk_term(object);
  callstack.pop_back();
}

void UhdmListener::listenNet_bit(const net_bit* const object) {
  callstack.push_back(object);
  enterNet_bit(object);
  if (visited.insert(object).second) {
    listenNet_bit_(object);
  }
  leaveNet_bit(object);
  callstack.pop_back();
}

void UhdmListener::listenStruct_net(const struct_net* const object) {
  callstack.push_back(object);
  enterStruct_net(object);
  if (visited.insert(object).second) {
    listenStruct_net_(object);
  }
  leaveStruct_net(object);
  callstack.pop_back();
}

void UhdmListener::listenEnum_net(const enum_net* const object) {
  callstack.push_back(object);
  enterEnum_net(object);
  if (visited.insert(object).second) {
    listenEnum_net_(object);
  }
  leaveEnum_net(object);
  callstack.pop_back();
}

void UhdmListener::listenInteger_net(const integer_net* const object) {
  callstack.push_back(object);
  enterInteger_net(object);
  if (visited.insert(object).second) {
    listenInteger_net_(object);
  }
  leaveInteger_net(object);
  callstack.pop_back();
}

void UhdmListener::listenTime_net(const time_net* const object) {
  callstack.push_back(object);
  enterTime_net(object);
  if (visited.insert(object).second) {
    listenTime_net_(object);
  }
  leaveTime_net(object);
  callstack.pop_back();
}

void UhdmListener::listenLogic_net(const logic_net* const object) {
  callstack.push_back(object);
  enterLogic_net(object);
  if (visited.insert(object).second) {
    listenLogic_net_(object);
  }
  leaveLogic_net(object);
  callstack.pop_back();
}

void UhdmListener::listenArray_net(const array_net* const object) {
  callstack.push_back(object);
  enterArray_net(object);
  if (visited.insert(object).second) {
    listenArray_net_(object);
  }
  leaveArray_net(object);
  callstack.pop_back();
}

void UhdmListener::listenPacked_array_net(const packed_array_net* const object) {
  callstack.push_back(object);
  enterPacked_array_net(object);
  if (visited.insert(object).second) {
    listenPacked_array_net_(object);
  }
  leavePacked_array_net(object);
  callstack.pop_back();
}

void UhdmListener::listenEvent_typespec(const event_typespec* const object) {
  callstack.push_back(object);
  enterEvent_typespec(object);
  if (visited.insert(object).second) {
    listenEvent_typespec_(object);
  }
  leaveEvent_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenNamed_event(const named_event* const object) {
  callstack.push_back(object);
  enterNamed_event(object);
  if (visited.insert(object).second) {
    listenNamed_event_(object);
  }
  leaveNamed_event(object);
  callstack.pop_back();
}

void UhdmListener::listenNamed_event_array(const named_event_array* const object) {
  callstack.push_back(object);
  enterNamed_event_array(object);
  if (visited.insert(object).second) {
    listenNamed_event_array_(object);
  }
  leaveNamed_event_array(object);
  callstack.pop_back();
}

void UhdmListener::listenParameter(const parameter* const object) {
  callstack.push_back(object);
  enterParameter(object);
  if (visited.insert(object).second) {
    listenParameter_(object);
  }
  leaveParameter(object);
  callstack.pop_back();
}

void UhdmListener::listenDef_param(const def_param* const object) {
  callstack.push_back(object);
  enterDef_param(object);
  if (visited.insert(object).second) {
    listenDef_param_(object);
  }
  leaveDef_param(object);
  callstack.pop_back();
}

void UhdmListener::listenSpec_param(const spec_param* const object) {
  callstack.push_back(object);
  enterSpec_param(object);
  if (visited.insert(object).second) {
    listenSpec_param_(object);
  }
  leaveSpec_param(object);
  callstack.pop_back();
}

void UhdmListener::listenClass_typespec(const class_typespec* const object) {
  callstack.push_back(object);
  enterClass_typespec(object);
  if (visited.insert(object).second) {
    listenClass_typespec_(object);
  }
  leaveClass_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenExtends(const extends* const object) {
  callstack.push_back(object);
  enterExtends(object);
  if (visited.insert(object).second) {
    listenExtends_(object);
  }
  leaveExtends(object);
  callstack.pop_back();
}

void UhdmListener::listenClass_defn(const class_defn* const object) {
  callstack.push_back(object);
  enterClass_defn(object);
  if (visited.insert(object).second) {
    listenClass_defn_(object);
  }
  leaveClass_defn(object);
  callstack.pop_back();
}

void UhdmListener::listenClass_obj(const class_obj* const object) {
  callstack.push_back(object);
  enterClass_obj(object);
  if (visited.insert(object).second) {
    listenClass_obj_(object);
  }
  leaveClass_obj(object);
  callstack.pop_back();
}

void UhdmListener::listenClass_var(const class_var* const object) {
  callstack.push_back(object);
  enterClass_var(object);
  if (visited.insert(object).second) {
    listenClass_var_(object);
  }
  leaveClass_var(object);
  callstack.pop_back();
}

void UhdmListener::listenInterface_inst(const interface_inst* const object) {
  callstack.push_back(object);
  enterInterface_inst(object);
  if (visited.insert(object).second) {
    listenInterface_inst_(object);
  }
  leaveInterface_inst(object);
  callstack.pop_back();
}

void UhdmListener::listenProgram(const program* const object) {
  callstack.push_back(object);
  enterProgram(object);
  if (visited.insert(object).second) {
    listenProgram_(object);
  }
  leaveProgram(object);
  callstack.pop_back();
}

void UhdmListener::listenPackage(const package* const object) {
  callstack.push_back(object);
  enterPackage(object);
  if (visited.insert(object).second) {
    listenPackage_(object);
  }
  leavePackage(object);
  callstack.pop_back();
}

void UhdmListener::listenModule_inst(const module_inst* const object) {
  callstack.push_back(object);
  enterModule_inst(object);
  if (visited.insert(object).second) {
    listenModule_inst_(object);
  }
  leaveModule_inst(object);
  callstack.pop_back();
}

void UhdmListener::listenChecker_decl(const checker_decl* const object) {
  callstack.push_back(object);
  enterChecker_decl(object);
  if (visited.insert(object).second) {
    listenChecker_decl_(object);
  }
  leaveChecker_decl(object);
  callstack.pop_back();
}

void UhdmListener::listenChecker_inst(const checker_inst* const object) {
  callstack.push_back(object);
  enterChecker_inst(object);
  if (visited.insert(object).second) {
    listenChecker_inst_(object);
  }
  leaveChecker_inst(object);
  callstack.pop_back();
}

void UhdmListener::listenShort_real_typespec(const short_real_typespec* const object) {
  callstack.push_back(object);
  enterShort_real_typespec(object);
  if (visited.insert(object).second) {
    listenShort_real_typespec_(object);
  }
  leaveShort_real_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenReal_typespec(const real_typespec* const object) {
  callstack.push_back(object);
  enterReal_typespec(object);
  if (visited.insert(object).second) {
    listenReal_typespec_(object);
  }
  leaveReal_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenByte_typespec(const byte_typespec* const object) {
  callstack.push_back(object);
  enterByte_typespec(object);
  if (visited.insert(object).second) {
    listenByte_typespec_(object);
  }
  leaveByte_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenShort_int_typespec(const short_int_typespec* const object) {
  callstack.push_back(object);
  enterShort_int_typespec(object);
  if (visited.insert(object).second) {
    listenShort_int_typespec_(object);
  }
  leaveShort_int_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenInt_typespec(const int_typespec* const object) {
  callstack.push_back(object);
  enterInt_typespec(object);
  if (visited.insert(object).second) {
    listenInt_typespec_(object);
  }
  leaveInt_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenLong_int_typespec(const long_int_typespec* const object) {
  callstack.push_back(object);
  enterLong_int_typespec(object);
  if (visited.insert(object).second) {
    listenLong_int_typespec_(object);
  }
  leaveLong_int_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenInteger_typespec(const integer_typespec* const object) {
  callstack.push_back(object);
  enterInteger_typespec(object);
  if (visited.insert(object).second) {
    listenInteger_typespec_(object);
  }
  leaveInteger_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenTime_typespec(const time_typespec* const object) {
  callstack.push_back(object);
  enterTime_typespec(object);
  if (visited.insert(object).second) {
    listenTime_typespec_(object);
  }
  leaveTime_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenEnum_typespec(const enum_typespec* const object) {
  callstack.push_back(object);
  enterEnum_typespec(object);
  if (visited.insert(object).second) {
    listenEnum_typespec_(object);
  }
  leaveEnum_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenString_typespec(const string_typespec* const object) {
  callstack.push_back(object);
  enterString_typespec(object);
  if (visited.insert(object).second) {
    listenString_typespec_(object);
  }
  leaveString_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenChandle_typespec(const chandle_typespec* const object) {
  callstack.push_back(object);
  enterChandle_typespec(object);
  if (visited.insert(object).second) {
    listenChandle_typespec_(object);
  }
  leaveChandle_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenModule_typespec(const module_typespec* const object) {
  callstack.push_back(object);
  enterModule_typespec(object);
  if (visited.insert(object).second) {
    listenModule_typespec_(object);
  }
  leaveModule_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenStruct_typespec(const struct_typespec* const object) {
  callstack.push_back(object);
  enterStruct_typespec(object);
  if (visited.insert(object).second) {
    listenStruct_typespec_(object);
  }
  leaveStruct_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenUnion_typespec(const union_typespec* const object) {
  callstack.push_back(object);
  enterUnion_typespec(object);
  if (visited.insert(object).second) {
    listenUnion_typespec_(object);
  }
  leaveUnion_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenLogic_typespec(const logic_typespec* const object) {
  callstack.push_back(object);
  enterLogic_typespec(object);
  if (visited.insert(object).second) {
    listenLogic_typespec_(object);
  }
  leaveLogic_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenPacked_array_typespec(const packed_array_typespec* const object) {
  callstack.push_back(object);
  enterPacked_array_typespec(object);
  if (visited.insert(object).second) {
    listenPacked_array_typespec_(object);
  }
  leavePacked_array_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenArray_typespec(const array_typespec* const object) {
  callstack.push_back(object);
  enterArray_typespec(object);
  if (visited.insert(object).second) {
    listenArray_typespec_(object);
  }
  leaveArray_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenVoid_typespec(const void_typespec* const object) {
  callstack.push_back(object);
  enterVoid_typespec(object);
  if (visited.insert(object).second) {
    listenVoid_typespec_(object);
  }
  leaveVoid_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenUnsupported_typespec(const unsupported_typespec* const object) {
  callstack.push_back(object);
  enterUnsupported_typespec(object);
  if (visited.insert(object).second) {
    listenUnsupported_typespec_(object);
  }
  leaveUnsupported_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenSequence_typespec(const sequence_typespec* const object) {
  callstack.push_back(object);
  enterSequence_typespec(object);
  if (visited.insert(object).second) {
    listenSequence_typespec_(object);
  }
  leaveSequence_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenProperty_typespec(const property_typespec* const object) {
  callstack.push_back(object);
  enterProperty_typespec(object);
  if (visited.insert(object).second) {
    listenProperty_typespec_(object);
  }
  leaveProperty_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenInterface_typespec(const interface_typespec* const object) {
  callstack.push_back(object);
  enterInterface_typespec(object);
  if (visited.insert(object).second) {
    listenInterface_typespec_(object);
  }
  leaveInterface_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenType_parameter(const type_parameter* const object) {
  callstack.push_back(object);
  enterType_parameter(object);
  if (visited.insert(object).second) {
    listenType_parameter_(object);
  }
  leaveType_parameter(object);
  callstack.pop_back();
}

void UhdmListener::listenTypespec_member(const typespec_member* const object) {
  callstack.push_back(object);
  enterTypespec_member(object);
  if (visited.insert(object).second) {
    listenTypespec_member_(object);
  }
  leaveTypespec_member(object);
  callstack.pop_back();
}

void UhdmListener::listenEnum_const(const enum_const* const object) {
  callstack.push_back(object);
  enterEnum_const(object);
  if (visited.insert(object).second) {
    listenEnum_const_(object);
  }
  leaveEnum_const(object);
  callstack.pop_back();
}

void UhdmListener::listenBit_typespec(const bit_typespec* const object) {
  callstack.push_back(object);
  enterBit_typespec(object);
  if (visited.insert(object).second) {
    listenBit_typespec_(object);
  }
  leaveBit_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenUser_systf(const user_systf* const object) {
  callstack.push_back(object);
  enterUser_systf(object);
  if (visited.insert(object).second) {
    listenUser_systf_(object);
  }
  leaveUser_systf(object);
  callstack.pop_back();
}

void UhdmListener::listenSys_func_call(const sys_func_call* const object) {
  callstack.push_back(object);
  enterSys_func_call(object);
  if (visited.insert(object).second) {
    listenSys_func_call_(object);
  }
  leaveSys_func_call(object);
  callstack.pop_back();
}

void UhdmListener::listenSys_task_call(const sys_task_call* const object) {
  callstack.push_back(object);
  enterSys_task_call(object);
  if (visited.insert(object).second) {
    listenSys_task_call_(object);
  }
  leaveSys_task_call(object);
  callstack.pop_back();
}

void UhdmListener::listenMethod_func_call(const method_func_call* const object) {
  callstack.push_back(object);
  enterMethod_func_call(object);
  if (visited.insert(object).second) {
    listenMethod_func_call_(object);
  }
  leaveMethod_func_call(object);
  callstack.pop_back();
}

void UhdmListener::listenMethod_task_call(const method_task_call* const object) {
  callstack.push_back(object);
  enterMethod_task_call(object);
  if (visited.insert(object).second) {
    listenMethod_task_call_(object);
  }
  leaveMethod_task_call(object);
  callstack.pop_back();
}

void UhdmListener::listenFunc_call(const func_call* const object) {
  callstack.push_back(object);
  enterFunc_call(object);
  if (visited.insert(object).second) {
    listenFunc_call_(object);
  }
  leaveFunc_call(object);
  callstack.pop_back();
}

void UhdmListener::listenTask_call(const task_call* const object) {
  callstack.push_back(object);
  enterTask_call(object);
  if (visited.insert(object).second) {
    listenTask_call_(object);
  }
  leaveTask_call(object);
  callstack.pop_back();
}

void UhdmListener::listenConstraint_ordering(const constraint_ordering* const object) {
  callstack.push_back(object);
  enterConstraint_ordering(object);
  if (visited.insert(object).second) {
    listenConstraint_ordering_(object);
  }
  leaveConstraint_ordering(object);
  callstack.pop_back();
}

void UhdmListener::listenConstraint(const constraint* const object) {
  callstack.push_back(object);
  enterConstraint(object);
  if (visited.insert(object).second) {
    listenConstraint_(object);
  }
  leaveConstraint(object);
  callstack.pop_back();
}

void UhdmListener::listenImport_typespec(const import_typespec* const object) {
  callstack.push_back(object);
  enterImport_typespec(object);
  if (visited.insert(object).second) {
    listenImport_typespec_(object);
  }
  leaveImport_typespec(object);
  callstack.pop_back();
}

void UhdmListener::listenDist_item(const dist_item* const object) {
  callstack.push_back(object);
  enterDist_item(object);
  if (visited.insert(object).second) {
    listenDist_item_(object);
  }
  leaveDist_item(object);
  callstack.pop_back();
}

void UhdmListener::listenDistribution(const distribution* const object) {
  callstack.push_back(object);
  enterDistribution(object);
  if (visited.insert(object).second) {
    listenDistribution_(object);
  }
  leaveDistribution(object);
  callstack.pop_back();
}

void UhdmListener::listenImplication(const implication* const object) {
  callstack.push_back(object);
  enterImplication(object);
  if (visited.insert(object).second) {
    listenImplication_(object);
  }
  leaveImplication(object);
  callstack.pop_back();
}

void UhdmListener::listenConstr_if(const constr_if* const object) {
  callstack.push_back(object);
  enterConstr_if(object);
  if (visited.insert(object).second) {
    listenConstr_if_(object);
  }
  leaveConstr_if(object);
  callstack.pop_back();
}

void UhdmListener::listenConstr_if_else(const constr_if_else* const object) {
  callstack.push_back(object);
  enterConstr_if_else(object);
  if (visited.insert(object).second) {
    listenConstr_if_else_(object);
  }
  leaveConstr_if_else(object);
  callstack.pop_back();
}

void UhdmListener::listenConstr_foreach(const constr_foreach* const object) {
  callstack.push_back(object);
  enterConstr_foreach(object);
  if (visited.insert(object).second) {
    listenConstr_foreach_(object);
  }
  leaveConstr_foreach(object);
  callstack.pop_back();
}

void UhdmListener::listenSoft_disable(const soft_disable* const object) {
  callstack.push_back(object);
  enterSoft_disable(object);
  if (visited.insert(object).second) {
    listenSoft_disable_(object);
  }
  leaveSoft_disable(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_if(const gen_if* const object) {
  callstack.push_back(object);
  enterGen_if(object);
  if (visited.insert(object).second) {
    listenGen_if_(object);
  }
  leaveGen_if(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_if_else(const gen_if_else* const object) {
  callstack.push_back(object);
  enterGen_if_else(object);
  if (visited.insert(object).second) {
    listenGen_if_else_(object);
  }
  leaveGen_if_else(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_for(const gen_for* const object) {
  callstack.push_back(object);
  enterGen_for(object);
  if (visited.insert(object).second) {
    listenGen_for_(object);
  }
  leaveGen_for(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_case(const gen_case* const object) {
  callstack.push_back(object);
  enterGen_case(object);
  if (visited.insert(object).second) {
    listenGen_case_(object);
  }
  leaveGen_case(object);
  callstack.pop_back();
}

void UhdmListener::listenGen_region(const gen_region* const object) {
  callstack.push_back(object);
  enterGen_region(object);
  if (visited.insert(object).second) {
    listenGen_region_(object);
  }
  leaveGen_region(object);
  callstack.pop_back();
}

void UhdmListener::listenDesign(const design* const object) {
  callstack.push_back(object);
  enterDesign(object);
  if (visited.insert(object).second) {
    listenDesign_(object);
  }
  leaveDesign(object);
  callstack.pop_back();
}

void UhdmListener::listenAny(const any* const object) {
  const bool revisiting = visited.find(object) != visited.end();
  if (!revisiting) enterAny(object);

  switch (object->UhdmType()) {
  case UHDM_OBJECT_TYPE::uhdmalias_stmt: listenAlias_stmt(static_cast<const alias_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmalways: listenAlways(static_cast<const always *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmany_pattern: listenAny_pattern(static_cast<const any_pattern *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmarray_expr: listenArray_expr(static_cast<const array_expr *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmarray_net: listenArray_net(static_cast<const array_net *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmarray_typespec: listenArray_typespec(static_cast<const array_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmarray_var: listenArray_var(static_cast<const array_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmassert_stmt: listenAssert_stmt(static_cast<const assert_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmassign_stmt: listenAssign_stmt(static_cast<const assign_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmassignment: listenAssignment(static_cast<const assignment *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmassume: listenAssume(static_cast<const assume *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmattribute: listenAttribute(static_cast<const attribute *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmbegin: listenBegin(static_cast<const begin *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmbit_select: listenBit_select(static_cast<const bit_select *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmbit_typespec: listenBit_typespec(static_cast<const bit_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmbit_var: listenBit_var(static_cast<const bit_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmbreak_stmt: listenBreak_stmt(static_cast<const break_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmbyte_typespec: listenByte_typespec(static_cast<const byte_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmbyte_var: listenByte_var(static_cast<const byte_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcase_item: listenCase_item(static_cast<const case_item *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcase_property: listenCase_property(static_cast<const case_property *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcase_property_item: listenCase_property_item(static_cast<const case_property_item *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcase_stmt: listenCase_stmt(static_cast<const case_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmchandle_typespec: listenChandle_typespec(static_cast<const chandle_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmchandle_var: listenChandle_var(static_cast<const chandle_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmchecker_decl: listenChecker_decl(static_cast<const checker_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmchecker_inst: listenChecker_inst(static_cast<const checker_inst *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmchecker_inst_port: listenChecker_inst_port(static_cast<const checker_inst_port *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmchecker_port: listenChecker_port(static_cast<const checker_port *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclass_defn: listenClass_defn(static_cast<const class_defn *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclass_obj: listenClass_obj(static_cast<const class_obj *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclass_typespec: listenClass_typespec(static_cast<const class_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclass_var: listenClass_var(static_cast<const class_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclocked_property: listenClocked_property(static_cast<const clocked_property *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclocked_seq: listenClocked_seq(static_cast<const clocked_seq *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclocking_block: listenClocking_block(static_cast<const clocking_block *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmclocking_io_decl: listenClocking_io_decl(static_cast<const clocking_io_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmconstant: listenConstant(static_cast<const constant *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmconstr_foreach: listenConstr_foreach(static_cast<const constr_foreach *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmconstr_if: listenConstr_if(static_cast<const constr_if *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmconstr_if_else: listenConstr_if_else(static_cast<const constr_if_else *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmconstraint: listenConstraint(static_cast<const constraint *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmconstraint_ordering: listenConstraint_ordering(static_cast<const constraint_ordering *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcont_assign: listenCont_assign(static_cast<const cont_assign *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcont_assign_bit: listenCont_assign_bit(static_cast<const cont_assign_bit *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcontinue_stmt: listenContinue_stmt(static_cast<const continue_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmcover: listenCover(static_cast<const cover *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdeassign: listenDeassign(static_cast<const deassign *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdef_param: listenDef_param(static_cast<const def_param *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdelay_control: listenDelay_control(static_cast<const delay_control *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdelay_term: listenDelay_term(static_cast<const delay_term *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdesign: listenDesign(static_cast<const design *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdisable: listenDisable(static_cast<const disable *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdisable_fork: listenDisable_fork(static_cast<const disable_fork *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdist_item: listenDist_item(static_cast<const dist_item *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdistribution: listenDistribution(static_cast<const distribution *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmdo_while: listenDo_while(static_cast<const do_while *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmenum_const: listenEnum_const(static_cast<const enum_const *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmenum_net: listenEnum_net(static_cast<const enum_net *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmenum_typespec: listenEnum_typespec(static_cast<const enum_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmenum_var: listenEnum_var(static_cast<const enum_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmevent_control: listenEvent_control(static_cast<const event_control *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmevent_stmt: listenEvent_stmt(static_cast<const event_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmevent_typespec: listenEvent_typespec(static_cast<const event_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmexpect_stmt: listenExpect_stmt(static_cast<const expect_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmextends: listenExtends(static_cast<const extends *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmfinal_stmt: listenFinal_stmt(static_cast<const final_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmfor_stmt: listenFor_stmt(static_cast<const for_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmforce: listenForce(static_cast<const force *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmforeach_stmt: listenForeach_stmt(static_cast<const foreach_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmforever_stmt: listenForever_stmt(static_cast<const forever_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmfork_stmt: listenFork_stmt(static_cast<const fork_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmfunc_call: listenFunc_call(static_cast<const func_call *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmfunction: listenFunction(static_cast<const function *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgate: listenGate(static_cast<const gate *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgate_array: listenGate_array(static_cast<const gate_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_case: listenGen_case(static_cast<const gen_case *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_for: listenGen_for(static_cast<const gen_for *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_if: listenGen_if(static_cast<const gen_if *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_if_else: listenGen_if_else(static_cast<const gen_if_else *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_region: listenGen_region(static_cast<const gen_region *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_scope: listenGen_scope(static_cast<const gen_scope *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_scope_array: listenGen_scope_array(static_cast<const gen_scope_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmgen_var: listenGen_var(static_cast<const gen_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmhier_path: listenHier_path(static_cast<const hier_path *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmif_else: listenIf_else(static_cast<const if_else *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmif_stmt: listenIf_stmt(static_cast<const if_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmimmediate_assert: listenImmediate_assert(static_cast<const immediate_assert *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmimmediate_assume: listenImmediate_assume(static_cast<const immediate_assume *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmimmediate_cover: listenImmediate_cover(static_cast<const immediate_cover *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmimplication: listenImplication(static_cast<const implication *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmimport_typespec: listenImport_typespec(static_cast<const import_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminclude_file_info: listenInclude_file_info(static_cast<const include_file_info *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmindexed_part_select: listenIndexed_part_select(static_cast<const indexed_part_select *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminitial: listenInitial(static_cast<const initial *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmint_typespec: listenInt_typespec(static_cast<const int_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmint_var: listenInt_var(static_cast<const int_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminteger_net: listenInteger_net(static_cast<const integer_net *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminteger_typespec: listenInteger_typespec(static_cast<const integer_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminteger_var: listenInteger_var(static_cast<const integer_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminterface_array: listenInterface_array(static_cast<const interface_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminterface_inst: listenInterface_inst(static_cast<const interface_inst *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminterface_tf_decl: listenInterface_tf_decl(static_cast<const interface_tf_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdminterface_typespec: listenInterface_typespec(static_cast<const interface_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmio_decl: listenIo_decl(static_cast<const io_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmlet_decl: listenLet_decl(static_cast<const let_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmlet_expr: listenLet_expr(static_cast<const let_expr *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmlogic_net: listenLogic_net(static_cast<const logic_net *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmlogic_typespec: listenLogic_typespec(static_cast<const logic_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmlogic_var: listenLogic_var(static_cast<const logic_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmlong_int_typespec: listenLong_int_typespec(static_cast<const long_int_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmlong_int_var: listenLong_int_var(static_cast<const long_int_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmethod_func_call: listenMethod_func_call(static_cast<const method_func_call *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmethod_task_call: listenMethod_task_call(static_cast<const method_task_call *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmod_path: listenMod_path(static_cast<const mod_path *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmodport: listenModport(static_cast<const modport *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmodule_array: listenModule_array(static_cast<const module_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmodule_inst: listenModule_inst(static_cast<const module_inst *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmodule_typespec: listenModule_typespec(static_cast<const module_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmmulticlock_sequence_expr: listenMulticlock_sequence_expr(static_cast<const multiclock_sequence_expr *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmnamed_begin: listenNamed_begin(static_cast<const named_begin *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmnamed_event: listenNamed_event(static_cast<const named_event *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmnamed_event_array: listenNamed_event_array(static_cast<const named_event_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmnamed_fork: listenNamed_fork(static_cast<const named_fork *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmnet_bit: listenNet_bit(static_cast<const net_bit *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmnull_stmt: listenNull_stmt(static_cast<const null_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmoperation: listenOperation(static_cast<const operation *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmordered_wait: listenOrdered_wait(static_cast<const ordered_wait *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmpackage: listenPackage(static_cast<const package *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmpacked_array_net: listenPacked_array_net(static_cast<const packed_array_net *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmpacked_array_typespec: listenPacked_array_typespec(static_cast<const packed_array_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmpacked_array_var: listenPacked_array_var(static_cast<const packed_array_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmparam_assign: listenParam_assign(static_cast<const param_assign *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmparameter: listenParameter(static_cast<const parameter *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmpart_select: listenPart_select(static_cast<const part_select *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmpath_term: listenPath_term(static_cast<const path_term *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmport: listenPort(static_cast<const port *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmport_bit: listenPort_bit(static_cast<const port_bit *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmprim_term: listenPrim_term(static_cast<const prim_term *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmprogram: listenProgram(static_cast<const program *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmprogram_array: listenProgram_array(static_cast<const program_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmprop_formal_decl: listenProp_formal_decl(static_cast<const prop_formal_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmproperty_decl: listenProperty_decl(static_cast<const property_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmproperty_inst: listenProperty_inst(static_cast<const property_inst *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmproperty_spec: listenProperty_spec(static_cast<const property_spec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmproperty_typespec: listenProperty_typespec(static_cast<const property_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmrange: listenRange(static_cast<const range *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmreal_typespec: listenReal_typespec(static_cast<const real_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmreal_var: listenReal_var(static_cast<const real_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmref_module: listenRef_module(static_cast<const ref_module *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmref_obj: listenRef_obj(static_cast<const ref_obj *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmref_typespec: listenRef_typespec(static_cast<const ref_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmref_var: listenRef_var(static_cast<const ref_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmreg: listenReg(static_cast<const reg *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmreg_array: listenReg_array(static_cast<const reg_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmrelease: listenRelease(static_cast<const release *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmrepeat: listenRepeat(static_cast<const repeat *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmrepeat_control: listenRepeat_control(static_cast<const repeat_control *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmrestrict: listenRestrict(static_cast<const restrict *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmreturn_stmt: listenReturn_stmt(static_cast<const return_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmseq_formal_decl: listenSeq_formal_decl(static_cast<const seq_formal_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmsequence_decl: listenSequence_decl(static_cast<const sequence_decl *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmsequence_inst: listenSequence_inst(static_cast<const sequence_inst *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmsequence_typespec: listenSequence_typespec(static_cast<const sequence_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmshort_int_typespec: listenShort_int_typespec(static_cast<const short_int_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmshort_int_var: listenShort_int_var(static_cast<const short_int_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmshort_real_typespec: listenShort_real_typespec(static_cast<const short_real_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmshort_real_var: listenShort_real_var(static_cast<const short_real_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmsoft_disable: listenSoft_disable(static_cast<const soft_disable *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmspec_param: listenSpec_param(static_cast<const spec_param *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmstring_typespec: listenString_typespec(static_cast<const string_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmstring_var: listenString_var(static_cast<const string_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmstruct_net: listenStruct_net(static_cast<const struct_net *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmstruct_pattern: listenStruct_pattern(static_cast<const struct_pattern *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmstruct_typespec: listenStruct_typespec(static_cast<const struct_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmstruct_var: listenStruct_var(static_cast<const struct_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmswitch_array: listenSwitch_array(static_cast<const switch_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmswitch_tran: listenSwitch_tran(static_cast<const switch_tran *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmsys_func_call: listenSys_func_call(static_cast<const sys_func_call *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmsys_task_call: listenSys_task_call(static_cast<const sys_task_call *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtable_entry: listenTable_entry(static_cast<const table_entry *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtagged_pattern: listenTagged_pattern(static_cast<const tagged_pattern *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtask: listenTask(static_cast<const task *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtask_call: listenTask_call(static_cast<const task_call *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtchk: listenTchk(static_cast<const tchk *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtchk_term: listenTchk_term(static_cast<const tchk_term *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmthread_obj: listenThread_obj(static_cast<const thread_obj *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtime_net: listenTime_net(static_cast<const time_net *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtime_typespec: listenTime_typespec(static_cast<const time_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtime_var: listenTime_var(static_cast<const time_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtype_parameter: listenType_parameter(static_cast<const type_parameter *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmtypespec_member: listenTypespec_member(static_cast<const typespec_member *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmudp: listenUdp(static_cast<const udp *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmudp_array: listenUdp_array(static_cast<const udp_array *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmudp_defn: listenUdp_defn(static_cast<const udp_defn *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmunion_typespec: listenUnion_typespec(static_cast<const union_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmunion_var: listenUnion_var(static_cast<const union_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmunsupported_expr: listenUnsupported_expr(static_cast<const unsupported_expr *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmunsupported_stmt: listenUnsupported_stmt(static_cast<const unsupported_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmunsupported_typespec: listenUnsupported_typespec(static_cast<const unsupported_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmuser_systf: listenUser_systf(static_cast<const user_systf *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmvar_bit: listenVar_bit(static_cast<const var_bit *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmvar_select: listenVar_select(static_cast<const var_select *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmvirtual_interface_var: listenVirtual_interface_var(static_cast<const virtual_interface_var *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmvoid_typespec: listenVoid_typespec(static_cast<const void_typespec *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmwait_fork: listenWait_fork(static_cast<const wait_fork *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmwait_stmt: listenWait_stmt(static_cast<const wait_stmt *>(object)); break;
  case UHDM_OBJECT_TYPE::uhdmwhile_stmt: listenWhile_stmt(static_cast<const while_stmt *>(object)); break;
  default: break;
  }

  if (!revisiting) leaveAny(object);
}

} // namespace UHDM
