/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   array_expr.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/array_expr.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* array_expr::GetByVpiName(std::string_view name) const {
  if (exprs_ != nullptr) {
    for (const BaseClass *ref : *exprs_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> array_expr::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiExpr: return std::make_tuple(nullptr, uhdmexprs, (const std::vector<const BaseClass*>*)exprs_);
  }
  return basetype_t::GetByVpiType(type);
}

array_expr::vpi_property_value_t array_expr::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void array_expr::DeepCopy(array_expr* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterArray_expr(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Exprs()) {
    auto clone_vec = context->m_serializer->MakeExprVec();
    clone->Exprs(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveArray_expr(clone, nullptr);
}

array_expr* array_expr::DeepClone(BaseClass* parent, CloneContext* context) const {
  array_expr* const clone = context->m_serializer->MakeArray_expr();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t array_expr::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs, lhs->Exprs(), rhs, rhs->Exprs(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
