/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   array_typespec.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/array_typespec.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/function.h>
#include <uhdm/range.h>
#include <uhdm/ref_typespec.h>


namespace UHDM {
const BaseClass* array_typespec::GetByVpiName(std::string_view name) const {
  if (ranges_ != nullptr) {
    for (const BaseClass *ref : *ranges_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((left_expr_ != nullptr) && (left_expr_->VpiName().compare(name) == 0)) {
    return left_expr_;
  }
  if ((right_expr_ != nullptr) && (right_expr_->VpiName().compare(name) == 0)) {
    return right_expr_;
  }
  if ((index_typespec_ != nullptr) && (index_typespec_->VpiName().compare(name) == 0)) {
    return index_typespec_;
  }
  if ((elem_typespec_ != nullptr) && (elem_typespec_->VpiName().compare(name) == 0)) {
    return elem_typespec_;
  }
  if ((resolution_func_ != nullptr) && (resolution_func_->VpiName().compare(name) == 0)) {
    return resolution_func_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> array_typespec::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiElemTypespec: return std::make_tuple(elem_typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiFunction: return std::make_tuple(resolution_func_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiIndexTypespec: return std::make_tuple(index_typespec_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLeftRange: return std::make_tuple(left_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRange: return std::make_tuple(nullptr, uhdmranges, (const std::vector<const BaseClass*>*)ranges_);
    case vpiRightRange: return std::make_tuple(right_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

array_typespec::vpi_property_value_t array_typespec::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiArrayType: return vpi_property_value_t(VpiArrayType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void array_typespec::DeepCopy(array_typespec* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterArray_typespec(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Ranges()) {
    auto clone_vec = context->m_serializer->MakeRangeVec();
    clone->Ranges(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Left_expr()) clone->Left_expr(obj->DeepClone(clone, context));
  if (auto obj = Right_expr()) clone->Right_expr(obj->DeepClone(clone, context));
  if (auto obj = Index_typespec()) clone->Index_typespec(obj->DeepClone(clone, context));
  if (auto obj = Elem_typespec()) clone->Elem_typespec(obj->DeepClone(clone, context));
  if (auto obj = Resolution_func()) clone->Resolution_func(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveArray_typespec(clone, nullptr);
}

array_typespec* array_typespec::DeepClone(BaseClass* parent, CloneContext* context) const {
  array_typespec* const clone = context->m_serializer->MakeArray_typespec();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t array_typespec::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiArrayType() - rhs->VpiArrayType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Ranges(), rhs, rhs->Ranges(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Left_expr(), rhs->Left_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_expr(), rhs->Right_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Index_typespec(), rhs->Index_typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Elem_typespec(), rhs->Elem_typespec(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Resolution_func(), rhs->Resolution_func(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
