/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   array_var.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/array_var.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>
#include <uhdm/range.h>
#include <uhdm/var_select.h>
#include <uhdm/variables.h>


namespace UHDM {
const BaseClass* array_var::GetByVpiName(std::string_view name) const {
  if (var_selects_ != nullptr) {
    for (const BaseClass *ref : *var_selects_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if (ranges_ != nullptr) {
    for (const BaseClass *ref : *ranges_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  if ((left_expr_ != nullptr) && (left_expr_->VpiName().compare(name) == 0)) {
    return left_expr_;
  }
  if ((right_expr_ != nullptr) && (right_expr_->VpiName().compare(name) == 0)) {
    return right_expr_;
  }
  if (variables_ != nullptr) {
    for (const BaseClass *ref : *variables_) {
      if (ref->VpiName().compare(name) == 0) return ref;
    }
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> array_var::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiLeftRange: return std::make_tuple(left_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRange: return std::make_tuple(nullptr, uhdmranges, (const std::vector<const BaseClass*>*)ranges_);
    case vpiReg: return std::make_tuple(nullptr, uhdmvariables, (const std::vector<const BaseClass*>*)variables_);
    case vpiRightRange: return std::make_tuple(right_expr_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiVarSelect: return std::make_tuple(nullptr, uhdmvar_selects, (const std::vector<const BaseClass*>*)var_selects_);
  }
  return basetype_t::GetByVpiType(type);
}

array_var::vpi_property_value_t array_var::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiArrayType: return vpi_property_value_t(VpiArrayType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void array_var::DeepCopy(array_var* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterArray_var(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto vec = Var_selects()) {
    auto clone_vec = context->m_serializer->MakeVar_selectVec();
    clone->Var_selects(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto vec = Ranges()) {
    auto clone_vec = context->m_serializer->MakeRangeVec();
    clone->Ranges(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  if (auto obj = Left_expr()) clone->Left_expr(obj->DeepClone(clone, context));
  if (auto obj = Right_expr()) clone->Right_expr(obj->DeepClone(clone, context));
  if (auto vec = Variables()) {
    auto clone_vec = context->m_serializer->MakeVariablesVec();
    clone->Variables(clone_vec);
    for (auto obj : *vec) {
      clone_vec->push_back(obj->DeepClone(clone, context));
    }
  }
  elaboratorContext->m_elaborator.leaveArray_var(clone, nullptr);
}

array_var* array_var::DeepClone(BaseClass* parent, CloneContext* context) const {
  array_var* const clone = context->m_serializer->MakeArray_var();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t array_var::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiArrayType() - rhs->VpiArrayType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs, lhs->Var_selects(), rhs, rhs->Var_selects(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Ranges(), rhs, rhs->Ranges(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Left_expr(), rhs->Left_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Right_expr(), rhs->Right_expr(), context)) != 0) return r;
  if ((r = SafeCompare(lhs, lhs->Variables(), rhs, rhs->Variables(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
