/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   assign_stmt.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/assign_stmt.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/expr.h>


namespace UHDM {
const BaseClass* assign_stmt::GetByVpiName(std::string_view name) const {
  if ((rhs_ != nullptr) && (rhs_->VpiName().compare(name) == 0)) {
    return rhs_;
  }
  if ((lhs_ != nullptr) && (lhs_->VpiName().compare(name) == 0)) {
    return lhs_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> assign_stmt::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiLhs: return std::make_tuple(lhs_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRhs: return std::make_tuple(rhs_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

assign_stmt::vpi_property_value_t assign_stmt::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void assign_stmt::DeepCopy(assign_stmt* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterAssign_stmt(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Rhs()) clone->Rhs(obj->DeepClone(clone, context));
  if (auto obj = Lhs()) clone->Lhs(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveAssign_stmt(clone, nullptr);
}

assign_stmt* assign_stmt::DeepClone(BaseClass* parent, CloneContext* context) const {
  assign_stmt* const clone = context->m_serializer->MakeAssign_stmt();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t assign_stmt::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = SafeCompare(lhs->Rhs(), rhs->Rhs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Lhs(), rhs->Lhs(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
