/*
 Do not modify, auto-generated by script

 Copyright 2019 Alain Dargelas

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
 * File:   assignment.cpp
 * Author:
 *
 * Created on December 14, 2019, 10:03 PM
 */

#include <uhdm/assignment.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/ElaboratorListener.h>
#include <uhdm/Serializer.h>
#include <uhdm/delay_control.h>
#include <uhdm/event_control.h>
#include <uhdm/expr.h>
#include <uhdm/expr_interf_expr_group.h>
#include <uhdm/repeat_control.h>


namespace UHDM {
const BaseClass* assignment::GetByVpiName(std::string_view name) const {
  if ((rhs_ != nullptr) && (rhs_->VpiName().compare(name) == 0)) {
    return rhs_;
  }
  if ((lhs_ != nullptr) && (lhs_->VpiName().compare(name) == 0)) {
    return lhs_;
  }
  if ((delay_control_ != nullptr) && (delay_control_->VpiName().compare(name) == 0)) {
    return delay_control_;
  }
  if ((event_control_ != nullptr) && (event_control_->VpiName().compare(name) == 0)) {
    return event_control_;
  }
  if ((repeat_control_ != nullptr) && (repeat_control_->VpiName().compare(name) == 0)) {
    return repeat_control_;
  }
  return basetype_t::GetByVpiName(name);
}

std::tuple<const BaseClass*, UHDM_OBJECT_TYPE, const std::vector<const BaseClass*>*> assignment::GetByVpiType(int32_t type) const {
  switch (type) {
    case vpiDelayControl: return std::make_tuple(delay_control_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiEventControl: return std::make_tuple(event_control_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiLhs: return std::make_tuple(lhs_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRepeatControl: return std::make_tuple(repeat_control_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
    case vpiRhs: return std::make_tuple(rhs_, static_cast<UHDM_OBJECT_TYPE>(0), nullptr);
  }
  return basetype_t::GetByVpiType(type);
}

assignment::vpi_property_value_t assignment::GetVpiPropertyValue(int32_t property) const {
  switch (property) {
    case vpiBlocking: return vpi_property_value_t(VpiBlocking());
    case vpiOpType: return vpi_property_value_t(VpiOpType());
    case vpiType: return vpi_property_value_t(VpiType());
  }
  return basetype_t::GetVpiPropertyValue(property);
}

void assignment::DeepCopy(assignment* clone, BaseClass* parent, CloneContext* context) const {
  [[maybe_unused]] ElaboratorContext* const elaboratorContext = clonecontext_cast<ElaboratorContext*>(context);
  elaboratorContext->m_elaborator.enterAssignment(clone, nullptr);
  basetype_t::DeepCopy(clone, parent, context);
  if (auto obj = Rhs()) clone->Rhs(obj->DeepClone(clone, context));
  if (auto obj = Lhs()) clone->Lhs(obj->DeepClone(clone, context));
  if (auto obj = Delay_control()) clone->Delay_control(obj->DeepClone(clone, context));
  if (auto obj = Event_control()) clone->Event_control(obj->DeepClone(clone, context));
  if (auto obj = Repeat_control()) clone->Repeat_control(obj->DeepClone(clone, context));
  elaboratorContext->m_elaborator.leaveAssignment(clone, nullptr);
}

assignment* assignment::DeepClone(BaseClass* parent, CloneContext* context) const {
  assignment* const clone = context->m_serializer->MakeAssignment();
  const uint32_t id = clone->UhdmId();
  *clone = *this;
  clone->UhdmId(id);
  DeepCopy(clone, parent, context);
  return clone;
}

int32_t assignment::Compare(const BaseClass *other, CompareContext* context) const {
  int32_t r = 0;
  if (!context->m_visited.insert(this).second) return r;
  if ((r = basetype_t::Compare(other, context)) != 0) return r;

  const thistype_t *const lhs = this;
  const thistype_t *const rhs = (const thistype_t *)other;

  if ((r = lhs->VpiOpType() - rhs->VpiOpType()) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = (lhs->VpiBlocking() == rhs->VpiBlocking()) ? 0 : (lhs->VpiBlocking() ? 1 : -1)) != 0) {
    context->m_failedLhs = lhs;
    context->m_failedRhs = rhs;
    return r;
  }
  if ((r = SafeCompare(lhs->Rhs(), rhs->Rhs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Lhs(), rhs->Lhs(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Delay_control(), rhs->Delay_control(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Event_control(), rhs->Event_control(), context)) != 0) return r;
  if ((r = SafeCompare(lhs->Repeat_control(), rhs->Repeat_control(), context)) != 0) return r;
  return r;
}

}  // namespace UHDM
